/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.jitsi.utils.logging2.ContextLogRecord;

public class JitsiLogFormatter
extends Formatter {
    private static final String PROGRAM_NAME_PROPERTY = ".programname";
    private static final String DISABLE_TIMESTAMP_PROPERTY = ".disableTimestamp";
    private static String lineSeparator = System.getProperty("line.separator");
    private static DecimalFormat twoDigFmt = new DecimalFormat("00");
    private static DecimalFormat threeDigFmt = new DecimalFormat("000");
    private static String programName;
    private static boolean timestampDisabled;

    public JitsiLogFormatter() {
        this.loadConfigProperties();
    }

    @Override
    public synchronized String format(LogRecord record) {
        String context;
        StringBuffer sb = new StringBuffer();
        if (programName != null) {
            sb.append(programName);
            sb.append(' ');
        }
        if (!timestampDisabled) {
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            int hour = cal.get(11);
            int minutes = cal.get(12);
            int seconds = cal.get(13);
            int millis = cal.get(14);
            sb.append(year).append('-');
            sb.append(twoDigFmt.format(month)).append('-');
            sb.append(twoDigFmt.format(day)).append(' ');
            sb.append(twoDigFmt.format(hour)).append(':');
            sb.append(twoDigFmt.format(minutes)).append(':');
            sb.append(twoDigFmt.format(seconds)).append('.');
            sb.append(threeDigFmt.format(millis)).append(' ');
        }
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append("[").append(record.getThreadID()).append("] ");
        if (record instanceof ContextLogRecord && !(context = ((ContextLogRecord)record).getContext()).isEmpty()) {
            sb.append(context).append(" ");
        }
        int lineNumber = this.inferCaller(record);
        sb.append(record.getSourceClassName());
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
            if (lineNumber != -1) {
                sb.append("#").append(lineNumber);
            }
        }
        sb.append(": ");
        sb.append(record.getMessage());
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private int inferCaller(LogRecord record) {
        StackTraceElement frame;
        String cname2;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int lineNumber = -1;
        for (ix = 0; ix < stack.length && !(cname2 = (frame = stack[ix]).getClassName()).equals("org.jitsi.utils.logging2.LoggerImpl") && !cname2.equals("org.jitsi.utils.logging.LoggerImpl"); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            lineNumber = stack[ix].getLineNumber();
            cname2 = frame.getClassName();
            String shortName = cname2.substring(cname2.lastIndexOf(".") + 1);
            if (!cname2.contains("org.jitsi.utils.logging")) {
                record.setSourceClassName(shortName);
                record.setSourceMethodName(frame.getMethodName());
                break;
            }
            ++ix;
        }
        return lineNumber;
    }

    private void loadConfigProperties() {
        JitsiLogFormatter.loadProgramNameProperty();
        JitsiLogFormatter.loadTimestampDisabledProperty();
    }

    private static void loadTimestampDisabledProperty() {
        LogManager manager = LogManager.getLogManager();
        String cname2 = JitsiLogFormatter.class.getName();
        timestampDisabled = Boolean.parseBoolean(manager.getProperty(cname2 + DISABLE_TIMESTAMP_PROPERTY));
    }

    private static void loadProgramNameProperty() {
        LogManager manager = LogManager.getLogManager();
        String cname2 = JitsiLogFormatter.class.getName();
        programName = manager.getProperty(cname2 + PROGRAM_NAME_PROPERTY);
    }

    static {
        timestampDisabled = false;
    }
}

