/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.videobridge.relay.AudioSourceDesc;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B/\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0018\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/videobridge/SourceDesc;", "", "s", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "(Lorg/jitsi/videobridge/relay/AudioSourceDesc;)V", "Lorg/jitsi/nlj/MediaSourceDesc;", "(Lorg/jitsi/nlj/MediaSourceDesc;)V", "name", "", "owner", "videoType", "Lorg/jitsi/nlj/VideoType;", "ssrc1", "", "ssrc2", "(Ljava/lang/String;Ljava/lang/String;Lorg/jitsi/nlj/VideoType;JJ)V", "getName", "()Ljava/lang/String;", "getOwner", "getSsrc1", "()J", "getSsrc2", "getVideoType", "()Lorg/jitsi/nlj/VideoType;", "toString", "Companion", "jitsi-videobridge"})
public final class SourceDesc {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String owner;
    @NotNull
    private final VideoType videoType;
    private final long ssrc1;
    private final long ssrc2;

    private SourceDesc(String name, String owner, VideoType videoType, long ssrc1, long ssrc2) {
        this.name = name;
        this.owner = owner;
        this.videoType = videoType;
        this.ssrc1 = ssrc1;
        this.ssrc2 = ssrc2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    @NotNull
    public final VideoType getVideoType() {
        return this.videoType;
    }

    public final long getSsrc1() {
        return this.ssrc1;
    }

    public final long getSsrc2() {
        return this.ssrc2;
    }

    public SourceDesc(@NotNull AudioSourceDesc s2) {
        String string;
        Intrinsics.checkNotNullParameter(s2, "s");
        String string2 = s2.getSourceName();
        if (string2 == null) {
            string2 = "anon";
        }
        if ((string = s2.getOwner()) == null) {
            string = "unknown";
        }
        this(string2, string, VideoType.DISABLED, s2.getSsrc(), -1L);
    }

    public SourceDesc(@NotNull MediaSourceDesc s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        this(s2.getSourceName(), s2.getOwner(), s2.getVideoType(), s2.getPrimarySSRC(), Companion.getRtx(s2));
    }

    @NotNull
    public String toString() {
        return this.owner + ":" + this.ssrc1 + "/" + this.ssrc2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/videobridge/SourceDesc$Companion;", "", "()V", "getRtx", "", "s", "Lorg/jitsi/nlj/MediaSourceDesc;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public final long getRtx(@NotNull MediaSourceDesc s2) {
            Intrinsics.checkNotNullParameter(s2, "s");
            return s2.getRtpEncodings().length == 0 ? -1L : s2.getRtpEncodings()[0].getSecondarySsrc(SsrcAssociationType.RTX);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

