/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.parts.Resourcepart;

public class Bookmarks
implements PrivateData {
    public static final String NAMESPACE = "storage:bookmarks";
    public static final String ELEMENT = "storage";
    private final List<BookmarkedURL> bookmarkedURLS = new ArrayList<BookmarkedURL>();
    private final List<BookmarkedConference> bookmarkedConferences = new ArrayList<BookmarkedConference>();

    public void addBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.add(bookmarkedURL);
    }

    public void removeBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.remove(bookmarkedURL);
    }

    public void clearBookmarkedURLS() {
        this.bookmarkedURLS.clear();
    }

    public void addBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.add(bookmarkedConference);
    }

    public void removeBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.remove(bookmarkedConference);
    }

    public void clearBookmarkedConferences() {
        this.bookmarkedConferences.clear();
    }

    public List<BookmarkedURL> getBookmarkedURLS() {
        return this.bookmarkedURLS;
    }

    public List<BookmarkedConference> getBookmarkedConferences() {
        return this.bookmarkedConferences;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public XmlStringBuilder toXML() {
        XmlStringBuilder buf = new XmlStringBuilder();
        buf.halfOpenElement(ELEMENT).xmlnsAttribute(NAMESPACE).rightAngleBracket();
        for (BookmarkedURL urlStorage : this.getBookmarkedURLS()) {
            if (urlStorage.isShared()) continue;
            buf.halfOpenElement("url").attribute("name", urlStorage.getName()).attribute("url", urlStorage.getURL());
            buf.condAttribute(urlStorage.isRss(), "rss", "true");
            buf.closeEmptyElement();
        }
        for (BookmarkedConference conference : this.getBookmarkedConferences()) {
            if (conference.isShared()) continue;
            buf.halfOpenElement("conference");
            buf.attribute("name", conference.getName());
            buf.attribute("autojoin", Boolean.toString(conference.isAutoJoin()));
            buf.attribute("jid", conference.getJid());
            buf.rightAngleBracket();
            buf.optElement("nick", conference.getNickname());
            buf.optElement("password", conference.getPassword());
            buf.closeElement("conference");
        }
        buf.closeElement(ELEMENT);
        return buf;
    }

    private static BookmarkedURL getURLStorage(XmlPullParser parser2) throws IOException, XmlPullParserException {
        String name = parser2.getAttributeValue("", "name");
        String url = parser2.getAttributeValue("", "url");
        String rssString = parser2.getAttributeValue("", "rss");
        boolean rss = rssString != null && "true".equals(rssString);
        BookmarkedURL urlStore = new BookmarkedURL(url, name, rss);
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT && "shared_bookmark".equals(parser2.getName())) {
                urlStore.setShared(true);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !"url".equals(parser2.getName())) continue;
            done = true;
        }
        return urlStore;
    }

    private static BookmarkedConference getConferenceStorage(XmlPullParser parser2) throws XmlPullParserException, IOException {
        String name = parser2.getAttributeValue("", "name");
        boolean autojoin = ParserUtils.getBooleanAttribute(parser2, "autojoin", false);
        EntityBareJid jid = ParserUtils.getBareJidAttribute(parser2);
        BookmarkedConference conf = new BookmarkedConference(jid);
        conf.setName(name);
        conf.setAutoJoin(autojoin);
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT && "nick".equals(parser2.getName())) {
                String nickString = parser2.nextText();
                conf.setNickname(Resourcepart.from(nickString));
                continue;
            }
            if (eventType == XmlPullParser.Event.START_ELEMENT && "password".equals(parser2.getName())) {
                conf.setPassword(parser2.nextText());
                continue;
            }
            if (eventType == XmlPullParser.Event.START_ELEMENT && "shared_bookmark".equals(parser2.getName())) {
                conf.setShared(true);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !"conference".equals(parser2.getName())) continue;
            done = true;
        }
        return conf;
    }

    public static class Provider
    implements PrivateDataProvider {
        @Override
        public PrivateData parsePrivateData(XmlPullParser parser2) throws XmlPullParserException, IOException {
            Bookmarks storage2 = new Bookmarks();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser2.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "url".equals(parser2.getName())) {
                    BookmarkedURL urlStorage = Bookmarks.getURLStorage(parser2);
                    if (urlStorage == null) continue;
                    storage2.addBookmarkedURL(urlStorage);
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "conference".equals(parser2.getName())) {
                    BookmarkedConference conference = Bookmarks.getConferenceStorage(parser2);
                    storage2.addBookmarkedConference(conference);
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !Bookmarks.ELEMENT.equals(parser2.getName())) continue;
                done = true;
            }
            return storage2;
        }
    }
}

