/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.bytestreams.BytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jxmpp.jid.Jid;

public class InBandBytestreamSession
implements BytestreamSession {
    private static final Logger LOGGER = Logger.getLogger(InBandBytestreamSession.class.getName());
    static final String UNEXPECTED_IBB_SEQUENCE = "Unexpected IBB sequence";
    private final XMPPConnection connection;
    private final Open byteStreamRequest;
    private IBBInputStream inputStream;
    private IBBOutputStream outputStream;
    private Jid remoteJID;
    private boolean closeBothStreamsEnabled = false;
    private boolean isClosed = false;

    protected InBandBytestreamSession(XMPPConnection connection, Open byteStreamRequest, Jid remoteJID) {
        this.connection = connection;
        this.byteStreamRequest = byteStreamRequest;
        this.remoteJID = remoteJID;
        switch (byteStreamRequest.getStanza()) {
            case IQ: {
                this.inputStream = new IQIBBInputStream();
                this.outputStream = new IQIBBOutputStream();
                break;
            }
            case MESSAGE: {
                this.inputStream = new MessageIBBInputStream();
                this.outputStream = new MessageIBBOutputStream();
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public int getReadTimeout() {
        return this.inputStream.readTimeout;
    }

    @Override
    public void setReadTimeout(int timeout2) {
        if (timeout2 < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        this.inputStream.readTimeout = timeout2;
    }

    public boolean isCloseBothStreamsEnabled() {
        return this.closeBothStreamsEnabled;
    }

    public void setCloseBothStreamsEnabled(boolean closeBothStreamsEnabled) {
        this.closeBothStreamsEnabled = closeBothStreamsEnabled;
    }

    @Override
    public void close() throws IOException {
        this.closeByLocal(true);
        this.closeByLocal(false);
    }

    protected void closeByPeer(Close closeRequest) throws SmackException.NotConnectedException, InterruptedException {
        this.inputStream.closeInternal();
        this.inputStream.cleanup();
        this.outputStream.closeInternal(false);
        IQ confirmClose = IQ.createResultIQ(closeRequest);
        this.connection.sendStanza(confirmClose);
    }

    protected synchronized void closeByLocal(boolean in) throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.closeBothStreamsEnabled) {
            this.inputStream.closeInternal();
            this.outputStream.closeInternal(true);
        } else if (in) {
            this.inputStream.closeInternal();
        } else {
            this.outputStream.closeInternal(true);
        }
        if (this.inputStream.isClosed && this.outputStream.isClosed) {
            this.isClosed = true;
            Close close = new Close(this.byteStreamRequest.getSessionID());
            close.setTo(this.remoteJID);
            try {
                this.connection.createStanzaCollectorAndSend(close).nextResultOrThrow();
            }
            catch (Exception e) {
                IOException ioException = new IOException();
                ioException.initCause(e);
                throw ioException;
            }
            this.inputStream.cleanup();
            InBandBytestreamManager.getByteStreamManager(this.connection).getSessions().remove(this.byteStreamRequest.getSessionID());
        }
    }

    public void processIQPacket(Data data2) throws SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        this.inputStream.dataPacketListener.processStanza(data2);
    }

    private class MessageIBBOutputStream
    extends IBBOutputStream {
        private MessageIBBOutputStream() {
        }

        @Override
        protected synchronized void writeToXML(DataPacketExtension data2) throws SmackException.NotConnectedException, InterruptedException {
            Message message = ((MessageBuilder)((MessageBuilder)StanzaBuilder.buildMessage().to(InBandBytestreamSession.this.remoteJID)).addExtension(data2)).build();
            InBandBytestreamSession.this.connection.sendStanza(message);
        }
    }

    private class IQIBBOutputStream
    extends IBBOutputStream {
        private IQIBBOutputStream() {
        }

        @Override
        protected synchronized void writeToXML(DataPacketExtension data2) throws IOException {
            block2: {
                Data iq = new Data(data2);
                iq.setTo(InBandBytestreamSession.this.remoteJID);
                try {
                    InBandBytestreamSession.this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
                }
                catch (Exception e) {
                    if (this.isClosed) break block2;
                    InBandBytestreamSession.this.close();
                    IOException ioException = new IOException();
                    ioException.initCause(e);
                    throw ioException;
                }
            }
        }
    }

    private abstract class IBBOutputStream
    extends OutputStream {
        protected final byte[] buffer;
        protected int bufferPointer = 0;
        protected UInt16 seq = UInt16.from(0);
        protected boolean isClosed = false;

        private IBBOutputStream() {
            this.buffer = new byte[InBandBytestreamSession.this.byteStreamRequest.getBlockSize()];
        }

        protected abstract void writeToXML(DataPacketExtension var1) throws IOException, SmackException.NotConnectedException, InterruptedException;

        @Override
        public synchronized void write(int b) throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            if (this.bufferPointer >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.bufferPointer++] = (byte)b;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            if (len >= this.buffer.length) {
                this.writeOut(b, off, this.buffer.length);
                this.write(b, off + this.buffer.length, len - this.buffer.length);
            } else {
                this.writeOut(b, off, len);
            }
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        private synchronized void writeOut(byte[] b, int off, int len) throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            int available = 0;
            if (len > this.buffer.length - this.bufferPointer) {
                available = this.buffer.length - this.bufferPointer;
                System.arraycopy(b, off, this.buffer, this.bufferPointer, available);
                this.bufferPointer += available;
                this.flushBuffer();
            }
            System.arraycopy(b, off + available, this.buffer, this.bufferPointer, len - available);
            this.bufferPointer += len - available;
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            this.flushBuffer();
        }

        private synchronized void flushBuffer() throws IOException {
            if (this.bufferPointer == 0) {
                return;
            }
            String enc = Base64.encodeToString(this.buffer, 0, this.bufferPointer);
            DataPacketExtension data2 = new DataPacketExtension(InBandBytestreamSession.this.byteStreamRequest.getSessionID(), this.seq, enc);
            try {
                this.writeToXML(data2);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                IOException ioException = new IOException();
                ioException.initCause(e);
                throw ioException;
            }
            this.bufferPointer = 0;
            this.seq = this.seq.incrementedByOne();
        }

        @Override
        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            InBandBytestreamSession.this.closeByLocal(false);
        }

        protected void closeInternal(boolean flush) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            try {
                if (flush) {
                    this.flushBuffer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class IBBDataPacketFilter
    implements StanzaFilter {
        private IBBDataPacketFilter() {
        }

        @Override
        public boolean accept(Stanza packet) {
            DataPacketExtension data2;
            if (!packet.getFrom().equals(InBandBytestreamSession.this.remoteJID)) {
                return false;
            }
            if (packet instanceof Data) {
                data2 = ((Data)packet).getDataPacketExtension();
            } else {
                data2 = packet.getExtension(DataPacketExtension.class);
                if (data2 == null) {
                    return false;
                }
            }
            return data2.getSessionID().equals(InBandBytestreamSession.this.byteStreamRequest.getSessionID());
        }
    }

    private class MessageIBBInputStream
    extends IBBInputStream {
        private MessageIBBInputStream() {
        }

        @Override
        protected StanzaListener getDataPacketListener() {
            return new StanzaListener(){

                @Override
                public void processStanza(Stanza packet) {
                    DataPacketExtension data2 = packet.getExtension(DataPacketExtension.class);
                    if (data2.getDecodedData() == null) {
                        return;
                    }
                    MessageIBBInputStream.this.dataQueue.offer(data2);
                }
            };
        }

        @Override
        protected StanzaFilter getDataPacketFilter() {
            return new AndFilter(new StanzaTypeFilter(Message.class), new IBBDataPacketFilter());
        }
    }

    private class IQIBBInputStream
    extends IBBInputStream {
        private IQIBBInputStream() {
        }

        @Override
        protected StanzaListener getDataPacketListener() {
            return new StanzaListener(){
                private UInt16 expectedSequence = UInt16.MIN_VALUE;

                @Override
                public void processStanza(Stanza packet) throws SmackException.NotConnectedException, InterruptedException {
                    Data dataIq = (Data)packet;
                    DataPacketExtension data2 = dataIq.getDataPacketExtension();
                    UInt16 seq = data2.getSeq();
                    if (!this.expectedSequence.equals(seq)) {
                        String descriptiveEnTest = "Unexpected IBB sequence " + seq + " received, expected " + this.expectedSequence;
                        StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.unexpected_request).setDescriptiveEnText(descriptiveEnTest)).build();
                        ErrorIQ unexpectedRequest = IQ.createErrorResponse((IQ)dataIq, stanzaError);
                        InBandBytestreamSession.this.connection.sendStanza(unexpectedRequest);
                        try {
                            IQIBBInputStream.this.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.FINER, "Could not close session, because of IOException. Close reason: " + descriptiveEnTest);
                        }
                        return;
                    }
                    if (data2.getDecodedData() == null) {
                        ErrorIQ badRequest = IQ.createErrorResponse((IQ)packet, StanzaError.Condition.bad_request);
                        InBandBytestreamSession.this.connection.sendStanza(badRequest);
                        return;
                    }
                    this.expectedSequence = seq.incrementedByOne();
                    IQIBBInputStream.this.dataQueue.offer(data2);
                    IQ confirmData = IQ.createResultIQ((IQ)packet);
                    InBandBytestreamSession.this.connection.sendStanza(confirmData);
                }
            };
        }

        @Override
        protected StanzaFilter getDataPacketFilter() {
            return new AndFilter(new StanzaTypeFilter(Data.class), new IBBDataPacketFilter());
        }
    }

    private abstract class IBBInputStream
    extends InputStream {
        private final StanzaListener dataPacketListener;
        protected final BlockingQueue<DataPacketExtension> dataQueue = new LinkedBlockingQueue<DataPacketExtension>();
        private byte[] buffer;
        private int bufferPointer = -1;
        private UInt16 expectedSeq = UInt16.MIN_VALUE;
        private boolean isClosed = false;
        private boolean closeInvoked = false;
        private int readTimeout = 0;

        protected IBBInputStream() {
            this.dataPacketListener = this.getDataPacketListener();
            InBandBytestreamSession.this.connection.addSyncStanzaListener(this.dataPacketListener, this.getDataPacketFilter());
        }

        protected abstract StanzaListener getDataPacketListener();

        protected abstract StanzaFilter getDataPacketFilter();

        @Override
        public synchronized int read() throws IOException {
            this.checkClosed();
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBuffer())) {
                return -1;
            }
            return this.buffer[this.bufferPointer++] & 0xFF;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            this.checkClosed();
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBuffer())) {
                return -1;
            }
            int bytesAvailable = this.buffer.length - this.bufferPointer;
            if (len > bytesAvailable) {
                len = bytesAvailable;
            }
            System.arraycopy(this.buffer, this.bufferPointer, b, off, len);
            this.bufferPointer += len;
            return len;
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        private synchronized boolean loadBuffer() throws IOException {
            DataPacketExtension data2 = null;
            try {
                if (this.readTimeout == 0) {
                    while (data2 == null) {
                        if (this.isClosed && this.dataQueue.isEmpty()) {
                            return false;
                        }
                        data2 = this.dataQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    }
                } else {
                    data2 = this.dataQueue.poll(this.readTimeout, TimeUnit.MILLISECONDS);
                    if (data2 == null) {
                        throw new SocketTimeoutException();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            UInt16 dataSeq = data2.getSeq();
            if (!this.expectedSeq.equals(dataSeq)) {
                InBandBytestreamSession.this.close();
                String message = "Unexpected IBB sequence " + dataSeq + " received, expected " + this.expectedSeq;
                throw new IOException(message);
            }
            this.expectedSeq = dataSeq.incrementedByOne();
            this.buffer = data2.getDecodedData();
            this.bufferPointer = 0;
            return true;
        }

        private void checkClosed() throws IOException {
            if (this.closeInvoked) {
                this.dataQueue.clear();
                throw new IOException("Stream is closed");
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void close() throws IOException {
            if (this.closeInvoked) {
                return;
            }
            this.closeInvoked = true;
            InBandBytestreamSession.this.closeByLocal(true);
        }

        private void closeInternal() {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }

        private void cleanup() {
            InBandBytestreamSession.this.connection.removeSyncStanzaListener(this.dataPacketListener);
        }
    }
}

