/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.util.ByteArrays;

public final class Dot1qVlanTagPacket
extends AbstractPacket {
    private static final long serialVersionUID = 1522789079803339400L;
    private final Dot1qVlanTagHeader header;
    private final Packet payload;

    public static Dot1qVlanTagPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot1qVlanTagPacket(rawData, offset, length);
    }

    private Dot1qVlanTagPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new Dot1qVlanTagHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawData, offset + this.header.length(), payloadLength, this.header.getType()) : null;
    }

    private Dot1qVlanTagPacket(Builder builder2) {
        if (builder2 == null || builder2.type == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.type: ").append(builder2.type);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder2.payloadBuilder != null ? builder2.payloadBuilder.build() : null;
        this.header = new Dot1qVlanTagHeader(builder2);
    }

    @Override
    public Dot1qVlanTagHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Dot1qVlanTagHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 7130569411806479522L;
        private static final int PRIORITY_AND_CFI_AND_VID_OFFSET = 0;
        private static final int PRIORITY_AND_CFI_AND_VID_SIZE = 2;
        private static final int TYPE_OFFSET = 2;
        private static final int TYPE_SIZE = 2;
        private static final int DOT1Q_TAG_HEADER_SIZE = 4;
        private final byte priority;
        private final boolean cfi;
        private final short vid;
        private final EtherType type;

        private Dot1qVlanTagHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The data is too short to build an IEEE802.1Q Tag header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            short priorityAndCfiAndVid = ByteArrays.getShort(rawData, 0 + offset);
            this.priority = (byte)((priorityAndCfiAndVid & 0xE000) >> 13);
            this.cfi = (priorityAndCfiAndVid & 0x1000) >> 12 == 1;
            this.vid = (short)(priorityAndCfiAndVid & 0xFFF);
            this.type = EtherType.getInstance(ByteArrays.getShort(rawData, 2 + offset));
        }

        private Dot1qVlanTagHeader(Builder builder2) {
            if ((builder2.priority & 0xF8) != 0) {
                throw new IllegalArgumentException("invalid priority: " + builder2.priority);
            }
            if ((builder2.vid & 0xF000) != 0) {
                throw new IllegalArgumentException("invalid vid: " + builder2.vid);
            }
            this.priority = builder2.priority;
            this.cfi = builder2.cfi;
            this.vid = builder2.vid;
            this.type = builder2.type;
        }

        public byte getPriority() {
            return this.priority;
        }

        public boolean getCfi() {
            return this.cfi;
        }

        public short getVid() {
            return this.vid;
        }

        public int getVidAsInt() {
            return 0xFFF & this.vid;
        }

        public EtherType getType() {
            return this.type;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((short)(this.priority << 13 | (this.cfi ? 1 : 0) << 12 | this.vid)));
            rawFields.add(ByteArrays.toByteArray((Short)this.type.value()));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[IEEE802.1Q Tag header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Priority: ").append(this.priority).append(ls);
            sb.append("  CFI: ").append(this.cfi ? 1 : 0).append(ls);
            sb.append("  VID: ").append(this.getVidAsInt()).append(ls);
            sb.append("  Type: ").append(this.type).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            Dot1qVlanTagHeader other = (Dot1qVlanTagHeader)obj;
            return this.vid == other.vid && this.type.equals(other.type) && this.priority == other.priority && this.cfi == other.cfi;
        }

        @Override
        protected int calcHashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.priority;
            result2 = 31 * result2 + (this.cfi ? 1231 : 1237);
            result2 = 31 * result2 + this.vid;
            result2 = 31 * result2 + this.type.hashCode();
            return result2;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private byte priority;
        private boolean cfi;
        private short vid;
        private EtherType type;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(Dot1qVlanTagPacket packet) {
            this.priority = packet.header.priority;
            this.cfi = packet.header.cfi;
            this.vid = packet.header.vid;
            this.type = packet.header.type;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder priority(byte priority) {
            this.priority = priority;
            return this;
        }

        public Builder cfi(boolean cfi) {
            this.cfi = cfi;
            return this;
        }

        public Builder vid(short vid) {
            this.vid = vid;
            return this;
        }

        public Builder type(EtherType type2) {
            this.type = type2;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public Dot1qVlanTagPacket build() {
            return new Dot1qVlanTagPacket(this);
        }
    }
}

