/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.ObjectStreamException;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class TcpNoOperationOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = -3555140079365778548L;
    private static final TcpNoOperationOption INSTANCE = new TcpNoOperationOption();
    private static final TcpOptionKind kind = TcpOptionKind.NO_OPERATION;

    private TcpNoOperationOption() {
    }

    public static TcpNoOperationOption getInstance() {
        return INSTANCE;
    }

    public static TcpNoOperationOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        if (rawData[offset] != (Byte)kind.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The kind must be: ").append(kind.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        return INSTANCE;
    }

    @Override
    public TcpOptionKind getKind() {
        return kind;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        return new byte[]{1};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(kind);
        sb.append("]");
        return sb.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

