/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.core.Inets;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class ProtocolFamily
extends NamedNumber<Integer, ProtocolFamily> {
    private static final long serialVersionUID = 2803732603678906217L;
    public static final ProtocolFamily PF_UNSPEC = new ProtocolFamily(0, "PF_UNSPEC");
    public static final ProtocolFamily PF_INET = new ProtocolFamily(0xFFFF & Inets.AF_INET, "PF_INET");
    public static final ProtocolFamily PF_LINK = new ProtocolFamily(0xFFFF & Inets.AF_LINK, "PF_LINK");
    public static final ProtocolFamily PF_INET6 = new ProtocolFamily(0xFFFF & Inets.AF_INET6, "PF_INET6");
    private static final Map<Integer, ProtocolFamily> registry = new HashMap<Integer, ProtocolFamily>(10);

    public ProtocolFamily(Integer value2, String name) {
        super(value2, name);
    }

    public static ProtocolFamily getInstance(Integer value2) {
        if (registry.containsKey(value2)) {
            return registry.get(value2);
        }
        return new ProtocolFamily(value2, "unknown");
    }

    public static ProtocolFamily register(ProtocolFamily type2) {
        return registry.put((Integer)type2.value(), type2);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Integer)this.value() & 0xFFFF);
    }

    @Override
    public int compareTo(ProtocolFamily o) {
        return ((Integer)this.value()).compareTo((Integer)o.value());
    }

    static {
        registry.put((Integer)PF_UNSPEC.value(), PF_UNSPEC);
        registry.put((Integer)PF_INET.value(), PF_INET);
        registry.put((Integer)PF_LINK.value(), PF_LINK);
        registry.put((Integer)PF_INET6.value(), PF_INET6);
    }
}

