/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class ArchiveRootBuildItem
extends SimpleBuildItem {
    private final Path archiveRoot;
    private final Collection<Path> excludedFromIndexing;
    private final PathCollection rootDirs;
    private final PathCollection paths;

    public static Builder builder() {
        return new Builder();
    }

    public ArchiveRootBuildItem(Path appClassesDir) {
        this(appClassesDir, appClassesDir);
    }

    @Deprecated
    public ArchiveRootBuildItem(Path archiveLocation, Path archiveRoot) {
        this(archiveLocation, archiveRoot, Collections.emptySet());
    }

    private ArchiveRootBuildItem(Path archiveLocation, Path archiveRoot, Collection<Path> excludedFromIndexing) {
        if (!Files.isDirectory(archiveRoot, new LinkOption[0])) {
            throw new IllegalArgumentException(archiveRoot + " does not point to the application output directory");
        }
        this.rootDirs = PathList.of((Path[])new Path[]{archiveRoot});
        this.paths = PathList.of((Path[])new Path[]{archiveLocation});
        this.archiveRoot = archiveRoot;
        this.excludedFromIndexing = excludedFromIndexing;
    }

    private ArchiveRootBuildItem(Builder builder, QuarkusBuildCloseablesBuildItem buildCloseables) throws IOException {
        this.excludedFromIndexing = builder.excludedFromIndexing;
        if (!builder.archiveRoots.isEmpty()) {
            PathList.Builder rootDirs = PathList.builder();
            PathList.Builder paths = PathList.builder();
            for (Path root : builder.archiveRoots) {
                paths.add(root);
                if (Files.isDirectory(root, new LinkOption[0])) {
                    rootDirs.add(root);
                    continue;
                }
                FileSystem fs = buildCloseables.add(ZipUtils.newFileSystem((Path)root));
                fs.getRootDirectories().forEach(arg_0 -> ((PathList.Builder)rootDirs).add(arg_0));
            }
            this.rootDirs = rootDirs.build();
            this.paths = paths.build();
            this.archiveRoot = (Path)this.rootDirs.iterator().next();
        } else {
            this.paths = this.rootDirs = PathsCollection.of((Path[])new Path[0]);
            this.archiveRoot = null;
        }
    }

    @Deprecated
    public Path getArchiveLocation() {
        Iterator i = this.paths.iterator();
        Path last = (Path)i.next();
        while (i.hasNext()) {
            last = (Path)i.next();
        }
        return last;
    }

    @Deprecated
    public Path getArchiveRoot() {
        return this.archiveRoot;
    }

    @Deprecated
    public PathsCollection getRootDirs() {
        return PathsCollection.from((Iterable)this.rootDirs);
    }

    public PathCollection getRootDirectories() {
        return this.rootDirs;
    }

    @Deprecated
    public PathsCollection getPaths() {
        return PathsCollection.from((Iterable)this.paths);
    }

    public PathCollection getResolvedPaths() {
        return this.paths;
    }

    public boolean isExcludedFromIndexing(Path p) {
        return this.excludedFromIndexing.contains(p);
    }

    public static class Builder {
        private List<Path> archiveRoots = new ArrayList<Path>();
        private Collection<Path> excludedFromIndexing;

        private Builder() {
        }

        public Builder addArchiveRoot(Path root) {
            this.archiveRoots.add(root);
            return this;
        }

        public Builder addArchiveRoots(PathCollection paths) {
            paths.forEach(this.archiveRoots::add);
            return this;
        }

        public Builder setExcludedFromIndexing(Collection<Path> excludedFromIndexing) {
            this.excludedFromIndexing = excludedFromIndexing;
            return this;
        }

        @Deprecated
        public Builder setArchiveLocation(Path archiveLocation) {
            this.archiveRoots.clear();
            this.archiveRoots.add(archiveLocation);
            return this;
        }

        public ArchiveRootBuildItem build(QuarkusBuildCloseablesBuildItem buildCloseables) throws IOException {
            return new ArchiveRootBuildItem(this, buildCloseables);
        }
    }
}

