/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor.jvm;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.MarkChangeSetRanStatement;
import liquibase.util.SqlUtil;

public class ChangelogJdbcMdcListener {
    public static void execute(SqlStatement statement, Database database, ExecuteJdbc jdbcQuery) throws DatabaseException {
        if (!(statement instanceof MarkChangeSetRanStatement)) {
            ChangelogJdbcMdcListener.addSqlMdc(statement, database);
        }
        try {
            jdbcQuery.execute(Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database));
            ChangelogJdbcMdcListener.logSuccess();
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().addMdcValue("databaseChangelogTableOutcome", "failed");
            throw new DatabaseException(e);
        }
    }

    public static <T> T query(SqlStatement statement, Database database, QueryJdbc<T> jdbcQuery) throws DatabaseException {
        ChangelogJdbcMdcListener.addSqlMdc(statement, database);
        try {
            T value = jdbcQuery.execute(Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database));
            ChangelogJdbcMdcListener.logSuccess();
            return value;
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().addMdcValue("databaseChangelogTableOutcome", "failed");
            throw new DatabaseException(e);
        }
    }

    private static void addSqlMdc(SqlStatement statement, Database database) {
        Scope.getCurrentScope().addMdcValue("databaseChangelogSQL", SqlUtil.getSqlString(statement, SqlGeneratorFactory.getInstance(), database));
    }

    private static void logSuccess() {
        Scope.getCurrentScope().addMdcValue("databaseChangelogTableOutcome", "executed");
        Scope.getCurrentScope().getLog(ChangelogJdbcMdcListener.class).info("Changelog query completed.");
        Scope.getCurrentScope().getMdcManager().remove("databaseChangelogTableOutcome");
        Scope.getCurrentScope().getMdcManager().remove("databaseChangelogSQL");
    }

    public static interface ExecuteJdbc {
        public void execute(Executor var1) throws DatabaseException;
    }

    public static interface QueryJdbc<T> {
        public T execute(Executor var1) throws DatabaseException;
    }
}

