/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderConfiguration;
import biz.paluch.logging.gelf.intern.GelfSenderProvider;
import biz.paluch.logging.gelf.intern.sender.GelfREDISSender;
import biz.paluch.logging.gelf.intern.sender.RedisPoolHolder;
import java.io.IOException;
import java.net.URI;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

public class RedisGelfSenderProvider
implements GelfSenderProvider {
    @Override
    public boolean supports(String host) {
        return host.startsWith("redis:") || host.startsWith("redis-sentinel:");
    }

    @Override
    public GelfSender create(GelfSenderConfiguration configuration) throws IOException {
        String graylogHost = configuration.getHost();
        URI hostUri = URI.create(graylogHost);
        int port = hostUri.getPort();
        if (port <= 0) {
            port = configuration.getPort();
        }
        if (port <= 0) {
            port = 6379;
        }
        if (hostUri.getFragment() == null || hostUri.getFragment().trim().equals("")) {
            throw new IllegalArgumentException("Redis URI must specify fragment");
        }
        if (hostUri.getHost() == null) {
            throw new IllegalArgumentException("Redis URI must specify host");
        }
        Pool<Jedis> pool = RedisPoolHolder.getInstance().getJedisPool(hostUri, port);
        return new GelfREDISSender(pool, hostUri.getFragment(), configuration.getErrorReporter());
    }
}

