/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.log4j2;

import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.GelfUtil;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.Values;
import biz.paluch.logging.gelf.log4j2.PatternLogMessageField;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

class Log4j2LogEvent
implements LogEvent {
    private org.apache.logging.log4j.core.LogEvent logEvent;

    public Log4j2LogEvent(org.apache.logging.log4j.core.LogEvent logEvent) {
        this.logEvent = logEvent;
    }

    @Override
    public String getMessage() {
        return this.logEvent.getMessage().getFormattedMessage();
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public Throwable getThrowable() {
        return this.logEvent.getThrown();
    }

    @Override
    public long getLogTimestamp() {
        return this.logEvent.getTimeMillis();
    }

    @Override
    public String getSyslogLevel() {
        return "" + this.levelToSyslogLevel(this.logEvent.getLevel());
    }

    private int levelToSyslogLevel(Level level) {
        switch (level.getStandardLevel()) {
            case FATAL: {
                return 2;
            }
            case ERROR: {
                return 3;
            }
            case WARN: {
                return 4;
            }
            case INFO: {
                return 6;
            }
        }
        return 7;
    }

    @Override
    public Values getValues(MessageField field) {
        if (field instanceof MdcMessageField) {
            return new Values(field.getName(), this.getValue((MdcMessageField)field));
        }
        if (field instanceof PatternLogMessageField) {
            return new Values(field.getName(), this.getValue((PatternLogMessageField)field));
        }
        if (field instanceof LogMessageField) {
            return new Values(field.getName(), this.getValues((LogMessageField)field));
        }
        if (field instanceof DynamicMdcMessageField) {
            return this.getMdcValues((DynamicMdcMessageField)field);
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    public String getValues(LogMessageField field) {
        switch (field.getNamedLogField()) {
            case Severity: {
                return this.logEvent.getLevel().toString();
            }
            case ThreadName: {
                return this.logEvent.getThreadName();
            }
            case SourceClassName: {
                return this.getSourceClassName();
            }
            case SourceLineNumber: {
                return this.getSourceLineNumber();
            }
            case SourceMethodName: {
                return this.getSourceMethodName();
            }
            case SourceSimpleClassName: {
                String sourceClassName = this.getSourceClassName();
                if (sourceClassName == null) {
                    return null;
                }
                return GelfUtil.getSimpleClassName(sourceClassName);
            }
            case LoggerName: {
                return this.logEvent.getLoggerName();
            }
            case Marker: {
                if (this.logEvent.getMarker() != null && !"".equals(this.logEvent.getMarker().toString())) {
                    return this.logEvent.getMarker().toString();
                }
                return null;
            }
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    private String getSourceMethodName() {
        if (this.logEvent.getSource() == null) {
            return null;
        }
        return this.logEvent.getSource().getMethodName();
    }

    private String getSourceLineNumber() {
        if (this.logEvent.getSource() == null || this.logEvent.getSource().getLineNumber() <= 0) {
            return null;
        }
        return "" + this.logEvent.getSource().getLineNumber();
    }

    private String getSourceClassName() {
        if (this.logEvent.getSource() == null) {
            return null;
        }
        return this.logEvent.getSource().getClassName();
    }

    private Values getMdcValues(DynamicMdcMessageField field) {
        Values result = new Values();
        Set<String> mdcNames = this.getAllMdcNames();
        Set<String> matchingMdcNames = GelfUtil.getMatchingMdcNames(field, mdcNames);
        for (String mdcName : matchingMdcNames) {
            String mdcValue = this.getMdcValue(mdcName);
            if (mdcValue == null) continue;
            result.setValue(mdcName, mdcValue);
        }
        return result;
    }

    private Set<String> getAllMdcNames() {
        HashSet<String> mdcNames = new HashSet<String>();
        mdcNames.addAll(this.logEvent.getContextData().toMap().keySet());
        return mdcNames;
    }

    public String getValue(PatternLogMessageField field) {
        return field.getPatternLayout().toSerializable(this.logEvent);
    }

    private String getValue(MdcMessageField field) {
        return this.getMdcValue(field.getMdcName());
    }

    @Override
    public String getMdcValue(String mdcName) {
        ReadOnlyStringMap contextData = this.logEvent.getContextData();
        if (null != contextData && contextData.containsKey(mdcName)) {
            Object value = contextData.getValue(mdcName);
            return value != null ? value.toString() : null;
        }
        return null;
    }

    @Override
    public Set<String> getMdcNames() {
        return this.getAllMdcNames();
    }
}

