/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.storage.SearchableModelField;

public abstract class JpaModelCriteriaBuilder<E, M, Self extends JpaModelCriteriaBuilder<E, M, Self>>
implements ModelCriteriaBuilder<M, Self> {
    private final Function<JpaPredicateFunction<E>, Self> instantiator;
    private JpaPredicateFunction<E> predicateFunc = null;
    private boolean isDistinct = false;

    public JpaModelCriteriaBuilder(Function<JpaPredicateFunction<E>, Self> instantiator) {
        this.instantiator = instantiator;
    }

    public JpaModelCriteriaBuilder(Function<JpaPredicateFunction<E>, Self> instantiator, JpaPredicateFunction<E> predicateFunc) {
        this.instantiator = instantiator;
        this.predicateFunc = predicateFunc;
    }

    public JpaModelCriteriaBuilder(Function<JpaPredicateFunction<E>, Self> instantiator, JpaPredicateFunction<E> predicateFunc, boolean isDistinct) {
        this.instantiator = instantiator;
        this.predicateFunc = predicateFunc;
        this.isDistinct = isDistinct;
    }

    protected void validateValue(Object[] value, SearchableModelField<? super M> field, ModelCriteriaBuilder.Operator op, Class<?> ... expectedTypes) {
        if (value == null || expectedTypes == null || value.length != expectedTypes.length) {
            throw new CriterionNotSupportedException(field, op, "Invalid argument: " + Arrays.toString(value));
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            if (expectedTypes[i].isInstance(value[i])) continue;
            throw new CriterionNotSupportedException(field, op, "Expected types: " + Arrays.toString(expectedTypes) + " but got: " + Arrays.toString(value));
        }
    }

    protected String convertToJson(Object input) {
        try {
            return JsonbType.MAPPER.writeValueAsString(input);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Unable to write value as String.", ex);
        }
    }

    @SafeVarargs
    public final Self and(Self ... builders) {
        return (Self)((JpaModelCriteriaBuilder)this.instantiator.apply((cb, query, root) -> cb.and((Predicate[])Stream.of(builders).map(b -> b.getPredicateFunc().apply(cb, query, root)).toArray(Predicate[]::new))));
    }

    @SafeVarargs
    public final Self or(Self ... builders) {
        return (Self)((JpaModelCriteriaBuilder)this.instantiator.apply((cb, query, root) -> cb.or((Predicate[])Stream.of(builders).map(b -> b.getPredicateFunc().apply(cb, query, root)).toArray(Predicate[]::new))));
    }

    public Self not(Self builder) {
        return (Self)((JpaModelCriteriaBuilder)this.instantiator.apply((cb, query, root) -> cb.not((Expression)builder.getPredicateFunc().apply(cb, query, root))));
    }

    public JpaPredicateFunction<E> getPredicateFunc() {
        return this.predicateFunc;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    protected Collection<?> getValuesForInOperator(Object[] values, SearchableModelField<?> modelField) {
        Collection<Object> collectionValues;
        if (values == null || values.length == 0) {
            throw new CriterionNotSupportedException(modelField, ModelCriteriaBuilder.Operator.IN);
        }
        if (values.length == 1) {
            if (values[0] instanceof Object[]) {
                collectionValues = Arrays.asList(values[0]);
            } else if (values[0] instanceof Collection) {
                collectionValues = (Collection)values[0];
            } else if (values[0] instanceof Stream) {
                try (Stream str = (Stream)values[0];){
                    collectionValues = str.collect(Collectors.toCollection(ArrayList::new));
                }
            } else {
                collectionValues = Collections.singleton(values[0]);
            }
        } else {
            collectionValues = new HashSet<Object>(Arrays.asList(values));
        }
        return collectionValues;
    }

    protected Set<UUID> getUuidsForInOperator(Object[] values, SearchableModelField<?> modelField) {
        return this.getValuesForInOperator(values, modelField).stream().map(val -> (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(Objects.toString(val, null))).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected Predicate hashExpression(CriteriaBuilder cb, Join<E, ?> join, String columnName, Object value) {
        return cb.equal((Expression)join.get(columnName), cb.function("kc_hash", Object.class, new Expression[]{cb.literal(value)}));
    }
}

