/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.ContextInternal;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.UserHolder;
import io.vertx.ext.web.impl.HeaderParser;
import io.vertx.ext.web.impl.HttpServerRequestWrapper;
import io.vertx.ext.web.impl.ParsableHeaderValue;
import io.vertx.ext.web.impl.ParsableHeaderValuesContainer;
import io.vertx.ext.web.impl.ParsableLanguageValue;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.RequestBodyImpl;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.RoutingContextImplBase;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.SparseArray;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Collectors;

public class RoutingContextImpl
extends RoutingContextImplBase {
    private static final AtomicIntegerFieldUpdater<RoutingContextImpl> HANDLER_SEQ = AtomicIntegerFieldUpdater.newUpdater(RoutingContextImpl.class, "handlerSeq");
    private final RouterImpl router;
    private final HttpServerRequest request;
    private final RequestBodyImpl body;
    private volatile int handlerSeq;
    private Map<String, Object> data;
    private Map<String, String> pathParams;
    private MultiMap queryParams;
    private SparseArray<Handler<Void>> headersEndHandlers;
    private SparseArray<Handler<Void>> bodyEndHandlers;
    private SparseArray<Handler<AsyncResult<Void>>> endHandlers;
    private Throwable failure;
    private int statusCode = -1;
    private String normalizedPath;
    private String acceptableContentType;
    private ParsableHeaderValuesContainer parsedHeaders;
    private List<FileUpload> fileUploads;
    private Session session;
    private User user;
    private volatile boolean isSessionAccessed = false;
    private volatile boolean endHandlerCalled = false;
    private static final String DEFAULT_404 = "<html><body><h1>Resource not found</h1></body></html>";

    public RoutingContextImpl(String mountPoint, RouterImpl router, HttpServerRequest request, Set<RouteImpl> routes) {
        super(mountPoint, routes, router);
        this.router = router;
        this.request = new HttpServerRequestWrapper(request, router.getAllowForward());
        this.body = new RequestBodyImpl(this);
        String path = request.path();
        if (path == null || path.length() == 0) {
            this.fail(400);
        } else if (path.charAt(0) != '/') {
            this.fail(404);
        }
    }

    private String ensureNotNull(String string) {
        return string == null ? "" : string;
    }

    private void fillParsedHeaders(HttpServerRequest request) {
        String accept = request.getHeader(HttpHeaders.ACCEPT);
        String acceptCharset = request.getHeader(HttpHeaders.ACCEPT_CHARSET);
        String acceptEncoding = request.getHeader(HttpHeaders.ACCEPT_ENCODING);
        String acceptLanguage = request.getHeader(HttpHeaders.ACCEPT_LANGUAGE);
        String contentType = this.ensureNotNull(request.getHeader(HttpHeaders.CONTENT_TYPE));
        this.parsedHeaders = new ParsableHeaderValuesContainer(HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(accept, ParsableMIMEValue::new)), HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(acceptCharset, ParsableHeaderValue::new)), HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(acceptEncoding, ParsableHeaderValue::new)), HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(acceptLanguage, ParsableLanguageValue::new)), new ParsableMIMEValue(contentType));
    }

    @Override
    public HttpServerRequest request() {
        return this.request;
    }

    @Override
    public HttpServerResponse response() {
        return this.request.response();
    }

    @Override
    public Throwable failure() {
        return this.failure;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public boolean failed() {
        return this.failure != null || this.statusCode != -1;
    }

    @Override
    public void next() {
        if (!this.iterateNext()) {
            this.checkHandleNoMatch();
        }
    }

    private void checkHandleNoMatch() {
        if (this.failed()) {
            this.unhandledFailure(this.statusCode, this.failure, this.router);
        } else {
            Handler<RoutingContext> handler = this.router.getErrorHandlerByStatusCode(this.matchFailure);
            this.statusCode = this.matchFailure;
            if (handler == null) {
                this.response().setStatusCode(this.matchFailure);
                if (this.request().method() != HttpMethod.HEAD && this.matchFailure == 404) {
                    this.response().putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8").end(DEFAULT_404);
                } else if (this.request().method() != HttpMethod.HEAD && this.matchFailure == 405) {
                    this.response().putHeader((CharSequence)HttpHeaderNames.ALLOW, (CharSequence)this.allowedMethods.stream().map(HttpMethod::name).collect(Collectors.joining(","))).end();
                } else {
                    this.response().end();
                }
            } else {
                handler.handle((Object)this);
            }
        }
    }

    @Override
    public void fail(int statusCode) {
        this.statusCode = statusCode;
        this.doFail();
    }

    @Override
    public void fail(Throwable t) {
        if (t instanceof HttpException) {
            this.fail(((HttpException)t).getStatusCode(), t);
        } else {
            this.fail(500, t);
        }
    }

    @Override
    public void fail(int statusCode, Throwable throwable) {
        this.statusCode = statusCode;
        Throwable throwable2 = this.failure = throwable == null ? new NullPointerException() : throwable;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RoutingContext failure (" + statusCode + ")"), this.failure);
        }
        this.doFail();
    }

    @Override
    public RoutingContext put(String key, Object obj) {
        this.getData().put(key, obj);
        return this;
    }

    @Override
    public Vertx vertx() {
        return this.router.vertx();
    }

    @Override
    public @Nullable RoutingContextInternal parent() {
        return null;
    }

    @Override
    public <T> T get(String key) {
        if (this.data == null) {
            return null;
        }
        return (T)this.getData().get(key);
    }

    @Override
    public <T> T get(String key, T defaultValue) {
        if (this.data == null) {
            return defaultValue;
        }
        Map<String, Object> data = this.getData();
        if (data.containsKey(key)) {
            return (T)data.get(key);
        }
        return defaultValue;
    }

    @Override
    public <T> T remove(String key) {
        if (this.data == null) {
            return null;
        }
        return (T)this.getData().remove(key);
    }

    @Override
    public Map<String, Object> data() {
        return this.getData();
    }

    @Override
    public String normalizedPath() {
        if (this.normalizedPath == null) {
            String path = this.request.path();
            this.normalizedPath = path == null ? "/" : HttpUtils.normalizePath((String)path);
        }
        return this.normalizedPath;
    }

    @Override
    @Deprecated
    public Cookie getCookie(String name) {
        return this.request.getCookie(name);
    }

    @Override
    @Deprecated
    public RoutingContext addCookie(Cookie cookie) {
        this.request.response().addCookie(cookie);
        return this;
    }

    @Override
    @Deprecated
    public Cookie removeCookie(String name, boolean invalidate) {
        return this.request.response().removeCookie(name, invalidate);
    }

    @Override
    @Deprecated
    public int cookieCount() {
        return this.request.cookieCount();
    }

    @Override
    @Deprecated
    public Map<String, Cookie> cookieMap() {
        return this.request.cookieMap();
    }

    @Override
    public RequestBody body() {
        return this.body;
    }

    @Override
    public void setBody(Buffer body) {
        this.body.setBuffer(body);
    }

    @Override
    public List<FileUpload> fileUploads() {
        if (this.fileUploads == null) {
            this.fileUploads = new ArrayList<FileUpload>();
        }
        return this.fileUploads;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
        UserHolder holder = (UserHolder)session.get("__vertx.userHolder");
        if (holder != null) {
            holder.refresh(this);
        }
    }

    @Override
    public Session session() {
        this.isSessionAccessed = true;
        return this.session;
    }

    @Override
    public boolean isSessionAccessed() {
        return this.isSessionAccessed;
    }

    @Override
    public User user() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public void clearUser() {
        this.user = null;
    }

    @Override
    public String getAcceptableContentType() {
        return this.acceptableContentType;
    }

    @Override
    public void setAcceptableContentType(String contentType) {
        this.acceptableContentType = contentType;
    }

    @Override
    public ParsableHeaderValuesContainer parsedHeaders() {
        if (this.parsedHeaders == null) {
            this.fillParsedHeaders(this.request);
        }
        return this.parsedHeaders;
    }

    @Override
    public int addHeadersEndHandler(Handler<Void> handler) {
        int seq = this.nextHandlerSeq();
        this.getHeadersEndHandlers().put(seq, handler);
        return seq;
    }

    @Override
    public boolean removeHeadersEndHandler(int handlerID) {
        return this.getHeadersEndHandlers().remove(handlerID) != null;
    }

    @Override
    public int addBodyEndHandler(Handler<Void> handler) {
        int seq = this.nextHandlerSeq();
        this.getBodyEndHandlers().put(seq, handler);
        return seq;
    }

    @Override
    public boolean removeBodyEndHandler(int handlerID) {
        return this.getBodyEndHandlers().remove(handlerID) != null;
    }

    @Override
    public int addEndHandler(Handler<AsyncResult<Void>> handler) {
        int seq = this.nextHandlerSeq();
        this.getEndHandlers().put(seq, handler);
        return seq;
    }

    @Override
    public boolean removeEndHandler(int handlerID) {
        return this.getEndHandlers().remove(handlerID) != null;
    }

    @Override
    public void reroute(HttpMethod method, String path) {
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("path must start with '/'");
        }
        ((HttpServerRequestWrapper)this.request).changeTo(method, path);
        this.normalizedPath = null;
        this.statusCode = -1;
        this.response().headers().clear();
        if (this.headersEndHandlers != null) {
            this.headersEndHandlers.clear();
        }
        if (this.bodyEndHandlers != null) {
            this.bodyEndHandlers.clear();
        }
        this.failure = null;
        this.restart();
    }

    @Override
    public Map<String, String> pathParams() {
        return this.getPathParams();
    }

    @Override
    public @Nullable String pathParam(String name) {
        return this.getPathParams().get(name);
    }

    @Override
    public MultiMap queryParams() {
        return this.getQueryParams(null);
    }

    @Override
    public MultiMap queryParams(Charset charset) {
        return this.getQueryParams(charset);
    }

    @Override
    public @Nullable List<String> queryParam(String query) {
        return this.queryParams().getAll(query);
    }

    private MultiMap getQueryParams(Charset charset) {
        block6: {
            if (charset != null || this.queryParams == null) {
                try {
                    if (charset == null) {
                        this.queryParams = MultiMap.caseInsensitiveMultiMap();
                        Map decodedParams = new QueryStringDecoder(this.request.uri()).parameters();
                        for (Map.Entry entry : decodedParams.entrySet()) {
                            this.queryParams.add((String)entry.getKey(), (Iterable)entry.getValue());
                        }
                        break block6;
                    }
                    MultiMap queryParams = MultiMap.caseInsensitiveMultiMap();
                    Map decodedParams = new QueryStringDecoder(this.request.uri(), charset).parameters();
                    for (Map.Entry entry : decodedParams.entrySet()) {
                        queryParams.add((String)entry.getKey(), (Iterable)entry.getValue());
                    }
                    return queryParams;
                }
                catch (IllegalArgumentException e) {
                    throw new HttpException(400, "Error while decoding query params", e);
                }
            }
        }
        return this.queryParams;
    }

    private Map<String, String> getPathParams() {
        if (this.pathParams == null) {
            this.pathParams = new HashMap<String, String>();
        }
        return this.pathParams;
    }

    private SparseArray<Handler<Void>> getHeadersEndHandlers() {
        if (this.headersEndHandlers == null) {
            this.headersEndHandlers = new SparseArray();
            this.response().headersEndHandler(v -> this.headersEndHandlers.forEachInReverseOrder(handler -> handler.handle(null)));
        }
        return this.headersEndHandlers;
    }

    private SparseArray<Handler<Void>> getBodyEndHandlers() {
        if (this.bodyEndHandlers == null) {
            this.bodyEndHandlers = new SparseArray();
            this.response().bodyEndHandler(v -> this.bodyEndHandlers.forEachInReverseOrder(handler -> handler.handle(null)));
        }
        return this.bodyEndHandlers;
    }

    private SparseArray<Handler<AsyncResult<Void>>> getEndHandlers() {
        if (this.endHandlers == null) {
            this.endHandlers = new SparseArray();
            ContextInternal ctx = (ContextInternal)this.vertx().getOrCreateContext();
            Handler endHandler = v -> {
                if (!this.endHandlerCalled) {
                    this.endHandlerCalled = true;
                    this.endHandlers.forEachInReverseOrder(handler -> handler.handle((Object)ctx.succeededFuture()));
                }
            };
            Handler exceptionHandler = cause -> {
                if (!this.endHandlerCalled) {
                    this.endHandlerCalled = true;
                    this.endHandlers.forEachInReverseOrder(handler -> handler.handle((Object)ctx.failedFuture(cause)));
                }
            };
            Handler closeHandler = cause -> {
                if (!this.endHandlerCalled) {
                    this.endHandlerCalled = true;
                    this.endHandlers.forEachInReverseOrder(handler -> handler.handle((Object)ctx.failedFuture("Connection closed")));
                }
            };
            this.response().endHandler(endHandler).exceptionHandler(exceptionHandler).closeHandler(closeHandler);
        }
        return this.endHandlers;
    }

    private void doFail() {
        this.iter = this.router.iterator();
        this.currentRoute = null;
        this.next();
    }

    private Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    private int nextHandlerSeq() {
        int seq = HANDLER_SEQ.incrementAndGet(this);
        if (seq == Integer.MAX_VALUE) {
            throw new IllegalStateException("Too many header/body end handlers!");
        }
        return seq;
    }
}

