/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import jakarta.persistence.GenerationType;
import jakarta.persistence.Index;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hibernate.AssertionFailure;
import org.hibernate.Internal;
import org.hibernate.boot.model.IdGeneratorStrategyInterpreter;
import org.hibernate.internal.util.collections.CollectionHelper;

public class IdentifierGeneratorDefinition
implements Serializable {
    private final String name;
    private final String strategy;
    private final Map<String, String> parameters;

    public IdentifierGeneratorDefinition(String name, String strategy, Map<String, String> parameters) {
        this.name = name;
        this.strategy = strategy;
        this.parameters = CollectionHelper.isEmpty(parameters) ? Collections.emptyMap() : Collections.unmodifiableMap(parameters);
    }

    public IdentifierGeneratorDefinition(String name, Map<String, String> parameters) {
        this(name, name, parameters);
    }

    public IdentifierGeneratorDefinition(String name) {
        this(name, name);
    }

    public IdentifierGeneratorDefinition(String name, String strategy) {
        this.name = name;
        this.strategy = strategy;
        this.parameters = Collections.emptyMap();
    }

    public String getStrategy() {
        return this.strategy;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Internal
    public static IdentifierGeneratorDefinition createImplicit(String name, final Class<?> idType, final String generatorName, IdGeneratorStrategyInterpreter generationInterpreter, GenerationType generationType) {
        String strategyName;
        if (generationType == null) {
            return IdentifierGeneratorDefinition.buildSequenceGeneratorDefinition(name, generationInterpreter);
        }
        switch (generationType) {
            case SEQUENCE: {
                return IdentifierGeneratorDefinition.buildSequenceGeneratorDefinition(name, generationInterpreter);
            }
            case TABLE: {
                return IdentifierGeneratorDefinition.buildTableGeneratorDefinition(name, generationInterpreter);
            }
            case IDENTITY: {
                strategyName = "identity";
                break;
            }
            case AUTO: {
                strategyName = generationInterpreter.determineGeneratorName(generationType, new IdGeneratorStrategyInterpreter.GeneratorNameDeterminationContext(){

                    @Override
                    public Class<?> getIdType() {
                        return idType;
                    }

                    @Override
                    public String getGeneratedValueGeneratorName() {
                        return generatorName;
                    }
                });
                break;
            }
            default: {
                throw new AssertionFailure("unknown generator type: " + generationType);
            }
        }
        return new IdentifierGeneratorDefinition(name, strategyName, Collections.singletonMap("GENERATOR_NAME", name));
    }

    private static IdentifierGeneratorDefinition buildTableGeneratorDefinition(final String name, IdGeneratorStrategyInterpreter generationInterpreter) {
        Builder builder = new Builder();
        generationInterpreter.interpretTableGenerator(new TableGenerator(){

            public String name() {
                return name;
            }

            public String table() {
                return "";
            }

            public int initialValue() {
                return 0;
            }

            public int allocationSize() {
                return 50;
            }

            public String catalog() {
                return "";
            }

            public String schema() {
                return "";
            }

            public String pkColumnName() {
                return "";
            }

            public String valueColumnName() {
                return "";
            }

            public String pkColumnValue() {
                return "";
            }

            public UniqueConstraint[] uniqueConstraints() {
                return new UniqueConstraint[0];
            }

            public Index[] indexes() {
                return new Index[0];
            }

            public Class<? extends Annotation> annotationType() {
                return TableGenerator.class;
            }
        }, builder);
        return builder.build();
    }

    private static IdentifierGeneratorDefinition buildSequenceGeneratorDefinition(final String name, IdGeneratorStrategyInterpreter generationInterpreter) {
        Builder builder = new Builder();
        generationInterpreter.interpretSequenceGenerator(new SequenceGenerator(){

            public String name() {
                return name;
            }

            public String sequenceName() {
                return "";
            }

            public String catalog() {
                return "";
            }

            public String schema() {
                return "";
            }

            public int initialValue() {
                return 1;
            }

            public int allocationSize() {
                return 50;
            }

            public Class<? extends Annotation> annotationType() {
                return SequenceGenerator.class;
            }
        }, builder);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifierGeneratorDefinition)) {
            return false;
        }
        IdentifierGeneratorDefinition that = (IdentifierGeneratorDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.strategy, that.strategy) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IdentifierGeneratorDefinition{name='" + this.name + "', strategy='" + this.strategy + "', parameters=" + this.parameters + "}";
    }

    public static class Builder {
        private String name;
        private String strategy;
        private Map<String, String> parameters;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public void addParam(String name, String value) {
            this.parameters().put(name, value);
        }

        private Map<String, String> parameters() {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>();
            }
            return this.parameters;
        }

        public void addParams(Map<String, String> parameters) {
            this.parameters().putAll(parameters);
        }

        public IdentifierGeneratorDefinition build() {
            return new IdentifierGeneratorDefinition(this.name, this.strategy, this.parameters);
        }
    }
}

