/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership.role;

import java.util.Collection;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ModelException;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapperConfig;

public class RoleMapperConfig
extends CommonLDAPGroupMapperConfig {
    public static final String ROLES_DN = "roles.dn";
    public static final String ROLE_NAME_LDAP_ATTRIBUTE = "role.name.ldap.attribute";
    public static final String ROLE_OBJECT_CLASSES = "role.object.classes";
    public static final String USE_REALM_ROLES_MAPPING = "use.realm.roles.mapping";
    public static final String CLIENT_ID = "client.id";
    public static final String ROLES_LDAP_FILTER = "roles.ldap.filter";
    public static final String LOAD_ROLES_BY_MEMBER_ATTRIBUTE = "LOAD_ROLES_BY_MEMBER_ATTRIBUTE";
    public static final String GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE = "GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE";
    public static final String LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY = "LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY";

    public RoleMapperConfig(ComponentModel mapperModel) {
        super(mapperModel);
    }

    public String getRolesDn() {
        String rolesDn = (String)this.mapperModel.getConfig().getFirst((Object)ROLES_DN);
        if (rolesDn == null) {
            throw new ModelException("Roles DN is null! Check your configuration");
        }
        return rolesDn;
    }

    @Override
    public String getLDAPGroupsDn() {
        return this.getRolesDn();
    }

    public String getRoleNameLdapAttribute() {
        String rolesRdnAttr = (String)this.mapperModel.getConfig().getFirst((Object)ROLE_NAME_LDAP_ATTRIBUTE);
        return rolesRdnAttr != null ? rolesRdnAttr : "cn";
    }

    @Override
    public String getLDAPGroupNameLdapAttribute() {
        return this.getRoleNameLdapAttribute();
    }

    public Collection<String> getRoleObjectClasses(LDAPStorageProvider ldapProvider) {
        String objectClasses = (String)this.mapperModel.getConfig().getFirst((Object)ROLE_OBJECT_CLASSES);
        if (objectClasses == null) {
            objectClasses = ldapProvider.getLdapIdentityStore().getConfig().isActiveDirectory() ? "group" : "groupOfNames";
        }
        return this.getConfigValues(objectClasses);
    }

    public String getCustomLdapFilter() {
        return (String)this.mapperModel.getConfig().getFirst((Object)ROLES_LDAP_FILTER);
    }

    public boolean isRealmRolesMapping() {
        String realmRolesMapping = (String)this.mapperModel.getConfig().getFirst((Object)USE_REALM_ROLES_MAPPING);
        return realmRolesMapping == null || Boolean.parseBoolean(realmRolesMapping);
    }

    public String getClientId() {
        return (String)this.mapperModel.getConfig().getFirst((Object)CLIENT_ID);
    }

    public String getUserRolesRetrieveStrategy() {
        String strategyString = (String)this.mapperModel.getConfig().getFirst((Object)"user.roles.retrieve.strategy");
        return strategyString != null ? strategyString : LOAD_ROLES_BY_MEMBER_ATTRIBUTE;
    }
}

