/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.parsetools;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.core.parsetools.RecordParser.class)
public class RecordParser
implements ReadStream<Buffer>,
Handler<Buffer>,
Consumer<Buffer> {
    public static final TypeArg<RecordParser> __TYPE_ARG = new TypeArg(obj -> new RecordParser((io.vertx.core.parsetools.RecordParser)obj), RecordParser::getDelegate);
    private final io.vertx.core.parsetools.RecordParser delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private Multi<Buffer> multi;

    public RecordParser(io.vertx.core.parsetools.RecordParser delegate) {
        this.delegate = delegate;
    }

    public RecordParser(Object delegate) {
        this.delegate = (io.vertx.core.parsetools.RecordParser)delegate;
    }

    RecordParser() {
        this.delegate = null;
    }

    public io.vertx.core.parsetools.RecordParser getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordParser that = (RecordParser)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    private void __setOutput(Handler<Buffer> output) {
        this.delegate.setOutput((Handler)new DelegatingHandler(output, event -> Buffer.newInstance(event)));
    }

    public void setOutput(Consumer<Buffer> output) {
        this.__setOutput((Handler<Buffer>)(output != null ? new DelegatingConsumerHandler(output) : null));
    }

    private static RecordParser __newDelimited(String delim, Handler<Buffer> output) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited((String)delim, (Handler)new DelegatingHandler(output, event -> Buffer.newInstance(event))));
        return ret;
    }

    public static RecordParser newDelimited(String delim, Consumer<Buffer> output) {
        return RecordParser.__newDelimited(delim, (Handler<Buffer>)(output != null ? new DelegatingConsumerHandler(output) : null));
    }

    public static RecordParser newDelimited(String delim, ReadStream<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited((String)delim, (io.vertx.core.streams.ReadStream)stream.getDelegate()));
        return ret;
    }

    public static RecordParser newDelimited(String delim, Flow.Publisher<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited((String)delim, (io.vertx.core.streams.ReadStream)ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume()));
        return ret;
    }

    public static RecordParser newDelimited(String delim) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited((String)delim));
        return ret;
    }

    public static RecordParser newDelimited(Buffer delim) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited((io.vertx.core.buffer.Buffer)delim.getDelegate()));
        return ret;
    }

    private static RecordParser __newDelimited(Buffer delim, Handler<Buffer> output) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited((io.vertx.core.buffer.Buffer)delim.getDelegate(), (Handler)new DelegatingHandler(output, event -> Buffer.newInstance(event))));
        return ret;
    }

    public static RecordParser newDelimited(Buffer delim, Consumer<Buffer> output) {
        return RecordParser.__newDelimited(delim, (Handler<Buffer>)(output != null ? new DelegatingConsumerHandler(output) : null));
    }

    public static RecordParser newDelimited(Buffer delim, ReadStream<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited((io.vertx.core.buffer.Buffer)delim.getDelegate(), (io.vertx.core.streams.ReadStream)stream.getDelegate()));
        return ret;
    }

    public static RecordParser newDelimited(Buffer delim, Flow.Publisher<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited((io.vertx.core.buffer.Buffer)delim.getDelegate(), (io.vertx.core.streams.ReadStream)ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume()));
        return ret;
    }

    public static RecordParser newFixed(int size) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed((int)size));
        return ret;
    }

    private static RecordParser __newFixed(int size, Handler<Buffer> output) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed((int)size, (Handler)new DelegatingHandler(output, event -> Buffer.newInstance(event))));
        return ret;
    }

    public static RecordParser newFixed(int size, Consumer<Buffer> output) {
        return RecordParser.__newFixed(size, (Handler<Buffer>)(output != null ? new DelegatingConsumerHandler(output) : null));
    }

    public static RecordParser newFixed(int size, ReadStream<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed((int)size, (io.vertx.core.streams.ReadStream)stream.getDelegate()));
        return ret;
    }

    public static RecordParser newFixed(int size, Flow.Publisher<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed((int)size, (io.vertx.core.streams.ReadStream)ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume()));
        return ret;
    }

    public void delimitedMode(String delim) {
        this.delegate.delimitedMode(delim);
    }

    public void delimitedMode(Buffer delim) {
        this.delegate.delimitedMode(delim.getDelegate());
    }

    public void fixedSizeMode(int size) {
        this.delegate.fixedSizeMode(size);
    }

    @Fluent
    public RecordParser maxRecordSize(int size) {
        this.delegate.maxRecordSize(size);
        return this;
    }

    public void handle(Buffer buffer) {
        this.delegate.handle(buffer.getDelegate());
    }

    @Fluent
    private RecordParser __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public RecordParser exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private RecordParser __handler(Handler<Buffer> handler) {
        this.delegate.handler((Handler)new DelegatingHandler(handler, event -> Buffer.newInstance(event)));
        return this;
    }

    public RecordParser handler(Consumer<Buffer> handler) {
        return this.__handler((Handler<Buffer>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    public RecordParser pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public RecordParser fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Fluent
    public RecordParser resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    private RecordParser __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public RecordParser endHandler(Runnable endHandler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> endHandler.run()));
    }

    @Override
    @CheckReturnValue
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    @Override
    public void accept(Buffer item) {
        this.handle(item);
    }

    public static RecordParser newInstance(io.vertx.core.parsetools.RecordParser arg) {
        return arg != null ? new RecordParser(arg) : null;
    }
}

