/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.jaxrs;

import jakarta.ws.rs.ApplicationPath;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.config.HostnameOptions;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.services.resources.DebugHostnameSettingsResource;
import org.keycloak.quarkus.runtime.services.resources.QuarkusWelcomeResource;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.WelcomeResource;

@ApplicationPath(value="/")
public class QuarkusKeycloakApplication
extends KeycloakApplication {
    private static boolean filterSingletons(Object o) {
        return !WelcomeResource.class.isInstance(o);
    }

    public KeycloakSessionFactory createSessionFactory() {
        QuarkusKeycloakSessionFactory instance = QuarkusKeycloakSessionFactory.getInstance();
        instance.init();
        return instance;
    }

    protected void loadConfig() {
    }

    public Set<Object> getSingletons() {
        Set<Object> singletons = super.getSingletons().stream().filter(QuarkusKeycloakApplication::filterSingletons).collect(Collectors.toSet());
        singletons.add(new QuarkusWelcomeResource());
        if (Configuration.getOptionalBooleanValue("--" + HostnameOptions.HOSTNAME_DEBUG.getKey()).orElse(Boolean.FALSE).booleanValue()) {
            singletons.add(new DebugHostnameSettingsResource());
        }
        return singletons;
    }
}

