/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.ContentTypeConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.util.logging.Log;

public class EncodingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<EncodingConfiguration> {
    private ContentTypeConfigurationBuilder keyContentTypeBuilder = new ContentTypeConfigurationBuilder(Element.KEY_DATA_TYPE, this);
    private ContentTypeConfigurationBuilder valueContentTypeBuilder = new ContentTypeConfigurationBuilder(Element.VALUE_DATA_TYPE, this);
    private final Attribute<MediaType> mediaType;
    private final AttributeSet attributes = EncodingConfiguration.attributeDefinitionSet();

    EncodingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.mediaType = this.attributes.attribute(EncodingConfiguration.MEDIA_TYPE);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public void validate() {
        MediaType globalMediaType = (MediaType)this.mediaType.get();
        if (globalMediaType != null) {
            MediaType keyType = this.keyContentTypeBuilder.mediaType();
            MediaType valueType = this.valueContentTypeBuilder.mediaType();
            if (keyType != null && !keyType.equals((Object)globalMediaType) || valueType != null && !valueType.equals((Object)globalMediaType)) {
                Log.CONFIG.ignoringSpecificMediaTypes();
            }
        }
        this.keyContentTypeBuilder.validate();
        this.valueContentTypeBuilder.validate();
    }

    public boolean isObjectStorage() {
        if (!this.mediaType.isNull()) {
            return MediaType.APPLICATION_OBJECT.match((MediaType)this.mediaType.get());
        }
        return this.keyContentTypeBuilder.isObjectStorage() && this.valueContentTypeBuilder.isObjectStorage();
    }

    public ContentTypeConfigurationBuilder key() {
        return this.keyContentTypeBuilder;
    }

    public ContentTypeConfigurationBuilder value() {
        return this.valueContentTypeBuilder;
    }

    public EncodingConfigurationBuilder mediaType(String keyValueMediaType) {
        this.mediaType.set((Object)MediaType.fromString((String)keyValueMediaType));
        return this;
    }

    public EncodingConfigurationBuilder mediaType(MediaType keyValueMediaType) {
        this.mediaType.set((Object)keyValueMediaType);
        return this;
    }

    public boolean isStorageBinary() {
        if (!this.mediaType.isNull()) {
            return ((MediaType)this.mediaType.get()).isBinary();
        }
        MediaType keyMediaType = this.keyContentTypeBuilder.mediaType();
        MediaType valueMediaType = this.valueContentTypeBuilder.mediaType();
        return keyMediaType != null && valueMediaType != null && keyMediaType.isBinary() && valueMediaType.isBinary();
    }

    public EncodingConfiguration create() {
        MediaType globalType = (MediaType)this.mediaType.get();
        ContentTypeConfiguration keyContentType = this.keyContentTypeBuilder.create(globalType);
        ContentTypeConfiguration valueContentType = this.valueContentTypeBuilder.create(globalType);
        return new EncodingConfiguration(this.attributes.protect(), keyContentType, valueContentType);
    }

    public Builder<?> read(EncodingConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.keyContentTypeBuilder = new ContentTypeConfigurationBuilder(Element.KEY_DATA_TYPE, this).read(template.keyDataType(), combine);
        this.valueContentTypeBuilder = new ContentTypeConfigurationBuilder(Element.VALUE_DATA_TYPE, this).read(template.valueDataType(), combine);
        return this;
    }

    public String toString() {
        return "EncodingConfigurationBuilder{keyContentTypeBuilder=" + this.keyContentTypeBuilder + ", valueContentTypeBuilder=" + this.valueContentTypeBuilder + ", attributes=" + this.attributes + "}";
    }
}

