"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.registerSampleDataRoutes = registerSampleDataRoutes;

var _path = _interopRequireDefault(require("path"));

var _constants = require("../utils/constants");

var _helpers = require("../sampleData/utils/helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function registerSampleDataRoutes(apiRouter, sampleDataService) {
  apiRouter.post('/create_sample_data/{type}', sampleDataService.createSampleData);
}

class SampleDataService {
  constructor(client) {
    _defineProperty(this, "client", void 0);

    _defineProperty(this, "createSampleData", async (context, request, opensearchDashboardsResponse) => {
      //@ts-ignore
      const type = request.params.type;

      try {
        let filePath = '';
        let indexName = '';

        switch (type) {
          case _constants.SAMPLE_TYPE.HTTP_RESPONSES:
            {
              filePath = _path.default.resolve(__dirname, '../sampleData/rawData/httpResponses.json.gz');
              indexName = 'sample-http-responses';
              break;
            }

          case _constants.SAMPLE_TYPE.ECOMMERCE:
            {
              filePath = _path.default.resolve(__dirname, '../sampleData/rawData/ecommerce.json.gz');
              indexName = 'sample-ecommerce';
              break;
            }

          case _constants.SAMPLE_TYPE.HOST_HEALTH:
            {
              filePath = _path.default.resolve(__dirname, '../sampleData/rawData/hostHealth.json.gz');
              indexName = 'sample-host-health';
              break;
            }
        }

        await (0, _helpers.loadSampleData)(filePath, indexName, this.client, request);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true
          }
        });
      } catch (err) {
        console.log('Anomaly detector - Unable to load the sample data', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });

    this.client = client;
  } // Get the zip file stored in server, unzip it, and bulk insert it


}

exports.default = SampleDataService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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