"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorRouter = void 0;

var _constants = require("./constants");

var _connector_service = require("../services/connector_service");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const connectorRouter = router => {
  router.get({
    path: _constants.CONNECTOR_API_ENDPOINT,
    validate: {}
  }, router.handleLegacyErrors(async (context, _req, res) => {
    const payload = await _connector_service.ConnectorService.search({
      client: context.core.opensearch.client,
      from: 0,
      size: 10000
    });
    return res.ok({
      body: payload
    });
  }));
  router.get({
    path: _constants.INTERNAL_CONNECTOR_API_ENDPOINT,
    validate: {}
  }, router.handleLegacyErrors(async (context, _req, res) => {
    const data = await _connector_service.ConnectorService.getUniqueInternalConnectorNames({
      client: context.core.opensearch.client,
      size: 10000
    });
    return res.ok({
      body: {
        data
      }
    });
  }));
};

exports.connectorRouter = connectorRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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