/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.traccar.api.ExtendedObjectResource;
import org.traccar.handler.ComputedAttributesHandler;
import org.traccar.model.Attribute;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="attributes/computed")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AttributeResource
extends ExtendedObjectResource<Attribute> {
    @Inject
    private ComputedAttributesHandler computedAttributesHandler;

    public AttributeResource() {
        super(Attribute.class);
    }

    @POST
    @Path(value="test")
    public Response test(@QueryParam(value="deviceId") long deviceId, Attribute entity) throws StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        Position position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.LatestPositions(deviceId)));
        Object result = this.computedAttributesHandler.computeAttribute(entity, position);
        if (result != null) {
            switch (entity.getType()) {
                case "number": {
                    Number numberValue = (Number)result;
                    return Response.ok((Object)numberValue).build();
                }
                case "boolean": {
                    Boolean booleanValue = (Boolean)result;
                    return Response.ok((Object)booleanValue).build();
                }
            }
            return Response.ok((Object)result.toString()).build();
        }
        return Response.noContent().build();
    }

    @Override
    @POST
    public Response add(Attribute entity) throws StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        return super.add(entity);
    }

    @Override
    @Path(value="{id}")
    @PUT
    public Response update(Attribute entity) throws StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        return super.update(entity);
    }

    @Override
    @Path(value="{id}")
    @DELETE
    public Response remove(@PathParam(value="id") long id) throws StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        return super.remove(id);
    }
}

