/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.traccar.BaseProtocol;
import org.traccar.ServerManager;
import org.traccar.broadcast.BroadcastInterface;
import org.traccar.broadcast.BroadcastService;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.model.QueuedCommand;
import org.traccar.session.ConnectionManager;
import org.traccar.session.DeviceSession;
import org.traccar.sms.SmsManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

@Singleton
public class CommandsManager
implements BroadcastInterface {
    private final Storage storage;
    private final ServerManager serverManager;
    private final SmsManager smsManager;
    private final ConnectionManager connectionManager;
    private final BroadcastService broadcastService;

    @Inject
    public CommandsManager(Storage storage, ServerManager serverManager, @Nullable SmsManager smsManager, ConnectionManager connectionManager, BroadcastService broadcastService) {
        this.storage = storage;
        this.serverManager = serverManager;
        this.smsManager = smsManager;
        this.connectionManager = connectionManager;
        this.broadcastService = broadcastService;
        broadcastService.registerListener(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendCommand(Command command) throws Exception {
        long deviceId = command.getDeviceId();
        if (command.getTextChannel()) {
            if (this.smsManager == null) {
                throw new RuntimeException("SMS not configured");
            }
            Device device = this.storage.getObject(Device.class, new Request((Columns)new Columns.Include("positionId", "phone"), new Condition.Equals("id", deviceId)));
            Position position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", device.getPositionId())));
            if (position != null) {
                BaseProtocol protocol = this.serverManager.getProtocol(position.getProtocol());
                protocol.sendTextCommand(device.getPhone(), command);
                return true;
            } else {
                if (!command.getType().equals("custom")) throw new RuntimeException("Command " + command.getType() + " is not supported");
                this.smsManager.sendMessage(device.getPhone(), command.getString("data"), true);
            }
            return true;
        } else {
            DeviceSession deviceSession = this.connectionManager.getDeviceSession(deviceId);
            if (deviceSession != null && deviceSession.supportsLiveCommands()) {
                deviceSession.sendCommand(command);
                return true;
            } else {
                this.storage.addObject(QueuedCommand.fromCommand(command), new Request(new Columns.Exclude("id")));
                this.broadcastService.updateCommand(true, deviceId);
                return false;
            }
        }
    }

    public Collection<Command> readQueuedCommands(long deviceId) {
        return this.readQueuedCommands(deviceId, Integer.MAX_VALUE);
    }

    public Collection<Command> readQueuedCommands(long deviceId, int count) {
        try {
            List<QueuedCommand> commands = this.storage.getObjects(QueuedCommand.class, new Request(new Columns.All(), new Condition.Equals("deviceId", deviceId), new Order("id", false, count)));
            for (QueuedCommand command : commands) {
                this.storage.removeObject(QueuedCommand.class, new Request(new Condition.Equals("id", command.getId())));
            }
            return commands.stream().map(QueuedCommand::toCommand).collect(Collectors.toList());
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateCommand(boolean local, long deviceId) {
        DeviceSession deviceSession;
        if (!local && (deviceSession = this.connectionManager.getDeviceSession(deviceId)) != null && deviceSession.supportsLiveCommands()) {
            for (Command command : this.readQueuedCommands(deviceId)) {
                deviceSession.sendCommand(command);
            }
        }
    }
}

