/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TranSyncProtocolDecoder
extends BaseProtocolDecoder {
    public TranSyncProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int value) {
        switch (value) {
            case 4: {
                return "lowBattery";
            }
            case 6: {
                return "powerRestored";
            }
            case 10: {
                return "sos";
            }
            case 13: {
                return "hardBraking";
            }
            case 14: {
                return "hardAcceleration";
            }
            case 17: {
                return "overspeed";
            }
            case 23: {
                return "accident";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        short length;
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedShort();
        buf.readByte();
        int lac = buf.readUnsignedShort();
        String deviceId = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, deviceId);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        position.setTime(new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).getDate());
        double latitude = (double)buf.readUnsignedInt() / 1800000.0;
        double longitude = (double)buf.readUnsignedInt() / 1800000.0;
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        position.setCourse(buf.readUnsignedShort());
        short mnc = buf.readUnsignedByte();
        int cid = buf.readUnsignedShort();
        short status0 = buf.readUnsignedByte();
        position.setValid(BitUtil.check(status0, 0));
        position.setLatitude(BitUtil.check(status0, 1) ? latitude : -latitude);
        position.setLongitude(BitUtil.check(status0, 2) ? longitude : -longitude);
        position.set("out1", BitUtil.check(status0, 7));
        position.set("out2", BitUtil.check(status0, 6));
        position.set("in3", BitUtil.check(status0, 5));
        if (BitUtil.check(status0, 4)) {
            position.set("alarm", "powerOff");
        }
        position.set("ignition", BitUtil.check(status0, 3));
        buf.readUnsignedByte();
        short event = buf.readUnsignedByte();
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", Integer.valueOf(event));
        short status3 = buf.readUnsignedByte();
        if (BitUtil.check(status3, 7)) {
            position.set("archive", true);
        }
        if (BitUtil.check(status3, 5)) {
            position.set("alarm", "gpsAntennaCut");
        }
        short rssi = buf.readUnsignedByte();
        CellTower cellTower = CellTower.fromLacCid(this.getConfig(), lac, cid);
        cellTower.setMobileNetworkCode(Integer.valueOf(mnc));
        cellTower.setSignalStrength(Integer.valueOf(rssi));
        position.setNetwork(new Network(cellTower));
        position.set("battery", Double.valueOf(buf.readUnsignedByte() / 10));
        position.set("sat", buf.readUnsignedByte());
        position.set("hdop", buf.readUnsignedByte());
        position.set("adc1", (short)buf.readUnsignedShort());
        if (buf.readableBytes() > 5) {
            buf.readUnsignedByte();
            length = buf.readUnsignedByte();
            if (length > 0) {
                position.set("odometer", buf.readBytes((int)length).readInt());
            }
        }
        if (buf.readableBytes() > 5) {
            buf.readUnsignedByte();
            length = buf.readUnsignedByte();
            if (length > 0) {
                position.set("driverUniqueId", ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)length)));
            }
        }
        if (buf.readableBytes() > 5) {
            buf.readUnsignedByte();
            length = buf.readUnsignedByte();
            if (length > 0) {
                position.set("adc2", buf.readUnsignedShort());
            }
        }
        if (buf.readableBytes() > 5) {
            buf.readUnsignedByte();
            length = buf.readUnsignedByte();
            if (length > 0 && length <= buf.readableBytes() - 2) {
                position.set("adc3", buf.readUnsignedShort());
            }
        }
        return position;
    }
}

