/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.firebase.messaging.FcmOptionsUtil;

public final class AndroidFcmOptions {
    @Key(value="analytics_label")
    private final String analyticsLabel;

    private AndroidFcmOptions(Builder builder) {
        FcmOptionsUtil.checkAnalyticsLabel(builder.analyticsLabel);
        this.analyticsLabel = builder.analyticsLabel;
    }

    public static AndroidFcmOptions withAnalyticsLabel(String analyticsLabel) {
        return AndroidFcmOptions.builder().setAnalyticsLabel(analyticsLabel).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String analyticsLabel;

        private Builder() {
        }

        public Builder setAnalyticsLabel(String analyticsLabel) {
            this.analyticsLabel = analyticsLabel;
            return this;
        }

        public AndroidFcmOptions build() {
            return new AndroidFcmOptions(this);
        }
    }
}

