/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.lifecycle;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.lifecycle.mqtt3.Mqtt3ClientConnectedContextView;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedContext;
import com.hivemq.client.mqtt.mqtt5.lifecycle.Mqtt5ClientConnectedContext;
import org.jetbrains.annotations.NotNull;

public class MqttClientConnectedContextImpl
implements Mqtt5ClientConnectedContext {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttConnect connect;
    @NotNull
    private final MqttConnAck connAck;

    @NotNull
    public static MqttClientConnectedContext of(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect, @NotNull MqttConnAck connAck) {
        if (clientConfig.getMqttVersion() == MqttVersion.MQTT_3_1_1) {
            return Mqtt3ClientConnectedContextView.of(clientConfig, connect, connAck);
        }
        return new MqttClientConnectedContextImpl(clientConfig, connect, connAck);
    }

    private MqttClientConnectedContextImpl(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect, @NotNull MqttConnAck connAck) {
        this.clientConfig = clientConfig;
        this.connect = connect;
        this.connAck = connAck;
    }

    @Override
    @NotNull
    public MqttClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Override
    @NotNull
    public MqttConnect getConnect() {
        return this.connect;
    }

    @Override
    @NotNull
    public MqttConnAck getConnAck() {
        return this.connAck;
    }
}

