/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class DisembarkMessage
extends AttributeMessage {
    public static final String TAG = "disembark";
    private static final String UNIT_TAG = "unit";

    public DisembarkMessage(Unit unit) {
        super(TAG, UNIT_TAG, unit.getId());
    }

    public DisembarkMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        ServerUnit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, ServerUnit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        return this.igc(freeColServer).disembarkUnit(serverPlayer, unit);
    }
}

