/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class PartialMessage
extends AttributeMessage {
    public static final String TAG = "partial";
    public static final String ID_TAG = "id";

    public PartialMessage(Map<String, String> map) {
        super(TAG, map);
    }

    public PartialMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr.getAllAttributes());
        xr.closeTag(TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.PARTIAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        String id = this.getStringAttribute(ID_TAG);
        if (id == null) {
            logger.warning("Partial update is missing identifier attribute");
            return;
        }
        FreeColGameObject fcgo = game.getFreeColGameObject(id);
        if (fcgo == null) {
            logger.warning("Partial update of missing object: " + id);
            return;
        }
        if (freeColClient.isInGame()) {
            this.igc(freeColClient).partialHandler(fcgo, this.getStringAttributeMap());
        } else {
            logger.warning("Partial update when not in game.");
        }
        this.clientGeneric(freeColClient);
    }
}

