/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class ScopeTest
extends FreeColTestCase {
    UnitType carpenter = ScopeTest.spec().getUnitType("model.unit.masterCarpenter");
    UnitType frigate = ScopeTest.spec().getUnitType("model.unit.frigate");

    public void testEmptyScope() {
        Scope testScope = new Scope();
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.carpenter));
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.frigate));
        testScope.setMatchNegated(true);
        ScopeTest.assertFalse((boolean)testScope.appliesTo(this.carpenter));
        ScopeTest.assertFalse((boolean)testScope.appliesTo(this.frigate));
    }

    public void testTypeScope() {
        Scope testScope = new Scope();
        testScope.setType("model.unit.frigate");
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.frigate));
        ScopeTest.assertFalse((boolean)testScope.appliesTo(this.carpenter));
        testScope.setMatchNegated(true);
        ScopeTest.assertFalse((boolean)testScope.appliesTo(this.frigate));
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.carpenter));
        testScope.setMatchNegated(false);
        testScope.setType("model.unit.masterCarpenter");
        ScopeTest.assertFalse((boolean)testScope.appliesTo(this.frigate));
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.carpenter));
        testScope.setMatchNegated(true);
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.frigate));
        ScopeTest.assertFalse((boolean)testScope.appliesTo(this.carpenter));
    }

    public void testAbilityScope() {
        Scope testScope = new Scope();
        testScope.setAbilityId("model.ability.navalUnit");
        ScopeTest.assertEquals((boolean)this.frigate.hasAbility("model.ability.navalUnit"), (boolean)testScope.appliesTo(this.frigate));
        ScopeTest.assertEquals((boolean)this.carpenter.hasAbility("model.ability.navalUnit"), (boolean)testScope.appliesTo(this.carpenter));
    }

    public void testMethodScope() {
        Scope testScope = new Scope();
        testScope.setMethodName("getLineOfSight");
        testScope.setMethodValue("1");
        ScopeTest.assertTrue((this.frigate.getLineOfSight() != 1 ? 1 : 0) != 0);
        ScopeTest.assertFalse((boolean)testScope.appliesTo(this.frigate));
        ScopeTest.assertTrue((this.carpenter.getLineOfSight() == 1 ? 1 : 0) != 0);
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.carpenter));
    }

    public void testCombinedScope() {
        Scope testScope = new Scope();
        testScope.setType("model.unit.frigate");
        testScope.setAbilityId("model.ability.navalUnit");
        testScope.setMethodName("getLineOfSight");
        testScope.setMethodValue("2");
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.frigate));
        testScope.setMethodValue("1");
        ScopeTest.assertFalse((boolean)testScope.appliesTo(this.frigate));
        testScope.setMethodValue("2");
        testScope.setAbilityId("model.ability.foundColony");
        ScopeTest.assertFalse((boolean)testScope.appliesTo(this.frigate));
    }

    public void testMatchesNull() {
        Scope testScope = new Scope();
        testScope.setType("model.unit.frigate");
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.frigate));
        ScopeTest.assertTrue((boolean)testScope.appliesTo(null));
        testScope.setMatchesNull(false);
        ScopeTest.assertTrue((boolean)testScope.appliesTo(this.frigate));
        ScopeTest.assertFalse((boolean)testScope.appliesTo(null));
    }

    public void testEquality() {
        Scope testScope1 = new Scope();
        testScope1.setType("model.unit.frigate");
        testScope1.setAbilityId("model.ability.navalUnit");
        testScope1.setMethodName("getLineOfSight");
        testScope1.setMethodValue("2");
        testScope1.setMatchesNull(true);
        testScope1.setMatchNegated(false);
        ScopeTest.assertTrue((boolean)testScope1.equals(testScope1));
        Scope testScope2 = new Scope();
        testScope2.setType("model.unit.frigate");
        testScope2.setAbilityId("model.ability.navalUnit");
        testScope2.setMethodName("getLineOfSight");
        testScope2.setMethodValue("2");
        testScope2.setMatchesNull(true);
        testScope2.setMatchNegated(false);
        ScopeTest.assertTrue((boolean)testScope2.equals(testScope2));
        ScopeTest.assertTrue((boolean)testScope1.equals(testScope2));
        ScopeTest.assertTrue((boolean)testScope2.equals(testScope1));
        testScope1.setType("model.unit.carpenter");
        ScopeTest.assertFalse((boolean)testScope1.equals(testScope2));
        ScopeTest.assertFalse((boolean)testScope2.equals(testScope1));
        testScope1.setType("model.unit.frigate");
        testScope1.setAbilityId("model.ability.foundColony");
        ScopeTest.assertFalse((boolean)testScope1.equals(testScope2));
        ScopeTest.assertFalse((boolean)testScope2.equals(testScope1));
        testScope1.setAbilityId("model.ability.navalUnit");
        testScope1.setAbilityValue(false);
        ScopeTest.assertFalse((boolean)testScope1.equals(testScope2));
        ScopeTest.assertFalse((boolean)testScope2.equals(testScope1));
        testScope1.setAbilityValue(true);
        testScope1.setMethodName("getOffence");
        ScopeTest.assertFalse((boolean)testScope1.equals(testScope2));
        ScopeTest.assertFalse((boolean)testScope2.equals(testScope1));
        testScope1.setMethodName("getLineOfSight");
        testScope1.setMethodValue("9");
        ScopeTest.assertFalse((boolean)testScope1.equals(testScope2));
        ScopeTest.assertFalse((boolean)testScope2.equals(testScope1));
        testScope1.setMethodValue("2");
        ScopeTest.assertTrue((boolean)testScope1.equals(testScope2));
        ScopeTest.assertTrue((boolean)testScope2.equals(testScope1));
        testScope1.setMatchesNull(false);
        ScopeTest.assertFalse((boolean)testScope1.equals(testScope2));
        ScopeTest.assertFalse((boolean)testScope2.equals(testScope1));
        testScope1.setMatchesNull(true);
        ScopeTest.assertTrue((boolean)testScope1.equals(testScope2));
        ScopeTest.assertTrue((boolean)testScope2.equals(testScope1));
        testScope1.setMatchNegated(true);
        ScopeTest.assertFalse((boolean)testScope1.equals(testScope2));
        ScopeTest.assertFalse((boolean)testScope2.equals(testScope1));
        testScope1.setMatchNegated(false);
        ScopeTest.assertTrue((boolean)testScope1.equals(testScope2));
        ScopeTest.assertTrue((boolean)testScope2.equals(testScope1));
    }

    public void testGameObjects() {
        Game game = ScopeTest.getStandardGame();
        Map map = ScopeTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile unitTile = map.getTile(6, 8);
        UnitType colonistType = ScopeTest.spec().getUnitType("model.unit.freeColonist");
        ServerUnit unit = new ServerUnit(game, unitTile, dutch, colonistType);
        Scope scope = new Scope();
        scope.setAbilityId("model.ability.foundColony");
        ScopeTest.assertTrue((boolean)scope.appliesTo(unit));
        scope.setType("model.unit.freeColonist");
        ScopeTest.assertTrue((boolean)scope.appliesTo(unit));
        scope.setType("model.unit.hardyPioneer");
        ScopeTest.assertFalse((boolean)scope.appliesTo(unit));
    }
}

