<-- This file is part 20 of the GNU version of
    The Collaborative International Dictionary of English (GCIDE)

    Copyright (C) 1992-2012 Patrick J. Cassidy

    GCIDE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3, or (at your option)
    any later version.

    GCIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this copy of GCIDE.  If not, see <http://www.gnu.org/licenses/>.
-->

<p><centered><point26>T.</point26></centered></p>

<p><ent>T</ent><br/
<hw>T</hw> <pr>(t<emac/)</pr>, <def>the twentieth letter of the English alphabet, is a nonvocal consonant. With the letter <xex>h</xex> it forms the digraph <xex>th</xex>, which has two distinct sounds, as in <xex>th</xex>in, <xex>th</xex>en. See <xex>Guide to Pronunciation</xex>, <sect/<sect/262-264, and also <sect/<sect/153, 156, 169, 172, 176, 178-180.</def><br/
[<source>1913 Webster</source>]</p>

<p>The letter derives its name and form from the Latin, the form of the Latin letter being further derived through the Greek from the Ph<oe/nician. The ultimate origin is probably Egyptian. It is etymologically most nearly related to <xex>d</xex>, <xex>s</xex>, <xex>th</xex>; as in <xex>t</xex>ug, <xex>d</xex>uke; <xex>t</xex>wo, <xex>d</xex>ual, L. <xex>d</xex>uo; re<xex>s</xex>in, L. re<xex>s</xex>ina, Gr. <grk>"rhti`nh</grk>, ten<xex>t</xex>, ten<xex>s</xex>e, a., <xex>t</xex>enuous, <xex>th</xex>in; nos<xex>t</xex>ril, <xex>th</xex>rill. See <er>D</er>, <er>S</er>.<br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>T bandage</b></col> <fld>(Surg.)</fld>, <cd>a bandage shaped like the letter <universbold>T</universbold>, and used principally for application to the groin, or perineum.</cd> -- <col><b>T cart</b></col>, <cd>a kind of fashionable two seated wagon for pleasure driving.</cd> -- <col><b>T iron</b></col>. <sd>(a)</sd> <cd>A rod with a short crosspiece at the end, -- used as a hook.</cd> <sd>(b)</sd> <cd>Iron in bars, having a cross section formed like the letter <universbold>T</universbold>, -- used in structures.</cd> -- <col><b>T rail</b></col>, <cd>a kind of rail for railroad tracks, having no flange at the bottom so that a section resembles the letter <universbold>T</universbold>.</cd> -- <col><b>T square</b></col>, <cd>a ruler having a crosspiece or head at one end, for the purpose of making parallel lines; -- so called from its shape. It is laid on a drawing board and guided by the crosspiece, which is pressed against the straight edge of the board. Sometimes the head is arranged to be set at different angles.</cd> -- <col><b>To a T</b></col>, <cd>exactly, perfectly; <as>as, to suit <ex>to a T</ex></as>.</cd> <mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ta</ent><br/
<hw>Ta</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To take.</def> <mark>[Obs. or Scot.]</mark>  <rj><au>Cursor Mundi.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Used by Chaucer to represent a peculiarity of the Northern dialect.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taas</ent><br/
<hw>Taas</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A heap. See <er>Tas</er>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tab</ent><br/
<hw>Tab</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Etymol. uncertain.]</ety> <sn>1.</sn> <def>The flap or latchet of a shoe fastened with a string or a buckle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tag. See <er>Tag</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A loop for pulling or lifting something.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A border of lace or other material, worn on the inner front edge of ladies' bonnets.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A loose pendent part of a lady's garment; esp., one of a series of pendent squares forming an edge or border.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>a small projecting piece of a file folder, file card, or similar sheet used in a filing system, on which a notation is written to permit convenient search for the folder, card, etc.</def><br/
[<source>PJC</source>]</p>

<p><sn>7.</sn> <def>a bill or check for some purchase, as in a restaurant; <as>as, the salesman will pick up the <ex>tab</ex></as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>8.</sn> <def>a key on a typewriter or computer keyboard which advances the carriage or curser to the next (preset) tab position; -- used especially to type or print text or numbers in columns.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tabacco</ent><br/
<hw>Ta*bac"co</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Tobacco.</def> <mark>[Obs.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabanus</ent><br/
\'d8<hw>Ta*ba"nus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., horsefly.]</ety> <fld>(Zool.)</fld> <def>A genus of blood sucking flies, including the horseflies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabard</ent><br/
<hw>Tab"ard</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>tabard</ets>, <ets>tabart</ets>; cf. Sp. & Pg. <ets>tabardo</ets>, It. <ets>tabarro</ets>, W. <ets>tabar</ets>, LGr. <grk>tampa`rion</grk>, LL. <ets>tabardum</ets>.]</ety> <def>A sort of tunic or mantle formerly worn for protection from the weather. When worn over the armor it was commonly emblazoned with the arms of the wearer, and from this the name was given to the garment adopted for heralds.</def> <altsp>[Spelt also <asp>taberd</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q>In a <qex>tabard</qex> he [the Plowman] rode upon a mare.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabarder</ent><br/
<hw>Tab"ard*er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who wears a tabard.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A scholar on the foundation of Queen's College, Oxford, England, whose original dress was a tabard.</def>  <rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabaret</ent><br/
<hw>Tab"a*ret</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Tabby</er>.]</ety> <def>A stout silk having satin stripes, -- used for furniture.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabasco sauce</ent><br/
<hw>Ta*bas"co sauce</hw> <pr>(?)</pr>. <ety>[So named after <etsep>Tabasco</etsep>, a river and state of Mexico.]</ety> <def>A kind of very pungent sauce made from red peppers.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>tabasheer</ent><br/
<hw>tab`a*sheer"</hw> <pr>(t<acr/b`<adot/*sh<emac/r")</pr>, <pos>n.</pos> <ety>[Per. <ets>tab<amac/sh<imac/r</ets>: cf. Skr. <ets>tvakksh<imac/r<amac/</ets>, <ets>tvaksh<imac/r<amac/</ets>.]</ety> <def>A concretion in the joints of the bamboo, which consists largely or chiefly of pure silica.  It is highly valued in the East Indies as a medicine for the cure of bilious vomitings, bloody flux, piles, and various other diseases.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabbinet</ent><br/
<hw>Tab"bi*net</hw> <pr>(t<acr/b"b<icr/*n<ecr/t)</pr>, <pos>n.</pos> <ety>[Cf. <er>Tabby</er>.]</ety> <def>A fabric like poplin, with a watered surface.</def> <altsp>[Written also <asp>tabinet</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabby</ent><br/
<hw>Tab"by</hw> <pr>(t<acr/b"b<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tabbies</plw> <pr>(t<acr/b"b<icr/z)</pr>.</plu> <ety>[F. <ets>tabis</ets> (cf. It. <ets>tab<igrave/</ets>, Sp. & Pg. <ets>tab<iacute/</ets>, LL. <ets>attabi</ets>), fr. Ar. <ets>'att<amac/b<imac/</ets>, properly the name of a quarter of Bagdad where it was made, the quarter being named from the prince <etsep>Attab</etsep>, great grandson of Omeyya.  Cf. <er>Tobine</er>.]</ety> <sn>1.</sn> <def>A kind of waved silk, usually called <altname>watered silk</altname>, manufactured like taffeta, but thicker and stronger.  The watering is given to it by calendering.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A mixture of lime with shells, gravel, or stones, in equal proportions, with an equal proportion of water. When dry, this becomes as hard as rock.</def>  <rj><au>Weale.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A brindled cat; hence, popularly, any cat.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An old maid or gossip.</def> <mark>[Colloq.]</mark>  <rj><au>Byron.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabby</ent><br/
<hw>Tab"by</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having a wavy or watered appearance; <as>as, a <ex>tabby</ex> waistcoat</as>.</def>  <rj><au>Pepys.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Brindled; diversified in color; <as>as, a <ex>tabby</ex> cat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tabby moth</b></col> <fld>(Zool.)</fld>, <cd>the grease moth. See under <er>Grease</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabby</ent><br/
<hw>Tab"by</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tabbied</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tabbying</conjf> <pr>(?)</pr>.]</vmorph> <def>To water; to cause to look wavy, by the process of calendering; to calender; <as>as, to <ex>tabby</ex> silk, mohair, ribbon, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabefaction</ent><br/
<hw>Tab`e*fac"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tabefy</er>.]</ety> <def>A wasting away; a gradual losing of flesh by disease.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabefy</ent><br/
<hw>Tab"e*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tabefied</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tabefying</conjf> <pr>(?)</pr>.]</vmorph> <ety>[L. <ets>tabere</ets> to waste away + <ets>-fy</ets>: cf. L. <ets>tabefacere</ets> to melt.]</ety> <def>To cause to waste gradually, to emaciate.</def> <mark>[R.]</mark>  <rj><au>Harvey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabellion</ent><br/
<hw>Ta*bel"lion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tabellio</ets>, fr. <ets>tabella</ets> a tablet, a writing, document, dim. of <ets>tabula</ets> a board: cf. F. <ets>tabellion</ets>. See <er>Table</er>.]</ety> <def>A secretary or notary under the Roman empire; also, a similar officer in France during the old monarchy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taber</ent><br/
<hw>Ta"ber</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>Same as <er>Tabor</er>.</def>  <rj><au>Nahum ii. 7.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taberd</ent><br/
<hw>Tab"erd</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tabard</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabernacle</ent><br/
<hw>Tab"er*na*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>tabernaculum</ets>, dim. of <ets>taberna</ets> nut. See <er>Tabern</er>.]</ety> <sn>1.</sn> <def>A slightly built or temporary habitation; especially, a tent.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Dwelling in <qex>tabernacles</qex> with Isaac and Jacob.</q> <rj><qau>Heb. xi. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Orange trees planted in the ground, and secured in winter with a wooden <qex>tabernacle</qex> and stoves.</q> <rj><qau>Evelyn.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Jewish Antiq.)</fld> <def>A portable structure of wooden framework covered with curtains, which was carried through the wilderness in the Israelitish exodus, as a place of sacrifice and worship.</def>  <rj><au>Ex. xxvi.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, the Jewish temple; sometimes, any other place for worship.</def>  <rj><au>Acts xv. 16.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Figuratively: The human body, as the temporary abode of the soul.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Shortly I must put off this my <qex>tabernacle</qex>.</q> <rj><qau>2 Pet. i. 14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Any small cell, or like place, in which some holy or precious things was deposited or kept.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>The ornamental receptacle for the pyx, or for the consecrated elements, whether a part of a building or movable.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>A niche for the image of a saint, or for any sacred painting or sculpture.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>Hence, a work of art of sacred subject, having a partially architectural character, as a solid frame resting on a bracket, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>A tryptich for sacred imagery.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(e)</sd> <def>A seat or stall in a choir, with its canopy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Naut.)</fld> <def>A boxlike step for a mast with the after side open, so that the mast can be lowered to pass under bridges, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Feast of Tabernacles</b></col> <fld>(Jewish Antiq.)</fld>, <cd>one of the three principal festivals of the Jews, lasting seven days, during which the people dwelt in booths formed of the boughs of trees, in commemoration of the habitation of their ancestors in similar dwellings during their pilgrimage in the wilderness.</cd> -- <col><b>Tabernacle work</b></col>, <cd>rich canopy work like that over the head of niches, used over seats or stalls, or over sepulchral monuments.</cd> <au>Oxf. Gloss.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabernacle</ent><br/
<hw>Tab"er*na*cle</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tabernacled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tabernacling</conjf> <pr>(?)</pr>.]</vmorph> <def>To dwell or reside for a time; to be temporary housed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He assumed our nature, and <qex>tabernacled</qex> among us in the flesh.</q> <rj><qau>Dr. J. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabernacular</ent><br/
<hw>Tab`er*nac"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Of or pertaining to a tabernacle, especially the Jewish tabernacle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Formed in latticework; latticed.</def>  <rj><au>T. Warton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Of or pertaining to huts or booths; hence, common; low.</def> <ldquo/Horribly <xex>tabernacular</xex>.<rdquo/  <rj><au>De Quincey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabes</ent><br/
\'d8<hw>Ta"bes</hw> <pr>(t<amac/"b<emac/z)</pr>, <pos>n.</pos> <ety>[L., a wasting disease.]</ety> <fld>(Med.)</fld> <def>Progressive emaciation of the body, accompanied with hectic fever, with no well-marked local symptoms.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs>\'d8<col><b>Tabes dorsalis</b></col> <pr>(t<amac/"b<emac/z d<ocir/r*s<amac/"l<icr/s)</pr> <ety>[NL., tabes of the back]</ety>, <cd>locomotor ataxia; -- sometimes called simply <xex>tabes</xex>.</cd> -- \'d8<col><b>Tabes mesenterica</b></col> <pr>(<?/)</pr> <ety>[NL., mesenteric tabes]</ety>, <cd>a wasting disease of childhood characterized by chronic inflammation of the lymphatic glands of the mesentery, attended with caseous degeneration.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabescent</ent><br/
<hw>Ta*bes"cent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tabescens</ets> wasting, p. pr. of <ets>tabescere</ets>.]</ety> <def>Withering, or wasting away.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabetic</ent><br/
<hw>Ta*bet"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Med.)</fld> <def>Of or pertaining to tabes; of the nature of tabes; affected with tabes; tabid.</def> -- <def2><pos>n.</pos> <def>One affected with tabes.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabid</ent><br/
<hw>Tab"id</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tabidus</ets>: cf. F. <ets>tabide</ets>. See <er>Tabes</er>.]</ety> <fld>(Med.)</fld> <def>Affected by tabes; tabetic.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In <qex>tabid</qex> persons, milk is the bset restorative.</q> <rj><qau>Arbuthnot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Tab"id*ly</wf>, <pos>adv.</pos> -- <wf>Tab"id*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabifical</ent><br/
<ent>Tabific</ent><br/
<mhw>{ <hw>Ta*bif"ic</hw> <pr>(?)</pr>, <hw>Ta*bif"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Tabes</ets> + L. <ets>facere</ets> to make.]</ety> <fld>(Med.)</fld> <def>Producing tabes; wasting; tabefying.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabinet</ent><br/
<hw>Tab"inet</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tabbinet</er>.</def>  <rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tablature</ent><br/
<hw>Tab"la*ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tablature</ets> ancient mode of musical notation. See <er>Table</er>.]</ety> <sn>1.</sn> <fld>(Paint.)</fld> <def>A painting on a wall or ceiling; a single piece comprehended in one view, and formed according to one design; hence, a picture in general.</def>  <rj><au>Shaftesbury.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>An ancient mode of indicating musical sounds by letters and other signs instead of by notes.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The chimes of bells are so rarely managed that I went up to that of Sir Nicholas, where I found who played all sorts of compositions from the <qex>tablature</qex> before him as if he had fingered an organ.</q> <rj><qau>Evelyn.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Anat.)</fld> <def>Division into plates or tables with intervening spaces; <as>as, the <ex>tablature</ex> of the cranial bones</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Table</ent><br/
<hw>Ta"ble</hw> <pr>(t<amac/"'l)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>tabula</ets> a board, tablet, a painting.  Cf. <er>Tabular</er>, <er>Taffrail</er>, <er>Tavern</er>.]</ety> <sn>1.</sn> <def>A smooth, flat surface, like the side of a board; a thin, flat, smooth piece of anything; a slab.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A bagnio paved with fair <qex>tables</qex> of marble.</q> <rj><qau>Sandys.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A thin, flat piece of wood, stone, metal, or other material, on which anything is cut, traced, written, or painted; a tablet</def>; <pluf>pl.</pluf> <def>a memorandum book.</def> <ldquo/The names . . . written on his <xex>tables</xex>.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And the Lord said unto Moses, Hew thee two <qex>tables</qex> of stone like unto the first, and I will write upon these <qex>tables</qex> the words that were in the first <qex>tables</qex>, which thou brakest.</q> <rj><qau>Ex. xxxiv. 1.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And stand there with your <qex>tables</qex> to glean<br/
The golden sentences.</q> <rj><qau>Beau. & Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any smooth, flat surface upon which an inscription, a drawing, or the like, may be produced.</def> <ldquo/Painted in a <xex>table</xex> plain.<rdquo/  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The opposite walls are painted by Rubens, which, with that other of the Infanta taking leave of Don Philip, is a most incomparable <qex>table</qex>.</q> <rj><qau>Evelyn.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>St. Antony has a <qex>table</qex> that hangs up to him from a poor peasant.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Hence, in a great variety of applications: A condensed statement which may be comprehended by the eye in a single view; a methodical or systematic synopsis; the presentation of many items or particulars in one group; a scheme; a schedule.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <fld>(Bibliog.)</fld> <def>A view of the contents of a work; a statement of the principal topics discussed; an index; a syllabus; a synopsis; <as>as, a <ex>table</ex> of contents</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <fld>(Chem.)</fld> <def>A list of substances and their properties; especially, the a list of the elementary substances with their atomic weights, densities, symbols, etc.; the periodic table of the elements.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <fld>(Mathematics, Science and Technology)</fld>  <def>Any collection and arrangement in a condensed form of many particulars or values, for ready reference, as of weights, measures, currency, specific gravities, etc.; also, a series of numbers following some law, and expressing particular values corresponding to certain other numbers on which they depend, and by means of which they are taken out for use in computations; <as>as, <ex>tables</ex> of logarithms, sines, tangents, squares, cubes, etc.; annuity <ex>tables</ex>; interest <ex>tables</ex>; astronomical <ex>tables</ex>; a <ex>table</ex> of logarithms, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <fld>(Palmistry)</fld> <def>The arrangement or disposition of the lines which appear on the inside of the hand.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Mistress of a fairer <qex>table</qex><br/
Hath not history for fable.</q> <rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>An article of furniture, consisting of a flat slab, board, or the like, having a smooth surface, fixed horizontally on legs, and used for a great variety of purposes, as in eating, writing, or working.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We may again<br/
Give to our <qex>tables</qex> meat.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The nymph the <qex>table</qex> spread.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Hence, food placed on a table to be partaken of; fare; entertainment; <as>as, to set a good <ex>table</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>The company assembled round a table.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I drink the general joy of the whole <qex>table</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Anat.)</fld> <def>One of the two, external and internal, layers of compact bone, separated by diploe, in the walls of the cranium.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Arch.)</fld> <def>A stringcourse which includes an offset; esp., a band of stone, or the like, set where an offset is required, so as to make it decorative. See <er>Water table</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Games)</fld> <sd>(a)</sd> <def>The board on the opposite sides of which backgammon and draughts are played.</def> <sd>(b)</sd> <def>One of the divisions of a backgammon board; <as>as, to play into the right-hand <ex>table</ex></as>.</def> <sd>(c)</sd> <pluf>pl.</pluf> <def>The games of backgammon and of draughts.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This is the ape of form, monsieur the nice,<br/
That, when he plays at <qex>tables</qex>, chides the dice.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <fld>(Glass Manuf.)</fld> <def>A circular plate of crown glass.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A circular plate or <qex>table</qex> of about five feet diameter weighs on an average nine pounds.</q> <rj><qau>Ure.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>12.</sn> <fld>(Jewelry)</fld> <def>The upper flat surface of a diamond or other precious stone, the sides of which are cut in angles.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>13.</sn> <fld>(Persp.)</fld> <def>A plane surface, supposed to be transparent and perpendicular to the horizon; -- called also <altname>perspective plane</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>14.</sn> <fld>(Mach.)</fld> <def>The part of a machine tool on which the work rests and is fastened.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Bench table</b></col>, <col><b>Card table</b></col>, <col><b>Communion table</b></col>, <col><b>Lord's table</b></col></mcol>, <cd>etc. See under <er>Bench</er>, <er>Card</er>, etc.</cd> -- <col><b>Raised table</b></col> <fld>(Arch. & Sculp.)</fld>, <cd>a raised or projecting member of a flat surface, large in proportion to the projection, and usually rectangular, -- especially intended to receive an inscription or the like.</cd> -- <col><b>Roller table</b></col> <fld>(Horology)</fld>, <cd>a flat disk on the arbor of the balance of a watch, holding the jewel which rolls in and out of the fork at the end of the lever of the escapement.</cd> -- <col><b>Round table</b></col>. <cd>See Dictionary of Noted Names in Fiction.</cd> -- <col><b>Table anvil</b></col>, <cd>a small anvil to be fastened to a table for use in making slight repairs.</cd> -- <col><b>Table base</b></col>. <fld>(Arch.)</fld> <cd>Same as <er>Water table</er>.</cd> -- <col><b>Table bed</b></col>, <cd>a bed in the form of a table.</cd> -- <col><b>Table beer</b></col>, <cd>beer for table, or for common use; small beer.</cd> -- <col><b>Table bell</b></col>, <cd>a small bell to be used at table for calling servants.</cd> -- <col><b>Table cover</b></col>, <cd>a cloth for covering a table, especially at other than mealtimes.</cd> -- <col><b>Table diamond</b></col>, <cd>a thin diamond cut with a flat upper surface.</cd> -- <col><b>Table linen</b></col>, <cd>linen tablecloth, napkins, and the like.</cd> -- <col><b>Table money</b></col> <fld>(Mil. or Naut.)</fld>, <cd>an allowance sometimes made to officers over and above their pay, for table expenses.</cd> -- <col><b>Table rent</b></col> <fld>(O. Eng. Law)</fld>, <cd>rent paid to a bishop or religious, reserved or appropriated to his table or housekeeping.</cd> <au>Burrill.</au> -- <col><b>Table shore</b></col> <fld>(Naut.)</fld>, <cd>a low, level shore.</cd> -- <col><b>Table talk</b></col>, <cd>conversation at table, or at meals.</cd> -- <col><b>Table talker</b></col>, <cd>one who talks at table.</cd> -- <mcol><col><b>Table tipping</b></col>, <col><b>Table turning</b></col></mcol>, <cd>certain movements of tables, etc., attributed by some to the agency of departed spirits, and by others to the development of latent vital or spriritual forces, but more commonly ascribed to the muscular force of persons in connection with the objects moved, or to physical force applied otherwise.</cd> -- <mcol><col><b>Tables of a girder</b></col> <it>or</it> <col><b>Tables of a chord</b></col></mcol> <fld>(Engin.)</fld>, <cd>the upper and lower horizontal members.</cd> -- <col><b>To lay on the table</b></col>, <cd>in parliamentary usage, to lay, as a report, motion, etc., on the table of the presiding officer, -- that is, to postpone the consideration of, by a vote; -- also called to <altname>table</altname> .  It is a tactic often used with the intention of postponing consideration of a motion indefinitely, that is, to kill the motion.</cd> -- <col><b>To serve tables</b></col> <fld>(Script.)</fld>, <cd>to provide for the poor, or to distribute provisions for their wants.</cd> <au>Acts vi. 2.</au> -- <col><b>To turn the tables</b></col>, <cd>to change the condition or fortune of contending parties; -- a metaphorical expression taken from the vicissitudes of fortune in gaming.</cd> -- <col><b>Twelve tables</b></col> <fld>(Rom. Antiq.)</fld>, <cd>a celebrated body of Roman laws, framed by decemvirs appointed 450 years before Christ, on the return of deputies or commissioners who had been sent to Greece to examine into foreign laws and institutions. They consisted partly of laws transcribed from the institutions of other nations, partly of such as were altered and accommodated to the manners of the Romans, partly of new provisions, and mainly, perhaps, of laws and usages under their ancient kings.</cd> <au>Burrill.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1467 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Table</ent><br/
<hw>Ta"ble</hw> <pr>(t<amac/"b'l)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tabled</conjf> <pr>(t<amac/"b'ld)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tabling</conjf> <pr>(t<amac/"bling)</pr>.]</vmorph> <sn>1.</sn> <def>To form into a table or catalogue; to tabulate; <as>as, to <ex>table</ex> fines</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To delineate, as on a table; to represent, as in a picture.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tabled</qex> and pictured in the chambers of meditation.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To supply with food; to feed.</def> <mark>[Obs.]</mark>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Carp.)</fld> <def>To insert, as one piece of timber into another, by alternate scores or projections from the middle, to prevent slipping; to scarf.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To lay or place on a table, as money.</def>  <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>In parliamentary usage, to lay on the table; to postpone, by a formal vote, the consideration of (a bill, motion, or the like) till called for, or indefinitely.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To enter upon the docket; <as>as, to <ex>table</ex> charges against some one</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Naut.)</fld> <def>To make broad hems in the skirts and bottoms of (sails) in order to strengthen them in the part attached to the boltrope.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Table</ent><br/
<hw>Ta"ble</hw>, <pos>v. i.</pos> <def>To live at the table of another; to board; to eat.</def> <mark>[Obs.]</mark> <ldquo/He . . . was driven from the society of men to <xex>table</xex> with the beasts.<rdquo/  <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tableau</ent><br/
\'d8<hw>Ta`bleau"</hw> <pr>(t<adot/`bl<omac/" E. t<acr/b"l<omac/`; 277)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tableaux</plw> <pr>(t<adot/`bl<omac/" E. t<acr/b"l<omac/z`)</pr>.</plu> <ety>[F., dim. fr. L. <ets>tabula</ets> a painting. See <er>Table</er>.]</ety> <sn>1.</sn> <def>A striking and vivid representation; a picture.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A representation of some scene by means of persons grouped in the proper manner, placed in appropriate postures, and remaining silent and motionless.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Solitaire)</fld> <def>The arrangement, or layout, of cards.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tableau vivant</ent><br/
\'d8<hw>Ta`bleau" vi`vant"</hw> <pr>(t<adot/`bl<omac/" v<esl/`v<aum/N")</pr>; <plu><it>pl.</it> <plw>Tableaux vivants</plw> <pr>(t<adot/`bl<omac/" v<esl/`v<aum/N")</pr>.</plu> <ety>[F.]</ety> <def>Same as <er>Tableau</er>, <pos>n.</pos>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tablebook</ent><br/
<hw>Ta"ble*book`</hw> <pr>(t<amac/"b'l b<oocr/k`)</pr>, <pos>n.</pos> <def>A tablet; a notebook.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Put into your <qex>tablebook</qex> whatever you judge worthy.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tablecloth</ent><br/
<hw>Ta"ble*cloth`</hw> <pr>(t<amac/"b'l kl<ocr/th`; 115)</pr>, <pos>n.</pos> <def>A cloth for covering a table, especially one with which a table is covered before the dishes, etc., are set on for meals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Table d'hote</ent><br/
\'d8<hw>Ta"ble d'h<ocir/te"</hw> <pr>(t<adot/"bl' d<omac/t`)</pr>; <plu><it>pl.</it> <plw>Tables d'h<ocir/te</plw> <pr>(#)</pr>.</plu> <ety>[F., literally, table of the landlord.]</ety> <sn>1.</sn> <def>A common table for guests at a hotel; an ordinary.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Now, commonly, a meal, usually of several preselected and fixed courses, in a restaurant, hotel, or the like, for which one pays a fixed price.  Sometimes, a meal with optional courses for which one pays a fixed price irrespective of what one orders; but the latter is usuallyt referred to as a <contr>pris fixe</contr> meal or a <contr>a la carte</contr> meal. Often used adjectively; <as>as, a <ex>table-d'h<ocir/te</ex> meal</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Table-land</ent><br/
<hw>Ta"ble-land`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A broad, level, elevated area of land; a plateau.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The toppling crags of Duty scaled,<br/
Are close upon the shining <qex>table-lands</qex><br/
To which our God himself is moon and sun.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tableman</ent><br/
<hw>Ta"ble*man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tablemen</plw> <pr>(<?/)</pr>.</plu> <def>A man at draughts; a piece used in playing games at tables. See <er>Table</er>, <pos>n.</pos>, 10.</def> <mark>[R.]</mark>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tablement</ent><br/
<hw>Ta"ble*ment</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Arch.)</fld> <def>A table.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tablements</qex> and chapters of pillars.</q> <rj><qau>Holland.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabler</ent><br/
<hw>Ta"bler</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who boards.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who boards others for hire.</def> <mark>[Obs.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tablespoon</ent><br/
<hw>Ta"ble*spoon`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A spoon of the largest size commonly used at the table; -- distinguished from <xex>teaspoon</xex>, <xex>dessert spoon</xex>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tablespoonful</ent><br/
<hw>Ta"ble*spoon`ful</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tablespoonfuls</plw> <pr>(<?/)</pr>.</plu> <def>As much as a tablespoon will hold; enough to fill a tablespoon. It is usually reckoned as one half of a fluid ounce, or four fluid drams.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tablet</ent><br/
<hw>Ta"blet</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tablette</ets>, dim. of <ets>table</ets>. See <er>Table</er>.]</ety> <sn>1.</sn> <def>A small table or flat surface.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A flat piece of any material on which to write, paint, draw, or engrave; also, such a piece containing an inscription or a picture.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, a small picture; a miniature.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <pluf>pl.</pluf> <def>A kind of pocket memorandum book.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A flattish cake or piece; <as>as, <ex>tablets</ex> of arsenic were formerly worn as a preservative against the plague</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Pharm.)</fld> <def>A solid kind of electuary or confection, commonly made of dry ingredients with sugar, and usually formed into little flat squares; -- called also <altname>lozenge</altname>, and <altname>troche</altname>, especially when of a round or rounded form.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tableware</ent><br/
<hw>Ta"ble*ware`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Ware, or articles collectively, for use during meals, including, for example, <examp>dishes</examp>, <examp>plates</examp>, <examp>bowls</examp>, <examp>knives</examp>, <examp>forks</examp>, and <examp>spoons</examp>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Table work</ent><br/
<hw>Table work</hw>. <fld>(Print.)</fld> <def>Typesetting of tabular nmatter, or the type matter set in tabular form.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tabling</ent><br/
<hw>Ta"bling</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A forming into tables; a setting down in order.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Carp.)</fld> <def>The letting of one timber into another by alternate scores or projections, as in shipbuilding.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Naut.)</fld> <def>A broad hem on the edge of a sail.</def>  <rj><au>Totten.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Board; support.</def> <mark>[Obs.]</mark>  <rj><au>Trence in English (1614).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Act of playing at tables. See <er>Table</er>, <pos>n.</pos>, 10.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tabling house</b></col>, <cd>a gambling house.</cd> <mark>[Obs.]</mark> <au>Northbrooke.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabloid</ent><br/
<hw>Tab"loid</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[A table-mark.]</ety> <sn>1.</sn> <def>A compressed portion of one or more drugs or chemicals, or of food, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>a newspaper with pages about half the size of a standard-sized newspaper, especially one that has relatively short or condensed articles and a large porortion of pictorial matter.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tabloid</ent><br/
<hw>Tab"loid</hw> <pr>(t<acr/b"loid)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Compressed or condensed, as into a tabloid; administrated in or as in tabloids, or small condensed bits; <as>as, a <ex>tabloid</ex> form of imparting information</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>of or pertaining to a tabloid newspaper or the type of story typically contained in one, such as lurid or sensationalistic stories of scandal, crime, or violence.</def><br/
[<source>PJC</source>]</p>

<p><ent>Taboo</ent><br/
<hw>Ta*boo"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A total prohibition of intercourse with, use of, or approach to, a given person or thing under pain of death, -- an interdict of religious origin and authority, formerly common in the islands of Polynesia; interdiction.</def> <altsp>[Written also <asp>tabu</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taboo</ent><br/
<hw>Ta*boo"</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tabooed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tabooing</conjf>.]</vmorph> <def>To put under taboo; to forbid, or to forbid the use of; to interdict approach to, or use of; <as>as, to <ex>taboo</ex> the ground set apart as a sanctuary for criminals</as>.</def> <altsp>[Written also <asp>tabu</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taboo</ent><br/
<hw>Ta*boo"</hw> <pr>(?)</pr>, <pos>a.</pos> <altsp>[Written also <asp>tabu</asp> and <asp>tapu</asp>.]</altsp> <ety>[Polynesian <ets>tabu</ets>, <ets>tapu</ets>, sacred, under restriction, a prohibition.]</ety> <def>Set apart or sacred by religious custom among certain races of Polynesia, New Zealand, etc., and forbidden to certain persons or uses; hence, prohibited under severe penalties; interdicted; <as>as, food, places, words, customs, etc., may be <ex>taboo</ex></as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tabor</ent><br/
<hw>Ta"bor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>tabor</ets>, <ets>tabour</ets>, F. <ets>tambour</ets>; cf. Pr. <ets>tabor</ets>, <ets>tanbor</ets>, Sp. & Pg. <ets>tambor</ets>, <ets>atambor</ets>, It. <ets>tamburo</ets>; all fr. Ar. & Per. <ets>tamb<?/r</ets> a kind of lute, or giutar, or Per. <ets>tab<imac/r</ets> a drum.  Cf. <er>Tabouret</er>, <er>Tambour</er>.]</ety> <fld>(Mus.)</fld> <def>A small drum used as an accompaniment to a pipe or fife, both being played by the same person.</def> <altsp>[Written also <asp>tabour</asp>, and <asp>taber</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabor</ent><br/
<hw>Ta"bor</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tabored</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Taboring</conjf>.]</vmorph> <ety>[Cf. OF. <ets>taborer</ets>.]</ety> <altsp>[Written also <asp>tabour</asp>.]</altsp> <sn>1.</sn> <def>To play on a tabor, or little drum.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To strike lightly and frequently.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabor</ent><br/
<hw>Ta"bor</hw>, <pos>v. t.</pos> <def>To make (a sound) with a tabor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taborer</ent><br/
<hw>Ta"bor*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who plays on the tabor.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taboret</ent><br/
<hw>Tab"o*ret</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Dim. of <ets>tabor</ets>.  Cf. <er>Tabret</er>.]</ety> <fld>(Mus.)</fld> <def>A small tabor.</def> <altsp>[Written also <asp>tabouret</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taborine</ent><br/
<hw>Tab"o*rine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>tabourin</ets>, F. <ets>tambourin</ets>. See <er>Tabor</er>, and cf. <er>Tambourine</er>.]</ety> <fld>(Mus.)</fld> <def>A small, shallow drum; a tabor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taborite</ent><br/
<hw>Ta"bor*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Eccl. Hist.)</fld> <def>One of certain Bohemian reformers who suffered persecution in the fifteenth century; -- so called from <xex>Tabor</xex>, a hill or fortress where they encamped during a part of their struggles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabour</ent><br/
<hw>Ta"bour</hw> <pr>(?)</pr>, <pos>n. & v.</pos> <def>See <er>Tabor</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabouret</ent><br/
<hw>Tab"ou*ret</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., dim. of OF. <ets>tabor</ets>, <ets>tabour</ets>, drum. See <er>Tabor</er>.]</ety> <sn>1.</sn> <def>Same as <er>Taboret</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A seat without arms or back, cushioned and stuffed: a high stool; -- so called from its resemblance to a drum.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An embroidery frame.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Right of the tabouret</b></col>, <cd>the privilege of sitting on a tabouret in the presence of the severeign, formerly granted to certain ladies of high rank at the French court.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabrere</ent><br/
<hw>Tab"rere</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A taborer.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabret</ent><br/
<hw>Tab"ret</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A taboret.</def>  <rj><au>Young.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabu</ent><br/
<hw>Ta*bu"</hw> <pr>(?)</pr>, <pos>n. & v.</pos> <def>See <er>Taboo</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabula</ent><br/
\'d8<hw>Tab"u*la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tabulae</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <sn>1.</sn> <def>A table; a tablet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>One of the transverse plants found in the calicles of certain corals and hydroids.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tabula rasa</b></col> <pr>(<?/)</pr> <ety>[L.]</ety>, <cd>a smoothed tablet; hence, figuratively, the mind in its earliest state, before receiving impressions from without; -- a term used by Hobbes, Locke, and others, in maintaining a theory opposed to the doctrine of <xex>innate ideas</xex>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabular</ent><br/
<hw>Tab"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tabularis</ets>, fr. <ets>tabula</ets> a board, table. See <er>Table</er>.]</ety> <def>Having the form of, or pertaining to, a table (in any of the uses of the word).</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>Having a flat surface; <as>as, a <ex>tabular</ex> rock</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>Formed into a succession of flakes; laminated.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Nodules . . . that are <qex>tabular</qex> and plated.</q> <rj><qau>Woodward.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>Set in squares.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>Arranged in a schedule; <as>as, <ex>tabular</ex> statistics</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(e)</sd> <def>Derived from, or computed by, the use of tables; <as>as, <ex>tabular</ex> right ascension</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tabular difference</b></col> <fld>(Math.)</fld>, <cd>the difference between two consecutive numbers in a table, sometimes printed in its proper place in the table.</cd> -- <col><b>Tabular spar</b></col> <fld>(Min.)</fld>, <cd>wollastonite.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabularization</ent><br/
<hw>Tab`u*lar*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of tabularizing, or the state of being tabularized; formation into tables; tabulation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabularize</ent><br/
<hw>Tab"u*lar*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tabularized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tabularizing</conjf> <pr>(?)</pr>.]</vmorph> <def>To tabulate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabulata</ent><br/
\'d8<hw>Tab`u*la"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>tabulatus</ets> floored.]</ety> <fld>(Zool.)</fld> <def>An artificial group of stony corals including those which have transverse septa in the calicles. The genera <gen>Pocillopora</gen> and Favosites are examples.</def>
<-- ## note that Pocillopora is italicised but not listed separately in this dictionary.  Favosites is not italicised, and has an entry as a headword.  Is that the difference between italicisation  or not for genus names? --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabulate</ent><br/
<hw>Tab"u*late</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tabulated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tabulating</conjf>.]</vmorph> <ety>[L. <ets>tabula</ets> a table. See <er>Tabular</er>.]</ety> <sn>1.</sn> <def>To form into a table or tables; to reduce to tables or synopses.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A philosophy is not worth the having, unless its results may be <qex>tabulated</qex>, and put in figures.</q> <rj><qau>I. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To shape with a flat surface.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tabulation</ent><br/
<hw>Tab`u*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of forming into a table or tables; <as>as, the <ex>tabulation</ex> of statistics</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tac</ent><br/
<hw>Tac</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Tack</er>, <pos>n.</pos>, 4.]</ety> <fld>(O. Eng. Law)</fld> <def>A kind of customary payment by a tenant; -- a word used in old records.</def>  <rj><au>Cowell.</au>  <au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tacamahaca</ent><br/
<ent>Tacamahac</ent><br/
<mhw>{ <hw>Tac"a*ma*hac`</hw> <pr>(?)</pr>, <hw>Tac`a*ma*ha"ca</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <sn>1.</sn> <def>A bitter balsamic resin obtained from tropical American trees of the genus <gen>Elaphrium</gen> (<spn>Elaphrium tomentosum</spn> and <spn>Elaphrium Tacamahaca</spn>), and also from East Indian trees of the genus <gen>Calophyllum</gen>; also, the resinous exhudation of the balsam poplar.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Any tree yielding tacamahac resin, especially, in North America, the balsam poplar, or balm of Gilead (<spn>Populus balsamifera</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tacaud</ent><br/
<hw>Ta*caud"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tacaud</ets>. See <er>Tomcod</er>.]</ety> <fld>(Zool.)</fld> <def>The bib, or whiting pout.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tac-au-tac</ent><br/
\'d8<hw>Tac`-au-tac"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. <ets>riposter du tac au tac</ets> to parry (where <ets>tac</ets> imitates the sound made by the steel).]</ety> <fld>(Fencing)</fld> <def>The parry which is connected with a riposte; also, a series of quick attacks and parries in which neither fencer gains a point.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tace</ent><br/
<hw>Tace</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The cross, or church, of St. Antony. See <xex>Illust.</xex> (6), under <er>Cross</er>, <pos>n.</pos></def>  <rj><au>Mollett.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tace</ent><br/
<hw>Tace</hw>, <pos>n.</pos> <def>See <er>Tasse</er>.</def>  <rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tacet</ent><br/
\'d8<hw>Ta"cet</hw> <pr>(?)</pr>, <pos>v. impers.</pos> <ety>[L., it is silent, 3d pers.pr. of <ets>tacere</ets> to be silent.]</ety> <fld>(Mus.)</fld> <def>It is silent; -- a direction for a vocal or instrumental part to be silent during a whole movement.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tache</ent><br/
<hw>Tache</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tack</er> a kind of nail.]</ety> <def>Something used for taking hold or holding; a catch; a loop; a button.</def> <mark>[Obs.]</mark>  <rj><au>Ex. xxvi. 6.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tache</ent><br/
<hw>Tache</hw>, <pos>n.</pos> <ety>[F. <ets>tache</ets> spot. See <er>Techy</er>.]</ety> <def>A spot, stain, or blemish.</def> <mark>[Obs.]</mark>  <rj><au>Warner.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tachhydrite</ent><br/
<hw>Tach*hy"drite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>tachy`s</grk> quick + <grk>"y`dwr</grk> water.  So named from its ready deliquescence.]</ety> <fld>(Min.)</fld> <def>A hydrous chloride of calcium and magnesium occurring in yellowish masses which rapidly deliquesce upon exposure.  It is found in the salt mines at <city>Stassfurt</city>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tachina</ent><br/
\'d8<hw>Tach"i*na</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tachinae</plw> <pr>(#)</pr>.</plu> <ety>[NL., fr. Gr. <grk>tachino`s</grk>, for <grk>tachy`s</grk> swift.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of Diptera belonging to <gen>Tachina</gen> and allied genera.  Their larvae are external parasites of other insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tachistoscope</ent><br/
<hw>Ta*chis"to*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>ta`chistos</grk>, superl. of <grk>tachy`s</grk> swift + <ets>-scope</ets>.]</ety> <fld>(Physiol.)</fld> <def>An apparatus for exposing briefly to view a screen bearing letters or figures.  It is used in studying the range of attention, or the power of distinguishing separate objects in a single impression.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tachograph</ent><br/
<hw>Tach"o*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>ta`chos</grk> speed + <ets>-graph</ets>.]</ety> <def>A recording or registering tachometer; also, its autographic record.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tachometer</ent><br/
<hw>Ta*chom"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>ta`chos</grk> swiftness, speed (fr. <grk>tachy`s</grk> quick) + <ets>-meter</ets>: cf. F. <ets>tachom<egrave/tre</ets>.]</ety> <def>An instrument for measuring the velocity, or indicating changes in the velocity, of a moving body or substance.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>An instrument for measuring the velocity of running water in a river or canal, consisting of a wheel with inclined vanes, which is turned by the current.  The rotations of the wheel are recorded by clockwork.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>An instrument for showing at any moment the speed of a revolving shaft, consisting of a delicate revolving conical pendulum which is driven by the shaft, and the action of which by change of speed moves a pointer which indicates the speed on a graduated dial.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <fld>(Physiol.)</fld> <def>An instrument for measuring the velocity of the blood; a haematachometer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tachometry</ent><br/
<hw>Ta*chom"e*try</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Measurement by a tachometer; the science or use of tachometers.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tachydidaxy</ent><br/
<hw>Tach"y*di*dax`y</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>tachy`s</grk> quick + <grk>di`daxis</grk> teaching.]</ety> <def>A short or rapid method of instructing.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tachyglossa</ent><br/
\'d8<hw>Tach`y*glos"sa</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>tachy`s</grk> quick + <grk>glw^ssa</grk> tongue.]</ety> <fld>(Zool.)</fld> <def>A division of monotremes which comprises the spiny ant-eaters of Australia and New Guinea. See <xex>Illust.</xex> under <er>Echidna</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tachygraph</ent><br/
<hw>Tach"y*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An example of tachygraphy; esp., an ancient Greek or Roman tachygraphic manuscript.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tachygrapher</ent><br/
<hw>Ta*chyg"ra*pher</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ a fast writer.]</ety> <def>One who writes shorthand; a stenographer; esp., an ancient Greek or Roman notary.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tachygraphical</ent><br/
<ent>Tachygraphic</ent><br/
<mhw>{ <hw>Tach`y*graph"ic</hw> <pr>(?)</pr>, <hw>Tach`y*graph"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>tachygraphique</ets>.]</ety> <def>Of or pertaining to tachygraphy; written in shorthand.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tachygraphy</ent><br/
<hw>Ta*chyg"ra*phy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>tachy`s</grk> quick + <ets>-graphy</ets>: cf. F. <ets>tachygraphie</ets>.]</ety> <def>The art or practice of rapid writing; shorthand writing; stenography.</def>  <rj><au>I. Taylor (The Alphabet).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tachylyte</ent><br/
<hw>Tach"y*lyte</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>tachy`s</grk> quick + <grk>ly`ein</grk> to dissolve.]</ety> <fld>(Min.)</fld> <def>A vitreous form of basalt; -- so called because decomposable by acids and readily fusible.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tachymeter</ent><br/
<hw>Ta*chym"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos>  <ety>[<ets>Tachy-</ets> + <ets>-meter</ets>.]</ety> <sn>1.</sn> <fld>(Surveying)</fld> <def>An instrument, esp. a transit or theodolite with stadia wires, for determining quickly the distances, bearings, and elevations of distant objects.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>A speed indicator; a tachometer.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tachymetry</ent><br/
<hw>Ta*chym"e*try</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The science or use of the tachymeter.</def> -- <wordforms><wf>Ta`chy*met"ric</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tachyscope</ent><br/
<hw>Tach"y*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>tachy`s</grk> quick + <ets>-scope</ets>.]</ety> <def>An early form of animated-picture machine, devised in 1889 by <person>Otto Ansch<uum/tz</person> of <city>Berlin</city>, in which the chronophotographs were mounted upon the periphery of a rotating wheel.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tacit</ent><br/
<hw>Tac"it</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tacitus</ets>, p. p. of <ets>tacere</ets> to be silent, to pass over in silence; akin to Goth. <ets><thorn/ahan</ets> to be silent, Icel. <ets><thorn/egja</ets>, OHG. <ets>dag<emac/n</ets>: cf. F. <ets>tacite</ets>.  Cf. <er>Reticent</er>.]</ety> <def>Done or made in silence; implied, but not expressed; silent; <as>as, <ex>tacit</ex> consent is consent by silence, or by not interposing an objection</as>.</def> -- <wordforms><wf>Tac"it*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>tacit</qex> and secret theft of abusing our brother in civil contracts.</q> <rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taciturn</ent><br/
<hw>Tac"i*turn</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>taciturnus</ets>: cf. F. <ets>taciturne</ets>. See <er>Tacit</er>.]</ety> <def>Habitually silent; not given to converse; not apt to talk or speak.</def> -- <wordforms><wf>Tac"i*turn*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Silent; reserved.</syn> <usage> <er>Taciturn</er>, <er>Silent</er>. <xex>Silent</xex> has reference to the act; <xex>taciturn</xex>, to the habit.  A man may be <xex>silent</xex> from circumstances; he is <xex>taciturn</xex> from disposition.  The loquacious man is at times <xex>silent</xex>; one who is <xex>taciturn</xex> may now and then make an effort at conversation.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taciturnity</ent><br/
<hw>Tac`i*tur"ni*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>taciturnitas</ets>: cf. F. <ets>taciturnit<eacute/</ets>.]</ety> <def>Habitual silence, or reserve in speaking.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The cause of Addison's <qex>taciturnity</qex> was a natural diffidence in the company of strangers.</q> <rj><qau>V. Knox.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>taciturnity</qex> and the short answers which gave so much offense.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tack</ent><br/
<hw>Tack</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From an old or dialectal form of F. <ets>tache</ets>. See <er>Techy</er>.]</ety> <sn>1.</sn> <def>A stain; a tache.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[Cf. L. <ets>tactus</ets>.]</ety> <def>A peculiar flavor or taint; <as>as, a musty <ex>tack</ex></as>.</def> <mark>[Obs. or Colloq.]</mark>  <rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tack</ent><br/
<hw>Tack</hw>, <pos>n.</pos> <ety>[OE. <ets>tak</ets>, <ets>takke</ets>, a fastening; akin to D. <ets>tak</ets> a branch, twig, G. <ets>zacke</ets> a twig, prong, spike, Dan. <ets>takke</ets> a tack, spike; cf. also Sw. <ets>tagg</ets> prickle, point, Icel. <ets>t<amac/g</ets> a willow twig, Ir. <ets>taca</ets> a peg, nail, fastening, Gael. <ets>tacaid</ets>, Armor. & Corn. <ets>tach</ets>; perhaps akin to E. <ets>take</ets>.  Cf. <er>Attach</er>, <er>Attack</er>, <er>Detach</er>, <er>Tag</er> an end, <er>Zigzag</er>.]</ety> <sn>1.</sn> <def>A small, short, sharp-pointed nail, usually having a broad, flat head.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is attached; a supplement; an appendix. See <er>Tack</er>, <pos>v. t.</pos>, 3.</def>  <rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Some <qex>tacks</qex> had been made to money bills in King Charles's time.</q> <rj><qau>Bp. Burnet.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1468 --><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Naut.)</fld> <sd>(a)</sd> <def>A rope used to hold in place the foremost lower corners of the courses when the vessel is closehauled (see <xex>Illust.</xex> of <er>Ship</er>); also, a rope employed to pull the lower corner of a studding sail to the boom.</def> <sd>(b)</sd> <def>The part of a sail to which the tack is usually fastened; the foremost lower corner of fore-and-aft sails, as of schooners (see <xex>Illust.</xex> of <er>Sail</er>).</def> <sd>(c)</sd> <def>The direction of a vessel in regard to the trim of her sails; <as>as, the starboard <ex>tack</ex>, or port <ex>tack</ex></as>; -- the former when she is closehauled with the wind on her starboard side; hence, the run of a vessel on one tack; also, a change of direction; <as>as, to take a different <ex>tack</ex>; -- often used metaphorically</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Scots Law)</fld> <def>A contract by which the use of a thing is set, or let, for hire; a lease.</def>  <rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Confidence; reliance.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tack of a flag</b></col> <fld>(Naut.)</fld>, <cd>a line spliced into the eye at the foot of the hoist for securing the flag to the halyards.</cd> -- <col><b>Tack pins</b></col> <fld>(Naut.)</fld>, <cd>belaying pins; -- also called <altname>jack pins</altname>.</cd> -- <col><b>To haul the tacks aboard</b></col> <fld>(Naut.)</fld>, <cd>to set the courses.</cd> -- <col><b>To hold tack</b></col>, <cd>to last or hold out.</cd> <au>Milton.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tack</ent><br/
<hw>Tack</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tacked</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tacking</conjf>.]</vmorph> <ety>[Cf. OD. <ets>tacken</ets> to touch, take, seize, fix, akin to E. <ets>take</ets>. See <er>Tack</er> a small nail.]</ety> <sn>1.</sn> <def>To fasten or attach.</def> <ldquo/In hopes of getting some commendam <xex>tacked</xex> to their sees.<rdquo/  <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And <qex>tacks</qex> the center to the sphere.</q> <rj><qau>Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Especially, to attach or secure in a slight or hasty manner, as by stitching or nailing; <as>as, to <ex>tack</ex> together the sheets of a book; to <ex>tack</ex> one piece of cloth to another; to <ex>tack</ex> on a board or shingle; to <ex>tack</ex> one piece of metal to another by drops of solder.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>In parliamentary usage, to add (a supplement) to a bill; to append; -- often with <xex>on</xex> or <xex>to</xex>; <as>as, to <ex>tack</ex> on a non-germane appropriation to a bill</as>.</def>  <rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Naut.)</fld> <def>To change the direction of (a vessel) when sailing closehauled, by putting the helm alee and shifting the tacks and sails so that she will proceed to windward nearly at right angles to her former course.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In tacking, a vessel is brought to point at first directly to windward, and then so that the wind will blow against the other side.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tack</ent><br/
<hw>Tack</hw>, <pos>v. i.</pos> <fld>(Naut.)</fld> <def>To change the direction of a vessel by shifting the position of the helm and sails; also (as said of a vessel), to have her direction changed through the shifting of the helm and sails. See <er>Tack</er>, <pos>v. t.</pos>, 4.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Monk, . . . when he wanted his ship to <qex>tack</qex> to larboard, moved the mirth of his crew by calling out, <ldquo/Wheel to the left.<rdquo/</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tacker</ent><br/
<hw>Tack"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who tacks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tacket</ent><br/
<hw>Tack"et</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Dim. of <ets>tack</ets> a small nail.]</ety> <def>A small, broad-headed nail.</def> <mark>[Scot.]</mark>  <rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tackey</ent><br/
<hw>Tack"ey</hw> <pr>(?)</pr>, <pos>a. & n.</pos> <def>See <er>Tacky</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tacking</ent><br/
<hw>Tack"ing</hw>, <pos>n.</pos> <fld>(Law)</fld> <def>A union of securities given at different times, all of which must be redeemed before an intermediate purchaser can interpose his claim.</def>  <rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The doctrine of <xex>tacking</xex> is not recognized in American law.</note>  <rj><au>Kent.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tackle</ent><br/
<hw>Tac"kle</hw> <pr>(?; sometimes improperly pronounced ?, especially by seamen)</pr>, <pos>n.</pos> <ety>[OE. <ets>takel</ets>, akin to LG. & D. <ets>takel</ets>, Dan. <ets>takkel</ets>, Sw. <ets>tackel</ets>; perhaps akin to E. <ets>taw</ets>, v. t., or to <ets>take</ets>.]</ety> <sn>1.</sn> <def>Apparatus for raising or lowering heavy weights, consisting of a rope and pulley blocks; sometimes, the rope and attachments, as distinct from the block, in which case the full appratus is referred to as a <altname>block and tackle</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any instruments of action; an apparatus by which an object is moved or operated; gear; <as>as, fishing <ex>tackle</ex>, hunting <ex>tackle</ex></as>; formerly, specifically, weapons.</def> <ldquo/She to her <xex>tackle</xex> fell.<rdquo/  <rj><au>Hudibras.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In Chaucer, it denotes usually an arrow or arrows.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Naut.)</fld> <def>The rigging and apparatus of a ship; also, any purchase where more than one block is used.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Fall and tackle</b></col>. <cd>See the Note under <er>Pulley</er>.</cd> -- <col><b>Fishing tackle</b></col>. <cd>See under <er>Fishing</er>, <pos>a.</pos></cd> -- <col><b>Ground tackle</b></col> <fld>(Naut.)</fld>, <cd>anchors, cables, etc.</cd> -- <col><b>Gun tackle</b></col>, <cd>the apparatus or appliances for hauling cannon in or out.</cd> -- <col><b>Tackle fall</b></col>, <cd>the rope, or rather the end of the rope, of a tackle, to which the power is applied.</cd> -- <col><b>Tack tackle</b></col> <fld>(Naut.)</fld>, <cd>a small tackle to pull down the tacks of the principal sails.</cd> -- <mcol><col><b>Tackle board</b></col>, <col><b>Tackle post</b></col></mcol> <fld>(Ropemaking)</fld>, <cd>a board, frame, or post, at the end of a ropewalk, for supporting the spindels, or whirls, for twisting the yarns.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>tackle</ent><br/
<hw>tac"kle</hw> <pos>n.</pos> <fld>(Football)</fld> <sn>1.</sn> <def>An act of tackling{4}; <as>as, brought down by a <ex>tackle</ex> by a lineman</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn>  <fld>(Football)</fld> <def>One of two linemen on a football team, occupying a position between the guard and an end; also, the position played by such a tackle.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tackle</ent><br/
<hw>Tac"kle</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tackled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tackling</conjf>.]</vmorph> <ety>[Cf. LG. <ets>takeln</ets> to equip. See <er>Tackle</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To supply with tackle.</def>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To fasten or attach, as with a tackle; to harness; <as>as, to <ex>tackle</ex> a horse into a coach or wagon</as>.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To seize; to lay hold of; to grapple; <as>as, a wrestler <ex>tackles</ex> his antagonist; a dog <ex>tackles</ex> the game.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The greatest poetess of our day has wasted her time and strength in <qex>tackling</qex> windmills under conditions the most fitted to insure her defeat.</q> <rj><qau>Dublin Univ. Mag.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Football)</fld> <def>To cause the ball carrier to fall to the ground, thus ending the forward motion of the ball and the play.</def><br/
[<source>PJC</source>]</p>

<p><sn>5.</sn> <def>To begin to deal with; <as>as, to <ex>tackle</ex> the problem</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tackled</ent><br/
<hw>Tac"kled</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Made of ropes tacked together.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>My man shall be with thee,<br/
And bring thee cords made like a <qex>tackled</qex> stair.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tackling</ent><br/
<hw>Tac"kling</hw>, <pos>n.</pos> <fld>(Naut.)</fld> <sn>1.</sn> <def>Furniture of the masts and yards of a vessel, as cordage, sails, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Instruments of action; <as>as, fishing <ex>tackling</ex></as>.</def>  <rj><au>Walton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The straps and fixures adjusted to an animal, by which he draws a carriage, or the like; harness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tacksman</ent><br/
<hw>Tacks"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tacksmen</plw> <pr>(?)</pr>.</plu> <fld>(Scots Law)</fld> <def>One who holds a tack or lease from another; a tenant, or lessee.</def>  <rj><au>Sir W. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>tacksmen</qex>, who formed what may be called the <ldquo/peerage<rdquo/ of the little community, must be the captains.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tacky</ent><br/
<hw>Tack"y</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. <er>Techy</er>, <er>Tack</er> a spot.]</ety> <def>Sticky; somewhat adhesive;; -- said of paint, varnish, etc., when not well dried.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tacky</ent><br/
<hw>Tack"y</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Etymol. uncert.]</ety> <sn>1.</sn> <def>Dowdy, shabby, or neglected in appearance; unkempt.</def> <mark>[Local, U. S.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>In poor taste; appearing cheap; gaudy; unstylish.  Broadly used to describe objects whose style is disapproved of by the speaker.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>Tactless; in poor taste; -- used to describe behavior.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tacky</ent><br/
<hw>Tack"y</hw>, <pos>n.</pos> <altsp>[Written also <asp>tackey</asp>.]</altsp> <def>An ill-conditioned, ill-fed, or neglected horse; also, a person in a like condition.</def> <mark>[Southern U. S.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taconic</ent><br/
<hw>Ta*con"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Geol.)</fld> <def>Designating, or pertaining to, the series of rocks forming the <etsep>Taconic</etsep> mountains in Western New England.  They were once supposed to be older than the Cambrian, but later proved to belong to the Lower Silurian and Cambrian.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tact</ent><br/
<hw>Tact</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tactus</ets> a touching, touch, fr. <ets>tangere</ets>, <ets>tactum</ets>, to touch: cf. F. <ets>tact</ets>. See <er>Tangent</er>.]</ety> <sn>1.</sn> <def>The sense of touch; feeling.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Did you suppose that I could not make myself sensible to <qex>tact</qex> as well as sight?</q> <rj><qau>Southey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Now, sight is a very refined <qex>tact</qex>.</q> <rj><qau>J. Le Conte.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>The stroke in beating time.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Sensitive mental touch; peculiar skill or faculty; nice perception or discernment; ready power of appreciating and doing what is required by circumstances.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He had formed plans not inferior in grandeur and boldness to those of Richelieu, and had carried them into effect with a <qex>tact</qex> and wariness worthy of Mazarin.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>tact</qex> which surpassed the <qex>tact</qex> of her sex as much as the <qex>tact</qex> of her sex surpassed the <qex>tact</qex> of ours.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tactable</ent><br/
<hw>Tac"ta*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being touched; tangible.</def> <mark>[R.]</mark> <ldquo/They [women] being created to be both tractable and <xex>tactable</xex>.<rdquo/  <rj><au>Massinger.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tactful</ent><br/
<hw>Tact"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Full of tact; characterized by a discerning sense of what is right, proper, or judicious.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tactical</ent><br/
<ent>Tactic</ent><br/
<mhw>{ <hw>Tac"tic</hw> <pr>(?)</pr>, <hw>Tac"tic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Gr. <grk>taktiko`s</grk>. See <er>tactics</er>.]</ety> <def>Of or pertaining to military or naval tactics; hence, pertaining to, or characterized by, planning or maneuvering for the short term; -- contrasted with <contr>strategic</contr>, planning for the long term.</def><br/ -- <wordforms><wf>Tac"tic*al*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tactic</ent><br/
<hw>Tac"tic</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tactics</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tactician</ent><br/
<hw>Tac*ti"cian</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tacticien</ets>.]</ety> <def>One versed in tactics; hence, a skillful maneuverer; an adroit manager.</def>
<-- as, a skilled parliamentary tactician. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tactics</ent><br/
<hw>Tac"tics</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>taktika`</grk> pl., and <grk>taktikh`</grk> (sc. <grk>te`chnh</grk>, sing., fr. <grk>taktiko`s</grk> fit for ordering or arranging, fr. <grk>ta`ssein</grk>, <grk>ta`ttein</grk>, to put in order, to arrange: cf. F. <ets>tactique</ets>.]</ety> <sn>1.</sn> <def>The science and art of disposing military and naval forces in order for battle, and performing military and naval evolutions. It is divided into <xex>grand tactics</xex>, or the tactics of battles, and <xex>elementary tactics</xex>, or the tactics of instruction.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, any system or method of procedure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tactile</ent><br/
<hw>Tac"tile</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tactilis</ets>, fr. <ets>tangere</ets>, <ets>tactum</ets>, to touch: cf. F. <ets>tactile</ets>.]</ety> <def>Of or pertaining to the organs, or the sense, of touch; perceiving, or perceptible, by the touch; capable of being touched; <as>as, <ex>tactile</ex> corpuscles; <ex>tactile</ex> sensations.</as></def> <ldquo/<xex>Tactile</xex> sweets.<rdquo/ <au>Beaumont.</au> <ldquo/<xex>Tactile</xex> qualities.<rdquo/ <au>Sir M. Hale.</au><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tactile</b></col><cd> sense <fld>(Physiol.)</fld>, the sense of touch, or pressure sense. See <er>Touch</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>The delicacy of the <qex>tactile</qex> sense varies on different parts of the skin; it is geatest on the forehead, temples and back of the forearm.</q> <rj><qau>H. N. Martin.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tactility</ent><br/
<hw>Tac*til"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tactilit<eacute/</ets>.]</ety> <def>The quality or state of being tactile; perceptibility by touch; tangibleness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taction</ent><br/
<hw>Tac"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tactio</ets>, from <ets>tangere</ets>, <ets>tactum</ets>, to touch.]</ety> <def>The act of touching; touch; contact; tangency.</def> <ldquo/External <xex>taction</xex>.<rdquo/  <rj><au>Chesterfield.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tactless</ent><br/
<hw>Tact"less</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Destitute of tact.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tactual</ent><br/
<hw>Tac"tu*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Tact</er>.]</ety> <fld>(Physiol.)</fld> <def>Of or pertaining to the sense, or the organs, of touch; derived from touch.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In the lowest organisms we have a kind of <qex>tactual</qex> sense diffused over the entire body.</q> <rj><qau>Tyndall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tadpole</ent><br/
<hw>Tad"pole`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>tadde</ets> toad (AS. <ets>t<amac/die</ets>, <ets>t<amac/dige</ets>) + <ets>poll</ets>; properly, a toad that is or seems all head. See <er>Toad</er>, and <er>Poll</er>.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>The young aquatic larva of any amphibian. In this stage it breathes by means of external or internal gills, is at first destitute of legs, and has a finlike tail. Called also <altname>polliwig</altname>, <altname>polliwog</altname>, <altname>porwiggle</altname>, or <altname>purwiggy</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The hooded merganser.</def> <mark>[Local, U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tadpole fish</b></col>. <fld>(Zool.)</fld> <cd>See <er>Forkbeard</er> <sd>(a)</sd>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taedium</ent><br/
\'d8<hw>Tae"di*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>See <er>Tedium</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tael</ent><br/
<hw>Tael</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Malay <ets>ta<icr/l</ets>, a certain weight, probably fr. Hind. <ets>tola</ets>, Skr. <ets>tul<amac/</ets> a balance, weight, <ets>tul</ets> to weigh.]</ety> <def>A denomination of money, in China, worth nearly six shillings sterling, or about a dollar and forty cents; also, a weight of one ounce and a third.</def> <altsp>[Written also <asp>tale</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ta'en</ent><br/
<ent>Taen</ent><br/
<mhw>{ <hw>Taen</hw> <pr>(?)</pr>, <it>or</it> <hw>Ta'en</hw>  }</mhw>, <def><pos>p. p.</pos> of <er>Ta</er>, to take, or a contraction of <er>Taken</er>.</def> <mark>[Poetic & Scot.]</mark>  <rj><au>Burns.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taenia</ent><br/
\'d8<hw>Tae"ni*a</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Taeniae</plw> <pr>(#)</pr>.</plu> <ety>[L., a ribbon, a tapeworm.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>A genus of intestinal worms which includes the common tapeworms of man. See <er>Tapeworm</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>A band; a structural line; -- applied to several bands and lines of nervous matter in the brain.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Arch.)</fld> <def>The fillet, or band, at the bottom of a Doric frieze, separating it from the architrave.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teniacide</ent><br/
<ent>Taeniacide</ent><br/
<mhw>{ <hw>Tae"ni*a*cide`</hw> <pr>(?)</pr>, <pos>n.</pos> Also <hw>Te"ni*a*cide`</hw>  }</mhw>. <ety>[<ets>Taenia</ets> + <ets>-cide</ets>.]</ety> <fld>(Med.)</fld> <def>A remedy to destroy tapeworms.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taeniada</ent><br/
\'d8<hw>Tae*ni"a*da</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Taenioidea</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teniafuge</ent><br/
<ent>Taeniafuge</ent><br/
<mhw>{ <hw>Tae"ni*a*fuge`</hw> <pr>(?)</pr>, <pos>n.</pos> Also <hw>Te"ni*a*fuge`</hw> }</mhw>. <ety>[<ets>Taenia</ets> + L. <ets>fugare</ets> to drive away.]</ety> <fld>(Med.)</fld> <def>A remedy to expel tapeworms.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Teniasis</ent><br/
<ent>Taeniasis</ent><br/
<mhw>{ \'d8<hw>Tae*ni"a*sis</hw> <pr>(?)</pr>, <pos>n.</pos> Also \'d8<hw>Te*ni"a*sis</hw> }</mhw>. <ety>[NL. See <er>Taenia</er>.]</ety> <fld>(Med.)</fld> <def>Ill health due to taenia, or tapeworms.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taeniata</ent><br/
\'d8<hw>Tae`ni*a"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>taenia</ets> a ribbon.]</ety> <fld>(Zool.)</fld> <def>A division of Ctenophora including those which have a long, ribbonlike body. The Venus's girdle is the most familiar example.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taenidium</ent><br/
\'d8<hw>Tae*nid"i*um</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Taenidia</plw> <pr>(#)</pr>.</plu> <ety>[NL., dim. fr. L. <ets>taenia</ets> a ribbon.]</ety> <fld>(Zool.)</fld> <def>The chitinous fiber forming the spiral thread of the tracheae of insects. See <xex>Illust.</xex> of <er>Trachea</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taenioglossa</ent><br/
\'d8<hw>Tae`ni*o*glos"sa</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>taini`a</grk> a ribbon + <grk>glw^ssa</grk> a tongue.]</ety> <fld>(Zool.)</fld> <def>An extensive division of gastropod mollusks in which the odontophore is long and narrow, and usually bears seven rows of teeth.  It includes a large number of families both marine and fresh-water.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taenioglossate</ent><br/
<hw>Tae`ni*o*glos"sate</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Of or pertaining to the Taenioglossa.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taenioid</ent><br/
<hw>Tae"ni*oid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Taenia</ets> + <ets>-oid</ets>.]</ety> <sn>1.</sn> <def>Ribbonlike; shaped like a ribbon.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>Like or pertaining to Taenia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taenioidea</ent><br/
\'d8<hw>Tae`ni*oi"de*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <fld>(Zool.)</fld> <def>The division of cestode worms which comprises the tapeworms. See <er>Tapeworm</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taeniola</ent><br/
\'d8<hw>Tae*ni"o*la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Taeniolae</plw> <pr>(#)</pr>.</plu> <ety>[L., dim. of <ets>taenia</ets> a ribbon.]</ety> <fld>(Zool.)</fld> <def>One of the radial partitions which separate the internal cavities of certain medusae.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taeniosomi</ent><br/
\'d8<hw>Tae`ni*o*so"mi</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>taini`a</grk> ribbon + <grk>sw^ma</grk> body.]</ety> <fld>(Zool.)</fld> <def>An order of fishes remarkable for their long and compressed form. The ribbon fishes are examples. See <cref>Ribbon fish</cref>, under <er>Ribbon</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tafferer</ent><br/
<hw>Taf"fer*er</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Naut.)</fld> <def>See <er>Taffrail</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taffety</ent><br/
<ent>Taffeta</ent><br/
<mhw>{ <hw>Taf"fe*ta</hw> <pr>(?)</pr>, <hw>Taf"fe*ty</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[F. <ets>taffetas</ets>, It. <ets>taffet<agrave/</ets>, from Per. <ets>t<amac/ftah</ets>, originally, twisted, woven, from <ets>t<amac/ftan</ets> to twist, to spin.]</ety> <def>A fine, smooth stuff of silk, having usually the wavy luster called <xex>watering</xex>. The term has also been applied to different kinds of silk goods, from the 16th century to modern times.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Lined with <qex>taffeta</qex> and with sendal.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taffrail</ent><br/
<hw>Taff"rail</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[D. <ets>tafereel</ets> a panel, picture, fr. <ets>tafel</ets> table, fr. L. <ets>tabula</ets>. See <er>Table</er>.]</ety> <fld>(Naut.)</fld> <def>The upper part of a ship's stern, which is flat like a table on the top, and sometimes ornamented with carved work; the rail around a ship's stern.</def> <altsp>[Written also <asp>tafferel</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taffy</ent><br/
<hw>Taf"fy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Prov. E. <ets>taffy</ets> toffy.]</ety> <sn>1.</sn> <def>A kind of candy made of molasses or brown sugar boiled down and poured out in shallow pans.</def> <altsp>[Written also, in England, <asp>toffy</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Flattery; soft phrases.</def> <mark>[Slang]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tafia</ent><br/
<hw>Taf"i*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. & Sp. <ets>tafia</ets>, It. <ets>taffia</ets>; fr. Malay <ets>t<amac/f<imac/a</ets> a spirit distilled from molasses.  Cf. <er>Ratafia</er>.]</ety> <def>A variety of rum.</def> <mark>[West Indies]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tag</ent><br/
<hw>Tag</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Probably akin to <ets>tack</ets> a small nail; cf. Sw. <ets>tagg</ets> a prickle, point, tooth.]</ety> <sn>1.</sn> <def>Any slight appendage, as to an article of dress; something slight hanging loosely; specifically, a direction card, or label.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A metallic binding, tube, or point, at the end of a string, or lace, to stiffen it.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The end, or catchword, of an actor's speech; cue.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Something mean and paltry; the rabble.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tag and rag</b></col>, <cd>the lowest sort; the rabble.</cd> <au>Holinshed.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A sheep of the first year.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tag</ent><br/
<hw>Tag</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tagged</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tagging</conjf> <pr>(?)</pr>.]</vmorph> <sn>1.</sn> <def>To fit with, or as with, a tag or tags.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He learned to make long-<qex>tagged</qex> thread laces.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His courteous host . . . <br/
<qex>Tags</qex> every sentence with some fawning word.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To join; to fasten; to attach.</def>  <rj><au>Bolingbroke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To follow closely after; esp., to follow and touch in the game of tag. See <er>Tag</er>, a play.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tag</ent><br/
<hw>Tag</hw>, <pos>v. i.</pos> <def>To follow closely, as it were an appendage; -- often with <xex>after</xex>; <as>as, to <ex>tag</ex> after a person</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tag</ent><br/
<hw>Tag</hw>, <pos>n.</pos> <ety>[From <er>Tag</er>, <pos>v.</pos>; cf. <er>Tag</er>, an end.]</ety> <def>A child's play in which one runs after and touches another, and then runs away to avoid being touched.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tagal</ent><br/
<hw>Ta*gal"</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One of a Malayan race, mainly of central Luzon, next to the Visayans the most numerous of the native peoples of the Philippines. Nearly all are Christians and many are highly educated.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>The language of the Tagals; Tagalog.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tagalog</ent><br/
<hw>Ta*ga"log</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Ethnol.)</fld> <def>Any member of a certain tribe which is one of the leading and most civilized of those native of the Philippine Islands.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>The language of the Tagalogs. It belongs to the Malay family of languages and is one of the most highly developed members of the family.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tagbelt</ent><br/
<hw>Tag"belt`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Far.)</fld> <def>Same as <er>Tagsore</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tag day</ent><br/
<hw>Tag day</hw>. <def>A day on which contributions to some public or private charity or fund are solicited promiscuously on the street, and tags given to contributors to wear as an evidence of their having contributed. Such solicitation is now subject to legal restriction in various places.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tagger</ent><br/
<hw>Tag"ger</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who, or that which, appends or joins one thing to another.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is pointed like a tag.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Hedgehogs' or procupines' small <qex>taggers</qex>.</q> <rj><qau>Cotton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <def>Sheets of tin or other plate which run below the gauge.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A device for removing taglocks from sheep.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- [Colloq.] One who spray-paints a distinctive logo on a wall or other property not his own. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taglet</ent><br/
<hw>Tag"let</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A little tag.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taglia</ent><br/
\'d8<hw>Tagl"ia</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It., a cutting, a pulley, from <ets>tagliare</ets> to cut. See <er>Tailor</er>.]</ety> <fld>(Mech.)</fld> <def>A peculiar combination of pulleys.</def>  <rj><au>Brande & C.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tagliacotain</ent><br/
<hw>Tagl`ia*co"tain</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Surg.)</fld> <def>Of or pertaining to <xex>Tagliacozzi</xex>, a Venetian surgeon; <as>as, the <ex>Tagliacotian</ex> operation, a method of rhinoplasty described by him</as>.</def> <altsp>[Also <asp>Taliacotian</asp>, and <asp>Tagliacozzian</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taglioni</ent><br/
<hw>Tagl*io"ni</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kind of outer coat, or overcoat; -- said to be so named after a celebrated Italian family of professional dancers.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He ought certainly to exchange his <qex>taglioni</qex>, or comfortable greatcoat, for a cuirass of steel.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taglock</ent><br/
<hw>Tag"lock`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An entangled lock, as of hair or wool.</def>  <rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tagnicate</ent><br/
<hw>Tag"ni*cate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The white-lipped peccary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tag-rag</ent><br/
<hw>Tag"-rag`</hw> <pr>(?)</pr>, <pos>n. & a.</pos> <ety>[See <er>Tag</er> an end, and <er>Rag</er>.]</ety> <def>The lowest class of people; the rabble.  Cf. <cref>Rag, tag, and bobtail</cref>, under <er>Bobtail</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If the <qex>tag-rag</qex> people did not clap him and hiss him, I am no true man.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tag sale</ent><br/
<hw>Tag sale</hw> <pr>(?)</pr>, <pos>n.</pos>  <ety>[From the price <ets>tag</ets> usually attached to each item.]</ety> <def>A sale of usually used items (such as furniture, clothing, household items or bric-a-brac), conducted by one or a small group of individuals, at a location which is not a normal retail establishment.</def> <note>Frequently it is held in the private home or in a yard attached to a private home belonging to the seller.  Similar to a <cref>yard sale</cref> or <cref>garage sale</cref>.  Compare <contr>flea market</contr>, where used items are sold by many individuals in a place rented for the purpose.</note><br/
[<source>PJC</source>]</p>

<p><ent>Tagsore</ent><br/
<hw>Tag"sore`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Far.)</fld> <def>Adhesion of the tail of a sheep to the wool from excoriation produced by contact with the feces; -- called also <altname>tagbelt</altname>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tagtail</ent><br/
<hw>Tag"tail`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A worm which has its tail conspicuously colored.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A person who attaches himself to another against the will of the latter; a hanger-on.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taguan</ent><br/
<hw>Tag"u*an</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native name in the East Indies.]</ety> <fld>(Zool.)</fld> <def>A large flying squirrel (<spn>Pteromys petuarista</spn>). Its body becomes two feet long, with a large bushy tail nearly as long.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1469 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taguicati</ent><br/
<hw>Ta`gui*ca"ti</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native name.]</ety> <fld>(Zool.)</fld> <def>The white-lipped peccary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taha</ent><br/
<hw>Ta"ha</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The African rufous-necked weaver bird (<spn>Hyphantornis texor</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tahaleb</ent><br/
<hw>Ta*ha"leb</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native name.]</ety> <fld>(Zool.)</fld> <def>A fox (<spn>Vulpes Niloticus</spn>) of Northern Africa.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tahitian</ent><br/
<hw>Ta*hi"ti*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to Tahiti, an island in the Pacific Ocean.</def> -- <def2><pos>n.</pos> <def>A native inhabitant of Tahiti.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tahr</ent><br/
<hw>Tahr</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Thar</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tai</ent><br/
<hw>Tai</hw> <pr>(t<aum/"<esl/)</pr>, <pos>a.</pos> <def>Designating, or pertaining to, the chief linguistic stock of Indo-China, including the peoples of Siamese and Shan speech.  It includes the Thai language.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tai</ent><br/
<hw>Tai</hw>, <pos>n.</pos> <def>A member of one of the tribes of the Tai stock.</def></p>

<p><q>The <qex>Tais</qex> first appeared in history in Yunnan, and from thence they migrated into Upper Burma. The earliest swarms appear to have entered that tract about two thousand years ago, and were small in number.</q>  <rj><qau>Census of India, 1901.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tail</ent><br/
<hw>Tail</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>taille</ets> a cutting. See <er>Entail</er>, <er>Tally</er>.]</ety> <fld>(Law)</fld> <def>Limitation; abridgment.</def>  <rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Estate in tail</b></col>, <cd>a limited, abridged, or reduced fee; an estate limited to certain heirs, and from which the other heirs are precluded; -- called also <altname>estate tail</altname>.</cd> <au>Blackstone.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tail</ent><br/
<hw>Tail</hw>, <pos>a.</pos> <fld>(Law)</fld> <def>Limited; abridged; reduced; curtailed; <as>as, estate <ex>tail</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tail</ent><br/
<hw>Tail</hw>, <pos>n.</pos> <ety>[AS. <ets>taegel</ets>, <ets>taegl</ets>; akin to G. <ets>zagel</ets>, Icel. <ets>tagl</ets>, Sw. <ets>tagel</ets>, Goth. <ets>tagl</ets> hair. <root/59.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>The terminal, and usually flexible, posterior appendage of an animal.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The tail of mammals and reptiles contains a series of movable vertebrae, and is covered with flesh and hairs or scales like those of other parts of the body. The tail of existing birds consists of several more or less consolidated vertebrae which supports a fanlike group of quills to which the term <xex>tail</xex> is more particularly applied. The tail of fishes consists of the tapering hind portion of the body ending in a caudal fin. The term <xex>tail</xex> is sometimes applied to the entire abdomen of a crustacean or insect, and sometimes to the terminal piece or pygidium alone.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any long, flexible terminal appendage; whatever resembles, in shape or position, the tail of an animal, as a catkin.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Doretus writes a great praise of the distilled waters of those <qex>tails</qex> that hang on willow trees.</q> <rj><qau>Harvey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, the back, last, lower, or inferior part of anything, -- as opposed to the <ant>head</ant>, or the superior part.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Lord will make thee the head, and not the <qex>tail</qex>.</q> <rj><qau>Deut. xxviii. 13.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A train or company of attendants; a retinue.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><ldquo/Ah,<rdquo/ said he, <ldquo/if you saw but the chief with his <qex>tail</qex> on.<rdquo/</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The side of a coin opposite to that which bears the head, effigy, or date; the reverse; -- rarely used except in the expression <ldquo/heads or tails,<rdquo/ employed when a coin is thrown up for the purpose of deciding some point by its fall.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Anat.)</fld> <def>The distal tendon of a muscle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Bot.)</fld> <def>A downy or feathery appendage to certain achenes. It is formed of the permanent elongated style.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Surg.)</fld> <sd>(a)</sd> <def>A portion of an incision, at its beginning or end, which does not go through the whole thickness of the skin, and is more painful than a complete incision; -- called also <altname>tailing</altname>.</def> <sd>(b)</sd> <def>One of the strips at the end of a bandage formed by splitting the bandage one or more times.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Naut.)</fld> <def>A rope spliced to the strap of a block, by which it may be lashed to anything.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Mus.)</fld> <def>The part of a note which runs perpendicularly upward or downward from the head; the stem.</def>  <rj><au>Moore (Encyc. of Music).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <pluf>pl.</pluf> <def>Same as <er>Tailing</er>, 4.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>12.</sn> <fld>(Arch.)</fld> <def>The bottom or lower portion of a member or part, as a slate or tile.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>13.</sn> <pluf>pl.</pluf> <fld>(Mining)</fld> <def>See <er>Tailing</er>, <pos>n.</pos>, 5.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>14.</sn> <fld>(Astronomy)</fld> <def>the long visible stream of gases, ions, or dust particles extending from the head of a comet in the direction opposite to the sun.</def><br/
[<source>PJC</source>]</p>

<p><sn>15.</sn> <pluf>pl.</pluf> <fld>(Rope Making)</fld> <def>In some forms of rope-laying machine, pieces of rope attached to the iron bar passing through the grooven wooden top containing the strands, for wrapping around the rope to be laid.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>16.</sn>  <pluf>pl.</pluf> <def>A tailed coat; a tail coat.</def> <mark>[Colloq. or Dial.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>17.</sn> <fld>(Aeronautics)</fld> <def>In airplanes, an airfoil or group of airfoils used at the rear to confer stability.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>18.</sn> <def>the buttocks.</def> <mark>[slang or vulgar]</mark><br/
[<source>PJC</source>]</p>

<p><sn>19.</sn> <def>sexual intercourse, or a woman used for sexual intercourse; <as>as, to get some <ex>tail</ex>; to find a piece of <ex>tail</ex></as>.  See also <er>tailing{3}</er>.</def> <mark>[slang and vulgar]</mark><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Tail beam</b></col>. <fld>(Arch.)</fld> <cd>Same as <er>Tailpiece</er>.</cd> -- <col><b>Tail coverts</b></col> <fld>(Zool.)</fld>, <cd>the feathers which cover the bases of the tail quills. They are sometimes much longer than the quills, and form elegant plumes. Those above the quills are called the <stype>upper tail coverts</stype>, and those below, the <stype>under tail coverts</stype>.</cd> -- <col><b>Tail end</b></col>, <cd>the latter end; the termination; <as>as, the <ex>tail end</ex> of a contest</as>.</cd> <mark>[Colloq.]</mark> -- <col><b>Tail joist</b></col>. <fld>(Arch.)</fld> <cd>Same as <er>Tailpiece</er>.</cd> -- <col><b>Tail of a comet</b></col> <fld>(Astron.)</fld>, <cd>a luminous train extending from the nucleus or body, often to a great distance, and usually in a direction opposite to the sun.</cd> -- <col><b>Tail of a gale</b></col> <fld>(Naut.)</fld>, <cd>the latter part of it, when the wind has greatly abated.</cd> <au>Totten.</au> -- <col><b>Tail of a lock</b></col> (on a canal), <cd>the lower end, or entrance into the lower pond.</cd> -- <col><b>Tail of the trenches</b></col> <fld>(Fort.)</fld>, <cd>the post where the besiegers begin to break ground, and cover themselves from the fire of the place, in advancing the lines of approach.</cd> -- <col><b>Tail spindle</b></col>, <cd>the spindle of the tailstock of a turning lathe; -- called also <altname>dead spindle</altname>.</cd> -- <col><b>To turn tail</b></col>, <cd>to run away; to flee.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>Would she <qex>turn tail</qex> to the heron, and fly quite out another way; but all was to return in a higher pitch.</q> <rj><qau>Sir P. Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tail</ent><br/
<hw>Tail</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To follow or hang to, like a tail; to be attached closely to, as that which can not be evaded.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Nevertheless his bond of two thousand pounds, wherewith he was <qex>tailed</qex>, continued uncanceled, and was called on the next Parliament.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To pull or draw by the tail.</def> <mark>[R.]</mark>  <rj><au>Hudibras.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>To tail in</b></col> <it>or</it> <col><b>To tail on</b></col></mcol> <fld>(Arch.)</fld>, <cd>to fasten by one of the ends into a wall or some other support; <as>as, <ex>to tail in</ex> a timber</as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tail</ent><br/
<hw>Tail</hw>, <pos>v. i.</pos> <sn>1.</sn> <fld>(Arch.)</fld> <def>To hold by the end; -- said of a timber when it rests upon a wall or other support; -- with <xex>in</xex> or <xex>into</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>To swing with the stern in a certain direction; -- said of a vessel at anchor; <as>as, this vessel <ex>tails</ex> down stream</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tail on</b></col>. <fld>(Naut.)</fld> <cd>See <cref>Tally on</cref>, under <er>Tally</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailage</ent><br/
<hw>Tail"age</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(O. Eng. Law)</fld> <def>See <er>Tallage</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tail-bay</ent><br/
<hw>Tail"-bay`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Arch.)</fld> <def>One of the joists which rest one end on the wall and the other on a girder; also, the space between a wall and the nearest girder of a floor.  Cf. <er>Case-bay</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The part of a canal lock below the lower gates.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailblock</ent><br/
<hw>Tail"block`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Naut.)</fld> <def>A block with a tail. See <er>Tail</er>, 9.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailboard</ent><br/
<hw>Tail"board`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The board at the rear end of a cart or wagon, which can be removed or let down, for convenience in loading or unloading.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailed</ent><br/
<hw>Tailed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having a tail; having (such) a tail or (so many) tails; -- chiefly used in composition; <as>as, bob<ex>tailed</ex>, long<ex>tailed</ex>, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Snouted and <qex>tailed</qex> like a boar.</q> <rj><qau>Grew.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailing</ent><br/
<hw>Tail"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Arch.)</fld> <def>The part of a projecting stone or brick inserted in a wall.</def>  <rj><au>Gwilt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Surg.)</fld> <def>Same as <er>Tail</er>, <pos>n.</pos>, 8 <sd>(a)</sd>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Sexual intercourse.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <pluf>pl.</pluf> <def>The lighter parts of grain separated from the seed threshing and winnowing; chaff.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <pluf>pl.</pluf> <fld>(Mining)</fld> <def>The refuse part of stamped ore, thrown behind the tail of the buddle or washing apparatus. It is dressed over again to secure whatever metal may exist in it.  Called also <altname>tails</altname>.</def>  <rj><au>Pryce.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Elec.)</fld> <def>A prolongation of current in a telegraph line, due to capacity in the line and causing signals to run together.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taille</ent><br/
<hw>Taille</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See <er>Tally</er>, <er>Tailor</er>.]</ety> <sn>1.</sn> <def>A tally; an account scored on a piece of wood.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Whether that he paid or took by <qex>taille</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(O. F. Law)</fld> <def>Any imposition levied by the king, or any other lord, upon his subjects.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>taille</qex>, as it still subsists in France, may serve as an example of those ancient tallages. It was a tax upon the profits of the farmer, which they estimate by the stock that he has upon the farm.</q> <rj><qau>A. Smith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Mus.)</fld> <def>The French name for the tenor voice or part; also, for the tenor viol or viola.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailless</ent><br/
<hw>Tail"less</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having no tail.</def>  <rj><au>H. Spencer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taillie</ent><br/
<hw>Tail"lie</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Scots Law)</fld> <def>Same as <er>Tailzie</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailor</ent><br/
<hw>Tai"lor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>tailleor</ets>, F. <ets>tailleur</ets>, fr. OF. <ets>taillier</ets>, F. <ets>tailler</ets> to cut, fr. L. <ets>talea</ets> a rod, stick, a cutting, layer for planting.  Cf. <er>Detail</er>, <er>Entail</er>, <er>Retail</er>, <er>Tally</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>One whose occupation is to cut out and make men's garments; also, one who cuts out and makes ladies' outer garments.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Well said, good woman's <qex>tailor</qex> . . . I would thou wert a man's <qex>tailor</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <sd>(a)</sd> <def>The mattowacca; -- called also <altname>tailor herring</altname>.</def> <sd>(b)</sd> <def>The silversides.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>The goldfish.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Salt-water tailor</b></col> <fld>(Zool.)</fld>, <cd>the bluefish.</cd> <mark>[Local, U. S.]</mark> <au>Bartlett.</au> -- <col><b>Tailor bird</b></col> <fld>(Zool.)</fld>, <cd>any one of numerous species of small Asiatic and East Indian singing birds belonging to <gen>Orthotomus</gen>, <gen>Prinia</gen>, and allied genera.  They are noted for the skill with which they sew leaves together to form nests.  The common Indian species are <spn>Orthotomus longicauda</spn>, which has the back, scapulars, and upper tail coverts yellowish green, and the under parts white; and the golden-headed tailor bird (<spn>Orthotomus coronatus</spn>), which has the top of the head golden yellow and the back and wings pale olive-green.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailor</ent><br/
<hw>Tai"lor</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tailored</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tailoring</conjf>.]</vmorph> <def>To practice making men's clothes; to follow the business of a tailor.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>These <qex>tailoring</qex> artists for our lays<br/
Invent cramped rules.</q> <rj><qau>M. Green.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailoress</ent><br/
<hw>Tai"lor*ess</hw>, <pos>n.</pos> <def>A female tailor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailoring</ent><br/
<hw>Tai"lor*ing</hw>, <pos>adv.</pos> <def>The business or the work of a tailor or a tailoress.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailor-made</ent><br/
<hw>Tai"lor-made`</hw>, <pos>a.</pos> <sn>1.</sn> <def>Made by a tailor or according to a tailor's fashion; -- said specif. of women's garments made with certain closeness of fit, simplicity of ornament, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>made or as if made specifically for the particular purpose at hand; --  used metaphorically.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tailpiece</ent><br/
<hw>Tail"piece`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A piece at the end; an appendage.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <def>One of the timbers which tail into a header, in floor framing. See <xex>Illust.</xex> of <er>Header</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Print.)</fld> <def>An ornament placed at the bottom of a short page to fill up the space, or at the end of a book.</def>  <rj><au>Savage.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A piece of ebony or other material attached to the lower end of a violin or similar instrument, to which the strings are fastened.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Locks)</fld> <def>A piece for transmitting motion from the hub of a lock to the latch bolt.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>6.</sn>  <def>The part of a telescope containing the adjusting device for the eyepiece, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tailpin</ent><br/
<hw>Tail"pin"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Mach.)</fld> <def>The center in the spindle of a turning lathe.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailrace</ent><br/
<hw>Tail"race`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>See <er>Race</er>, <pos>n.</pos>, 6.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mining)</fld> <def>The channel in which tailings, suspended in water, are conducted away.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailstock</ent><br/
<hw>Tail"stock`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The sliding block or support, in a lathe, which carries the dead spindle, or adjustable center. The <contr>headstock</contr> supports the live spindle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tail-water</ent><br/
<hw>Tail"-wa`ter</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Water in a tailrace.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tailzie</ent><br/
<hw>Tail"zie</hw> <pr>(-z<icr/ <or/ -y<icr/)</pr>, <pos>n.</pos> <ety>[F. <ets>tailler</ets> to cut. See <er>Tail</er> a limitation.]</ety> <fld>(Scots Law)</fld> <def>An entailment or deed whereby the legal course of succession is cut off, and an arbitrary one substituted.</def> <altsp>[Written also <asp>tailzee</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tain</ent><br/
<hw>Tain</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>tein</ets>, <ets>teyne</ets>; cf. Icel. <ets>teinn</ets> a twig, akin to AS. <ets>t<amac/n</ets>, Goth. <ets>tains</ets>.]</ety> <def>Thin tin plate; also, tin foil for mirrors.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taint</ent><br/
<hw>Taint</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>atteinte</ets> a blow, bit, stroke. See <er>Attaint</er>.]</ety> <sn>1.</sn> <def>A thrust with a lance, which fails of its intended effect.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>This <qex>taint</qex> he followed with his sword drawn from a silver sheath.</q> <rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An injury done to a lance in an encounter, without its being broken; also, a breaking of a lance in an encounter in a dishonorable or unscientific manner.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taint</ent><br/
<hw>Taint</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tainted</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tainting</conjf>.]</vmorph> <def>To thrust ineffectually with a lance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taint</ent><br/
<hw>Taint</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To injure, as a lance, without breaking it; also, to break, as a lance, but usually in an unknightly or unscientific manner.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Do not fear; I have<br/
A staff to <qex>taint</qex>, and bravely.</q> <rj><qau>Massinger.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To hit or touch lightly, in tilting.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>They <qex>tainted</qex> each other on the helms and passed by.</q> <rj><qau>Ld. Berners.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taint</ent><br/
<hw>Taint</hw>, <pos>v. t.</pos> <ety>[F. <ets>teint</ets>, p. p. of <ets>teindre</ets> to dye, tinge, fr. L. <ets>tingere</ets>, <ets>tinctum</ets>. See <er>Tinge</er>, and cf. <er>Tint</er>.]</ety> <sn>1.</sn> <def>To imbue or impregnate with something extraneous, especially with something odious, noxious, or poisonous; hence, to corrupt; to infect; to poison; <as>as, putrid substance <ex>taint</ex> the air</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: To stain; to sully; to tarnish.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His unkindness may defeat my life,<br/
But never <qex>taint</qex> my love.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To contaminate; defile; pollute; corrupt; infect; disease; vitiate; poison.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taint</ent><br/
<hw>Taint</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To be infected or corrupted; to be touched with something corrupting.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I can not <qex>taint</qex> with fear.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be affected with incipient putrefaction; <as>as, meat soon <ex>taints</ex> in warm weather</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taint</ent><br/
<hw>Taint</hw>, <pos>n.</pos> <sn>1.</sn> <def>Tincture; hue; color; tinge.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Infection; corruption; deprivation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He had inherited from his parents a scrofulous <qex>taint</qex>, which it was beyond the power of medicine to remove.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A blemish on reputation; stain; spot; disgrace.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taint</ent><br/
<hw>Taint</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>Aphetic form of <er>Attaint</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taintless</ent><br/
<hw>Taint"less</hw>, <pos>a.</pos> <def>Free from taint or infection; pure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taintlessly</ent><br/
<hw>Taint"less*ly</hw>, <pos>adv.</pos> <def>In a taintless manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tainture</ent><br/
<hw>Tain"ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>teinture</ets>. See <er>Taint</er> to stain, and cf. <er>Tincture</er>.]</ety> <def>Taint; tinge; difilement; stain; spot.</def> <mark>[R.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taintworm</ent><br/
<hw>Taint"worm`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A destructive parasitic worm or insect larva.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taeping</ent><br/
<ent>Taiping</ent><br/
<mhw>{ <hw>Tai"ping"</hw>, <it>or</it> <hw>Tae"ping"</hw> }</mhw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Chin. <ets>t'aip'ing</ets> great peace.]</ety> <fld>(Chinese Hist.)</fld> <def>Pertaining to or designating a dynasty with which one Hung-Siu-Chuen, a half-religious, half-political enthusiast, attempted to supplant the Manchu dynasty by the <col><b>Taiping rebellion</b></col>, incited by him in 1850 and suppressed by General Gordon about 1864.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taira</ent><br/
<hw>Tai"ra</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Tayra</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tairn</ent><br/
<hw>Tairn</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tarn</er>.</def>  <rj><au>Coleridge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tait</ent><br/
<hw>Tait</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A small nocturnal and arboreal Australian marsupial (<spn>Tarsipes rostratus</spn>) about the size of a mouse. It has a long muzzle, a long tongue, and very few teeth, and feeds upon honey and insects. Called also <altname>noolbenger</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tajassu</ent><br/
<ent>Tajacu</ent><br/
<mhw>{ <hw>Ta*ja<cced/"u</hw>, <hw>Ta*jas"su</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pg. <ets>taja<cced/<uacute/</ets>, from Braz. <ets>taya<cced/<uacute/</ets> a hog or swine.]</ety> <fld>(Zool.)</fld> <def>The common, or collared, peccary (<spn>Tayassu tajacu</spn>).  Called also <altname>javelina</altname> and <altname>tayaussa</altname>.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><q><title>Javelina</title><br/
Common Names: Collared Peccary, Musk Hog, Tayaussa<br/
Genus: Tayassu<br/
Species: tajacu<br/
<br/
The <a href="images/javelina.gif">javelina</a> is the only wild pig in North America. It looks exactly like a real pig except a little bigger.  It is a grizzled blackish-gray color with a yellowish band which runs under the neck.  The name <altname>collared peccary</altname> comes from the ruff of hair around its neck.  It has small, round ears and beady eyes. Its body is barrel-shaped with short legs.  Its head is pointed, ending in a disc-like nose. Javelinas have 3 toes on each hind foot. The upper tusks (1.5 inches long) are pointed down, instead of up like some other wild pigs. The javelina grows from 46 to 60 inches long, and can weigh up to 60 pounds.<br/
<br/
Javelinas live in the canyon area of the desert. They live there because it is bushy and there are water holes everywhere. They need the bushes for the shade and they need lots of water to live.<br/
<br/
The javelina eats cacti, grass, bulbs, berries, flowers, mushrooms, and fruit, which is easy for them to get in their habitat.<br/
<br/
The javelina always travel and live in groups. The female gives birth to twins about once a year. Her young travel with the group their whole life until they die. No new members are ever accepted into the group unless they are born into it.<br/
<br/
The javelinas have a very good nose. That can have its advantages if there is a predator around. They also look for food in groups so if they're attacked they can fight back in numbers.<br/
<br/
The javelina's niche is the water holes and bushes in the canyon area where they live. They get shade under the bushes, so they won't over heat. They can't survive long without water, so it's good to have water close by if you are a javelina.<br/
<br/
Javelinas' status in the wild is very good right now. There are lots of them around and they're not dying off or going extinct.</q>  <qau>Tristan A.  (from http://www.blueplanetbiomes.org/javelina.htm, 2000.)</qau><br/
[<source>PJC</source>]</p>


<p><ent>Taj Mahal</ent><br/
<hw>Taj Ma*hal"</hw> <pr>(t<aum/j m<adot/*h<aum/l")</pr>, <pos>prop. n.</pos> <ety>[Corruption of Per. <ets>Mumt<amac/z-i-Ma<hsdot/al</ets>, lit., the distinguished one of the palace, fr. Ar.]</ety> <def>A marble mausoleum built at <city>Agra</city>, <country>India</country>, by the Mogul Emperor <person>Shah Jahan</person>, in memory of his favorite wife.  In beauty of design and rich decorative detail it is one of the best examples of Saracenic architecture, and specifically of Mogul architecture.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Take</ent><br/
<hw>Take</hw> <pr>(t<amac/k)</pr>, <mark>obs.</mark> <pos>p. p.</pos> <mord>of <er>Take</er></mord>. <def>Taken.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1470 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Take</ent><br/
<hw>Take</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp.</pos> <conjf>Took</conjf> <pr>(t<oocr/k)</pr>; <pos>p. p.</pos> <conjf>Taken</conjf> <pr>(t<amac/k'n)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Taking</conjf>.]</vmorph> <ety>[Icel. <ets>taka</ets>; akin to Sw. <ets>taga</ets>, Dan. <ets>tage</ets>, Goth. <ets>t<emac/kan</ets> to touch; of uncertain origin.]</ety> <sn>1.</sn> <def>In an active sense; To lay hold of; to seize with the hands, or otherwise; to grasp; to get into one's hold or possession; to procure; to seize and carry away; to convey.</def> <specif>Hence, specifically:</specif> --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>To obtain possession of by force or artifice; to get the custody or control of; to reduce into subjection to one's power or will; to capture; to seize; to make prisoner; <as>as, to <ex>take</ex> an army, a city, or a ship</as>; also, to come upon or befall; to fasten on; to attack; to seize; -- said of a disease, misfortune, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This man was <qex>taken</qex> of the Jews.</q> <rj><qau>Acts xxiii. 27.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Men in their loose, unguarded hours they <qex>take</qex>;<br/
Not that themselves are wise, but others weak.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They that come abroad after these showers are commonly <qex>taken</qex> with sickness.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There he blasts the tree and <qex>takes</qex> the cattle<br/
And makes milch kine yield blood.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>To gain or secure the interest or affection of; to captivate; to engage; to interest; to charm.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Neither let her <qex>take</qex> thee with her eyelids.</q> <rj><qau>Prov. vi. 25.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Cleombroutus was so <qex>taken</qex> with this prospect, that he had no patience.</q> <rj><qau>Wake.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I know not why, but there was a something in those half-seen features, -- a charm in the very shadow that hung over their imagined beauty, -- which <qex>took</qex> me more than all the outshining loveliness of her companions.</q> <rj><qau>Moore.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>To make selection of; to choose; also, to turn to; to have recourse to; <as>as, to <ex>take</ex> the road to the right</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Saul said, Cast lots between me and Jonathan my son.  And Jonathan was <qex>taken</qex>.</q> <rj><qau>1 Sam. xiv. 42.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The violence of storming is the course which God is forced to <qex>take</qex> for the destroying . . . of sinners.</q> <rj><qau>Hammond.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>To employ; to use; to occupy; hence, to demand; to require; <as>as, it <ex>takes</ex> so much cloth to make a coat; it <ex>takes</ex> five hours to get to Boston from New York by car</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This man always <qex>takes</qex> time . . . before he passes his judgments.</q> <rj><qau>I. Watts.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(e)</sd> <def>To form a likeness of; to copy; to delineate; to picture; <as>as, to <ex>take</ex> a picture of a person</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Beauty alone could beauty <qex>take</qex> so right.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(f)</sd> <def>To draw; to deduce; to derive.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The firm belief of a future judgment is the most forcible motive to a good life, because <qex>taken</qex> from this consideration of the most lasting happiness and misery.</q> <rj><qau>Tillotson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(g)</sd> <def>To assume; to adopt; to acquire, as shape; to permit to one's self; to indulge or engage in; to yield to; to have or feel; to enjoy or experience, as rest, revenge, delight, shame; to form and adopt, as a resolution; -- used in general senses, limited by a following complement, in many idiomatic phrases; <as>as, to <ex>take</ex> a resolution; I <ex>take</ex> the liberty to say</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(h)</sd> <def>To lead; to conduct; <as>as, to <ex>take</ex> a child to church</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(i)</sd> <def>To carry; to convey; to deliver to another; to hand over; <as>as, he <ex>took</ex> the book to the bindery; he <ex>took</ex> a dictionary with him</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>took</qex> me certain gold, I wot it well.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(k)</sd> <def>To remove; to withdraw; to deduct; -- with <xex>from</xex>; <as>as, to <ex>take</ex> the breath from one; to <ex>take</ex> two from four</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In a somewhat passive sense, to receive; to bear; to endure; to acknowledge; to accept.</def> <specif>Specifically:</specif> --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>To accept, as something offered; to receive; not to refuse or reject; to admit.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ye shall <qex>take</qex> no satisfaction for the life of a murderer.</q> <rj><qau>Num. xxxv. 31.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Let not a widow be <qex>taken</qex> into the number under threescore.</q> <rj><qau>1 Tim. v. 10.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>To receive as something to be eaten or drunk; to partake of; to swallow; <as>as, to <ex>take</ex> food or wine</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>Not to refuse or balk at; to undertake readily; to clear; <as>as, to <ex>take</ex> a hedge or fence</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>To bear without ill humor or resentment; to submit to; to tolerate; to endure; <as>as, to <ex>take</ex> a joke; he will <ex>take</ex> an affront from no man</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(e)</sd> <def>To admit, as, something presented to the mind; not to dispute; to allow; to accept; to receive in thought; to entertain in opinion; to understand; to interpret; to regard or look upon; to consider; to suppose; <as>as, to <ex>take</ex> a thing for granted; this I <ex>take</ex> to be man's motive; to <ex>take</ex> men for spies</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>You <qex>take</qex> me right.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Charity, <qex>taken</qex> in its largest extent, is nothing else but the science love of God and our neighbor.</q> <rj><qau>Wake.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>[He] <qex>took</qex> that for virtue and affection which was nothing but vice in a disguise.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>You'd doubt his sex, and <qex>take</qex> him for a girl.</q> <rj><qau>Tate.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(f)</sd> <def>To accept the word or offer of; to receive and accept; to bear; to submit to; to enter into agreement with; -- used in general senses; <as>as, to <ex>take</ex> a form or shape</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I <qex>take</qex> thee at thy word.</q> <rj><qau>Rowe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Yet thy moist clay is pliant to command; . . . <br/
Not <qex>take</qex> the mold.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To make a picture, photograph, or the like, of; <as>as, to <ex>take</ex> a group or a scene</as>.</def> <mark>[Colloq.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>4.</sn>  <def>To give or deliver (a blow to); to strike; hit; <as>as, he <ex>took</ex> me in the face; he <ex>took</ex> me a blow on the head.</as></def> <mark>[Obs. exc. Slang or Dial.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><mcol><col><b>To be taken aback</b></col>, <col><b>To take advantage of</b></col>, <col><b>To take air</b></col>, etc.</mcol> <cd>See under <er>Aback</er>, <er>Advantage</er>, etc.</cd> -- <col><b>To take aim</b></col>, <cd>to direct the eye or weapon; to aim.</cd> -- <col><b>To take along</b></col>, <cd>to carry, lead, or convey.</cd> -- <col><b>To take arms</b></col>, <cd>to commence war or hostilities.</cd> -- <col><b>To take away</b></col>, <cd>to carry off; to remove; to cause deprivation of; to do away with; <as>as, a bill for <ex>taking away</ex> the votes of bishops</as>.</cd> <ldquo/By your own law, I <xex>take</xex> your life <xex>away</xex>.<rdquo/ <au>Dryden.</au> -- <col><b>To take breath</b></col>, <cd>to stop, as from labor, in order to breathe or rest; to recruit or refresh one's self.</cd> -- <col><b>To take care</b></col>, <cd>to exercise care or vigilance; to be solicitous.</cd> <ldquo/Doth God <xex>take care</xex> for oxen?<rdquo/ <au>1 Cor. ix. 9.</au> -- <col><b>To take care of</b></col>, <cd>to have the charge or care of; to care for; to superintend or oversee.</cd> -- <col><b>To take down</b></col>. <sd>(a)</sd> <cd>To reduce; to bring down, as from a high, or higher, place; <as>as, <ex>to take down</ex> a book</as>; hence, to bring lower; to depress; to abase or humble; <as>as, <ex>to take down</ex> pride, or the proud</as>.</cd> <ldquo/I never attempted to be impudent yet, that I was not <xex>taken down</xex>.<rdquo/ <au>Goldsmith.</au> <sd>(b)</sd> <cd>To swallow; <as>as, <ex>to take down</ex> a potion</as>.</cd> <sd>(c)</sd> <cd>To pull down; to pull to pieces; <as>as, <ex>to take down</ex> a house or a scaffold</as>.</cd> <sd>(d)</sd> <cd>To record; to write down; <as>as, <ex>to take down</ex> a man's words at the time he utters them</as>.</cd> -- <mcol><col><b>To take effect</b></col>, <col><b>To take fire</b></col></mcol>. <cd>See under <er>Effect</er>, and <er>Fire</er>.</cd> -- <mcol><col><b>To take ground to the right</b></col> <it>or</it> <col><b>To take ground to the left</b></col></mcol> <fld>(Mil.)</fld>, <cd>to extend the line to the right or left; to move, as troops, to the right or left.</cd> -- <col><b>To take heart</b></col>, <cd>to gain confidence or courage; to be encouraged.</cd> -- <col><b>To take heed</b></col>, <cd>to be careful or cautious.</cd> <ldquo/<xex>Take heed</xex> what doom against yourself you give.<rdquo/ <au>Dryden.</au> -- <col><b>To take heed to</b></col>, <cd>to attend with care, <as>as, <ex>take heed to</ex> thy ways</as>.</cd> -- <col><b>To take hold of</b></col>, <cd>to seize; to fix on.</cd> -- <col><b>To take horse</b></col>, <cd>to mount and ride a horse.</cd> -- <col><b>To take in</b></col>. <sd>(a)</sd> <cd>To inclose; to fence.</cd> <sd>(b)</sd> <cd>To encompass or embrace; to comprise; to comprehend.</cd> <sd>(c)</sd> <cd>To draw into a smaller compass; to contract; to brail or furl; <as>as, <ex>to take in</ex> sail</as>.</cd> <sd>(d)</sd> <cd>To cheat; to circumvent; to gull; to deceive.</cd> <mark>[Colloq.]</mark> <sd>(e)</sd> <cd>To admit; to receive; <as>as, a leaky vessel will <ex>take in</ex> water</as>.</cd> <sd>(f)</sd> <cd>To win by conquest.</cd> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>For now Troy's broad-wayed town<br/
He shall <qex>take in</qex>.</q> <rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(g)</sd> <cd>To receive into the mind or understanding.</cd> <ldquo/Some bright genius can <xex>take in</xex> a long train of propositions.<rdquo/ <au>I. Watts.</au> <sd>(h)</sd> <cd>To receive regularly, as a periodical work or newspaper; to take.</cd> <mark>[Eng.]</mark> -- <col><b>To take in hand</b></col>. <cd>See under <er>Hand</er>.</cd> -- <col><b>To take in vain</b></col>, <cd>to employ or utter as in an oath.</cd> <ldquo/Thou shalt not <xex>take</xex> the name of the Lord thy God <xex>in vain</xex>.<rdquo/ <au>Ex. xx. 7.</au> -- <col><b>To take issue</b></col>. <cd>See under <er>Issue</er>.</cd> -- <col><b>To take leave</b></col>. <cd>See <er>Leave</er>, <pos>n.</pos>, 2.</cd> -- <mcol><col><b>To take a newspaper</b></col>, <col><b>magazine</b></col>, or the like</mcol>, <cd>to receive it regularly, as on paying the price of subscription.</cd> -- <col><b>To take notice</b></col>, <cd>to observe, or to observe with particular attention.</cd> -- <col><b>To take notice of</b></col>. <cd>See under <er>Notice</er>.</cd> -- <col><b>To take oath</b></col>, <cd>to swear with solemnity, or in a judicial manner.</cd>  -- <col><b>To take on</b></col>, <cd>to assume; to take upon one's self; <as>as, <ex>to take on</ex> a character or responsibility</as>.</cd> -- <col><b>To take one's own course</b></col>, <cd>to act one's pleasure; to pursue the measures of one's own choice.</cd> -- <col><b>To take order for</b></col>. <cd>See under <er>Order</er>.</cd> -- <col><b>To take order with</b></col>, <cd>to check; to hinder; to repress.</cd> <mark>[Obs.]</mark> <au>Bacon.</au> -- <col><b>To take orders</b></col>. <sd>(a)</sd> <cd>To receive directions or commands.</cd> <sd>(b)</sd> <fld>(Eccl.)</fld> <cd>To enter some grade of the ministry. See <er>Order</er>, <pos>n.</pos>, 10.</cd> -- <col><b>To take out</b></col>. <sd>(a)</sd> <cd>To remove from within a place; to separate; to deduct.</cd> <sd>(b)</sd> <cd>To draw out; to remove; to clear or cleanse from; <as>as, <ex>to take out</ex> a stain or spot from cloth</as>.</cd> <sd>(c)</sd> <cd>To produce for one's self; <as>as, <ex>to take out</ex> a patent</as>.</cd> <-- "produce"?? better, "obtain" --> <sd>(d)</sd> <cd>To put an end to; <as>as, <ex>to take</ex> the conceit <ex>out</ex> of a man</as>.</cd> <sd>(e)</sd> <cd>To escort; <as>as, <ex>to take out</ex> to dinner</as>.</cd><-- usu. paying the expenses --> -- <col><b>To take over</b></col>, <cd>to undertake; to take the management of.</cd> <mark>[Eng.]</mark> <au>Cross (Life of G. Eliot).</au> -- <col><b>To take part</b></col>, <cd>to share; <as>as, they <ex>take part</ex> in our rejoicing</as>.</cd> -- <col><b>To take part with</b></col>, <cd>to unite with; to join with.</cd><-- take part in = participate in --> -- <mcol><col><b>To take place</b></col>, <col><b>root</b></col>, <col><b>sides</b></col>, <col><b>stock</b></col>, etc.</mcol> <cd>See under <er>Place</er>, <er>Root</er>, <er>Side</er>, etc.</cd> -- <col><b>To take the air</b></col>. <sd>(a)</sd> <fld>(Falconry)</fld> <cd>To seek to escape by trying to rise higher than the falcon; -- said of a bird.</cd> <sd>(b)</sd> <cd>See under <er>Air</er>.</cd> -- <col><b>To take the field</b></col>. <fld>(Mil.)</fld> <cd>See under <er>Field</er>.</cd> -- <col><b>To take thought</b></col>, <cd>to be concerned or anxious; to be solicitous.</cd> <au>Matt. vi. 25, 27.</au> -- <col><b>To take to heart</b></col>. <cd>See under <er>Heart</er>.</cd> -- <col><b>To take to task</b></col>, <cd>to reprove; to censure.</cd> -- <-- <col><b>to take to the air</b></col>, <cd>to take off.</cd> --> <col><b>To take up</b></col>. <sd>(a)</sd> <cd>To lift; to raise.</cd> <au>Hood.</au> <sd>(b)</sd> <cd>To buy or borrow; <as>as, <ex>to take up</ex> goods to a large amount; <ex>to take up</ex> money at the bank</as>.</cd> <sd>(c)</sd> <cd>To begin; <as>as, <ex>to take up</ex> a lamentation</as>.</cd> <au>Ezek. xix. 1.</au> <sd>(d)</sd> <cd>To gather together; to bind up; to fasten or to replace; <as>as, <ex>to take up</ex> raveled stitches</as></cd>; specifically <fld>(Surg.)</fld>, <cd>to fasten with a ligature.</cd> <sd>(e)</sd> <cd>To engross; to employ; to occupy or fill; <as>as, <ex>to take up</ex> the time; <ex>to take up</ex> a great deal of room</as>.</cd> <sd>(f)</sd> <cd>To take permanently.</cd> <ldquo/Arnobius asserts that men of the finest parts . . . <xex>took up</xex> their rest in the Christian religion.<rdquo/ <au>Addison.</au> <sd>(g)</sd> <cd>To seize; to catch; to arrest; <as>as, <ex>to take up</ex> a thief; <ex>to take up</ex> vagabonds</as>.</cd> <sd>(h)</sd> <cd>To admit; to believe; to receive.</cd> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The ancients <qex>took up</qex> experiments upon credit.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(i)</sd> <cd>To answer by reproof; to reprimand; to berate.</cd><br/
[<source>1913 Webster</source>]</p>

<p><q>One of his relations <qex>took</qex> him <qex>up</qex> roundly.</q> <rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(k)</sd> <cd>To begin where another left off; to keep up in continuous succession; to take up (a topic, an activity).</cd><br/
[<source>1913 Webster</source>]</p>

<p><q>Soon as the evening shades prevail,<br/
The moon <qex>takes up</qex> the wondrous tale.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- The second volume takes up where the first left off. --><br/
[<source>1913 Webster</source>]</p>

<p><sd>(l)</sd> <cd>To assume; to adopt as one's own; to carry on or manage; <as>as, <ex>to take up</ex> the quarrels of our neighbors; <ex>to take up</ex> current opinions</as>.</cd> <ldquo/They <xex>take up</xex> our old trade of conquering.<rdquo/ <au>Dryden.</au> <sd>(m)</sd> <cd>To comprise; to include.</cd> <ldquo/The noble poem of Palemon and Arcite . . . <xex>takes up</xex> seven years.<rdquo/ <au>Dryden.</au> <sd>(n)</sd> <cd>To receive, accept, or adopt for the purpose of assisting; to espouse the cause of; to favor.</cd> <au>Ps. xxvii. 10.</au> <sd>(o)</sd> <cd>To collect; to exact, as a tax; to levy; <as>as, <ex>to take up</ex> a contribution</as>.</cd> <ldquo/<xex>Take up</xex> commodities upon our bills.<rdquo/ <au>Shak.</au> <sd>(p)</sd> <cd>To pay and receive; <as>as, <ex>to take up</ex> a note at the bank</as>.</cd> <sd>(q)</sd> <fld>(Mach.)</fld> <cd>To remove, as by an adjustment of parts; <as>as, <ex>to take up</ex> lost motion, as in a bearing</as>; also, to make tight, as by winding, or drawing; <as>as, <ex>to take up</ex> slack thread in sewing</as>.</cd> <sd>(r)</sd> <cd>To make up; to compose; to settle; <as>as, <ex>to take up</ex> a quarrel</as>.</cd> <mark>[Obs.]</mark> <au>Shak.</au> -- (s) <cd>To accept from someone, as a wager or a challenge; <as>as, J. <ex>took</ex> M. <ex>up</ex> on his challenge</as>.</cd> -- <col><b>To take up arms</b></col>. <cd>Same as <cref>To take arms</cref>, above.</cd> -- <col><b>To take upon one's self</b></col>. <sd>(a)</sd> <cd>To assume; to undertake; <as>as, he <ex>takes upon himself</ex> to assert that the fact is capable of proof</as>.</cd> <sd>(b)</sd> <cd>To appropriate to one's self; to allow to be imputed to, or inflicted upon, one's self; <as>as, <ex>to take upon one's self</ex> a punishment</as>.</cd> -- <col><b>To take up the gauntlet</b></col>. <cd>See under <er>Gauntlet</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Take</ent><br/
<hw>Take</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To take hold; to fix upon anything; to have the natural or intended effect; to accomplish a purpose; <as>as, he was inoculated, but the virus did not <ex>take</ex></as>.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When flame <qex>taketh</qex> and openeth, it giveth a noise.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In impressions from mind to mind, the impression <qex>taketh</qex>, but is overcome . . . before it work any manifest effect.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To please; to gain reception; to succeed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Each wit may praise it for his own dear sake,<br/
And hint he writ it, if the thing should <qex>take</qex>.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To move or direct the course; to resort; to betake one's self; to proceed; to go; -- usually with <xex>to</xex>; <as>as, the fox, being hard pressed, <ex>took</ex> to the hedge</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To admit of being pictured, as in a photograph; <as>as, his face does not <ex>take</ex> well</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To take after</b></col>. <sd>(a)</sd> <cd>To learn to follow; to copy; to imitate; <as>as, he <ex>takes after</ex> a good pattern</as>.</cd> <sd>(b)</sd> <cd>To resemble; <as>as, the son <ex>takes after</ex> his father</as>.</cd> -- <col><b>To take in with</b></col>, <cd>to resort to.</cd> <mark>[Obs.]</mark> <au>Bacon.</au> -- <col><b>To take on</b></col>, <cd>to be violently affected; to express grief or pain in a violent manner.</cd> -- <col><b>To take to</b></col>. <sd>(a)</sd> <cd>To apply one's self to; to be fond of; to become attached to; <as>as, <ex>to take to</ex> evil practices</as>.</cd> <ldquo/If he does but <xex>take to</xex> you, . . . you will contract a great friendship with him.<rdquo/ <au>Walpole.</au> <sd>(b)</sd> <cd>To resort to; to betake one's self to.</cd> <ldquo/Men of learning, who <xex>take to</xex> business, discharge it generally with greater honesty than men of the world.<rdquo/ <au>Addison.</au> -- <col><b>To take up</b></col>. <sd>(a)</sd> <cd>To stop.</cd> <mark>[Obs.]</mark> <ldquo/Sinners at last <xex>take up</xex> and settle in a contempt of religion.<rdquo/ <au>Tillotson.</au> <sd>(b)</sd> <cd>To reform.</cd> <mark>[Obs.]</mark> <au>Locke.</au> -- <col><b>To take up with</b></col>. <sd>(a)</sd> <cd>To be contended to receive; to receive without opposition; to put up with; <as>as, <ex>to take up with</ex> plain fare</as>.</cd> <ldquo/In affairs which may have an extensive influence on our future happiness, we should not <xex>take up with</xex> probabilities.<rdquo/ <au>I. Watts.</au> <sd>(b)</sd> <cd>To lodge with; to dwell with.</cd> <mark>[Obs.]</mark> <au>L'Estrange.</au> -- <col><b>To take with</b></col>, <cd>to please.</cd> <au>Bacon.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Take</ent><br/
<hw>Take</hw>, <pos>n.</pos> <sn>1.</sn> <def>That which is taken, such as the quantity of fish captured at one haul or catch, or the amouont of money collected during one event; <as>as, the box-office <ex>take</ex></as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <fld>(Print.)</fld> <def>The quantity or copy given to a compositor at one time.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Take-in</ent><br/
<hw>Take"-in`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Imposition; fraud.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taken</ent><br/
<hw>Tak"en</hw> <pr>(t<amac/k"'n)</pr>, <def><pos>p. p.</pos> of <er>Take</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Take-off</ent><br/
<ent>Takeoff</ent><br/
<mhw><hw>Take"off`</hw>, <hw>Take"-off`</hw></mhw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>An imitation, especially in the way of caricature; -- used with <ptcl>of</ptcl> or <ptcl>on</ptcl>; <as>as, the comedian did a hilarious <ex>takeoff</ex> on the president</as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>The spot at which one takes off; specif., the place from which a jumper rises in leaping.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>The <qex>take-off</qex> should be selected with great care, and a pit of large dimensions provided on the landing side.</q>  <rj><qau>Encyc. of Sport.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn> <def>The beginning of a leap from a surface or a flight into the air, especially the process or event of an airplane leaving the ground and beginning its flight; <as>as, the <ex>takeoff</ex> of flight CA123 was scheduled for 3:00 PM</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Take off</ent><br/
<hw>Take" off`</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>to begin a leap from a surface or a flight into the air; especially, (of a bird or an airplane) to leave the ground and begin to fly; <as>as, flight CA123 <ex>took off</ex> on schedule at 3:00 PM</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>To begin a period of accelerating growth or development; <as>as, the economy <ex>took off</ex> in the third quarter</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>To begin a journey; to depart.</def><br/
[<source>PJC</source>]</p>

<p><ent>Take off</ent><br/
<hw>Take" off`</hw> <pr>(?)</pr>, <pos>v. t.</pos> <sn>1.</sn> <def>To remove, as from the surface or outside; to remove from the top of anything; <as>as, <ex>to take off</ex> a load; <ex>to take off</ex> one's hat, coat or other article of clothing; to <ex>take off</ex> a coat of paint from a surface</as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>To cut off; <as>as, <ex>to take off</ex> the head, or a limb</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To destroy; <as>as, <ex>to take off</ex> life</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To remove; to invalidate; <as>as, <ex>to take off</ex> the force of an argument</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To withdraw; to call or draw away; <as>as, the director <ex>took</ex> him <ex>off</ex> the project</as>.</def> <au>Locke.</au><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><sn>6.</sn> <def>To swallow; <as>as, <ex>to take off</ex> a glass of wine</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To purchase; to take in trade.</def> <ldquo/The Spaniards having no commodities that we will <xex>take off</xex>.<rdquo/ <au>Locke.</au><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>To copy; to reproduce.</def> <ldquo/<xex>Take off</xex> all their models in wood.<rdquo/ <au>Addison.</au><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>To imitate; to mimic; to personate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>To find place for; to dispose of; <as>as, more scholars than preferments can <ex>take off</ex>.</as></def> <mark>[R.]</mark> <au>Bacon.</au><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <def>To discount or deduct (from a price); <as>the dealer <ex>took off</ex> twenty percent on remaining toys</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>takeover</ent><br/
<hw>take"o*ver</hw> <pos>n.</pos> <fld>(Business, Finance)</fld> <def>The acquisition of ownership of one company by another company, usually by purchasing a controlling percentage of its stock or by exchanging stock of the purchasing company for that of the purchased company.  It is a <stype>hostile takeover</stype> if the management of the company being taken over is opposed to the deal.  A hostile <ex>takeover</ex> is sometimes organized by a <er>corporate raider</er>.</def><br/
<syn><b>Syn. --</b> acquisition, buyout</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Taker</ent><br/
<hw>Tak"er</hw> <pr>(t<amac/k"<etil/r)</pr>, <pos>n.</pos> <def>One who takes or receives; one who catches or apprehends.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>take the heat</ent><br/
<hw>take` the heat"</hw> <pr>(t<amac/k`<th/<ucr/*h<emac/t")</pr>, <pos>phr.</pos> <sn>1.</sn> <def>To be assigned or to accept the blame for some misdeed; <as>as, Mary broke the vase, but she acted innocent and young Johnny had to <ex>take the heat</ex></as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>To withstand high temperature; <as>as, the new radios can <ex>take the heat</ex> of a black car parked in the sun in Death Valley</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <specif>Hence:</specif> <def>To endure stressful conditions, expecially without signs of difficulty or complaint; <as>as, if you can't <ex>take the heat</ex>, stay out of the kitchen</as>,</def><br/
[<source>PJC</source>]</p>

<p><ent>Take-up</ent><br/
<hw>Take"-up`</hw> <pr>(t<amac/k"<ucr/p`)</pr>, <pos>n.</pos> <fld>(Mach.)</fld> <def>That which takes up or tightens; specifically, a device in a sewing machine for drawing up the slack thread as the needle rises, in completing a stitch.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taking</ent><br/
<hw>Tak"ing</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Apt to take; alluring; attracting.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Subtile in making his temptations most <qex>taking</qex>.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Infectious; contageous.</def> <mark>[Obs.]</mark>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Tak"ing*ly</wf>, <pos>adv.</pos> -- <wf>Tak"ing*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taking</ent><br/
<hw>Tak"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of gaining possession; a seizing; seizure; apprehension.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Agitation; excitement; distress of mind.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>What a <qex>taking</qex> was he in, when your husband asked who was in the basket!</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Malign influence; infection.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taking-off</ent><br/
<hw>Tak"ing-off`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>Removal; murder. See <cref>To take off</cref> <sd>(c)</sd>, under <er>Take</er>, <pos>v. t.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The deep damnation of his <qex>taking-off</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Print.)</fld> <def>The removal of sheets from the press.</def> <mark>[Eng.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <def>Act of presenting a take-off, or burlesque imitation.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Talapoin</ent><br/
<hw>Tal"a*poin</hw> <pr>(t<acr/l"<adot/*poin)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A small African monkey (<spn>Cercopithecus talapoin</spn> or <spn>Miopithecus talapoin</spn>) -- called also <altname>melarhine</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talapoin</ent><br/
\'d8<hw>Tal"a*poin</hw> <pr>(t<acr/l"<adot/*poin)</pr>, <pos>n.</pos> <ety>[Pg. <ets>talapoi</ets>, <ets>talapoin</ets>, name for Buddhist priest, fr. Siamese <ets>t<lsquo/ama p<lsquo/r<acr/</ets>; <ets>t<lsquo/ama</ets>, honorific title + <ets>p<lsquo/r<acr/</ets> priest.]</ety> <def>A Buddhist monk or priest.</def> <mark>[Ceylon & Indo-China]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Talaria</ent><br/
\'d8<hw>Ta*la"ri*a</hw> <pr>(t<adot/*l<amac/"r<icr/*<adot/)</pr>, <pos>n. pl.</pos> <ety>[L., from <ets>talaris</ets> pertaining to the ankles, fr. <ets>talus</ets> ankle.]</ety> <fld>(Class. Myth.)</fld> <def>Small wings or winged shoes represented as fastened to the ankles, -- chiefly used as an attribute of Mercury.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talbot</ent><br/
<hw>Tal"bot</hw> <pr>(t<add/l"b<ucr/t)</pr>, <pos>n.</pos> <def>A sort of dog, noted for quick scent and eager pursuit of game.</def> <mark>[Obs.]</mark>  <rj><au>Wase (1654).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The figure of a dog is borne in the arms of the <xex>Talbot</xex> family, whence, perhaps, the name.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talbotype</ent><br/
<hw>Tal"bo*type</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Photog.)</fld> <def>Same as <er>Calotype</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talc</ent><br/
<hw>Talc</hw> <pr>(t<acr/lk)</pr>, <pos>n.</pos> <ety>[F. <ets>talc</ets>; cf. Sp. & It. <ets>talco</ets>, LL. <ets>talcus</ets>; all fr. Ar. <ets>talq</ets>.]</ety> <fld>(Min.)</fld> <def>A soft mineral of a soapy feel and a greenish, whitish, or grayish color, usually occurring in foliated masses. It is hydrous silicate of magnesia. <stype>Steatite</stype>, or <stype>soapstone</stype>, is a compact granular variety.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Indurated talc</b></col>, <cd>an impure, slaty talc, with a nearly compact texture, and greater hardness than common talc; -- called also <altname>talc slate</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talcous</ent><br/
<ent>Talcose</ent><br/
<mhw>{ <hw>Tal*cose"</hw> <pr>(t<acr/l*k<omac/s" or t<acr/lk"<omac/s`)</pr>, <hw>Talc"ous</hw> <pr>(t<acr/lk"<ucr/s)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>talqueux</ets>.]</ety> <fld>(Min.)</fld> <def>Of or pertaining to talc; composed of, or resembling, talc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talcum</ent><br/
\'d8<hw>Tal"cum</hw> <pr>(t<acr/l"k<ucr/m)</pr>, <pos>n.</pos> <ety>[NL.]</ety> <fld>(Min.)</fld> <def>Same as <er>Talc</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tale</ent><br/
<hw>Tale</hw> <pr>(t<amac/l)</pr>, <pos>n.</pos> <def>See <er>Tael</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tale</ent><br/
<hw>Tale</hw>, <pos>n.</pos> <ety>[AS. <ets>talu</ets> number, speech, narrative; akin to D. <ets>taal</ets> speech, language, G. <ets>zahl</ets> number, OHG. <ets>zala</ets>, Icel. <ets>tal</ets>, <ets>tala</ets>, number, speech, Sw. <ets>tal</ets>, Dan. <ets>tal</ets> number, <ets>tale</ets> speech, Goth. <ets>talzjan</ets> to instruct.  Cf. <er>Tell</er>, <pos>v. t.</pos>, <er>Toll</er> a tax, also <er>Talk</er>, <pos>v. i.</pos>]</ety> <sn>1.</sn> <def>That which is told; an oral relation or recital; any rehearsal of what has occured; narrative; discourse; statement; history; story.</def> <ldquo/The <xex>tale</xex> of Troy divine.<rdquo/ <au>Milton.</au> <ldquo/In such manner rime is Dante's <xex>tale</xex>.<rdquo/ <au>Chaucer.</au><br/
[<source>1913 Webster</source>]</p>

<p><q>We spend our years as a <qex>tale</qex> that is told.</q> <rj><qau>Ps. xc. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A number told or counted off; a reckoning by count; an enumeration; a count, in distinction from measure or weight; a number reckoned or stated.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The ignorant, . . . who measure by <qex>tale</qex>, and not by weight.</q> <rj><qau>Hooker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And every shepherd tells his <qex>tale</qex>,<br/
Under the hawthorn in the dale.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In packing, they keep a just <qex>tale</qex> of the number.</q> <rj><qau>Carew.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <def>A count or declaration.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To tell tale of</b></col>, <cd>to make account of.</cd> <mark>[Obs.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>Therefore little <qex>tale</qex> hath he <qex>told</qex><br/
<qex>Of</qex> any dream, so holy was his heart.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Anecdote; story; fable; incident; memoir; relation; account; legend; narrative.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tale</ent><br/
<hw>Tale</hw> <pr>(t<amac/l)</pr>, <pos>v. i.</pos> <def>To tell stories.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au>  <au>Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talebearer</ent><br/
<hw>Tale"bear`er</hw> <pr>(t<amac/l"b<acir/r`<etil/r)</pr>, <pos>n.</pos> <def>One who officiously tells tales; one who impertinently or maliciously communicates intelligence, scandal, etc., and makes mischief.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Spies and <qex>talebearers</qex>, encouraged by her father, did their best to inflame her resentment.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talebearing</ent><br/
<hw>Tale"bear`ing</hw>, <pos>a.</pos> <def>Telling tales officiously.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talebearing</ent><br/
<hw>Tale"bear`ing</hw>, <pos>n.</pos> <def>The act of informing officiously; communication of secrets, scandal, etc., maliciously.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taled</ent><br/
<hw>Ta"led</hw> <pr>(t<amac/"l<ecr/d)</pr>, <pos>n.</pos> <fld>(Jewish Antiq.)</fld> <def>A kind of quadrangular piece of cloth put on by the Jews when repeating prayers in the synagogues.</def>  <rj><au>Crabb.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taleful</ent><br/
<hw>Tale"ful</hw> <pr>(t<amac/l"f<usdot/l)</pr>, <pos>a.</pos> <def>Full of stories.</def> <mark>[R.]</mark>  <rj><au>Thomson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talegalla</ent><br/
\'d8<hw>Tal`e*gal"la</hw> <pr>(t<amac/l`<esl/*g<acr/l"l<adot/)</pr>, <pos>prop. n.</pos> <ety>[NL.]</ety> <fld>(Zool.)</fld> <def>A genus of Australian birds which includes the brush turkey. See <er>Brush turkey</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talent</ent><br/
<hw>Tal"ent</hw> <pr>(t<acr/l"<eit/nt)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>talentum</ets> a talent (in sense 1), Gr. <grk>ta`lanton</grk> a balance, anything weighed, a definite weight, a talent; akin to <grk>tlh^nai</grk> to bear, endure, <grk>tolma^n</grk>, L. <ets>tolerare</ets>, <ets>tollere</ets>, to lift up, sustain, endure. See <er>Thole</er>, <pos>v. t.</pos>, <er>Tolerate</er>.]</ety> <sn>1.</sn> <def>Among the ancient Greeks, a weight and a denomination of money equal to 60 minae or 6,000 drachmae.  The Attic talent, as a weight, was about 57 lbs. avoirdupois; as a denomination of silver money, its value was <pound/243 15s. sterling, or about $1,180 (using 1900 values).</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Rowing vessel whose burden does not exceed five hundred <qex>talents</qex>.</q> <rj><qau>Jowett (Thucid.).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Among the Hebrews, a weight and denomination of money. For silver it was equivalent to 3,000 shekels, and in weight was equal to about 93<frac34/ lbs. avoirdupois; as a denomination of silver, it has been variously estimated at from <pound/340 to <pound/396 sterling, or about $1,645 to $1,916 (ca. 1900).  For gold it was equal to 10,000 gold shekels.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Inclination; will; disposition; desire.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>They rather counseled you to your <qex>talent</qex> than to your profit.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Intellectual ability, natural or acquired; mental endowment or capacity; skill in accomplishing; a special gift, particularly in business, art, or the like; faculty; a use of the word probably originating in the Scripture parable of the talents (<au>Matt. xxv. 14-30</au>).</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He is chiefly to be considered in his three different <qex>talents</qex>, as a critic, a satirist, and a writer of odes.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His <qex>talents</qex>, his accomplishments, his graceful manners, made him generally popular.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Ability; faculty; gift; endowment. See <er>Genius</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talented</ent><br/
<hw>Tal"ent*ed</hw>, <pos>a.</pos> <def>Furnished with talents; possessing skill or talent; mentally gifted.</def>  <rj><au>Abp. Abbot (1663).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This word has been strongly objected to by Coleridge and some other critics, but, as it would seem, upon not very good grounds, as the use of <xex>talent</xex> or <xex>talents</xex> to signify mental ability, although at first merely metaphorical, is now fully established, and <xex>talented</xex>, as a formative, is just as analogical and legitimate as <xex>gifted</xex>, <xex>bigoted</xex>, <xex>moneyed</xex>, <xex>landed</xex>, <xex>lilied</xex>, <xex>honeyed</xex>, and numerous other adjectives having a participal form, but derived directly from nouns and not from verbs.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tales</ent><br/
\'d8<hw>Ta"les</hw> <pr>(t<amac/"l<emac/z)</pr>, <pos>n.</pos> <ety>[L., pl. of <ets>talis</ets> such (persons).]</ety> <fld>(Law)</fld> <sd>(a)</sd> <pluf>pl.</pluf> <def>Persons added to a jury, commonly from those in or about the courthouse, to make up any deficiency in the number of jurors regularly summoned, being like, or <xex>such</xex> as, the latter.</def> <au>Blount.</au>  <au>Blackstone.</au> <sd>(b)</sd> <pos>syntactically sing.</pos> <def>The writ by which such persons are summoned.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tales book</b></col>, <cd>a book containing the names of such as are admitted of the tales.</cd> <au>Blount.</au> <au>Craig.</au> -- \'d8<col><b>Tales de circumstantibus</b></col> <ety>[L.]</ety>, <cd>such, or the like, from those standing about.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talesman</ent><br/
<hw>Tales"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Talesmen</plw> <pr>(<?/)</pr>.</plu> <fld>(Law)</fld> <def>A person called to make up a deficiency in the number of jurors when a tales is awarded.</def>  <rj><au>Wharton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taleteller</ent><br/
<hw>Tale"tell`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who tells tales or stories, especially in a mischievous or officious manner; a talebearer; a telltale; a tattler.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talewise</ent><br/
<hw>Tale"wise`</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a way of a tale or story.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taliacotian</ent><br/
<hw>Tal"ia*co`tian</hw> <pr>(?)</pr>, <pos>a.</pos> <def>See <er>Tagliacotian</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taliation</ent><br/
<hw>Tal`i*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Retaliation.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Just heav'n this <qex>taliation</qex> did decree.</q> <rj><qau>Beaumont.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talion</ent><br/
<hw>Ta"li*on</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>talio</ets>, perh. fr. <ets>talis</ets> such.  Cf. <er>Retaliation</er>.]</ety> <def>Retaliation.</def> <mark>[R.]</mark>  <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talipes</ent><br/
\'d8<hw>Tal"i*pes</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. L. <ets>talus</ets> an ankle + <ets>pes</ets>, <ets>pedis</ets>, a foot; cf. L. <ets>talipedare</ets> to be weak in the feet, properly, to walk on the ankles.]</ety> <fld>(Surg.)</fld> <def>The deformity called <altname>clubfoot</altname>. See <er>Clubfoot</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Several varieties are distinguished; as, <stype>Talipes varus</stype>, in which the foot is drawn up and bent inward; <stype>T. valgus</stype>, in which the foot is bent outward; <stype>T. equinus</stype>, in which the sole faces backward and the patient walks upon the balls of the toes; and <stype>T. calcaneus</stype> (called also <stype>talus</stype>), in which the sole faces forward and the patient walks upon the heel.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talipot</ent><br/
<hw>Tal"i*pot</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Hind. <ets>t<amac/lp<amac/t</ets> the leaf of the tree.]</ety> <fld>(Bot.)</fld> <def>A beautiful tropical palm tree (<spn>Corypha umbraculifera</spn>), a native of Ceylon and the Malabar coast. It has a trunk sixty or seventy feet high, bearing a crown of gigantic fan-shaped leaves which are used as umbrellas and as fans in ceremonial processions, and, when cut into strips, as a substitute for writing paper.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1471 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talisman</ent><br/
<hw>Tal"is*man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Talismans</plw> <pr>(#)</pr>.</plu> <ety>[Sp., from Ar. <ets>tilism</ets>, <ets>tilsam</ets>, a magical image, pl. <ets>tilsam<amac/n</ets>, fr. Gr. <?/ tribute, tax, LGr., an initiation, incantation, from <?/ to complete, perform, to play taxes, to make perfect, to initiate, especially in the mysteries, fr. <?/ completion, end.]</ety> <sn>1.</sn> <def>A magical figure cut or engraved under certain superstitious observances of the configuration of the heavens, to which wonderful effects are ascribed; the seal, figure, character, or image, of a heavenly sign, constellation, or planet, engraved on a sympathetic stone, or on a metal corresponding to the star, in order to receive its influence.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, something that produces extraordinary effects, esp. in averting or repelling evil; an amulet; a charm; <as>as, a <ex>talisman</ex> to avert diseases</as>.</def>  <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talismanical</ent><br/
<ent>Talismanic</ent><br/
<mhw>{ <hw>Tal`is*man"ic</hw> <pr>(?)</pr>, <hw>Tal`is*man"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>talismanique</ets>.]</ety> <def>Of or pertaining to a talisman; having the properties of a talisman, or preservative against evils by occult influence; magical.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>talk</ent><br/
<hw>talk</hw> <pr>(t<add/k)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>talked</conjf> <pr>(t<add/kt)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>talking</conjf>.]</vmorph> <ety>[Cf. LG. <ets>talk</ets> talk, gabble, Prov. G. <ets>talken</ets> to speak indistinctly; or OD. <ets>tolken</ets> to interpret, MHG. <ets>tolkan</ets> to interpret, to tell, to speak indistinctly, Dan. <ets>tolke</ets> to interpret, Sw. <ets>tolka</ets>, Icel. <ets>t<umac/lka</ets> to interpret, <ets>t<umac/lkr</ets> an interpreter, Lith. <ets>tulkas</ets> an interpreter, <ets>tulkanti</ets>, <ets>tulk<omac/ti</ets>, to interpret, Russ. <ets>tolkovate</ets> to interpret, to talk about; or perhaps fr. OE. <ets>talien</ets> to speak (see <er>tale</er>, <pos>v. i.</pos> & <pos>n.</pos>).]</ety> <sn>1.</sn> <def>To utter words; esp., to converse familiarly; to speak, as in familiar discourse, when two or more persons interchange thoughts.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I will buy with you, sell with you, <qex>talk</qex> with you, walk with you, and so following, but I will not eat with you.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To confer; to reason; to consult.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let me <qex>talk</qex> with thee of thy judgments.</q> <rj><qau>Jer. xii. 1.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To prate; to speak impertinently.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To talk of</b></col>, <cd>to relate; to tell; to give an account of; <as>as, authors <ex>talk of</ex> the wonderful remains of Palmyra</as>.</cd> <ldquo/The natural histories of Switzerland <xex>talk</xex> much <xex>of</xex> the fall of these rocks, and the great damage done.<rdquo/ <au>Addison.</au> -- <col><b>To talk to</b></col>, <cd>to advise or exhort, or to reprove gently; <as>as, I will <ex>talk to</ex> my son respecting his conduct</as>.</cd> <mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talk</ent><br/
<hw>Talk</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To speak freely; to use for conversing or communicating; <as>as, to <ex>talk</ex> French</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To deliver in talking; to speak; to utter; to make a subject of conversation; <as>as, to <ex>talk</ex> nonsense; to <ex>talk</ex> politics</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To consume or spend in talking; -- often followed by <xex>away</xex>; <as>as, to <ex>talk</ex> away an evening</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To cause to be or become by talking.</def> <ldquo/They would <xex>talk</xex> themselves mad.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To talk over</b></col>. <sd>(a)</sd> <cd>To talk about; to have conference respecting; to deliberate upon; to discuss; <as>as, to <ex>talk over</ex> a matter or plan</as>.</cd> <sd>(b)</sd> <cd>To change the mind or opinion of by talking; to convince; <as>as, to <ex>talk over</ex> an opponent</as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talk</ent><br/
<hw>Talk</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of talking; especially, familiar converse; mutual discourse; that which is uttered, especially in familiar conversation, or the mutual converse of two or more.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In various <qex>talk</qex> the instructive hours they passed.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Their <qex>talk</qex>, when it was not made up of nautical phrases, was too commonly made up of oaths and curses.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Report; rumor; <as>as, to hear <ex>talk</ex> of war</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I hear a <qex>talk</qex> up and down of raising our money.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Subject of discourse; <as>as, his achievment is the <ex>talk</ex> of the town</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Conversation; colloquy; discourse; chat; dialogue; conference; communication. See <er>Conversation</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talkative</ent><br/
<hw>Talk"a*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Given to much talking.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Garrulous; loquacious. See <er>Garrulous</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Talk"a*tive*ly</wf>, <pos>adv.</pos> -- <wf>Talk"a*tive*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talker</ent><br/
<hw>Talk"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who talks; especially, one who is noted for his power of conversing readily or agreeably; a conversationist.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There probably were never four <qex>talkers</qex> more admirable in four different ways than Johnson, Burke, Beauclerk, and Garrick.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A loquacious person, male or female; a prattler; a babbler; also, a boaster; a braggart; -- used in contempt or reproach.</def>  <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talking</ent><br/
<hw>Talk"ing</hw>, <pos>a.</pos> <sn>1.</sn> <def>That talks; able to utter words; <as>as, a <ex>talking</ex> parrot</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Given to talk; loquacious.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The hawthorn bush, with seats beneath the shade,<br/
For <qex>talking</qex> age and whispering lovers made.</q> <rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tall</ent><br/
<hw>Tall</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Taller</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Tallest</adjf>.]</amorph> <ety>[OE. <ets>tal</ets> seemly, elegant, docile (?); of uncertain origin; cf. AS. un-<ets>tala</ets>, un-<ets>tale</ets>, bad, Goth. un<ets>tals</ets> indocile, disobedient, uninstructed, or W. & Corn. <ets>tal</ets> high, Ir. <ets>talla</ets> meet, fit, proper, just.]</ety> <sn>1.</sn> <def>High in stature; having a considerable, or an unusual, extension upward; long and comparatively slender; having the diameter or lateral extent small in proportion to the height; <as>as, a <ex>tall</ex> person, tree, or mast</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Two of far nobler shape, erect and <qex>tall</qex>.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Brave; bold; courageous.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>As <qex>tall</qex> a trencherman<br/
As e'er demolished a pye fortification.</q> <rj><qau>Massinger.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His companions, being almost in despair of victory, were suddenly recomforted by Sir William Stanley, which came to succors with three thousand <qex>tall</qex> men.</q> <rj><qau>Grafton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Fine; splendid; excellent; also, extravagant; excessive.</def> <mark>[Obs. or Slang]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- High; lofty.</syn> <usage> -- <er>Tall</er>, <er>High</er>, <er>Lofty</er>. <xex>High</xex> is the generic term, and is applied to anything which is elevated or raised above another thing. <xex>Tall</xex> specifically describes that which has a small diameter in proportion to its height; hence, we speak of a <xex>tall</xex> man, a <xex>tall</xex> steeple, a <xex>tall</xex> mast, etc., but not of a <xex>tall</xex> hill. <xex>Lofty</xex> has a special reference to the expanse above us, and denotes an imposing height; <as>as, a <ex>lofty</ex> mountain; a <ex>lofty</ex> room</as>. <xex>Tall</xex> is now properly applied only to physical objects; <xex>high</xex> and <xex>lofty</xex> have a moral acceptation; <as>as, <ex>high</ex> thought, purpose, etc.</as>; <xex>lofty</xex> aspirations; a <xex>lofty</xex> genius. <xex>Lofty</xex> is the stronger word, and is usually coupled with the grand or admirable.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talliage</ent><br/
<ent>Tallage</ent><br/
<mhw>{ <hw>Tal"lage</hw> <pr>(?)</pr>, <hw>Tal"li*age</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[F. <ets>taillage</ets>. See <er>Taille</er>, and cf. <er>Tailage</er>.]</ety> <fld>(O. Eng. Law)</fld> <def>A certain rate or tax paid by barons, knights, and inferior tenants, toward the public expenses.</def> <altsp>[Written also <asp>tailage</asp>, <asp>taillage</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ When paid out of knight's fees, it was called <stype>scutage</stype>; when by cities and burghs, <stype>tallage</stype>; when upon lands not held by military tenure, <stype>hidage</stype>.</note>  <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallage</ent><br/
<hw>Tal"lage</hw>, <pos>v. t.</pos> <def>To lay an impost upon; to cause to pay tallage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallboy</ent><br/
<hw>Tall"boy`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A kind of long-stemmed wineglass or cup.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>A piece of household furniture common in the eighteenth century, usually in two separate parts, with larger drawers above and smaller ones below and raised on legs fifteen inches or more in height; -- called also <altname>highboy</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <def>A long sheet-metal pipe for a chimney top.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tallier</ent><br/
<hw>Tal"li*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who keeps tally.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallis</ent><br/
\'d8<hw>Tal"lis</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Tallith</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tallith</ent><br/
\'d8<hw>Tal"lith</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NHeb. <ets>tall<imac/th</ets>.]</ety> <fld>(Jewish Costume)</fld> <sd>(a)</sd> <def>An undergarment worn by orthodox Jews, covering the chest and the upper part of the back. It has an opening for the head, and has tassels, called <part>zizith</part>, on its four corners.</def> <sd>(b)</sd> <def>A tasseled shawl or scarf worn over the head or thrown round the shoulders while at prayer.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tallness</ent><br/
<hw>Tall"ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being tall; height of stature.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallow</ent><br/
<hw>Tal"low</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>taluh</ets>, <ets>talugh</ets>; akin to OD. <ets>talgh</ets>, D. <ets>talk</ets>, G., Dan. and Sw. <ets>talg</ets>, Icel. <ets>t<omac/lgr</ets>, <ets>t<omac/lg</ets>, <ets>t<omac/lk</ets>; and perhaps to Goth. <ets>tulgus</ets> firm.]</ety> <sn>1.</sn> <def>The suet or fat of animals of the sheep and ox kinds, separated from membranous and fibrous matter by melting.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The solid consistency of tallow is due to the large amount of stearin it contains. See <er>Fat</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The fat of some other animals, or the fat obtained from certain plants, or from other sources, resembling the fat of animals of the sheep and ox kinds.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tallow candle</b></col>, <cd>a candle made of tallow.</cd> -- <col><b>Tallow catch</b></col>, <cd>a keech.</cd> See <er>Keech</er>. <mark>[Obs.]</mark> -- <col><b>Tallow chandler</b></col>, <cd>one whose occupation is to make, or to sell, tallow candles.</cd> -- <col><b>Tallow chandlery</b></col>, <cd>the trade of a tallow chandler; also, the place where his business is carried on.</cd> -- <col><b>Tallow tree</b></col> <fld>(Bot.)</fld>, <cd>a tree (<spn>Stillingia sebifera</spn>) growing in China, the seeds of which are covered with a substance which resembles tallow and is applied to the same purposes.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallow</ent><br/
<hw>Tal"low</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tallowed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tallowing</conjf>.]</vmorph> <sn>1.</sn> <def>To grease or smear with tallow.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cause to have a large quantity of tallow; to fatten; <as>as, <ex>tallow</ex> sheep</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallower</ent><br/
<hw>Tal"low*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An animal which produces tallow.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallow-face</ent><br/
<hw>Tal"low-face`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who has a sickly, pale complexion.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallow-faced</ent><br/
<hw>Tal"low-faced`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having a sickly complexion; pale.</def>  <rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallowing</ent><br/
<hw>Tal"low*ing</hw>, <pos>n.</pos> <def>The act, or art, of causing animals to produce tallow; also, the property in animals of producing tallow.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallowish</ent><br/
<hw>Tal"low*ish</hw>, <pos>a.</pos> <def>Having the qualities of tallow.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallowy</ent><br/
<hw>Tal"low*y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of the nature of tallow; resembling tallow; greasy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallwood</ent><br/
<hw>Tall"wood`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Tally</er>.]</ety> <def>Firewood cut into billets of a certain length.</def> <mark>[Obs.]</mark> <mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tally</ent><br/
<hw>Tal"ly</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tallies</plw> <pr>(#)</pr>.</plu> <ety>[OE. <ets>taile</ets>, <ets>taille</ets>, F. <ets>taille</ets> a cutting, cut tally, fr. <ets>tailler</ets> to cut, but influenced probably by <ets>taill<eacute/</ets>, p. p. of <ets>tailler</ets>. See <er>Tailor</er>, and cf. <er>Tail</er> a limitation, <er>Taille</er>, <er>Tallage</er>.]</ety> <sn>1.</sn> <def>Originally, a piece of wood on which notches or scores were cut, as the marks of number; later, one of two books, sheets of paper, etc., on which corresponding accounts were kept.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In purshasing and selling, it was once customary for traders to have two sticks, or one stick cleft into two parts, and to mark with a score or notch, on each, the number or quantity of goods delivered, -- the seller keeping one stick, and the purchaser the other. Before the use of writing, this, or something like it, was the only method of keeping accounts; and <xex>tallies</xex> were received as evidence in courts of justice. In the English exchequer were <xex>tallies</xex> of loans, one part being kept in the exchequer, the other being given to the creditor in lieu of an obligation for money lent to government.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, any account or score kept by notches or marks, whether on wood or paper, or in a book; especially, one kept in duplicate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>One thing made to suit another; a match; a mate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They were framed the <qex>tallies</qex> for each other.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A notch, mark, or score made on or in a tally; <as>as, to make or earn a <ex>tally</ex> in a game</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A tally shop. See <cref>Tally shop</cref>, below.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tally shop</b></col>, <cd>a shop at which goods or articles are sold to customers on account, the account being kept in corresponding books, one called the <xex>tally</xex>, kept by the buyer, the other the <xex>counter tally</xex>, kept by the seller, and the payments being made weekly or otherwise by agreement. The trade thus regulated is called <xex>tally trade</xex>.</cd> <au>Eng. Encyc.</au> -- <col><b>To strike tallies</b></col>, <cd>to act in correspondence, or alike.</cd> <mark>[Obs.]</mark> <au>Fuller.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tally</ent><br/
<hw>Tal"ly</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tallied</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tallying</conjf>.]</vmorph> <ety>[Cf. F. <ets>tialler</ets> to cut. See <er>Tally</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To score with correspondent notches; hence, to make to correspond; to cause to fit or suit.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They are not so well <qex>tallied</qex> to the present juncture.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>To check off, as parcels of freight going inboard or outboard.</def>  <rj><au>W. C. Russell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tally on</b></col> <fld>(Naut.)</fld>, <cd>to dovetail together.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tally</ent><br/
<hw>Tal"ly</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To be fitted; to suit; to correspond; to match.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I found pieces of tiles that exactly <qex>tallied</qex> with the channel.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Your idea . . . <qex>tallies</qex> exactly with mine.</q> <rj><qau>Walpole.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make a tally; to score; <as>as, to <ex>tally</ex> in a game</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tally on</b></col> <fld>(Naut.)</fld>, <cd>to man a rope for hauling, the men standing in a line or tail.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tally</ent><br/
<hw>Tal"ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[See <er>Tall</er>, <pos>a.</pos>]</ety> <def>Stoutly; with spirit.</def> <mark>[Obs.]</mark>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallyho</ent><br/
<hw>Tal"ly*ho`</hw> <pr>(?)</pr>, <pos>interj. & n.</pos> <sn>1.</sn> <def>The huntsman's cry to incite or urge on his hounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tallyho coach.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tallyho coach</b></col>, <cd>a pleasure coach. See under <er>Coach</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tallyman</ent><br/
<hw>Tal"ly*man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tallymen</plw> <pr>(<?/)</pr>.</plu> <sn>1.</sn> <def>One who keeps the tally, or marks the sticks.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who keeps a tally shop, or conducts his business as tally trade.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talma</ent><br/
<hw>Tal"ma</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Talmas</plw> <pr>(#)</pr>.</plu> <ety>[Prob. so called from <ets>Talma</ets>, a French actor.]</ety> <sd>(a)</sd> <def>A kind of large cape, or short, full cloak, forming part of the dress of ladies.</def> <sd>(b)</sd> <def>A similar garment worn formerly by gentlemen.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talmud</ent><br/
<hw>Tal"mud</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Chald. <ets>talm<umac/d</ets> instruction, doctrine, fr. <ets>lamad</ets> to learn, <ets>limmad</ets> to teach.]</ety> <def>The body of the Jewish civil and canonical law not comprised in the Pentateuch.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>Talmud</xex> consists of two parts, the <xex>Mishna</xex>, or text, and the <xex>Gemara</xex>, or commentary. Sometimes, however, the name <xex>Talmud</xex> is restricted, especially by Jewish writers, to the Gemara. There are two Talmuds, the <xex>Palestinian</xex>, commonly, but incorrectly, called the <xex>Talmud of Jerusalem</xex>, and the <xex>Babylonian Talmud</xex>. They contain the same Mishna, but different Gemaras. The Babylonian Talmud is about three times as large as the other, and is more highly esteemed by the Jews.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talmudical</ent><br/
<ent>Talmudic</ent><br/
<mhw>{ <hw>Tal*mud"ic</hw> <pr>(?)</pr>, <hw>Tal*mud"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>talmudique</ets>.]</ety> <def>Of or pertaining to the Talmud; contained in the Talmud; <as>as, <ex>Talmudic</ex> Greek; <ex>Talmudical</ex> phrases.</as></def>  <rj><au>Lightfoot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talmudism</ent><br/
<hw>Tal"mud*ism</hw> <pr>(?)</pr>, <pos>n.</pos>  <pr>(<?/)</pr>, <pos>n.</pos> <def>The teachings of the Talmud, or adherence to them.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Talmudist</ent><br/
<hw>Tal"mud*ist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>talmudiste</ets>.]</ety> <def>One versed in the Talmud; one who adheres to the teachings of the Talmud.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talmudistic</ent><br/
<hw>Tal`mud*is"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Resembling the Talmud; Talmudic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talon</ent><br/
<hw>Tal"on</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., heel, spur, LL. <ets>talo</ets>, fr. L. <ets>talus</ets> the ankle, heel.]</ety> <sn>1.</sn> <def>The claw of a predaceous bird or animal, especially the claw of a bird of prey.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>One of certain small prominences on the hind part of the face of an elephant's tooth.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Arch.)</fld> <def>A kind of molding, concave at the bottom and convex at the top; -- usually called an <altname>ogee</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ When the concave part is at the top, it is called an <stype>inverted talon</stype>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The shoulder of the bolt of a lock on which the key acts to shoot the bolt.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taluk</ent><br/
<ent>Talook</ent><br/
<mhw>{ <hw>Ta*look"</hw>, <hw>Ta*luk"</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Ar. <ets>ta'lluq</ets>.]</ety> <def>A large estate; esp., one constituting a revenue district or dependency the native proprietor of which is responsible for the collection and payment of the public revenue due from it.</def> <mark>[India]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talukdar</ent><br/
<ent>Talookdar</ent><br/
<mhw>{ <hw>Ta*look"dar</hw>, <hw>Ta*luk"dar</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Hind., fr. Per. <ets>ta'lluqd<amac/r</ets>.]</ety> <def>A proprietor of a talook.</def> <mark>[India]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talpa</ent><br/
\'d8<hw>Tal"pa</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., mole.]</ety> <fld>(Zool.)</fld> <def>A genus of small insectivores including the common European mole.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talus</ent><br/
\'d8<hw>Ta"lus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tali</plw> <pr>(#)</pr>.</plu> <ety>[L., the ankle, the ankle bone.]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>The astragalus.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Surg.)</fld> <def>A variety of clubfoot (<spn>Talipes calcaneus</spn>). See the Note under <er>Talipes</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Talus</ent><br/
<hw>Ta"lus</hw>, <pos>n.</pos> <ety>[F.]</ety> <sn>1.</sn> <fld>(Fort.)</fld> <def>A slope; the inclination of the face of a work.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geol.)</fld> <def>A sloping heap of fragments of rock lying at the foot of a precipice.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamability</ent><br/
<hw>Tam`a*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being tamable; tamableness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamable</ent><br/
<hw>Tam"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being tamed, subdued, or reclaimed from wildness or savage ferociousness.</def> -- <wordforms><wf>Tam"a*ble*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamale</ent><br/
<hw>Ta*ma"le</hw> <pr>(?)</pr>, <pos>n.</pos> <altsp>[Written also <asp>tamal</asp>, <asp>tomale</asp>.]</altsp> <ety>[Amer. Sp. <ets>tamal</ets>, of Mex. origin.]</ety> <def>A Mexican dish made of crushed corn (cornmeal) mixed with minced meat, seasoned with red pepper, dipped in oil, and steamed.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tamandu</ent><br/
<hw>Ta*man"du</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp., from the native name: cf. F. <ets>tamandua</ets>.]</ety> <fld>(Zool.)</fld> <def>A small ant-eater (<spn>Tamandua tetradactyla</spn>) native of the tropical parts of South America.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It has five toes on the fore feet, an elongated snout, small ears, and short woolly hair. Its tail is stout and hairy at the base, tapering, and covered with minute scales, and is somewhat prehensile at the end. Called also <altname>tamandua</altname>, <altname>little ant-bear</altname>, <altname>fourmilier</altname>, and <altname>cagouare</altname>.
    The collared, or striped, tamandu (<stype><spn>Tamandua bivittata</spn></stype>) is considered a distinct species by some writers, but by others is regarded as only a variety.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamanoir</ent><br/
<hw>Ta`ma*noir"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The ant-bear.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamarack</ent><br/
<hw>Tam"a*rack</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <sd>(a)</sd> <def>The American larch; also, the larch of Oregon and British Columbia (<spn>Larix occidentalis</spn>). See <er>Hackmatack</er>, and <er>Larch</er>.</def> <sd>(b)</sd> <def>The black pine (<spn>Pinus Murrayana</spn>) of Alaska, California, etc. It is a small tree with fine-grained wood.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamaric</ent><br/
<hw>Tam"a*ric</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tamarice</ets>. See <er>Tamarisk</er>.]</ety> <def>A shrub or tree supposed to be the tamarisk, or perhaps some kind of heath.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He shall be like <qex>tamaric</qex> in the desert, and he shall not see when good shall come.</q> <rj><qau>Jer. xvii. 6 (Douay version).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamarin</ent><br/
<hw>Tam"a*rin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native name in Cayenne.]</ety> <fld>(Zool.)</fld> <def>Any one of several species of small squirrel-like South American monkeys of the genus <gen>Midas</gen>, especially <spn>Midas ursulus</spn>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1472 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamarind</ent><br/
<hw>Tam"a*rind</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It. <ets>tamarindo</ets>, or Sp. <ets>tamarindo</ets>, or Pg. <ets>tamarindo</ets>, <ets>tamarinho</ets>, from Ar. <ets>tamarhind<imac/</ets>, literally, Indian date; <ets>tamar</ets> a dried date + <ets>Hind</ets> India: cf. F. <ets>tamarin</ets>.  Cf. <er>Hindu</er>.]</ety> <fld>(Bot.)</fld> <sn>1.</sn> <def>A leguminous tree (<spn>Tamarindus Indica</spn>) cultivated both the Indies, and the other tropical countries, for the sake of its shade, and for its fruit. The trunk of the tree is lofty and large, with wide-spreading branches; the flowers are in racemes at the ends of the branches. The leaves are small and finely pinnated.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of the preserved seed pods of the tamarind, which contain an acid pulp, and are used medicinally and for preparing a pleasant drink.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tamarind fish</b></col>, <cd>a preparation of a variety of East Indian fish with the acid pulp of the tamarind fruit.</cd> -- <col><b>Velvet tamarind</b></col>. <sd>(a)</sd> <cd>A West African leguminous tree (<spn>Codarium acutifolium</spn>).</cd> <sd>(b)</sd> <cd>One of the small black velvety pods, which are used for food in Sierra Leone.</cd> -- <col><b>Wild tamarind</b></col> <fld>(Bot.)</fld>, <cd>a name given to certain trees somewhat resembling the tamarind, as the <spn>Lysiloma latisiliqua</spn> of Southern Florida, and the <spn>Pithecolobium filicifolium</spn> of the West Indies.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamarisk</ent><br/
<hw>Tam"a*risk</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tamariscus</ets>, also <ets>tamarix</ets>, <ets>tamarice</ets>, Skr. <ets>tam<amac/la</ets>, <ets>tam<amac/laka</ets>, a tree with a very dark bark; cf. <ets>tamas</ets> darkness: cf. F. <ets>tamarisc</ets>, <ets>tamarix</ets>, <ets>tamaris</ets>.]</ety> <fld>(Bot.)</fld> <def>Any shrub or tree of the genus <gen>Tamarix</gen>, the species of which are European and Asiatic.  They have minute scalelike leaves, and small flowers in spikes.  An Arabian species (<spn>Tamarix mannifera</spn>) is the source of one kind of manna.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tamarisk salt tree</b></col>, <cd>an East Indian tree (<spn>Tamarix orientalis</spn>) which produces an incrustation of salt.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tambac</ent><br/
<hw>Tam"bac</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Metal.)</fld> <def>See <er>Tombac</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tambour</ent><br/
<hw>Tam"bour</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Mus.)</fld> <def>A kind of small flat drum; a tambourine.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A small frame, commonly circular, and somewhat resembling a tambourine, used for stretching, and firmly holding, a portion of cloth that is to be embroidered; also, the embroidery done upon such a frame; -- called also, in the latter sense, <altname>tambour work</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Arch.)</fld> <def>Same as <er>Drum</er>, <pos>n.</pos>, 2<sd>(d)</sd>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Fort.)</fld> <def>A work usually in the form of a redan, to inclose a space before a door or staircase, or at the gorge of a larger work. It is arranged like a stockade.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Physiol.)</fld> <def>A shallow metallic cup or drum, with a thin elastic membrane supporting a writing lever. Two or more of these are connected by an India rubber tube, and used to transmit and register the movements of the pulse or of any pulsating artery.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tambour</ent><br/
<hw>Tam"bour</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tamboured</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tambouring</conjf>.]</vmorph> <def>To embroider on a tambour.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamboura</ent><br/
<hw>Tam*bour"a</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Mus.)</fld> <def>A stringed musical instrument resembling a lute but lacking frets, with a small round body and a long neck, used to produce an accompaniment for singing; -- called also <altname>tambur</altname>, <altname>tambour</altname>, and <altname>tampur</altname>.</def> <altsp>[Also spelled <asp>tambura</asp>.]</altsp><br/
[<source>PJC</source>]</p>

<p><ent>Tambourin</ent><br/
<hw>Tam`bou`rin"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See <er>Tambourine</er>.]</ety> <sn>1.</sn> <def>A tambourine.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>An old Proven<cced/al dance of a lively character, common on the stage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tambourine</ent><br/
<hw>Tam`bour*ine"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tambourin</ets>; cf. It. <ets>tamburino</ets>. See <er>Tambour</er>, and cf. <er>Tamborine</er>.]</ety> <def>A small drum, especially a shallow drum with only one skin, played on with the hand, and having bells at the sides; a timbrel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tambourine</ent><br/
<hw>Tam`bour*ine"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A South American wild dove (<spn>Tympanistria tympanistria</spn>), mostly white, with black-tiped wings and tail. Its resonant note is said to be ventriloquous.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tambreet</ent><br/
<hw>Tam"breet</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The duck mole.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamburin</ent><br/
<hw>Tam`bu*rin"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tambourine</er>.</def>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tame</ent><br/
<hw>Tame</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[Cf. F. <ets>entamer</ets> to cut into, to broach.]</ety> <def>To broach or enter upon; to taste, as a liquor; to divide; to distribute; to deal out.</def> <mark>[Obs. or Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In the time of famine he is the Joseph of the country, and keeps the poor from starving. Then he <qex>tameth</qex> his stacks of corn, which not his covetousness, but providence, hath reserved for time of need.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tame</ent><br/
<hw>Tame</hw>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Tamer</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Tamest</adjf>.]</amorph> <ety>[AS. <ets>tam</ets>; akin to D. <ets>tam</ets>, G. <ets>zahm</ets>, OHG. <ets>zam</ets>, Dan. & Sw. <ets>tam</ets>, Icel. <ets>tamr</ets>, L. <ets>domare</ets> to tame, Gr. <?/, Skr. <ets>dam</ets> to be tame, to tame, and perhaps to E. <ets>beteem</ets>. <root/61.  Cf. <er>Adamant</er>, <er>Diamond</er>, <er>Dame</er>, <er>Daunt</er>, <er>Indomitable</er>.]</ety> <sn>1.</sn> <def>Reduced from a state of native wildness and shyness; accustomed to man; domesticated; domestic; <as>as, a <ex>tame</ex> deer, a <ex>tame</ex> bird</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Crushed; subdued; depressed; spiritless.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tame</qex> slaves of the laborious plow.</q> <rj><qau>Roscommon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Deficient in spirit or animation; spiritless; dull; flat; insipid; <as>as, a <ex>tame</ex> poem; <ex>tame</ex> scenery</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Gentle; mild; meek. See <er>Gentle</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tame</ent><br/
<hw>Tame</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tamed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Taming</conjf>.]</vmorph> <ety>[AS. <ets>tamian</ets>, <ets>temian</ets>, akin to D. <ets>tammen</ets>, <ets>temmen</ets>, G. <ets>z<aum/hmen</ets>, OHG. <ets>zemmen</ets>, Icel. <ets>temja</ets>, Goth. ga<ets>tamjan</ets>. See <er>Tame</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>To reduce from a wild to a domestic state; to make gentle and familiar; to reclaim; to domesticate; <as>as, to <ex>tame</ex> a wild beast</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They had not been <qex>tamed</qex> into submission, but baited into savegeness and stubbornness.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To subdue; to conquer; to repress; <as>as, to <ex>tame</ex> the pride or passions of youth</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tameable</ent><br/
<hw>Tame"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Tamable.</def>  <rj><au>Bp. Wilkins.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tameless</ent><br/
<hw>Tame"less</hw>, <pos>a.</pos> <def>Incapable of being tamed; wild; untamed; untamable.</def> <au>Bp. Hall.</au> -- <wordforms><wf>Tame"less*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamely</ent><br/
<hw>Tame"ly</hw>, <pos>adv.</pos> <def>In a tame manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tameness</ent><br/
<hw>Tame"ness</hw>, <pos>n.</pos> <def>The quality or state of being tame.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamer</ent><br/
<hw>Tam"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who tames or subdues.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamerlane</ent><br/
<hw>Ta*mer*lane"</hw> <pr>(t<acr/*m<etil/r*l<amac/n")</pr>, <pos>prop. n.</pos> <def>A Tatar conquerer, also called <altname>Timur</altname> or <altname>Timour</altname> (t<emac/*m<ocir/r") or <altname>Timur Bey</altname>, also <altname>Timur-Leng</altname> or <altname>Timur-i-Leng</altname> ('Timur the Lame'), which was corrupted to <ex>Tamerlane</ex>.  He was born in Central Asia, 1333, a member of the Barslas, a Turkish Mongol tribe which had converted to Islam.  He died 1405.  Though he claimed descent from Jenghiz Khan, it is believed that he was in fact descended from a follower of the Khan.  By 1370, Tamerlane, a renowned warrior, began consolidating his power among the various nomadic tribes of Central Asia by conquering the entire region. He became a ruler about 1370 of a realm whose capital was Samarkand; conquered Persia, Central Asia, and in 1398 a great part of India, including Delhi; waged war with the Turkish <person>Sultan Bajazet I.</person> (Beyazid), whom he defeated at Ankara in 1402 and took prisoner; and died while preparing to invade China.  By the end of his life in 1405, after 35 years of campaigns and wars that left hundreds of thousands dead and enslaved, he had successfully defeated Ottoman Turks, Hindus, The Golden Horde, and other peoples and controlled an empire stretching from the Aegean to the River Ganges and threatened the trembling Kingdoms of Europe and the Eastern Roman Empire.  He is the <asp>Tamerlaine</asp> of the plays.</def><br/
[<source>Century Dict. 1906</source> + <source>PJC</source>]</p>

<p><q>Just at the moment when the Sultan (Bajazet) seemed to have attained the pinnacle of his ambition, when his authority was unquestioningly obeyed over the greater part of the Byzantine Empire in Europe and Asia, when the Christian states were regarding him with terror as the scourge of the world, another and greater scourge came to quell him, and at one stroke all the vast fabric of empire which Bayezid (Beyazid or B<amac/yez<imac/d) had so triumphantly erected was shattered to the ground.  This terrible conquerer was Tim<umac/r the Tatar, or as we call him, <ldquo/Tamerlane<rdquo/.  Tim<umac/r was of Turkish race, and was born near Samarkand in 1333.  He was consequently an old man of 70 when he came to encounter B<amac/yez<imac/d in 1402.  It had taken him many years to establish his authority over a portion of the numerous divisions into which the immense empire of Chingiz Khan had fallen after the death of that stupendous conqueror.  Tim<umac/r was but a petty chief among many others: but at last he won his way and became ruler of Samarkand and the whole province of Transoxiana, or 'Beyond the River' (M<amac/-war<amac/-n-nahr) as the Arabs called the country north of the Oxus.  Once fairly established in this province, Tim<umac/r began to overrun the surrounding lands, and during thirty years his ruthless armies spread over the provinces of Asia, from Delhi to Damascus, and from the Sea of Aral to the Persian Gulf.  The subdivision of the Moslem Empire into numerous petty kingdoms rendered it powerless to meet the overwhelming hordes which Tim<umac/r brought down from Central Asia.  One and all, the kings and princes of Persia and Syria succumbed, and Tim<umac/r carried his banners triumphantly as far as the frontier of Egypt, where the brave Mamluk Sultans still dared to defy him.  He had so far left B<amac/yez<imac/d unmolested; partly because he was too powerful to be rashly provoked, and partly because Tim<umac/r respected the Sultan's valorous deeds against the Christians: for Tim<umac/r, though a wholesale butcher, was very conscientious in matters of religion, and held that B<amac/yez<imac/d's fighting for the Faith rightly covered a multitude of sins.</q> <rj><qau>Poole, Story of Turkey, p. 63</qau></rj><br/
[<source>Century Dict. 1906</source>]</p>

<p><note>Timour (t<imac/*m<oomac/r"), Timur, or TAMERLANE, was the second of the great conquerers whom central Asia sent forth in the middle ages, and was born at Kesh, about 40 miles southeast of Samarkand, April 9, 1336. His father was a Turkish chieftain and his mother claimed descent from the great Genghis-Khan.   When he became tribal chieftain, Timour helped the Amir Hussein to drive out the Kalmucks.  Turkestan was thereupon divided between them, but soon war broke out between the two chiefs, and the death of Hussein in battle made Timour master of all Turkestan.  He now began his career of conquest, overcoming the Getes, Khiva and Khorassin, after storming Herat.  His ever-widening circle of possessions soon embraced Persia, Mesopotamia, Georgia, and the Mongol state, Kiptchak.  He threatened Moscow, burned Azoo, captured Delhi, overran Syria, and stormed Bagdad, which had revolted.  At last, July 20, 1402, Timour met the Sultan Bajazet of the Ottoman Turks, on the plains of Ankara, captured him and routed his army, thus becoming master of the Turkish empire.  He took but a short rest at his capital, Samarkand, and in his eagerness to conquer China, led his army of 200,000 across the Jaxartes on the ice, and pushed rapidly on for 300 miles, when his death, Feb. 18, 1405, saved the independence of China.  Though notorious for his acts of cruelty -- he may have slaughtered 80,000 in Delhi -- he was a patron of the arts. In his reign of 35 years, this chief of a small tribe, dependent on the Kalmucks, became the ruler of the vast territory stretching from Moscow to the Ganges.  A number of writings said to have been written by Timour have been preserved in Persian, one of which, the <booki>Institutions</booki>, has been translated into English.</note>  <au>The Student's Cyclopedia, 1897.</au><br/
[<source>PJC</source>]</p>

<p><note>  There is a story about an incident when an archaeologist opened Timur's tomb at the Gur-Amir mausoleum in Samarkand, which was erected in 1404.  Timur and several of his descendants, including Ulugh Beg, are interred in that magnificent structure in the south-western side of Samarkand.  In the mausoleum, mosaics made out of light- and dark-blue glazed bricks decorate the walls and the drum, and the tiled geometrical designs of the cupola shine brightly in the sun.  Restoration work was started in 1967; the exterior cupola and glazed decorations were restored before that, in the 1950s.  The mausoleum holds tombstones made of marble and onyx, the tombstone of Timur is carved from a slab of nephrite. The burials proper are placed in a crypt under the mausoleum.<br/
   In 1941, a distinguished Soviet scientist, M. Gerasimov, received permission to exhume Tamerlane's body.  On June 22, 1941, working in the Samarkand crypt, he opened the sarcophagus to study the body and found the inscription: "Whoever opens this will be defeated by an enemy more fearsome than I." Hours later, Hitler invaded Russia. Five weeks after the great Emir was reinterred in 1942, the Germans surrendered at Stalingrad.<br/
   Examination of the remains in Timur's tomb confirmed that the body was tall, as was reported in the histories, and had been wounded in the leg and arm.<br/
    The actual inscription on the tomb has been reported variously:<br/
   "He whomsoever shall disturb the earthly resting place of Timur-i-Lenk (Tamerlane), then his country shall suffer such terrible retribution as the Hand of Allah shall visit upon it."<br/
   "When I rise, the World will Tremble".</note><br/
[<source>PJC</source>]</p>

<p><q><title>Timur's Legacy: The Architecture of Samarkand</title><br/
<br/
Let he who doubt Our power and munificence look upon Our buildings<br/
                      Amir Timur, 1379 AD<br/
<br/
Timur, better known in the West as Tamerlane from his nickname Timur-i-leng or "Timur the Lame", was the last of the great nomadic warriors to sweep out of Central Asia and shake the world. As befits a man styled "World Conqueror", we know a lot about him -- and not all of it good. In 1336, at Shakhrisabz in present-day Uzbekistan, the wife of a minor chief of the Mongol Barlas clan gave birth to a son with blood-filled palms, a sure omen that the infant was predestined to cause the death of many. He was given an appropriate name -- Timur means "iron" in Turkish -- and raised in the Turkic-Islamic tradition of the surrounding steppe as a rider, archer and swordsman.<br/
<br/
Even by the harsh standards of the Mongol hordes, Timur excelled. Before he was twenty years old he had attracted a band of followers with whom he ranged across the steppe raiding caravans and rustling horses. In 1360 his skills as a commander were rewarded when he was recognised as chief of the Barlas clan. Over the next ten years he steadily extended his influence over Transoxiana -- the region between the Oxus and Jaxartes Rivers centred on present-day Uzbekistan -- acquiring wounds to his right arm and leg in the process, and hence his nickname. In 1370 he conquered Turkistan, the last surviving Mongol Khanate, and declared himself Amir or "Commander". He made the Silk Road city of Samarkand his capital, and then embarked on a series of military conquests that rocked Asia and Europe to their very foundations.<br/
<br/
For 35 years Timur's forces ranged far and wide, repeatedly sweeping across Central Asia, Iran, Turkey and northern India. In 1405 Timur was preparing his greatest expedition ever, aimed at conquering China, when he was struck down by fever. Despite the best efforts of his doctors, to the sound of massive thunderclaps and "foaming like a camel dragged backwards by the rein", Timur finally succumbed. The Ming Emperor must have breathed a heartfelt sigh of relief when he eventually heard the news.<br/
<br/
Historians estimate that Timur, who personally led his forces as far afield as Moscow and Delhi, may have been responsible for the death of as many as 15 million people. Yet he made little attempt to consolidate his conquests, preferring to mount regular, devastating attacks against his neighbours before returning to his native Transoxiana. As a consequence, the dynasty he established proved to be short-lived, though in 1526 Timur's great, great, great grandson Babur restored the family fortunes by conquering Delhi and founding the resplendent Mogul Empire.<br/
<br/
Timur must have been an enigma to his contemporaries. Brutal and utterly ruthless, he was nevertheless a man of culture. He is said to have been illiterate, but fluent in Turkish and Persian. Sources speak of his sharp wit and hunger for knowledge. When not out and about slaughtering his neighbours, he indulged in passionate debate with scholars of history, medicine and astronomy. He enjoyed playing chess. Above all, he seems to have loved his capital, Samarkand, and he spent much time between campaigns embellishing this previously undistinguished city. To help in this great enterprise, he plundered cities like Damascus, Baghdad, Isfahan and Delhi not just for the loot, but for their skilled artisans, who were brought back to make Samarkand a city worthy of the "World Conqueror". As a consequence the warlike Timur's most lasting and unlikely legacy remains the unsurpassed architectural jewel of Central Asia.<br/
<br/
With Timur's death Transoxiana began a long period of decline, culminating in gradual Russian conquest during the 19th century. Samarkand had long been inaccessible to outsiders because of the xenophobia and religious bigotry of the ruling amirs. This situation was compounded in 1920, when the Red Army seized control of the region and began a process of Sovietisation. In 1924 Samarkand was included within the frontiers of the new Uzbek Soviet Socialist Republic, and a curtain of silence fell across the region with Westerners, in particular, being rigorously excluded.<br/
<br/
Only in the 1980s did the veil begin to rise, and then within a few short years the former USSR disintegrated, resulting in the birth of independent Uzbekistan in 1991. Although ruled by a suspicious and innately cautious former Soviet aparatchik, Islam Karimov, Uzbekistan is today slowly opening to foreign tourism. It should do well. The cities of Bukhara and Khiva, together with Timur's capital at Samarkand, are truly magnificent. In places, it's as though time stood still. It didn't of course. The Soviets worked long and hard to restore what remained of Timurid Samarkand, and Uzbekistan stands to benefit greatly as a result. Moreover, the process continues apace, both in spiritual terms -- Timur is now an Uzbek national hero -- and at a more mundane level. Everywhere the chip of stonemasons' hammers is to be heard, and a whole new generation of skilled craftsmen is being trained to restore the architectural legacy of the "Iron Limper".<br/
<br/
The historic heart of Samarkand is the Registan, an open square dominated by three great madrassa , or Islamic colleges. <person>George Curzon</person>, later to become Viceroy of India, visited in 1899 and was moved enough to describe the Registan as "the noblest public square in the world". He continues: "No European spectacle can be adequately compared to it, in our inability to point to an open space in any western city that is commanded on three of its four sides by Gothic cathedrals of the finest order". The architecture is distinctively Timurid, being characterised by an extraordinarily lavish use of colour, especially emerald, azure, deep blue and gold. The great domes are fluted, the vast porticoes richly decorated with corkscrew columns and intricately-patterned glazed tiles. Astonishingly, the faade of the Shir Dor Madrassa on the east side of the square is decorated with half-tiger, half-lion creatures stalking deer, whilst a blazing sun with a human face rises behind the beast of prey's back. In Islam, such representational art is generally forbidden, and it is wonderful that these clearly heretical images have survived through the long centuries since they were created.<br/
<br/
Samarkand -- let alone Uzbekistan -- has too many Timurid gems to describe in one short article, but after the Registan, the monumental Bibi Khanum Mosque is perhaps the most extraordinary sight in the city. Built for Timur's chief wife, <person>Saray Mulk Khanum</person>, this magnificent building was financed by the plunder brought back from Delhi in 1398; it is said that 95 elephants were used in hauling marble for the mosque. On Bibi Khanum's completion a chronicler was moved to write: "Its dome would have been unique had it not been for the heavens, and unique would have been its portal had it not been for the Milky Way".  Even so, historians have shown that in his plans for the Bibi Khanum, Timur's vision exceeded the architectural possibilities of the time.  Quite simply, the lofty iwan (portico) and the towering minarets were too ambitious for the technology of the time -- especially in a land prone to violent earthquakes. By all accounts, parts of the giant mosque began to collapse within months of its consecration.  Today all three massive azure domes have been restored, and work still continues, though this time with ferro-concrete supports hidden behind the elaborate glazed tilework, on the lofty iwan and minarets. When the restoration is complete in around 2002, Uzbekistan will have yet another architectural marvel to draw visitors.<br/
<br/
Finally and fittingly we turn to the Gur-i Amir, or "Tomb of the Ruler", Timur's own last resting place. This fabulous structure, which was completed in 1404, is dominated by the octagonal mausoleum and its peerless fluted dome, azure in colour, with 64 separate ribs. Within lie the remains not only of Timur, but also of various members of his family, including his grandson the scholar-king Ulugh Beg. Timur's tomb is protected by a single slab of jade, said to be the largest in the world. Brought back by Ulugh Beg from Mongolia in 1425, it was broken in half in the 18th century by the Persian ruler Nadir Shah, who tried to remove it from the chamber. Carved into the jade is an inscription in Arabic: "When I rise, the World will Tremble".<br/
<br/
Coincidence, no doubt, but on the night of June 22, 1941, the Russian Scientist M. Gerasimov began his exhumation of Timur's remains. Within hours Hitler's armies crashed across the Soviet frontier signalling the beginning of the Nazi invasion. Gerasimov's investigations showed that Timur had been a tall man for his race and time, lame, as recorded, in his right leg, and with a wound to his right arm.  Surprisingly, red hair still clung to the skull from which Gerasimov reconstructed a bronze bust. Eventually Timur's remains were reinterred with full Muslim burial rites, giving truth to the message thundered in Arabic script three metres high from the cylindrical drum of the great conqueror's mausoleum: "Only God is Immortal".</q><br/
<rj><qau>Andrew Forbes/CPA</qau> (Text copyright   2001.)<br/
(from https://web.archive.org/web/20110607205608/http://www.cpamedia.com/articles/20010215/)</rj><br/
[<source>PJC</source>]</p>

<p><ent>Tamias</ent><br/
\'d8<hw>Ta"mi*as</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ a distributer.]</ety> <fld>(Zool.)</fld> <def>A genus of ground squirrels, including the chipmunk.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamil</ent><br/
<hw>Ta"mil</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to the Tamils, or to their language.</def> <altsp>[Written also <asp>Tamul</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamil</ent><br/
<hw>Ta"mil</hw>, <pos>n.</pos> <ety>[Written also <ets>Tamul</ets>.]</ety> <sn>1.</sn> <fld>(Ethnol.)</fld> <def>One of a Dravidian race of men native of Northern Ceylon and Southern India.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The Tamil language, the most important of the Dravidian languages. See <er>Dravidian</er>, <pos>a.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamilian</ent><br/
<hw>Ta*mil"i*an</hw> <pr>(?)</pr>, <pos>a. & n.</pos> <def>Tamil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taminy</ent><br/
<ent>Tamine</ent><br/
<mhw>{ <hw>Tam"ine</hw> <pr>(?)</pr>, <hw>Tam"i*ny</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[Cf. F. <ets>tamis</ets> a sort of sieve.  Cf. <er>Stamin</er>, <er>Temse</er>.]</ety> <def>A kind of woolen cloth; tammy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamis</ent><br/
<hw>Tam"is</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., a kind of sieve.]</ety> <sn>1.</sn> <def>A sieve, or strainer, made of a kind of woolen cloth.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The cloth itself; tammy.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tamis bird</b></col> <fld>(Zool.)</fld>, <cd>a Guinea fowl.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamkin</ent><br/
<hw>Tam"kin</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A tampion.</def>  <rj><au>Johnson (Dict.).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tammy</ent><br/
<hw>Tam"my</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tammies</plw> <pr>(<?/)</pr>.</plu> <sn>1.</sn> <def>A kind of woolen, or woolen and cotton, cloth, often highly glazed, -- used for curtains, sieves, strainers, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A sieve, or strainer, made of this material; a tamis.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tam-o'-shanter</ent><br/
<hw>Tam`-o'-shan"ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So named after <etsep>Tam o'Shanter</etsep>, a character in Burns's poem of the same name.]</ety> <def>A kind of Scotch cap of wool, worsted, or the like, having a round, flattish top much wider than the band which fits the head, and usually having a tassel in the center.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tamoxifen</ent><br/
<hw>Ta*mox"i*fen</hw> <pr>(t<acr/*m<ocr/k"s<icr/*f<ecr/n)</pr>, <pos>n.</pos> <def>a chemical compound (<chform>C26H29NO</chform>) which is non-steroidal but physiogically active as an estrogen antagonist.  It is used to treat postmenopausal breast cancer.  Chemically it is <chname>1-p-dimethylaminoethoxyphenyl-trans-1,2-diphenyl-but-1-ene</chname>. It can be obtained as a white crystalline powder.</def> <au>[MI11]</au><br/
<syn><b>Syn. --</b> Kessar; Noltam; Nolvadex; Tamofen; Tamoxasta; Terimon; Xynoplex.</syn>
[<source>PJC</source>]</p>

<p><ent>Tamp</ent><br/
<hw>Tamp</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tamped</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tamping</conjf>.]</vmorph> <ety>[Cf. F. <ets>tamponner</ets> to plug or stop. See <er>Tampion</er>.]</ety> <sn>1.</sn> <def>In blasting, to plug up with clay, earth, dry sand, sod, or other material, as a hole bored in a rock, in order to prevent the force of the explosion from being misdirected.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To drive in or down by frequent gentle strokes; <as>as, to <ex>tamp</ex> earth so as to make a smooth place</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tampan</ent><br/
<hw>Tam"pan</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A venomous South African tick.</def>  <rj><au>Livingstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tampeon</ent><br/
<hw>Tam"pe*on</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tampion</er>.</def>  <rj><au>Farrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamper</ent><br/
<hw>Tamp"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who tamps; specifically, one who prepares for blasting, by filling the hole in which the charge is placed.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An instrument used in tamping; a tamping iron.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamper</ent><br/
<hw>Tam"per</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tampered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tampering</conjf>.]</vmorph> <ety>[A corruption of <ets>temper</ets>.]</ety> <sn>1.</sn> <def>To meddle; to be busy; to try little experiments; <as>as, to <ex>tamper</ex> with a disease</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>'T is dangerous <qex>tampering</qex> with a muse.</q> <rj><qau>Roscommon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To meddle so as to alter, injure, or vitiate a thing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To deal unfairly; to practice secretly; to use bribery.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Others <qex>tampered</qex><br/
For Fleetwood, Desborough, and Lambert.</q> <rj><qau>Hudibras.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamperer</ent><br/
<hw>Tam"per*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who tampers; one who deals unfairly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tampico fibre</ent><br/
<ent>Tampico fiber</ent><br/
<mhw>{ <hw>Tam*pi"co fi"ber</hw> <it>or</it> <hw>Tam*pi"co fi"bre</hw> <pr>(?)</pr> }</mhw>. <def>A tough vegetable fiber used as a substitute for bristles in making brushes. The piassava and the ixtle are both used under this name.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamping</ent><br/
<hw>Tamp"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act of one who tamps; specifically, the act of filling up a hole in a rock, or the branch of a mine, for the purpose of blasting the rock or exploding the mine.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The material used in tamping. See <er>Tamp</er>, <pos>v. t.</pos>, 1.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tamping iron</b></col>, <cd>an iron rod for beating down the earthy substance in tamping for blasting.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tampion</ent><br/
<hw>Tam"pi*on</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tampon</ets>, <ets>tapon</ets>, <ets>tape</ets>, of Dutch or German origin. See <er>Tap</er> a pipe or plug, and cf. <er>Tamp</er>, <er>Tampop</er>, <er>Tompion</er>.]</ety> <altsp>[Written also <asp>tampeon</asp>, and <asp>tompion</asp>.]</altsp> <sn>1.</sn> <def>A wooden stopper, or plug, as for a cannon or other piece of ordnance, when not in use.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>A plug for upper end of an organ pipe.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tampoe</ent><br/
<hw>Tam"poe</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The edible fruit of an East Indian tree (<spn>Baccaurea Malayana</spn>) of the Spurge family. It somewhat resembles an apple.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tampon</ent><br/
<hw>Tam"pon</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See <er>Tampion</er>.]</ety> <fld>(Surg.)</fld> <def>A plug introduced into a natural or artificial cavity of the body in order to arrest hemorrhage, absorb secretions (as from menstruation), or for the application of medicine.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Tampon</ent><br/
<hw>Tam"pon</hw>, <pos>v. t.</pos> <fld>(Surg.)</fld> <def>To plug with a tampon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tampoon</ent><br/
<hw>Tam"poon</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tampion</er>.]</ety> <def>The stopper of a barrel; a bung.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tam-tam</ent><br/
<hw>Tam"-tam`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Hind.; of imitative origin.]</ety> <fld>(Mus.)</fld> <sd>(a)</sd> <def>A kind of drum used in the East Indies and other Oriental countries; -- called also <altname>tom-tom</altname>.</def> <sd>(b)</sd> <def>A gong. See <er>Gong</er>, <pos>n.</pos>, 1.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamul</ent><br/
<hw>Ta"mul</hw> <pr>(t<aum/"m<ucr/l)</pr>, <pos>a. & n.</pos> <def>Tamil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tamworth</ent><br/
<hw>Tam"worth</hw> <pr>(t<acr/m"w<ucr/rth)</pr>, <pos>n.</pos> <ety>[From <etsep>Tamworth</etsep>, Staffordshire, England.]</ety> <def>One of a long-established English breed of large pigs. They are red, often spotted with black, with a long snout and erect or forwardly pointed ears, and are valued as bacon producers.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tan</ent><br/
<hw>Tan</hw> <pr>(t<acr/n)</pr>, <pos>n.</pos> <ety>[Chin.]</ety> <def>See <er>Picul</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tan</ent><br/
<hw>Tan</hw>, <pos>n.</pos> <ety>[F. <ets>tan</ets>, perhaps fr. Armor. <ets>tann</ets> an oak, oak bar; or of Teutonic origin; cf. G. <ets>tanne</ets> a fir, OHG. <ets>tanna</ets> a fir, oak, MHG. <ets>tan</ets> a forest.  Cf. <er>Tawny</er>.]</ety> <sn>1.</sn> <def>The bark of the oak, and some other trees, bruised and broken by a mill, for tanning hides; -- so called both before and after it has been used. Called also <altname>tan bark</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A yellowish-brown color, like that of tan.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A brown color imparted to the skin by exposure to the sun; <as>as, hands covered with <ex>tan</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tan bed</b></col> <fld>(Hort.)</fld>, <cd>a bed made of tan; a bark bed.</cd> -- <col><b>Tan pickle</b></col>, <cd>the liquor used in tanning leather.</cd> -- <col><b>Tan spud</b></col>, <cd>a spud used in stripping bark for tan from trees.</cd> -- <col><b>Tan stove</b></col>. <cd>See <cref>Bark stove</cref>, under <er>Bark</er>.</cd> -- <col><b>Tan vat</b></col>, <cd>a vat in which hides are steeped in liquor with tan.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tan</ent><br/
<hw>Tan</hw>, <pos>a.</pos> <def>Of the color of tan; yellowish-brown.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Black and tan</b></col>. <cd>See under <er>Black</er>, <pos>a.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tan</ent><br/
<hw>Tan</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tanned</conjf> <pr>(t<acr/nd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tanning</conjf>.]</vmorph> <ety>[F. <ets>tanner</ets>, LL. <ets>tannare</ets>. See <er>Tan</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To convert (the skin of an animal) into leather, as by the usual process of steeping it in an infusion of oak or some other bark, whereby it is impregnated with tannin, or tannic acid (which exists in several species of bark), and is thus rendered firm, durable, and in some degree impervious to water.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The essential result in tanning is due to the fact that the tannins form, with gelatins and albuminoids, a series of insoluble compounds which constitute leather. Similar results may be produced by the use of other reagents in place of tannin, as alum, and some acids or chlorides, which are employed in certain processes of tanning.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make brown; to imbrown, as by exposure to the rays of the sun; <as>as, to <ex>tan</ex> the skin</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To thrash or beat; to flog; to switch; <as>as, to <ex>tan</ex> a disobedient child's hide</as>.</def> <mark>[Colloq.]</mark><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Tan</ent><br/
<hw>Tan</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To get or become tanned.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tana</ent><br/
<hw>Ta"na</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Banxring</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanager</ent><br/
<hw>Tan"a*ger</hw> <pr>(t<acr/n"<adot/*j<etil/r)</pr>, <pos>n.</pos> <ety>[NL. <ets>tanagra</ets>, probably fr. Brazilian <ets>tangara</ets>.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of bright-colored singing birds belonging to <gen>Tanagra</gen>, <gen>Piranga</gen>, and allied genera.  The scarlet tanager (<spn>Piranga erythromelas</spn>) and the summer redbird (<spn>Piranga rubra</spn>) are common species of the United States.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanagrine</ent><br/
<hw>Tan"a*grine</hw> <pr>(t<acr/n"<adot/*gr<imac/n)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Of or pertaining to the tanagers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanagroid</ent><br/
<hw>Tan"a*groid</hw> <pr>(t<acr/n"<adot/*groid)</pr>, <pos>a.</pos> <ety>[<ets>Tanager</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Tanagrine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanakh</ent><br/
<ent>Tanak</ent><br/
<mhw><hw>Tanak</hw>, <hw>Tanakh</hw></mhw> <pr>(t<adot/*n<adot/k")</pr>, <pos>n.</pos> <ety>[From the initial (Hebrew) letters of <ets>T</ets>orah, <ets>N</ets>evi'im, and  <ets>K</ets>ethubim.]</ety> <def>A term used among Jews for the Hebrew Bible; the Old Testament.</def> <altsp>[Also spelled <asp>Tanach</asp>.]</altsp> <note>Although Christians use the term <ldquo/Old Testament<rdquo/, this term implies the superseding force of the <ldquo/New Testament<rdquo/, not recognized as revelation by the Jewish faith.</note><br/
[<source>PJC</source>]</p>

<p><q>The Hebrew Bible is divided into three parts: (1) The <er>Torah</er>, <ldquo/Law,<rdquo/ or Pentateuch. (2) The Prophets . . . (3) The Kethubim, or the <ldquo/Writings,<rdquo/ generally termed <er>Hagiographa</er>.</q>  <rj><qau>C. H. H. Wright.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tanate</ent><br/
\'d8<hw>Ta*na"te</hw> <pr>(t<adot/*n<aum/"t<asl/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>An Asiatic wild dog (<spn>Canis procyonoides</spn>), native of Japan and adjacent countries. It has a short, bushy tail. Called also <altname>raccoon dog</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tandem</ent><br/
<hw>Tan"dem</hw> <pr>(t<acr/n"d<ecr/m)</pr>, <pos>adv. & a.</pos> <ety>[L. <ets>tandem</ets> at length (of time only), punningly taken as meaning, lengthwise.]</ety> <def>One after another; -- said especially of horses harnessed and driven one before another, instead of abreast.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tandem</ent><br/
<hw>Tan"dem</hw>, <pos>n.</pos> <sn>1.</sn> <def>A team of horses harnessed one before the other.</def> <ldquo/He drove <xex>tandems</xex>.<rdquo/  <rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tandem bicycle or other vehicle.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><mcol><col><b>Tandem bicycle</b></col> <it>or</it>  <col><b>Tandem tricycle</b></col></mcol>, <cd>one for two persons in which one rider sits before the other.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tandem cart</ent><br/
<hw>Tan"dem cart</hw>. <def>A kind of two-wheeled vehicle with seats back to back, the front one somewhat elevated.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tandem engine</ent><br/
<hw>Tandem engine</hw>. <def>A steam engine having two or more steam cylinders in line, with a common piston rod.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tandem system</ent><br/
<hw>Tandem system</hw>. <fld>(Elec.)</fld> <def>same as <er>Cascade system</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tang</ent><br/
<hw>Tang</hw> <pr>(t<acr/ng)</pr>, <pos>n.</pos> <ety>[Of Scand. origin; cf. Dan. <ets>tang</ets> seaweed, Sw. <ets>t<aring/ng</ets>, Icel. <ets><thorn/ang</ets>.  Cf. <er>Tangle</er>.]</ety> <fld>(Bot.)</fld> <def>A coarse blackish seaweed (<spn>Fucus nodosus</spn>).</def>  <rj><au>Dr. Prior.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tang sparrow</b></col> <fld>(Zool.)</fld>, <cd>the rock pipit.</cd> <mark>[Prov. Eng.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tang</ent><br/
<hw>Tang</hw>, <pos>n.</pos> <ety>[Probably fr. OD. <ets>tanger</ets> sharp, tart, literally, pinching; akin to E. <ets>tongs</ets>. <root/59. See <er>Tong</er>.]</ety> <sn>1.</sn> <def>A strong or offensive taste; especially, a taste of something extraneous to the thing itself; <as>as, wine or cider has a <ex>tang</ex> of the cask</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: A sharp, specific flavor or tinge.  Cf. <er>Tang</er> a twang.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Such proceedings had a strong <qex>tang</qex> of tyranny.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A cant of philosophism, and a <qex>tang</qex> of party politics.</q> <rj><qau>Jeffrey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <ety>[Probably of Scand. origin; cf. Icel. <ets>tangi</ets> a projecting point; akin to E. <ets>tongs</ets>. See <er>Tongs</er>.]</ety> <def>A projecting part of an object by means of which it is secured to a handle, or to some other part; anything resembling a tongue in form or position.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>The part of a knife, fork, file, or other small instrument, which is inserted into the handle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>The projecting part of the breech of a musket barrel, by which the barrel is secured to the stock.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>The part of a sword blade to which the handle is fastened.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>The tongue of a buckle.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tang</ent><br/
<hw>Tang</hw>, <pos>n.</pos> <ety>[Of imitative origin.  Cf. <er>Twang</er>. This word has become confused with <ets>tang</ets> taste, flavor.]</ety> <def>A sharp, twanging sound; an unpleasant tone; a twang.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tang</ent><br/
<hw>Tang</hw> <pr>(t<aum/ng)</pr>, <pos>n.</pos> <ety>[Chin. <ets>T`ang</ets>.]</ety> <def>A dynasty in Chinese history, from <sc>a. d.</sc> 618 to 905, distinguished by the founding of the Imperial Academy (the Hanlin), by the invention of printing, and as marking a golden age of literature.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tang</ent><br/
<hw>Tang</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tanged</conjf> <pr>(t<acr/ngd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tanging</conjf>.]</vmorph> <def>To cause to ring or sound loudly; to ring.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let thy tongue <qex>tang</qex> arguments of state.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To tang bees</b></col>, <cd>to cause a swarm of bees to settle, by beating metal to make a din.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tang</ent><br/
<hw>Tang</hw>, <pos>v. i.</pos> <def>To make a ringing sound; to ring.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let thy tongue <qex>tang</qex> arguments of state.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangalung</ent><br/
<hw>Tan"ga*lung</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>An East Indian civet (<spn>Viverra tangalunga</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangelo</ent><br/
<hw>Tan"ge*lo</hw> <pr>(t<acr/n"j<esl/*l<omac/)</pr>, <pos>n.</pos>  <ety>[<ets>Tang</ets>erine + pom<ets>elo</ets>.]</ety> <def>A hybrid between the tangerine orange and the grapefruit, or pomelo; also, the fruit.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tangence</ent><br/
<hw>Tan"gence</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Tangency.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangency</ent><br/
<hw>Tan"gen*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being tangent; a contact or touching.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangent</ent><br/
<hw>Tan"gent</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tangens</ets>, <ets>-entis</ets>, p. pr. of <ets>tangere</ets> to touch; akin to Gr. <?/ having seized: cf. F. <ets>tangente</ets>.  Cf. <er>Attain</er>, <er>Contaminate</er>, <er>Contingent</er>, <er>Entire</er>, <er>Tact</er>, <er>Taste</er>, <er>Tax</er>, <pos>v. t.</pos>]</ety> <fld>(Geom.)</fld> <def>A tangent line curve, or surface; specifically, that portion of the straight line tangent to a curve that is between the point of tangency and a given line, the given line being, for example, the axis of abscissas, or a radius of a circle produced. See <cref>Trigonometrical function</cref>, under <er>Function</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Artificial tangent</b></col>, <it>or</it> <col><b>Logarithmic tangent</b></col></mcol>, <cd>the logarithm of the natural tangent of an arc.</cd> -- <col><b>Natural tangent</b></col>, <cd>a decimal expressing the length of the tangent of an arc, the radius being reckoned unity.</cd> -- <col><b>Tangent galvanometer</b></col> <fld>(Elec.)</fld>, <cd>a form of galvanometer having a circular coil and a short needle, in which the tangent of the angle of deflection of the needle is proportional to the strength of the current.</cd> -- <col><b>Tangent of an angle</b></col>, <cd>the natural tangent of the arc subtending or measuring the angle.</cd> -- <col><b>Tangent of an arc</b></col>, <cd>a right line, as <it>ta</it>, touching the arc of a circle at one extremity <it>a</it>, and terminated by a line <it>ct</it>, passing from the center through the other extremity <it>o</it>.</cd></cs>
<-- references are to a figure showing the tangent of an arc --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangent</ent><br/
<hw>Tan"gent</hw>, <pos>a.</pos> <ety>[L. <ets>tangens</ets>, <ets>-entis</ets>, p. pr.]</ety> <def>Touching; touching at a single point</def>; specifically <fld>(Geom.)</fld> <def>meeting a curve or surface at a point and having at that point the same direction as the curve or surface; -- said of a straight line, curve, or surface; <as>as, a line <ex>tangent</ex> to a curve; a curve <ex>tangent</ex> to a surface; <ex>tangent</ex> surfaces.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tangent plane</b></col> <fld>(Geom.)</fld>, <cd>a plane which touches a surface in a point or line.</cd> -- <col><b>Tangent scale</b></col> <fld>(Gun.)</fld>, <cd>a kind of breech sight for a cannon.</cd> -- <col><b>Tangent screw</b></col> <fld>(Mach.)</fld>, <cd>an endless screw; a worm.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1473 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangental</ent><br/
<hw>Tan*gen"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Geom.)</fld> <def>Tangential.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangential</ent><br/
<hw>Tan*gen"tial</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Geom.)</fld> <def>Of or pertaining to a tangent; in the direction of a tangent.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tangential force</b></col> <fld>(Mech.)</fld>, <cd>a force which acts on a moving body in the direction of a tangent to the path of the body, its effect being to increase or diminish the velocity; -- distinguished from a <xex>normal force</xex>, which acts at right angles to the tangent and changes the direction of the motion without changing the velocity.</cd> -- <col><b>Tangential stress</b></col>. <fld>(Engin.)</fld> <cd>See <er>Shear</er>, <pos>n.</pos>, 3.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangentially</ent><br/
<hw>Tan*gen"tial*ly</hw>, <pos>adv.</pos> <def>In the direction of a tangent.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangent spoke</ent><br/
<hw>Tangent spoke</hw>. <def>A tension spoke of a bicycle or similar wheel, secured tangentially to the hub.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tangent wheel</ent><br/
<hw>Tangent wheel</hw>. <sd>(a)</sd> <def>A worm or worm wheel; a tangent screw.</def> <sd>(b)</sd> <def>A wheel with tangent spokes.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tangerine</ent><br/
<hw>Tan"ger*ine`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Etymol. uncertain.]</ety> <fld>(Bot.)</fld> <def>A kind of orange, much like the mandarin, but of deeper color and higher flavor. It is said to have been produced in America from the mandarin.</def> <altsp>[Written also <asp>tangierine</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangfish</ent><br/
<hw>Tang"fish`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The common harbor seal.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanghinia</ent><br/
\'d8<hw>Tan*ghin"i*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety> <fld>(Bot.)</fld> <def>The ordeal tree. See under <er>Ordeal</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangibility</ent><br/
<hw>Tan`gi*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tanggibilit<eacute/</ets>.]</ety> <def>The quality or state of being tangible.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangible</ent><br/
<hw>Tan"gi*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tangibilis</ets>, fr. <ets>tangere</ets> to touch: cf. F. <ets>tangible</ets>. See <er>Tangent</er>.]</ety> <sn>1.</sn> <def>Perceptible to the touch; tactile; palpable.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Capable of being possessed or realized; readily apprehensible by the mind; real; substantial; evident.</def> <ldquo/A <xex>tangible</xex> blunder.<rdquo/  <rj><au>Byron.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Direct and <qex>tangible</qex> benefit to ourselves and others.</q> <rj><qau>Southey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Tan"gi*ble*ness</wf>, <pos>n.</pos> -- <wf>Tan"gi*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangle</ent><br/
<hw>Tan"gle</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tangled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tangling</conjf> <pr>(?)</pr>.]</vmorph> <ety>[A frequentative fr. <ets>tang</ets> seaweed; hence, to twist like seaweed. See <er>Tang</er> seaweed, and cf. <er>Tangle</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To unite or knit together confusedly; to interweave or interlock, as threads, so as to make it difficult to unravel the knot; to entangle; to ravel.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To involve; to insnare; to entrap; <as>as, to be <ex>tangled</ex> in lies</as>.</def> <ldquo/<xex>Tangled</xex> in amorous nets.<rdquo/  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When my simple weakness strays,<br/
<qex>Tangled</qex> in forbidden ways.</q> <rj><qau>Crashaw.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangle</ent><br/
<hw>Tan"gle</hw>, <pos>v. i.</pos> <def>To be entangled or united confusedly; to get in a tangle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangle</ent><br/
<hw>Tan"gle</hw>, <pos>n.</pos> <sn>1.</sn> <ety>[Cf. Icel. <ets><thorn/<oum/ngull</ets>. See <er>Tang</er> seaweed.]</ety> <fld>(Bot.)</fld> <def>Any large blackish seaweed, especially the <spn>Laminaria saccharina</spn>. See <er>Kelp</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Coral and sea fan and <qex>tangle</qex>, the blooms and the palms of the ocean.</q> <rj><qau>C. Kingsley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[From <er>Tangle</er>, <pos>v.</pos>]</ety> <def>A knot of threads, or other thing, united confusedly, or so interwoven as not to be easily disengaged; a snarl; <as>as, hair or yarn in <ex>tangles</ex>; a <ex>tangle</ex> of vines and briers. Used also figuratively.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <def>An instrument consisting essentially of an iron bar to which are attached swabs, or bundles of frayed rope, or other similar substances, -- used to capture starfishes, sea urchins, and other similar creatures living at the bottom of the sea.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Blue tangle</b></col>. <fld>(Bot.)</fld>S<cd>ee <er>Dangleberry</er>.</cd> -- <col><b>Tangle picker</b></col> <fld>(Zool.)</fld>, <cd>the turnstone.</cd> <mark>[Prov. Eng.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanglefish</ent><br/
<hw>Tan"gle*fish`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The sea adder, or great pipefish of Europe.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanglingly</ent><br/
<hw>Tan"gling*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a tangling manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangly</ent><br/
<hw>Tan"gly</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Entangled; intricate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Covered with tangle, or seaweed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Prone, helpless, on the <qex>tangly</qex> beach he lay.</q> <rj><qau>Falconer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tango</ent><br/
<hw>Tan"go</hw> <pr>(t<acr/<nsm/"g<omac/; <it>Sp.</it> t<aum/<nsm/"g<omac/)</pr>, <pos>n.</pos>; <plu>pl. <plw>Tangos</plw> <pr>(-g<omac/z)</pr></plu>. <ety>[Sp., a certain dance.]</ety> <sd>(a)</sd> <def>A difficult dance in two-four time characterized by graceful posturing, frequent pointing positions, and a great variety of steps, including the cross step and turning steps. The dance is of Spanish origin, and is believed to have been in its original form a part of the fandango.</def> <sd>(b)</sd> <def>Any of various popular forms derived from this.</def> <sd>(c)</sd> <def>a musical tune appropriate for this dance.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Tangram</ent><br/
<hw>Tan"gram</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Trangram</er>.]</ety> <def>A Chinese toy made by cutting a square of thin wood, or other suitable material, into seven pieces, as shown in the cut, these pieces being capable of combination in various ways, so as to form a great number of different figures. It is now often used in primary schools as a means of instruction.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangue</ent><br/
<hw>Tangue</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The tenrec.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangun</ent><br/
<hw>Tan"gun</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A piebald variety of the horse, native of Thibet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tangwhaup</ent><br/
<hw>Tang"whaup</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The whimbrel.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanier</ent><br/
<hw>Tan"i*er</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>An aroid plant (<spn>Caladium sagittaefolium</spn>), the leaves of which are boiled and eaten in the West Indies.</def> <altsp>[Written also <asp>tannier</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanist</ent><br/
<hw>Tan"ist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Ir. <ets>tanaiste</ets>, <ets>tanaise</ets>, second, the second person in rank, the presumptive or apparent heir to a prince.]</ety> <def>In Ireland, a lord or proprietor of a tract of land or of a castle, elected by a family, under the system of tanistry.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This family [the O'Hanlons] were <qex>tanists</qex> of a large territory within the present county of Armagh.</q> <rj><qau>M. A. Lower.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanistry</ent><br/
<hw>Tan"ist*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tanist</er>.]</ety> <def>In Ireland, a tenure of family lands by which the proprietor had only a life estate, to which he was admitted by election.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The primitive intention seems to have been that the inheritance should descend to the oldest or most worthy of the blood and name of the deceased. This was, in reality, giving it to the strongest; and the practice often occasioned bloody feuds in families, for which reason it was abolished under James I.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanite</ent><br/
<hw>Ta"nite</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A firm composition of emery and a certain kind of cement, used for making grinding wheels, slabs, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tank</ent><br/
<hw>Tank</hw> <pr>(t<acr/<nsm/k)</pr>, <pos>n.</pos> <def>A small Indian dry measure, averaging 240 grains in weight; also, a Bombay weight of 72 grains, for pearls.</def>  <rj><au>Simmonds.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tank</ent><br/
<hw>Tank</hw> <pr>(t<acr/<nsm/k)</pr>, <pos>n.</pos> <ety>[Pg. <ets>tanque</ets>, L. <ets>stangum</ets> a pool; or perhaps of East Indian origin.  Cf. <er>Stank</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>A large basin or cistern; an artificial receptacle for liquids.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A pond, pool, or small lake, natural or artificial.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>We stood in the afterglow on the bank of the <qex>tank</qex> and saw the ducks come home.</q>  <rj><qau>F. Remington.</qau></rj></p>

<p><q>The <qex>tanks</qex> are full and the grass is high.</q>  <rj><qau>Lawson.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn> <fld>(Mil.)</fld> <def>a heavily armored combat vehicle which moves on caterpillar treads, rather than wheels.  It typically carries a cannon and a heavy machine, and sometimes other weapons.  It is the main distinguishing weapon of an <partof>armored division</partof>.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>a jail cell for temporarily holding prisoners, as in a police station.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Tank engine</b></col>, <cd>a locomotive which carries the water and fuel it requires, thus dispensing with a tender.</cd> -- <col><b>Tank iron</b></col>, <cd>plate iron thinner than boiler plate, and thicker than sheet iron or stovepipe iron.</cd> -- <col><b>Tank worm</b></col> <fld>(Zool.)</fld>, <cd>a small nematoid worm found in the water tanks of India, supposed by some to be the young of the Guinea worm.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanka</ent><br/
<hw>Tan"ka</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Naut.)</fld> <def>A kind of boat used in Canton. It is about 25 feet long and is often rowed by women. Called also <altname>tankia</altname>.</def>  <rj><au>S. W. Williams.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tankage</ent><br/
<hw>Tank"age</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act or process of putting or storing in tanks.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>Fees charged for storage in tanks.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <def>The capacity or contents of a tank or tanks.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>4.</sn>  <fld>(Agric.)</fld> <def>Waste matter from tanks; esp., the dried nitrogenous residue from tanks in which fat has been rendered, used as a fertilizer.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tankard</ent><br/
<hw>Tank"ard</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>tanquart</ets>; cf. OD. <ets>tanckaert</ets>; of uncertain origin.]</ety> <def>A large drinking vessel, especially one with a cover.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Marius was the first who drank out of a silver <qex>tankard</qex>, after the manner of Bacchus.</q> <rj><qau>Arbuthnot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tankia</ent><br/
<hw>Tan"ki*a</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Naut.)</fld> <def>See <er>Tanka</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tankling</ent><br/
<hw>Tank"ling</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A tinkling.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tank vessel</ent><br/
<ent>Tank ship</ent><br/
<mhw>{ <hw>Tank ship</hw>, <hw>Tank vessel</hw>  }</mhw>. <fld>(Naut.)</fld> <def>A vessel fitted with tanks for the carrying of oil or other liquid in bulk; -- called also <altname>tanker</altname>.  A tank ship of very large capacity is called a <stype>supertanker</stype>.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Tank top</ent><br/
<hw>Tank" top`</hw>, <pos>n.</pos> <def>a sleeveless and collarless shirt with wide shoulder straps and no front opening, often close-fitting and low-cut.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tank warfare</ent><br/
<hw>Tank war"fare</hw>, <pos>n.</pos> <def>combat between tanks of opposing armies.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tanling</ent><br/
<hw>Tan"ling</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One tanned by the sun.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Hot summer's <qex>tanlings</qex> and<br/
The shrinking slaves of winter.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tannable</ent><br/
<hw>Tan"na*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>That may be tanned.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tannage</ent><br/
<hw>Tan"nage</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A tanning; the act, operation, or result of tanning.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>They should have got his cheek fresh <qex>tannage</qex>.</q> <rj><qau>R. Browning.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tannate</ent><br/
<hw>Tan"nate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tannate</ets>.]</ety> <fld>(Chem.)</fld> <def>A salt of tannic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanner</ent><br/
<hw>Tan"ner</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One whose occupation is to tan hides, or convert them into leather by the use of tan.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanner</ent><br/
<hw>Tan"ner</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Etym. uncertain.]</ety> <def>A sixpence.</def> <mark>[Slang, Eng.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tannery</ent><br/
<hw>Tan"ner*y</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tanneries</plw> <pr>(#)</pr>.</plu> <ety>[Cf. F. <ets>tannerie</ets>.]</ety> <sn>1.</sn> <def>A place where the work of tanning is carried on.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The art or process of tanning.</def> <mark>[R.]</mark>  <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tannic</ent><br/
<hw>Tan"nic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to tan; derived from, or resembling, tan; <as>as, <ex>tannic</ex> acid</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tannic acid</b></col>. <fld>(Chem.)</fld> <sd>(a)</sd> <cd>An acid obtained from nutgalls as a yellow amorphous substance, <chform>C14H10O9</chform>, having an astringent taste, and forming with ferric salts a bluish-black compound, which is the basis of common ink. Called also <altname>tannin</altname>, and <altname>gallotannic acid</altname>.</cd> <sd>(b)</sd> <cd>By extension, any one of a series of astringent substances resembling tannin proper, widely diffused through the vegetable kingdom, as in oak bark, willow, catechu, tea, coffee, etc.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tannier</ent><br/
<hw>Tan"ni*er</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>See <er>Tanier</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tannigen</ent><br/
<hw>Tan"ni*gen</hw> <pr>(?)</pr>, <pos>n.</pos>  <ety>[<ets>Tann</ets>in + <ets>-gen</ets>.]</ety> <fld>(Pharm.)</fld> <def>A compound obtained as a yellowish gray powder by the action of acetyl chloride or acetic anhydride or ordinary tannic acid. It is used as an intestinal astringent, and locally in rhinitis and pharyngitis.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tannin</ent><br/
<hw>Tan"nin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tannin</ets>.]</ety> <fld>(Chem.)</fld> <def>Same as <cref>Tannic acid</cref>, under <er>Tannic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanning</ent><br/
<hw>Tan"ning</hw>, <pos>n.</pos> <def>The art or process of converting skins into leather. See <er>Tan</er>, <pos>v. t.</pos>, 1.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanrec</ent><br/
<hw>Tan"rec</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Tenrec</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tansy</ent><br/
<hw>Tan"sy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>tansaye</ets>, F. <ets>tanaise</ets>; cf. It. & Sp. <ets>tanaceto</ets>, NL. <ets>tanacetum</ets>, Pg. <ets>atanasia</ets>, <ets>athanasia</ets>, Gr. <grk>'aqanasi`a</grk> immortality, fr. <grk>'aqa`natos</grk> immortal; <grk>'a</grk> priv. + <grk>qa`natos</grk> death.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>Any plant of the composite genus <gen>Tanacetum</gen>. The common tansy (<spn>Tanacetum vulgare</spn>) has finely divided leaves, a strong aromatic odor, and a very bitter taste. It is used for medicinal and culinary purposes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A dish common in the seventeenth century, made of eggs, sugar, rose water, cream, and the juice of herbs, baked with butter in a shallow dish.</def> <mark>[Obs.]</mark>  <rj><au>Pepys.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Double tansy</b></col> <fld>(Bot.)</fld>, <cd>a variety of the common tansy with the leaves more dissected than usual.</cd> -- <col><b>Tansy mustard</b></col> <fld>(Bot.)</fld>, <cd>a plant (<spn>Sisymbrium canescens</spn>) of the Mustard family, with tansylike leaves.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tant</ent><br/
<hw>Tant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Taint</er> tincture.]</ety> <fld>(Zool.)</fld> <def>A small scarlet arachnid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalate</ent><br/
<hw>Tan"ta*late</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of tantalic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalic</ent><br/
<hw>Tan*tal"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of or pertaining to tantalum; derived from, or containing, tantalum; specifically, designating any one of a series of acids analogous to nitric acid and the polyacid compounds of phosphorus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalism</ent><br/
<hw>Tan"ta*lism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tantalize</er>.]</ety> <def>A punishment like that of Tantalus; a teasing or tormenting by the hope or near approach of good which is not attainable; tantalization.</def>  <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Is not such a provision like <qex>tantalism</qex> to this people?</q> <rj><qau>Josiah Quincy.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalite</ent><br/
<hw>Tan"ta*lite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tantalite</ets>.]</ety> <fld>(Min.)</fld> <def>A heavy mineral of an iron-black color and submetallic luster.  It is essentially a tantalate of iron.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalization</ent><br/
<hw>Tan`ta*li*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of tantalizing, or state of being tantalized.</def>  <rj><au>Gayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalize</ent><br/
<hw>Tan"ta*lize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tantalized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tantalizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[From <er>Tantalus</er>: cf. F. <ets>tantaliser</ets>.]</ety> <def>To tease or torment by presenting some good to the view and exciting desire, but continually frustrating the expectations by keeping that good out of reach; to tease; to torment.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thy vain desires, at strife<br/
Within themselves, have <qex>tantalized</qex> thy life.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To tease; vex; irritate; provoke.</syn> <usage> -- <er>Tantalize</er>, <er>Disappoint</er>. To <xex>disappoint</xex> is literally to <xex>do away</xex> with what was (or was taken to be) <xex>appointed</xex>; hence the peculiar pain from hopes thus dashed to the ground. To <xex>tantalize</xex>, a much stronger term, describes a most distressing form of disappointment, as in the case of Tantalus, the Phrygian king. To <xex>tantalize</xex> is to visit with the bitterest disappointment -- to torment by exciting hopes or expectations which can never be realized.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalizer</ent><br/
<hw>Tan"ta*li`zer</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who tantalizes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalizingly</ent><br/
<hw>Tan"ta*li`zing*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a tantalizing or teasing manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalum</ent><br/
<hw>Tan"ta*lum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. So named on account of the perplexity and difficulty encounterd by its discoverer (Ekeberg) in isolating it. See <er>Tantalus</er>.]</ety> <fld>(Chem.)</fld> <def>A rare nonmetallic element found in certain minerals, as tantalite, samarskite, and fergusonite, and isolated as a dark powder which becomes steel-gray by burnishing. Symbol Ta. Atomic weight 182.0. Formerly called also <altname>tantalium</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantalus</ent><br/
<hw>Tan"ta*lus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., from Gr. <grk>Ta`ntalos</grk>.]</ety> <fld>(Gr. Myth.)</fld> <sn>1.</sn> <def>A Phrygian king who was punished in the lower world by being placed in the midst of a lake whose waters reached to his chin but receded whenever he attempted to allay his thirst, while over his head hung branches laden with choice fruit which likewise receded whenever he stretched out his hand to grasp them.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A genus of wading birds comprising the wood ibises.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tantalus's cup</b></col> <fld>(Physics)</fld>, <cd>a philosophical toy, consisting of a cup, within which is the figure of a man, and within the figure a siphon, the longer arm of which passes down through the bottom of the cup, and allows the escape of any liquid that may be poured in, when it reaches as high as the bend of the siphon, which is just below the level of the mouth of the figure in the cup.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantamount</ent><br/
<hw>Tan"ta*mount`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F. <ets>tant</ets> so much (L. <ets>tantus</ets>) + E. <ets>amount</ets>.]</ety> <def>Equivalent in value, signification, or effect.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A usage nearly <qex>tantamount</qex> to constitutional right.</q> <rj><qau>Hallam.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The certainty that delay, under these circumstances, was <qex>tantamount</qex> to ruin.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantamount</ent><br/
<hw>Tan"ta*mount`</hw>, <pos>v. i.</pos> <def>To be tantamount or equivalent; to amount.</def> <mark>[Obs.]</mark>  <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantivy</ent><br/
<hw>Tan*tiv"y</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[Said to be from the note of a hunting horn.]</ety> <def>Swiftly; speedily; rapidly; -- a fox-hunting term; <as>as, to ride <ex>tantivy</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantivy</ent><br/
<hw>Tan*tiv"y</hw>, <pos>n.</pos> <def>A rapid, violent gallop; an impetuous rush.</def>  <rj><au>Cleverland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantivy</ent><br/
<hw>Tan*tiv"y</hw>, <pos>v. i.</pos> <def>To go away in haste.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tantra</ent><br/
<hw>Tan"tra</hw> <pr>(t<acr/n"tr<adot/; t<ucr/n"tr<adot/)</pr>, <pos>n.</pos> <ety>[Skr.]</ety> <fld>(Hinduism)</fld> <def>A ceremonial treatise related to Puranic and magic literature; esp., one of the sacred works of the worshipers of Sakti.</def> -- <wordforms><wf>Tan"tric</wf> <pr>(t<acr/n"tr<icr/k)</pr>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tantrism</ent><br/
<hw>Tan"trism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The system of doctrines and  rites taught in the tantras.</def> -- <wordforms><wf>Tan"trist</wf> <pr>(#)</pr>, <pos>n.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tantrum</ent><br/
<hw>Tan"trum</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A whim; an affected air.</def> <mark>[Colloq. and archaic]</mark>  <rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A display of ill-humor, especially a demonstration of rage or frustration by shouting or violent physical movements, such as the stamping of feet; called also <altname>temper tantrum</altname>.  It is usually associated with children, but is sometimes seen in adults.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <mark>[fig.]</mark> <def>A display of anger expressed by irrationally striking out at innocent targets or inanimate objects; <as>as, the governor was so insulted by the article, he threw a temper <ex>tantrum</ex> and cancelled the ceremony</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tanyard</ent><br/
<hw>Tan"yard`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An inclosure where the tanning of leather is carried on; a tannery.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tanystomata</ent><br/
\'d8<hw>Tan`y*stom"a*ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <?/ to stretch + <?/, <?/, mouth.]</ety> <fld>(Zool.)</fld> <def>A division of dipterous insects in which the proboscis is large and contains lancelike mandibles and maxillae. The horseflies and robber flies are examples.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taoism</ent><br/
<hw>Ta"o*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One of the popular religions of China, sanctioned by the state.</def> -- <wordforms><wf>Ta"o*ist</wf>, <pos>a. & n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taotai</ent><br/
\'d8<hw>Tao`tai"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Chin. <ets>tao</ets> circuit + <ets>t'ai</ets>, a title of respect.]</ety> <def>In China, an official at the head of the civil and military affairs of a circuit, which consists of two or more <xex>fu</xex>, or territorial departments; -- called also, by foreigners, <altname>intendant of circuit</altname>. Foreign consuls and commissioners associated with taotais as superintendants of trade at the treaty ports are ranked with the taotai.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tap</ent><br/
<hw>Tap</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tapped</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tapping</conjf>.]</vmorph> <ety>[F. <ets>taper</ets> to strike; of Teutonic origin; cf. dial. G. <ets>tapp</ets>, <ets>tapps</ets>, a blow, <ets>tappe</ets> a paw, fist, G. <ets>tappen</ets> to grope.]</ety> <sn>1.</sn> <def>To strike with a slight or gentle blow; to touch gently; to rap lightly; to pat; <as>as, to <ex>tap</ex> one with the hand or a cane</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To put a new sole or heel on; <as>as, to <ex>tap</ex> shoes</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tap</ent><br/
<hw>Tap</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>tape</ets>. See <er>Tap</er> to strike.]</ety> <sn>1.</sn> <def>A gentle or slight blow; a light rap; a pat.</def>  <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A piece of leather fastened upon the bottom of a boot or shoe in repairing or renewing the sole or heel.</def>
<-- a piece of metal so fastened, used to reduce wear on the shoe, or for the purpose of tap dancing. --><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <fld>(Mil.)</fld> <def>A signal, by drum or trumpet, for extinguishing all lights in soldiers' quarters and retiring to bed, -- usually given about a quarter of an hour after tattoo.</def>  <rj><au>Wilhelm.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tap</ent><br/
<hw>Tap</hw>, <pos>v. i.</pos> <def>To strike a gentle blow.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tap</ent><br/
<hw>Tap</hw>, <pos>n.</pos> <ety>[AS. <ets>t<ae/ppa</ets>, akin to D. <ets>tap</ets>, G. <ets>zapfen</ets>, OHG. <ets>zapfo</ets>, Dan. <ets>tap</ets>, Sw. <ets>tapp</ets>, Icel. <ets>tappi</ets>.  Cf. <er>Tampion</er>, <er>Tip</er>.]</ety> <sn>1.</sn> <def>A hole or pipe through which liquor is drawn.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A plug or spile for stopping a hole pierced in a cask, or the like; a faucet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Liquor drawn through a tap; hence, a certain kind or quality of liquor; <as>as, a liquor of the same <ex>tap</ex></as>.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A place where liquor is drawn for drinking; a taproom; a bar.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Mech.)</fld> <def>A tool for forming an internal screw, as in a nut, consisting of a hardened steel male screw grooved longitudinally so as to have cutting edges.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>On tap</b></col>. <sd>(a)</sd> <cd>Ready to be drawn; <as>as, ale <ex>on tap</ex></as>.</cd> <sd>(b)</sd> <cd>Broached, or furnished with a tap; <as>as, a barrel <ex>on tap</ex></as>.</cd> -- <col><b>Plug tap</b></col> <fld>(Mech.)</fld>, <cd>a screw-cutting tap with a slightly tapering end.</cd> -- <col><b>Tap bolt</b></col>, <cd>a bolt with a head on one end and a thread on the other end, to be screwed into some fixed part, instead of passing through the part and receiving a nut. See <xex>Illust.</xex> under <er>Bolt</er>.</cd> -- <col><b>Tap cinder</b></col> <fld>(Metal.)</fld>, <cd>the slag of a puddling furnace.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tap</ent><br/
<hw>Tap</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To pierce so as to let out, or draw off, a fluid; <as>as, to <ex>tap</ex> a cask, a tree, a tumor,  a keg of beer, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, to draw resources from (a reservoir) in any analogous way; <as>as, to <ex>tap</ex> someone's knowledge of the Unix system; to <ex>tap</ex> the treasury.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To draw, or cause to flow, by piercing.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He has been <qex>tapping</qex> his liquors.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mech.)</fld> <def>To form an internal screw in (anything) by means of a tool called a <xex>tap</xex>; <as>as, to <ex>tap</ex> a nut, a pipe, or tubing</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>to connect a listening device to (a telephone or telegraph line) secretly, for the purpose of hearing private conversations; also, to obtain or record (information) by tapping; -- a technique used by law enforcement agencies investigating suspected criminals.  In the United States it is illegal without a court order permitting it.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tapa</ent><br/
\'d8<hw>Ta"pa</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kind of cloth prepared by the Polynesians from the inner bark of the paper mulberry; -- sometimes called also <altname>kapa</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapadero</ent><br/
<ent>Tapadera</ent><br/
<mhw>{ \'d8<hw>Tap`a*de"ra</hw> <pr>(?)</pr>, \'d8<hw>Tap`a*de"ro</hw> <pr>(?)</pr> }</mhw>, <pos>n.</pos>} <altsp>[Also <asp>tapidero</asp>.]</altsp> <ety>[Sp. <ets>tapadera</ets> lid, cover.]</ety> <def>One of the leather hoods which cover the stirrups of a Mexican saddle.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tapayaxin</ent><br/
\'d8<hw>Ta`pa*yax"in</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A Mexican spinous lizard (<spn>Phrynosoma orbiculare</spn>) having a head somewhat like that of a toad; -- called also <altname>horned toad</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tape</ent><br/
<hw>Tape</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>t<ae/ppe</ets> a fillet.  Cf. <er>Tapestry</er>, <er>Tippet</er>.]</ety> <sn>1.</sn> <def>A narrow fillet or band of cotton or linen; a narrow woven fabric used for strings and the like; <as>as, curtains tied with <ex>tape</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tapeline; also, a metallic ribbon so marked as to serve as a tapeline; <as>as, a steel <ex>tape</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Red tape</b></col>. <cd>See under <er>Red</er>.</cd> -- <col><b>Tape grass</b></col> <fld>(Bot.)</fld>, <cd>a plant (<spn>Vallisneria spiralis</spn>) with long ribbonlike leaves, growing in fresh or brackish water; -- called also <altname>fresh-water eelgrass</altname>, and, in Maryland, <altname>wild celery</altname>.</cd> -- <col><b>Tape needle</b></col>.  <cd>See <er>Bodkin</er>, <pos>n.</pos>, 4.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tape</ent><br/
<hw>Tape</hw> <pr>(?)</pr>, <pos>v. t.</pos>  <vmorph>[<pos>imp. & p. p.</pos> <conjf>Taped</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Taping</conjf>.]</vmorph> <sn>1.</sn> <def>To furnish with tape; to fasten, tie, bind, or the like, with tape;</def> <specif>specif.</specif> <fld>(Elec.)</fld>, <def>to cover (a wire) with insulating tape.</def></p>

<p><sn>2.</sn> <def>to record on audio tape or video tape; -- either directly, at the scene of the action tape, or indirectly, as from a broadcast of the action.</def> <ldquo/I was busy when that episode was on TV, but I <ex>taped</ex> it and watched it later.<rdquo/<br/
[<source>PJC</source>]</p>

<p><ent>Tape deck</ent><br/
<hw>Tape deck</hw> <pr>(?)</pr>, <pos>n.</pos> <def>an electroinic device for recording and playing back sounds on magnetic tape; usually it needs to be connected to an amplifier system for playback.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tapeline</ent><br/
<hw>Tape"line`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A painted tape, marked with linear dimensions, as inches, feet, etc., and often inclosed in a case, -- used for measuring.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taper</ent><br/
<hw>Ta"per</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>tapur</ets>, <ets>tapor</ets>, <ets>taper</ets>; cf. Ir. <ets>tapar</ets>, W. <ets>tampr</ets>.]</ety> <sn>1.</sn> <def>A small wax candle; a small lighted wax candle; hence, a small light.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Get me a <qex>taper</qex> in my study, Lucius.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tapering form; gradual diminution of thickness in an elongated object; <as>as, the <ex>taper</ex> of a spire</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1474 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taper</ent><br/
<hw>Ta"per</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Supposed to be from <ets>taper</ets>, n., in allusion to its form.]</ety> <def>Regularly narrowed toward the point; becoming small toward one end; conical; pyramidical; <as>as, <ex>taper</ex> fingers</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taper</ent><br/
<hw>Ta"per</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tapered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tapering</conjf>.]</vmorph> <def>To become gradually smaller toward one end; <as>as, a sugar loaf <ex>tapers</ex> toward one end</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taper</ent><br/
<hw>Ta"per</hw>, <pos>v. t.</pos> <def>To make or cause to taper.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tape recorder</ent><br/
<hw>Tape recorder</hw> <pr>(?)</pr>, <pos>n.</pos> <def>an electroinic device for recording and playing back sounds on magnetic tape; it often has an integrated microphone, amplifier, and speaker, and in such cases requires no additional equipment other than the magnetic tape for recording or playback.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tape recording</ent><br/
<hw>Tape recording</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>a recording of sound or video on magnetic tape.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>the process of recording sound or video on magnetic tape.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tapered</ent><br/
<hw>Ta"pered</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Lighted with a taper or tapers; <as>as, a <ex>tapered</ex> choir</as>.</def> <mark>[R.]</mark>  <rj><au>T. Warton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapering</ent><br/
<hw>Ta"per*ing</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Becoming gradually smaller toward one end.</def> -- <wordforms><wf>Ta"per*ing*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taperness</ent><br/
<hw>Ta"per*ness</hw>, <pos>n.</pos> <def>The quality or state of being taper; tapering form; taper.</def>  <rj><au>Shenstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapestry</ent><br/
<hw>Tap"es*try</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tapestries</plw> <pr>(#)</pr>.</plu> <ety>[F. <ets>tapissere</ets>, fr. <ets>tapisser</ets> to carpet, to hang, or cover with tapestry, fr. <ets>tapis</ets> a carpet, carpeting, LL. <ets>tapecius</ets>, fr. L. <ets>tapete</ets> carpet, tapestry, Gr. <?/, <?/.  Cf. <er>Tapis</er>, <er>Tippet</er>.]</ety> <def>A fabric, usually of worsted, worked upon a warp of linen or other thread by hand, the designs being usually more or less pictorial and the stuff employed for wall hangings and the like. The term is also applied to different kinds of embroidery.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tapestry carpet</b></col>, <cd>a kind of carpet, somewhat resembling Brussels, in which the warp is printed before weaving, so as to produce the figure in the cloth.</cd> -- <col><b>Tapestry moth</b></col>. <fld>(Zool.)</fld> <cd>Same as <cref>Carpet moth</cref>, under <er>Carpet</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapestry</ent><br/
<hw>Tap"es*try</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tapestried</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tapestrying</conjf>.]</vmorph> <def>To adorn with tapestry, or as with tapestry.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Trosachs wound, as now, between gigantic walls of rock <qex>tapestried</qex> with broom and wild roses.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapestry beetle</ent><br/
<hw>Tap"es*try bee"tle</hw>. <def>A small black dermestoid beetle (<spn>Attagenus piceus</spn>) whose larva feeds on tapestry, carpets, silk, fur, flour, and various other goods.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tapet</ent><br/
<hw>Tap"et</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tapete</ets>. See <er>Tapestry</er>.]</ety> <def>Worked or figured stuff; tapestry.</def> <mark>[R.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapeti</ent><br/
<hw>Tap"e*ti</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tapetis</plw> <pr>(#)</pr>.</plu> <ety>[Braz.]</ety> <fld>(Zool.)</fld> <def>A small South American hare (<spn>Lepus Braziliensis</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapetum</ent><br/
\'d8<hw>Ta*pe"tum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., from L. <ets>tapete</ets> a carpet, a tapestry.]</ety> <fld>(Anat.)</fld> <def>An area in the pigmented layer of the choroid coat of the eye in many animals, which has an iridescent or metallic luster and helps to make the eye visible in the dark. Sometimes applied to the whole layer of pigmented epithelium of the choroid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapeworm</ent><br/
<hw>Tape"worm`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Any one of numerous species of cestode worms belonging to Taenia and many allied genera. The body is long, flat, and composed of numerous segments or proglottids varying in shape, those toward the end of the body being much larger and longer than the anterior ones, and containing the fully developed sexual organs. The head is small, destitute of a mouth, but furnished with two or more suckers (which vary greatly in shape in different genera), and sometimes, also, with hooks for adhesion to the walls of the intestines of the animals in which they are parasitic. The larvae (see <er>Cysticercus</er>) live in the flesh of various creatures, and when swallowed by another animal of the right species develop into the mature tapeworm in its intestine. See <xex>Illustration</xex> in Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Three species are common parasites of man: the <stype>pork tapeworm</stype> (<spn>Taenia solium</spn>), the larva of which is found in pork; the <stype>beef tapeworm</stype> (<spn>Taenia mediocanellata</spn>), the larva of which lives in the flesh of young cattle; and the <stype>broad tapeworm</stype> (<spn>Bothriocephalus latus</spn>) which is found chiefly in the inhabitants of the mountainous regions of Europe and Asia. See also <er>Echinococcus</er>, <er>Cysticercus</er>, <er>Proglottis</er>, and 2d <er>Measles</er>, 4.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taphouse</ent><br/
<hw>Tap"house`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A house where liquors are retailed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taphrenchyma</ent><br/
\'d8<hw>Taph*ren"chy*ma</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ a trench + <ets>enchyma</ets>, as in <ets>parenchyma</ets>.]</ety> <fld>(Bot.)</fld> <def>Same as <er>Bothrenchyma</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapinage</ent><br/
<hw>Tap"i*nage</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tapish</er>.]</ety> <def>A lurking or skulking.</def> <mark>[Obs.]</mark>  <rj><au>Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapioca</ent><br/
<hw>Tap`i*o"ca</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Braz. <ets>tapioka</ets>: cf. Pg., Sp. & F. <ets>tapioca</ets>.]</ety> <def>A coarsely granular substance obtained by heating, and thus partly changing, the moistened starch obtained from the roots of the cassava. It is much used in puddings and as a thickening for soups. See <er>Cassava</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapir</ent><br/
<hw>Ta"pir</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Braz. <ets>tapy'ra</ets>: cf. F. <ets>tapir</ets>.]</ety> <fld>(Zool.)</fld> <def>Any one of several species of large odd-toed ungulates belonging to <gen>Tapirus</gen>, <gen>Elasmognathus</gen>, and allied genera. They have a long prehensile upper lip, short ears, short and stout legs, a short, thick tail, and short, close hair. They have three toes on the hind feet, and four toes on the fore feet, but the outermost toe is of little use.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The best-known species are the Indian tapir (<spn>Tapirus Indicus</spn>), native of the <geog>East Indies</geog> and <geog>Malacca</geog>, which is black with a broad band of white around the middle, and the common American tapir (<spn>Tapirus Americanus</spn>), which, when adult, is dull brown. Several others species inhabit the Andes and Central America.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tapir tiger</b></col> <fld>(Zool.)</fld>, <cd>the wallah.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapiroid</ent><br/
<hw>Ta"pir*oid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tapir</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Allied to the tapir, or the Tapir family.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapis</ent><br/
<hw>Ta"pis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See <er>Tapestry</er>.]</ety> <def>Tapestry; formerly, the cover of a council table.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>On the tapis</b></col>, <it>or</it> <col><b>Upon the tapis</b></col></mcol>, <cd>on the table, or under consideration; <as>as, to lay a motion in Parliament <ex>on the tapis</ex></as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapis</ent><br/
<hw>Tap"is</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To cover or work with figures like tapestry.</def> <mark>[R.]</mark>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapiser</ent><br/
<hw>Tap"is*er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tapissier</ets>.]</ety> <def>A maker of tapestry; an upholsterer.</def> <mark>[R.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapish</ent><br/
<hw>Tap"ish</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[F. se <ets>tapir</ets> to squat.]</ety> <def>To lie close to the ground, so as to be concealed; to squat; to crouch; hence, to hide one's self.</def> <altsp>[Written also <asp>tappis</asp>, <asp>tappish</asp>, <asp>tappice</asp>.]</altsp> <mark>[Obs. or Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>As a hound that, having roused a hart,<br/
Although he <qex>tappish</qex> ne'er so soft.</q> <rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taplash</ent><br/
<hw>Tap"lash`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Bad small beer; also, the refuse or dregs of liquor.</def> <mark>[Obs. or Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>taplash</qex> of strong ale and wine.</q> <rj><qau>Taylor (1630).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taplings</ent><br/
<hw>Tap"lings</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>The strong double leathers by which the two parts of a flail are united.</def>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapoa tafa</ent><br/
\'d8<hw>Ta*po"a ta"fa</hw> <pr>(?)</pr>. <fld>(Zool.)</fld> <def>A small carnivorous marsupial (<spn>Phascogale penicillata</spn>) having long, soft fur, and a very long tail with a tuft of long hairs at the end; -- called also <altname>brush-tailed phascogale</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tappen</ent><br/
<hw>Tap"pen</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An obstruction, or indigestible mass, found in the intestine of bears and other animals during hibernation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapper</ent><br/
<hw>Tap"per</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The lesser spotted woodpecker (<spn>Dendrocopus minor</spn>); -- called also <altname>tapperer</altname>, <altname>tabberer</altname>, <altname>little wood pie</altname>, <altname>barred woodpecker</altname>, <altname>wood tapper</altname>, <altname>hickwall</altname>, and <altname>pump borer</altname>.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tappester</ent><br/
<hw>Tap"pes*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tapster</er>.]</ety> <def>A female tapster.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tappet</ent><br/
<hw>Tap"pet</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Mach.)</fld> <def>A lever or projection moved by some other piece, as a cam, or intended to tap or touch something else, with a view to produce change or regulate motion.</def>  <rj><au>G. Francis.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tappet motion</b></col>, <cd>a valve motion worked by tappets from a reciprocating part, without an eccentric or cam, -- used in steam pumps, etc.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tappet rod</ent><br/
<hw>Tap"pet rod</hw>. <fld>(Mech.)</fld> <def>A rod carrying a tappet or tappets, as one for closing the valves in a Cornish pumping engine.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tappis</ent><br/
<ent>Tappice</ent><br/
<mhw>{ <hw>Tap"pice</hw> <pr>(?)</pr>, <hw>Tap"pis</hw> <pr>(?)</pr> }</mhw>, <pos>v. i.</pos> <def>See <er>Tapish</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tappit hen</ent><br/
<hw>Tap"pit hen`</hw> <pr>(?)</pr>. <sn>1.</sn> <def>A hen having a tuft of feathers on her head.</def> <mark>[Scot.]</mark>  <rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A measuring pot holding one quart (according to some, three quarts); -- so called from a knob on the lid, thought to resemble a crested hen.</def> <mark>[Scot.]</mark>  <rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tappoon</ent><br/
<hw>Tap*poon"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>tamp<oacute/n</ets> a stopper.]</ety> <fld>(Irrigation)</fld> <def>A piece of wood or sheet metal fitted into a ditch to dam up the water so as to overflow a field.</def> <mark>[U. S.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taproom</ent><br/
<hw>Tap"room`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A room where liquors are kept on tap; a barroom.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The ambassador was put one night into a miserable <qex>taproom</qex>, full of soldiers smoking.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taproot</ent><br/
<hw>Tap"root`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The root of a plant which penetrates the earth directly downward to a considerable depth without dividing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tapster</ent><br/
<hw>Tap"ster</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>t<ae/ppestre</ets> a female tapster. See <er>Tap</er> a plug, pipe, and <er>-ster</er>.]</ety> <def>One whose business is to tap or draw ale or other liquor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taqua-nut</ent><br/
<hw>Ta"qua-nut`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A Central American name for the ivory nut.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tar</ent><br/
<hw>Tar</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Abbrev. from <ets>tarpaulin</ets>.]</ety> <def>A sailor; a seaman.</def> <mark>[Colloq.]</mark>  <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tar</ent><br/
<hw>Tar</hw>, <pos>n.</pos> <ety>[OE. <ets>terre</ets>, <ets>tarre</ets>, AS. <ets>teru</ets>, <ets>teoru</ets>; akin to D. <ets>teer</ets>, G. <ets>teer</ets>, <ets>theer</ets>, Icel. <ets>tjara</ets>, Sw. <ets>tj<aum/ra</ets>, Dan. <ets>ti<ae/re</ets>, and to E. <ets>tree</ets>. <root/63. See <er>Tree</er>.]</ety> <def>A thick, black, viscous liquid obtained by the distillation of wood, coal, etc., and having a varied composition according to the temperature and material employed in obtaining it.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Coal tar</b></col>. <cd>See in the Vocabulary.</cd> -- <col><b>Mineral tar</b></col> <fld>(Min.)</fld>, <cd>a kind of soft native bitumen.</cd> -- <col><b>Tar board</b></col>, <cd>a strong quality of millboard made from junk and old tarred rope.</cd> <au>Knight.</au> -- <col><b>Tar water</b></col>. <sd>(a)</sd> <cd>A cold infusion of tar in water, used as a medicine.</cd> <sd>(b)</sd> <cd>The ammoniacal water of gas works.</cd> -- <col><b>Wood tar</b></col>, <cd>tar obtained from wood. It is usually obtained by the distillation of the wood of the pine, spruce, or fir, and is used in varnishes, cements, and to render ropes, oakum, etc., impervious to water.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tar</ent><br/
<hw>Tar</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tarred</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tarring</conjf>.]</vmorph> <def>To smear with tar, or as with tar; <as>as, to <ex>tar</ex> ropes; to <ex>tar</ex> cloth.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To tar and feather a person</b></col>. <cd>See under <er>Feather</er>, <pos>v. t.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taranis</ent><br/
<hw>Tar"a*nis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>taranis</ets>, from the Celtic; cf. W. & Corn. <ets>taran</ets> thunder.]</ety> <fld>(Myth.)</fld> <def>A Celtic divinity, regarded as the evil principle, but confounded by the Romans with Jupiter.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarantass</ent><br/
<hw>Tar`an*tass"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Russ. <ets>tarantas'</ets>.]</ety> <def>A low four-wheeled carriage used in Russia. The carriage box rests on two long, springy poles which run from the fore to the hind axletree. When snow falls, the wheels are taken off, and the body is mounted on a sledge.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarantella</ent><br/
<hw>Tar`an*tel"la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It.]</ety> <fld>(Mus.)</fld> <sd>(a)</sd> <def>A rapid and delirious sort of Neapolitan dance in 6-8 time, which moves in whirling triplets; -- so called from a popular notion of its being a remedy against the poisonous bite of the <xex>tarantula</xex>. Some derive its name from Taranto in Apulia.</def> <sd>(b)</sd> <def>Music suited to such a dance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarantism</ent><br/
<hw>Tar"ant*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It. <ets>tarantismo</ets>: cf. F. <ets>tarentisme</ets>. See <er>Tarantula</er>.]</ety> <fld>(Med.)</fld> <def>A nervous affection producing melancholy, stupor, and an uncontrollable desire to dance. It was supposed to be produced by the bite of the tarantula, and considered to be incapable of cure except by protracted dancing to appropriate music.</def> <altsp>[Written also <asp>tarentism</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarantula</ent><br/
<hw>Ta*ran"tu*la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E. <plw>Tarantulas</plw> <pr>(#)</pr>, L. <plw>Tarantulae</plw> <pr>(#)</pr>.</plu> <ety>[NL., fr. It. <ets>tarantola</ets>, fr. L. <ets>Tarentum</ets>, now <ets>Taranto</ets>, in the south of Italy.]</ety> <fld>(Zool.)</fld> <def>Any one of several species of large spiders, popularly supposed to be very venomous, especially the European species (<spn>Tarantula apuliae</spn>). The tarantulas of Texas and adjacent countries are large species of Mygale.</def> <altsp>[Written also <asp>tarentula</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tarantula killer</b></col>, <cd>a very large wasp (<spn>Pompilus formosus</spn>), which captures the Texan tarantula (<spn>Mygale Hentzii</spn>) and places it in its nest as food for its young, after paralyzing it by a sting.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarantulated</ent><br/
<hw>Ta*ran"tu*la`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Bitten by a tarantula; affected with tarantism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarbogan</ent><br/
<hw>Tar*bog"an</hw> <pr>(?)</pr>, <pos>n. & v.</pos> <def>See <er>Toboggan</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarboosh</ent><br/
<hw>Tar*boosh"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Ar. <ets>tarb<?/sh</ets>; perhaps from Per. <ets>sar-posh</ets> headdress: cf. F. <ets>tarbouch</ets>.]</ety> <def>A red cap worn by Turks and other Eastern nations, sometimes alone and sometimes swathed with linen or other stuff to make a turban. See <er>Fez</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardation</ent><br/
<hw>Tar*da"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tardatio</ets>, fr. <ets>tardare</ets>, <ets>tardatum</ets>, to retard, delay, fr. <ets>tardus</ets> slow.]</ety> <def>The act of retarding, or delaying; retardation.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardigrada</ent><br/
\'d8<hw>Tar`di*gra"da</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Tardigrade</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>A tribe of edentates comprising the sloths. They are noted for the slowness of their movements when on the ground. See <er>Sloth</er>, 3.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>An order of minute aquatic arachnids; -- called also <altname>bear animalcules</altname>, <altname>sloth animalcules</altname>, and <altname>water bears</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardigrade</ent><br/
<hw>Tar"di*grade</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tardigradus</ets>; <ets>tardus</ets> slow + <ets>gradi</ets> to step: cf. F. <ets>tardigrade</ets>.]</ety> <sn>1.</sn> <def>Moving or stepping slowly; slow-paced.</def> <mark>[R.]</mark>  <rj><au>G. Eliot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>Of or pertaining to the Tardigrada.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardigrade</ent><br/
<hw>Tar"di*grade</hw>, <pos>n.</pos> <fld>(Zool.)</fld> <def>One of the Tardigrada.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardigradous</ent><br/
<hw>Tar"di*gra`dous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Moving slowly; slow-paced.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardily</ent><br/
<hw>Tar"di*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a tardy manner; slowly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardiness</ent><br/
<hw>Tar"di*ness</hw>, <pos>n.</pos> <def>The quality or state of being tardy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarditation</ent><br/
<hw>Tar`di*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Tardiness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>To instruct them to avoid all snares of <qex>tarditation</qex>, in the Lord's affairs.</q> <rj><qau>Herrick.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardity</ent><br/
<hw>Tar"di*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tarditas</ets>.]</ety> <def>Slowness; tardiness.</def> <mark>[R.]</mark>  <rj><au>Sir K. Digby.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardo</ent><br/
\'d8<hw>Tar"do</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[It.]</ety> <fld>(Mus.)</fld> <def>Slow; -- a direction to perform a passage slowly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardo</ent><br/
\'d8<hw>Tar"do</hw>, <pos>n.</pos> <ety>[Sp., slow, L. <ets>tardus</ets>.]</ety> <fld>(Zool.)</fld> <def>A sloth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardy</ent><br/
<hw>Tar"dy</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Tardier</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Tardiest</adjf>.]</amorph> <ety>[F. <ets>tardif</ets>, fr. (assumed) LL. <ets>tardivus</ets>, fr. L. <ets>tardus</ets> slow.]</ety> <sn>1.</sn> <def>Moving with a slow pace or motion; slow; not swift.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And check the <qex>tardy</qex> flight of time.</q> <rj><qau>Sandys.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tardy</qex> to vengeance, and with mercy brave.</q> <rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not being inseason; late; dilatory; -- opposed to <xex>prompt</xex>; <as>as, to be <ex>tardy</ex> in one's payments</as>.</def>  <rj><au>Arbuthnot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>tardy</qex> plants in our cold orchards placed.</q> <rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Unwary; unready.</def> <mark>[Obs.]</mark>  <rj><au>Hudibras.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Criminal; guilty.</def> <mark>[Obs.]</mark>  <rj><au>Collier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Slow; dilatory; tedious; reluctant. See <er>Slow</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tardy</ent><br/
<hw>Tar"dy</hw>, <pos>v. t.</pos> <def>To make tardy.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tare</ent><br/
<hw>Tare</hw> <pr>(?)</pr>, <mark>obs.</mark> <pos>imp.</pos> <mord>of <er>Tear</er></mord>. <def>Tore.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tare</ent><br/
<hw>Tare</hw>, <pos>n.</pos> <ety>[Cf. Prov. E. <ets>tare</ets> brisk, eager, OE. <ets>tarefitch</ets> the wild vetch.]</ety> <sn>1.</sn> <def>A weed that grows among wheat and other grain; -- alleged by modern naturalists to be the <spn>Lolium temulentum</spn>, or darnel.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Didst not thou sow good seed in thy field? From whence then hath it <qex>tares</qex>?</q> <rj><qau>Matt. xiii. 27.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <ldquo/darnel<rdquo/ is said to be the <qex>tares</qex> of Scripture, and is the only deleterious species belonging to the whole order.</q> <rj><qau>Baird.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>A name of several climbing or diffuse leguminous herbs of the genus <gen>Vicia</gen>; especially, the <spn>Vicia sativa</spn>, sometimes grown for fodder.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tare</ent><br/
<hw>Tare</hw>, <pos>n.</pos> <ety>[F. <ets>tare</ets>; cf. Pr., Sp., Pg., & It. <ets>tara</ets>; all fr. Ar. <ets>tarah</ets> thrown away, removed, fr. <ets>taraha</ets> to reject, remove.]</ety> <fld>(Com.)</fld> <def>Deficientcy in the weight or quantity of goods by reason of the weight of the cask, bag, or whatever contains the commodity, and is weighed with it; hence, the allowance or abatement of a certain weight or quantity which the seller makes to the buyer on account of the weight of such cask, bag, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tare</ent><br/
<hw>Tare</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tared</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Taring</conjf>.]</vmorph> <def>To ascertain or mark the tare of (goods).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tared</ent><br/
<hw>Tared</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Weighed; determined; reduced to equal or standard weight; <as>as, <ex>tared</ex> filter papers, used in weighing precipitates</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarente</ent><br/
<hw>Ta*ren"te</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tarente</ets>.]</ety> <fld>(Zool.)</fld> <def>A harmless lizard of the Gecko family (<spn>Platydactylus Mauritianicus</spn>) found in Southern Europe and adjacent countries, especially among old walls and ruins.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarentism</ent><br/
<hw>Tar"ent*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tarantism</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarentula</ent><br/
<hw>Ta*ren"tu*la</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tarantula</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Targe</ent><br/
<hw>Targe</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.  Cf. <er>Target</er>.]</ety> <def>A shield or target.</def> <mark>[Obs. or Poetic]</mark> <ldquo/A buckler on a <xex>targe</xex>.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Target</ent><br/
<hw>Tar"get</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>targette</ets>, dim. of OF. & F. <ets>targe</ets>, of Teutonic origin; cf. AS. <ets>targe</ets>, OD. <ets>targie</ets>, G. <ets>zarge</ets> a frame, case, border, OHG. <ets>zarga</ets>, Icel. <ets>targa</ets> shield.]</ety> <sn>1.</sn> <def>A kind of small shield or buckler, used as a defensive weapon in war.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <sd>(a)</sd> <def>A butt or mark to shoot at, as for practice, or to test the accuracy of a firearm, or the force of a projectile.</def> <sd>(b)</sd> <def>The pattern or arrangement of a series of hits made by a marksman on a butt or mark; <as>as, he made a good <ex>target</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Surveying)</fld> <def>The sliding crosspiece, or vane, on a leveling staff.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Railroad)</fld> <def>A conspicuous disk attached to a switch lever to show its position, or for use as a signal.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A thin cut; a slice; specif., of lamb, a piece consisting of the neck and breast joints.</def> <mark>[Eng.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>6.</sn>  <def>A tassel or pendent; also, a shred; tatter.</def> <mark>[Obs. Scot.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>7.</sn>  <def>A goal for an activity; <as>as, the <ex>target</ex> of this year's fundraising drive is 2 million dollars</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>8.</sn>  <def>A metallic object toward which a beam of electrons is aimed in a tube designed to generate X-rays; when the electrons strike the <ex>target,</ex> the impact causes emission of X-rays.</def><br/
[<source>PJC</source>]</p>

<p><sn>9.</sn>  <def>Any object toward which a beam of photons, a laser beam, an electron beam, or a beam of atomic or subatomic particles is aimed.</def><br/
[<source>PJC</source>]</p>

<p><sn>10.</sn>  <def>A person who is the subject of criticism or ridicule.</def><br/
[<source>PJC</source>]</p>

<p><ent>Target date</ent><br/
<hw>Tar"get date</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The date set as a goal for completion of some activity.</def><br/
[<source>PJC</source>]</p>

<p><ent>Target language</ent><br/
<hw>Tar"get language</hw> <pr>(?)</pr>, <pos>n.</pos> <def>the language into which a text is to be translated; -- correlative of <inv>source language</inv>.</def><br/
[<source>PJC</source>]</p>

<p><-- p. 1475 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Targeted</ent><br/
<hw>Tar"get*ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Furnished, armed, or protected, with a target.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Targeteer</ent><br/
<hw>Tar`get*eer"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who is armed with a target or shield.</def> <altsp>[Written also <asp>targetier</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Targum</ent><br/
<hw>Tar"gum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Targums</plw> <pr>(#)</pr>. Heb. <plw>Targumim</plw> <pr>(#)</pr>.</plu> <ety>[Chald. <ets>targ<umac/m</ets> interpretation, fr. <ets>targ<emac/m</ets> to interpret.  Cf. <er>Truchman</er>, and <er>Dragoman</er>.]</ety> <def>A translation or paraphrase of some portion of the Old Testament Scriptures in the Chaldee or Aramaic language or dialect.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Targumist</ent><br/
<hw>Tar"gum*ist</hw>, <pos>n.</pos> <def>The writer of a Targum; one versed in the Targums.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarheel</ent><br/
<hw>Tar"heel</hw> <pr>(?)</pr>, <pos>n.</pos> <def>a native or resident of North Carolina; -- used as a nickname.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tarheel state</ent><br/
<hw>Tar"heel state</hw> <pr>(?)</pr>, <pos>n.</pos> <def>North Carolina; -- used as a nickname.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tariff</ent><br/
<hw>Tar"iff</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tarif</ets>; cf. Sp. & Pg. <ets>tarifa</ets>, It. <ets>tariffa</ets>; all fr. Ar. <ets>ta'r<imac/f</ets> information, explanation, definition, from <ets>'arafa</ets>, to know, to inform, explain.]</ety> <sn>1.</sn> <def>A schedule, system, or scheme of duties imposed by the government of a country upon goods imported or exported; <as>as, a revenue <ex>tariff</ex>; a protective <ex>tariff</ex>; Clay's compromise <ex>tariff</ex>. (U. S. 1833).</as></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The United States and Great Britain impose no duties on exports; hence, in these countries the <ex>tariff</ex> refers only to imports.</note><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A tariff may be imposed solely for, and with reference to, the production of revenue (called a <col><b>revenue tariff</b></col>, or <col><b>tariff for revenue</b></col>, or for the artificial fostering of home industries (<col><b>a projective tariff</b></col>), or as a means of coercing foreign governments, as in case of <col><b>retaliatory tariff</b></col>.</note><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>The duty, or rate of duty, so imposed; <as>as, the <ex>tariff</ex> on wool; a <ex>tariff</ex> of two cents a pound.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any schedule or system of rates, changes, etc.; <as>as, a <ex>tariff</ex> of fees, or of railroad fares</as>.</def>  <rj><au>Bolingbroke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tariff</ent><br/
<hw>Tar"iff</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tariffed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tariffing</conjf>.]</vmorph> <def>To make a list of duties on, as goods.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarin</ent><br/
<hw>Tar"in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <fld>(Zool.)</fld> <def>The siskin.</def> <mark>[Prov.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taring</ent><br/
<hw>Tar"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The common tern; -- called also <altname>tarret</altname>, and <altname>tarrock</altname>.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarlatan</ent><br/
<hw>Tar"la*tan</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kind of thin, transparent muslin, used for dresses.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarn</ent><br/
<hw>Tarn</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>terne</ets>, Icel. <ets>tj<oum/rn</ets>.]</ety> <def>A mountain lake or pool.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A lofty precipice in front,<br/
A silent <qex>tarn</qex> below.</q> <rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarnish</ent><br/
<hw>Tar"nish</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tarnished</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tarnishing</conjf>.]</vmorph> <ety>[F. <ets>ternir</ets>, fr. OHG. <ets>tarnen</ets> to darken, to conceal, hide; akin to OS. <ets>dernian</ets> to hide, AS. <ets>dernan</ets>, <ets>dyrnan</ets>, OHG. <ets>tarni</ets> hidden, OS. <ets>derni</ets>, AS. <ets>derne</ets>, <ets>dyrne</ets>.  Cf. <er>Dern</er>, <pos>a.</pos>, and see <er>-ish</er>.]</ety> <def>To soil, or change the appearance of, especially by an alternation induced by the air, or by dust, or the like; to diminish, dull, or destroy the luster of; to sully; <as>as, to <ex>tarnish</ex> a metal; to <ex>tarnish</ex> gilding; to <ex>tarnish</ex> the purity of color</as>.</def> <ldquo/<xex>Tarnished</xex> lace.<rdquo/ <au>Fuller.</au> Used also figuratively; <as>as, to <ex>tarnish</ex> one's honor</as>.<br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To sully; stain; dim.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarnish</ent><br/
<hw>Tar"nish</hw>, <pos>v. i.</pos> <def>To lose luster; to become dull; <as>as, gilding will <ex>tarnish</ex> in a foul air</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Till thy fresh glories, which now shine so bright,<br/
Grow stale and <qex>tarnish</qex> with our daily sight.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarnish</ent><br/
<hw>Tar"nish</hw>, <pos>n.</pos> <sn>1.</sn> <def>The quality or state of being tarnished; stain; soil; blemish.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Min.)</fld> <def>A thin film on the surface of a metal, usually due to a slight alteration of the original color; <as>as, the steel <ex>tarnish</ex> in columbite</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarnisher</ent><br/
<hw>Tar"nish*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that which, tarnishes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taro</ent><br/
<hw>Ta"ro</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the Polynesian name.]</ety> <fld>(Bot.)</fld> <def>A name for several aroid plants (<spn>Colocasia antiquorum</spn>, var. <varn>esculenta</varn>, <spn>Colocasia macrorhiza</spn>, etc.), and their rootstocks. They have large ovate-sagittate leaves and large fleshy tuberous rootstocks, which are cooked and used for food in tropical countries.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarot</ent><br/
<hw>Tar"ot</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.; cf. It. <ets>tarocco</ets>.]</ety> <sn>1.</sn> <def>A game of cards; -- called also <altname>taroc</altname>.</def>  <rj><au>Hoyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>any of a set of 22 playing cards which bear allegorical images representing various objects or influences affecting human life, and widely used in fortunetelling; they are also used as trumps in the game of  taroc.  Various images are used by different artists to represent the themes of each card.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tarpan</ent><br/
<hw>Tar"pan</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native name.]</ety> <fld>(Zool.)</fld> <def>A wild horse found in the region of the Caspian Sea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarpaulin</ent><br/
<hw>Tar*pau"lin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tar</ets> + <ets>palling</ets> a covering, pall to cover. See <er>Pall</er> a covering.]</ety> <sn>1.</sn> <def>A piece of canvas covered with tar or a waterproof composition, used for covering the hatches of a ship, hammocks, boats, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A hat made of, or covered with, painted or tarred cloth, worn by sailors and others.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, a sailor; a seaman; a tar.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To a landsman, these <qex>tarpaulins</qex>, as they were called, seemed a strange and half-savage race.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarpeian</ent><br/
<hw>Tar*pe"ian</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>Tarpeius</ets>, prop., pertaining to <etsep>Tarpeia</etsep>.]</ety> <def>Pertaining to or designating a rock or peak of the Capitoline hill, Rome, from which condemned criminals were hurled.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tarpon</ent><br/
<hw>Tar"pon</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Tarpum</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarpum</ent><br/
<hw>Tar"pum</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A very large marine fish (<spn>Megapolis Atlanticus</spn>) of the Southern United States and the West Indies. It often becomes six or more feet in length, and has large silvery scales. The scales are a staple article of trade, and are used in fancywork. Called also <altname>tarpon</altname>, <altname>sabalo</altname>, <altname>savanilla</altname>, <altname>silverfish</altname>, and <altname>jewfish</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarquinish</ent><br/
<hw>Tar"quin*ish</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Like a Tarquin, a king of ancient Rome; proud; haughty; overbearing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarrace</ent><br/
<hw>Tar"race</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Trass</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarragon</ent><br/
<hw>Tar"ra*gon</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>taragona</ets>, Ar. <ets>tarkh<?/n</ets>; perhaps fr. Gr. <?/ a dragon, or L. <ets>draco</ets>; cf. L. <ets>dracunculus</ets> tarragon.  Cf. <er>Dragon</er>.]</ety> <fld>(Bot.)</fld> <def>A plant of the genus <gen>Artemisa</gen> (<spn>Artemisa dracunculus</spn>), much used in France for flavoring vinegar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarras</ent><br/
<hw>Tar"ras</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Trass</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarre</ent><br/
<hw>Tarre</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[OE. <ets>tarien</ets>, <ets>terien</ets>, to irritate, provoke, AS. <ets>tergan</ets> to pull, pluck, torment; probably akin to E. <ets>tear</ets>, v. t.  <root/63.  Cf. <er>Tarry</er>, <pos>v.</pos>]</ety> <def>To set on, as a dog; to incite.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarriance</ent><br/
<hw>Tar"ri*ance</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act or time of tarrying; delay; lateness.</def> <mark>[Archaic]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And after two days' <qex>tarriance</qex> there, returned.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarrier</ent><br/
<hw>Tar"ri*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that which, tarries.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarrier</ent><br/
<hw>Tar"ri*er</hw>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A kind of dig; a terrier.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarrock</ent><br/
<hw>Tar"rock</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Greenland <ets>tattarock</ets>.]</ety> <fld>(Zool.)</fld> <sd>(a)</sd> <def>The young of the kittiwake gull before the first molt.</def> <sd>(b)</sd> <def>The common guillemot.</def> <mark>[Prov. Eng.]</mark> <sd>(c)</sd> <def>The common tern.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarry</ent><br/
<hw>Tar"ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Tar</er>, <pos>n.</pos>]</ety> <def>Consisting of, or covered with, tar; like tar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarry</ent><br/
<hw>Tar"ry</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tarried</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tarrying</conjf>.]</vmorph> <ety>[OE. <ets>tarien</ets> to irritate (see <er>Tarre</er>); but with a change of sense probably due to confusion with OE. <ets>targen</ets> to delay, OF. <ets>targier</ets>, fr. (assumed) LL. <ets>tardicare</ets>, fr. L. <ets>tardare</ets> to make slow, to tarry, fr. <ets>tardus</ets> slow.  Cf. <er>Tardy</er>.]</ety> <sn>1.</sn> <def>To stay or remain behind; to wait.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tarry</qex> ye for us, until we come again.</q> <rj><qau>Ex. xxiv. 14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To delay; to put off going or coming; to loiter.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Come down unto me, <qex>tarry</qex> not.</q> <rj><qau>Gen. xic. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>One <qex>tarried</qex> here, there hurried one.</q> <rj><qau>Emerson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To stay; to abide; to continue; to lodge.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tarry</qex> all night, and wash your feet.</q> <rj><qau>Gen. xix. 2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To abide; continue; lodge; await; loiter.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarry</ent><br/
<hw>Tar"ry</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To delay; to defer; to put off.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tarry</qex> us here no longer than to-morrow.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To wait for; to stay or stop for.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He that will have a cake out of the wheat must needs <qex>tarry</qex> the grinding.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He plodded on, . . . <qex>tarrying</qex> no further question.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarry</ent><br/
<hw>Tar"ry</hw>, <pos>n.</pos> <def>Stay; stop; delay.</def> <mark>[Obs.]</mark>  <rj><au>E. Lodge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsal</ent><br/
<hw>Tar"sal</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <def>Of or pertaining to the tarsus (either of the foot or eye).</def> -- <def2><pos>n.</pos> <def>A tarsal bone or cartilage; a tarsale.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tarsal tetter</b></col> <fld>(Med.)</fld>, <cd>an eruptive disease of the edges of the eyelids; a kind of bleareye.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsal</ent><br/
<hw>Tar"sal</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Tercel</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsale</ent><br/
\'d8<hw>Tar*sa"le</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tarsalia</plw> <pr>(#)</pr>.</plu> <ety>[NL.]</ety> <fld>(Anat.)</fld> <def>One of the bones or cartilages of the tarsus; esp., one of the series articulating with the metatarsals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarse</ent><br/
<hw>Tarse</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Tassel</er>, <er>Tiercel</er>.]</ety> <fld>(Falconry)</fld> <def>The male falcon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarse</ent><br/
<hw>Tarse</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tarse</ets>.]</ety> <fld>(Anat.)</fld> <def>tarsus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsectomy</ent><br/
<hw>Tar*sec"to*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tarsus</ets> + Gr. <?/ to cut out.]</ety> <fld>(Surg.)</fld> <def>The operation of excising one or more of the bones of the tarsus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsel</ent><br/
<hw>Tar"sel</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A male hawk. See <er>Tercel</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsi</ent><br/
\'d8<hw>Tar"si</hw> <pr>(?)</pr>, <pos>n.</pos>, <def><pos>pl.</pos> of <er>Tarsus</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsiatura</ent><br/
<ent>Tarsia</ent><br/
<mhw>{ \'d8<hw>Tar"si*a</hw> <pr>(?)</pr>, \'d8<hw>Tar`si*a*tu"ra</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[It.]</ety> <def>A kind of mosaic in woodwork, much employed in Italy in the fifteenth century and later, in which scrolls and arabesques, and sometimes architectural scenes, landscapes, fruits, flowers, and the like, were produced by inlaying pieces of wood of different colors and shades into panels usually of walnut wood.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsier</ent><br/
<hw>Tar"si*er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tarsier</ets>.]</ety> <def>See <er>Tarsius</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsius</ent><br/
\'d8<hw>Tar"si*us</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Tarsus</er>.]</ety> <fld>(Zool.)</fld> <def>A genus of nocturnal lemurine mammals having very large eyes and ears, a long tail, and very long proximal tarsal bones; -- called also <altname>malmag</altname>, <altname>spectral lemur</altname>, <altname>podji</altname>, and <altname>tarsier</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarso-</ent><br/
<hw>Tar"so-</hw> <pr>(?)</pr>. <def>A combining form used in anatomy to indicate <xex>connection with</xex>, or <xex>relation to</xex>, <xex>the tarsus</xex>; <as>as, <ex>tarso</ex>metatarsus</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsometatarsal</ent><br/
<hw>Tar`so*met`a*tar"sal</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <sd>(a)</sd> <def>Of or pertaining to both the tarsus and metatarsus; <as>as, the <ex>tarsometatarsal</ex> articulations</as>.</def> <sd>(b)</sd> <def>Of or pertaining to the tarsometatarsus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsometatarsus</ent><br/
\'d8<hw>Tar`so*met`a*tar"sus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tarsometatarsi</plw> <pr>(#)</pr>.</plu> <ety>[NL.]</ety> <fld>(Anat.)</fld> <def>The large bone next the foot in the leg of a bird. It is formed by the union of the distal part of the tarsus with the metatarsus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsorrhaphy</ent><br/
<hw>Tar*sor"rha*phy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tarsus</ets> + Gr. <grk>"rafh`</grk> seam, fr. <?/ to sew.]</ety> <fld>(Surg.)</fld> <def>An operation to diminish the size of the opening between eyelids when enlarged by surrounding cicatrices.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsotomy</ent><br/
<hw>Tar*sot"o*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tarsus</ets> + Gr. <?/ to cut.]</ety> <fld>(Surg.)</fld> <def>The operation of cutting or removing the tarsal cartilages.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarsus</ent><br/
<hw>Tar"sus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tarsi</plw> <pr>(#)</pr>.</plu> <ety>[NL., fr. Gr. <?/ the flat of the foot, the edge of the eyelid.  Cf. 2d <er>Tarse</er>.]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <sd>(a)</sd> <def>The ankle; the bones or cartilages of the part of the foot between the metatarsus and the leg, consisting in man of seven short bones.</def> <sd>(b)</sd> <def>A plate of dense connective tissue or cartilage in the eyelid of man and many animals; -- called also <altname>tarsal cartilage</altname>, and <altname>tarsal plate</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The foot of an insect or a crustacean. It usually consists of form two to five joints.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tart</ent><br/
<hw>Tart</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[AS. <ets>teart</ets>. <root/63.  Cf. <er>Tear</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>Sharp to the taste; acid; sour; <as>as, a <ex>tart</ex> apple</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: Sharp; keen; severe; <as>as, a <ex>tart</ex> reply; <ex>tart</ex> language; a <ex>tart</ex> rebuke.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Why art thou <qex>tart</qex>, my brother?</q> <rj><qau>Bunyan.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tart</ent><br/
<hw>Tart</hw>, <pos>n.</pos> <ety>[OE. <ets>tarte</ets>, F. <ets>tarte</ets>; perhaps originally the same word as <ets>tourte</ets>, LL. <ets>torta</ets>, fr. L. <ets>tortus</ets>, p. p. of <ets>torquere</ets> to twist, bend, wind, because tarts were originally made of a twisted shape.  Cf. <er>Torture</er>, <pos>n.</pos>]</ety> <def>A species of small open pie, or piece of pastry, containing jelly or conserve; a sort of fruit pie.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartan</ent><br/
<hw>Tar"tan</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tiretane</ets> linsey-woolsey, akin to Sp. <ets>tirita<ntil/a</ets> a sort of thin silk; cf. Sp. <ets>tiritar</ets> to shiver or shake with cold.]</ety> <def>Woolen cloth, checkered or crossbarred with narrow bands of various colors, much worn in the Highlands of Scotland; hence, any pattern of tartan; also, other material of a similar pattern.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>MacCullummore's heart will be as cold as death can make it, when it does not warm to the <qex>tartan</qex>.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The sight of the <qex>tartan</qex> inflamed the populace of London with hatred.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartan</ent><br/
<hw>Tar"tan</hw>, <pos>n.</pos> <ety>[F. <ets>tartane</ets>, or Sp., Pg., or It. <ets>tartana</ets>; all perhaps of Arabic origin.]</ety> <fld>(Naut.)</fld> <def>A small coasting vessel, used in the Mediterranean, having one mast carrying large leteen sail, and a bowsprit with staysail or jib.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartar</ent><br/
<hw>Tar"tar</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tartre</ets> (cf. Pr. <ets>tartari</ets>, Sp., Pg., & It. <ets>tartaro</ets>, LL. <ets>tartarum</ets>, LGr. <?/); perhaps of Arabic origin.]</ety> <sn>1.</sn> <fld>(Chem.)</fld> <def>A reddish crust or sediment in wine casks, consisting essentially of crude cream of tartar, and used in marking pure cream of tartar, tartaric acid, potassium carbonate, black flux, etc., and, in dyeing, as a mordant for woolen goods; -- called also <altname>argol</altname>, <altname>wine stone</altname>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A correction which often incrusts the teeth, consisting of salivary mucus, animal matter, and phosphate of lime.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Cream of tartar</b></col>. <fld>(Chem.)</fld> <cd>See under <er>Cream</er>.</cd> -- <col><b>Tartar emetic</b></col> <fld>(Med. Chem.)</fld>, <cd>a double tartrate of potassium and basic antimony. It is a poisonous white crystalline substance having a sweetish metallic taste, and used in medicine as a sudorific and emetic.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartar</ent><br/
<hw>Tar"tar</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <ety>[Per. <ets>T<amac/t<amac/r</ets>, of Tartar origin.]</ety> <def>A native or inhabitant of Tartary in Asia; a member of any one of numerous tribes, chiefly Moslem, of Turkish origin, inhabiting the Russian Europe; -- written also, more correctly but less usually, <altname>Tatar</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A person of a keen, irritable temper.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To catch a tartar</b></col>, <cd>to lay hold of, or encounter, a person who proves too strong for the assailant.</cd> <mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartar</ent><br/
<hw>Tar"tar</hw>, <pos>a.</pos> <def>Of or pertaining to Tartary in Asia, or the Tartars.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartar</ent><br/
<hw>Tar"tar</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>tartare</ets>.]</ety> <def>See <er>Tartarus</er>.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartarated</ent><br/
<hw>Tar"tar*a`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Tartrated.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartareous</ent><br/
<ent>Tartarean</ent><br/
<mhw>{ <hw>Tar*ta"re*an</hw> <pr>(?)</pr>, <hw>Tar*ta"re*ous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>tartareus</ets>: cf. F. <ets>tartar<eacute/en</ets>.]</ety> <def>Of or pertaining to Tartarus; hellish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartareous</ent><br/
<hw>Tar*ta"re*ous</hw>, <pos>a.</pos> <ety>[Cf. 1st <er>Tartarous</er>.]</ety> <sn>1.</sn> <def>Consisting of tartar; of the nature of tartar.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Having the surface rough and crumbling; <as>as, many lichens are <ex>tartareous</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartaric</ent><br/
<ent>Tartarian</ent><br/
<mhw>{ <hw>Tar*ta"ri*an</hw> <pr>(?)</pr>, <hw>Tar*tar"ic</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <def>Of or pertaining to Tartary in Asia, or the Tartars.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tartarian lamb</b></col> <fld>(Bot.)</fld>, <cd>Scythian lamb. See <er>Barometz</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartarian</ent><br/
<hw>Tar*ta"ri*an</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The name of some kinds of cherries, <as>as the Black <ex>Tartarian</ex>, or the White <ex>Tartarian</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartaric</ent><br/
<hw>Tar*tar"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of or pertaining to tartar; derived from, or resembling, tartar.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tartaric acid</b></col>. <fld>(a)</fld> <cd>An acid widely diffused throughout the vegetable kingdom, as in grapes, mountain-ash berries, etc., and obtained from tartar as a white crystalline substance, <chform>C2H2(OH)2.(CO2H)2</chform>, having a strong pure acid taste. It is used in medicine, in dyeing, calico printing, photography, etc., and also as a substitute for lemon juice. Called also <altname>dextro-tartaric acid</altname>.</cd> <sd>(b)</sd> <cd>By extension, any one of the series of isomeric acids (racemic acid, levotartaric acid, inactive tartaric acid) of which tartaric acid proper is the type.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartarine</ent><br/
<hw>Tar"tar*ine</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Old Chem.)</fld> <def>Potassium carbonate, obtained by the incineration of tartar.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartarize</ent><br/
<hw>Tar"tar*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tartarized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tartarizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Cf. F. <ets>tartariser</ets>.]</ety> <fld>(Chem.)</fld> <def>To impregnate with, or subject to the action of, tartar.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tartarized antimony</b></col> <fld>(Med. Chem.)</fld>, <cd>tartar emetic.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartarize</ent><br/
<hw>Tar"tar*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To cause to resemble the Tartars and their civilization, as by conquest.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartarous</ent><br/
<hw>Tar"tar*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>tartareux</ets>.]</ety> <def>Containing tartar; consisting of tartar, or partaking of its qualities; tartareous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartarous</ent><br/
<hw>Tar"tar*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Resembling, or characteristic of, a Tartar; ill-natured; irritable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>Tartarous</qex> moods of common men.</q> <rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartarum</ent><br/
<hw>Tar"ta*rum</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>See 1st <er>Tartar</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartarus</ent><br/
<hw>Tar"ta*rus</hw> <pr>(t<aum/r"t<adot/*r<ucr/s)</pr>, <pos>prop. n.</pos> <ety>[L., from Gr. <grk>Ta`rtaros</grk>.]</ety> <fld>(Class. Myth.)</fld> <def>The infernal regions, described in the Iliad as situated as far below Hades as heaven is above the earth, and by later writers as the place of punishment for the spirits of the wicked. By the later poets, also, the name is often used synonymously with <altname>Hades</altname>, or the Lower World in general.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartary</ent><br/
<hw>Tar"ta*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Tartarus.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1476 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartini's tones</ent><br/
<hw>Tar*ti"ni's tones`</hw> <pr>(?)</pr>. <ety>[From <ets>Tartini</ets>, an Italian violinist, who discovered them in 1754.]</ety> <def>See the Note under <er>Tone</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartish</ent><br/
<hw>Tart"ish</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Somewhat tart.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartlet</ent><br/
<hw>Tart"let</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A small tart.</def>  <rj><au>V. Knox.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartly</ent><br/
<hw>Tart"ly</hw>, <pos>adv.</pos> <def>In a tart manner; with acidity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartness</ent><br/
<hw>Tart"ness</hw>, <pos>n.</pos> <def>The quality or state of being tart.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Acrimony; sourness; keenness; poignancy; severity; asperity; acerbity; harshness. See <er>Acrimony</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartralic</ent><br/
<hw>Tar*tral"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Tartar</er> the chemical compound.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an acid obtained as a white amorphous deliquescent substance, <chform>C8H10O11</chform>; -- called also <altname>ditartaric</altname>, <altname>tartrilic</altname>, or <altname>tartrylic acid</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartramate</ent><br/
<hw>Tar*tram"ate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of tartramic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartramic</ent><br/
<hw>Tar*tram"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tarto-</ets> + <ets>amic</ets>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, an acid which is the primary acid amide derivative of tartaric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartramide</ent><br/
<hw>Tar*tram"ide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tarto-</ets> + <ets>amide</ets>.]</ety> <fld>(Chem.)</fld> <def>An acid amide derivative of tartaric acid, obtained as a white crystalline substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartrate</ent><br/
<hw>Tar"trate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tartrate</ets>.]</ety> <fld>(Chem.)</fld> <def>A salt of tartaric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartrated</ent><br/
<hw>Tar"tra`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Med. Chem.)</fld> <def>Containing, or derived from, tartar; combined with tartaric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartrazine</ent><br/
<hw>Tar"tra*zine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tart</ets>aric + hyd<ets>razine</ets>.]</ety> <fld>(Chem.)</fld> <def>An artificial dyestuff obtained as an orange-yellow powder, and regarded as a phenyl hydrazine derivative of tartaric and sulphonic acids.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartrelic</ent><br/
<hw>Tar*trel"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Tartar</er> the chemical compound.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, an anhydride, <chform>C4H4O5</chform>, of tartaric acid, obtained as a white crystalline deliquescent substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartro-</ent><br/
<hw>Tar"tro-</hw>. <def>A combining form (also used adjectively) used in chemistry to denote <xex>the presence of tartar</xex> or <xex>of some of its compounds</xex> or <xex>derivatives</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartronate</ent><br/
<hw>Tar"tro*nate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of tartronic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartronic</ent><br/
<hw>Tar*tron"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tartro-</ets> + mal<ets>onic</ets>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, an organic acid (called also <xex>hydroxy malonic acid</xex>) obtained, by reducing mesoxalic acid, as a white crystalline substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartronyl</ent><br/
<hw>Tar"tro*nyl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tartron</ets>ic + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>A hypothetical radical constituting the characteristic residue of tartronic acid and certain of its derivatives.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartrovinic</ent><br/
<hw>Tar`tro*vin"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tartro-</ets> + <ets>vinic</ets>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, a certain acid composed of tartaric acid in combination with ethyl, and now called <xex>ethyltartaric acid</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartufe</ent><br/
<ent>Tartuffe</ent><br/
<mhw>{ <hw>Tar*tuffe"</hw>, <hw>Tar*tufe"</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tartufe</ets>.]</ety> <def>A hypocritical devotee. See the Dictionary of Noted Names in Fiction.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tartufish</ent><br/
<ent>Tartuffish</ent><br/
<mhw>{ <hw>Tar*tuff"ish</hw>, <hw>Tar*tuf"ish</hw>, }</mhw> <pos>a.</pos> <def>Like a tartuffe; precise; hypocritical.</def>  <rj><au>Sterne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tarweed</ent><br/
<hw>Tar"weed`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A name given to several resinous-glandular composite plants of California, esp. to the species of <gen>Grindelia</gen>, <gen>Hemizonia</gen>, and <gen>Madia</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tas</ent><br/
<hw>Tas</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A heap.</def> <mark>[Obs.]</mark> <ldquo/The <xex>tas</xex> of bodies slain.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tas</ent><br/
<hw>Tas</hw>, <pos>v. t.</pos> <def>To tassel.</def> <mark>[Obs.]</mark> <ldquo/A purse of leather <xex>tassed</xex> with silk.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasco</ent><br/
<hw>Tas"co</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Sp. <ets>tasconio</ets>.]</ety> <def>A kind of clay for making melting pots.</def>  <rj><au>Percy Smith.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasimer</ent><br/
<hw>Ta*sim"er</hw> <pr>(t<adot/*s<icr/m"<esl/*t<etil/r)</pr>, <pos>n.</pos> <ety>[Gr. <grk>ta`sis</grk> stretching, extension (from <grk>tei`nein</grk> to stretch) + <ets>-meter</ets>.]</ety> <fld>(Physics)</fld> <def>An instrument for detecting or measuring minute extensions or movements of solid bodies. It consists essentially of a small rod, disk, or button of carbon, forming part of an electrical circuit, the resistance of which, being varied by the changes of pressure produced by the movements of the object to be measured, causes variations in the strength of the current, which variations are indicated by a sensitive galvanometer. It is also used for measuring minute changes of temperature.</def>  <rj><au>T. A. Edison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Task</ent><br/
<hw>Task</hw> <pr>(t<adot/sk)</pr>, <pos>n.</pos> <ety>[OE. <ets>taske</ets>, OF. <ets>tasque</ets>, F. <ets>t<acir/che</ets>, for <ets>tasche</ets>, LL. <ets>tasca</ets>, <ets>taxa</ets>, fr. L. <ets>taxare</ets> to rate, appraise, estimate. See <er>Tax</er>, <pos>n.</pos> & <pos>v.</pos>]</ety> <sn>1.</sn> <def>Labor or study imposed by another, often in a definite quantity or amount.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ma <qex>task</qex> of servile toil.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Each morning sees some <qex>task</qex> begin,<br/
Each evening sees it close.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Business; employment; undertaking; labor.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His mental powers were equal to greater <qex>tasks</qex>.</q> <rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To take to task</b></col>. <cd>See under <er>Take</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Work; labor; employment; business; toil; drudgery; study; lesson; stint.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Task</ent><br/
<hw>Task</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tasked</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tasking</conjf>.]</vmorph> <sn>1.</sn> <def>To impose a task upon; to assign a definite amount of business, labor, or duty to.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There <qex>task</qex> thy maids, and exercise the loom.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To oppress with severe or excessive burdens; to tax.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To charge; to tax, as with a fault.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Too impudent to <qex>task</qex> me with those errors.</q> <rj><qau>Beau. & Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasker</ent><br/
<hw>Task"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who imposes a task.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who performs a task, as a day-laborer.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A laborer who receives his wages in kind.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taskmaster</ent><br/
<hw>Task"mas`ter</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who imposes a task, or burdens another with labor; one whose duty is to assign tasks; an overseer.</def>  <rj><au>Ex. i. 11.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>All is, if I have grace to use it so,<br/
As ever in my great <qex>Taskmaster's</qex> eye.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Task wage</ent><br/
<hw>Task wage</hw>. <fld>(Polit. Econ.)</fld> <def>A wage paid by the day, or some fixed period, on condition that a minimum task be performed. When the workman is paid in proportion for excess over the minimum, the wage is one for piece-work.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taskwork</ent><br/
<hw>Task"work`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Work done as a task; also, work done by the job; piecework.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taslet</ent><br/
<hw>Tas"let</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tasse</er> a piece of armor.]</ety> <def>A piece of armor formerly worn to guard the thighs; a tasse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasmanian</ent><br/
<hw>Tas*ma"ni*an</hw> <pr>(t<acr/z*m<amac/"n<icr/*<ait/n)</pr>, <pos>a.</pos> <def>Of or pertaining to Tasmania, or Van Diemen's Land.</def> -- <def2><pos>n.</pos> <def>A native or inhabitant of Tasmania;</def> <specif>specifically</specif> <fld>(Ethnol.)</fld>, <def>in the plural, the race of men that formerly inhabited Tasmania, but is now extinct.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tasmanian cider tree</b></col>. <fld>(Bot.)</fld> <cd>See the Note under <er>Eucalyptus</er>.</cd> -- <col><b>Tasmanian devil</b></col>. <fld>(Zool.)</fld> <cd>See under <er>Devil</er>.</cd> -- <col><b>Tasmanian wolf</b></col> <fld>(Zool.)</fld>, <cd>a savage carnivorous marsupial; -- called also <altname>zebra wolf</altname>. See <cref>Zebra wolf</cref>, under <er>Wolf</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasse</ent><br/
<hw>Tasse</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>tassette</ets>.]</ety> <def>A piece of armor for the thighs, forming an appendage to the ancient corselet.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Usually the <xex>tasse</xex> was a plate of iron swinging from the cuirass, but the skirts of sliding splints were also called by this name.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tassel</ent><br/
<hw>Tas"sel</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Falconry)</fld> <def>A male hawk. See <er>Tercel</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tassel</ent><br/
<hw>Tas"sel</hw>, <pos>n.</pos> <ety>[See <er>Teasel</er>.]</ety> <def>A kind of bur used in dressing cloth; a teasel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tassel</ent><br/
<hw>Tas"sel</hw>, <pos>n.</pos> <ety>[OE., a fastening of a mantle, OF. <ets>tassel</ets> a fastening, clasp, F. <ets>tasseau</ets> a bracket, Fr. L. <ets>taxillus</ets> a little die, dim. of <ets>talus</ets> a die of a longish shape, rounded on two sides and marked only on the other four, a knuckle bone.]</ety> <sn>1.</sn> <def>A pendent ornament, attached to the corners of cushions, to curtains, and the like, ending in a tuft of loose threads or cords.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The flower or head of some plants, esp. when pendent.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And the maize field grew and ripened, Till it stood in all the splendor<br/
Of its garments green and yellow,<br/
Of its <qex>tassels</qex> and its plumage.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A narrow silk ribbon, or the like, sewed to a book to be put between the leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Arch.)</fld> <def>A piece of board that is laid upon a wall as a sort of plate, to give a level surface to the ends of floor timbers; -- rarely used in the United States.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tassel flower</b></col> <fld>(Bot.)</fld>, <cd>a name of several composite plants of the genus <gen>Cineraria</gen>, especially the <spn>Cineraria sconchifolia</spn>, and of the blossoms which they bear.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tassel</ent><br/
<hw>Tas"sel</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tasseled</conjf> <pr>(?)</pr> or <conjf>Tasselled</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Tasseling</conjf> or <conjf>Tasselling</conjf>.]</vmorph> <def>To put forth a tassel or flower; <as>as, maize <ex>tassels</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tassel</ent><br/
<hw>Tas"sel</hw>, <pos>v. t.</pos> <def>To adorn with tassels.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasset</ent><br/
<hw>Tas"set</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tasse</er>.]</ety> <def>A defense for the front of the thigh, consisting of one or more iron plates hanging from the belt on the lower edge of the corselet.</def><-- same as tasse? --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tastable</ent><br/
<hw>Tast"a*ble</hw> <pr>(t<amac/st"<adot/*b'l)</pr>, <pos>a.</pos> <def>Capable of worthy of being tasted; savory; relishing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taste</ent><br/
<hw>Taste</hw> <pr>(t<amac/st)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tasted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Tasting</conjf>.]</vmorph> <ety>[OE. <ets>tasten</ets> to feel, to taste, OF. <ets>taster</ets>, F. <ets>tater</ets> to feel, to try by the touch, to try, to taste, (assumed) LL. <ets>taxitare</ets>, fr. L. <ets>taxare</ets> to touch sharply, to estimate. See <er>Tax</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>To try by the touch; to handle; <as>as, to <ex>taste</ex> a bow</as>.</def> <mark>[Obs.]</mark>  <rj><au>Chapman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Taste</qex> it well and stone thou shalt it find.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To try by the touch of the tongue; to perceive the relish or flavor of (anything) by taking a small quantity into a mouth. Also used figuratively.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When the ruler of the feast had <qex>tasted</qex> the water that was made wine.</q> <rj><qau>John ii. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When Commodus had once <qex>tasted</qex> human blood, he became incapable of pity or remorse.</q> <rj><qau>Gibbon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To try by eating a little; to eat a small quantity of.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I <qex>tasted</qex> a little of this honey.</q> <rj><qau>1 Sam. xiv. 29.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To become acquainted with by actual trial; to essay; to experience; to undergo.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He . . . should <qex>taste</qex> death for every man.</q> <rj><qau>Heb. ii. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To partake of; to participate in; -- usually with an implied sense of relish or pleasure.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou . . . wilt <qex>taste</qex><br/
No pleasure, though in pleasure, solitary.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taste</ent><br/
<hw>Taste</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To try food with the mouth; to eat or drink a little only; to try the flavor of anything; <as>as, to <ex>taste</ex> of each kind of wine</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To have a smack; to excite a particular sensation, by which the specific quality or flavor is distinguished; to have a particular quality or character; <as>as, this water <ex>tastes</ex> brackish; the milk <ex>tastes</ex> of garlic</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Yea, every idle, nice, and wanton reason<br/
Shall to the king <qex>taste</qex> of this action.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To take sparingly.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For age but <qex>tastes</qex> of pleasures, youth devours.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To have perception, experience, or enjoyment; to partake; <as>as, to <ex>taste</ex> of nature's bounty</as>.</def>  <rj><au>Waller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The valiant never <qex>taste</qex> of death but once.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taste</ent><br/
<hw>Taste</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of tasting; gustation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A particular sensation excited by the application of a substance to the tongue; the quality or savor of any substance as perceived by means of the tongue; flavor; <as>as, the <ex>taste</ex> of an orange or an apple; a bitter <ex>taste</ex>; an acid <ex>taste</ex>; a sweet <ex>taste</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Physiol.)</fld> <def>The one of the five senses by which certain properties of bodies (called their <xex>taste</xex>, <xex>savor</xex>, <xex>flavor</xex>) are ascertained by contact with the organs of taste.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Taste depends mainly on the contact of soluble matter with the terminal organs (connected with branches of the glossopharyngeal and other nerves) in the papillae on the surface of the tongue. The base of the tongue is considered most sensitive to bitter substances, the point to sweet and acid substances.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Intellectual relish; liking; fondness; -- formerly with <xex>of</xex>, now with <xex>for</xex>; <as>as, he had no <ex>taste</ex> for study</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I have no <qex>taste</qex><br/
Of popular applause.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The power of perceiving and relishing excellence in human performances; the faculty of discerning beauty, order, congruity, proportion, symmetry, or whatever constitutes excellence, particularly in the fine arts and belles-letters; critical judgment; discernment.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Manner, with respect to what is pleasing, refined, or in accordance with good usage; style; <as>as, music composed in good <ex>taste</ex>; an epitaph in bad <ex>taste</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Essay; trial; experience; experiment.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>A small portion given as a specimen; a little piece tasted or eaten; a bit.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>A kind of narrow and thin silk ribbon.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Savor; relish; flavor; sensibility; gout.</syn> <usage> -- <er>Taste</er>, <er>Sensibility</er>, <er>Judgment</er>. Some consider <xex>taste</xex> as a mere <xex>sensibility</xex>, and others as a simple exercise of <xex>judgment</xex>; but a union of both is requisite to the existence of anything which deserves the name. An original sense of the beautiful is just as necessary to aesthetic judgments, as a sense of right and wrong to the formation of any just conclusions on moral subjects. But this <ldquo/sense of the beautiful<rdquo/ is not an arbitrary principle. It is under the guidance of reason; it grows in delicacy and correctness with the progress of the individual and of society at large; it has its laws, which are seated in the nature of man; and it is in the development of these laws that we find the true <ldquo/standard of taste.<rdquo/</usage><br/
[<source>1913 Webster</source>]</p>

<p><q>What, then, is <qex>taste</qex>, but those internal powers,<br/
Active and strong, and feelingly alive<br/
To each fine impulse? a discerning sense<br/
Of decent and sublime, with quick disgust<br/
From things deformed, or disarranged, or gross<br/
In species? This, nor gems, nor stores of gold,<br/
Nor purple state, nor culture, can bestow,<br/
But God alone, when first his active hand<br/
Imprints the secret bias of the soul.</q> <rj><qau>Akenside.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Taste buds</b></col>, <it>or</it> <col><b>Taste goblets</b></col></mcol> <fld>(Anat.)</fld>, <cd>the flask-shaped end organs of taste in the epithelium of the tongue.  They are made up of modified epithelial cells arranged somewhat like leaves in a bud.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasteful</ent><br/
<hw>Taste"ful</hw> <pr>(t<amac/st"f<usdot/l)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having a high relish; savory.</def> <ldquo/<xex>Tasteful</xex> herbs.<rdquo/  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Having or exhibiting good taste; in accordance with good taste; tasty; <as>as, a <ex>tasteful</ex> drapery</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Taste"ful*ly</wf>, <pos>adv.</pos> -- <wf>Taste"ful*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasteless</ent><br/
<hw>Taste"less</hw>, <pos>a.</pos> <sn>1.</sn> <def>Having no taste; insipid; flat; <as>as, <ex>tasteless</ex> fruit</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Destitute of the sense of taste; or of good taste; <as>as, a <ex>tasteless</ex> age</as>.</def>  <rj><au>Orrery.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Not in accordance with good taste; <as>as, a <ex>tasteless</ex> arrangement of drapery; a <ex>tasteless</ex> remark</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Taste"less*ly</wf>, <pos>adv.</pos> -- <wf>Taste"less*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taster</ent><br/
<hw>Tast"er</hw> <pr>(t<amac/st"<etil/r)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who tastes; especially, one who first tastes food or drink to ascertain its quality.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thy tutor be thy <qex>taster</qex>, ere thou eat.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That in which, or by which, anything is tasted, as, a dram cup, a cheese taster, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>One of a peculiar kind of zooids situated on the polyp-stem of certain Siphonophora. They somewhat resemble the feeding zooids, but are destitute of mouths. See <er>Siphonophora</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tastily</ent><br/
<hw>Tast"i*ly</hw> <pr>(t<amac/st"<icr/*l<ycr/)</pr>, <pos>adv.</pos> <def>In a tasty manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasting</ent><br/
<hw>Tast"ing</hw>, <pos>n.</pos> <def>The act of perceiving or tasting by the organs of taste; the faculty or sense by which we perceive or distinguish savors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasto</ent><br/
\'d8<hw>Tas"to</hw> <pr>(t<aum/s"t<osl/)</pr>, <pos>n.</pos> <ety>[It.]</ety> <fld>(Mus.)</fld> <def>A key or thing touched to produce a tone.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs>\'d8<col><b>Tasto solo</b></col>, <cd>single touch; -- in old music, a direction denoting that the notes in the bass over or under which it is written should be performed alone, or with no other chords than unisons and octaves.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tasty</ent><br/
<hw>Tast"y</hw> <pr>(t<amac/st"<ycr/)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Tastier</adjf> <pr>(t<amac/st"<icr/*<etil/r)</pr>; <pos>superl.</pos> <adjf>Tastiest</adjf>.]</amorph> <sn>1.</sn> <def>Having a good taste; -- applied to persons; <as>as, a <ex>tasty</ex> woman</as>. See <er>Taste</er>, <pos>n.</pos>, 5.</def><-- not used in that sense now. --><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Being in conformity to the principles of good taste; elegant; <as>as, <ex>tasty</ex> furniture; a <ex>tasty</ex> dress.</as></def><br/
<syn><b>Syn. --</b> tasteful{2}.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tat</ent><br/
<hw>Tat</hw> <pr>(t<acr/t)</pr>, <pos>n.</pos> <ety>[Hind. <ets><tsdo/<amac/<tsdo/</ets>.]</ety> <def>Gunny cloth made from the fiber of the <spn>Corchorus olitorius</spn>, or jute.</def> <mark>[India]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tat</ent><br/
<hw>Tat</hw>, <pos>n.</pos> <ety>[Hind. <ets><tsdot/a<tsdot/<tsdot/<umac/</ets>.]</ety> <fld>(Zool.)</fld> <def>A pony.</def> <mark>[India]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tataupa</ent><br/
<hw>Ta*tau"pa</hw> <pr>(t<adot/*t<add/"p<adot/)</pr>, <pos>n.</pos> <ety>[From the native name.]</ety> <fld>(Zool.)</fld> <def>A South American tinamou (<spn>Crypturus tataupa</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatch</ent><br/
<hw>Tatch</hw> <pr>(t<acr/ch)</pr>, <pos>n.</pos> <ety>[F. <ets>tache</ets> spot. See <er>Techy</er>.]</ety> <def>A spot or stain; also, a trick.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Elyot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tath</ent><br/
<hw>Tath</hw> <pr>(t<acr/th)</pr>, <mark>obs.</mark> <def><pos>3d pers. sing. pres.</pos> of <er>Ta</er>, to take.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tath</ent><br/
<hw>Tath</hw>, <pos>n.</pos> <ety>[Prov. E.; of Scand. origin; cf. Icel. <ets>ta<edh/</ets> dung, <ets>ta<edh/a</ets> the grass of a manured pasture, <ets>te<edh/ja</ets> to manure.  <root/58.  Cf. <er>Ted</er>.]</ety> <sn>1.</sn> <def>Dung, or droppings of cattle.</def> <mark>[Prov. Eng. & Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The luxuriant grass growing about the droppings of cattle in a pasture.</def> <mark>[Prov. Eng. & Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tath</ent><br/
<hw>Tath</hw>, <pos>v. t.</pos> <def>To manure (land) by pasturing cattle on it, or causing them to lie upon it.</def> <mark>[Prov. Eng. & Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatou</ent><br/
<hw>Ta*tou"</hw> <pr>(t<adot/*t<oomac/")</pr>, <pos>n.</pos> <ety>[Cf. <er>Tatouay</er>.]</ety> <fld>(Zool.)</fld> <def>The giant armadillo (<spn>Priodontes gigas</spn>) of tropical South America. It becomes nearly five feet long including the tail. It is noted for its burrowing powers, feeds largely upon dead animals, and sometimes invades human graves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatouay</ent><br/
<hw>Tat"ou*ay</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Of Brazilian origin; cf. Pg. <ets>tatu</ets>, F. <ets>tatou</ets>.]</ety> <fld>(Zool.)</fld> <def>An armadillo (<spn>Xenurus unicinctus</spn>), native of the tropical parts of South America.  It has about thirteen movable bands composed of small, nearly square, scales.  The head is long; the tail is round and tapered, and nearly destitute of scales; the claws of the fore feet are very large.  Called also <altname>tatouary</altname>, and <altname>broad-banded armadillo</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatouhou</ent><br/
<hw>Tat"ou*hou</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Tatouay</er>.]</ety> <fld>(Zool.)</fld> <def>The peba.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatt</ent><br/
<hw>Tatt</hw> <pr>(t<acr/t)</pr>, <pos>v. t. & i.</pos> <def>To make (anything) by tatting; to work at tatting; <as>as, <ex>tatted</ex> edging</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1477 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatta</ent><br/
\'d8<hw>Tat"ta</hw> <pr>(t<acr/t"t<adot/)</pr>, <pos>n.</pos> <ety>[Hind. <ets><tsdot/a<tsdot/<tsdot/<imac/</ets>, <ets>t<amac/t<imac/</ets>.]</ety> <def>A bamboo frame or trellis hung at a door or window of a house, over which water is suffered to trickle, in order to moisten and cool the air as it enters.</def> <mark>[India]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatter</ent><br/
<hw>Tat"ter</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who makes tatting.</def>  <rj><au>Caulfield & S. (Doct. of Needlework).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatter</ent><br/
<hw>Tat"ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Icel. <ets>t<oum/tur</ets>, <ets>t<oum/ttur</ets>, pl. <ets>t<oum/trar</ets>, <ets><?/<oum/ttrar</ets>; cf. Norw. <ets>totra</ets>, pl. <ets>totror</ets>, LG. <ets>taltern</ets> tatters. <root/240.]</ety> <def>A rag, or a part torn and hanging; -- chiefly used in the plural.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Tear a passion to <qex>tatters</qex>, to very rags.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatter</ent><br/
<hw>Tat"ter</hw>, <pos>v. t.</pos> <vmorph>[<pos>p. p.</pos> <conjf>Tattered</conjf> <pr>(?)</pr>.]</vmorph> <def>To rend or tear into rags; -- used chiefly in the past participle as an adjective.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Where waved the <qex>tattered</qex> ensigns of Ragfair.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatterdemalion</ent><br/
<hw>Tat`ter*de*mal"ion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tatter</ets> + OF. <ets>desmaillier</ets> to break the meshes of, to tear: cf. OF. <ets>maillon</ets> long clothes, swadding clothes, F. <ets>maillot.</ets> See <er>Tatter</er>, and <er>Mail</er> armor.]</ety> <def>A ragged fellow; a ragamuffin.</def>  <rj><au>L'Estrange.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tattersall's</ent><br/
<hw>Tat"ter*sall's</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A famous horse market in London, established in 1766 by Richard Tattersall, also used as the headquarters of credit betting on English horse races; hence, a large horse market elsewhere.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tatting</ent><br/
<hw>Tat"ting</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kind of lace made from common sewing thread, with a peculiar stitch.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tatting shuttle</b></col>, <cd>the shuttle on which the thread used in tatting is wound.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tattle</ent><br/
<hw>Tat"tle</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tattled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tattling</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Akin to OE. <ets>tateren</ets>, LG. <ets>tateln</ets>, D. <ets>tateren</ets> to stammer, and perhaps to E. <ets>titter</ets>.]</ety> <sn>1.</sn> <def>To prate; to talk idly; to use many words with little meaning; to chat.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>tattling</qex> quality of age, which is always narrative.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To tell tales; to communicate secrets; to be a talebearer; <as>as, a <ex>tattling</ex> girl</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tattle</ent><br/
<hw>Tat"tle</hw>, <pos>n.</pos> <def>Idle talk or chat; trifling talk; prate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[They] told the <qex>tattle</qex> of the day.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tattler</ent><br/
<hw>Tat"tler</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who tattles; an idle talker; one who tells tales.</def>  <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>Any one of several species of large, long-legged sandpipers belonging to the genus <gen>Totanus</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The common American species are the greater tattler, or telltale (<spn>Totanus melanoleucus</spn>), the smaller tattler, or lesser yellowlegs (<spn>Totanus flavipes</spn>), the solitary tattler (<spn>Totanus solitarius</spn>), and the semipalmated tattler, or willet. The first two are called also <altname>telltale</altname>, <altname>telltale spine</altname>, <altname>telltale tattler</altname>, <altname>yellowlegs</altname>, <altname>yellowshanks</altname>, and <altname>yelper.</altname></note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tattlery</ent><br/
<hw>Tat"tler*y</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Idle talk or chat; tittle-tattle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tattling</ent><br/
<hw>Tat"tling</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Given to idle talk; apt to tell tales.</def> -- <wordforms><wf>Tat"tling*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tattoo</ent><br/
<hw>Tat*too"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Earlier <ets>taptoo</ets>, D. <ets>taptoe</ets>; <ets>tap</ets> a tap, faucet + <ets>toe</ets> to, shut (<it>i. e.</it>, the taps, or drinking houses, shut from the soldiers).]</ety> <fld>(Mil.)</fld> <def>A beat of drum, or sound of a trumpet or bugle, at night, giving notice to soldiers to retreat, or to repair to their quarters in garrison, or to their tents in camp.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>The Devil's tattoo</b></col>. <cd>See under <er>Devil</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tattoo</ent><br/
<hw>Tat*too"</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tattooed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tattooing</conjf>.]</vmorph> <ety>[Of Polynesian origin; cf. New Zealand <ets>ta</ets> to tattoo, <ets>tatu</ets> puncturation (in Otaheite).]</ety> <def>To color, as the flesh, by pricking in coloring matter, so as to form marks or figures which can not be washed out.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tattoo</ent><br/
<hw>Tat*too"</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tattoos</plw> <pr>(<?/)</pr>.</plu> <def>An indelible mark or figure made by puncturing the skin and introducing some pigment into the punctures; -- a mode of ornamentation practiced by various barbarous races, both in ancient and modern times, and also by some among civilized nations, especially by sailors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatty</ent><br/
<hw>Tat"ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl. <plw>Tatties</plw> <pr>(#)</pr></plu>. <ety>[Hind. <ets><tsdot/a<tsdot/<tsdot/<imac/</ets>.]</ety> <def>A mat or screen of fibers, as of the kuskus grass, hung at a door or window and kept wet to moisten and cool the air as it enters.</def> <mark>[India]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tatu</ent><br/
<hw>Ta*tu"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Tatou</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tatusiid</ent><br/
<hw>Ta*tu"si*id</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Any armadillo of the family <fam>Tatusiidae</fam>, of which the peba and mule armadillo are examples. Also used adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tau</ent><br/
<hw>Tau</hw> <pr>(tou)</pr>, <pos>n.</pos> <ety>[Gr. <grk>tay^</grk>.]</ety> <def>The nineteenth letter (<TAU/, <tau/) of the Greek alphabet, equivalent to English <it>t</it>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tau</ent><br/
<hw>Tau</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>tay^</grk> the letter <tau/ (English <er>T</er>).]</ety> <fld>(Zool.)</fld> <def>The common American toadfish; -- so called from a marking resembling the Greek letter <ex>tau</ex> (<tau/).</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tau cross</b></col>. <cd>See <xex>Illust.</xex> 6, of <er>Cross</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taught</ent><br/
<hw>Taught</hw> <pr>(?)</pr>, <pos>a.</pos> <def>See <er>Taut</er>.</def>  <rj><au>Totten.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taught</ent><br/
<hw>Taught</hw>, <def><pos>imp. & p. p.</pos> of <er>Teach</er>.</def> <ety>[AS. imp. <ets>t<aemac/hte</ets>, p. p. <ets>get<aemac/ht</ets>.]</ety> <note>See <er>Teach</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taunt</ent><br/
<hw>Taunt</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. OF. <ets>tant</ets> so great, F. <ets>tant</ets> so much, L. <ets>tantus</ets> of such size, so great, so much.]</ety> <fld>(Naut.)</fld> <def>Very high or tall; <as>as, a ship with <ex>taunt</ex> masts</as>.</def>  <rj><au>Totten.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taunt</ent><br/
<hw>Taunt</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Taunted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Taunting</conjf>.]</vmorph> <ety>[Earlier, to tease; probably fr. OF. <ets>tanter</ets> to tempt, to try, for <ets>tenter</ets>. See <er>Tempt</er>.]</ety> <def>To reproach with severe or insulting words; to revile; to upbraid; to jeer at; to flout.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When I had at my pleasure <qex>taunted</qex> her.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To deride; ridicule; mock; jeer; flout; revile. See <er>Deride</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taunt</ent><br/
<hw>Taunt</hw>, <pos>n.</pos> <def>Upbraiding language; bitter or sarcastic reproach; insulting invective.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>With scoffs, and scorns, and contemelious <qex>taunts</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>With sacrilegious <qex>taunt</qex> and impious jest.</q> <rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taunter</ent><br/
<hw>Taunt"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who taunts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taunting</ent><br/
<hw>Taunt"ing</hw>, <def><pos>a. & n.</pos> from <er>Taunt</er>, <pos>v.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Every kind of insolent and <qex>taunting</qex> reflection.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tauntingly</ent><br/
<hw>Taunt"ing*ly</hw>, <pos>adv.</pos> <def>In a taunting manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tauntress</ent><br/
<hw>Taunt"ress</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A woman who taunts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tawpie</ent><br/
<ent>Taupie</ent><br/
<mhw>{ <hw>Tau"pie</hw>, <hw>Taw"pie</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Icel. <ets>t<omac/pi</ets> fool, Dan. <ets>taabe</ets>, Sw. <ets>t<aring/p</ets>.]</ety> <def>A foolish or thoughtless young person, esp. a slothful or slovenly woman.</def> <mark>[Scot.]</mark>  <rj><au>Burns.</au></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taur</ent><br/
<hw>Taur</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>Taurus</ets>.]</ety> <def>The constellation Taurus.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tauricornous</ent><br/
<hw>Tau`ri*cor"nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tauricornis</ets>; <ets>taurus</ets> a bull + <ets>cornu</ets> a horn.]</ety> <fld>(Zool.)</fld> <def>Having horns like those of a bull.</def>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taurid</ent><br/
<hw>Tau"rid</hw> <pr>(?)</pr>, <pos>n.</pos>  <ety>[<ets>Taurus</ets> + 1st <ets>-id</ets>.]</ety> <fld>(Astron.)</fld> <def>Any of a group of meteors appearing November 20-23; -- so called because they appear to radiate from a point in Taurus.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tauridor</ent><br/
<hw>Tau`ri*dor"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Toreador</er>.]</ety> <def>A bullfighter; a toreador.</def>  <rj><au>Sir W. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tauriform</ent><br/
<hw>Tau"ri*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tauriformis</ets>; <ets>taurus</ets> a bull + <ets>-form</ets>: cf. F. <ets>tauriforme</ets>.]</ety> <def>Having the form of a bull.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taurine</ent><br/
<hw>Tau"rine</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>taurinus</ets>, fr. <ets>taurus</ets> a bull. See <er>Taurus</er>.]</ety> <fld>(Zool.)</fld> <def>Of or pertaining to the genus Taurus, or cattle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taurine</ent><br/
<hw>Tau"rine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So named because it was discovered in the bile of the ox. See <er>Taurus</er>.]</ety> <fld>(Physiol. Chem.)</fld> <def>A chemical compound occurring in small quantity in the juices of muscle, in the lungs, and elsewhere, but especially in the bile, where it is found as a component part of taurocholic acid, from which it can be prepared by decomposition of the acid. It crystallizes in colorless, regular six-sided prisms, and is especially characterized by containing both nitrogen and sulphur, being chemically amido-isethionic acid, <chform>C2H7NSO3</chform>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taurocholate</ent><br/
<hw>Tau`ro*cho"late</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Physiol. Chem.)</fld> <def>A salt of taurocholic acid; <as>as, sodium <ex>taurocholate</ex>, which occurs in human bile</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taurocholic</ent><br/
<hw>Tau`ro*chol"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Taur</ets>ine + <ets>cholic</ets>.]</ety> <fld>(Physiol. Chem.)</fld> <def>Pertaining to, or designating, a conjugate acid (called <xex>taurocholic acid</xex>) composed of taurine and cholic acid, present abundantly in human bile and in that of carnivora. It is exceedingly deliquescent, and hence appears generally as a thick, gummy mass, easily soluble in water and alcohol. It has a bitter taste.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taurocolla</ent><br/
<ent>Taurocol</ent><br/
<mhw>{ <hw>Tau"ro*col</hw> <pr>(?)</pr>, <hw>Tau`ro*col"la</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[NL. <ets>taurocolla</ets>, fr. Gr. <grk>tayro`kolla</grk>; <grk>tay^ros</grk> a bull + <grk>ko`lla</grk> glue: cf. F. <ets>taurocolle</ets>.]</ety> <def>Glue made from a bull's hide.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tauromachian</ent><br/
<hw>Tau`ro*ma"chi*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Tauromachy</er>.]</ety> <def>Of or pertaining to bullfights.</def> -- <def2><pos>n.</pos> <def>A bullfighter.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tauromachy</ent><br/
<hw>Tau*rom"a*chy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>tayromachi`a</grk>; <grk>tay^ros</grk> bull + <grk>ma`chh</grk> fight.]</ety> <def>Bullfighting.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taurus</ent><br/
\'d8<hw>Tau"rus</hw> <pr>(t<add/"r<ucr/s)</pr>, <pos>n.</pos> <ety>[L., akin to Gr. <grk>tay^ros</grk>, and E. <ets>steer</ets>. See <er>Steer</er> a young ox.]</ety> <sn>1.</sn> <fld>(Astron.)</fld> <sd>(a)</sd> <def>The Bull; the second in order of the twelve signs of the zodiac, which the sun enters about the 20th of April; -- marked thus [<Taurus/] in almanacs.</def> <sd>(b)</sd> <def>A zodiacal constellation, containing the well-known clusters called the Pleiades and the Hyades, in the latter of which is situated the remarkably bright Aldebaran.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A genus of ruminants comprising the common domestic cattle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taurylic</ent><br/
<hw>Tau*ryl"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>taurus</ets> a bull + E. phen<ets>ylic</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an acid found of a urine of neat cattle, and probably identical with <xex>cresol</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taut</ent><br/
<hw>Taut</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Dan. <ets>t<ae/t</ets>; akin to E. <ets>tight</ets>. See <er>Tight</er>.]</ety> <sn>1.</sn> <fld>(Naut.)</fld> <def>Tight; stretched; not slack; -- said esp. of a rope that is tightly strained.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Snug; close; firm; secure.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Taut hand</b></col> <fld>(Naut.)</fld>, <cd>a sailor's term for an officer who is severe in discipline.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautaug</ent><br/
<hw>Tau*taug"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Tautog</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tautegorical</ent><br/
<hw>Tau`te*gor"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/, for <?/ <?/ the same + <?/ to speak.  Cf. <er>Allegory</er>.]</ety> <def>Expressing the same thing with different words; -- opposed to <xex>allegorical</xex>.</def> <mark>[R.]</mark>  <rj><au>Coleridge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautochrone</ent><br/
<hw>Tau"to*chrone</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/, for <?/ <?/ the same + <?/ time: cf. F. <ets>tautochrone</ets>.]</ety> <fld>(Math.)</fld> <def>A curved line, such that a heavy body, descending along it by the action of gravity, will always arrive at the lowest point in the same time, wherever in the curve it may begin to fall; <as>as, an inverted cycloid with its base horizontal is a <ex>tautochrone</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautochronous</ent><br/
<hw>Tau*toch"ro*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Math.)</fld> <def>Occupying the same time; pertaining to, or having the properties of, a tautochrone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautog</ent><br/
<hw>Tau*tog"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[The pl. of <ets>taut</ets>, the American Indian name, translated by Roger Williams <ets>sheep's heads</ets>, and written by him <ets>tauta<uacute/og</ets>.]</ety> <fld>(Zool.)</fld> <def>An edible labroid fish (<spn>Haitula onitis</spn>, or <spn>Tautoga onitis</spn>) of the Atlantic coast of the United States. When adult it is nearly black, more or less irregularly barred, with greenish gray. Called also <altname>blackfish</altname>, <altname>oyster fish</altname>, <altname>salt-water chub</altname>, and <altname>moll</altname>.</def> <altsp>[Written also <asp>tautaug</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautologic</ent><br/
<hw>Tau`to*log"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Tautological.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautological</ent><br/
<hw>Tau`to*log"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>tautologique</ets>.]</ety> <def>Involving tautology; having the same signification; <as>as, <ex>tautological</ex> expression</as>.</def> -- <wordforms><wf>Tau`to*log"ic*al*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tautological echo</b></col>, <cd>an echo that repeats the same sound or syllable many times.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautologist</ent><br/
<hw>Tau*tol"o*gist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who uses tautological words or phrases.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautologize</ent><br/
<hw>Tau*tol"o*gize</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tautologized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tautologizing</conjf> <pr>(?)</pr>.]</vmorph> <def>To repeat the same thing in different words.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautologous</ent><br/
<hw>Tau*tol"o*gous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/; <?/, for <?/ <?/ the same + <?/ to speak.]</ety> <def>Repeating the same thing in different words; tautological.</def> <mark>[R.]</mark>  <rj><au>Tooke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautology</ent><br/
<hw>Tau*tol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tautologia</ets>, Gr. <?/: cf. F. <ets>tautologie</ets>.]</ety> <fld>(Rhet.)</fld> <def>A repetition of the same meaning in different words; needless repetition of an idea in different words or phrases; a representation of anything as the cause, condition, or consequence of itself, as in the following lines: --<br/
<br/
<q>The dawn is overcast, the morning lowers,<br/
And heavily in clouds brings on the day.</q> <rj><qau>Addison.</qau></rj></def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Repetition.</syn> <usage> -- <er>Tautology</er>, <er>Repetition</er>. There may be frequent <xex>repetitions</xex> (as in legal instruments) which are warranted either by necessity or convenience; but <xex>tautology</xex> is always a fault, being a sameness of expression which adds nothing to the sense or the sound.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautomeric</ent><br/
<hw>Tau`to*mer"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Relating to, or characterized by, tautomerism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautomerism</ent><br/
<hw>Tau*tom"er*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/; <?/, for <?/ <?/ the same + <?/ part.]</ety> <fld>(Chem.)</fld> <def>The condition, quality, or relation of metameric substances, or their respective derivatives, which are more or less interchangeable, according as one form or the other is the more stable. It is a special case of metamerism; thus, the lactam and the lactim compounds exhibit <xex>tautomerism</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautoousious</ent><br/
<ent>Tautoousian</ent><br/
<mhw>{ <hw>Tau`to*ou"si*an</hw> <pr>(?)</pr>, <hw>Tau`to*ou"si*ous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Gr. <?/; <?/, for <?/ <?/ the same + <?/ being, essence.]</ety> <def>Having the same essence; being identically of the same nature.</def> <mark>[R.]</mark>  <rj><au>Cudworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautophonical</ent><br/
<hw>Tau`to*phon"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to, or characterized by, tautophony; repeating the same sound.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautophony</ent><br/
<hw>Tau*toph"o*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/; <?/, for <?/ <?/ the same + <?/ voice.]</ety> <def>Repetition of the same sound.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tautozonal</ent><br/
<hw>Tau`to*zon"al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/; <?/, for <?/ <?/ the same + E. <ets>zonal</ets>.]</ety> <fld>(Crystallog.)</fld> <def>Belonging to the same zone; <as>as, <ex>tautozonal</ex> planes</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tavern</ent><br/
<hw>Tav"ern</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>taverne</ets>, F. <ets>taverne</ets>, from L. <ets>taberna</ets> a hut, booth, tavern.  Cf. <er>Table</er>, <er>Tabernacle</er>.]</ety> <def>A public house where travelers and other transient guests are accomodated with rooms and meals; an inn; a hotel; especially, in modern times, a public house licensed to sell liquor in small quantities.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taverner</ent><br/
<hw>Tav"ern*er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tavernier</ets>, L. <ets>tabernarius</ets>.]</ety> <def>One who keeps a tavern.</def>  <rj><au>Chaucer. Camden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taverning</ent><br/
<hw>Tav"ern*ing</hw>, <pos>n.</pos> <def>A feasting at taverns.</def> <mark>[Obs.]</mark> <ldquo/The misrule of our <xex>tavernings</xex>.<rdquo/  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tavernman</ent><br/
<hw>Tav"ern*man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tavernmen</plw> <pr>(<?/)</pr>.</plu> <def>The keeper of a tavern; also, a tippler.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taw</ent><br/
<hw>Taw</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Tow.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taw</ent><br/
<hw>Taw</hw>, <pos>v. t.</pos> <ety>[Cf. <er>Tew</er> to tow, <er>Tow</er>, <pos>v. t.</pos>]</ety> <def>To push; to tug; to tow.</def> <mark>[Obs.]</mark>  <rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taw</ent><br/
<hw>Taw</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tawed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tawing</conjf>.]</vmorph> <ety>[OE. <ets>tawen</ets>, <ets>tewen</ets>, AS. <ets>t<amac/wian</ets> to prepare; cf. D. <ets>touwen</ets>, Goth. <ets>t<emac/wa</ets> order, <ets>taujan</ets> to do, and E. <ets>tool</ets>. <root/64.  Cf. 1st <er>Tew</er>, <er>Tow</er> the coarse part of flax.]</ety> <sn>1.</sn> <def>To prepare or dress, as hemp, by beating; to tew; hence, to beat; to scourge.</def> <mark>[Obs.]</mark>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To dress and prepare, as the skins of sheep, lambs, goats, and kids, for gloves, and the like, by imbuing them with alum, salt, and other agents, for softening and bleaching them.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taw</ent><br/
<hw>Taw</hw>, <pos>n.</pos> <ety>[Cf. AS. <ets>t<amac/w</ets> instrument.]</ety> <sn>1.</sn> <def>A large marble to be played with; also, a game at marbles.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A line or mark from which the players begin a game of marbles.</def> <mark>[Colloq. U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tawdrily</ent><br/
<hw>Taw"dri*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a tawdry manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tawdriness</ent><br/
<hw>Taw"dri*ness</hw>, <pos>n.</pos> <def>Quality or state of being tawdry.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A clumsy person makes his ungracefulness more ungraceful by <qex>tawdriness</qex> of dress.</q> <rj><qau>Richardson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tawdry</ent><br/
<hw>Taw"dry</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Tawdrier</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Tawdriest</adjf>.]</amorph> <ety>[Said to be corrupted from <ets>Saint Audrey</ets>, or <ets>Auldrey</ets>, meaning <ets>Saint Ethelreda</ets>, implying therefore, originally, bought at the fair of St. Audrey, where laces and gay toys of all sorts were sold. This fair was held in Isle Ely, and probably at other places, on the day of the saint, which was the 17th of October.]</ety> <sn>1.</sn> <def>Bought at the festival of St. Audrey.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>And gird in your waist,<br/
For more fineness, with a <qex>tawdry</qex> lace.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Very fine and showy in colors, without taste or elegance; having an excess of showy ornaments without grace; cheap and gaudy; <as>as, a <ex>tawdry</ex> dress; <ex>tawdry</ex> feathers; <ex>tawdry</ex> colors.</as></def><-- tacky? --><br/
[<source>1913 Webster</source>]</p>

<p><q>He rails from morning to night at essenced fops and <qex>tawdry</qex> courtiers.</q> <rj><qau>Spectator.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tawdry</ent><br/
<hw>Taw"dry</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tawdries</plw> <pr>(<?/)</pr>.</plu> <def>A necklace of a rural fashion, bought at St. Audrey's fair; hence, a necklace in general.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Of which the Naiads and the blue Nereids make<br/
Them <qex>tawdries</qex> for their necks.</q> <rj><qau>Drayton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tawer</ent><br/
<hw>Taw"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who taws; a dresser of white leather.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tawery</ent><br/
<hw>Taw"er*y</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A place where skins are tawed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tawniness</ent><br/
<hw>Taw"ni*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being tawny.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tawny</ent><br/
<hw>Taw"ny</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Tawnier</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Tawniest</adjf>.]</amorph> <ety>[F. <ets>tann<eacute/</ets>, p. p. of <ets>tanner</ets> to tan. See <er>Tan</er>, <pos>v. t.</pos> & <pos>n.</pos>  Cf. <er>Tenn<eacute/</er>.]</ety> <def>Of a dull yellowish brown color, like things tanned, or persons who are sunburnt; <as>as, <ex>tawny</ex> Moor or Spaniard; the <ex>tawny</ex> lion</as>.</def> <ldquo/A leopard's <xex>tawny</xex> and spotted hide.<rdquo/  <rj><au>Longfellow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taws</ent><br/
<hw>Taws</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Taw</er> to beat.]</ety> <def>A leather lash, or other instrument of punishment, used by a schoolmaster.</def> <altsp>[Written also <asp>tawes</asp>, <asp>tawis</asp>, and <asp>tawse</asp>.]</altsp> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Never use the <qex>taws</qex> when a gloom can do the turn.</q> <rj><qau>Ramsay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tax</ent><br/
<hw>Tax</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>taxe</ets>, fr. <ets>taxer</ets> to tax, L. <ets>taxare</ets> to touch, sharply, to feel, handle, to censure, value, estimate, fr. <ets>tangere</ets>, <ets>tactum</ets>, to touch. See <er>Tangent</er>, and cf. <er>Task</er>, <er>Taste</er>.]</ety> <sn>1.</sn> <def>A charge, especially a pecuniary burden which is imposed by authority.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>A charge or burden laid upon persons or property for the support of a government.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A farmer of <qex>taxes</qex> is, of all creditors, proverbially the most rapacious.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>Especially, the sum laid upon specific things, as upon polls, lands, houses, income, etc.; <as>as, a land <ex>tax</ex>; a window <ex>tax</ex>; a <ex>tax</ex> on carriages, and the like</as>.</def> <note>Taxes are <stype>annual</stype> or <stype>perpetual</stype>, <stype>direct</stype> or <stype>indirect</stype>, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>A sum imposed or levied upon the members of a society to defray its expenses.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A task exacted from one who is under control; a contribution or service, the rendering of which is imposed upon a subject.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A disagreeable or burdensome duty or charge; <as>as, a heavy <ex>tax</ex> on time or health</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Charge; censure.</def> <mark>[Obs.]</mark>  <rj><au>Clarendon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A lesson to be learned; a task.</def> <mark>[Obs.]</mark>  <rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tax cart</b></col>, <cd>a spring cart subject to a low tax.</cd> <mark>[Eng.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Impost; tribute; contribution; duty; toll; rate; assessment; exaction; custom; demand.</syn><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1478 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tax</ent><br/
<hw>Tax</hw> <pr>(t<acr/ks)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Taxed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Taxing</conjf>.]</vmorph> <ety>[Cf. F. <ets>taxer</ets>. See <er>Tax</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To subject to the payment of a tax or taxes; to impose a tax upon; to lay a burden upon; especially, to exact money from for the support of government.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We are more heavily <qex>taxed</qex> by our idleness, pride, and folly than we are <qex>taxed</qex> by government.</q> <rj><qau>Franklin.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>To assess, fix, or determine judicially, the amount of; <as>as, to <ex>tax</ex> the cost of an action in court</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To charge; to accuse; also, to censure; -- often followed by <xex>with</xex>, rarely by <xex>of</xex> before an indirect object; <as>as, to <ex>tax</ex> a man with pride</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I <qex>tax</qex> you, you elements, with unkindness.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Men's virtues I have commended as freely as I have <qex>taxed</qex> their crimes.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Fear not now that men should <qex>tax</qex> thine honor.</q> <rj><qau>M. Arnold.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxability</ent><br/
<hw>Tax`a*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being taxable; taxableness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxable</ent><br/
<hw>Tax"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Capable of being taxed; liable by law to the assessment of taxes; <as>as, <ex>taxable</ex> estate; <ex>taxable</ex> commodities</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>That may be legally charged by a court against the plaintiff of defendant in a suit; <as>as, <ex>taxable</ex> costs</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Tax"a*ble*ness</wf>, <pos>n.</pos> -- <wf>Tax"a*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxaspidean</ent><br/
<hw>Tax`as*pid"e*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/ an arrangement + <?/, <?/, shield.]</ety> <fld>(Zool.)</fld> <def>Having the posterior tarsal scales, or scutella, rectangular and arranged in regular rows; -- said of certain birds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxation</ent><br/
<hw>Tax*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>taxation</ets>, L. <ets>taxatio</ets> a valuing, estimation, from L. <ets>taxare</ets>. See <er>Tax</er>.]</ety> <sn>1.</sn> <def>The act of laying a tax, or of imposing taxes, as on the subjects of a state, by government, or on the members of a corporation or company, by the proper authority; the raising of revenue; also, a system of raising revenue.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>The act of taxing, or assessing a bill of cost.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Tax; sum imposed.</def> <mark>[R.]</mark>  <rj><au>Daniel.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Charge; accusation.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tax certificate</ent><br/
<hw>Tax certificate</hw>. <fld>(Law)</fld> <def>The certificate issued to the purchaser of land at a tax sale certifying to the sale and the payment of the consideration thereof, and entitling the purchaser upon certain conditions and at a certain time thereafter to a deed or instrument of conveyance (called a <xex>tax deed</xex>) of the land, to be executed by the proper officer.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Taxel</ent><br/
<hw>Tax"el</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The American badger.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxeopoda</ent><br/
\'d8<hw>Tax`e*op"o*da</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <?/ (?) + <ets>-poda</ets>.]</ety> <fld>(Paleon.)</fld> <def>An order of extinct Mammalia found in the Tertiary formations.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxer</ent><br/
<hw>Tax"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who taxes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of two officers chosen yearly to regulate the assize of bread, and to see the true gauge of weights and measures is observed.</def> <mark>[Camb. Univ., Eng.]</mark> <altsp>[Written also <asp>taxor</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxgatherer</ent><br/
<hw>Tax"gath`er*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who collects taxes or revenues.</def> -- <wordforms><wf>Tax"gath`er*ing</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxiarch</ent><br/
<hw>Tax"i*arch</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ and <?/; <?/ a division of an army, a brigade (from <?/ to arrange, array) + to rule.]</ety> <fld>(Gr. Antiq.)</fld> <def>An Athenian military officer commanding a certain division of an army.</def>  <rj><au>Milford.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxicorn</ent><br/
<hw>Tax"i*corn</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>taxus</ets> a yew + <ets>cornu</ets> a horn: cf. F. <ets>taxicorne</ets>.]</ety> <fld>(Zool.)</fld> <def>One of a family of beetles (<fam>Taxicornes</fam>) whose antennae are largest at the tip. Also used adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxidermic</ent><br/
<hw>Tax`i*der"mic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>taxidermique</ets>.]</ety> <def>Of or pertaining to the art of preparing and preserving the skins of animals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxidermist</ent><br/
<hw>Tax"i*der`mist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A person skilled in taxidermy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxidermy</ent><br/
<hw>Tax"i*der`my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ an arranging, arrangement (fr. <?/ to arrange) + <?/ a skin, from <?/ to skin: cf. F. <ets>taxidermie</ets>. See <er>Tactics</er>, <er>Tear</er>, <pos>v. t.</pos>]</ety> <def>The art of preparing, preserving, and mounting the skins of animals so as to represent their natural appearance, as for cabinets.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>taximeter</ent><br/
<hw>taximeter</hw> <pos>n.</pos> <sn>1.</sn> <def>a meter in a taxi that registers the fare (based on the length of the ride).</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Taxine</ent><br/
<hw>Tax"ine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>taxus</ets> a yew.]</ety> <fld>(Chem.)</fld> <def>A poisonous alkaloid of bitter taste extracted from the leaves and seeds of the European yew (<spn>Taxus baccata</spn>).  Called also <altname>taxia</altname>.  The usual preparation is a mixture of compounds.  Taxine A has the chemical formula: <chform>C35H47NO10</chform>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Taxis</ent><br/
\'d8<hw>Tax"is</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>ta`xis</grk> a division or arrangement, fr. <grk>ta`ssein</grk> to arrange.]</ety> <sn>1.</sn> <fld>(Surg.)</fld> <def>Manipulation applied to a hernial tumor, or to an intestinal obstruction, for the purpose of reducing it.</def>  <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In technical uses, as in architecture, biology, grammar, etc., arrangement; order; ordonnance.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn> <def>a reflexive movement by a motile organism by which it moves or orients itself in relation to some source of stimulation; <as>as, chemo<ex>taxis</ex>, the motion toward or away from gradients of certain chemical compounds</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>-taxis</ent><br/
<hw>-tax"is</hw> <pr>(?)</pr>, <pos>n.</pos> <def>combining form for <er>taxis{3}</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>taxi</ent><br/
<hw>tax"i</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>same as <er>taxicab</er>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>any vehicle that carries passengers for a fare, as a water <ex>taxi</ex>.</def><br/
[<source>PJC</source>]</p>

<p><ent>taxicab</ent><br/
<hw>tax"i*cab</hw> <pr>(?)</pr>, <pos>n.</pos> <def>an automobile with a professional driver which can be hired to carry passengers; -- also called a <altname>taxi</altname>, and informally called a <altname>cab</altname> or a <altname>hack</altname>.  The driver of a taxicab is referred to as a <er>cab driver</er> or <er>cabbie</er>, and sometimes as a <er>chauffeur</er> or <er>hackie</er>.</def> <note>Taxicabs may be engaged by a prior appointment made, e.g. by telephone, or they may <perf>cruise</perf> for passengers, i.e. they may drive in city streets and stop to <perf>pick up pasengers</perf> when they are signalled by a prospective passenger.  The act of signalling a taxicab (usually by a wave of the arm) is often called <col><b>to hail a cab</b></col> or <col><b>to flag down a cab</b></col>.</note><br/
[<source>PJC</source>]</p>

<p><ent>Taxless</ent><br/
<hw>Tax"less</hw>, <pos>a.</pos> <def>Free from taxation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxology</ent><br/
<hw>Tax*ol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>ta`xis</grk> arrangement + <ets>-logy</ets>.]</ety> <fld>(Biol.)</fld> <def>Same as <er>Taxonomy</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxon</ent><br/
<hw>Tax"on</hw> <pr>(t<acr/ks"<ocr/n)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>taxa</plw> or <plw>taxons</plw>.</plu> <def>a taxonomic group, or the name of a taxonomic grouping.</def><br/
[<source>PJC</source>]</p>

<p><ent>Taxonomic</ent><br/
<hw>Tax`o*nom"ic</hw> <pr>(t<acr/ks`<ocr/*n<ocr/m"<icr/k)</pr>, <pos>a.</pos> <def>Pertaining to, or involving, taxonomy, or the laws and principles of classification; classificatory.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxonomist</ent><br/
<hw>Tax*on"o*mist</hw> <pr>(t<acr/ks*<ocr/n"<osl/*m<icr/st)</pr>, <pos>n.</pos> <def>One skilled in taxonomy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxonomy</ent><br/
<hw>Tax*on"o*my</hw> <pr>(t<acr/ks*<ocr/n"<osl/*m<ycr/)</pr>, <pos>n.</pos> <ety>[Gr. <grk>ta`xis</grk> an arrangement, order + <grk>no`mos</grk> a law.]</ety> <sn>1.</sn> <def>That division of the natural sciences which treats of the classification of animals and plants, primarily by consideration of their natural relationships with respect to their structure or genetic origin; the laws or principles of classification; systematics.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>A systematic arrangement of objects or concepts showing the relations between them, especially one including a hierarchical arrangement of types in which categories of objects are classified as subtypes of more abstract categories, starting from one or a small number of top categories, and descending to more specific types through an arbitrary number of levels.  An <partof><er>ontology</er></partof> usually contains a <ex>taxonomy</ex> as one of the important principles of organization.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Taxor</ent><br/
<hw>Tax"or</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety> <def>Same as <er>Taxer</er>, <pos>n.</pos>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taxpayer</ent><br/
<hw>Tax"pay`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who is assessed and pays a tax.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Taylor-White process</ent><br/
<hw>Tay"lor-White" proc`ess</hw>. <fld>(Metal.)</fld> <def>A process (invented about 1899 by <person>Frederick W. Taylor</person> and <person>Maunsel B. White</person>) for giving toughness to self-hardening steels. The steel is heated almost to fusion, cooled to a temperature of from 700<deg/ to 850<deg/ C. in molten lead, further cooled in oil, reheated to between 370<deg/ and 670<deg/ C., and cooled in air.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tayra</ent><br/
<hw>Tay"ra</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native name.]</ety> <fld>(Zool.)</fld> <def>A South American carnivore (<spn>Galera barbara</spn>) allied to the grison. The tail is long and thick. The length, including the tail, is about three feet.</def> <altsp>[Written also <asp>taira</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tay-Sachs Disease</ent><br/
<hw>Tay"-Sachs Disease</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Med.)</fld> <def>A rare hereditary disease affecting lipid metabolism in humans, due to a deficiency of hexosaminidase.  It occurs in infants and children, and causes death before the onset of adulthood.  It occurs most commonly of people of Jewish origin from easter Europe.  It is characterized by accumulation of lipids in nervous tissue, causes a red spot on the retina, and eventual blindness and paralysis before death.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tazel</ent><br/
<hw>Ta"zel</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The teasel.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tazza</ent><br/
\'d8<hw>Taz"za</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It.]</ety> <def>An ornamental cup or vase with a large, flat, shallow bowl, resting on a pedestal and often having handles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>T cart</ent><br/
<hw>T" cart`</hw> <pr>(?)</pr>. <def>See under <er>T</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>T cell</ent><br/
<hw>T" cell`</hw> <pr>(t<emac/"s<ecr/l`)</pr> <ety>[From <ets>T</ets>hymus, the site of maturation of T-cells.]</ety> <def>A type of white blood cell that circulates in the blood and lymph, and provides cell-mediated immunity for the organism, protecting against infecting cells or the body's own malignant cells; also called <altname>T lymphocyte</altname>.  There are several types of T cells.  They develop, as do B cells, from progenitor cells in the bone marrow, but are distinguished from B-cells (B-lymphocytes) by their site of differentiation; T-cells mature in the thymus and B-cells in the bone marrow (in birds in the Bursa of Fabricius).  They also have different antigen receptors from those of B-cells. T-cells differentiate into cells that can directly kill infecting cells (cell-mediated immunity, cytotoxity) or activate other cells of the immune system (helper T cells), whereas B-cells differentiate on activation into antibody-secreting plasma cells.   Helper T cells interact with B-cells by secreting lymphokines that stimulate the B cell which have detected a foreign antigen to enter the cell cycle and develop, by repeated mitosis, into a clone of cells with identical receptors, and then to secrete antibodies to that specific antigen.</def><br/
[<source>PJC</source>]</p>

<p><ent>Tchawytcha</ent><br/
\'d8<hw>Tcha*wy"tcha</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The quinnat salmon.</def> <mark>[Local, U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tchick</ent><br/
<hw>Tchick</hw> <pr>(ch<icr/k)</pr>, <pos>n.</pos> <ety>[Imitative.]</ety> <def>A slight sound such as that made by pressing the tongue against the roof of the mouth and explosively sucking out the air at one side, as in urging on a horse.</def> -- <def2><pos>v. i.</pos> <def>To make a tchick.</def></def2><-- = cluck? click? --><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>tchotchke</ent><br/
<hw>tchotch"ke</hw> <pos>n.</pos> <sn>1.</sn> <ety>[Yiddish <ets>tshatshke</ets>, trinket, from Pol. <ets>czaczko</ets>. <au>MW10.</au>]</ety> <def>a knickknack or trinket; a decorative item or souvenir of little value.</def> <altsp>[Also spelled <asp>chotchke</asp>.]</altsp><br/
[<source>PJC</source>]</p>

<p><ent>T connection</ent><br/
<hw>T connection</hw>. <fld>(Elec.)</fld> <def>The connection of two coils diagrammatically as a letter <universbold>T</universbold>, chiefly used as a connection for passing transformers. When the three free ends are connected to a source of three-phase current, two-phase current may be derived from the secondary circuits. The reverse arrangement may be used to transform from two-phase.</def> -- <wordforms><wf>T"-connected</wf>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tea</ent><br/
<hw>Tea</hw> <pr>(t<emac/)</pr>, <pos>n.</pos> <ety>[Chin. <ets>tsh<amac/</ets>, Prov. Chin. <ets>te</ets>: cf. F. <ets>th<eacute/</ets>.]</ety> <sn>1.</sn> <def>The prepared leaves of a shrub, or small tree (<spn>Thea Chinensis</spn> <it>or</it>  <spn>Camellia Chinensis</spn>). The shrub is a native of China, but has been introduced to some extent into some other countries.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Teas</xex> are classed as <xex>green</xex> or <xex>black</xex>, according to their color or appearance, the kinds being distinguished also by various other characteristic differences, as of taste, odor, and the like. The color, flavor, and quality are dependent upon the treatment which the leaves receive after being gathered. The leaves for green tea are heated, or roasted slightly, in shallow pans over a wood fire, almost immediately after being gathered, after which they are rolled with the hands upon a table, to free them from a portion of their moisture, and to twist them, and are then quickly dried. Those intended for black tea are spread out in the air for some time after being gathered, and then tossed about with the hands until they become soft and flaccid, when they are roasted for a few minutes, and rolled, and having then been exposed to the air for a few hours in a soft and moist state, are finally dried slowly over a charcoal fire. The operation of roasting and rolling is sometimes repeated several times, until the leaves have become of the proper color. The principal sorts of green tea are Twankay, the poorest kind; Hyson skin, the refuse of Hyson; Hyson, Imperial, and Gunpowder, fine varieties; and Young Hyson, a choice kind made from young leaves gathered early in the spring. Those of black tea are Bohea, the poorest kind; Congou; Oolong; Souchong, one of the finest varieties; and Pekoe, a fine-flavored kind, made chiefly from young spring buds. See <er>Bohea</er>, <er>Congou</er>, <cref>Gunpowder tea</cref>, under <er>Gunpowder</er>, <er>Hyson</er>, <er>Oolong</er>, and <er>Souchong</er>.</note>  <rj><au>K. Johnson.</au>  <au>Tomlinson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ldquo/No knowledge of . . . [tea] appears to have reached Europe till after the establishment of intercourse between Portugal and China in 1517. The Portuguese, however, did little towards the introduction of the herb into Europe, and it was not till the Dutch established themselves at Bantam early in 17th century, that these adventurers learned from the Chinese the habit of tea drinking, and brought it to Europe.<rdquo/</note>  <rj><au>Encyc. Brit.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A decoction or infusion of tea leaves in boiling water; <as>as, <ex>tea</ex> is a common beverage</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any infusion or decoction, especially when made of the dried leaves of plants; <as>as, sage <ex>tea</ex>; chamomile <ex>tea</ex>; catnip <ex>tea</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The evening meal, at which tea is usually served; supper.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Arabian tea</b></col>, <cd>the leaves of <spn>Catha edulis</spn>; also <fld>(Bot.)</fld>, the plant itself. See <er>Kat</er>.</cd> -- <col><b>Assam tea</b></col>, <cd>tea grown in Assam, in India, originally brought there from China about the year 1850.</cd> -- <mcol><col><b>Australian tea</b></col>, <it>or</it> <col><b>Botany Bay tea</b></col></mcol> <fld>(Bot.)</fld>, <cd>a woody climbing plant (<spn>Smilax glycyphylla</spn>).</cd> -- <col><b>Brazilian tea</b></col>. <sd>(a)</sd> <cd>The dried leaves of <spn>Lantana pseodothea</spn>, used in Brazil as a substitute for tea.</cd> <sd>(b)</sd> <cd>The dried leaves of <spn>Stachytarpheta mutabilis</spn>, used for adulterating tea, and also, in <country>Austria</country>, for preparing a beverage.</cd> -- <col><b>Labrador tea</b></col>. <fld>(Bot.)</fld> <cd>See under <er>Labrador</er>.</cd> -- <col><b>New Jersey tea</b></col> <fld>(Bot.)</fld>, <cd>an American shrub, the leaves of which were formerly used as a substitute for tea; redroot. See <er>Redroot</er>.</cd> -- <col><b>New Zealand tea</b></col>. <fld>(Bot.)</fld> <cd>See under <er>New Zealand</er>.</cd> -- <col><b>Oswego tea</b></col>. <fld>(Bot.)</fld> <cd>See <er>Oswego tea</er>.</cd> -- <col><b>Paraguay tea</b></col>, <cd>mate. See 1st <er>Mate</er>.</cd> -- <col><b>Tea board</b></col>, <cd>a board or tray for holding a tea set.</cd> -- <col><b>Tea bug</b></col> <fld>(Zool.)</fld>, <cd>an hemipterous insect which injures the tea plant by sucking the juice of the tender leaves.</cd> -- <col><b>Tea caddy</b></col>, <cd>a small box for holding tea.</cd> -- <col><b>Tea chest</b></col>, <cd>a small, square wooden case, usually lined with sheet lead or tin, in which tea is imported from China.</cd> -- <col><b>Tea clam</b></col> <fld>(Zool.)</fld>, <cd>a small quahaug.</cd> <mark>[Local, U. S.]</mark> -- <col><b>Tea garden</b></col>, <cd>a public garden where tea and other refreshments are served.</cd> -- <col><b>Tea plant</b></col> <fld>(Bot.)</fld>, <cd>any plant, the leaves of which are used in making a beverage by infusion; specifically, <spn>Thea Chinensis</spn>, from which the tea of commerce is obtained.</cd> -- <col><b>Tea rose</b></col> <fld>(Bot.)</fld>, <cd>a delicate and graceful variety of the rose (<spn>Rosa Indica</spn>, var. <varn>odorata</varn>), introduced from China, and so named from its scent. Many varieties are now cultivated.</cd> -- <col><b>Tea service</b></col>, <cd>the appurtenances or utensils required for a tea table, -- when of silver, usually comprising only the teapot, milk pitcher, and sugar dish.</cd> -- <col><b>Tea set</b></col>, <cd>a tea service.</cd> -- <col><b>Tea table</b></col>, <cd>a table on which tea furniture is set, or at which tea is drunk.</cd> -- <col><b>Tea taster</b></col>, <cd>one who tests or ascertains the quality of tea by tasting.</cd> -- <col><b>Tea tree</b></col> <fld>(Bot.)</fld>, <cd>the tea plant of China. See <spn>Tea plant</spn>, above.</cd><-- In Australia and New Zealand, tea tree refers to a tree or tall shrib, Leptospermum scoparium, having white bell-shaped flowers.  The leaves are used to prepare an infusion; an oil, tea tree oil, is also derived, and claimed to have therapeutic properties, as for healing burns of the skin. --> -- <col><b>Tea urn</b></col>, <cd>a vessel generally in the form of an urn or vase, for supplying hot water for steeping, or infusing, tea.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tea</ent><br/
<hw>Tea</hw>, <pos>v. i.</pos> <def>To take or drink tea.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teaberry</ent><br/
<hw>Tea"ber`ry</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The checkerberry.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teach</ent><br/
<hw>Teach</hw> <pr>(t<emac/ch)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Taught</conjf> <pr>(t<add/t)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Teaching</conjf>.]</vmorph> <ety>[OE. <ets>techen</ets>, imp. <ets>taughte</ets>, <ets>tahte</ets>, AS. <ets>t<aemac/cean</ets>, imp. <ets>t<aemac/hte</ets>, to show, teach, akin to <ets>t<amac/cn</ets> token. See <er>Token</er>.]</ety> <sn>1.</sn> <def>To impart the knowledge of; to give intelligence concerning; to impart, as knowledge before unknown, or rules for practice; to inculcate as true or important; to exhibit impressively; <as>as, to <ex>teach</ex> arithmetic, dancing, music, or the like; to <ex>teach</ex> morals.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>If some men <qex>teach</qex> wicked things, it must be that others should practice them.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To direct, as an instructor; to manage, as a preceptor; to guide the studies of; to instruct; to inform; to conduct through a course of studies; <as>as, to <ex>teach</ex> a child or a class</as>.</def> <ldquo/He <xex>taught</xex> his disciples.<rdquo/  <rj><au>Mark ix. 31.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The village master <qex>taught</qex> his little school.</q> <rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To accustom; to guide; to show; to admonish.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I shall myself to herbs <qex>teach</qex> you.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They have <qex>taught</qex> their tongue to speak lies.</q> <rj><qau>Jer. ix. 5.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This verb is often used with two objects, one of the person, the other of the thing; <as>as, he <ex>taught</ex> me Latin grammar</as>. In the passive construction, either of these objects may be retained in the objective case, while the other becomes the subject; <as>as, I was <ex>taught</ex> Latin grammar by him; Latin grammar was <ex>taught</ex> me by him</as>.</note><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To instruct; inform; inculcate; tell; guide; counsel; admonish. See the Note under <er>Learn</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teach</ent><br/
<hw>Teach</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To give instruction; to follow the business, or to perform the duties, of a preceptor.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And gladly would he learn, and gladly <qex>teach</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The priests thereof <qex>teach</qex> for hire.</q> <rj><qau>Micah iii. 11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teachable</ent><br/
<hw>Teach"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being taught; apt to learn; also, willing to receive instruction; docile.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We ought to bring our minds free, unbiased, and <qex>teachable</qex>, to learn our religion from the Word of God.</q> <rj><qau>I. Watts.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teachableness</ent><br/
<hw>Teach"a*ble*ness</hw>, <pos>n.</pos> <def>Willingness to be taught.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teache</ent><br/
<hw>Teache</hw> <pr>(t<emac/ch)</pr>, <pos>n.</pos> <ety>[Cf. Amer. Sp. <ets>tacha</ets>, <ets>tacho</ets>.]</ety> <fld>(Sugar Manuf.)</fld> <def>Any one of the series of boilers or evaporating pans in which the cane juice is concentrated in making sugar; especially, the last boiler of the series.</def>  <rj><au>Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note>The 1890 edition had the following etymology for <ex>teache</ex>: <ety>[Cf. Ir. <ets>teaghaim</ets>, Gael. <ets>teasaich</ets>, to heat.]</ety>.  Presumably a speculation which proved incorrect?</note></p>

<p><ent>Teacher</ent><br/
<hw>Teach"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who teaches or instructs; one whose business or occupation is to instruct others; an instructor; a tutor.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who instructs others in religion; a preacher; a minister of the gospel; sometimes, one who preaches without regular ordination.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>teachers</qex> in all the churches assembled.</q> <rj><qau>Sir W. Raleigh.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teaching</ent><br/
<hw>Teach"ing</hw>, <pos>n.</pos> <def>The act or business of instructing; also, that which is taught; instruction.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Education; instruction; breeding. See <er>Education</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teachless</ent><br/
<hw>Teach"less</hw>, <pos>a.</pos> <def>Not teachable.</def> <mark>[R.]</mark>  <rj><au>Shelley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teacup</ent><br/
<hw>Tea"cup`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A small cup from which to drink tea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teacupful</ent><br/
<hw>Tea"cup`ful</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Teacupfuls</plw> <pr>(<?/)</pr>.</plu> <def>As much as a teacup can hold; enough to fill a teacup.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teade</ent><br/
<ent>Tead</ent><br/
<mhw>{ <hw>Tead</hw>, <hw>Teade</hw>  }</mhw> <pr>(t<emac/d)</pr>, <pos>n.</pos> <ety>[L. <ets>taeda</ets>, <ets>teda</ets>.]</ety> <def>A torch.</def> <mark>[Obs.]</mark> <ldquo/A burning <xex>teade</xex>.<rdquo/  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teagle</ent><br/
<hw>Tea"gle</hw> <pr>(t<emac/"g'l)</pr>, <pos>n.</pos> <ety>[Cf. <er>Tackle</er>.]</ety> <def>A hoisting apparatus; an elevator; a crane; a lift.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teague</ent><br/
<hw>Teague</hw> <pr>(t<emac/g)</pr>, <pos>n.</pos> <ety>[Cf. W. <ets>taeog</ets>, <ets>taeawg</ets>, <ets>taiawg</ets>, adj., rustic, rude, n., a vassal, villain, peasant, clown, Ir. <ets>thuatach</ets> rural, boorish.]</ety> <def>An Irishman; -- a term used in contempt.</def>  <rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teak</ent><br/
<hw>Teak</hw> <pr>(t<emac/k)</pr>, <pos>n.</pos> <ety>[Malayalam <ets>tekku</ets>.]</ety> <fld>(Bot.)</fld> <def>A tree of East Indies (<spn>Tectona grandis</spn>) which furnishes an extremely strong and durable timber highly valued for shipbuilding and other purposes; also, the timber of the tree.</def> <altsp>[Written also <asp>teek</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>African teak</b></col>, <cd>a tree (<spn>Oldfieldia Africana</spn>) of Sierra Leone; also, its very heavy and durable wood; -- called also <altname>African oak</altname>.</cd> -- <col><b>New Zeland teak</b></col>, <cd>a large tree (<spn>Vitex littoralis</spn>) of New Zeland; also, its hard, durable timber.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teakettle</ent><br/
<hw>Tea"ket`tle</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kettle in which water is boiled for making tea, coffee, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teal</ent><br/
<hw>Teal</hw> <pr>(t<emac/l)</pr>, <pos>n.</pos> <ety>[OE. <ets>tele</ets>; akin to D. <ets>teling</ets> a generation, production, teal, <ets>telen</ets> to breed, produce, and E. <ets>till</ets> to cultivate. The English word probably once meant, a brood or flock. See <er>Till</er> to cultivate.]</ety> <fld>(Zool.)</fld> <def>Any one of several species of small fresh-water ducks of the genus <gen>Anas</gen> and the subgenera <gen>Querquedula</gen> and <gen>Nettion</gen>. The male is handsomely colored, and has a bright green or blue speculum on the wings.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The common European teal (<spn>Anas crecca</spn>) and the European blue-winged teal, or garganey (<spn>Anas querquedula</spn> or <spn>Anas circia</spn>), are well-known species. In America the blue-winged teal (<spn>Anas discors</spn>), the green-winged teal (<spn>Anas Carolinensis</spn>), and the cinnamon teal (<spn>Anas cyanoptera</spn>) are common species, valued as game birds. See <er>Garganey</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Goose teal</b></col>, <cd>a goslet. See <er>Goslet</er>.</cd> -- <col><b>Teal duck</b></col>, <cd>the common European teal.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Team</ent><br/
<hw>Team</hw> <pr>(t<emac/m)</pr>, <pos>n.</pos> <ety>[OE. <ets>tem</ets>, <ets>team</ets>, AS. <ets>te<aacute/m</ets>, offspring, progeny, race of descendants, family; akin to D. <ets>toom</ets> a bridle, LG. <ets>toom</ets> progeny, team, bridle, G. <ets>zaum</ets> a bridle, <ets>zeugen</ets> to beget, Icel. <ets>taumr</ets> a rein, bridle, Dan. <ets>t<oum/mme</ets>, Sw. <ets>t<oum/m</ets>, and also to E. <ets>tow</ets> to drag, <ets>tug</ets> to draw.  <root/64.  See <er>Tug</er>, and cf. <er>Teem</er> to bear.]</ety> <sn>1.</sn> <def>A group of young animals, especially of young ducks; a brood; a litter.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>team</qex> of ducklings about her.</q> <rj><qau>Holland.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, a number of animals moving together.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A long <qex>team</qex> of snowy swans on high.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Two or more horses, oxen, or other beasts harnessed to the same vehicle for drawing, as to a coach, wagon, sled, or the like.</def> <ldquo/A <xex>team</xex> of dolphins.<rdquo/  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To take his <qex>team</qex> and till the earth.</q> <rj><qau>Piers Plowman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It happened almost every day that coaches stuck fast, until a <qex>team</qex> of cattle could be procured from some neighboring farm to tug them out of the slough.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A number of persons associated together in any work; a gang; especially, a number of persons selected to contend on one side in a match, or a series of matches, in a cricket, football, rowing, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Zool.)</fld> <def>A flock of wild ducks.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(O. Eng. Law)</fld> <def>A royalty or privilege granted by royal charter to a lord of a manor, of having, keeping, and judging in his court, his bondmen, neifes, and villains, and their offspring, or suit, that is, goods and chattels, and appurtenances thereto.</def>  <rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1479 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Team</ent><br/
<hw>Team</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To engage in the occupation of driving a team of horses, cattle, or the like, as in conveying or hauling lumber, goods, etc.; to be a teamster.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- <col><b>team up</b></col>, <cd>to form one or more teams, either for a common endeavor, or to compete in a contest.</cd> --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Team</ent><br/
<hw>Team</hw>, <pos>v. t.</pos> <def>To convey or haul with a team; <as>as, to <ex>team</ex> lumber</as>.</def> <mark>[R.]</mark>  <rj><au>Thoreau.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teamed</ent><br/
<hw>Teamed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Yoked in, or as in, a team.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Let their <qex>teamed</qex> fishes softly swim.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teaming</ent><br/
<hw>Team"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act or occupation of driving a team, or of hauling or carrying, as logs, goods, or the like, with a team.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Manuf.)</fld> <def>Contract work.</def> <mark>[R.]</mark>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teamster</ent><br/
<hw>Team"ster</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who drives a team.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teamwork</ent><br/
<hw>Team"work`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>Work done by a team, as distinguished from that done by personal labor.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Work done by a number of associates, usually each doing a clearly defined portion, but all subordinating personal prominence to the efficiency of the whole; <as>as, the <ex>teamwork</ex> of a football eleven or a gun crew</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>Is the <qex>teamwork</qex> system employed, or does one workman make the whole cigar?</q>  <rj><qau>U. S. Consular Repts.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Teapot</ent><br/
<hw>Tea"pot`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A vessel with a spout, in which tea is made, and from which it is poured into teacups.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teapoy</ent><br/
<hw>Tea"poy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Hind. <ets>tip<amac/i</ets>; Hind. <ets>tin</ets> there + Per. <ets>p<amac/e</ets> foot.]</ety> <def>An ornamental stand, usually with three legs, having caddies for holding tea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tear</ent><br/
<hw>Tear</hw> <pr>(t<emac/r)</pr>, <pos>n.</pos> <ety>[AS. <ets>te<aacute/r</ets>; akin to G. <ets>z<aum/rhe</ets>, OHG. <ets>zahar</ets>, OFries. & Icel. <ets>t<amac/r</ets>, Sw. <ets>t<aring/r</ets>, Dan. <ets>taare</ets>, Goth. <ets>tagr</ets>, OIr. <ets>d<emac/r</ets>, W. <ets>dagr</ets>, OW. <ets>dacr</ets>, L. <ets>lacrima</ets>, <ets>lacruma</ets>, for older <ets>dacruma</ets>, Gr. <grk>da`kry</grk>, <grk>da`kryon</grk>, <grk>da`kryma</grk>. <root/59.  Cf. <er>Lachrymose</er>.]</ety> <sn>1.</sn> <fld>(Physiol.)</fld> <def>A drop of the limpid, saline fluid secreted, normally in small amount, by the lachrymal gland, and diffused between the eye and the eyelids to moisten the parts and facilitate their motion. Ordinarily the secretion passes through the lachrymal duct into the nose, but when it is increased by emotion or other causes, it overflows the lids.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And yet for thee ne wept she never a <qex>tear</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Something in the form of a transparent drop of fluid matter; also, a solid, transparent, tear-shaped drop, as of some balsams or resins.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let Araby extol her happy coast,<br/
Her fragrant flowers, her trees with precious <qex>tears</qex>.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which causes or accompanies tears; a lament; a dirge.</def> <mark>[R.]</mark> <ldquo/Some melodous <xex>tear</xex>.<rdquo/  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Glass Manuf.)</fld> <def>A partially vitrified bit of clay in glass.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><note><hand/ <xex>Tear</xex> is sometimes used in the formation of self-explaining compounds; as, <xex>tear</xex>-distilling, <xex>tear</xex>-drop, <xex>tear</xex>-filled, <xex>tear</xex>-stained, and the like.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tears of St. Lawrence</b></col>, <cd>the Perseid shower of meteors, seen every year on or about the eve of <person>St. Lawrence</person>, August 9th.</cd> -- <col><b>Tears of wine</b></col>, <cd>drops which form and roll down a glass above the surface of strong wine. The phenomenon is due to the evaporation of alcohol from the surface layer, which, becoming more watery, increases in surface tension and creeps up the sides until its weight causes it to break.</cd></cs><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tear</ent><br/
<hw>Tear</hw> <pr>(t<acir/r)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.</pos> <conjf>Tore</conjf> <pr>(t<omac/r)</pr>, ((<mark>Obs.</mark> <conjf>Tare</conjf>) <pr>(t<acir/r)</pr>; <pos>p. p.</pos> <conjf>Torn</conjf> <pr>(t<omac/rn)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tearing</conjf>.]</vmorph> <ety>[OE. <ets>teren</ets>, AS. <ets>teran</ets>; akin to OS. far<ets>terian</ets> to destroy, D. <ets>teren</ets> to consume, G. <ets>zerren</ets> to pull, to tear, <ets>zehren</ets> to consume, Icel. <ets>t>ae/ra</ets>, Goth. <ets>gata<iacute/ran</ets> to destroy, Lith. <ets>dirti</ets> to flay, Russ. <ets>drate</ets> to pull, to tear, Gr. <grk>de`rein</grk> to flay, Skr. <ets>dar</ets> to burst. <root/63.  Cf. <er>Darn</er>, <er>Epidermis</er>, <er>Tarre</er>, <er>Tirade</er>.]</ety> <sn>1.</sn> <def>To separate by violence; to pull apart by force; to rend; to lacerate; <as>as, to <ex>tear</ex> cloth; to <ex>tear</ex> a garment; to <ex>tear</ex> the skin or flesh.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tear</qex> him to pieces; he's a conspirator.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, to divide by violent measures; to disrupt; to rend; <as>as, a party or government <ex>torn</ex> by factions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To rend away; to force away; to remove by force; to sunder; <as>as, a child <ex>torn</ex> from its home</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The hand of fate<br/
Hath <qex>torn</qex> thee from me.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To pull with violence; <as>as, to <ex>tear</ex> the hair</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To move violently; to agitate.</def> <ldquo/Once I loved <xex>torn</xex> ocean's roar.<rdquo/  <rj><au>Byron.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To tear a cat</b></col>, <cd>to rant violently; to rave; -- especially applied to theatrical ranting.</cd> <mark>[Obs.]</mark> <au>Shak.</au> -- <col><b>To tear down</b></col>, <cd>to demolish violently; to pull or pluck down.</cd> -- <col><b>To tear off</b></col>, <cd>to pull off by violence; to strip.</cd> -- <col><b>To tear out</b></col>, <cd>to pull or draw out by violence; <as>as, <ex>to tear out</ex> the eyes</as>.</cd> -- <col><b>To tear up</b></col>, <cd>to rip up; to remove from a fixed state by violence; <as>as, <ex>to tear up</ex> a floor; <ex>to tear up</ex> the foundation of government or order</as>.</cd></cs><-- tear sheet, (a) a sheet usu. with performations, intended to be torn from a book or booklet to be used for some purpose. (b) any sheet torn from a publication. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tear</ent><br/
<hw>Tear</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To divide or separate on being pulled; to be rent; <as>as, this cloth <ex>tears</ex> easily</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To move and act with turbulent violence; to rush with violence; hence, to rage; to rave.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tear</ent><br/
<hw>Tear</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of tearing, or the state of being torn; a rent; a fissure.</def>  <rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Wear and tear</b></col>. <cd>See under <er>Wear</er>, <pos>n.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tearer</ent><br/
<hw>Tear"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who tears or rends anything; also, one who rages or raves with violence.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tear-falling</ent><br/
<hw>Tear"-fall`ing</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Shedding tears; tender.</def> <mark>[Poetic]</mark> <ldquo/<xex>Tear-falling</xex> pity.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tearful</ent><br/
<hw>Tear"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Abounding with tears; weeping; shedding tears; <as>as, <ex>tearful</ex> eyes</as>.</def> -- <wordforms><wf>Tear"ful*ly</wf>, <pos>adv.</pos> -- <wf>Tear"ful*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tearless</ent><br/
<hw>Tear"less</hw>, <pos>a.</pos> <def>Shedding no tears; free from tears; unfeeling.</def> -- <wordforms><wf>Tear"less*ly</wf>, <pos>adv.</pos> -- <wf>Tear"less*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tearpit</ent><br/
<hw>Tear"pit`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Anat.)</fld> <def>A cavity or pouch beneath the lower eyelid of most deer and antelope; the lachrymal sinus; larmier. It is capable of being opened at pleasure and secretes a waxy substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tear-thumb</ent><br/
<hw>Tear"-thumb`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A name given to several species of plants of the genus Polygonum, having angular stems beset with minute reflexed prickles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teary</ent><br/
<hw>Tear"y</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Wet with tears; tearful.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Consisting of tears, or drops like tears.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tea-saucer</ent><br/
<hw>Tea"-sau`cer</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A small saucer in which a teacup is set.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tease</ent><br/
<hw>Tease</hw> <pr>(t<emac/z)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Teased</conjf> <pr>(t<emac/zd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Teasing</conjf>.]</vmorph> <ety>[AS. <ets>t<?/san</ets> to pluck, tease; akin to OD. <ets>teesen</ets>, MHG. <ets>zeisen</ets>, Dan. <ets>t<ae/se</ets>, <ets>t<ae/sse</ets>. <root/58.  Cf. <er>Touse</er>.]</ety> <sn>1.</sn> <def>To comb or card, as wool or flax.</def> <ldquo/<xex>Teasing</xex> matted wool.<rdquo/  <rj><au>Wordsworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To stratch, as cloth, for the purpose of raising a nap; teasel.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Anat.)</fld> <def>To tear or separate into minute shreds, as with needles or similar instruments.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To vex with importunity or impertinence; to harass, annoy, disturb, or irritate by petty requests, or by jests and raillery; to plague.</def>  <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He . . . suffered them to <qex>tease</qex> him into acts directly opposed to his strongest inclinations.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To vex; harass: annoy; disturb; irritate; plague; torment; mortify; tantalize; chagrin.</syn> <usage> -- <er>Tease</er>, <er>Vex</er>. To <xex>tease</xex> is literally to pull or scratch, and implies a prolonged annoyance in respect to little things, which is often more irritating, and harder to bear, than severe pain. <xex>Vex</xex> meant originally to seize and bear away hither and thither, and hence, to disturb; <as>as, to <ex>vex</ex> the ocean with storms</as>. This sense of the term now rarely occurs; but <xex>vex</xex> is still a stronger word than <xex>tease</xex>, denoting the disturbance or anger created by minor provocations, losses, disappointments, etc.  We are <xex>teased</xex> by the buzzing of a fly in our eyes; we are <xex>vexed</xex> by the carelessness or stupidity of our servants.</usage><br/
[<source>1913 Webster</source>]</p>

<p><q>Not by the force of carnal reason,<br/
But indefatigable <qex>teasing</qex>.</q> <rj><qau>Hudibras.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In disappointments, where the affections have been strongly placed, and the expectations sanguine, particularly where the agency of others is concerned, sorrow may degenerate into <qex>vexation</qex> and chagrin.</q> <rj><qau>Cogan.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tease tenon</b></col> <fld>(Joinery)</fld>, <cd>a long tenon at the top of a post to receive two beams crossing each other one above the other.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tease</ent><br/
<hw>Tease</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who teases or plagues.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teasel</ent><br/
<hw>Tea"sel</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>tesel</ets>, AS. <ets>t<aemac/sel</ets>, <ets>t<aemac/sl</ets>, the fuller's herb. See <er>Tease</er>.]</ety> <altsp>[Written also <asp>tassel</asp>, <asp>tazel</asp>, <asp>teasle</asp>, <asp>teazel</asp>, and <asp>teazle</asp>.]</altsp> <sn>1.</sn> <fld>(Bot.)</fld> <def>A plant of the genus <gen>Dipsacus</gen>, of which one species (<spn>Dipsacus fullonum</spn>) bears a large flower head covered with stiff, prickly, hooked bracts. This flower head, when dried, is used for raising a nap on woolen cloth.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Small teasel is <spn>Dipsacus pilosus</spn>, wild teasel is <spn>Dipsacus sylvestris</spn>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A bur of this plant.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any contrivance intended as a substitute for teasels in dressing cloth.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Teasel frame</b></col>, <cd>a frame or set of iron bars in which teasel heads are fixed for raising the nap on woolen cloth.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teasel</ent><br/
<hw>Tea"sel</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Teaseled</conjf> <pr>(?)</pr> or <conjf>Teaselled</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Teaseling</conjf> or <conjf>Teaselling</conjf>.]</vmorph> <def>To subject, as woolen cloth, to the action of teasels, or any substitute for them which has an effect to raise a nap.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teaseler</ent><br/
<hw>Tea"sel*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who uses teasels for raising a nap on cloth.</def> <altsp>[Written also <asp>teaseller</asp>, <asp>teasler</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teaseling</ent><br/
<hw>Tea"sel*ing</hw>, <pos>n.</pos> <def>The cutting and gathering of teasels; the use of teasels.</def> <altsp>[Written also <asp>teaselling</asp>, <asp>teazling</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teaser</ent><br/
<hw>Teas"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who teases or vexes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A jager gull.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Elec.)</fld> <def>A shunt winding on field magnets for maintaining their magnetism when the main circuit is open.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Teasle</ent><br/
<hw>Tea"sle</hw> <pr>(?)</pr>, <pos>n. & v. t.</pos> <def>See <er>Teasel</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teaspoon</ent><br/
<hw>Tea"spoon`</hw> <pr>(t<emac/"sp<oomac/n`)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A small spoon used in stirring and sipping tea, coffee, etc., and for other purposes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>same as <er>teaspoonful</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Teaspoonful</ent><br/
<hw>Tea"spoon`ful</hw> <pr>(t<emac/"sp<oomac/n`f<usdot/l)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Teaspoonfuls</plw> <pr>(t<emac/"sp<oomac/n`f<usdot/lz)</pr> or <plw>Teaspoonsful</plw>.</plu> <def>As much as teaspoon will hold; enough to fill a teaspoon.  In cooking, it is usually estimated as 4.9 milliliters, which is <frac16/ of a fluid ounce, or <frac13/ of a tablespoonful.  In cooking recipes it may be abbreviated as <abbr>t.</abbr></def> <note>In the 1890 dictionary, it was defined as a fluid dram or one quarter of a tablespoonful.</note><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Teat</ent><br/
<hw>Teat</hw> <pr>(t<emac/t)</pr>, <pos>n.</pos> <ety>[OE. <ets>tete</ets>, <ets>titte</ets>, AS. <ets>tit</ets>, <ets>titt</ets>; akin to LG. & OD. <ets>titte</ets>, D. <ets>tet</ets>, G. <ets>zitze</ets>: cf. F. <ets>tette</ets>, probably of Teutonic origin.]</ety> <sn>1.</sn> <def>The protuberance through which milk is drawn from the udder or breast of a mammal; a nipple; a pap; a mammilla; a dug; a tit.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mach.)</fld> <def>A small protuberance or nozzle resembling the teat of an animal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teated</ent><br/
<hw>Teat"ed</hw>, <pos>a.</pos> <def>Having protuberances resembling the teat of an animal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teathe</ent><br/
<hw>Teathe</hw> <pr>(?)</pr>, <pos>n. & v.</pos> <def>See <er>Tath</er>.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teatish</ent><br/
<hw>Teat"ish</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Peevish; tettish; fretful; -- said of a child. See <er>Tettish</er>.</def> <mark>[Obs.]</mark>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teaze-hole</ent><br/
<hw>Teaze"-hole`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Corrupted fr. F. <ets>tisard</ets> fire door.]</ety> <fld>(Glass Works)</fld> <def>The opening in the furnaces through which fuel is introduced.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teazel</ent><br/
<hw>Tea"zel</hw> <pr>(?)</pr>, <pos>n. & v. t.</pos> <def>See <er>Teasel</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teazer</ent><br/
<hw>Tea"zer</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Corrupted fr. F. <ets>tiser</ets> to feed a fire.]</ety> <def>The stoker or fireman of a furnace, as in glass works.</def>  <rj><au>Tomlinson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teazle</ent><br/
<hw>Tea"zle</hw> <pr>(?)</pr>, <pos>n. & v. t.</pos> <def>See <er>Teasel</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tebeth</ent><br/
<hw>Te"beth</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Heb.]</ety> <def>The tenth month of the Jewish ecclesiastical year, answering to a part of December with a part of January.</def>  <rj><au>Esther ii. 16.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Techily</ent><br/
<hw>Tech"i*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a techy manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Techiness</ent><br/
<hw>Tech"i*ness</hw>, <pos>n.</pos> <def>The quality or state of being techy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technic</ent><br/
<hw>Tech"nic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Technical.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technic</ent><br/
<hw>Tech"nic</hw>, <pos>n.</pos> <ety>[See <er>Technical</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>The method of performance in any art; technical skill; artistic execution; technique.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They illustrate the method of nature, not the <qex>technic</qex> of a manlike Artificer.</q> <rj><qau>Tyndall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <def>Technical terms or objects; things pertaining to the practice of an art or science.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technical</ent><br/
<hw>Tech"nic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/, fr. <?/ an art, probably from the same root as <?/, <?/, to bring forth, produce, and perhaps akin to E. <ets>text</ets>: cf. F. <ets>technique</ets>.]</ety> <def>Of or pertaining to the useful or mechanic arts, or to any science, business, or the like; specially appropriate to any art, science, or business; <as>as, the words of an indictment must be <ex>technical</ex></as>.</def>  <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technicality</ent><br/
<hw>Tech`ni*cal"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Technicalities</plw> <pr>(<?/)</pr>.</plu> <sn>1.</sn> <def>The quality or state of being technical; technicalness.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is technical, or peculiar to any trade, profession, sect, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>technicalities</qex> of the sect.</q> <rj><qau>Palfrey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technically</ent><br/
<hw>Tech"nic*al*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a technical manner; according to the signification of terms as used in any art, business, or profession.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technicalness</ent><br/
<hw>Tech"nic*al*ness</hw>, <pos>n.</pos> <def>The quality or state of being technical; technicality.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technicals</ent><br/
<hw>Tech"nic*als</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>Those things which pertain to the practical part of an art, science, or profession; technical terms; technics.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technician</ent><br/
<hw>Tech*ni"cian</hw> <pr>(?)</pr>, <pos>n.</pos> <def>a person trained or skilled in the technical details of a particular art or science, especially one skilled at operating, maintaining, or repairing equipment, in contrast to the theory or informational content of a craft; -- formerly also called a <er>technicist</er>.</def> <note>In computer software companies, individuals skilled at the details of using programs and employed to help customers to install or use software or troubleshoot software problems for  are also called <ex>technicians</ex>.</note><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Technicist</ent><br/
<hw>Tech"ni*cist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One skilled in technics or in one or more of the practical arts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technicological</ent><br/
<hw>Tech`ni*co*log"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Technological; technical.</def> <mark>[R.]</mark>  <rj><au>Dr. J. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technicology</ent><br/
<hw>Tech`ni*col"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Technology.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technicolor</ent><br/
<hw>Tech`ni*col"or</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[a treadmark]</ety> <def>the name of one process used for color cinematography; -- also used attributively.</def> <mark>[trademark]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>Technics</ent><br/
<hw>Tech"nics</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The doctrine of arts in general; such branches of learning as respect the arts.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The study of a particular art.</def><br/
[<source>PJC</source>]</p>

<p><ent>Techniphone</ent><br/
<hw>Tech"ni*phone</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ art + <ets>-phone</ets>.]</ety> <fld>(Music)</fld> <def>A dumb gymnastic apparatus for  training the hands of pianists and organists, as to a legato touch.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Technique</ent><br/
<hw>Tech`nique"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <sn>1.</sn> <def>The method or manner of performance in any art; -- also called <altname>technic</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The body of technical methods and procedures used in a science or craft.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>the detailed movements used for executing an artistic performance; technical skill; artistic execution; <as>as, a pianist's fingering <ex>technique</ex></as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Technism</ent><br/
<hw>Tech"nism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Technicality.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Techno</ent><br/
<hw>Tech"no</hw> <pr>(?)</pr>, <pos>n.</pos> <def>a form of music primarily created by computer sound synthizers rather than by musicians playing instruments.</def> <mark>[slang]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>Technobabble</ent><br/
<hw>Tech"no*bab`ble</hw> <pr>(?)</pr>, <pos>n.</pos> <def>technical jargon incomprehensible to non-specialists; -- sometimes used derogatorily of discussions using unnecessarily technical terminology and intended to impress or confuse, rather than inform, the listener.</def><br/
[<source>PJC</source>]</p>

<p><ent>technocracy</ent><br/
<hw>tech*noc"ra*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>government by technical specialists.</def><br/
[<source>PJC</source>]</p>

<p><ent>technocrat</ent><br/
<hw>tech"no*crat</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>a technical specialist exercising governmental or managerial authority.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>a proponent of technocracy.</def><br/
[<source>PJC</source>]</p>

<p> -- <wordforms><wf>technocratic</wf>, <pos>a.</pos></wordforms><br/
[<source>PJC</source>]</p>

<p><ent>Technography</ent><br/
<hw>Tech*nog"ra*phy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ art, skill, craft + <ets>graph</ets>.]</ety> <def>Description of the arts and  crafts of tribes and peoples.</def> -- <wordforms><wf>Tech`no*graph"ic</wf>, <wf>Tech`no*graph"ic*al</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Technologic</ent><br/
<hw>Tech`no*log"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Technological.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technological</ent><br/
<hw>Tech`no*log"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>technologique</ets>.]</ety> <def>Of or pertaining to technology.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technologist</ent><br/
<hw>Tech*nol"o*gist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One skilled in technology; one who treats of arts, or of the terms of arts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Technology</ent><br/
<hw>Tech*nol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ an art + <ets>-logy</ets>; cf. Gr. <?/ systematic treatment: cf. F. <ets>technologie</ets>.]</ety> <def>Industrial science; the science of systematic knowledge of the industrial arts, especially of the more important manufactures, as spinning, weaving, metallurgy, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Technology</xex> is not an independent science, having a set of doctrines of its own, but consists of applications of the principles established in the various physical sciences (chemistry, mechanics, mineralogy, etc.) to manufacturing processes.  <rj><au>Internat. Cyc.</au></rj>
</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Techy</ent><br/
<hw>Tech"y</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From OE. <ets>tecche</ets>, <ets>tache</ets>, a habit, bad habit, vice, OF. <ets>tache</ets>, <ets>teche</ets>, a spot, stain, blemish, habit, vice, F. <ets>tache</ets> a spot, blemish; probably akin to E. <ets>tack</ets> a small nail. See <er>Tack</er> a small nail, and cf. <er>Touchy</er>.]</ety> <def>Peevish; fretful; irritable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tectibranch</ent><br/
<hw>Tec`ti*branch</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>One of the Tectibranchiata. Also used adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tectibranchia</ent><br/
\'d8<hw>Tec`ti*bran"chi*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.]</ety> <def>Same as <er>Tectibranchiata</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tectibranchiata</ent><br/
\'d8<hw>Tec`ti*bran`chi*a"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>tectus</ets> (p. p. of <ets>tegere</ets> to cover) + Gr. <?/ a gill.]</ety> <fld>(Zool.)</fld> <def>An order, or suborder, of gastropod Mollusca in which the gills are usually situated on one side of the back, and protected by a fold of the mantle.  When there is a shell, it is usually thin and delicate and often rudimentary. The aplysias and the bubble shells are examples.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tectibranchiate</ent><br/
<hw>Tec`ti*bran"chi*ate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tectus</ets> (p. p. of <ets>tegere</ets> to cover) + E. <ets>branchiate</ets>.]</ety> <fld>(Zool.)</fld> <def>Having the gills covered by the mantle; of or pertaining to the Tectibranchiata.</def> -- <def2><pos>n.</pos> <def>A tectibranchiate mollusk.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tectly</ent><br/
<hw>Tect"ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[L. <ets>tectus</ets> covered, fr. <ets>tegere</ets> to cover.]</ety> <def>Covertly; privately; secretly.</def> <mark>[Obs.]</mark>  <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tectology</ent><br/
<hw>Tec*tol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ a carpenter + <ets>-logy</ets>.]</ety> <fld>(Biol.)</fld> <def>A division of morphology created by Haeckel; the science of organic individuality constituting the purely structural portion of morphology, in which the organism is regarded as composed of organic individuals of different orders, each organ being considered an individual. See <er>Promorphology</er>, and <er>Morphon</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tectonic</ent><br/
<hw>Tec*ton"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tectonicus</ets>, Gr. <?/, fr. <?/, <?/, a carpenter, builder.]</ety> <sn>1.</sn> <def>Of or pertaining to building or construction; architectural.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Biol.)</fld> <def>Structural.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <fld>(Geol. & Phys. Geog.)</fld> <def>Of, pert. to, or designating, the rock structures and external forms resulting from the deformation of the earth's crust; <as>as, <ex>tectonic</ex> arches or valleys; <ex>tectonic</ex> plates</as>.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Tectonics</ent><br/
<hw>Tec*ton"ics</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The science, or the art, by which implements, vessels, dwellings, or other edifices, are constructed, both agreeably to the end for which they are designed, and in conformity with artistic sentiments and ideas.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn>  <fld>(Geol. & Phys. Geog.)</fld> <def>the branch of geology concerned with the rock structures and external forms resulting from the deformation of the earth's crust; also, similar studies of other planets.  Also called <altname>structural geology</altname>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>plate tectonics</b></col> <cd>a geological theory which considers the earth's crust as divided into a number of large relatively rigid plates, which move relatively independently on the more plastic asthenosphere under the influence of magmatic upwellings, so as to drift apart, slide past, or collide with each other, causing the formation, breakup, or merging of continents, and causing volcanism, the building of mountain ranges, and the subduction of one plate beneath another. In recent decades a large body of data have accumulated to support the theory and provide some details of the mechanisms at work.  One set of supporting observations consists of data showing that the continents have slowly moved relative to each other over long periods of time, a phenomenon called <er>continental drift</er>.  Africa and South America, for example, have apparently moved apart from a connected configuration at about 2 to 3 cm per year over tens of millions of years.</cd></cs><br/
[<source>PJC</source>]</p>

<p><ent>Tectorial</ent><br/
<hw>Tec*to"ri*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tectorius</ets>.]</ety> <fld>(Anat.)</fld> <def>Of or pertaining to covering; -- applied to a membrane immediately over the organ of Corti in the internal ear.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tectrices</ent><br/
\'d8<hw>Tec"tri*ces</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>tegere</ets>, <ets>tectum</ets>, to cover.]</ety> <fld>(Zool.)</fld> <def>The wing coverts of a bird. See <er>Covert</er>, and <xex>Illust.</xex> of <er>Bird</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tecum</ent><br/
<hw>Te"cum</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>See <er>Tucum</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ted</ent><br/
<hw>Ted</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tedded</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tedding</conjf>.]</vmorph> <ety>[Prob. fr. Icel. <ets>te<?/ja</ets> to spread manure, fr. <ets>ta<?/</ets> manure; akin to MHG. <ets>zetten</ets> to scatter, spread. <root/58.  Cf. <er>Teathe</er>.]</ety> <def>To spread, or turn from the swath, and scatter for drying, as new-mowed grass; -- chiefly used in the past participle.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The smell of grain or <qex>tedded</qex> grass.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>tedded</qex> hay and corn sheaved in one field.</q> <rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tedder</ent><br/
<hw>Ted"der</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A machine for stirring and spreading hay, to expedite its drying.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tedder</ent><br/
<hw>Ted"der</hw>, <pos>n.</pos> <ety>[OE. <root/64. See <er>Tether</er>.]</ety> <def>Same as <er>Tether</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tedder</ent><br/
<hw>Ted"der</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Teddered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Teddering</conjf>.]</vmorph> <def>Same as <er>Tether</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tedesco</ent><br/
\'d8<hw>Te*des"co</hw> <pr>(?)</pr>, <pos>a.</pos>; <plu>pl. <plw>Tedeschi</plw> <pr>(#)</pr></plu>. <ety>[It., of Germanic origin. See <er>Dutch</er>.]</ety> <def>German; -- used chiefly of art, literature, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Te Deum</ent><br/
\'d8<hw>Te` De"um</hw> <pr>(?)</pr>. <ety>[L., from <ets>te</ets> (accus. of <ets>tu</ets> thou) + <ets>Deum</ets>, accus. of <ets>Deus</ets> God. See <er>Thou</er>, and <er>Deity</er>.]</ety> <sn>1.</sn> <def>An ancient and celebrated Christian hymn, of uncertain authorship, but often ascribed to St. Ambrose; -- so called from the first words <ldquo/<xex>Te Deum laudamus</xex>.<rdquo/ It forms part of the daily matins of the Roman Catholic breviary, and is sung on all occasions of thanksgiving. In its English form, commencing with words, <ldquo/We praise thee, O God,<rdquo/ it forms a part of the regular morning service of the Church of England and the Protestant Episcopal Church in America.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A religious service in which the singing of the hymn forms a principal part.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A musical setting of the <er>Te Deum{1}</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tedge</ent><br/
<hw>Tedge</hw> <pr>(t<ecr/j)</pr>, <pos>n.</pos> <fld>(Founding)</fld> <def>The gate of a mold, through which the melted metal is poured; runner, geat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tediosity</ent><br/
<hw>Te`di*os"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Tediousness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tedious</ent><br/
<hw>Te"di*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>taediosus</ets>, fr. <ets>taedium</ets>. See <er>Tedium</er>.]</ety> <def>Involving tedium; tiresome from continuance, prolixity, slowness, or the like; wearisome.</def> -- <wordforms><wf>Te"di*ous*ly</wf>, <pos>adv.</pos> -- <wf>Te"di*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>I see a man's life is a <qex>tedious</qex> one.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I would not be <qex>tedious</qex> to the court.</q> <rj><qau>Bunyan.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Wearisome; fatiguing. See <er>Irksome</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1480 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tedium</ent><br/
<hw>Te"di*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>taedium</ets>, fr. <ets>taedet</ets> it disgusts, it wearies one.]</ety> <def>Irksomeness; wearisomeness; tediousness.</def> <altsp>[Written also <asp>taedium</asp>.]</altsp>  <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To relieve the <qex>tedium</qex>, he kept plying them with all manner of bams.</q> <rj><qau>Prof. Wilson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>tedium</qex> of his office reminded him more strongly of the willing scholar, and his thoughts were rambling.</q> <rj><qau>Dickens.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tee</ent><br/
<hw>Tee</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Icel. <ets>tj<amac/</ets> to show, mark.]</ety> <sd>(a)</sd> <def>The mark aimed at in curling and in quoits.</def> <sd>(b)</sd> <def>The nodule of earth, or a short peg stuck into the ground, from which the ball is struck at the beginning of play for each hole in golf.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Tee</ent><br/
<hw>Tee</hw>, <pos>n.</pos> <sn>1.</sn> <def>A short piece of pipe having a lateral outlet, used to connect a line of pipe with a pipe at a right angle with the line; -- so called because it resembles the letter <er>T</er> in shape.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The letter T, t; also, something shaped like, or resembling in form, the letter <universbold>T</universbold>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tee</ent><br/
<hw>Tee</hw> <pr>(?)</pr>, <pos>v. t.</pos>  <vmorph>[<pos>imp. & p. p.</pos> <conjf>Teed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Teeing</conjf>.]</vmorph> <fld>(Golf)</fld> <def>To place (the ball) on a tee; also called to <altname>tee up</altname>.</def><-- also . See tee off. --><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Teeing ground</ent><br/
<hw>Teeing ground</hw>. <fld>(Golf)</fld> <def>The space from within which the ball must be struck in beginning the play for each hole.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tee iron</ent><br/
<hw>Tee" i`ron</hw> <pr>(?)</pr>. <def>See <cref>T iron</cref>, under <er>T</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teek</ent><br/
<hw>Teek</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>See <er>Teak</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teel</ent><br/
<hw>Teel</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Sesame.</def> <altsp>[Sometimes written <asp>til</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Teel oil</b></col>, <cd>sesame oil.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teelseed</ent><br/
<hw>Teel"seed`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The seed of sesame.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teem</ent><br/
<hw>Teem</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[Icel. <ets>t<ae/ma</ets> to empty, from <ets>t<omac/mr</ets> empty; akin to Dan. <ets>t<oum/mme</ets> to empty, Sw. <ets>t<oum/mma</ets>. See <er>Toom</er> to empty.]</ety> <sn>1.</sn> <def>To pour; -- commonly followed by <xex>out</xex>; <as>as, to <ex>teem</ex> out ale</as>.</def> <mark>[Obs. or Prov. Eng.]</mark>  <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Steel Manuf.)</fld> <def>To pour, as steel, from a melting pot; to fill, as a mold, with molten metal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teem</ent><br/
<hw>Teem</hw>, <pos>v. t.</pos> <ety>[See <er>Tame</er>, <pos>a.</pos>, and cf. <er>Beteem</er>.]</ety> <def>To think fit.</def> <mark>[Obs. or R.]</mark>  <rj><au>G. Gifford.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teem</ent><br/
<hw>Teem</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Teemed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Teeming</conjf>.]</vmorph> <ety>[OE. <ets>temen</ets>, AS. <ets>t<emac/man</ets>, <ets>t<?/man</ets>, from <ets>te<aacute/m</ets>. See <er>Team</er>.]</ety> <sn>1.</sn> <def>To bring forth young, as an animal; to produce fruit, as a plant; to bear; to be pregnant; to conceive; to multiply.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If she must <qex>teem</qex>,<br/
Create her child of spleen.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be full, or ready to bring forth; to be stocked to overflowing; to be prolific; to abound.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His mind <qex>teeming</qex> with schemes of future deceit to cover former villainy.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The young, brimful of the hopes and feeling which <qex>teem</qex> in our time.</q> <rj><qau>F. Harrison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teem</ent><br/
<hw>Teem</hw>, <pos>v. t.</pos> <def>To produce; to bring forth.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>That [grief] of an hour's age doth hiss the speaker;<br/
Each minute <qex>teems</qex> a new one.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teemer</ent><br/
<hw>Teem"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who teems, or brings forth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teemful</ent><br/
<hw>Teem"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Pregnant; prolific.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Brimful.</def> <mark>[Obs.]</mark>  <rj><au>Ainsworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeming</ent><br/
<hw>Teem"ing</hw>, <pos>a.</pos> <def>Prolific; productive.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Teeming</qex> buds and cheerful appear.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teemless</ent><br/
<hw>Teem"less</hw>, <pos>a.</pos> <def>Not fruitful or prolific; barren; <as>as, a <ex>teemless</ex> earth</as>.</def> <mark>[Poetic]</mark>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teen</ent><br/
<hw>Teen</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>tene</ets>, AS. <ets>te<oacute/na</ets> reproach, wrong, fr. <ets>te<oacute/n</ets> to accuse; akin to G. <ets>zeihen</ets>, Goth. ga<ets>teihan</ets> to tell, announce, L. <ets>dicere</ets> to say. See <er>Token</er>.]</ety> <def>Grief; sorrow; affiction; pain.</def> <mark>[Archaic]</mark>  <rj><au>Chaucer. Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>With public toil and private <qex>teen</qex><br/
Thou sank'st alone.</q> <rj><qau>M. Arnold.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teen</ent><br/
<hw>Teen</hw>, <pos>v. t.</pos> <ety>[AS. <ets>te<oacute/nian</ets>, <ets>t<?/nan</ets>, to slander, vex. <root/64. See <er>Teen</er>, <pos>n.</pos>]</ety> <def>To excite; to provoke; to vex; to affict; to injure.</def> <mark>[Obs.]</mark>  <rj><au>Piers Plowman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teen</ent><br/
<hw>Teen</hw>, <pos>v. t.</pos> <ety>[See <er>Tine</er> to shut.]</ety> <def>To hedge or fence in; to inclose.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teen</ent><br/
<hw>Teen</hw>, <pos>n.</pos> <def>a <er>teenager</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Teenage</ent><br/
<hw>Teen"age</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The longer wood for making or mending fences.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teenage</ent><br/
<hw>Teen"age`</hw> <pr>(t<emac/n"<amac/j)</pr>, <pos>n.</pos> <def>of or pertaining to a teenager; being in one's teens; <as>as, a busload of <ex>teenage</ex> football fans; <ex>teenage</ex> inexperience</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Teenager</ent><br/
<hw>Teen"ag`er</hw> <pr>(t<emac/n"<amac/j`<etil/r)</pr>, <pos>n.</pos> <def>a person whose age is in the teens, i.e. one between the ages of 13 to 19 inclusive.</def><br/
[<source>PJC</source>]</p>

<p><ent>Teend</ent><br/
<hw>Teend</hw> <pr>(?)</pr>, <pos>v. t. & i.</pos> <ety>[See <er>Tinder</er>.]</ety> <def>To kindle; to burn.</def> <mark>[Obs.]</mark>  <rj><au>Herrick.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teenful</ent><br/
<hw>Teen"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Full of teen; harmful; grievous; grieving; afflicted.</def> <mark>[Obs.]</mark>  <rj><au>Piers Plowman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teens</ent><br/
<hw>Teens</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[See <er>Ten</er>.]</ety> <def>The years of one's age having the termination <xex>-teen</xex>, beginning with thirteen and ending with nineteen; <as>as, a girl in her <ex>teens</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeny</ent><br/
<hw>Tee"ny</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Very small; tiny.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeny</ent><br/
<hw>Teen"y</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Teen</er> grief.]</ety> <def>Fretful; peevish; pettish; cross.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeong</ent><br/
<hw>Tee*ong"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The mino bird.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teest</ent><br/
<hw>Teest</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A tinsmith's stake, or small anvil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeswater</ent><br/
<hw>Tees"wa`ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the river <ets>Tees</ets>, northern England.]</ety> <sn>1.</sn> <def>A breed of cattle formerly bred in England, but supposed to have originated in Holland and to have been the principal stock from which the shorthorns were derived.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>An old English breed of sheep allied to the Leicester.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Teetan</ent><br/
<hw>Tee"tan</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A pipit.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teetee</ent><br/
<hw>Tee"tee</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>tit<iacute/</ets>.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>Any one of several species of small, soft-furred South American monkeys belonging to <gen>Callithrix</gen>, <gen>Chrysothrix</gen>, and allied genera; <as>as, the collared <ex>teetee</ex> (<spn>Callithrix torquatus</spn>), and the squirrel <ex>teetee</ex> (<spn>Chrysothrix sciurea</spn>)</as>. Called also <altname>pinche</altname>, <altname>titi</altname>, and <altname>saimiri</altname>. See <cref>Squirrel monkey</cref>, under <er>Squirrel</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A diving petrel of Australia (<spn>Halodroma wrinatrix</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeter</ent><br/
<hw>Tee"ter</hw> <pr>(?)</pr>, <pos>v. i. & t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Teetered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Teetering</conjf>.]</vmorph> <ety>[Prov. E. <ets>titter</ets> to tremble, to seesaw; cf. Icel. <ets>titra</ets> to tremble, OHG. <ets>zittar<omac/n</ets>, G. <ets>zittern</ets>.]</ety> <def>To move up and down on the ends of a balanced plank, or the like, as children do for sport; to seesaw; to titter; to titter-totter.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>[The bobolink] alit upon the flower, and <qex>teetered</qex> up and down.</q> <rj><qau>H. W. Beecher.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeter-tail</ent><br/
<hw>Tee"ter-tail`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The spotted sandpiper. See the Note under <er>Sandpiper</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeth</ent><br/
<hw>Teeth</hw> <pr>(?)</pr>, <pos>n.</pos>, <def><pos>pl.</pos> of <er>Tooth</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeth</ent><br/
<hw>Teeth</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Teethed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Teething</conjf>.]</vmorph> <def>To breed, or grow, teeth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teething</ent><br/
<hw>Teeth"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The process of the first growth of teeth, or the phenomena attending their issue through the gums; dentition.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teetotal</ent><br/
<hw>Tee*to"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Entire; total.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teetotaler</ent><br/
<hw>Tee*to"tal*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One pledged to entire abstinence from all intoxicating drinks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teetotalism</ent><br/
<hw>Tee*to"tal*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The principle or practice of entire abstinence, esp. from intoxicating drinks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teetotally</ent><br/
<hw>Tee*to"tal*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>Entirely; totally.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teetotum</ent><br/
<hw>Tee*to"tum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[For T-<ets>totum</ets>. It was used for playing games of chance, and was four-sided, one side having the letter <b>T</b> on it, standing for Latin <ets>totum</ets> all, meaning, take all that is staked, whence the name. The other three sides each had a letter indicating an English or Latin word; as <b>P</b> meaning put down, <b>N</b> nothing or L. <ets>nil</ets>, <b>H</b> half. See <er>Total</er>.]</ety> <def>A child's toy, somewhat resembling a top, and twirled by the fingers.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The staggerings of the gentleman . . . were like those of a <qex>teetotum</qex> nearly spent.</q> <rj><qau>Dickens.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tee-to-tum</ent><br/
<hw>Tee-to"-tum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Teetotaler</er>.]</ety> <def>A workingmen's resort conducted under religious influences as a counteractant to the drinking saloon.</def> <mark>[Colloq. or Cant]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Teetuck</ent><br/
<hw>Tee"tuck</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The rock pipit.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teeuck</ent><br/
<hw>Tee"uck</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The lapwing.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teewit</ent><br/
<hw>Tee"wit</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The pewit.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teg</ent><br/
<hw>Teg</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A sheep in its second year; also, a doe in its second year.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tegmen</ent><br/
\'d8<hw>Teg"men</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tegmina</plw> <pr>(#)</pr>.</plu> <ety>[L., fr. <ets>tegere</ets>, <ets>tectum</ets>, to cover.]</ety> <sn>1.</sn> <def>A tegument or covering.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>The inner layer of the coating of a seed, usually thin and delicate; the endopleura.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>One of the elytra of an insect, especially of certain Orthoptera.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <pluf>pl.</pluf> <fld>(Zool.)</fld> <def>Same as <er>Tectrices</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tegmental</ent><br/
<hw>Teg*men"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Biol.)</fld> <def>Of or pertaining to a tegument or tegmentum; <as>as, the <ex>tegmental</ex> layer of the epiblast; the <ex>tegmental</ex> cells of the taste buds.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tegmentum</ent><br/
\'d8<hw>Teg*men"tum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tegmenta</plw> <pr>(#)</pr>.</plu> <ety>[L., a covering.]</ety> <fld>(Anat.)</fld> <def>A covering; -- applied especially to the bundles of longitudinal fibers in the upper part of the crura of the cerebrum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teguexin</ent><br/
<hw>Te*guex"in</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A large South American lizard (<spn>Tejus teguexin</spn>). It becomes three or four feet long, and is blackish above, marked with yellowish spots of various sizes. It feeds upon fruits, insects, reptiles, young birds, and birds' eggs. The closely allied species <spn>Tejus rufescens</spn> is called <altname>red teguexin</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tegula</ent><br/
\'d8<hw>Teg"u*la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tegulae</plw> <pr>(#)</pr>.</plu> <ety>[L., a tile, dim. fr. <ets>tegere</ets> to cover.]</ety> <fld>(Zool.)</fld> <def>A small appendage situated above the base of the wings of Hymenoptera and attached to the mesonotum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tegular</ent><br/
<hw>Teg"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[LL. <ets>tegularis</ets>, from L. <ets>tegula</ets> a tile. See <er>Tile</er>.]</ety> <def>Of or pertaining to a tile; resembling a tile, or arranged like tiles; consisting of tiles; <as>as, a <ex>tegular</ex> pavement</as>.</def> -- <wordforms><wf>Teg"u*lar*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tegulated</ent><br/
<hw>Teg`u*la"ted</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Composed of small plates, as of horn or metal, overlapping like tiles; -- said of a kind of ancient armor.</def>  <rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tegument</ent><br/
<hw>Teg"u*ment</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tegumentum</ets>, from <ets>tegere</ets> to cover. See <er>Thatch</er>, <pos>n.</pos>, and cf. <er>Detect</er>, <er>Protect</er>.]</ety> <sn>1.</sn> <def>A cover or covering; an integument.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Especially, the covering of a living body, or of some part or organ of such a body; skin; hide.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tegumentary</ent><br/
<hw>Teg`u*men"ta*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>t<eacute/gumentaire</ets>.]</ety> <def>Of or pertaining to a tegument or teguments; consisting of teguments; serving as a tegument or covering.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Te-hee</ent><br/
<hw>Te-hee"</hw> <pr>(?)</pr>, <pos>n. & interj.</pos> <def>A tittering laugh; a titter.</def> <ldquo/'<xex>Te-hee</xex>,' quoth she.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Te-hee</ent><br/
<hw>Te-hee"</hw>, <pos>v. i.</pos> <def>To titter; to laugh derisively.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She cried, <ldquo/Come, come; you must not look grave upon me.<rdquo/ Upon this, I <qex>te-heed</qex>.</q> <rj><qau>Madame D'Arblay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teil</ent><br/
<hw>Teil</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>teil</ets>, <ets>til</ets>, L. <ets>tilia</ets>.]</ety> <fld>(Bot.)</fld> <def>The lime tree, or linden; -- called also <altname>teil tree</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teind</ent><br/
<hw>Teind</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Icel. <ets>t<imac/und</ets>. See <er>Tithe</er>.]</ety> <def>A tithe.</def> <mark>[Scot.]</mark>  <rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teine</ent><br/
<hw>Teine</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Teyne</er>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teinland</ent><br/
<hw>Tein"land</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(O. Eng. Law)</fld> <def>Land granted by the crown to a thane or lord.</def>  <rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teinoscope</ent><br/
<hw>Tei"no*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ to extend + <ets>-scope</ets>.]</ety> <fld>(Physics)</fld> <def>An instrument formed by combining prisms so as to correct the chromatic aberration of the light while linear dimensions of objects seen through the prisms are increased or diminished; -- called also <altname>prism telescope</altname>.</def>  <rj><au>Sir D. Brewster.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teint</ent><br/
<hw>Teint</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>teint</ets>, <ets>teinte</ets>. See <er>Tint</er>.]</ety> <def>Tint; color; tinge, See <er>Tint</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Time shall . . . embrown the <qex>teint</qex>.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teinture</ent><br/
<hw>Tein"ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See <er>Tincture</er>.]</ety> <def>Color; tinge; tincture.</def> <mark>[Obs.]</mark>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tek</ent><br/
<hw>Tek</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A Siberian ibex.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telamones</ent><br/
\'d8<hw>Tel`a*mo"nes</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[L., pl. of <ets>telamo</ets> or <ets>telamon</ets>, Gr. <?/ a bearer, fr. <?/ to bear.]</ety> <fld>(Arch.)</fld> <def>Same as <er>Atlantes</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telangiectasis</ent><br/
\'d8<hw>Tel*an`gi*ec"ta*sis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ end + <?/ vessel + <?/ extension.]</ety> <fld>(Med.)</fld> <def>Dilatation of the capillary vessels.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telangiectasy</ent><br/
<hw>Tel*an`gi*ec"ta*sy</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Med.)</fld> <def>Telangiectasis.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telarly</ent><br/
<hw>Te"lar*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a weblike manner.</def> <mark>[Obs.]</mark> <ldquo/<xex>Telarly</xex> interwoven.<rdquo/  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telary</ent><br/
<hw>Te"la*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[LL. <ets>telaris</ets>, fr. L. <ets>tela</ets> a web. See <er>Toil</er> a snare.]</ety> <def>Of or pertaining to a web; hence, spinning webs; retiary.</def> <ldquo/Pictures of <xex>telary</xex> spiders.<rdquo/  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telautogram</ent><br/
<hw>Tel*au"to*gram</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A message transmitted and recorded by a teleautograph.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telautograph</ent><br/
<hw>Tel*au"to*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>autograph</ets>.]</ety> <def>A facsimile telegraph for reproducing writing, pictures, maps, etc. In the transmitter the motions of the pencil are communicated by levers to two rotary shafts, by which variations in current are produced in two separate circuits. In the receiver these variations are utilized by electromagnetic devices and levers to move a pen as the pencil moves.</def> -- <wordforms><wf>Tel`au*tog"ra*phist</wf> <pr>(#)</pr>, <pos>n.</pos><-- superseded by FAX --></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telechirograph</ent><br/
<hw>Tel`e*chi"ro*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <grk>chei`r</grk>, <grk>cheiro`s</grk>, hand + <ets>-graph</ets>.]</ety> <def>An instrument for  telegraphically transmitting and receiving handwritten messages, as photographically by a beam of light from a mirror.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Teledu</ent><br/
<hw>Tel"e*du</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>An East Indian carnivore (<spn>Mydaus meliceps</spn>) allied to the badger, and noted for the very offensive odor that it emits, somewhat resembling that of a skunk. It is a native of the high mountains of Java and Sumatra, and has long, silky fur. Called also <altname>stinking badger</altname>, and <altname>stinkard</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telega</ent><br/
<hw>Te*le"ga</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Russ. <ets>telyega</ets>.]</ety> <def>A rude four-wheeled, springless wagon, used among the Russians.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telegony</ent><br/
<hw>Te*leg"o*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + root of  Gr. <?/ to be born.]</ety> <fld>(Biol.)</fld> <def>The supposed influence of a father upon offspring subsequent to his own, begotten of the same mother by another father.</def> -- <wordforms><wf>Te*leg"o*nous</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telegram</ent><br/
<hw>Tel"e*gram</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far + <ets>-gram</ets>.]</ety> <def>A message sent by telegraph; a telegraphic dispatch.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ldquo/A friend desires us to give notice that he will ask leave, at some convenient time, to introduce a new word into the vocabulary. It is <xex>telegram</xex>, instead of <xex>telegraphic dispatch</xex>, or <xex>telegraphic communication</xex>.<rdquo/  <rj><au>Albany [N. Y.] Evening Journal (April 6, 1852).</au></rj>
</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telegrammic</ent><br/
<hw>Tel`e*gram*mic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to, or resembling, a telegram; laconic; concise; brief.</def> <mark>[R.]</mark><br/
<syn><b>Syn. --</b> telegraphic.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telegraph</ent><br/
<hw>Tel"e*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far, far off (cf. Lith. <ets>toli</ets>) + <ets>-graph</ets>: cf. F. <ets>t<eacute/l<eacute/graphe</ets>. See <er>Graphic</er>.]</ety> <def>An apparatus, or a process, for communicating intelligence rapidly between distant points, especially by means of preconcerted visible or audible signals representing words or ideas, or by means of words and signs, transmitted by electrical action.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The instruments used are classed as <xex>indicator</xex>, <xex>type-printing</xex>, <xex>symbol-printing</xex>, or <xex>chemical-printing telegraphs</xex>, according as the intelligence is given by the movements of a pointer or indicator, as in Cooke & Wheatstone's (the form commonly used in England), or by impressing, on a fillet of paper, letters from types, as in House's and Hughe's, or dots and marks from a sharp point moved by a magnet, as in Morse's, or symbols produced by electro-chemical action, as in Bain's. In the offices in the United States the recording instrument is now little used, the receiving operator reading by ear the combinations of long and short intervals of sound produced by the armature of an electro-magnet as it is put in motion by the opening and breaking of the circuit, which motion, in registering instruments, traces upon a ribbon of paper the lines and dots used to represent the letters of the alphabet. See <xex>Illustration</xex> in Appendix, and <er>Morse code</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><note>In 1837,  <person>Samuel F. B. Morse</person>, an American artist, devised a working electric telegraph, based on a rough knowledge of electrical circuits, electromagnetic induction coils, and a scheme to encode alphabetic letters.  He  and his collaborators and backers campaigned for years before persuading the federal government to fund a demonstration.  Finally, on May 24, 1844, they sent the first official long-distance telegraphic message in Morse code, "What hath God wrought," through a copper wire strung between Washington, D.C., to Baltimore, Maryland.   The phrase was taken from the Bible, Numbers 23:23.  It  had been suggested to <persfn>Morse</persfn> by <person>Annie Ellworth</person>, the young daughter of a friend.</note> <au>Library of Congress, American Memories series (http://memory.loc.gov/ammem/today/may24.html).</au><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Acoustic telegraph</b></col>. <cd>See under <er>Acoustic</er>.</cd> -- <col><b>Dial telegraph</b></col>, <cd>a telegraph in which letters of the alphabet and numbers or other symbols are placed upon the border of a circular dial plate at each station, the apparatus being so arranged that the needle or index of the dial at the receiving station accurately copies the movements of that at the sending station.</cd> -- <mcol><col><b>Electric telegraph</b></col>, <it>or</it> <col><b>Electro-magnetic telegraph</b></col></mcol>, <cd>a telegraph in which an operator at one station causes words or signs to be made at another by means of a current of electricity, generated by a battery and transmitted over an intervening wire.</cd> -- <col><b>Facsimile telegraph</b></col>. <cd>See under <er>Facsimile</er>.</cd> -- <col><b>Indicator telegraph</b></col>. <cd>See under <er>Indicator</er>.</cd> -- <col><b>Pan-telegraph</b></col>, <cd>an electric telegraph by means of which a drawing or writing, as an autographic message, may be exactly reproduced at a distant station.</cd> -- <col><b>Printing telegraph</b></col>, <cd>an electric telegraph which automatically prints the message as it is received at a distant station, in letters, not signs.</cd> -- <col><b>Signal telegraph</b></col>, <cd>a telegraph in which preconcerted signals, made by a machine, or otherwise, at one station, are seen or heard and interpreted at another; a semaphore.</cd> -- <col><b>Submarine telegraph cable</b></col>, <cd>a telegraph cable laid under water to connect stations separated by a body of water.</cd> -- <col><b>Telegraph cable</b></col>, <cd>a telegraphic cable consisting of several conducting wires, inclosed by an insulating and protecting material, so as to bring the wires into compact compass for use on poles, or to form a strong cable impervious to water, to be laid under ground, as in a town or city, or under water, as in the ocean.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telegraph</ent><br/
<hw>Tel"e*graph</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Telegraphed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Telegraphing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[F. <ets>t<eacute/l<eacute/graphier</ets>.]</ety> <def>To convey or announce by telegraph.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telegrapher</ent><br/
<hw>Te*leg"ra*pher</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who sends telegraphic messages; a telegraphic operator; a telegraphist.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>telegraphese</ent><br/
<hw>telegraphese</hw> <pos>n.</pos> <sn>1.</sn> <def>language characterized by terseness and ellipsis as in telegrams.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Telegraphic</ent><br/
<hw>Tel`e*graph"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>t<eacute/l<eacute/graphique</ets>.]</ety> <sn>1.</sn> <def>Of or pertaining to the telegraph; made or communicated by a telegraph; <as>as, <ex>telegraphic</ex> signals; <ex>telegraphic</ex> art; <ex>telegraphic</ex> intelligence.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Having only the essential information; brief; concise; terse; -- of communications, by analogy with the style of telegrams, which are short to avoid unnecessary expense.</def> <note>a <ex>telegraphic</ex> communication should have enough information to allow comprehension of the content, though it may leave out normally included words.  If so much is left out that the communication becomes difficult or impossible to understand, it may be called <contr>cryptic</contr>. <ldquo/Sighted sub. Sank same.<rdquo/ is a <ex>telegraphic</ex> message.</note><br/
[<source>PJC</source>]</p>

<p><ent>Telegraphical</ent><br/
<hw>Tel`e*graph"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Telegraphic.</def> -- <wordforms><wf>Tel`e*graph"ic*al*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telegraphist</ent><br/
<hw>Te*leg"ra*phist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One skilled in telegraphy; a telegrapher.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telegraph plant</ent><br/
<hw>Telegraph plant</hw> <fld>(Bot.)</fld>, <def>A tick trefoil (<spn>Meibomia gyrans</spn> formerly <spn>Desmodium gyrans</spn>), native of the East Indies; it is a leguminous plant whose lateral leaflets jerk up and down like the arms of a semaphore, and also rotate on their axes.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telegraphone</ent><br/
<hw>Te*leg"ra*phone</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>-graph</ets> + <?/ sound.]</ety> <def>An instrument for recording and reproducing sound by local magnetization of a steel wire, disk, or ribbon, moved against the pole of a magnet connected electrically with a telephone receiver, or the like.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telegraphoscope</ent><br/
<hw>Tel`e*graph"o*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk>  far + <ets>-graph</ets> + <ets>-scope</ets>.]</ety> <def>An instrument for telegraphically transmitting a picture and reproducing its image as a positive or negative.  The transmitter includes a camera obscura and a row of minute selenium cells.  The receiver includes an oscillograph, relay, equilibrator, and an induction coil the sparks from which perforate a paper with tiny holes that form the image.  It is now (1999) obsolete, having been replaced by telefax and internet transmission of images.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Telegraphy</ent><br/
<hw>Te*leg"ra*phy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>t<eacute/l<eacute/graphie</ets>.]</ety> <def>The science or art of constructing, or of communicating by means of, telegraphs; <as>as, submarine <ex>telegraphy</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telegu</ent><br/
<hw>Tel`e*gu"</hw>, <pos>prop. a. & n.</pos> <def>same as <er>Telugu</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Telehydrobarometer</ent><br/
<hw>Tel`e*hy`dro*ba*rom"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>hydrobarometer</ets>.]</ety> <def>An instrument for indicating the level of water in a distant tank or reservior.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tele-iconograph</ent><br/
<hw>Tel`e-i*con"o*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>iconograph</ets>.]</ety> <sn>1.</sn> <def>An instrument essentially the same as the telemetrograph.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>A form of facsimile telegraph.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>telekinesis</ent><br/
<hw>tel`e*ki*ne"sis</hw> <pr>(t<ecr/l`<ucr/*k<icr/*n<emac/"s<icr/s)</pr>, <pos>n.</pos> <def>the ability to move objects by means of thought alone, without physical means; -- an ability claimed by certain persons, such as mediums.</def> <note>the existence of this ability is disbelieved by most scientists.</note><br/
<syn><b>Syn. --</b> psychokinesis</syn><br/
[<source>PJC</source>]</p>

<p><ent>Tel-el-Amarna</ent><br/
<hw>Tel`-el-A*mar"na</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Ar., hill of Amarna.]</ety> <def>A station on the Nile in Egypt, midway between Thebes and Memphis, forming the site of the ancient city of Akhetaton, capital of <person>Amenophis IV.</person> (<persfn>Akhenaton</persfn>, or <person>Amenhotep IV.</person>, of the 18th dynasty, king 1353-1336 B. C.), whose archive chamber was discovered there during extensive excavations in 1887-1888.  A collection of about 300 clay tablets (called the <mcol><col><b>Tel-el-Amarna tablets</b></col>, <it>or</it> the <col><b>Amarna tablets</b></col></mcol>) was found here, forming the diplomatic correspondence (<col><b>Tel-el-Amarna letters</b></col>) of <person>Amenophis IV.</person> and his father, <person>Amenophis III.</person>, with the kings of Asiatic countries (such as Babylonia, Assyria, and Palestine), written in cuneiform characters.  It is an important source of our knowledge of Asia from about 1400 to 1370 <sc>b. c.</sc>.  The name of the site is also spelled <asp>Tell-el-Amarna</asp>, <asp>Tell el Amarna</asp>, and <asp>Tel Amarna</asp>.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Telelectric</ent><br/
<hw>Tel`e*lec"tric</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>electric</ets>.]</ety> <fld>(Elec.)</fld> <def>Of or pertaining to transmission, as of music, to a distance by electricity.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telelectroscope</ent><br/
<hw>Tel`e*lec"tro*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>electro-</ets> + <ets>-scope</ets>.]</ety> <def>Any apparatus for making distant objects visible by the aid of electric transmission.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>telemarketing</ent><br/
<hw>telemarketing</hw> <pos>n.</pos> <def>the use of the telephone as an interactive medium for promotion; calling potential customers by telephone for the purpose of selling something; -- applied especially to calls made to persons who have not previously contacted the seller.</def><br/
<syn><b>Syn. --</b> teleselling.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Telemechanic</ent><br/
<hw>Tel`e*me*chan"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>mechanic</ets>.]</ety> <def>Designating, or pert. to, any device for operating mechanisms at a distance.</def> -- <wordforms><wf>Tel`e*mech"a*nism</wf> <pr>(#)</pr>, <pos>n.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telemachus</ent><br/
<hw>Tel`e*ma"chus</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <def>The son of Odysseus and Penelope, as told in Homer's Oddysey.</def><br/
[<source>PJC</source>]</p>

<p><ent>Telemeteorograph</ent><br/
<hw>Tel`e*me`te*or"o*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>meteorograph</ets>.]</ety> <def>Any apparatus recording meteorological phenomena at a distance from the measuring apparatus, as by electricity or by compressed air; esp., an apparatus recording conditions at many distant stations at a central office.</def> -- <wordforms><wf>Tel`e*me`te*or*o*graph"ic</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telemeter</ent><br/
<hw>Te*lem"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far + <ets>-meter</ets>.]</ety> <sn>1.</sn> <def>An instrument used for measuring the distance of an object from an observer; <as>as, a telescope with a micrometer for measuring the apparent diameter of an object whose real dimensions are known</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A measuring instrument which sends the information obtained from its sensors by radio to a distant station, usually to be recorded there; also, the complete system including measuring instrument, transmitter, and receiver.  Such instruments are used, for example, to measure conditions in space or in other locations difficult of access for humans observers, or merely to allow one observer to monitor conditions in many places simultaneously.</def><br/
[<source>PJC</source>]</p>

<p><ent>Telemetrograph</ent><br/
<hw>Tel`e*met"ro*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <grk>me`tron</grk> measure + <ets>-graph</ets>.]</ety> <def>A combination of the camera lucida and telescope for drawing and measuring distant objects.</def> -- <wordforms><wf>Tel`e*me*trog"ra*phy</wf> <pr>(#)</pr>, <pos>n.</pos> -- <wf>Tel`e*met`ro*graph"ic</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telemetry</ent><br/
<hw>Te*lem"e*try</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The science or process of making remote measurements and sending the data by radio; the use of a telemeter.</def><br/
[<source>PJC</source>]</p>

<p><ent>Telemotor</ent><br/
<hw>Tel`e*mo"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>motor</ets>.]</ety> <fld>(Naut.)</fld> <def>A hydraulic device by which the movement of the wheel on the bridge operates the steering gear at the stern.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>telencephalon</ent><br/
<hw>telencephalon</hw> <pos>n.</pos> <sn>1.</sn> <def>the anterior division of the forebrain; the cerebrum and related parts of the hypothalamus.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Telenergy</ent><br/
<hw>Tel*en"er*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>energy</ets>.]</ety> <def>Display of force or energy at a distance, or without contact; now more commonly called <altname>telekinesis</altname>; -- applied to mediumistic phenomena.</def> -- <wordforms><wf>Tel`en*er"gic</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telengiscope</ent><br/
<hw>Te*len"gi*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <?/ near + <ets>-scope</ets>.]</ety> <fld>(Optics)</fld> <def>An instrument of such focal length that it may be used as an observing telescope for objects close at hand or as a long-focused microscope.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Teleocephali</ent><br/
\'d8<hw>Te`le*o*ceph"a*li</hw> <pr>(t<emac/`l<esl/*<osl/*s<ecr/f"<adot/*l<imac/ <it>or</it> t<ecr/`l<esl/*<osl/*s<ecr/f"<adot/*l<imac/)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>te`leos</grk> complete + <grk>kefalh`</grk> head.]</ety> <fld>(Zool.)</fld> <def>An extensive order of bony fishes including most of the common market species, as bass, salmon, cod, perch, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleological</ent><br/
<hw>Te`le*o*log"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>t<eacute/l<eacute/ologique</ets>.]</ety> <sn>1.</sn> <fld>(Biol.)</fld> <def>Of or pertaining to teleology, or the doctrine of design.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>showing evidence of design or purpose, especially in natural phenomena.</def><br/
[<source>PJC</source>]</p>

<p> -- <wordforms><wf>Te`le*o*log"ic*al*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleologist</ent><br/
<hw>Te`le*ol"o*gist</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Biol.)</fld> <def>One versed in teleology.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleology</ent><br/
<hw>Te`le*ol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/, <grk>teleos</grk>, the end or issue + <ets>-logy</ets>: cf. F. <ets>t<eacute/l<eacute/ologie</ets>.]</ety> <def>The doctrine of the final causes of things</def>; specif. <fld>(Biol.)</fld>, <def>the doctrine of design, which assumes that the phenomena of organic life, particularly those of evolution, are explicable only by purposive causes, and that they in no way admit of a mechanical explanation or one based entirely on biological science; the doctrine of adaptation to purpose.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleophore</ent><br/
<hw>Te"le*o*phore`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>teleos</grk> complete + <grk>fe`rein</grk> to bear.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Gonotheca</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleorganic</ent><br/
<hw>Te`le*or*gan"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>teleos</grk> complete + E. <ets>organic</ets>.]</ety> <fld>(Physiol.)</fld> <def>Vital; <as>as, <ex>teleorganic</ex> functions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleosaur</ent><br/
<hw>Te`le*o*saur"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Paleon.)</fld> <def>Any one of several species of fossil suarians belonging to Teleosaurus and allied genera. These reptiles are related to the crocodiles, but have biconcave vertebrae.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleosaurus</ent><br/
\'d8<hw>Te`le*o*sau"rus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ complete, perfect + <?/ a lizard.]</ety> <fld>(Paleon.)</fld> <def>A genus of extinct crocodilian reptiles of the Jurassic period, having a long and slender snout.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleost</ent><br/
<hw>Te"le*ost</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ complete + <?/ bone.]</ety> <fld>(Zool.)</fld> <def>One of the Teleosti. Also used adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleostean</ent><br/
<hw>Te`le*os"te*an</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Of or pertaining to the teleosts.</def> -- <def2><pos>n.</pos> <def>A teleostean fish.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleostei</ent><br/
\'d8<hw>Te`le*os"te*i</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <?/ complete + <?/ bone.]</ety> <fld>(Zool.)</fld> <def>A subclass of fishes including all the ordinary bony fishes as distinguished from the ganoids.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1481 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleostomi</ent><br/
\'d8<hw>Te"le*os`to*mi</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <?/ complete + <?/ mouth.]</ety> <fld>(Zool.)</fld> <def>An extensive division of fishes including the ordinary fishes (Teleostei) and the ganoids.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleozoic</ent><br/
<hw>Te`le*o*zo"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Having tissued composed of cells.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleozoon</ent><br/
<hw>Te*le*o*zo"on</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A metazoan.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telepathy</ent><br/
<hw>Te*lep"a*thy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far off + <?/, <?/, to suffer.]</ety> <def>The sympathetic affection of one mind by the thoughts, feelings, or emotions of another at a distance, without communication through the ordinary channels of sensation.</def> <note>The existence of this ability has not been proven scientifically.</note>-- <wordforms><wf>Tel`e*path"ic</wf>, <pos>a.</pos> -- <wf>Te*lep"a*thist</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Telepheme</ent><br/
<hw>Tel"e*pheme</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ afar + <?/ a saying.]</ety> <def>A message by a telephone.</def> <mark>[Recent]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telephone</ent><br/
<hw>Tel"e*phone</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far off + <?/ sound.]</ety> <fld>(Physics)</fld> <def>An instrument for reproducing sounds, especially articulate speech, at a distance.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The ordinary telephone consists essentially of a device by which currents of electricity, produced by sounds through the agency of certain mechanical devices and exactly corresponding in duration and intensity to the vibrations of the air which attend them, are transmitted to a distant station, and there, acting on suitable mechanism, reproduce similar sounds by repeating the vibrations. The necessary variations in the electrical currents are usually produced by means of a microphone attached to a thin diaphragm upon which the voice acts, and are intensified by means of an induction coil. In the <xex>magnetic telephone</xex>, or <xex>magneto-telephone</xex>, the diaphragm is of soft iron placed close to the pole of a magnet upon which is wound a coil of fine wire, and its vibrations produce corresponding vibrable currents in the wire by induction. The <xex>mechanical</xex>, or <xex>string</xex>, <xex>telephone</xex> is a device in which the voice or sound causes vibrations in a thin diaphragm, which are directly transmitted along a wire or string connecting it to a similar diaphragm at the remote station, thus reproducing the sound. It does not employ electricity.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telephone</ent><br/
<hw>Tel"e*phone</hw>, <pos>v. t.</pos> <def>To convey or announce by telephone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telephone exchange</ent><br/
<hw>Tel`e*phone ex*change"</hw>. <def>A central office in which the  wires of telephones from local subscribers may be connected by switches to other local telephones or to long-distance lines, to permit transmission of conversation or data.</def> <note>In the late 1990's the traditional copper wires connecting local telephones to the telephone exchange have begun to be replaced with optical fiber connections.</note><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Telephonic</ent><br/
<hw>Tel`e*phon"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>t<eacute/l<eacute/phonique</ets>. See <er>Telephone</er>.]</ety> <sn>1.</sn> <def>Conveying sound to a great distance.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to the telephone; by the telephone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telephonically</ent><br/
<hw>Tel`e*phon"ic*al*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>By telephonic means or processes; by the use of the telephone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telephony</ent><br/
<hw>Te*leph"o*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The art or process of reproducing sounds at a distance, as with the telephone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telephote</ent><br/
<hw>Tel"e*phote</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <grk>fw^s</grk>, <grk>fwto`s</grk>, light.]</ety> <def>A telelectric apparatus for producing images of visible objects at a distance.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telephoto</ent><br/
<hw>Tel`e*pho"to</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>of or relating to photography with a <er>telephoto lens</er>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>of or pertaining to a <er>telephoto lens</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>telephoto</ent><br/
<hw>telephoto</hw> <pos>n.</pos> <sn>1.</sn> <def>a <er>telephoto lens</er>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>a photograph taken using a <er>telephoto lens</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Telephotograph</ent><br/
<hw>Tel`e*pho"to*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>photograph</ets>.]</ety> <def>a photograph transmitted and reproduced by telephotography.</def><br/
[<source>Webster 1913 Suppl.</source> + <source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>a photograph made with a telephoto lens.</def><br/
<syn><b>Syn. --</b> telephoto.</syn><br/
[<source>Webster 1913 Suppl.</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Telephotographic</ent><br/
<hw>Tel`e*pho`to*graph"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Designating, or pertaining to, the process of telephotography.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telephotography</ent><br/
<hw>Tel`e*pho*tog"ra*phy</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The photography of distant objects in more enlarged form than is possible by the ordinary means, usually by a camera provided with a <er>telephoto lens</er> or mounted in place of the eyepiece of a telescope, so that the real or a magnified image falls on the sensitive plate.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>Art or process of electrically transmitting and reproducing photographic or other pictures at a distance, especially by methods similar to those used in electric telegraphy.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <def>Less properly, phototelegraphy.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telephoto lens</ent><br/
<hw>Tel`e*pho"to lens</hw> <pos>n.</pos> <def>a special compound camera lens with a long effective focal length but used in a camera with a short focal length, allowing large images to be obtained of distant objects when used in a camera in place of an ordinary lens; -- called also <altname>telephotographic lens</altname>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Telepolariscope</ent><br/
<hw>Tel`e*po*lar"i*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far off + E. <ets>polariscope</ets>.]</ety> <fld>(Opt.)</fld> <def>A polariscope arranged to be attached to a telescope.</def>  <rj><au>Lockyer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telerythin</ent><br/
<hw>Tel`e*ryth"in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ end + E. <ets>erythrin</ets>.]</ety> <fld>(Chem.)</fld> <def>A red crystalline compound related to, or produced from, erythrin. So called because regarded as the end of the series of erythrin compounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telescope</ent><br/
<hw>Tel"e*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ viewing afar, farseeing; <?/ far, far off + <?/ a watcher, akin to <?/ to view: cf. F. <ets>t<eacute/lescope</ets>. See <er>Telegraph</er>, and <er>-scope</er>.]</ety> <def>An optical instrument used in viewing distant objects, as the heavenly bodies.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A telescope assists the eye chiefly in two ways; first, by enlarging the visual angle under which a distant object is seen, and thus magnifying that object; and, secondly, by collecting, and conveying to the eye, a larger beam of light than would enter the naked organ, thus rendering objects distinct and visible which would otherwise be indistinct and or invisible. Its essential parts are the <xex>object glass</xex>, or <xex>concave mirror</xex>, which collects the beam of light, and forms an image of the object, and the <xex>eyeglass</xex>, which is a microscope, by which the image is magnified.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Achromatic telescope</b></col>. <cd>See under <er>Achromatic</er>.</cd> -- <col><b>Aplanatic telescope</b></col>, <cd>a telescope having an aplanatic eyepiece.</cd> -- <col><b>Astronomical telescope</b></col>, <cd>a telescope which has a simple eyepiece so constructed or used as not to reverse the image formed by the object glass, and consequently exhibits objects inverted, which is not a hindrance in astronomical observations.</cd> -- <col><b>Cassegrainian telescope</b></col>, <cd>a reflecting telescope invented by <etsep>Cassegrain</etsep>, which differs from the Gregorian only in having the secondary speculum convex instead of concave, and placed nearer the large speculum. The Cassegrainian represents objects inverted; the Gregorian, in their natural position. The Melbourne telescope (see <xex>Illust.</xex> under <cref>Reflecting telescope</cref>, below) is a Cassegrainian telescope.</cd> -- <col><b>Dialytic telescope</b></col>. <cd>See under <er>Dialytic</er>.</cd> -- <col><b>Equatorial telescope</b></col>. <cd>See the Note under <er>Equatorial</er>.</cd> -- <col><b>Galilean telescope</b></col>, <cd>a refracting telescope in which the eyeglass is a concave instead of a convex lens, as in the common opera glass. This was the construction originally adopted by <etsep>Galileo</etsep>, the inventor of the instrument. It exhibits the objects erect, that is, in their natural positions.</cd> -- <col><b>Gregorian telescope</b></col>, <cd>a form of reflecting telescope. See under <er>Gregorian</er>.</cd> -- <col><b>Herschelian telescope</b></col>, <cd>a reflecting telescope of the form invented by Sir William <etsep>Herschel</etsep>, in which only one speculum is employed, by means of which an image of the object is formed near one side of the open end of the tube, and to this the eyeglass is applied directly.</cd> -- <col><b>Newtonian telescope</b></col>, <cd>a form of reflecting telescope. See under <er>Newtonian</er>.</cd> -- <col><b>Photographic telescope</b></col>, <cd>a telescope specially constructed to make photographs of the heavenly bodies.</cd> -- <col><b>Prism telescope</b></col>. <cd>See <er>Teinoscope</er>.</cd> -- <col><b>Reflecting telescope</b></col>, <cd>a telescope in which the image is formed by a speculum or mirror (or usually by two speculums, a large one at the lower end of the telescope, and the smaller one near the open end) instead of an object glass. See <cref>Gregorian, Cassegrainian, Herschelian, <and/ Newtonian, telescopes</cref>, above.</cd> -- <col><b>Refracting telescope</b></col>, <cd>a telescope in which the image is formed by refraction through an object glass.</cd> -- <col><b>Telescope carp</b></col> <fld>(Zool.)</fld>, <cd>the telescope fish.</cd> -- <col><b>Telescope fish</b></col> <fld>(Zool.)</fld>, <cd>a monstrous variety of the goldfish having very protuberant eyes.</cd> -- <col><b>Telescope fly</b></col> <fld>(Zool.)</fld>, <cd>any two-winged fly of the genus <gen>Diopsis</gen>, native of Africa and Asia. The telescope flies are remarkable for having the eyes raised on very long stalks.</cd> -- <col><b>Telescope shell</b></col> <fld>(Zool.)</fld>, <cd>an elongated gastropod (<spn>Cerithium telescopium</spn>) having numerous flattened whorls.</cd> -- <col><b>Telescope sight</b></col> <fld>(Firearms)</fld>, <cd>a slender telescope attached to the barrel, having cross wires in the eyepiece and used as a sight.</cd> -- <col><b>Terrestrial telescope</b></col>, <cd>a telescope whose eyepiece has one or two lenses more than the astronomical, for the purpose of inverting the image, and exhibiting objects erect.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telescope</ent><br/
<hw>Tel"e*scope</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Telescoped</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Telescoping</conjf> <pr>(?)</pr>.]</vmorph> <def>To slide or pass one within another, after the manner of the sections of a small telescope or spyglass; to come into collision, as railway cars, in such a manner that one runs into another; to become compressed in the manner of a telescope, due to a collision or other force.</def> <mark>[Recent]</mark><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Telescope</ent><br/
<hw>Tel"e*scope</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To cause to come into collision, so as to telescope.</def> <mark>[Recent]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>to shorten or abridge significantly; <as>as, to <ex>telescope</ex> a whole semester's lectures into one week</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Telescope</ent><br/
<hw>Tel"e*scope</hw> <pr>(t<ecr/l"<esl/*sk<omac/p)</pr>, <pos>a.</pos> <def>Capable of being extended or compacted, like a telescope, by the sliding of joints or parts one within the other; telescopic; <as>as, a <ex>telescope</ex> bag; <ex>telescope</ex> table, etc.; -- now more commonly replaced by the term <altname>telescoping</altname>.</as></def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telescope bag</ent><br/
<hw>Telescope bag</hw>. <def>An adjustable traveling bag consisting of two cases, the larger slipping over the other.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telescopical</ent><br/
<ent>Telescopic</ent><br/
<mhw>{ <hw>Tel`e*scop"ic</hw> <pr>(?)</pr>, <hw>Tel`e*scop"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>t<eacute/lescopique</ets>.]</ety> <sn>1.</sn> <def>Of or pertaining to a telescope; performed by a telescope.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Seen or discoverable only by a telescope; <as>as, <ex>telescopic</ex> stars</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Able to discern objects at a distance; farseeing; far-reaching; <as>as, a <ex>telescopic</ex> eye; <ex>telescopic</ex> vision</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Having the power of extension by joints sliding one within another, like the tube of a small telescope or a spyglass; especially <fld>(Mach.)</fld>, constructed of concentric tubes, either stationary, as in the <xex>telescopic</xex> boiler, or movable, as in the <xex>telescopic</xex> chimney of a war vessel, which may be put out of sight by being lowered endwise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telescopically</ent><br/
<hw>Tel`e*scop"ic*al*ly</hw>, <pos>adv.</pos> <def>In a telescopical manner; by or with the telescope.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telescopic sight</ent><br/
<hw>Tel`e*scop"ic sight`</hw>. <def>A sight consisting of a small telescope, as on a compass or rifle.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telescoping</ent><br/
<hw>Tel"e*scop`ing</hw> <pr>(t<ecr/l"<esl/*sk<omac/p`<icr/ng)</pr>, <pos>a.</pos> <def>Capable of being extended or compacted, like a telescope, by the sliding of sections or parts one within the other; telescopic; <as>as, <ex>telescoping</ex> tripod legs; a <ex>telescoping</ex> table, etc.</as>; -- a term replacing the formerly used <altname>telescope</altname>.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Telescopist</ent><br/
<hw>Te*les"co*pist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who uses a telescope.</def>  <rj><au>R. A. Proctor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telescopy</ent><br/
<hw>Te*les"co*py</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The art or practice of using or making telescopes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleseism</ent><br/
<hw>Tel"e*seism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <?/ shock.]</ety> <def>A seismic movement or shock far from the  recording instrument.</def> -- <wordforms><wf>Tel`e*seis"mic</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Teleseme</ent><br/
<hw>Tel"e*seme</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <?/ sign.]</ety> <def>A system of apparatus for electric signals providing for automatic transmission of a definite number of different signals or calls, as in connection with hotel annunciators.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telesm</ent><br/
<hw>Tel"esm</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Ar. <ets>tilism</ets>. See <er>Talisman</er>.]</ety> <def>A kind of amulet or magical charm.</def> <mark>[Obs.]</mark>  <rj><au>J. Gregory.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telesmatical</ent><br/
<ent>Telesmatic</ent><br/
<mhw>{ <hw>Tel`es*mat"ic</hw> <pr>(?)</pr>, <hw>Tel`es*mat"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <def>Of or pertaining to telesms; magical.</def>  <rj><au>J. Gregory.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telespectroscope</ent><br/
<hw>Tel`e*spec"tro*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far off + E. <ets>spectroscope</ets>.]</ety> <fld>(Astron.)</fld> <def>A spectroscope arranged to be attached to a telescope for observation of distant objects, as the sun or stars.</def>  <rj><au>Lockyer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telestereograph</ent><br/
<hw>Tel`e*ste"re*o*graph`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>stereograph</ets>.]</ety> <def>An instrument for telegraphically reproducing a photograph.</def> -- <wordforms><wf>Tel`e*ste`re*og"ra*phy</wf> <pr>(#)</pr>, <pos>n.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telestereoscope</ent><br/
<hw>Tel`e*ste"re*o*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far off + E. <ets>stereoscope</ets>.]</ety> <fld>(Opt.)</fld> <def>A stereoscope adapted to view distant natural objects or landscapes; a telescopic stereoscope.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telestic</ent><br/
<hw>Te*les"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/ fit for finishing, from <?/ to finish.]</ety> <def>Tending or relating to a purpose or an end.</def> <mark>[R.]</mark>  <rj><au>Cudworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telestich</ent><br/
<hw>Te*les"tich</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ the end + <?/ a line, verse.]</ety> <def>A poem in which the final letters of the lines, taken consequently, make a name.  Cf. <er>Acrostic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telethermograph</ent><br/
<hw>Tel`e*ther"mo*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>thermo-</ets> + <ets>-graph</ets>.]</ety> <fld>(Physics)</fld> <sd>(a)</sd> <def>A record of fluctuations of temperature made automatically at a distant station.</def> <sd>(b)</sd> <def>An instrument, usually electrical, making such records.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telethermometer</ent><br/
<hw>Tel`e*ther*mom"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far off + E. <ets>thermometer</ets>.]</ety> <fld>(Physics)</fld> <def>An apparatus for determining the temperature of a distant point, as by a thermoelectric circuit or otherwise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teleutospore</ent><br/
<hw>Te*leu"to*spore</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ completion + E. <ets>spore</ets>.]</ety> <fld>(Bot.)</fld> <def>The thick-celled winter or resting spore of the rusts (order <ord>Uredinales</ord>), produced in late summer. See <xex>Illust.</xex> of <er>Uredospore</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telford</ent><br/
<hw>Tel"ford</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[After Thomas <etsep>Telford</etsep>, a Scotch road engineer.]</ety> <def>Designating, or pert. to, a road pavement having a surface of small stone rolled hard and  smooth, distinguished from macadam road by its firm foundation of large stones with fragments of stone wedged tightly, in the interstices; <as>as, <ex>telford</ex> pavement, road, etc.</as></def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telfordize</ent><br/
<hw>Tel"ford*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos>  <vmorph>[<pos>imp. & p. p.</pos> <conjf>Telfordized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Telfordizing</conjf> <pr>(?)</pr>.]</vmorph> <def>To furnish (a road) with a telford pavement.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telharmonic</ent><br/
<hw>Tel`har*mon"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to telharmonium.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telharmony</ent><br/
<ent>Telharmonium</ent><br/
<hw>Tel`har*mo"ni*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>th^le</grk> far + <ets>harmolium</ets>.]</ety> <def>An instrument for producing music (<hw>Tel*har"mo*ny</hw> [<pr><?/</pr>]), at a distant point or points by means of alternating currents of electricity controlled by an operator who plays on a keyboard. The music is produced by a receiving instrument similar or analogous to the telephone, but not held to the ear. The pitch corresponds with frequency of alternation of current.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telic</ent><br/
<hw>Tel"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/, from <?/ the end.]</ety> <fld>(Gram.)</fld> <def>Denoting the final end or purpose, as distinguished from <contr>ecbatic</contr>. See <er>Ecbatic</er>.</def>  <rj><au>Gibbs.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tell</ent><br/
<hw>Tell</hw> <pr>(t<ecr/l)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Told</conjf> <pr>(t<omac/ld)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Telling</conjf>.]</vmorph> <ety>[AS. <ets>tellan</ets>, from <ets>talu</ets> tale, number, speech; akin to D. <ets>tellen</ets> to count, G. <ets>z<aum/hlen</ets>, OHG. <ets>zellen</ets> to count, tell, say, Icel. <ets>telja</ets>, Dan. <ets>tale</ets> to speak, <ets>t<ae/lle</ets> to count. See <er>Tale</er> that which is told.]</ety> <sn>1.</sn> <def>To mention one by one, or piece by piece; to recount; to enumerate; to reckon; to number; to count; <as>as, to <ex>tell</ex> money</as>.</def> <ldquo/An heap of coin he <xex>told</xex>.<rdquo/  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>telleth</qex> the number of the stars.</q> <rj><qau>Ps. cxlvii. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tell</qex> the joints of the body.</q> <rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To utter or recite in detail; to give an account of; to narrate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Of which I shall <qex>tell</qex> all the array.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And not a man appears to <qex>tell</qex> their fate.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To make known; to publish; to disclose; to divulge.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Why didst thou not <qex>tell</qex> me that she was thy wife?</q> <rj><qau>Gen. xii. 18.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To give instruction to; to make report to; to acquaint; to teach; to inform.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A secret pilgrimage,<br/
That you to-day promised to <qex>tell</qex> me of?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To order; to request; to command.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>told</qex> her not to be frightened.</q> <rj><qau>Dickens.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To discern so as to report; to ascertain by observing; to find out; to discover; <as>as, I can not <ex>tell</ex> where one color ends and the other begins</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To make account of; to regard; to reckon; to value; to estimate.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I ne <qex>told</qex> no dainity of her love.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Tell</xex>, though equivalent in some respect to <xex>speak</xex> and <xex>say</xex>, has not always the same application. We say, to <xex>tell</xex> truth or falsehood, to <xex>tell</xex> a number, to <xex>tell</xex> the reasons, to <xex>tell</xex> something or nothing; but we never say, to <xex>tell</xex> a speech, discourse, or oration, or to <xex>tell</xex> an argument or a lesson. It is much used in commands; <as>as, <ex>tell</ex> me the whole story; <ex>tell</ex> me all you know</as>.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To tell off</b></col>, <cd>to count; to divide.</cd> <au>Sir W. Scott.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To communicate; impart; reveal; disclose; inform; acquaint; report; repeat; rehearse; recite.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tell</ent><br/
<hw>Tell</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To give an account; to make report.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That I may publish with the voice of thankgiving, and <qex>tell</qex> of all thy wondrous works.</q> <rj><qau>Ps. xxvi. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To take effect; to produce a marked effect; <as>as, every shot <ex>tells</ex>; every expression <ex>tells</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To tell of</b></col>. <sd>(a)</sd> <cd>To speak of; to mention; to narrate or describe.</cd> <sd>(b)</sd> <cd>To inform against; to disclose some fault of.</cd> -- <col><b>To tell on</b></col>, <cd>to inform against.</cd> <mark>[Archaic & Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>Lest they should <qex>tell on</qex> us, saying, So did David.</q> <rj><qau>1 Sam. xxvii. 11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tell</ent><br/
<hw>Tell</hw>, <pos>n.</pos> <def>That which is told; tale; account.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I am at the end of my <qex>tell</qex>.</q> <rj><qau>Walpole.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tell</ent><br/
<hw>Tell</hw>, <pos>n.</pos> <ety>[Ar.]</ety> <def>A hill or mound.</def>  <rj><au>W. M. Thomson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellable</ent><br/
<hw>Tell"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being told.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellen</ent><br/
<hw>Tel"len</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Any species of Tellina.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teller</ent><br/
<hw>Tell"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who tells, relates, or communicates; an informer, narrator, or describer.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of four officers of the English Exchequer, formerly appointed to receive moneys due to the king and to pay moneys payable by the king.</def>  <rj><au>Cowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An employee of a bank who receives money paid in, and pays money out, and makes records of such transactions.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>4.</sn> <def>One who is appointed to count the votes given in a legislative body, public meeting, assembly, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellership</ent><br/
<hw>Tell"er*ship</hw>, <pos>n.</pos> <def>The office or employment of a teller.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellina</ent><br/
\'d8<hw>Tel*li"na</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ a kind of shellfish.]</ety> <fld>(Zool.)</fld> <def>A genus of marine bivalve mollusks having thin, delicate, and often handsomely colored shells.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telling</ent><br/
<hw>Tell"ing</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Operating with great effect; effective; <as>as, a <ex>telling</ex> speech</as>.</def> -- <wordforms><wf>Tell"ing*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telltale</ent><br/
<hw>Tell"tale`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Telling tales; babbling.</def> <ldquo/The <xex>telltale</xex> heart.<rdquo/  <rj><au>Poe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telltale</ent><br/
<hw>Tell"tale`</hw>, <pos>n.</pos> <sn>1.</sn> <def>One who officiously communicates information of the private concerns of others; one who tells that which prudence should suppress.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>A movable piece of ivory, lead, or other material, connected with the bellows of an organ, that gives notice, by its position, when the wind is exhausted.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Naut.)</fld> <sd>(a)</sd> <def>A mechanical attachment to the steering wheel, which, in the absence of a tiller, shows the position of the helm.</def> <sd>(b)</sd> <def>A compass in the cabin of a vessel, usually placed where the captain can see it at all hours, and thus inform himself of the vessel's course.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mach.)</fld> <def>A machine or contrivance for indicating or recording something, particularly for keeping a check upon employees, as factory hands, watchmen, drivers, check takers, and the like, by revealing to their employers what they have done or omitted.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Zool.)</fld> <def>The tattler. See <er>Tattler</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A thing that serves to disclose something or give information; a hint or indication.</def></p>

<p><q>It supplies many useful links and <qex>telltales</qex>.</q>  <rj><qau>Saintsbury.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>7.</sn>  <fld>(Railroads)</fld> <def>An arrangement consisting of long strips, as of rope, wire, or leather, hanging from a bar over railroad tracks, in such a position as to warn freight brakemen of their approach to a low overhead bridge.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><-- p. 1482 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellural</ent><br/
<hw>Tel*lu"ral</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tellus</ets>, <ets>-uris</ets>, the earth.]</ety> <def>Of or pertaining to the earth.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellurate</ent><br/
<hw>Tel"lu*rate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tellurate</ets>. See <er>Tellurium</er>.]</ety> <fld>(Chem.)</fld> <def>A salt of telluric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telluret</ent><br/
<hw>Tel"lu*ret</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A telluride.</def> <mark>[Obsoles.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellureted</ent><br/
<hw>Tel"lu*ret`ed</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>Combined or impregnated with tellurium; tellurized.</def> <altsp>[Written also <asp>telluretted</asp>.]</altsp> <mark>[Obsoles.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tellureted hydrogen</b></col> <fld>(Chem.)</fld>, <cd>hydrogen telluride, <chform>H2Te</chform>, a gaseous substance analogous to hydrogen sulphide; -- called also <altname>tellurhydric acid</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellurhydric</ent><br/
<hw>Tel`lur*hy"dric</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, hydrogen telluride, which is regarded as an acid, especially when in solution.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellurian</ent><br/
<hw>Tel*lu"ri*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tellus</ets>, <ets>-uris</ets>, the earth.]</ety> <def>Of or pertaining to the earth.</def>  <rj><au>De Quincey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellurian</ent><br/
<hw>Tel*lu"ri*an</hw>, <pos>n.</pos> <sn>1.</sn> <def>A dweller on the earth.</def>  <rj><au>De Quincey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An instrument for showing the operation of the causes which produce the succession of day and night, and the changes of the seasons.</def> <altsp>[Written also <asp>tellurion</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telluric</ent><br/
<hw>Tel*lu"ric</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tellus</ets>, <ets>-uris</ets>, the earth: cf. F. <ets>tellurique</ets>.]</ety> <sn>1.</sn> <def>Of or pertaining to the earth; proceeding from the earth.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Amid these hot, <qex>telluric</qex> flames.</q> <rj><qau>Carlyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>Of or pertaining to tellurium; derived from, or resembling, tellurium; specifically, designating those compounds in which the element has a higher valence as contrasted with <contr>tellurous</contr> compounds; <as>as, <ex>telluric acid</ex>, which is analogous to sulphuric acid</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Telluric bismuth</b></col> <fld>(Min.)</fld>, <cd>tetradymite.</cd> -- <col><b>Telluric silver</b></col> <fld>(Min.)</fld>, <cd>hessite.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telluride</ent><br/
<hw>Tel"lu*ride</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A compound of tellurium with a more positive element or radical; -- formerly called <altname>telluret</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellurism</ent><br/
<hw>Tel"lu*rism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An hypothesis of animal magnetism propounded by Dr. Keiser, in Germany, in which the phenomena are ascribed to the agency of a telluric spirit or influence.</def> <mark>[R.]</mark>  <rj><au>S. Thompson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellurite</ent><br/
<hw>Tel"lu*rite</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Chem.)</fld> <def>A salt of tellurous acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Min.)</fld> <def>Oxide of tellurium. It occurs sparingly in tufts of white or yellowish crystals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellurium</ent><br/
<hw>Tel*lu"ri*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., from L. <ets>tellus</ets>, <ets>-uris</ets>, the earth.]</ety> <fld>(Chem.)</fld> <def>A rare nonmetallic element, analogous to sulphur and selenium, occasionally found native as a substance of a silver-white metallic luster, but usually combined with metals, as with gold and silver in the mineral sylvanite, with mercury in Coloradoite, etc. Symbol Te. Atomic weight 125.2.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Graphic tellurium</b></col>. <fld>(Min.)</fld> <cd>See <er>Sylvanite</er>.</cd> -- <col><b>Tellurium glance</b></col> <fld>(Min.)</fld>, <cd>nagyagite; -- called also <altname>black tellurium</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellurize</ent><br/
<hw>Tel"lu*rize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <fld>(Chem.)</fld> <def>To impregnate with, or to subject to the action of, tellurium; -- chiefly used adjectively in the past participle; <as>as, <ex>tellurized</ex> ores</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tellurous</ent><br/
<hw>Tel"lu*rous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of or pertaining to tellurium; derived from, or containing, tellurium; specifically, designating those compounds in which the element has a lower valence as contrasted with <contr>telluric</contr> compounds; <as>as, <ex>tellurous acid</ex>, which is analogous to sulphurous acid</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telodynamic</ent><br/
<hw>Tel`o*dy*nam"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/ far + E. <ets>dynamic</ets>.]</ety> <def>Relating to a system for transmitting power to a distance by means of swiftly moving ropes or cables driving grooved pulleys of large diameter.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teloogoo</ent><br/
<hw>Tel`oo*goo"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Telugu</er>.</def>  <rj><au>D. O. Allen.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telotrocha</ent><br/
\'d8<hw>Te*lot"ro*cha</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Telotrochae</plw> <pr>(#)</pr>.</plu> <ety>[NL. See <er>Telotrochal</er>.]</ety> <fld>(Zool.)</fld> <def>An annelid larva having telotrochal bands of cilia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telotrochous</ent><br/
<ent>Telotrochal</ent><br/
<mhw>{ <hw>Te*lot"ro*chal</hw> <pr>(?)</pr>, <hw>Te*lot"ro*chous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Gr. <?/ complete + <?/ wheel, hoop.]</ety> <fld>(Zool.)</fld> <def>Having both a preoral and a posterior band of cilla; -- applied to the larvae of certain annelids.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telotype</ent><br/
<hw>Tel"o*type</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far off + <ets>-type</ets>.]</ety> <def>An electric telegraph which prints the messages in letters and not in signs.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telpher</ent><br/
<hw>Tel"pher</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ far, far off + <grk>fe`rein</grk> to bear.]</ety> <sn>1.</sn> <fld>(Elec.)</fld> <def>A contrivance for the conveyance of vehicles or loads by means of electricity.</def>  <rj><au>Fleeming Jenkin.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Elec.)</fld> <def>Specif., the equipment or apparatus used in a system of electric transportation by means of carriages which are suspended on an overhead conductor, as of wire.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><mcol><col><b>Telpher line</b></col>, <it>or</it> <col><b>Telpher road</b></col></mcol>, <cd>an electric line or road over which vehicles for carrying loads are moved by electric engines actuated by a current conveyed by the line.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telpherage</ent><br/
<hw>Tel"pher*age</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The conveyance of vehicles or loads by means of electricity.</def>  <rj><au>Fleeming Jenkin.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Elec.)</fld> <def>Specif., electric transportation of goods by means of carriages suspended on overhead conductors, as of wire, the power being conveyed to the motor carriage by the wires on which it runs. <ex>Telpherage</ex> and <xex>telpher</xex> are sometimes applied to such systems in which the motive power is not electricity.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Telson</ent><br/
<hw>Tel"son</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Telsons</plw> <pr>(#)</pr>.</plu> <ety>[NL., fr. Gr. <?/ a boundary, limit.]</ety> <fld>(Zool.)</fld> <def>The terminal joint or movable piece at the end of the abdomen of Crustacea and other articulates. See <er>Thoracostraca</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telugu</ent><br/
<hw>Tel`u*gu"</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A Darvidian language spoken in the northern parts of the Madras presidency. In extent of use it is the next language after Hindustani (in its various forms) and Bengali.</def> <altsp>[Spelt also <asp>Teloogoo</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of the people speaking the Telugu language.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Telugu</ent><br/
<hw>Tel`u*gu"</hw>, <pos>a.</pos> <def>Of or pertaining to the Telugu language, or the Telugus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temblor</ent><br/
\'d8<hw>Tem*blor"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp.]</ety> <def>An earthquake.</def> <mark>[Western U. S.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Temerarious</ent><br/
<hw>Tem`er*a"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>temerarius</ets>. See <er>Temerity</er>.]</ety> <def>Unreasonably adventurous; despising danger; rash; headstrong; audacious; reckless; heedless.</def> -- <wordforms><wf>Tem`er*a"ri*ous*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>I spake against <qex>temerarious</qex> judgment.</q> <rj><qau>Latimer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temeration</ent><br/
<hw>Tem`er*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>temerare</ets> to defile.]</ety> <def>Temerity.</def> <mark>[Obs.]</mark>  <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temerity</ent><br/
<hw>Te*mer"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>temeritas</ets>, from <ets>temere</ets> by chance, rashly; perhaps akin to Skr. <ets>tamas</ets> darkness: cf. F. <ets>t<eacute/m<eacute/rit<eacute/</ets>.]</ety> <def>Unreasonable contempt of danger; extreme venturesomeness; rashness; <as>as, the <ex>temerity</ex> of a commander in war</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Rashness; precipitancy; heedlessness; venturesomeness.</syn> <usage> -- <er>Temerity</er>, <er>Rashness</er>. These words are closely allied in sense, but have a slight difference in their use and application. <xex>Temerity</xex> is Latin, and <xex>rashness</xex> is Anglo-Saxon. As in many such cases, the Latin term is more select and dignified; the Anglo-Saxon more familiar and energetic. We show <xex>temerity</xex> in hasty decisions, and the conduct to which they lead. We show <xex>rashness</xex> in particular actions, as dictated by sudden impulse. It is an exhibition of <xex>temerity</xex> to approach the verge of a precipice; it is an act of <xex>rashness</xex> to jump into a river without being able to swim. <xex>Temerity</xex>, then, is an unreasonable contempt of danger; <xex>rashness</xex> is a rushing into danger from thoughtlessness or excited feeling.</usage><br/
[<source>1913 Webster</source>]</p>

<p><q>It is notorious <qex>temerity</qex> to pass sentence upon grounds uncapable of evidence.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Her <qex>rush</qex> hand in evil hour<br/
Forth reaching to the fruit, she plucked, she eat.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temerous</ent><br/
<hw>Tem"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Temerarious.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempean</ent><br/
<hw>Tem*pe"an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to Temple, a valley in Thessaly, celebrated by Greek poets on account of its beautiful scenery; resembling Temple; hence, beautiful; delightful; charming.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temper</ent><br/
<hw>Tem"per</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tempered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tempering</conjf>.]</vmorph> <ety>[AS. <ets>temprian</ets> or OF. <ets>temper</ets>, F. <ets>temp<eacute/rer</ets>, and (in sense 3) <ets>temper</ets>, L. <ets>temperare</ets>, akin to <ets>tempus</ets> time.  Cf. <er>Temporal</er>, <er>Distemper</er>, <er>Tamper</er>.]</ety> <sn>1.</sn> <def>To mingle in due proportion; to prepare by combining; to modify, as by adding some new element; to qualify, as by an ingredient; hence, to soften; to mollify; to assuage; to soothe; to calm.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Puritan austerity was so <qex>tempered</qex> by Dutch indifference, that mercy itself could not have dictated a milder system.</q> <rj><qau>Bancroft.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Woman! lovely woman! nature made thee<br/
To <qex>temper</qex> man: we had been brutes without you.</q> <rj><qau>Otway.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>But thy fire<br/
Shall be more <qex>tempered</qex>, and thy hope far higher.</q> <rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>She [the Goddess of Justice] threw darkness and clouds about her, that <qex>tempered</qex> the light into a thousand beautiful shades and colors.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To fit together; to adjust; to accomodate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thy sustenance . . . serving to the appetite of the eater, <qex>tempered</qex> itself to every man's liking.</q> <rj><qau>Wisdom xvi. 21.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Metal.)</fld> <def>To bring to a proper degree of hardness; <as>as, to <ex>temper</ex> iron or steel</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>tempered</qex> metals clash, and yield a silver sound.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To govern; to manage.</def> <mark>[A Latinism & Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>With which the damned ghosts he governeth,<br/
And furies rules, and Tartare <qex>tempereth</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To moisten to a proper consistency and stir thoroughly, as clay for making brick, loam for molding, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Mus.)</fld> <def>To adjust, as the mathematical scale to the actual scale, or to that in actual use.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To soften; mollify; assuage; soothe; calm.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temper</ent><br/
<hw>Tem"per</hw>, <pos>n.</pos> <sn>1.</sn> <def>The state of any compound substance which results from the mixture of various ingredients; due mixture of different qualities; just combination; <as>as, the <ex>temper</ex> of mortar</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Constitution of body; temperament; in old writers, the mixture or relative proportion of the four humors, blood, choler, phlegm, and melancholy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The exquisiteness of his [Christ's] bodily <qex>temper</qex> increased the exquisiteness of his torment.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Disposition of mind; the constitution of the mind, particularly with regard to the passions and affections; <as>as, a calm <ex>temper</ex>; a hasty <ex>temper</ex>; a fretful <ex>temper</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Remember with what mild<br/
And gracious <qex>temper</qex> he both heared and judged.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The consequents of a certain ethical <qex>temper</qex>.</q> <rj><qau>J. H. Newman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Calmness of mind; moderation; equanimity; composure; <as>as, to keep one's <ex>temper</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To fall with dignity, with <qex>temper</qex> rise.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Restore yourselves to your <qex>tempers</qex>, fathers.</q> <rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Heat of mind or passion; irritation; proneness to anger; -- in a reproachful sense.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>The state of a metal or other substance, especially as to its hardness, produced by some process of heating or cooling; <as>as, the <ex>temper</ex> of iron or steel</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Middle state or course; mean; medium.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The perfect lawgiver is a just <qex>temper</qex> between the mere man of theory, who can see nothing but general principles, and the mere man of business, who can see nothing but particular circumstances.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Sugar Works)</fld> <def>Milk of lime, or other substance, employed in the process formerly used to clarify sugar.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Temper screw</b></col>, <cd>in deep well boring, an adjusting screw connecting the working beam with the rope carrying the tools, for lowering the tools as the drilling progresses.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Disposition; temperament; frame; humor; mood. See <er>Disposition</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temper</ent><br/
<hw>Tem"per</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To accord; to agree; to act and think in conformity.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To have or get a proper or desired state or quality; to grow soft and pliable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I have him already <qex>tempering</qex> between my finger and my thumb, and shortly will I seal with him.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempera</ent><br/
\'d8<hw>Tem"pe*ra</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It.]</ety> <fld>(Paint.)</fld> <def>A mode or process of painting; distemper.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The term is applied especially to early Italian painting, common vehicles of which were yolk of egg, yolk and white of egg mixed together, the white juice of the fig tree, and the like.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperable</ent><br/
<hw>Tem"per*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being tempered.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The fusible, hard, and <qex>temperable</qex> texture of metals.</q> <rj><qau>Emerson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperament</ent><br/
<hw>Tem"per*a*ment</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>temperamentum</ets> a mixing in due proportion, proper measure, temperament: cf. F. <ets>temp<eacute/rament</ets>. See <er>Temper</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>Internal constitution; state with respect to the relative proportion of different qualities, or constituent parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The common law . . . has reduced the kingdom to its just state and <qex>temperament</qex>.</q> <rj><qau>Sir M. Hale.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Due mixture of qualities; a condition brought about by mutual compromises or concessions.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>However, I forejudge not any probable expedient, any <qex>temperament</qex> that can be found in things of this nature, so disputable on their side.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The act of tempering or modifying; adjustment, as of clashing rules, interests, passions, or the like; also, the means by which such adjustment is effected.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Wholesome <qex>temperaments</qex> of the rashness of popular assemblies.</q> <rj><qau>Sir J. Mackintosh.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Condition with regard to heat or cold; temperature.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Bodies are denominated <ldquo/hot<rdquo/ and <ldquo/cold<rdquo/ in proportion to the present <qex>temperament</qex> of that part of our body to which they are applied.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Mus.)</fld> <def>A system of compromises in the tuning of organs, pianofortes, and the like, whereby the tones generated with the vibrations of a ground tone are mutually modified and in part canceled, until their number reduced to the actual practicable scale of twelve tones to the octave. This scale, although in so far artificial, is yet closely suggestive of its origin in nature, and this system of tuning, although not mathematically true, yet satisfies the ear, while it has the convenience that the same twelve fixed tones answer for every key or scale, C<sharp/ becoming identical with D<flat/, and so on.</def><-- = tempering --><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Physiol.)</fld> <def>The peculiar physical and mental character of an individual, in olden times erroneously supposed to be due to individual variation in the relations and proportions of the constituent parts of the body, especially of the fluids, as the bile, blood, lymph, etc. Hence the phrases, bilious or choleric <xex>temperament</xex>, sanguine <xex>temperament</xex>, etc., implying a predominance of one of these fluids and a corresponding influence on the temperament.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Equal temperament</b></col> <fld>(Mus.)</fld>, <cd>that in which the variations from mathematically true pitch are distributed among all the keys alike.</cd> -- <col><b>Unequal temperament</b></col> <fld>(Mus.)</fld>, <cd>that in which the variations are thrown into the keys least used.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperamental</ent><br/
<hw>Tem`per*a*men"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to temperament; constitutional.</def> <mark>[R.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperance</ent><br/
<hw>Tem"per*ance</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>temperantia</ets>: cf. F. <ets>temp<eacute/rance</ets>. See <er>Temper</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>Habitual moderation in regard to the indulgence of the natural appetites and passions; restrained or moderate indulgence; moderation; <as>as, <ex>temperance</ex> in eating and drinking; <ex>temperance</ex> in the indulgence of joy or mirth</as>; specifically, moderation, and sometimes abstinence, in respect to using intoxicating liquors.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Moderation of passion; patience; calmness; sedateness.</def> <mark>[R.]</mark> <ldquo/A gentleman of all <xex>temperance</xex>.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He calmed his wrath with goodly <qex>temperance</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>State with regard to heat or cold; temperature.</def> <mark>[Obs.]</mark> <ldquo/Tender and delicate <xex>temperance</xex>.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Temperance society</b></col>, <cd>an association formed for the purpose of diminishing or stopping the use of alcoholic liquors as a beverage.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperancy</ent><br/
<hw>Tem"per*an*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Temperance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperate</ent><br/
<hw>Tem"per*ate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>temperatus</ets>, p. p. of <ets>temperare</ets>. See <er>Temper</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>Moderate; not excessive; <as>as, <ex>temperate</ex> heat; a <ex>temperate</ex> climate</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not marked with passion; not violent; cool; calm; <as>as, <ex>temperate</ex> language</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She is not hot, but <qex>temperate</qex> as the morn.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>That sober freedom out of which there springs<br/
Our loyal passion for our <qex>temperate</qex> kings.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Moderate in the indulgence of the natural appetites or passions; <as>as, <ex>temperate</ex> in eating and drinking</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Be sober and <qex>temperate</qex>, and you will be healthy.</q> <rj><qau>Franklin.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Proceeding from temperance.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>temperate</qex> sleeps, and spirits light as air.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Temperate zone</b></col> <fld>(Geog.)</fld>, <cd>that part of the earth which lies between either tropic and the corresponding polar circle; -- so called because the heat is less than in the torrid zone, and the cold less than in the frigid zones.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Abstemious; sober; calm; cool; sedate.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperate</ent><br/
<hw>Tem"per*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To render temperate; to moderate; to soften; to temper.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>It inflames temperance, and <qex>temperates</qex> wrath.</q> <rj><qau>Marston.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperately</ent><br/
<hw>Tem"per*ate*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a temperate manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperateness</ent><br/
<hw>Tem"per*ate*ness</hw>, <pos>n.</pos> <def>The quality or state of being temperate; moderateness; temperance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperative</ent><br/
<hw>Tem"per*a*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. L. <ets>temperativus</ets> soothing.]</ety> <def>Having power to temper.</def> <mark>[R.]</mark>  <rj><au>T. Granger.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperature</ent><br/
<hw>Tem"per*a*ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>temp<eacute/rature</ets>, L. <ets>temperatura</ets> due measure, proportion, temper, temperament.]</ety> <sn>1.</sn> <def>Constitution; state; degree of any quality.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The best composition and <qex>temperature</qex> is, to have openness in fame and opinion, secrecy in habit, dissimulation in seasonable use, and a power to feign, if there be no remedy.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Memory depends upon the consistence and the <qex>temperature</qex> of the brain.</q> <rj><qau>I. Watts.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Freedom from passion; moderation.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In that proud port, which her so goodly graceth,<br/
Most goodly <qex>temperature</qex> you may descry.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Physics)</fld> <def>Condition with respect to heat or cold, especially as indicated by the sensation produced, or by the thermometer or pyrometer; degree of heat or cold; <as>as, the <ex>temperature</ex> of the air; high <ex>temperature</ex>; low <ex>temperature</ex>; <ex>temperature</ex> of freezing or of boiling.</as></def> <note>The temperature of a liquid or a solid body as measured by a thermometer is a measure of the average kinetic energy of the consituent atoms or molecules of the body.  For other states of matter such as plasma, electromagnetic radiation, or subatomic particles, an analogous measure of the average kinetic energy may be expressed as a <ex>temperature</ex>, although it could never be measured by a traditional thermometer, let alone by sensing with the skin.</note><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>4.</sn> <def>Mixture; compound.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Made a <qex>temperature</qex> of brass and iron together.</q> <rj><qau>Holland.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Physiol. & Med.)</fld> <def>The degree of heat of the body of a living being, esp. of the human body; also <mark>(Colloq.)</mark>, loosely, the excess of this over the  normal (of the human body 98<deg/-99.5<deg/ F., in the mouth of an adult about 98.4<deg/).</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Absolute temperature</b></col>. <fld>(Physics)</fld> <cd>See under <er>Absolute</er>.</cd> -- <col><b>Animal temperature</b></col> <fld>(Physiol.)</fld>, <cd>the nearly constant temperature maintained in the bodies of warm-blooded (<xex>homoiothermal</xex>) animals during life. The ultimate source of the heat is to be found in the potential energy of the food and the oxygen which is absorbed from the air during respiration. See <er>Homoiothermal</er>.</cd> -- <col><b>Temperature sense</b></col> <fld>(Physiol.)</fld>, <cd>the faculty of perceiving cold and warmth, and so of perceiving differences of temperature in external objects.</cd> <au>H. N. Martin.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1483 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempered</ent><br/
<hw>Tem"pered</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Brought to a proper temper; <as>as, <ex>tempered</ex> steel</as>; having (such) a temper; -- chiefly used in composition; <as>as, a good-<ex>tempered</ex> or bad-<ex>tempered</ex> man; a well-<ex>tempered</ex> sword.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temperer</ent><br/
<hw>Tem"per*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that which, tempers; specifically, a machine in which lime, cement, stone, etc., are mixed with water.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempering</ent><br/
<hw>Tem"per*ing</hw>, <pos>n.</pos> <fld>(Metal.)</fld> <def>The process of giving the requisite degree of hardness or softness to a substance, as iron and steel; especially, the process of giving to steel the degree of hardness required for various purposes, consisting usually in first plunging the article, when heated to redness, in cold water or other liquid, to give an excess of hardness, and then reheating it gradually until the hardness is reduced or drawn down to the degree required, as indicated by the color produced on a polished portion, or by the burning of oil.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tempering color</b></col>, <cd>the shade of color that indicates the degree of temper in tempering steel, as pale straw yellow for lancets, razors, and tools for metal; dark straw yellow for penknives, screw taps, etc.; brown yellow for axes, chisels, and plane irons; yellow tinged with purple for table knives and shears; purple for swords and watch springs; blue for springs and saws; and very pale blue tinged with green, too soft for steel instruments.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temper screw</ent><br/
<hw>Tem"per screw</hw>. <sn>1.</sn> <def>A screw link, to which is attached the rope of a rope-drilling apparatus, for feeding and slightly turning the drill jar at each stroke.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>A set screw used for adjusting.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tempest</ent><br/
<hw>Tem"pest</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>tempeste</ets>, F. <ets>temp<ecir/te</ets>, (assumed) LL. <ets>tempesta</ets>, fr. L. <ets>tempestas</ets> a portion of time, a season, weather, storm, akin to <ets>tempus</ets> time. See <er>Temporal</er> of time.]</ety> <sn>1.</sn> <def>An extensive current of wind, rushing with great velocity and violence, and commonly attended with rain, hail, or snow; a furious storm.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[We] caught in a fiery <qex>tempest</qex>, shall be hurled,<br/
Each on his rock transfixed.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: Any violent tumult or commotion; <as>as, a political <ex>tempest</ex>; a <ex>tempest</ex> of war, or of the passions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A fashionable assembly; a drum. See the Note under <er>Drum</er>, <pos>n.</pos>, 4.</def> <mark>[Archaic]</mark>  <rj><au>Smollett.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ex>Tempest</ex> is sometimes used in the formation of self-explaining compounds; <as>as, <ex>tempest</ex>-beaten, <ex>tempest</ex>-loving, <ex>tempest</ex>-tossed, <ex>tempest</ex>-winged, and the like</as>.</note><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Storm; agitation; perturbation. See <er>Storm</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempest</ent><br/
<hw>Tem"pest</hw>, <pos>v. t.</pos> <ety>[Cf. OF. <ets>tempester</ets>, F. <ets>temp<ecir/ter</ets> to rage.]</ety> <def>To disturb as by a tempest.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Part huge of bulk<br/
Wallowing unwieldy, enormous in their gait,<br/
<qex>Tempest</qex> the ocean.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempest</ent><br/
<hw>Tem"pest</hw>, <pos>v. i.</pos> <def>To storm.</def> <mark>[Obs.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempestive</ent><br/
<hw>Tem*pes"tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tempestivus</ets>.]</ety> <def>Seasonable; timely; <as>as, <ex>tempestive</ex> showers</as>.</def> <mark>[Obs.]</mark> <au>Heywood.</au> -- <wordforms><wf>Tem*pes"tive*ly</wf>, <pos>adv.</pos> <mark>[Obs.]</mark></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempestivily</ent><br/
<hw>Tem`pes*tiv"i*ly</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tempestivitas</ets>.]</ety> <def>The quality, or state, of being tempestive; seasonableness.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempestuous</ent><br/
<hw>Tem*pes"tu*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tempestuous</ets>: cf. OF. <ets>tempestueux</ets>, F. <ets>temp<ecir/tueux</ets>.]</ety> <def>Of or pertaining to a tempest; involving or resembling a tempest; turbulent; violent; stormy; <as>as, <ex>tempestuous</ex> weather; a <ex>tempestuous</ex> night; a <ex>tempestuous</ex> debate.</as></def> -- <wordforms><wf>Tem*pes"tu*ous*ly</wf>, <pos>adv.</pos> -- <wf>Tem*pes"tu*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>They saw the Hebrew leader,<br/
Waiting, and clutching his <qex>tempestuous</qex> beard.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Templar</ent><br/
<hw>Tem"plar</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>templere</ets>, F. <ets>templier</ets>, LL. <ets>templarius</ets>. See <er>Temple</er> a church.]</ety> <sn>1.</sn> <def>One of a religious and military order first established at Jerusalem, in the early part of the 12th century, for the protection of pilgrims and of the Holy Sepulcher. These <membof>Knights Templars</membof>, or <membof>Knights of the Temple</membof>, were so named because they occupied an apartment of the palace of Bladwin II. in Jerusalem, near the Temple.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The order was first limited in numbers, and its members were bound by vows of chastity and poverty. After the conquest of Palestine by the Saracens, the Templars spread over Europe, and, by reason of their reputation for valor and piety, they were enriched by numerous donations of money and lands. The extravagances and vices of the later Templars, however, finally led to the suppression of the order by the Council of Vienne in 1312.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A student of law, so called from having apartments in the Temple at London, the original buildings having belonged to the Knights Templars. See <cref>Inner Temple</cref>, and <cref>Middle Temple</cref>, under <er>Temple</er>.</def> <mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>One belonged to a certain order or degree among the Freemasons, called <membof>Knights Templars</membof>. Also, one of an order among temperance men, styled <membof>Good Templars</membof>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Templar</ent><br/
<hw>Tem"plar</hw>, <pos>a.</pos> <def>Of or pertaining to a temple.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Solitary, family, and <qex>templar</qex> devotion.</q> <rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Template</ent><br/
<hw>Tem"plate</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Templet</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temple</ent><br/
<hw>Tem"ple</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Templet</er>.]</ety> <fld>(Weaving)</fld> <def>A contrivence used in a loom for keeping the web stretched transversely.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temple</ent><br/
<hw>Tem"ple</hw>, <pos>n.</pos> <ety>[OF. <ets>temple</ets>, F. <ets>tempe</ets>, from L. <ets>tempora</ets>, <ets>tempus</ets>; perhaps originally, the right place, the fatal spot, supposed to be the same word as <ets>tempus</ets>, <ets>temporis</ets>, the fitting or appointed time. See <er>Temporal</er> of time, and cf. <er>Tempo</er>, <er>Tense</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>The space, on either side of the head, back of the eye and forehead, above the zygomatic arch and in front of the ear.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of the side bars of a pair of spectacles, jointed to the bows, and passing one on either side of the head to hold the spectacles in place.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temple</ent><br/
<hw>Tem"ple</hw>, <pos>n.</pos> <ety>[AS. <ets>tempel</ets>, from L. <ets>templum</ets> a space marked out, sanctuary, temple; cf. Gr. <?/ a piece of land marked off, land dedicated to a god: cf. F. <ets>t<eacute/mple</ets>, from the Latin.  Cf. <er>Contemplate</er>.]</ety> <sn>1.</sn> <def>A place or edifice dedicated to the worship of some deity; <as>as, the <ex>temple</ex> of Jupiter at Athens, or of Juggernaut in India</as>.</def> <ldquo/The <xex>temple</xex> of mighty Mars.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Jewish Antiq.)</fld> <def>The edifice erected at Jerusalem for the worship of Jehovah.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Jesus walked in the <qex>temple</qex> in Solomon's porch.</q> <rj><qau>John x. 23.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, among Christians, an edifice erected as a place of public worship; a church.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Can he whose life is a perpetual insult to the authority of God enter with any pleasure a <qex>temple</qex> consecrated to devotion and sanctified by prayer?</q> <rj><qau>Buckminster.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Fig.: Any place in which the divine presence specially resides.</def> <ldquo/The <xex>temple</xex> of his body.<rdquo/  <rj><au>John ii. 21.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Know ye not that ye are the <qex>temple</qex> of God, and that the spirit of God dwelleth in you?</q> <rj><qau>1 Cor. iii. 16.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The groves were God's first <qex>temples</qex>.</q> <rj><qau>Bryant.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Mormon Ch.)</fld> <def>A building dedicated to the administration of ordinances.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>6.</sn>  <def>A local organization of Odd Fellows.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><mcol><col><b>Inner Temple</b></col>, <it>and</it> <col><b>Middle Temple</b></col></mcol>, <cd>two buildings, or ranges of buildings, occupied by two inns of court in London, on the site of a monastic establishment of the Knights Templars, called <xex>the Temple</xex>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temple</ent><br/
<hw>Tem"ple</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To build a temple for; to appropriate a temple to; <as>as, to <ex>temple</ex> a god</as>.</def> <mark>[R.]</mark>  <rj><au>Feltham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Templed</ent><br/
<hw>Tem"pled</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Supplied with a temple or temples, or with churches; inclosed in a temple.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I love thy rocks and rills,<br/
Thy woods and <qex>templed</qex> hills.</q> <rj><qau>S. F. Smith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Templet</ent><br/
<hw>Tem"plet</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL. <ets>templatus</ets> vaulted, from L. <ets>templum</ets> a small timber.]</ety> <altsp>[Spelt also <asp>template</asp>.]</altsp> <sn>1.</sn> <def>A gauge, pattern, or mold, commonly a thin plate or board, used as a guide to the form of the work to be executed; <as>as, a mason's or a wheelwright's <ex>templet</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <def>A short piece of timber, iron, or stone, placed in a wall under a girder or other beam, to distribute the weight or pressure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempo</ent><br/
\'d8<hw>Tem"po</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It., fr. L. <ets>tempus</ets>. See <er>Tense</er>, <pos>n.</pos>]</ety> <fld>(Mus.)</fld> <def>The rate or degree of movement in time.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs>\'d8<col><b>A tempo giusto</b></col> <pr>(j<oomac/s"t<osl/)</pr> <ety>[It.]</ety>, <cd>in exact time; -- sometimes, directing a return to strict time after a tempo rubato.</cd> -- <col><b>Tempo rubato</b></col>. <cd>See under <er>Rubato</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporal</ent><br/
<hw>Tem"po*ral</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>temporalis</ets>, fr. <ets>tempora</ets> the temples: cf. F. <ets>temporal</ets>. See <er>Temple</er> a part of the head.]</ety> <fld>(Anat.)</fld> <def>Of or pertaining to the temple or temples; <as>as, the <ex>temporal</ex> bone; a <ex>temporal</ex> artery.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Temporal bone</b></col>, <cd>a very complex bone situated in the side of the skull of most mammals and containing the organ of hearing. It consists of an expanded <xex>squamosal</xex> portion above the ear, corresponding to the squamosal and zygoma of the lower vertebrates, and a thickened basal <xex>petrosal</xex> and <xex>mastoid</xex> portion, corresponding to the periotic and tympanic bones of the lower vertebrates.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporal</ent><br/
<hw>Tem"po*ral</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>temporalis</ets>, fr. <ets>tempus</ets>, <ets>temporis</ets>, time, portion of time, the fitting or appointed time: cf. F. <ets>temporel</ets>.  Cf. <er>Contemporaneous</er>, <er>Extempore</er>, <er>Temper</er>, <pos>v. t.</pos>, <er>Tempest</er>, <er>Temple</er> a part of the head, <er>Tense</er>, <pos>n.</pos>, <er>Thing</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to time, that is, to the present life, or this world; secular, as distinguished from <xex>sacred</xex> or <xex>eternal</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The things which are seen are <qex>temporal</qex>, but the things which are not seen are eternal.</q> <rj><qau>2 Cor. iv. 18.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Is this an hour for <qex>temporal</qex> affairs?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Civil or political, as distinguished from <xex>ecclesiastical</xex>; <as>as, <ex>temporal</ex> power; <ex>temporal</ex> courts</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lords temporal</b></col>. <cd>See under <er>Lord</er>, <pos>n.</pos></cd> -- <col><b>Temporal augment</b></col>. <cd>See the Note under <er>Augment</er>, <pos>n.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Transient; fleeting; transitory.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporal</ent><br/
<hw>Tem"po*ral</hw>, <pos>n.</pos> <def>Anything temporal or secular; a temporality; -- used chiefly in the plural.</def>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He assigns supremacy to the pope in spirituals, and to the emperor or <qex>temporals</qex>.</q> <rj><qau>Lowell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporality</ent><br/
<hw>Tem`po*ral"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Temporalities</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>temporalitas</ets>, in LL., possessions of the church: cf. F. <ets>temporalit<eacute/</ets>.]</ety> <sn>1.</sn> <def>The state or quality of being temporary; -- opposed to <xex>perpetuity</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The laity; temporality.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which pertains to temporal welfare; material interests; especially, the revenue of an ecclesiastic proceeding from lands, tenements, or lay fees, tithes, and the like; -- chiefly used in the plural.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Supreme head, . . . under God, of the spirituality and <qex>temporality</qex> of the same church.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporally</ent><br/
<hw>Tem"po*ral*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a temporal manner; secularly.</def> <mark>[R.]</mark>  <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporalness</ent><br/
<hw>Tem"po*ral*ness</hw>, <pos>n.</pos> <def>Worldliness.</def> <mark>[R.]</mark>  <rj><au>Cotgrave.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporalty</ent><br/
<hw>Tem"po*ral*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Temporality</er>.]</ety> <sn>1.</sn> <def>The laity; secular people.</def> <mark>[Obs.]</mark>  <rj><au>Abp. Abbot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A secular possession; a temporality.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporaneous</ent><br/
<hw>Tem`po*ra"ne*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>temporaneus</ets> happening at the right time, fr. <ets>tempus</ets>, <ets>temporis</ets>, time.]</ety> <def>Temporarity.</def> <mark>[Obs.]</mark>  <rj><au>Hallywell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporarily</ent><br/
<hw>Tem"po*ra*ri*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a temporary manner; for a time.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporariness</ent><br/
<hw>Tem"po*ra*ri*ness</hw>, <pos>n.</pos> <def>The quality or state of being temporary; -- opposed to <xex>perpetuity</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporary</ent><br/
<hw>Tem"po*ra*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>temporarius</ets>, fr. <ets>tempus</ets>, <ets>temporis</ets>, time: cf. F. <ets>temporaire</ets>.]</ety> <def>Lasting for a time only; existing or continuing for a limited time; not permanent; <as>as, the patient has obtained <ex>temporary</ex> relief</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Temporary</qex> government of the city.</q> <rj><qau>Motley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Temporary star</b></col>. <fld>(Astron.)</fld> <cd>See under <er>Star</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporist</ent><br/
<hw>Tem"po*rist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A temporizer.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Why, turn a <qex>temporist</qex>, row with the tide.</q> <rj><qau>Marston.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporization</ent><br/
<hw>Tem`po*ri*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>temporisation</ets>.]</ety> <def>The act of temporizing.</def>  <rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporize</ent><br/
<hw>Tem"po*rize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Temporized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Temporizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[F. <ets>temporiser</ets>. See <er>Temporal</er> of time.]</ety> <sn>1.</sn> <def>To comply with the time or occasion; to humor, or yield to, the current of opinion or circumstances; also, to trim, as between two parties.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They might their grievance inwardly complain,<br/
But outwardly they needs must <qex>temporize</qex>.</q> <rj><qau>Daniel.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To delay; to procrastinate.</def> <mark>[R.]</mark>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To comply; to agree.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporizer</ent><br/
<hw>Tem"po*ri`zer</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who temporizes; one who yields to the time, or complies with the prevailing opinions, fashions, or occasions; a trimmer.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A sort of <qex>temporizers</qex>, ready to embrace and maintain all that is, or shall be, proposed, in hope of preferment.</q> <rj><qau>Burton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporizingly</ent><br/
<hw>Tem"po*ri`zing*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a temporizing or yielding manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporo-</ent><br/
<hw>Tem"po*ro-</hw> <pr>(?)</pr>. <def>A combining form used in anatomy to indicate <xex>connection with</xex>, or <xex>relation to</xex>, <xex>the temple</xex>, or <xex>temporal bone</xex>; <as>as, <ex>temporo</ex>facial</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporo-auricular</ent><br/
<hw>Tem`po*ro-au*ric"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <def>Of or pertaining to both the temple and the ear; <as>as, the <ex>temporo-auricular</ex> nerve</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporofacial</ent><br/
<hw>Tem`po*ro*fa"cial</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <def>Of or pertaining to both the temple and the face.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporomalar</ent><br/
<hw>Tem`po*ro*ma"lar</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <def>Of or pertaining to both the temple and the region of the malar bone; <as>as, the <ex>temporomalar</ex> nerve</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temporomaxillary</ent><br/
<hw>Tem`po*ro*max"il*la*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <def>Of or pertaining to both the temple or the temporal bone and the maxilla.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temps</ent><br/
<hw>Temps</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. & F., fr. L. <ets>tempus</ets>. See <er>Temporal</er> of time.]</ety> <def>Time.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempse</ent><br/
<hw>Tempse</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Temse</er>.</def> <mark>[Obs. or Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempt</ent><br/
<hw>Tempt</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tempted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Tempting</conjf>.]</vmorph> <ety>[OE. <ets>tempten</ets>, <ets>tenten</ets>, from OF. <ets>tempter</ets>, <ets>tenter</ets>, F. <ets>tenter</ets>, fr. L. <ets>tentare</ets>, <ets>temptare</ets>, to handle, feel, attack, to try, put to the test, urge, freq. from <ets>tendere</ets>, <ets>tentum</ets>, and <ets>tensum</ets>, to stretch. See <er>Thin</er>, and cf. <er>Attempt</er>, <er>Tend</er>, <er>Taunt</er>, <er>Tent</er> a pavilion, <er>Tent</er> to probe.]</ety> <sn>1.</sn> <def>To put to trial; to prove; to test; to try.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>God did <qex>tempt</qex> Abraham.</q> <rj><qau>Gen. xxii. 1.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ye shall not <qex>tempt</qex> the Lord your God.</q> <rj><qau>Deut. vi. 16.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To lead, or endeavor to lead, into evil; to entice to what is wrong; to seduce.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Every man is <qex>tempted</qex> when he is drawn away of his own lust, and enticed.</q> <rj><qau>James i. 14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To endeavor to persuade; to induce; to invite; to incite; to provoke; to instigate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tempt</qex> not the brave and needy to despair.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Nor <qex>tempt</qex> the wrath of heaven's avenging Sire.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To endeavor to accomplish or reach; to attempt.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ere leave be given to <qex>tempt</qex> the nether skies.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To entice; allure; attract; decoy; seduce.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temptability</ent><br/
<hw>Tempt`a*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being temptable; lability to temptation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temptable</ent><br/
<hw>Tempt"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being tempted; liable to be tempted.</def>  <rj><au>Cudworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temptation</ent><br/
<hw>Temp*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>temptation</ets>, <ets>tentation</ets>, F. <ets>tentation</ets>, L. <ets>tentatio</ets>.]</ety> <sn>1.</sn> <def>The act of tempting, or enticing to evil; seduction.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When the devil had ended all the <qex>temptation</qex>, he departed from him for a season.</q> <rj><qau>Luke iv. 13.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The state of being tempted, or enticed to evil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Lead us not into <qex>temptation</qex>.</q> <rj><qau>Luke xi. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which tempts; an inducement; an allurement, especially to something evil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Dare to be great, without a guilty crown;<br/
View it, and lay the bright <qex>temptation</qex> down.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temptationless</ent><br/
<hw>Temp*ta"tion*less</hw>, <pos>a.</pos> <def>Having no temptation or motive; <as>as, a <ex>temptationless</ex> sin</as>.</def> <mark>[R.]</mark>  <rj><au>Hammond.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temptatious</ent><br/
<hw>Temp*ta"tious</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Tempting.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempter</ent><br/
<hw>Tempt"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who tempts or entices; especially, Satan, or the Devil, regarded as the great enticer to evil.</def> <ldquo/Those who are bent to do wickedly will never want <xex>tempters</xex> to urge them on.<rdquo/  <rj><au>Tillotson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>So glozed the <qex>Tempter</qex>, and his proem tuned.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tempting</ent><br/
<hw>Tempt"ing</hw>, <pos>a.</pos> <def>Adapted to entice or allure; attractive; alluring; seductive; enticing; <as>as, <ex>tempting</ex> pleasures</as>.</def> -- <wordforms><wf>Tempt"ing*ly</wf>, <pos>adv.</pos> -- <wf>Tempt"ing*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temptress</ent><br/
<hw>Tempt"ress</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A woman who entices.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She was my <qex>temptress</qex>, the foul provoker.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temse</ent><br/
<hw>Temse</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tamis</ets>, or D. <ets>tems</ets>, <ets>teems</ets>.  Cf. <er>Tamine</er>.]</ety> <def>A sieve.</def> <altsp>[Written also <asp>tems</asp>, and <asp>tempse</asp>.]</altsp> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Temse bread</b></col>, <col><b>Temsed bread</b></col>, <col><b>Temse loaf</b></col></mcol>, <cd>bread made of flour better sifted than common fluor.</cd> <mark>[Prov. Eng.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temulency</ent><br/
<ent>Temulence</ent><br/
<mhw>{ <hw>Tem"u*lence</hw> <pr>(?)</pr>, <hw>Tem"u*len*cy</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[L. <ets>temulentia</ets>.]</ety> <def>Intoxication; inebriation; drunkenness.</def> <mark>[R.]</mark> <ldquo/Their <xex>temulency</xex>.<rdquo/  <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temulent</ent><br/
<hw>Tem"u*lent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>temulentus</ets>.]</ety> <def>Intoxicated; drunken.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Temulentive</ent><br/
<hw>Tem"u*lent*ive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Somewhat temulent; addicted to drink.</def> <mark>[R.]</mark>  <rj><au>R. Junius.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ten</ent><br/
<hw>Ten</hw> <pr>(t<ecr/n)</pr>, <pos>a.</pos> <ety>[AS. <ets>t<emac/n</ets>, <ets>ti<eacute/n</ets>, <ets>t<ymac/n</ets>, <ets>t<emac/ne</ets>; akin to OFries. <ets>tian</ets>, OS. <ets>tehan</ets>, D. <ets>tien</ets>, G. <ets>zehn</ets>, OHG. <ets>zehan</ets>, Icel. <ets>t<imac/u</ets>, Sw. <ets>tio</ets>, Dan. <ets>ti</ets>, Goth. <ets>ta<iacute/hun</ets>, Lith. <ets>deszimt</ets>, Russ. <ets>desiate</ets>, W. <ets>deg</ets>, Ir. & Gael. <ets>deich</ets>, L. <ets>decem</ets>, Gr. <grk>de`ka</grk>, Skr. <ets>da<cced/an</ets>. <root/308.  Cf. <er>Dean</er>, <er>Decade</er>, <er>Decimal</er>, <er>December</er>, <er>Eighteen</er>, <er>Eighty</er>, <er>Teens</er>, <er>Tithe</er>.]</ety> <def>One more than nine; twice five.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>With twice <qex>ten</qex> sail I crossed the Phrygian Sea.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Ten</xex> is often used, indefinitely, for <xex>several</xex>, <xex>many</xex>, and other like words.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>There 's a proud modesty in merit,<br/
Averse from begging, and resolved to pay<br/
<qex>Ten</qex> times the gift it asks.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1484 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ten</ent><br/
<hw>Ten</hw> <pr>(t<ecr/n)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The number greater by one than nine; the sum of five and five; ten units of objects.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I will not destroy it for <qex>ten's</qex> sake.</q> <rj><qau>Gen. xviii. 32.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A symbol representing ten units, as 10, <er>x</er>, or <er>X</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenability</ent><br/
<hw>Ten`a*bil"i*ty</hw> <pr>(t<ecr/n`<adot/*b<icr/l"<icr/*t<ycr/)</pr>, <pos>n.</pos> <def>The quality or state of being tenable; tenableness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenable</ent><br/
<hw>Ten"a*ble</hw> <pr>(t<ecr/n"<adot/*b'l)</pr>, <pos>a.</pos> <ety>[F. <ets>tenable</ets>, fr. <ets>tenir</ets> to hold, L. <ets>tenere</ets>. See <er>Thin</er>, and cf. <er>Continue</er>, <er>Continent</er>, <er>Entertain</er>, <er>Maintain</er>, <er>Tenant</er>, <er>Tent</er>.]</ety> <def>Capable of being held, maintained, or defended, as against an assailant or objector, or against attempts to take or process; <as>as, a <ex>tenable</ex> fortress, a <ex>tenable</ex> argument</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If you have hitherto concealed his sight,<br/
Let it be <qex>tenable</qex> in your silence still.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I would be the last man in the world to give up his cause when it was <qex>tenable</qex>.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenableness</ent><br/
<hw>Ten`a*ble*ness</hw>, <pos>n.</pos> <def>Same as <er>Tenability</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenace</ent><br/
<hw>Ten"ace</hw> <pr>(t<ecr/n"<asl/s)</pr>, <pos>n.</pos> <ety>[F. <ets>tenace</ets> tenacious, demeurer <ets>tenace</ets> to hold the best and third best cards and take both tricks, the adversary having to lead. See <er>Tenacious</er>.]</ety> <fld>(Whist)</fld> <def>The holding by the fourth hand of the best and third best cards of a suit led; also, sometimes, the combination of best with third best card of a suit in any hand.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenacious</ent><br/
<hw>Te*na"cious</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tenax</ets>, <ets>-acis</ets>, from <ets>tenere</ets> to hold. See <er>Tenable</er>, and cf. <er>Tenace</er>.]</ety> <sn>1.</sn> <def>Holding fast, or inclined to hold fast; inclined to retain what is in possession; <as>as, men <ex>tenacious</ex> of their just rights</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Apt to retain; retentive; <as>as, a <ex>tenacious</ex> memory</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Having parts apt to adhere to each other; cohesive; tough; <as>as, steel is a <ex>tenacious</ex> metal; tar is more <ex>tenacious</ex> than oil</as>.</def>  <rj><au>Sir I. Newton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Apt to adhere to another substance; glutinous; viscous; sticking; adhesive.</def> <ldquo/Female feet, too weak to struggle with <xex>tenacious</xex> clay.<rdquo/  <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Niggardly; closefisted; miserly.</def>  <rj><au>Ainsworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Holding stoutly to one's opinion or purpose; obstinate; stubborn.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Te*na"cious*ly</wf>, <pos>adv.</pos> -- <wf>Te*na"cious*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenacity</ent><br/
<hw>Te*nac"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tenacitas</ets>: cf. F. <ets>t<eacute/nacit<eacute/</ets>. See <er>Tenacious</er>.]</ety> <sn>1.</sn> <def>The quality or state of being tenacious; <as>as, <ex>tenacity</ex>, or retentiveness, of memory; <ex>tenacity</ex>, or persistency, of purpose</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That quality of bodies which keeps them from parting without considerable force; cohesiveness; the effect of attraction; -- as distinguished from <xex>brittleness</xex>, <xex>fragility</xex>, <xex>mobility</xex>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That quality of bodies which makes them adhere to other bodies; adhesiveness; viscosity.</def>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Physics)</fld> <def>The greatest longitudinal stress a substance can bear without tearing asunder, -- usually expressed with reference to a unit area of the cross section of the substance, as the number of pounds per square inch, or kilograms per square centimeter, necessary to produce rupture.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenaculum</ent><br/
\'d8<hw>Te*nac"u*lum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Tenacula</plw> <pr>(#)</pr>; E. <plw>Tenaculums</plw> <pr>(#)</pr>.</plu> <ety>[L., a holder, fr. <ets>tenere</ets> to hold.  Cf. <er>Tenaille</er>.]</ety> <fld>(Surg.)</fld> <def>An instrument consisting of a fine, sharp hook attached to a handle, and used mainly for taking up arteries, and the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenacy</ent><br/
<hw>Ten"a*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tenacia</ets> obstinacy. See <er>Tenacious</er>.]</ety> <def>Tenaciousness; obstinacy.</def> <mark>[Obs.]</mark>  <rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenaille</ent><br/
<hw>Te*naille"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., a pair of pincers or tongs, a tenaille, fr. L. <ets>tenaculum</ets>. See <er>Tenaculum</er>.]</ety> <fld>(Fort.)</fld> <def>An outwork in the main ditch, in front of the curtain, between two bastions. See <xex>Illust.</xex> of <er>Ravelin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenaillon</ent><br/
<hw>Te*nail"lon</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See <er>Tenaille</er>.]</ety> <fld>(Fort.)</fld> <def>A work constructed on each side of the ravelins, to increase their strength, procure additional ground beyond the ditch, or cover the shoulders of the bastions.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenancy</ent><br/
<hw>Ten"an*cy</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tenacies</plw> <pr>(#)</pr>.</plu> <ety>[Cf. OF. <ets>tenace</ets>, LL. <ets>tenentia</ets>. See <er>Tenant</er>.]</ety> <fld>(Law)</fld> <sd>(a)</sd> <def>A holding, or a mode of holding, an estate; tenure; the temporary possession of what belongs to another.</def> <sd>(b)</sd> <fld>(O. Eng. Law)</fld> <def>A house for habitation, or place to live in, held of another.</def>  <rj><au>Blount. Blackstone. Wharton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenant</ent><br/
<hw>Ten"ant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tenant</ets>, p. pr. of <ets>tenir</ets> to hold. See <er>Tenable</er>, and cf. <er>Lieutenant</er>.]</ety> <sn>1.</sn> <fld>(Law)</fld> <def>One who holds or possesses lands, or other real estate, by any kind of right, whether in fee simple, in common, in severalty, for life, for years, or at will; also, one who has the occupation or temporary possession of lands or tenements the title of which is in another; -- correlative to <xex>landlord</xex>. See Citation from <au>Blackstone</au>, under <er>Tenement</er>, 2.</def>  <rj><au>Blount. Wharton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who has possession of any place; a dweller; an occupant.</def> <ldquo/Sweet <xex>tenants</xex> of this grove.<rdquo/  <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The hhappy <qex>tenant</qex> of your shade.</q> <rj><qau>Cowley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The sister <qex>tenants</qex> of the middle deep.</q> <rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Tenant in capite</b></col> <ety>[L. <ets>in</ets> in + <ets>capite</ets>, abl. of <ets>caput</ets> head, chief.]</ety>, <it>or</it> <col><b>Tenant in chief</b></col></mcol>, <cd>by the laws of England, one who holds immediately of the king.  According to the feudal system, all lands in England are considered as held immediately or mediately of the king, who is styled <xex>lord paramount</xex>. Such tenants, however, are considered as having the fee of the lands and permanent possession.</cd> <au>Blackstone.</au> -- <col><b>Tenant in common</b></col>. <cd>See under <er>Common</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenant</ent><br/
<hw>Ten"ant</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tenanted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Tenanting</conjf>.]</vmorph> <def>To hold, occupy, or possess as a tenant.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Sir Roger's estate is <qex>tenanted</qex> by persons who have served him or his ancestors.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenantable</ent><br/
<hw>Ten"ant*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Fit to be rented; in a condition suitable for a tenant.</def> -- <wordforms><wf>Ten"ant*a*ble*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenantless</ent><br/
<hw>Ten"ant*less</hw>, <pos>a.</pos> <def>Having no tenants; unoccupied; <as>as, a <ex>tenantless</ex> mansion</as>.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenantry</ent><br/
<hw>Ten"ant*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The body of tenants; <as>as, the <ex>tenantry</ex> of a manor or a kingdom</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Tenancy.</def> <mark>[Obs.]</mark>  <rj><au>Ridley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenant saw</ent><br/
<hw>Ten"ant saw`</hw> <pr>(?)</pr>. <def>See <cref>Tenon saw</cref>, under <er>Tenon</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tench</ent><br/
<hw>Tench</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>tenche</ets>, F. <ets>tanche</ets>, L. <ets>tinca</ets>.]</ety> <fld>(Zool.)</fld> <def>A European fresh-water fish (<spn>Tinca tinca</spn>, or <spn>Tinca vulgaris</spn>) allied to the carp. It is noted for its tenacity of life.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tend</ent><br/
<hw>Tend</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[See <er>Tender</er> to offer.]</ety> <fld>(O. Eng. Law)</fld> <def>To make a tender of; to offer or tender.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tend</ent><br/
<hw>Tend</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tended</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Tending</conjf>.]</vmorph> <ety>[Aphetic form of <ets>attend</ets>. See <er>Attend</er>, <er>Tend</er> to move, and cf. <er>Tender</er> one that tends or attends.]</ety> <sn>1.</sn> <def>To accompany as an assistant or protector; to care for the wants of; to look after; to watch; to guard; <as>as, shepherds <ex>tend</ex> their flocks</as>.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And flaming ministers to watch and <qex>tend</qex><br/
Their earthly charge.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There 's not a sparrow or a wren,<br/
There 's not a blade of autumn grain,<br/
Which the four seasons do not <qex>tend</qex><br/
And tides of life and increase lend.</q> <rj><qau>Emerson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be attentive to; to note carefully; to attend to.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Being to descend<br/
A ladder much in height, I did not <qex>tend</qex><br/
My way well down.</q> <rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To tend a vessel</b></col> <fld>(Naut.)</fld>, <cd>to manage an anchored vessel when the tide turns, so that in swinging she shall not entangle the cable.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tend</ent><br/
<hw>Tend</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To wait, as attendants or servants; to serve; to attend; -- with <xex>on</xex> or <xex>upon</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Was he not companion with the riotous knights<br/
That <qex>tend</qex> upon my father?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[F. <ets>attendre</ets>.]</ety> <def>To await; to expect.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tend</ent><br/
<hw>Tend</hw>, <pos>v. i.</pos> <ety>[F. <ets>tendre</ets>, L. <ets>tendere</ets>, <ets>tensum</ets> and <ets>tentum</ets>, to stretch, extend, direct one's course, tend; akin to Gr. <?/ to stretch, Skr. <ets>tan</ets>. See <er>Thin</er>, and cf. <er>Tend</er> to attend, <er>Contend</er>, <er>Intense</er>, <er>Ostensible</er>, <er>Portent</er>, <er>Tempt</er>, <er>Tender</er> to offer, <er>Tense</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>To move in a certain direction; -- usually with <xex>to</xex> or <xex>towards</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Two gentlemen <qex>tending</qex> towards that sight.</q> <rj><qau>Sir H. Wotton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Thus will this latter, as the former world,<br/
Still <qex>tend</qex> from bad to worse.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The clouds above me to the white Alps <qex>tend</qex>.</q> <rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be directed, as to any end, object, or purpose; to aim; to have or give a leaning; to exert activity or influence; to serve as a means; to contribute; <as>as, our petitions, if granted, might <ex>tend</ex> to our destruction</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The thoughts of the diligent <qex>tend</qex> only to plenteousness; but of every one that is hasty only to want.</q> <rj><qau>Prov. xxi. 5.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The laws of our religion <qex>tend</qex> to the universal happiness of mankind.</q> <rj><qau>Tillotson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendance</ent><br/
<hw>Tend"ance</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tend</er> to attend, and cf. <er>Attendance</er>.]</ety> <sn>1.</sn> <def>The act of attending or waiting; attendance.</def> <mark>[Archaic]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The breath<br/
Of her sweet <qex>tendance</qex> hovering over him.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Persons in attendance; attendants.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendence</ent><br/
<hw>Tend"ence</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Tendency.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendency</ent><br/
<hw>Tend"en*cy</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tendencies</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>tendents</ets>, <ets>-entis</ets>, p. pr. of <ets>tendere</ets>: cf. F. <ets>tendance</ets>. See <er>Tend</er> to move.]</ety> <def>Direction or course toward any place, object, effect, or result; drift; causal or efficient influence to bring about an effect or result.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Writings of this kind, if conducted with candor, have a more particular <qex>tendency</qex> to the good of their country.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In every experimental science, there is a <qex>tendency</qex> toward perfection.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Disposition; inclination; proneness; drift; scope; aim.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tender</ent><br/
<hw>Tend"er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Tend</er> to attend.  Cf. <er>Attender</er>.]</ety> <sn>1.</sn> <def>One who tends; one who takes care of any person or thing; a nurse.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>A vessel employed to attend other vessels, to supply them with provisions and other stores, to convey intelligence, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- submarine tender, a ship which provides supplies and logistic support to submarines.  A specialization of def. 2. --><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A car attached to a locomotive, for carrying a supply of fuel and water.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tender</ent><br/
<hw>Ten"der</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tendered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tendering</conjf>.]</vmorph> <ety>[F. <ets>tendre</ets> to stretch, stretch out, reach, L. <ets>tendere</ets>. See <er>Tend</er> to move.]</ety> <sn>1.</sn> <fld>(Law)</fld> <def>To offer in payment or satisfaction of a demand, in order to save a penalty or forfeiture; <as>as, to <ex>tender</ex> the amount of rent or debt</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To offer in words; to present for acceptance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>You see how all conditions, how all minds, . . . <qex>tender</qex> down<br/
Their services to Lord Timon.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tender</ent><br/
<hw>Ten"der</hw>, <pos>n.</pos> <sn>1.</sn> <fld>(Law)</fld> <def>An offer, either of money to pay a debt, or of service to be performed, in order to save a penalty or forfeiture, which would be incurred by nonpayment or nonperformance; <as>as, the <ex>tender</ex> of rent due, or of the amount of a note, with interest</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ To constitute a legal tender, such money must be offered as the law prescribes. So also the tender must be at the time and place where the rent or debt ought to be paid, and it must be to the full amount due.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any offer or proposal made for acceptance; <as>as, a <ex>tender</ex> of a loan, of service, or of friendship; a <ex>tender</ex> of a bid for a contract.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>A free, unlimited <qex>tender</qex> of the gospel.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The thing offered; especially, money offered in payment of an obligation.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- 4. (Finance) An offer to buy a certain number of shares of stock of a publicly-traded company at a fixed price, usu. in an attempt to gain control of the company. --><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Legal tender</b></col>. <cd>See under <er>Legal</er>.</cd> -- <col><b>Tender of issue</b></col> <fld>(Law)</fld>, <cd>a form of words in a pleading, by which a party offers to refer the question raised upon it to the appropriate mode of decision.</cd> <au>Burrill.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tender</ent><br/
<hw>Ten"der</hw>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Tenderer</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Tenderest</adjf>.]</amorph> <ety>[F. <ets>tendre</ets>, L. <ets>tener</ets>; probably akin to <ets>tenuis</ets> thin. See <er>Thin</er>.]</ety> <sn>1.</sn> <def>Easily impressed, broken, bruised, or injured; not firm or hard; delicate; <as>as, <ex>tender</ex> plants; <ex>tender</ex> flesh; <ex>tender</ex> fruit</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Sensible to impression and pain; easily pained.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our bodies are not naturally more <qex>tender</qex> than our faces.</q> <rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Physically weak; not hardly or able to endure hardship; immature; effeminate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>tender</qex> and delicate woman among you.</q> <rj><qau>Deut. xxviii. 56.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Susceptible of the softer passions, as love, compassion, kindness; compassionate; pitiful; anxious for another's good; easily excited to pity, forgiveness, or favor; sympathetic.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Lord is very pitiful, and of <qex>tender</qex> mercy.</q> <rj><qau>James v. 11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I am choleric by my nature, and <qex>tender</qex> by my temper.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Exciting kind concern; dear; precious.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I love Valentine,<br/
Whose life's as <qex>tender</qex> to me as my soul!</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Careful to save inviolate, or not to injure; -- with <xex>of</xex>.</def> <ldquo/<xex>Tender</xex> of property.<rdquo/  <rj><au>Burke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The civil authority should be <qex>tender</qex> of the honor of God and religion.</q> <rj><qau>Tillotson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Unwilling to cause pain; gentle; mild.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>You, that are thus so <qex>tender</qex> o'er his follies,<br/
Will never do him good.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>Adapted to excite feeling or sympathy; expressive of the softer passions; pathetic; <as>as, <ex>tender</ex> expressions; <ex>tender</ex> expostulations; a <ex>tender</ex> strain</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>Apt to give pain; causing grief or pain; delicate; <as>as, a <ex>tender</ex> subject</as>.</def> <ldquo/Things that are <xex>tender</xex> and unpleasing.<rdquo/  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Naut.)</fld> <def>Heeling over too easily when under sail; -- said of a vessel.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ex>Tender</ex> is sometimes used in the formation of self-explaining compounds; <as>as, <ex>tender</ex>-footed, <ex>tender</ex>-looking, <ex>tender</ex>-minded, <ex>tender</ex>-mouthed, and the like</as>.</note><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Delicate; effeminate; soft; sensitive; compassionate; kind; humane; merciful; pitiful.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tender</ent><br/
<hw>Ten"der</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>tendre</ets>.]</ety> <def>Regard; care; kind concern.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tender</ent><br/
<hw>Ten"der</hw>, <pos>v. t.</pos> <def>To have a care of; to be tender toward; hence, to regard; to esteem; to value.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>For first, next after life, he <qex>tendered</qex> her good.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Tender</qex> yourself more dearly.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To see a prince in want would move a miser's charity. Our western princes <qex>tendered</qex> his case, which they counted might be their own.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenderfoot</ent><br/
<hw>Ten"der*foot`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A delicate person; one not inured to the hardship and rudeness of pioneer life.</def> <mark>[Slang, Western U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>See <er>Boy scout</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tender-hearted</ent><br/
<hw>Ten"der-heart`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having great sensibility; susceptible of impressions or influence; affectionate; pitying; sensitive.</def> -- <wordforms><wf>Ten"der-heart`ed*ly</wf>, <pos>adv.</pos> -- <wf>Ten"der-heart`ed*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>Rehoboam was young and <qex>tender-hearted</qex>, and could not withstand them.</q> <rj><qau>2 Chron. xiii. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Be ye kind one to another, <qex>tender-hearted</qex>.</q> <rj><qau>Eph. iv. 32.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tender-hefted</ent><br/
<hw>Ten"der-heft`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having great tenderness; easily moved.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenderling</ent><br/
<hw>Ten"der*ling</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One made tender by too much kindness; a fondling.</def> <mark>[R.]</mark>  <rj><au>W. Harrison (1586).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>One of the first antlers of a deer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenderloin</ent><br/
<hw>Ten"der*loin`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A strip of tender flesh on either side of the vertebral column under the short ribs, in the hind quarter of beef and pork. It consists of the psoas muscles.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn>  <def>In New York City, the region which is the center of the night life of fashionable amusement, including the  majority of the theaters, etc., centering on Broadway. The term orig. designates the old twenty-ninth police precinct, in this region, which afforded the police great opportunities for profit through conniving at vice and lawbreaking, one captain being reported to have said on being transferred there that whereas he had been eating chuck steak he would now eat tenderlion. Hence, in some other cities, a district largely devoted to night amusement, or, sometimes, to vice.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tenderly</ent><br/
<hw>Ten"der*ly</hw>, <pos>adv.</pos> <def>In a tender manner; with tenderness; mildly; gently; softly; in a manner not to injure or give pain; with pity or affection; kindly.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenderness</ent><br/
<hw>Ten"der*ness</hw>, <pos>n.</pos> <def>The quality or state of being tender (in any sense of the adjective).</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Benignity; humanity; sensibility; benevolence; kindness; pity; clemency; mildness; mercy.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendinous</ent><br/
<hw>Ten"di*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>tendineux</ets>.]</ety> <sn>1.</sn> <def>Pertaining to a tendon; of the nature of tendon.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Full of tendons; sinewy; <as>as, nervous and <ex>tendinous</ex> parts of the body</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendment</ent><br/
<hw>Tend"ment</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Attendance; care.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendon</ent><br/
<hw>Ten"don</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>tendere</ets> to stretch, extend. See <er>Tend</er> to move.]</ety> <fld>(Anat.)</fld> <def>A tough insensible cord, bundle, or band of fibrous connective tissue uniting a muscle with some other part; a sinew.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tendon reflex</b></col> <fld>(Physiol.)</fld>, <cd>a kind of reflex act in which a muscle is made to contract by a blow upon its tendon. Its absence is generally a sign of disease. See <cref>Knee jerk</cref>, under <er>Knee</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendonous</ent><br/
<hw>Ten"don*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Tendinous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendosynovitis</ent><br/
\'d8<hw>Ten`do*syn`o*vi"tis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Tendon</er>, and <er>Synovitis</er>.]</ety> <def>See <er>Tenosynovitis</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendrac</ent><br/
<hw>Ten"drac</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tenrec</er>.]</ety> <fld>(Zool.)</fld> <def>Any one of several species of small insectivores of the family <fam>Centetidae</fam>, belonging to <gen>Ericulus</gen>, <gen>Echinope</gen>, and related genera, native of Madagascar. They are more or less spinose and resemble the hedgehog in habits. The rice tendrac (<spn>Oryzorictes hora</spn>) is very injurious to rice crops. Some of the species are called also <stype>tenrec</stype>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendre</ent><br/
\'d8<hw>Ten"dre</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>Tender feeling or fondness; affection.</def></p>

<p><q>You poor friendless creatures are always having some foolish <qex>tendre</qex>.</q>  <rj><qau>Thackeray.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tendresse</ent><br/
<hw>Ten*dresse"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>Tender feeling; fondness.</def> <mark>[Obs., except as a French word]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tendril</ent><br/
<hw>Ten"dril</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Shortened fr. OF. <ets>tendrillon</ets>, fr. F. <ets>tendre</ets> tender; hence, properly, the tender branch or spring of a plant: cf. F. <ets>tendrille</ets>. See <er>Tender</er>, <pos>a.</pos>, and cf. <er>Tendron</er>.]</ety> <fld>(Bot.)</fld> <def>A slender, leafless portion of a plant by which it becomes attached to a supporting body, after which the tendril usually contracts by coiling spirally.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Tendrils may represent the end of a stem, as in the grapevine; an axillary branch, as in the passion flower; stipules, as in the genus Smilax; or the end of a leaf, as in the pea.</note><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1485 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendril</ent><br/
<hw>Ten"dril</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Clasping; climbing as a tendril.</def> <mark>[R.]</mark>  <rj><au>Dyer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendrilled</ent><br/
<ent>Tendriled</ent><br/
<mhw>{ <hw>Ten"driled</hw>, <hw>Ten"drilled</hw>  }</mhw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Bot.)</fld> <def>Furnished with tendrils, or with such or so many, tendrils.</def> <ldquo/The <xex>thousand tendriled</xex> vine.<rdquo/  <rj><au>Southey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendron</ent><br/
<hw>Ten"dron</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.  Cf. <er>Tendril</er>.]</ety> <def>A tendril.</def> <mark>[Obs.]</mark>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tendry</ent><br/
<hw>Ten"dry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A tender; an offer.</def> <mark>[Obs.]</mark>  <rj><au>Heylin.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tene</ent><br/
<hw>Tene</hw> <pr>(?)</pr>, <pos>n. & v.</pos> <def>See 1st and 2d <er>Teen</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenebrae</ent><br/
\'d8<hw>Ten"e*brae</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., pl., darkness.]</ety> <fld>(R. C. Ch.)</fld> <def>The matins and lauds for the last three days of Holy Week, commemorating the sufferings and death of Christ, -- usually sung on the afternoon or evening of Wednesday, Thursday, and Friday, instead of on the following days.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenebricose</ent><br/
<hw>Te*neb"ri*cose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tenebricosus</ets>.]</ety> <def>Tenebrous; dark; gloomy.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenebrific</ent><br/
<hw>Ten`e*brif"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tenebrae</ets> darkness + <ets>facere</ets> to make.]</ety> <def>Rendering dark or gloomy; tenebrous; gloomy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It lightens, it brightens,<br/
The <qex>tenebrific</qex> scene.</q> <rj><qau>Burns.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Where light<br/
Lay fitful in a <qex>tenebrific</qex> time.</q> <rj><qau>R. Browning.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenebrificous</ent><br/
<hw>Ten`e*brif"ic*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Tenebrific.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Authors who are <qex>tenebrificous</qex> stars.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenebrious</ent><br/
<hw>Te*ne"bri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Tenebrous.</def>  <rj><au>Young.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenebrose</ent><br/
<hw>Ten"e*brose`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Characterized by darkness or gloom; tenebrous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenebrosity</ent><br/
<hw>Ten`e*bros"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being tenebrous; tenebrousness.</def>  <rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenebrous</ent><br/
<hw>Ten"e*brous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tenebrosus</ets>, fr. <ets>tenebrae</ets> darkness: cf. F. <ets>t<eacute/n<eacute/breux</ets>.]</ety> <def>Dark; gloomy; dusky; tenebrious.</def> -- <wordforms><wf>Ten"e*brous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>The most dark, <qex>tenebrous</qex> night.</q> <rj><qau>J. Hall (1565).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The towering and <qex>tenebrous</qex> boughts of the cypress.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenement</ent><br/
<hw>Ten"e*ment</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>tenement</ets> a holding, a fief, F. <ets>t<egrave/nement</ets>, LL. <ets>tenementum</ets>, fr. L. <ets>tenere</ets> to hold. See <er>Tenant</er>.]</ety> <sn>1.</sn> <fld>(Feud. Law)</fld> <def>That which is held of another by service; property which one holds of a lord or proprietor in consideration of some military or pecuniary service; fief; fee.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Common Law)</fld> <def>Any species of permanent property that may be held, so as to create a tenancy, as lands, houses, rents, commons, an office, an advowson, a franchise, a right of common, a peerage, and the like; -- called also <altname>free tenements</altname> <it>or</it> <altname>frank tenements</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The thing held is a <qex>tenement</qex>, the possessor of it a <ldquo/tenant,<rdquo/ and the manner of possession is called <ldquo/tenure.<rdquo/</q> <rj><qau>Blackstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A dwelling house; a building for a habitation; also, an apartment, or suite of rooms, in a building, used by one family; often, a house erected to be rented.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Fig.: Dwelling; abode; habitation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Who has informed us that a rational soul can inhabit no <qex>tenement</qex>, unless it has just such a sort of frontispiece?</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A <cref>tenement house</cref>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Tenement house</b></col>, <cd>commonly, a dwelling house erected for the purpose of being rented, and divided into separate apartments or tenements for families.  The term is often applied to apartment houses occupied by poor families, often overcrowded and in poor condition.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><syn><b>Syn.</b> -- House; dwelling; habitation.</syn> <usage> -- <er>Tenement</er>, <er>House</er>.  There may be many <xex>houses</xex> under one roof, but they are completely separated from each other by party walls. A <xex>tenement</xex> may be detached by itself, or it may be part of a house divided off for the use of a family.  In modern usage, a <ex>tenement</ex> or <ex>tenement house</ex> most commonly refers to the meaning given for <cref>tenement house</cref>, above.</usage><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Tenemental</ent><br/
<hw>Ten`e*men"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to a tenement; capable of being held by tenants.</def>  <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenementary</ent><br/
<hw>Ten`e*men"ta*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being leased; held by tenants.</def>  <rj><au>Spelman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenent</ent><br/
<hw>Ten"ent</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tenent</ets> they hold, 3d pers. pl. pres. of <ets>tenere</ets>.]</ety> <def>A tenet.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Sanderson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teneral</ent><br/
<hw>Ten"er*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tener</ets>, <ets>-eris</ets>, tender, delicate.]</ety> <fld>(Zool.)</fld> <def>Of, pertaining to, or designating, a condition assumed by the imago of certain Neuroptera, after exclusion from the pupa. In this state the insect is soft, and has not fully attained its mature coloring.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teneriffe</ent><br/
<hw>Ten`er*iffe"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A white wine resembling Madeira in taste, but more tart, produced in Teneriffe, one of the Canary Islands; -- called also <altname>Vidonia</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenerity</ent><br/
<hw>Te*ner"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>teneritas</ets>. See <er>Tender</er>, <pos>a.</pos>]</ety> <def>Tenderness.</def> <mark>[Obs.]</mark>  <rj><au>Ainsworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenesmic</ent><br/
<hw>Te*nes"mic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Med.)</fld> <def>Of or pertaining to tenesmus; characterized by tenesmus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenesmus</ent><br/
\'d8<hw>Te*nes"mus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/, fr. <?/ to stretch: cf. L. <ets>tenesmos</ets>.]</ety> <fld>(Med.)</fld> <def>An urgent and distressing sensation, as if a discharge from the intestines must take place, although none can be effected; -- always referred to the lower extremity of the rectum.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vesical tenesmus</b></col>, <cd>a similar sensation as to the evacuation of urine, referred to the region of the bladder.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenet</ent><br/
<hw>Ten"et</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tenet</ets> he holds, fr. <ets>tenere</ets> to hold. See <er>Tenable</er>.]</ety> <def>Any opinion, principle, dogma, belief, or doctrine, which a person holds or maintains as true; <as>as, the <ex>tenets</ex> of Plato or of Cicero</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That al animals of the land are in their kind in the sea, . . . is a <qex>tenet</qex> very questionable.</q> <rj><qau>Sir T. Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The religious <qex>tenets</qex> of his family he had early renounced with contempt.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Dogma; doctrine; opinion; principle; position. See <er>Dogma</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenfold</ent><br/
<hw>Ten"fold`</hw> <pr>(?)</pr>, <pos>a. & adv.</pos> <def>In tens; consisting of ten in one; ten times repeated.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The grisly Terror . . . grew <qex>tenfold</qex><br/
More dreadful and deform.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenia</ent><br/
\'d8<hw>Te"ni*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety> <def>See <er>Taenia</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenioid</ent><br/
<hw>Te"ni*oid</hw> <pr>(?)</pr>, <pos>a.</pos> <def>See <er>Taenoid</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tennantite</ent><br/
<hw>Ten"nant*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Named after <person>Smithson <etsep>Tennant</etsep></person>, an English chemist.]</ety> <fld>(Min.)</fld> <def>A blackish lead-gray mineral, closely related to tetrahedrite.  It is essentially a sulphide of arsenic and copper.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenne</ent><br/
\'d8<hw>Ten`n<eacute/"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Tawny</er>.]</ety> <fld>(Her.)</fld> <def>A tincture, rarely employed, which is considered as an orange color or bright brown. It is represented by diagonal lines from sinister to dexter, crossed by vertical lines.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tennis</ent><br/
<hw>Ten"nis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>tennes</ets>, <ets>tenies</ets>, <ets>tenyse</ets>; of uncertain origin, perhaps fr. F. <ets>tenez</ets> hold or take it, fr. <ets>tenir</ets> to hold (see <er>Tenable</er>).]</ety> <def>A play in which a ball is driven to and fro, or kept in motion by striking it with a racket or with the open hand.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His easy bow, his good stories, his style of dancing and playing <qex>tennis</qex>, . . . were familiar to all London.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Court tennis</b></col>, <cd>the old game of tennis as played within walled courts of peculiar construction; -- distinguished from <contr>lawn tennis</contr>.</cd> -- <col><b>Lawn tennis</b></col>. <cd>See under <er>Lawn</er>, <pos>n.</pos></cd> -- <col><b>Tennis court</b></col>, <cd>a place or court for playing the game of tennis.</cd> <au>Shak.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tennis</ent><br/
<hw>Ten"nis</hw>, <pos>v. t.</pos> <def>To drive backward and forward, as a ball in playing tennis.</def> <mark>[R.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenno</ent><br/
\'d8<hw>Ten*no"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Jap. <ets>tenn<omac/</ets>, fr. Chin. <ets>t'ien</ets> heaven + <ets>wang</ets> king.]</ety> <def>Lit., King of Heaven; -- a title of the emperor of Japan as the head of the Shinto religion.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tennu</ent><br/
<hw>Ten"nu</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The tapir.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tennysonian</ent><br/
<hw>Ten`ny*so"ni*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to <person>Alfred (Lord) Tennyson</person>, the English poet (1809-92); resembling, or having some of the characteristics of, his poetry, as simplicity, pictorial quality, sensuousness, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Ten-o'clock</ent><br/
<hw>Ten"-o'*clock`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A plant, the star-of-Bethlehem. See under <er>Star</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenon</ent><br/
<hw>Ten"on</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. <ets>tenir</ets> to hold. See <er>Tenable</er>.]</ety> <fld>(Carp. & Join.)</fld> <def>A projecting member left by cutting away the wood around it, and made to insert into a mortise, and in this way secure together the parts of a frame; especially, such a member when it passes entirely through the thickness of the piece in which the mortise is cut, and shows on the other side.  Cf. <er>Tooth</er>, <er>Tusk</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tenon saw</b></col>, <cd>a saw with a thin blade, usually stiffened by a brass or steel back, for cutting tenons.</cd> <altsp>[Corruptly written <asp>tenant saw</asp>.]</altsp> <au>Gwilt.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenon</ent><br/
<hw>Ten"on</hw>, <pos>v. t.</pos> <def>To cut or fit for insertion into a mortise, as the end of a piece of timber.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenonian</ent><br/
<hw>Te*no"ni*an</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <def>Discovered or described by M. <etsep>Tenon</etsep>, a French anatomist.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tenonian capsule</b></col> <fld>(Anat.)</fld>, <cd>a lymphatic space inclosed by a delicate membrane or fascia (the <xex>fascia of Tenon</xex>) between the eyeball and the fat of the orbit; -- called also <altname>capsule of Tenon</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenonitis</ent><br/
\'d8<hw>Ten`o*ni"tis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., Gr. <grk>te`nwn</grk> tendon + <ets>-itis</ets>.]</ety> <fld>(Med.)</fld> <def>Inflammation of a tendon.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tenonitis</ent><br/
\'d8<hw>Ten`o*ni"tis</hw>, <pos>n.</pos> <ety>[NL. See <er>Tenonian</er>, <er>-itis</er>.]</ety> <def>Inflammation of the Tenonian capsule.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tenor</ent><br/
<hw>Ten"or</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., from <ets>tenere</ets> to hold; hence, properly, a holding on in a continued course: cf. F. <ets>teneur</ets>. See <er>Tenable</er>, and cf. <er>Tenor</er> a kind of voice.]</ety> <sn>1.</sn> <def>A state of holding on in a continuous course; manner of continuity; constant mode; general tendency; course; career.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Along the cool sequestered vale of life<br/
They kept the noiseless <qex>tenor</qex> of their away.</q> <rj><qau>Gray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That course of thought which holds on through a discourse; the general drift or course of thought; purport; intent; meaning; understanding.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When it [the bond] is paid according to the <qex>tenor</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Does not the whole <qex>tenor</qex> of the divine law positively require humility and meekness to all men?</q> <rj><qau>Spart.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Stamp; character; nature.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This success would look like chance, if it were perpetual, and always of the same <qex>tenor</qex>.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Law)</fld> <def>An exact copy of a writing, set forth in the words and figures of it. It differs from <xex>purport</xex>, which is only the substance or general import of the instrument.</def>  <rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <ety>[F. <ets>t<eacute/nor</ets>, L. <ets>tenor</ets>, properly, a holding; -- so called because the tenor was the voice which took and held the principal part, the plain song, air, or tune, to which the other voices supplied a harmony above and below: cf. It. <ets>tenore</ets>.]</ety> <fld>(Mus.)</fld> <sd>(a)</sd> <def>The higher of the two kinds of voices usually belonging to adult males; hence, the part in the harmony adapted to this voice; the second of the four parts in the scale of sounds, reckoning from the base, and originally the air, to which the other parts were auxillary.</def> <sd>(b)</sd> <def>A person who sings the tenor, or the instrument that play it.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Old Tenor</b></col>, <col><b>New Tenor</b></col>, <col><b>Middle Tenor</b></col></mcol>, <cd>different descriptions of paper money, issued at different periods, by the American colonial governments in the last century.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenorrhaphy</ent><br/
<hw>Te*nor"rha*phy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>te`nwn</grk> tendon + <ets>-rhaphy</ets>.]</ety> <fld>(Surg.)</fld> <def>Suture of a tendon.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tenositis</ent><br/
\'d8<hw>Ten`o*si"tis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>te`nwn</grk> tendon + <ets>-itis</ets>.]</ety> <fld>(Med.)</fld> <def>Inflammation of a tendon.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tenosynovitis</ent><br/
\'d8<hw>Ten`o*syn`o*vi"tis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>te`nwn</grk> a tendon + E. <ets>synovitis</ets>.]</ety> <fld>(Med.)</fld> <def>Inflammation of the synovial sheath of a tendon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenotome</ent><br/
<hw>Ten"o*tome</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Surg.)</fld> <def>A slender knife for use in the operation of tenotomy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenotomy</ent><br/
<hw>Te*not"o*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>te`nwn</grk> a tendon + <grk>te`mnein</grk> to cut.]</ety> <fld>(Surg.)</fld> <def>The division of a tendon, or the act of dividing a tendon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenpenny</ent><br/
<hw>Ten"pen*ny</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Valued or sold at ten pence; <as>as, a <ex>tenpenny</ex> cake</as>. See 2d <er>Penny</er>, <pos>n.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenpenny</ent><br/
<hw>Ten"pen*ny</hw>, <pos>a.</pos> <def>Denoting a size of nails. See 1st <er>Penny</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenpins</ent><br/
<hw>Ten"pins</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A game resembling ninepins, but played with ten pins. See <er>Ninepins</er>.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ten-pounder</ent><br/
<hw>Ten"-pound`er</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A large oceanic fish (<spn>Elops saurus</spn>) found in the tropical parts of all the oceans. It is used chiefly for bait.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenrec</ent><br/
<hw>Ten"rec</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native name: cf. F. <ets>tanrac</ets>, <ets>tanrec</ets>, <ets>tandrec</ets>.]</ety> <fld>(Zool.)</fld> <def>A small insectivore (<spn>Centetes ecaudatus</spn>), native of Madagascar, but introduced also into the islands of Bourbon and Mauritius; -- called also <altname>tanrec</altname>. The name is applied to other allied genera. See <er>Tendrac</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tense</ent><br/
<hw>Tense</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>tens</ets>, properly, time, F. <ets>temps</ets> time, tense. See <er>Temporal</er> of time, and cf. <er>Thing</er>.]</ety> <fld>(Gram.)</fld> <def>One of the forms which a verb takes by inflection or by adding auxiliary words, so as to indicate the time of the action or event signified; the modification which verbs undergo for the indication of time.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The primary simple tenses are three: those which express time <xex>past</xex>, <xex>present</xex>, and <xex>future</xex>; but these admit of modifications, which differ in different languages.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tense</ent><br/
<hw>Tense</hw>, <pos>a.</pos> <ety>[L. <ets>tensus</ets>, p. p. of <ets>tendere</ets> to stretch. See <er>Tend</er> to move, and cf. <er>Toise</er>.]</ety> <def>Stretched tightly; strained to stiffness; rigid; not lax; <as>as, a <ex>tense</ex> fiber</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The temples were sunk, her forehead was <qex>tense</qex>, and a fatal paleness was upon her.</q> <rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Tense"ly</wf>, <pos>adv.</pos> -- <wf>Tense"ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensibility</ent><br/
<hw>Ten`si*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being tensible; tensility.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensible</ent><br/
<hw>Ten"si*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Tense</er>, <pos>a.</pos>]</ety> <def>Capable of being extended or drawn out; ductile; tensible.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Gold . . . is likewise the most flexible and <qex>tensible</qex>.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensile</ent><br/
<hw>Ten"sile</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Tense</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>Of or pertaining to extension; <as>as, <ex>tensile</ex> strength</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Capable of extension; ductile; tensible.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensiled</ent><br/
<hw>Ten"siled</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Made tensile.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensility</ent><br/
<hw>Ten*sil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being tensile, or capable of extension; tensibility; <as>as, the <ex>tensility</ex> of the muscles</as>.</def>  <rj><au>Dr. H. Mere.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tension</ent><br/
<hw>Ten"sion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tensio</ets>, from <ets>tendere</ets>, <ets>tensum</ets>, to stretch: cf. F. <ets>tension</ets>. See <er>Tense</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>The act of stretching or straining; the state of being stretched or strained to stiffness; the state of being bent strained; <as>as, the <ex>tension</ex> of the muscles, <ex>tension</ex> of the larynx</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: Extreme strain of mind or excitement of feeling; intense effort.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The degree of stretching to which a wire, cord, piece of timber, or the like, is strained by drawing it in the direction of its length; strain.</def>  <rj><au>Gwilt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mech.)</fld> <def>The force by which a part is pulled when forming part of any system in equilibrium or in motion; <as>as, the <ex>tension</ex> of a srting supporting a weight equals that weight</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A device for checking the delivery of the thread in a sewing machine, so as to give the stitch the required degree of tightness.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Physics)</fld> <def>Expansive force; the force with which the particles of a body, as a gas, tend to recede from each other and occupy a larger space; elastic force; elasticity; <as>as, the <ex>tension</ex> of vapor; the <ex>tension</ex> of air</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Elec.)</fld> <def>The quality in consequence of which an electric charge tends to discharge itself, as into the air by a spark, or to pass from a body of greater to one of less electrical potential. It varies as the quantity of electricity upon a given area.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Tension brace</b></col>, <it>or</it> <col><b>Tension member</b></col></mcol> <fld>(Engin.)</fld>, <cd>a brace or member designed to resist tension, or subjected to tension, in a structure.</cd> -- <col><b>Tension rod</b></col> <fld>(Engin.)</fld>, <cd>an iron rod used as a tension member to strengthen timber or metal framework, roofs, or the like.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensioned</ent><br/
<hw>Ten"sioned</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Extended or drawn out; subjected to tension.</def> <ldquo/A highly <xex>tensioned</xex> string.<rdquo/  <rj><au>Tyndall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensity</ent><br/
<hw>Ten"si*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being tense, or strained to stiffness; tension; tenseness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensive</ent><br/
<hw>Ten"sive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>tensif</ets>. See <er>Tense</er>, <pos>a.</pos>]</ety> <def>Giving the sensation of tension, stiffness, or contraction.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>tensive</qex> pain from distension of the parts.</q> <rj><qau>Floyer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensor</ent><br/
<hw>Ten"sor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Tension</er>.]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>A muscle that stretches a part, or renders it tense.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geom.)</fld> <def>The ratio of one vector to another in length, no regard being had to the direction of the two vectors; -- so called because considered as a <xex>stretching</xex> factor in changing one vector into another. See <er>Versor</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ten-strike</ent><br/
<hw>Ten"-strike`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Tenpins)</fld> <def>A knocking down of all ten pins at one delivery of the ball<-- also, strike-->.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any quick, decisive stroke or act.</def> <mark>[Colloq. U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tensure</ent><br/
<hw>Ten"sure</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tensura</ets>. See <er>Tension</er>.]</ety> <def>Tension.</def> <mark>[Obs.]</mark>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tent</ent><br/
<hw>Tent</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>tinto</ets>, properly, deep-colored, fr. L. <ets>tinctus</ets>, p. p. of <ets>tingere</ets> to dye. See <er>Tinge</er>, and cf. <er>Tint</er>, <er>Tinto</er>.]</ety> <def>A kind of wine of a deep red color, chiefly from Galicia or Malaga in Spain; -- called also <altname>tent wine</altname>, and <altname>tinta</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tent</ent><br/
<hw>Tent</hw>, <pos>n.</pos> <ety>[Cf. <er>Attent</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>Attention; regard, care.</def> <mark>[Obs. or Prov. Eng. & Scot.]</mark>  <rj><au>Lydgate.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Intention; design.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tent</ent><br/
<hw>Tent</hw>, <pos>v. t.</pos> <def>To attend to; to heed; hence, to guard; to hinder.</def> <mark>[Prov. Eng. & Scot.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tent</ent><br/
<hw>Tent</hw>, <pos>v. t.</pos> <ety>[OF. <ets>tenter</ets>. See <er>Tempt</er>.]</ety> <def>To probe or to search with a tent; to keep open with a tent; <as>as, to <ex>tent</ex> a wound</as>. Used also figuratively.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I'll <qex>tent</qex> him to the quick.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tent</ent><br/
<hw>Tent</hw>, <pos>n.</pos> <ety>[F. <ets>tente</ets>. See <er>Tent</er> to probe.]</ety> <fld>(Surg.)</fld> <sd>(a)</sd> <def>A roll of lint or linen, or a conical or cylindrical piece of sponge or other absorbent, used chiefly to dilate a natural canal, to keep open the orifice of a wound, or to absorb discharges.</def> <sd>(b)</sd> <def>A probe for searching a wound.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>tent</qex> that searches<br/
To the bottom of the worst.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1486 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tent</ent><br/
<hw>Tent</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>tente</ets>, F. <ets>tente</ets>, LL. <ets>tenta</ets>, fr. L. <ets>tendere</ets>, <ets>tentum</ets>, to stretch. See <er>Tend</er> to move, and cf. <er>Tent</er> a roll of lint.]</ety> <sn>1.</sn> <def>A pavilion or portable lodge consisting of skins, canvas, or some strong cloth, stretched and sustained by poles, -- used for sheltering persons from the weather, especially soldiers in camp.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Within his <qex>tent</qex>, large as is a barn.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Her.)</fld> <def>The representation of a tent used as a bearing.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tent bed</b></col>, <cd>a high-post bedstead curtained with a tentlike canopy.</cd> -- <col><b>Tent caterpillar</b></col> <fld>(Zool.)</fld>, <cd>any one of several species of gregarious caterpillars which construct on trees large silken webs into which they retreat when at rest. Some of the species are very destructive to fruit trees. The most common American species is the larva of a bombycid moth (<spn>Clisiocampa Americana</spn>). Called also <altname>lackery caterpillar</altname>, and <altname>webworm</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tent</ent><br/
<hw>Tent</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tented</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Tenting</conjf>.]</vmorph> <def>To lodge as a tent; to tabernacle.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>We 're <qex>tenting</qex> to-night on the old camp ground.</q> <rj><qau>W. Kittredge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentacle</ent><br/
<hw>Ten"ta*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. <ets>tentaculum</ets>, from L. <ets>tentare</ets> to handle, feel: cf. F. <ets>tentacule</ets>. See <er>Tempt</er>.]</ety> <fld>(Zool.)</fld> <def>A more or less elongated process or organ, simple or branched, proceeding from the head or cephalic region of invertebrate animals, being either an organ of sense, prehension, or motion.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tentacle sheath</b></col> <fld>(Zool.)</fld>, <cd>a sheathlike structure around the base of the tentacles of many mollusks.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentacled</ent><br/
<hw>Ten"ta*cled</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Having tentacles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentacular</ent><br/
<hw>Ten*tac"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>tentaculaire</ets>.]</ety> <fld>(Zool.)</fld> <def>Of or pertaining to a tentacle or tentacles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentaculata</ent><br/
\'d8<hw>Ten*tac`u*la"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.]</ety> <fld>(Zool.)</fld> <def>A division of Ctenophora including those which have two long tentacles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentaculated</ent><br/
<ent>Tentaculate</ent><br/
<mhw>{ <hw>Ten*tac"u*late</hw> <pr>(?)</pr>, <hw>Ten*tac"u*la`ted</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <fld>(Zool.)</fld> <def>Having tentacles, or organs like tentacles; tentacled.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentaculifera</ent><br/
\'d8<hw>Ten`ta*cu*lif"e*ra</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Suctoria</er>, 1.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentaculiferous</ent><br/
<hw>Ten`ta*cu*lif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tentaculum</ets> + <ets>-ferous</ets>.]</ety> <fld>(Zool.)</fld> <def>Producing or bearing tentacles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentaculiform</ent><br/
<hw>Ten`ta*cu"li*form</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Shaped like a tentacle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentaculite</ent><br/
<hw>Ten*tac"u*lite</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Paleon.)</fld> <def>Any one of numerous species of small, conical fossil shells found in Paleozoic rocks. They are supposed to be pteropods.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentaculocyst</ent><br/
<hw>Ten*tac"u*lo*cyst</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tentaculum</ets> + <ets>cyst</ets>.]</ety> <fld>(Zool.)</fld> <def>One of the auditory organs of certain medusae; -- called also <altname>auditory tentacle</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentaculum</ent><br/
\'d8<hw>Ten*tac"u*lum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tentacula</plw> <pr>(#)</pr>.</plu> <ety>[NL. See <er>Tentacle</er>.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>A tentacle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>One of the stiff hairs situated about the mouth, or on the face, of many animals, and supposed to be tactile organs; a tactile hair.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentage</ent><br/
<hw>Tent"age</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Tent</er> a pavilion.]</ety> <def>A collection of tents; an encampment.</def> <mark>[Obs.]</mark>  <rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentation</ent><br/
<hw>Ten*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tentatio</ets>: cf. F. <ets>tentation</ets>. See <er>Temptation</er>.]</ety> <sn>1.</sn> <def>Trial; temptation.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mech.)</fld> <def>A mode of adjusting or operating by repeated trials or experiments.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentative</ent><br/
<hw>Ten*ta"tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tentare</ets> to try: cf. F. <ets>tentatif</ets>. See <er>Tempt</er>.]</ety> <def>Of or pertaining to a trial or trials; essaying; experimental.</def> <ldquo/A slow, <xex>tentative</xex> manner.<rdquo/ <au>Carlyle.</au> -- <wordforms><wf>Ten*ta"tive*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentative</ent><br/
<hw>Ten*ta"tive</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>tentative</ets>.]</ety> <def>An essay; a trial; an experiment.</def>  <rj><au>Berkley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tented</ent><br/
<hw>Tent"ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Covered with tents.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenter</ent><br/
<hw>Ten"ter</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who takes care of, or tends, machines in a factory; a kind of assistant foreman.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mach.)</fld> <def>A kind of governor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenter</ent><br/
<hw>Ten"ter</hw>, <pos>n.</pos> <ety>[OE. <ets>tenture</ets>, <ets>tentoure</ets>, OF. <ets>tenture</ets> a stretching, spreading, F. <ets>tenture</ets> hangings, tapestry, from L. <ets>tendere</ets>, <ets>tentum</ets>, to stretch. See <er>Tend</er> to move.]</ety> <def>A machine or frame for stretching cloth by means of hooks, called <xex>tenter-hooks</xex>, so that it may dry even and square.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tenter ground</b></col>, <cd>a place where tenters are erected.</cd> -- <col><b>Tenter-hook</b></col>, <cd>a sharp, hooked nail used for fastening cloth on a tenter.</cd> -- <mcol><col><b>To be on the tenters</b></col>, <col><b>To be on the tenter-hooks</b></col> <it>or</it> <col><b>To be on tenterhooks</b></col></mcol>, <cd>to be on the stretch; to be in distress, uneasiness, or suspense.</cd> <au>Hudibras.</au></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Tenter</ent><br/
<hw>Ten"ter</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tentered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tentering</conjf>.]</vmorph> <def>To admit extension.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Woolen cloth will <qex>tenter</qex>, linen scarcely.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenter</ent><br/
<hw>Ten"ter</hw>, <pos>v. t.</pos> <def>To hang or stretch on, or as on, tenters.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentful</ent><br/
<hw>Tent"ful</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tentfuls</plw> <pr>(<?/)</pr>.</plu> <def>As much, or as many, as a tent will hold.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenth</ent><br/
<hw>Tenth</hw> <pr>(t<ecr/nth)</pr>, <pos>a.</pos> <ety>[From <er>Ten</er>: cf. OE. <ets>tethe</ets>, AS. <ets>te<oacute/<edh/a</ets>. See <er>Ten</er>, and cf. <er>Tithe</er>.]</ety> <sn>1.</sn> <def>Next in order after the ninth; coming after nine others.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Constituting or being one of ten equal parts into which anything is divided.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenth</ent><br/
<hw>Tenth</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The next in order after the ninth; one coming after nine others.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The quotient of a unit divided by ten; one of ten equal parts into which anything is divided.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The tenth part of annual produce, income, increase, or the like; a tithe.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mus.)</fld> <def>The interval between any tone and the tone represented on the tenth degree of the staff above it, as between one of the scale and three of the octave above; the octave of the third.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <pluf>pl.</pluf> <fld>(Eng. Law)</fld> <sd>(a)</sd> <def>A temporary aid issuing out of personal property, and granted to the king by Parliament; formerly, the real tenth part of all the movables belonging to the subject.</def> <sd>(b)</sd> <fld>(Eccl. Law)</fld> <def>The tenth part of the annual profit of every living in the kingdom, formerly paid to the pope, but afterward transferred to the crown. It now forms a part of the fund called <xex>Queen Anne's Bounty</xex>.</def>
<-- (b) sic. = tithe? what kind of "living"?? prob. living, n. 5 = "the benefice of a clergyman" -->  <rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenthly</ent><br/
<hw>Tenth"ly</hw>, <pos>adv.</pos> <def>In a tenth manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenthmetre</ent><br/
<ent>Tenthmeter</ent><br/
<mhw>{ <hw>Tenth"me`ter</hw>, <hw>Tenth"me`tre</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Physics)</fld> <def>A unit for the measurement of many small lengths, such that 10<exp>10</exp> of these units make one meter; the ten millionth part of a millimeter.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenthredinides</ent><br/
\'d8<hw>Ten`thre*din"i*des</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <?/ a kind of wasp.]</ety> <fld>(Zool.)</fld> <def>A group of Hymneoptera comprising the sawflies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentif</ent><br/
<hw>Ten"tif</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Attentive.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentifly</ent><br/
<hw>Ten"tif*ly</hw>, <pos>adv.</pos> <def>Attentively.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentiginous</ent><br/
<hw>Ten*tig"i*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tentigo</ets>, <ets>-inis</ets>, a tension, lecherousness, fr. <ets>tendere</ets>, <ets>tentum</ets>, to stretch.]</ety> <sn>1.</sn> <def>Stiff; stretched; strained.</def> <mark>[Obs.]</mark>  <rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lustful, or pertaining to lust.</def> <mark>[Obs.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentmaker</ent><br/
<hw>Tent"mak`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One whose occupation it is to make tents.</def>  <rj><au>Acts xviii. 3.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentorium</ent><br/
\'d8<hw>Ten*to"ri*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a tent.]</ety> <fld>(Anat.)</fld> <def>A fold of the dura mater which separates the cerebellum from the cerebrum and often incloses a process or plate of the skull called the <xex>bony tentorium</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentory</ent><br/
<hw>Tent"o*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tentorium</ets> a tent.]</ety> <def>The awning or covering of a tent.</def> <mark>[Obs.]</mark>  <rj><au>Evelyn.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tentwort</ent><br/
<hw>Tent"wort`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A kind of small fern, the wall rue. See under <er>Wall</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenuate</ent><br/
<hw>Ten"u*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tenuated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tenuating</conjf>.]</vmorph> <ety>[L. <ets>tenuatus</ets>, p. p. of <ets>tenuare</ets> to make thin, fr. <ets>tenuis</ets> thin. See <er>Tenuous</er>.]</ety> <def>To make thin; to attenuate.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenuifolious</ent><br/
<hw>Ten`u*i*fo"li*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tenuis</ets> thin + <ets>folium</ets> a leaf.]</ety> <fld>(Bot.)</fld> <def>Having thin or narrow leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenuious</ent><br/
<hw>Te*nu"i*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Tenuous</er>.]</ety> <def>Rare or subtile; tenuous; -- opposed to <xex>dense</xex>.</def> <mark>[Obs.]</mark>  <rj><au>Glanvill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenuiroster</ent><br/
<hw>Ten`u*i*ros"ter</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tenuirosters</plw> <pr>(#)</pr>.</plu> <ety>[NL., fr. L. <ets>tenuis</ets> thin + <ets>rostrum</ets> a beak.]</ety> <fld>(Zool.)</fld> <def>One of the Tenuirostres.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenuirostral</ent><br/
<hw>Ten`u*i*ros"tral</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Thin-billed; -- applied to birds with a slender bill, as the humming birds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenuirostres</ent><br/
\'d8<hw>Ten`u*i*ros"tres</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.]</ety> <fld>(Zool.)</fld> <def>An artificial group of passerine birds having slender bills, as the humming birds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenuis</ent><br/
\'d8<hw>Ten"u*is</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tenues</plw> <pr>(#)</pr>.</plu> <ety>[NL., fr. L. <ets>tenuis</ets> fine, thin. See <er>Tenuous</er>.]</ety> <fld>(Gr. Gram.)</fld> <def>One of the three surd mutes <kappa/, <pi/, <tau/; -- so called in relation to their respective middle letters, or medials, <gamma/, <beta/, <delta/, and their aspirates, <chi/, <phi/, <theta/. The term is also applied to the corresponding letters and articulate elements in other languages.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenuity</ent><br/
<hw>Te*nu"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tenuitas</ets>, from <ets>tenuis</ets> thin: cf. F. <ets>t<eacute/nuit<eacute/</ets>. See <er>Tenuous</er>.]</ety> <sn>1.</sn> <def>The quality or state of being tenuous; thinness, applied to a broad substance; slenderness, applied to anything that is long; <as>as, the <ex>tenuity</ex> of a leaf; the <ex>tenuity</ex> of a hair.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Rarily; rareness; thinness, as of a fluid; <as>as, the <ex>tenuity</ex> of the air; the <ex>tenuity</ex> of the blood</as>.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Poverty; indigence.</def> <mark>[Obs.]</mark>  <rj><au>Eikon Basilike.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Refinement; delicacy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenuous</ent><br/
<hw>Ten"u*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tenuis</ets> thin. See <er>Thin</er>, and cf. <er>Tenuis</er>.]</ety> <sn>1.</sn> <def>Thin; slender; small; minute.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Rare; subtile; not dense; -- said of fluids.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- 3. Fig. <def>Lacking substance, as a tenuous argument.</def> --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tenure</ent><br/
<hw>Ten"ure</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tenure</ets>, OF. <ets>teneure</ets>, fr. F. <ets>tenir</ets> to hold. See <er>Tenable</er>.]</ety> <sn>1.</sn> <def>The act or right of holding, as property, especially real estate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That the <qex>tenure</qex> of estates might rest on equity, the Indian title to lands was in all cases to be quieted.</q> <rj><qau>Bancroft.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eng. Law)</fld> <def>The manner of holding lands and tenements of a superior.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Tenure is inseparable from the idea of property in land, according to the theory of the English law; and this idea of tenure pervades, to a considerable extent, the law of real property in the United States, where the title to land is essentially allodial, and almost all lands are held in fee simple, not of a superior, but the whole right and title to the property being vested in the owner. Tenure, in general, then, is the particular manner of holding real estate, as by exclusive title or ownership, by fee simple, by fee tail, by courtesy, in dower, by copyhold, by lease, at will, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The consideration, condition, or service which the occupier of land gives to his lord or superior for the use of his land.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Manner of holding, in general; <as>as, in absolute governments, men hold their rights by a precarious <ex>tenure</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>All that seems thine own,<br/
Held by the <qex>tenure</qex> of his will alone.</q> <rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tenure by fee alms</b></col>. <fld>(Law)</fld> <cd>See <er>Frankalmoigne</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teocalli</ent><br/
<hw>Te`o*cal"li</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Teocallis</plw> <pr>(#)</pr>.</plu> <ety>[Mexican.]</ety> <def>Literally, God's house; a temple, usually of pyramidal form, such as were built by the aborigines of Mexico, Yucatan, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And Aztec priests upon their <qex>teocallis</qex><br/
Beat the wild war-drums made of serpent's skin.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teosinte</ent><br/
<hw>Te`o*sin"te</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A large grass (<spn>Euchlaena luxurians</spn>) closely related to maize. It is native of Mexico and Central America, but is now cultivated for fodder in the Southern United States and in many warm countries. Called also <altname>Guatemala grass</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tepal</ent><br/
<hw>Tep"al</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>t<eacute/pale</ets>, fr. <ets>p<eacute/tale</ets>, by transposition.]</ety> <fld>(Bot.)</fld> <def>A division of a perianth.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tepee</ent><br/
<hw>Tep*ee"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An Indian wigwam or tent.</def><-- also teepee --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tepefaction</ent><br/
<hw>Tep`e*fac"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Act of tepefying.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tepefy</ent><br/
<hw>Tep"e*fy</hw> <pr>(?)</pr>, <pos>v. t. & i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tepefied</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tepefying</conjf> <pr>(?)</pr>.]</vmorph> <ety>[L. <ets>tepere</ets> to be tepid + <ets>-fy</ets>; cf. L. <ets>tepefacere</ets>. See <er>Tepid</er>.]</ety> <def>To make or become tepid, or moderately warm.</def>  <rj><au>Goldsmith.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tephramancy</ent><br/
<hw>Teph"ra*man`cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ ashes + <ets>-mancy</ets>.]</ety> <def>Divination by the ashes of the altar on which a victim had been consumed in sacrifice.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tephrite</ent><br/
<hw>Teph"rite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ ashes.]</ety> <fld>(Geol.)</fld> <def>An igneous rock consisting essentially of plagioclase and either leucite or nephelite, or both.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tephroite</ent><br/
<hw>Teph"ro*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tephrosia</er>.]</ety> <fld>(Min.)</fld> <def>A silicate of manganese of an ash-gray color.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tephrosia</ent><br/
\'d8<hw>Te*phro"si*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ ash-colored, from <?/ ashes.]</ety> <fld>(Bot.)</fld> <def>A genus of leguminous shrubby plants and herbs, mostly found in tropical countries, a few herbaceous species being North American. The foliage is often ashy-pubescent, whence the name.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>Tephrosia toxicaria</xex> is used in the West Indies and in Polynesia for stupefying fish. <xex>T</xex>. <xex>purpurea</xex> is used medicinally in the East Indies. <xex>T</xex>. <xex>Virginia</xex> is the goat's rue of the United States.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tepid</ent><br/
<hw>Tep"id</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tepidus</ets>, fr. <ets>tepere</ets> to be warm; akin to Skr. <ets>tap</ets> to be warm, <ets>tapas</ets> heat.]</ety> <def>Moderately warm; lukewarm; <as>as, a <ex>tepid</ex> bath; <ex>tepid</ex> rays; <ex>tepid</ex> vapors.</as></def> -- <wordforms><wf>Tep"id*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tepidity</ent><br/
<hw>Te*pid"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>t<eacute/pidit<eacute/</ets>.]</ety> <def>The quality or state of being tepid; moderate warmth; lukewarmness; tepidness.</def>  <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tepor</ent><br/
<hw>Te"por</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr. <ets>tepere</ets> to be tepid.]</ety> <def>Gentle heat; moderate warmth; tepidness.</def>  <rj><au>Arbuthnot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tequila</ent><br/
<hw>Te*qui"la</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An intoxicating liquor made from the maguey in the district of Tequila, Mexico.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ter-</ent><br/
<hw>Ter-</hw> <pr>(?)</pr>. <def>A combining form from L. <xex>ter</xex> signifying <xex>three times</xex>, <xex>thrice</xex>. See <er>Tri-</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teraconic</ent><br/
<hw>Ter`a*con"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Ter</ets>ebic + citr<ets>aconic</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an acid obtained by the distillation of terebic acid, and homologous with citraconic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teracrylic</ent><br/
<hw>Ter`a*cryl"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Ter</ets>pene + <ets>acrylic</ets>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, an acid of the acrylic series, obtained by the distillation of terpenylic acid, as an only substance having a peculiar cheesy odor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teraph</ent><br/
<hw>Ter"aph</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Teraphs</plw> <pr>(<?/)</pr>.</plu> <def>See <er>Teraphim</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teraphim</ent><br/
<hw>Ter"a*phim</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[Heb. <ets>ter<amac/ph<imac/m</ets>.]</ety> <def>Images connected with the magical rites used by those Israelites who added corrupt practices to the patriarchal religion. Teraphim were consulted by the Israelites for oracular answers.</def>  <rj><au>Dr. W. Smith (Bib. Dict.).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terapin</ent><br/
<hw>Ter"a*pin</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Terrapin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teratical</ent><br/
<hw>Te*rat"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/ a wonder.]</ety> <def>Wonderful; ominous; prodigious.</def> <mark>[Obs.]</mark>  <rj><au>Wollaston.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teratogeny</ent><br/
<hw>Ter`a*tog"e*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/, <?/, a wonder, monster + the root of <?/ to be born.]</ety> <fld>(Med.)</fld> <def>The formation of monsters.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teratoid</ent><br/
<hw>Ter"a*toid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/, <?/, monster + <ets>-oid</ets>.]</ety> <def>Resembling a monster; abnormal; of a pathological growth, exceedingly complex or highly organized.</def>  <rj><au>S. D. Gross.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teratological</ent><br/
<hw>Ter`a*to*log"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Biol.)</fld> <def>Of or pertaining to teratology; <as>as, <ex>teratological</ex> changes</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teratology</ent><br/
<hw>Ter`a*tol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/, <?/, a wonder, monster + <ets>-logy</ets>: cf. Gr. <?/ a telling of wonders, and F. <ets>t<eacute/ratologie</ets>.]</ety> <sn>1.</sn> <def>That branch of biological science which treats of monstrosities, malformations, or deviations from the normal type of structure, either in plants or animals.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Affectation of sublimity; bombast.</def> <mark>[Obs.]</mark>  <rj><au>Bailey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teratoma</ent><br/
<hw>Ter`a*to"ma</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/, <?/, monster + <ets>-oma</ets>.]</ety> <fld>(Med.)</fld> <def>A tumor, sometimes found in newborn children, which is made up of a heterigenous mixture of tissues, as of bone, cartilage and muscle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terbic</ent><br/
<hw>Ter"bic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of, pertaining to, or containing, terbium; also, designating certain of its compounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terbium</ent><br/
<hw>Ter"bi*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Yt<ets>terby</ets>, in Sweden. See <er>Erbium</er>.]</ety> <fld>(Chem.)</fld> <def>A rare metallic element, found in certain minerals, as gadolinite and samarskite, with other rare earths such as ytterbium. Symbol Tb. Atomic number 65. Atomic weight 158.925.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Terce</ent><br/
<hw>Terce</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tierce</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tercel</ent><br/
<hw>Ter"cel</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Tiercel</er>. Called also <altname>tarsel</altname>, <altname>tassel</altname>.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tercelet</ent><br/
<hw>Terce"let</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A male hawk or eagle; a tiercelet.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tercellene</ent><br/
<hw>Ter"cel*lene</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A small male hawk.</def> <mark>[R.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tercentenary</ent><br/
<hw>Ter*cen"te*na*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>ter</ets> thirce + E. <ets>centenary</ets>.]</ety> <def>Including, or relating to, an interval of three hundred years.</def> -- <def2><pos>n.</pos> <def>The three hundredth anniversary of any event; also, a celebration of such an anniversary.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tercet</ent><br/
<hw>Ter"cet</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. It. <ets>terzetto</ets>, dim. of <ets>terzo</ets>, third, L. <ets>tertius</ets>. See <er>Tierce</er>, and cf. <er>Terzetto</er>.]</ety> <sn>1.</sn> <fld>(Mus.)</fld> <def>A triplet.</def>  <rj><au>Hiles.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Poetry)</fld> <def>A triplet; a group of three lines.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tercine</ent><br/
<hw>Ter"cine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., from L. <ets>tertius</ets> the third.]</ety> <fld>(Bot.)</fld> <def>A cellular layer derived from the nucleus of an ovule and surrounding the embryo sac.  Cf. <er>Quintine</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebate</ent><br/
<hw>Ter"e*bate</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A salt of terebic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebene</ent><br/
<hw>Ter"e*bene</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A polymeric modification of terpene, obtained as a white crystalline camphorlike substance; -- called also <altname>camphene</altname>. By extension, any one of a group of related substances.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1487 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebenthene</ent><br/
<hw>Ter`e*ben"thene</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>Oil of turpentine. See <er>Turpentine</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebic</ent><br/
<hw>Te*reb"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or obtained from, terbenthene (oil of turpentine); specifically, designating an acid, <chform>C7H10O4</chform>, obtained by the oxidation of terbenthene with nitric acid, as a white crystalline substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebilenic</ent><br/
<hw>Ter`e*bi*len"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, a complex acid, <chform>C7H8O4</chform>, obtained as a white crystalline substance by a modified oxidation of terebic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebinth</ent><br/
<hw>Ter"e*binth</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>terbinthus</ets>, Gr. <?/: cf. F. <ets>t<eacute/r<eacute/binthe</ets>.  Cf. <er>Turpentine</er>.]</ety> <fld>(Bot.)</fld> <def>The turpentine tree.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebinthic</ent><br/
<hw>Ter`e*bin"thic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of or pertaining to turpentine; resembling turpentine; terbinthine; <as>as, <ex>terbinthic</ex> qualities</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebinthinate</ent><br/
<hw>Ter`e*bin"thi*nate</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Impregnating with the qualities of turpentine; terbinthine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebinthine</ent><br/
<hw>Ter`e*bin"thine</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>terbinthinus</ets>, Gr. <?/.]</ety> <def>Of or pertaining to turpentine; consisting of turpentine, or partaking of its qualities.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebra</ent><br/
\'d8<hw>Ter"e*bra</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E. <plw>Terebras</plw> <pr>(#)</pr>, L. <plw>Terebrae</plw> <pr>(#)</pr>.</plu> <ety>[L., a borer.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>A genus of marine gastropods having a long, tapering spire. They belong to the Toxoglossa. Called also <altname>auger shell</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The boring ovipositor of a hymenopterous insect.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebrant</ent><br/
<hw>Ter"e*brant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>terebrans</ets>, <ets>-antis</ets>, p. pr.]</ety> <fld>(Zool.)</fld> <def>Boring, or adapted for boring; -- said of certain Hymenoptera, as the sawflies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebrantia</ent><br/
\'d8<hw>Ter`e*bran"ti*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.]</ety> <fld>(Zool.)</fld> <def>A division of Hymenoptera including those which have an ovipositor adapted for perforating plants. It includes the sawflies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebrate</ent><br/
<hw>Ter"e*brate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L. <ets>terebratus</ets>, p. p. of <ets>terebrare</ets>, from <ets>terebra</ets> a borer, <ets>terere</ets> to rub.]</ety> <def>To perforate; to bore; to pierce.</def> <mark>[R.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebrating</ent><br/
<hw>Ter"e*bra`ting</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <fld>(Zool.)</fld> <def>Boring; perforating; -- applied to molluskas which form holes in rocks, wood, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>Boring; piercing; -- applied to certain kinds of pain, especially to those of locomotor ataxia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebration</ent><br/
<hw>Ter`e*bra"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>terebratio</ets>.]</ety> <def>The act of terebrating, or boring.</def> <mark>[R.]</mark>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebratula</ent><br/
\'d8<hw>Ter`e*brat"u*la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Terebratulae</plw> <pr>(#)</pr>.</plu> <ety>[Nl., dim. fr. <ets>terebratus</ets>, p. p., perforated.]</ety> <fld>(Zool.)</fld> <def>A genus of brachiopods which includes many living and some fossil species. The larger valve has a perforated beak, through which projects a short peduncle for attachment. Called also <altname>lamp shell</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebratulid</ent><br/
<hw>Ter`e*brat"u*lid</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Any species of Terebratula or allied genera. Used also adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terebratuliform</ent><br/
<hw>Ter`e*bra*tu"li*form</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Having the general form of a terebratula shell.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teredine</ent><br/
<hw>Ter"e*dine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>t<eacute/r<eacute/dine</ets>.]</ety> <fld>(Zool.)</fld> <def>A borer; the teredo.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teredo</ent><br/
<hw>Te*re"do</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E. <plw>Teredos</plw> <pr>(#)</pr>, L. <plw>Teredines</plw> <pr>(#)</pr>.</plu> <ety>[L., a worm that gnaws wood, clothes, etc.; akin to Gr. <?/, L. <ets>terere</ets> to rub.]</ety> <fld>(Zool.)</fld> <def>A genus of long, slender, wormlike bivalve mollusks which bore into submerged wood, such as the piles of wharves, bottoms of ships, etc.; -- called also <altname>shipworm</altname>. See <er>Shipworm</er>. See <xex>Illust.</xex> in Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terek</ent><br/
<hw>Ter"ek</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Because found on the <etsep>Terek</etsep> River in the Caucasus.]</ety> <def>A sandpiper (<spn>Terekia cinerea</spn>) of the Old World, breeding in the far north of eastern Europe and Asia and migrating to South Africa and Australia. It frequents rivers.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Terephthalate</ent><br/
<hw>Ter*eph"tha*late</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of terephthalic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terephthalic</ent><br/
<hw>Ter`eph*thal"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tere</ets>bene + <ets>phthalic</ets>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, a dibasic acid of the aromatic series, metameric with phthalic acid, and obtained, as a tasteless white crystalline powder, by the oxidation of oil of turpentine; -- called also <altname>paraphthalic acid</altname>.  Cf. <er>Phthalic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teret</ent><br/
<hw>Ter"et</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Round; terete.</def> <mark>[Obs.]</mark>  <rj><au>Fotherby.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terete</ent><br/
<hw>Te*rete"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>teres</ets>, <ets>-etis</ets>, rounded off, properly, rubbed off, fr. <ets>terere</ets> to rub.]</ety> <def>Cylindrical and slightly tapering; columnar, as some stems of plants.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teretial</ent><br/
<hw>Te*re"tial</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Terete</er>.]</ety> <fld>(Anat.)</fld> <def>Rounded; <as>as, the <ex>teretial</ex> tracts in the floor of the fourth ventricle of the brain of some fishes</as>.</def>  <rj><au>Owen.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teretous</ent><br/
<hw>Ter"e*tous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Terete.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergal</ent><br/
<hw>Ter"gal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tergum</ets> the back.]</ety> <fld>(Anat. & Zool.)</fld> <def>Of or pertaining to back, or tergum. See <er>Dorsal</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergant</ent><br/
<hw>Ter"gant</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Her.)</fld> <def>Showing the back; <as>as, the eagle <ex>tergant</ex></as>.</def> <altsp>[Written also <asp>tergiant</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergeminate</ent><br/
<ent>Tergeminal</ent><br/
<mhw>{ <hw>Ter*gem"i*nal</hw> <pr>(?)</pr>, <hw>Ter*gem"i*nate</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[See <er>Tergeminous</er>.]</ety> <fld>(Bot.)</fld> <def>Thrice twin; having three pairs of leaflets.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergeminous</ent><br/
<hw>Ter*gem"i*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tergeminus</ets>; <ets>ter</ets> thrice + <ets>geminus</ets> doubled at birth, twin-born.  Cf. <er>Trigeminous</er>.]</ety> <def>Threefold; thrice-paired.</def>  <rj><au>Blount.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergiferous</ent><br/
<hw>Ter*gif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tergum</ets> the back + <ets>-ferous</ets>.]</ety> <def>Carrying or bearing upon the back.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tergiferous plants</b></col> <fld>(Bot.)</fld>, <cd>plants which bear their seeds on the back of their leaves, as ferns.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergite</ent><br/
<hw>Ter"gite</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The dorsal portion of an arthromere or somite of an articulate animal. See <xex>Illust.</xex> under <er>Coleoptera</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergiversate</ent><br/
<hw>Ter"gi*ver*sate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[L. <ets>tergiversatus</ets>, p. p. of <ets>tergiversari</ets> to turn one's back, to shift; <ets>tergum</ets> back + <ets>versare</ets>, freq. of <ets>vertere</ets> to turn. See <er>Verse</er>.]</ety> <def>To shift; to practice evasion; to use subterfuges; to shuffle.</def> <mark>[R.]</mark>  <rj><au>Bailey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergiversation</ent><br/
<hw>Ter`gi*ver*sa"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tergiversario</ets>: cf. F. <ets>tergiversation</ets>.]</ety> <sn>1.</sn> <def>The act of tergiversating; a shifting; shift; subterfuge; evasion.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Writing is to be preferred before verbal conferences, as being freer from passions and <qex>tergiversations</qex>.</q> <rj><qau>Abp. Bramhall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fickleness of conduct; inconstancy; change.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The colonel, after all his <qex>tergiversations</qex>, lost his life in the king's service.</q> <rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergiversator</ent><br/
<hw>Ter"gi*ver*sa`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>One who tergiversates; one who suffles, or practices evasion.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tergum</ent><br/
\'d8<hw>Ter"gum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Terga</plw> <pr>(#)</pr>.</plu> <ety>[L., the back.]</ety> <fld>(Zool.)</fld> <sd>(a)</sd> <def>The back of an animal.</def> <sd>(b)</sd> <def>The dorsal piece of a somite of an articulate animal.</def> <sd>(c)</sd> <def>One of the dorsal plates of the operculum of a cirriped.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terin</ent><br/
<hw>Te"rin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>tarin</ets>, Prov. F. <ets>tairin</ets>, <ets>t<eacute/rin</ets>, probably from the Picard <ets>t<egrave/re</ets> tender.]</ety> <fld>(Zool.)</fld> <def>A small yellow singing bird, with an ash-colored head; the European siskin. Called also <altname>tarin</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Term</ent><br/
<hw>Term</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>terme</ets>, L. <ets>termen</ets>, <ets>-inis</ets>, <ets>terminus</ets>, a boundary limit, end; akin to Gr. <?/, <?/. See <er>Thrum</er> a tuft, and cf. <er>Terminus</er>, <er>Determine</er>, <er>Exterminate</er>.]</ety> <sn>1.</sn> <def>That which limits the extent of anything; limit; extremity; bound; boundary.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Corruption is a reciprocal to generation, and they two are as nature's two <qex>terms</qex>, or boundaries.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The time for which anything lasts; any limited time; <as>as, a <ex>term</ex> of five years; the <ex>term</ex> of life</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>In universities, schools, etc., a definite continuous period during which instruction is regularly given to students; <as>as, the school year is divided into three <ex>terms</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Geom.)</fld> <def>A point, line, or superficies, that limits; <as>as, a line is the <ex>term</ex> of a superficies, and a superficies is the <ex>term</ex> of a solid</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Law)</fld> <def>A fixed period of time; a prescribed duration</def>; as: <sd>(a)</sd> <def>The limitation of an estate; or rather, the whole time for which an estate is granted, as for the term of a life or lives, or for a term of years.</def> <sd>(b)</sd> <def>A space of time granted to a debtor for discharging his obligation.</def> <sd>(c)</sd> <def>The time in which a court is held or is open for the trial of causes.</def>  <rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In England, there were formerly four terms in the year, during which the superior courts were open: Hilary term, beginning on the 11th and ending on the 31st of January; Easter term, beginning on the 15th of April, and ending on the 8th of May; Trinity term, beginning on the 22d day of May, and ending on the 12th of June; Michaelmas term, beginning on the 2d and ending on the 25th day of November. The rest of the year was called <xex>vacation</xex>. But this division has been practically abolished by the Judicature Acts of 1873, 1875, which provide for the more convenient arrangement of the terms and vacations.<br/
    In the United States, the terms to be observed by the tribunals of justice are prescribed by the statutes of Congress and of the several States.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Logic)</fld> <def>The subject or the predicate of a proposition; one of the three component parts of a syllogism, each one of which is used twice.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The subject and predicate of a proposition are, after Aristotle, together called its <qex>terms</qex> or extremes.</q> <rj><qau>Sir W. Hamilton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The predicate of the conclusion is called the <xex>major</xex> term, because it is the most general, and the subject of the conclusion is called the <xex>minor</xex> term, because it is less general. These are called the <xex>extermes</xex>; and the third term, introduced as a common measure between them, is called the <xex>mean</xex> or <xex>middle</xex> term. Thus in the following syllogism, --<br/
[<source>1913 Webster</source>]</p>

<p>Every vegetable is combustible;
Every tree is a vegetable;
Therefore every tree is combustible, -<br/
[<source>1913 Webster</source>]</p>

<p><xex>combustible</xex>, the predicate of the conclusion, is the major term; <xex>tree</xex> is the minor term; <xex>vegetable</xex> is the middle term.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>A word or expression; specifically, one that has a precisely limited meaning in certain relations and uses, or is peculiar to a science, art, profession, or the like; <as>as, a technical <ex>term</ex></as>.</def> <ldquo/<xex>Terms</xex> quaint of law.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In painting, the greatest beauties can not always be expressed for want of <qex>terms</qex>.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Arch.)</fld> <def>A quadrangular pillar, adorned on the top with the figure of a head, as of a man, woman, or satyr; -- called also <altname>terminal figure</altname>. See <er>Terminus</er>, <pos>n.</pos>, 2 and 3.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The pillar part frequently tapers downward, or is narrowest at the base. <xex>Terms</xex> rudely carved were formerly used for landmarks or boundaries. <au>Gwilt.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Alg.)</fld> <def>A member of a compound quantity; <as>as, <it>a</it> or <it>b</it> in <mathex>a + b</mathex>; <it>ab</it> or <it>cd</it> in <mathex>ab - cd</mathex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <pluf>pl.</pluf> <fld>(Med.)</fld> <def>The menses.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <pluf>pl.</pluf> <fld>(Law)</fld> <def>Propositions or promises, as in contracts, which, when assented to or accepted by another, settle the contract and bind the parties; conditions.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>12.</sn> <fld>(Law)</fld> <def>In Scotland, the time fixed for the payment of rents.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Terms legal and conventional</xex> in Scotland correspond to <xex>quarter days</xex> in England and Ireland. There are two <xex>legal terms</xex> -- Whitsunday, May 15, and Martinmas, Nov. 11; and two <xex>conventional terms</xex> -- Candlemas, Feb. 2, and Lammas day, Aug. 1. <au>Mozley & W.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><sn>13.</sn> <fld>(Naut.)</fld> <def>A piece of carved work placed under each end of the taffrail.</def>  <rj><au>J. Knowels.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>In term</b></col>, <cd>in set terms; in formal phrase.</cd> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I can not speak <qex>in term</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <col><b>Term fee</b></col> <fld>(Law)</fld> <sd>(a)</sd>, <cd>a fee by the term, chargeable to a suitor, or by law fixed and taxable in the costs of a cause for each or any term it is in court.</cd> -- <col><b>Terms of a proportion</b></col> <fld>(Math.)</fld>, <cd>the four members of which it is composed.</cd> -- <col><b>To bring to terms</b></col>, <cd>to compel (one) to agree, assent, or submit; to force (one) to come to terms.</cd> -- <col><b>To make terms</b></col>, <cd>to come to terms; to make an agreement: to agree.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Limit; bound; boundary; condition; stipulation; word; expression.</syn> <usage> -- <er>Term</er>, <er>Word</er>. These are more frequently interchanged than almost any other vocables that occur of the language. There is, however, a difference between them which is worthy of being kept in mind. <xex>Word</xex> is generic; it denotes an utterance which represents or expresses our thoughts and feelings. <xex>Term</xex> originally denoted one of the two essential members of a proposition in logic, and hence signifies a word of specific meaning, and applicable to a definite class of objects. Thus, we may speak of a scientific or a technical <xex>term</xex>, and of stating things in distinct <xex>terms</xex>. Thus we say, <ldquo/the <xex>term</xex> minister literally denotes servant;<rdquo/ <ldquo/an exact definition of <xex>terms</xex> is essential to clearness of thought;<rdquo/ <ldquo/no <xex>term</xex> of reproach can sufficiently express my indignation;<rdquo/ <ldquo/every art has its peculiar and distinctive <xex>terms</xex>,<rdquo/ etc. So also we say, <ldquo/purity of style depends on the choice of <xex>words</xex>, and precision of style on a clear understanding of the <xex>terms</xex> used.<rdquo/ <xex>Term</xex> is chiefly applied to verbs, nouns, and adjectives, these being capable of standing as terms in a logical proposition; while prepositions and conjunctions, which can never be so employed, are rarely spoken of as <xex>terms</xex>, but simply as <xex>words</xex>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Term</ent><br/
<hw>Term</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Termed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Terming</conjf>.]</vmorph> <ety>[See <er>Term</er>, <pos>n.</pos>, and cf. <er>Terminate</er>.]</ety> <def>To apply a term to; to name; to call; to denominate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Men <qex>term</qex> what is beyond the limits of the universe <ldquo/imaginary space.<rdquo/</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terma</ent><br/
\'d8<hw>Ter"ma</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Term</er>, <pos>n.</pos>]</ety> <fld>(Anat.)</fld> <def>The terminal lamina, or thin ventral part, of the anterior wall of the third ventricle of the brain.</def>  <rj><au>B. G. Wilder.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termagancy</ent><br/
<hw>Ter"ma*gan*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being termagant; turbulence; tumultuousness; <as>as, a violent <ex>termagancy</ex> of temper</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termagant</ent><br/
<hw>Ter"ma*gant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>Trivigant</ets>, <ets>Termagant</ets>, Termagant (in sense 1), OF. <ets>Tervagan</ets>; cf. It. <ets>Trivigante</ets>.]</ety> <sn>1.</sn> <def>An imaginary being supposed by the Christians to be a Moslem deity or false god.  He is represented in the ancient moralities, farces, and puppet shows as extremely vociferous and tumultous.</def> <mark>[Obs.]</mark> <au>Chaucer.</au> <ldquo/And oftentimes by <xex>Termagant</xex> and Mahound [Mahomet] swore.<rdquo/ <au>Spenser.</au><br/
[<source>1913 Webster</source>]</p>

<p><q>The lesser part on Christ believed well,<br/
On <qex>Termagant</qex> the more, and on Mahound.</q> <rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A boisterous, brawling, turbulent person; -- formerly applied to both sexes, now only to women.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This terrible <qex>termagant</qex>, this Nero, this Pharaoh.</q> <rj><qau>Bale (1543).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The slave of an imperious and reckless <qex>termagant</qex>.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termagant</ent><br/
<hw>Ter"ma*gant</hw>, <pos>a.</pos> <def>Tumultuous; turbulent; boisterous; furious; quarrelsome; scolding.</def> -- <wordforms><wf>Ter"ma*gant*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>termagant</qex>, imperious, prodigal, profligate wench.</q> <rj><qau>Arbuthnot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termatarium</ent><br/
\'d8<hw>Ter`ma*ta"ri*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Termes</er>.]</ety> <fld>(Zool.)</fld> <def>Any nest or dwelling of termes, or white ants.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termatary</ent><br/
<hw>Ter"ma*ta*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Termatarium</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Term day</ent><br/
<hw>Term day</hw>. <def>A day which is a term (as for payment of rent), or is a day in a term, as of the sitting of a court; esp., one of a series of special days, designated by scientists of different nations or stations, for making synoptic magnetic, meteorological, or other physical observations.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Termer</ent><br/
<hw>Term"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who resorted to London during the law term only, in order to practice tricks, to carry on intrigues, or the like.</def> <mark>[Obs.]</mark> <altsp>[Written also <asp>termor</asp>.]</altsp>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>One who has an estate for a term of years or for life.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termes</ent><br/
\'d8<hw>Ter"mes</hw> <pr>(t<etil/r"m<emac/z)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Termites</plw> <pr>(-m<icr/*t<emac/z)</pr>.</plu> <ety>[L. <ets>termes</ets>, <ets>tarmes</ets>, <ets>-itis</ets>, a woodworm.  Cf. <er>Termite</er>.]</ety> <fld>(Zool.)</fld> <def>A genus of Pseudoneuroptera including the white ants, or termites. See <er>Termite</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminable</ent><br/
<hw>Ter"mi*na*ble</hw> <pr>(-m<icr/n*<adot/*b'l)</pr>, <pos>a.</pos> <ety>[See <er>Terminate</er>.]</ety> <def>Capable of being terminated or bounded; limitable.</def> -- <wordforms><wf>Ter"mi*na*ble*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Terminable annuity</b></col>, <cd>an annuity for a stated, definite number of years; -- distinguished from <contr>life annuity</contr>, and <contr>perpetual annuity</contr>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminal</ent><br/
<hw>Ter"mi*nal</hw> <pr>(-n<ait/l)</pr>, <pos>a.</pos> <ety>[L. <ets>terminals</ets>: cf. F. <ets>terminal</ets>. See <er>Term</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>Of or pertaining to the end or extremity; forming the extremity; <as>as, a <ex>terminal</ex> edge</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Growing at the end of a branch or stem; terminating; <as>as, a <ex>terminal</ex> bud, flower, or spike</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Railroads)</fld> <def>Pertaining to a railroad terminal; connected with the receipt or delivery of freight; <as>as, <ex>terminal</ex> charges</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Terminal moraine</b></col>. <cd>See the Note under <er>Moraine</er>.</cd> -- <col><b>Terminal statue</b></col>. <cd>See <er>Terminus</er>, <pos>n.</pos>, 2 and 3.</cd> -- <col><b>Terminal velocity</b></col>. <sd>(a)</sd> <cd>The velocity acquired at the end of a body's motion.</cd> <sd>(b)</sd> <cd>The limit toward which the velocity of a body approaches, as of a body falling through the air.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminal</ent><br/
<hw>Ter"mi*nal</hw>, <pos>n.</pos> <sn>1.</sn> <def>That which terminates or ends; termination; extremity.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eccl.)</fld> <def>Either of the ends of the conducting circuit of an electrical apparatus, as an inductorium, dynamo, or electric motor, usually provided with binding screws for the attachment of wires by which a current may be conveyed into or from the machine; a pole.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Railroads)</fld> <sd>(a)</sd> <def>The end of a line of railroad, with the switches, stations, sheds, and other appliances pertaining thereto.</def> <sd>(b)</sd> <def>Any station for the delivery or receipt of freight lying too far from the main line to be served by mere <xex>sidings</xex>.</def> <sd>(c)</sd> <def>A rate charged on all freight, independent of the distance, and supposed to cover the expenses of station service, as distinct from <contr>mileage rate</contr>, generally proportionate to the distance and intended to cover movement expenses; a terminal charge.</def> <sd>(d)</sd> <def>A town lying at the end of a railroad,  in which the terminal is located; -- more properly called a <altname>terminus</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>4.</sn> <def>The station at either end of a bus line line which transports freight or passengers.</def><br/
[<source>PJC</source>]</p>

<p><sn>5.</sn> <def>A station where passenger buses start or end a trip; -- also called <ecol><b>bus terminal</b></ecol>.</def><br/
[<source>PJC</source>]</p>

<p><sn>6.</sn> <def>The structure at an airport where passengers board or debark, and where ticket purchases and baggage pickup is performed; -- also called <ecol><b>airline terminal</b></ecol>.</def><br/
[<source>PJC</source>]</p>

<p><sn>7.</sn> <fld>(Computers)</fld> <def>An electronic device where data may be entered into a computer, and information received from it, usually consisting of a keyboard and video display unit (monitor); the terminal may be integrated or connected directly to a computer, or connected by a communications circuit with a computer at a remote location; -- also called <ecol><b>computer terminal</b></ecol>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>freight terminal</b></col>, <cd>a terminal used for loading or unloading of freight.</cd></cs><br/
[<source>PJC</source>]</p>

<p><ent>Terminalia</ent><br/
\'d8<hw>Ter`mi*na"li*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[L.]</ety> <fld>(Rom. Antiq.)</fld> <def>A festival celebrated annually by the Romans on February 23 in honor of <etsep>Terminus</etsep>, the god of boundaries.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminant</ent><br/
<hw>Ter"mi*nant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>terminans</ets>, p. pr. of <ets>terminare</ets>.]</ety> <def>Termination; ending.</def> <mark>[R.]</mark>  <rj><au>Puttenham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminate</ent><br/
<hw>Ter"mi*nate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Terminated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Terminating</conjf>.]</vmorph> <ety>[L. <ets>terminatus</ets>, p. p. of <ets>terminare</ets>. See <er>Term</er>.]</ety> <sn>1.</sn> <def>To set a term or limit to; to form the extreme point or side of; to bound; to limit; <as>as, to <ex>terminate</ex> a surface by a line</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To put an end to; to make to cease; <as>as, to <ex>terminate</ex> an effort, or a controversy</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, to put the finishing touch to; to bring to completion; to perfect.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>During this interval of calm and prosperity, he [Michael Angelo] <qex>terminated</qex> two figures of slaves, destined for the tomb, in an incomparable style of art.</q> <rj><qau>J. S. Harford.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1488 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminate</ent><br/
<hw>Ter"mi*nate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To be limited in space by a point, line, or surface; to stop short; to end; to cease; <as>as, the torrid zone <ex>terminates</ex> at the tropics</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To come to a limit in time; to end; to close.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The wisdom of this world, its designs and efficacy, <qex>terminate</qex> on zhis side heaven.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termination</ent><br/
<hw>Ter`mi*na"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>terminatio</ets> a bounding, fixing, determining: cf. F. <ets>terminasion</ets>, OF. also <ets>termination</ets>. See <er>Term</er>.]</ety> <sn>1.</sn> <def>The act of terminating, or of limiting or setting bounds; the act of ending or concluding; <as>as, a voluntary <ex>termination</ex> of hostilities</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which ends or bounds; limit in space or extent; bound; end; <as>as, the <ex>termination</ex> of a line</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>End in time or existence; <as>as, the <ex>termination</ex> of the year, or of life; the <ex>termination</ex> of happiness</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>End; conclusion; result.</def>  <rj><au>Hallam.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Last purpose of design.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A word; a term.</def> <mark>[R. & Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Gram.)</fld> <def>The ending of a word; a final syllable or letter; the part added to a stem in inflection.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminational</ent><br/
<hw>Ter`mi*na"tion*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to termination; forming a termination.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminative</ent><br/
<hw>Ter"mi*na*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Tending or serving to terminate; terminating; determining; definitive.</def> <au>Bp. Rust.</au> -- <wordforms><wf>Ter"mi*na*tive*ly</wf>, <pos>adv.</pos> <au>Jer. Taylor.</au></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminator</ent><br/
<hw>Ter"mi*na`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., he who limits or sets bounds.]</ety> <sn>1.</sn> <def>One who, or that which, terminates.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Astron.)</fld> <def>The dividing line between the illuminated and the unilluminated part of the moon.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- The Terminator. Arnold Schwarzenegger. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminatory</ent><br/
<hw>Ter"mi*na*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Terminative.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termine</ent><br/
<hw>Ter"mine</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[Cf. F. <ets>terminer</ets>.]</ety> <def>To terminate.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminer</ent><br/
<hw>Ter"mi*ner</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>terminer</ets> to bound, limit, end. See <er>Terminate</er>.]</ety> <fld>(Law)</fld> <def>A determining; <as>as, in oyer and <ex>terminer</ex></as>. See <er>Oyer</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminism</ent><br/
<hw>Ter"mi*nism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The doctrine held by the Terminists.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminist</ent><br/
<hw>Ter"mi*nist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>terministe</ets>.]</ety> <fld>(Theol.)</fld> <def>One of a class of theologians who maintain that God has fixed a certain term for the probation of individual persons, during which period, and no longer, they have the offer to grace.</def>  <rj><au>Murdock.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminological</ent><br/
<hw>Ter`mi*no*log"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to terminology.</def> -- <wordforms><wf>Ter`mi*no*log"ic*al*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terminology</ent><br/
<hw>Ter`mi*nol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>terminus</ets> term + <ets>-logy</ets>: cf. F. <ets>terminologie</ets>.]</ety> <sn>1.</sn> <def>The doctrine of terms; a theory of terms or appellations; a treatise on terms.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The terms actually used in any business, art, science, or the like; nomenclature; technical terms; <as>as, the <ex>terminology</ex> of chemistry</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The barbarous effect produced by a German structure of sentence, and a <qex>terminology</qex> altogether new.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Term insurance</ent><br/
<hw>Term insurance</hw>. <def>Insurance for a specified term providing for no payment to the insured except upon losses during the term, and becoming void upon its expiration.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Terminus</ent><br/
<hw>Ter"mi*nus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Termini</plw> <pr>(#)</pr>.</plu> <ety>[L. See <er>Term</er>.]</ety> <sn>1.</sn> <def>Literally, a boundary; a border; a limit.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Myth.)</fld> <def>The Roman divinity who presided over boundaries, whose statue was properly a short pillar terminating in the bust of a man, woman, satyr, or the like, but often merely a post or stone stuck in the ground on a boundary line.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, any post or stone marking a boundary; a term. See <er>Term</er>, 8.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Either end of a railroad line; also, the station house, or the town or city, at that place.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termite</ent><br/
<hw>Ter"mite</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Termites</plw> <pr>(#)</pr>.</plu> <ety>[F. See <er>Termes</er>.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of pseudoneoropterous insects belonging to <gen>Termes</gen> and allied genera; -- called also <altname>white ant</altname>. See <xex>Illust.</xex> of <er>White ant</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ They are very abundant in tropical countries, and are noted for their destructive habits, their large nests, their remarkable social instincts, and their division of labor among the polymorphic individuals of several kinds. Besides the males and females, each nest has ordinary workers, and large-headed individuals called <xex>soldiers</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termless</ent><br/
<hw>Term"less</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having no term or end; unlimited; boundless; unending; <as>as, <ex>termless</ex> time</as>.</def> <mark>[R.]</mark> <ldquo/<xex>Termless</xex> joys.<rdquo/  <rj><au>Sir W. Raleigh.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Inexpressible; indescribable.</def> <mark>[R.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termly</ent><br/
<hw>Term"ly</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Occurring every term; <as>as, a <ex>termly</ex> fee</as>.</def> <mark>[R.]</mark>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termly</ent><br/
<hw>Term"ly</hw>, <pos>adv.</pos> <def>Term by term; every term.</def> <mark>[R.]</mark> <ldquo/Fees . . . that are <xex>termly</xex> given.<rdquo/  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termonology</ent><br/
<hw>Ter`mo*nol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/, <?/, boundary, end + <ets>-logy</ets>.]</ety> <def>Terminology.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Termor</ent><br/
<hw>Term"or</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Law)</fld> <def>Same as <er>Termer</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Term policy</ent><br/
<hw>Term policy</hw>. <def>A policy of term insurance.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tern</ent><br/
<hw>Tern</hw> <pr>(t<etil/rn)</pr>, <pos>n.</pos> <ety>[Dan. <ets>terne</ets>, <ets>t<ae/rne</ets>; akin to Sw. <ets>t<aum/rna</ets>, Icel. <ets><thorn/erna</ets>; cf. NL. <ets>sterna</ets>.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of long-winged aquatic birds, allied to the gulls, and belonging to <gen>Sterna</gen> and various allied genera.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Terns differ from gulls chiefly in their graceful form, in their weaker and more slender bills and feet, and their longer and more pointed wings. The tail is usually forked. Most of the species are white with the back and wings pale gray, and often with a dark head. The common European tern (<spn>Sterna hirundo</spn>) is found also in Asia and America. Among other American species are the arctic tern (<spn>Sterna paradisaea</spn>), the roseate tern (<spn>Sterna Dougalli</spn>), the least tern (<spn>Sterna Antillarum</spn>), the royal tern (<spn>Sterna maxima</spn>), and the sooty tern (<spn>Sterna fuliginosa</spn>).</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Hooded tern</b></col>. <cd>See <cref>Fairy bird</cref>, under <er>Fairy</er>.</cd> -- <col><b>Marsh tern</b></col>, <cd>any tern of the genus <gen>Hydrochelidon</gen>. They frequent marshes and rivers and feed largely upon insects.</cd> -- <col><b>River tern</b></col>, <cd>any tern belonging to <gen>Seena</gen> or allied genera which frequent rivers.</cd> -- <col><b>Sea tern</b></col>, <cd>any tern of the genus <gen>Thalasseus</gen>. Terns of this genus have very long, pointed wings, and chiefly frequent seas and the mouths of large rivers.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tern</ent><br/
<hw>Tern</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. pl. <ets>terni</ets> three each, three; akin to <ets>tres</ets> three. See <er>Three</er>, and cf. <er>Trine</er>.]</ety> <def>Threefold; triple; consisting of three; ternate.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tern flowers</b></col> <fld>(Bot.)</fld>, <cd>flowers growing three and three together.</cd> -- <col><b>Tern leaves</b></col> <fld>(Bot.)</fld>, <cd>leaves arranged in threes, or three by three, or having three in each whorl or set.</cd> -- <col><b>Tern peduncles</b></col> <fld>(Bot.)</fld>, <cd>three peduncles growing together from the same axis.</cd> -- <col><b>Tern schooner</b></col> <fld>(Naut.)</fld>, <cd>a three-masted schooner.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tern</ent><br/
<hw>Tern</hw>, <pos>n.</pos> <ety>[F. <ets>terne</ets>. See <er>Tern</er>, <pos>a.</pos>]</ety> <def>That which consists of, or pertains to, three things or numbers together; especially, a prize in a lottery resulting from the favorable combination of three numbers in the drawing; also, the three numbers themselves.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She'd win a <qex>tern</qex> in Thursday's lottery.</q> <rj><qau>Mrs. Browning.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ternary</ent><br/
<hw>Ter"na*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>ternarius</ets>, fr. <ets>terni</ets>. See <er>Tern</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>Proceeding by threes; consisting of three; <as>as, the <ex>ternary</ex> number was anciently esteemed a symbol of perfection, and held in great veneration</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>Containing, or consisting of, three different parts, as elements, atoms, groups, or radicals, which are regarded as having different functions or relations in the molecule; <as>thus, sodic hydroxide, <chform>NaOH</chform>, is a <ex>ternary</ex> compound</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ternary</ent><br/
<hw>Ter"na*ry</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Ternaries</plw> <pr>(<?/)</pr>.</plu> <def>A ternion; the number three; three things taken together; a triad.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some in <qex>ternaries</qex>, some in pairs, and some single.</q> <rj><qau>Holder.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ternate</ent><br/
<hw>Ter"nate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[NL. <ets>ternatus</ets>, fr. L. <ets>terni</ets> three each. See <er>Tern</er>, <pos>a.</pos>]</ety> <def>Having the parts arranged by threes; <as>as, <ex>ternate</ex> branches, leaves, or flowers</as>.</def> -- <wordforms><wf>Ter"nate*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terneplate</ent><br/
<hw>Terne"plate`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tern</er>, <pos>a.</pos>, and <er>Plate</er>.]</ety> <def>Thin iron sheets coated with an alloy of lead and tin; -- so called because made up of <xex>three</xex> metals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ternion</ent><br/
<hw>Ter"ni*on</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>ternio</ets>, fr. <ets>terni</ets> three each. See <er>Tern</er>, <pos>a.</pos>]</ety> <def>The number three; three things together; a ternary.</def>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terpene</ent><br/
<hw>Ter"pene</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Turpentine</er>.]</ety> <fld>(Chem.)</fld> <def>Any one of a series of isomeric hydrocarbons of pleasant aromatic odor, occurring especially in coniferous plants and represented by oil of turpentine, but including also certain hydrocarbons found in some essential oils.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terpentic</ent><br/
<hw>Ter*pen"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Terpenylic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terpenylic</ent><br/
<hw>Ter`pe*nyl"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Terpene</ets> + <ets>-yl</ets> + <ets>-ic</ets>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, an acid, <chform>C8H12O4</chform> (called also <xex>terpentic acid</xex>), homologous with terebic acid, and obtained as a white crystalline substance by the oxidation of oil of turpentine with chromic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terpilene</ent><br/
<hw>Ter"pi*lene</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A polymeric form of terpene, resembling terbene.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terpin</ent><br/
<hw>Ter"pin</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A white crystalline substance regarded as a hydrate of oil of turpentine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terpinol</ent><br/
<hw>Ter"pin*ol</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Terpin</ets> + L. <ets>ol</ets>eum oil.]</ety> <fld>(Chem.)</fld> <def>Any oil substance having a hyacinthine odor, obtained by the action of acids on terpin, and regarded as a related hydrate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terpsichore</ent><br/
<hw>Terp*sich"o*re</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr. Gr. <?/; <?/ enjoyment (fr. <?/ to gladden) + <?/ dance, dancing.]</ety> <fld>(Gr. Myth.)</fld> <def>The Muse who presided over the choral song and the dance, especially the latter.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terpsichorean</ent><br/
<hw>Terp`sich*o*re"an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to Terpsichore; of or pertaining to dancing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terra</ent><br/
\'d8<hw>Ter"ra</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It. & L. See <er>Terrace</er>.]</ety> <def>The earth; earth.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Terra alba</b></col> <ety>[L., white earth]</ety> <fld>(Com.)</fld>, <cd>a white amorphous earthy substance consisting of burnt gypsum, aluminium silicate (kaolin), or some similar ingredient, as magnesia. It is sometimes used to adulterate certain foods, spices, candies, paints, etc.</cd> -- <col><b>Terra cotta</b></col>. <ety>[It., fr. <ets>terra</ets> earth + <ets>cotta</ets>, fem. of <ets>cotto</ets> cooked, L. <ets>coctus</ets>, p. p. of <ets>coquere</ets> to cook. See <er>Cook</er>, <pos>n.</pos>]</ety> <cd>Baked clay; a kind of hard pottery used for statues, architectural decorations, figures, vases, and the like.</cd> -- <col><b>Terrae filius</b></col> <ety>[L., son of the earth]</ety>, <cd>formerly, one appointed to write a satirical Latin poem at the public acts in the University of Oxford; -- not unlike the <it>prevaricator</it> at Cambridge, England.</cd> -- <col><b>Terra firma</b></col> <ety>[L.]</ety>, <cd>firm or solid earth, as opposed to <contr>water</contr>.</cd> -- <col><b>Terra Japonica</b></col>. <ety>[NL.]</ety> <cd>Same as <er>Gambier</er>. It was formerly supposed to be a kind of earth from Japan.</cd> -- <col><b>Terra Lemnia</b></col> <ety>[L., Lemnian earth]</ety>, <cd>Lemnian earth. See under <er>Lemnian</er>.</cd> -- <col><b>Terra ponderosa</b></col> <ety>[L., ponderous earth]</ety> <fld>(Min.)</fld>, <cd>barite, or heavy spar.</cd> -- <col><b>Terra di Sienna</b></col>. <cd>See <er>Sienna</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrace</ent><br/
<hw>Ter"race</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>terrasse</ets> (cf. Sp. <ets>terraza</ets>, It. <ets>terrazza</ets>), fr. L. <ets>terra</ets> the earth, probably for <ets>tersa</ets>, originally meaning, dry land, and akin to <ets>torrere</ets> to parch, E. <ets>torrid</ets>, and <ets>thirst</ets>. See <er>Thirst</er>, and cf. <er>Fumitory</er>, <er>Inter</er>, <pos>v.</pos>, <er>Patterre</er>, <er>Terrier</er>, <er>Trass</er>, <er>Tureen</er>, <er>Turmeric</er>.]</ety> <sn>1.</sn> <def>A raised level space, shelf, or platform of earth, supported on one or more sides by a wall, a bank of tuft, or the like, whether designed for use or pleasure.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A balcony, especially a large and uncovered one.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A flat roof to a house; <as>as, the buildings of the Oriental nations are covered with <ex>terraces</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A street, or a row of houses, on a bank or the side of a hill; hence, any street, or row of houses.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Geol.)</fld> <def>A level plain, usually with a steep front, bordering a river, a lake, or sometimes the sea.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Many rivers are bordered by a series of terraces at different levels, indicating the flood plains at successive periods in their history.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Terrace epoch</b></col>. <fld>(Geol.)</fld> <cd>See <cref>Drift epoch</cref>, under <er>Drift</er>, <pos>a.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrace</ent><br/
<hw>Ter"race</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Terraced</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Terracing</conjf> <pr>(?)</pr>.]</vmorph> <def>To form into a terrace or terraces; to furnish with a terrace or terraces, <as>as, to <ex>terrace</ex> a garden, or a building</as>.</def>  <rj><au>Sir H. Wotton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Clermont's <qex>terraced</qex> height, and Esher's groves.</q> <rj><qau>Thomson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terraculture</ent><br/
<hw>Ter"ra*cul`ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>terra</ets> the earth + <ets>cultura</ets>.]</ety> <def>Cultivation on the earth; agriculture.</def> <mark>[R.]</mark> -- <wordforms><wf>Ter`ra*cul"tur*al</wf> <pr>(#)</pr>, <pos>a.</pos> <mark>[R.]</mark></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terra incognita</ent><br/
\'d8<hw>Ter"ra in*cog"ni*ta</hw> <pr>(?)</pr>. <ety>[L.]</ety> <def>An unknown land; unexplored country.</def></p>

<p><q>The enormous tracts lying outside China proper, still almost <qex>terrae incognitae</qex>.</q>  <rj><qau>A. R. Colquhoun.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Terrane</ent><br/
<hw>Ter"rane</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>terrain</ets>, from L. <ets>terra</ets> earth.]</ety> <sn>1.</sn> <fld>(Geol.)</fld> <def>A group of rocks having a common age or origin; -- nearly equivalent to <xex>formation</xex>, but used somewhat less comprehensively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrane</ent><br/
<hw>Ter"rane</hw>, <pos>n.</pos> <fld>(Geog.)</fld> <sn>2.</sn> <def>A region or limited area considered with reference to some special feature; <as>as, the <ex>terrane</ex> of a river, that is, its drainage basin</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Terrapin</ent><br/
<hw>Ter"ra*pin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Probably of American Indian origin.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of tortoises living in fresh and brackish waters. Many of them are valued for food.</def> <altsp>[Written also <asp>terapin</asp>, <asp>terrapen</asp>, <asp>terrapene</asp>, <asp>turpen</asp>, and <asp>turapen</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The yellow-bellied terrapin (<spn>Pseudemys scabra</spn>) of the Southern United States, the red-bellied terrapin (<spn>Pseudemys rugosa</spn> or <spn>Chrysemys rubriventris</spn>), native of the tributaries Chesapeake Bay (called also <altname>potter</altname>, <altname>slider</altname>, and <altname>redfender</altname>), and the diamond-back or salt-marsh terrapin (<spn>Malaclemmys palustris</spn>), are the most important American species. The diamond-back terrapin is native of nearly the whole of the Atlantic coast of the United States.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Alligator terrapin</b></col>, <cd>the snapping turtle.</cd> -- <col><b>Mud terrapin</b></col>, <cd>any one of numerous species of American tortoises of the genus <gen>Cinosternon</gen>.</cd> -- <col><b>Painted terrapin</b></col>, <cd>the painted turtle. See under <er>Painted</er>.</cd> -- <col><b>Speckled terrapin</b></col>, <cd>a small fresh-water American terrapin (<spn>Chelopus guttatus</spn>) having the carapace black with round yellow spots; -- called also <altname>spotted turtle</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terraqueous</ent><br/
<hw>Ter*ra"que*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>terra</ets> the earth + E. <ets>aqueous</ets>.]</ety> <def>Consisting of land and water; <as>as, the earth is a <ex>terraqueous</ex> globe</as>.</def>  <rj><au>Cudworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The grand <qex>terraqueous</qex> spectacle<br/
From center to circumference unveiled.</q> <rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrar</ent><br/
<hw>Ter"rar</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL. <ets>terrarius liber</ets>. See <er>Terrier</er> a collection of acknowledgments.]</ety> <fld>(O. Eng. Law)</fld> <def>See 2d <er>Terrier</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terras</ent><br/
<hw>Ter"ras</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Min.)</fld> <def>See <er><?/rass</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terreen</ent><br/
<hw>Ter*reen"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Turren</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terreity</ent><br/
<hw>Ter*re"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Quality of being earthy; earthiness.</def> <mark>[Obs.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrel</ent><br/
<hw>Ter"rel</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. <ets>terrella</ets>, from L. <ets>terra</ets> the earth.]</ety> <def>A spherical magnet so placed that its poles, equator, etc., correspond to those of the earth.</def> <mark>[Obs.]</mark>  <rj><au>Chambers.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terremote</ent><br/
<hw>Terre"mote`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>terremote</ets>, <ets>terremoete</ets>, fr. L. <ets>terra</ets> the earth + <ets>movere</ets>, <ets>motum</ets>, to move.]</ety> <def>An earthquake.</def> <mark>[Obs.]</mark>  <rj><au>Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrene</ent><br/
<hw>Ter*rene"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A tureen.</def> <mark>[Obs.]</mark>  <rj><au>Walpole.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrene</ent><br/
<hw>Ter*rene"</hw>, <pos>a.</pos> <ety>[L. <ets>terrenus</ets>, fr. <ets>terra</ets> the earth. See <er>Terrace</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to the earth; earthy; <as>as, <ex>terrene</ex> substance</as>.</def>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Earthy; terrestrial.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>God set before him a mortal and immortal life, a nature celestial and <qex>terrene</qex>.</q> <rj><qau>Sir W. Raleigh.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Be true and faithful to the king and his heirs, and truth and faith to bear of life and limb, and <qex>terrene</qex> honor.</q> <rj><qau>O. Eng. Oath of Allegiance, quoted by Blackstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Common conceptions of the matters which lie at the basis of our <qex>terrene</qex> experience.</q> <rj><qau>Hickok.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrene</ent><br/
<hw>Ter*rene"</hw>, <pos>n.</pos> <ety>[L. <ets>terrenum</ets> land, ground: cf. F. <ets>terrain</ets>.]</ety> <sn>1.</sn> <def>The earth's surface; the earth.</def> <mark>[Poetic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Tenfold the length of this <qex>terrene</qex>.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Surv.)</fld> <def>The surface of the ground.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrenity</ent><br/
<hw>Ter*ren"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Earthiness; worldliness.</def> <mark>[Obs.]</mark> <ldquo/A dull and low <xex>terrenity</xex>.<rdquo/  <rj><au>Feltham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terreous</ent><br/
<hw>Ter"re*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>terreus</ets>, fr. <ets>terra</ets> the earth. See <er>Terrace</er>.]</ety> <def>Consisting of earth; earthy; <as>as, <ex>terreous</ex> substances; <ex>terreous</ex> particles</as>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terreplein</ent><br/
<hw>Terre"plein`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>terra</ets> earth + <ets>planus</ets> even, level, plain.]</ety> <sn>1.</sn> <fld>(Fort.)</fld> <def>The top, platform, or horizontal surface, of a rampart, on which the cannon are placed. See <xex>Illust.</xex> of <er>Casemate</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Civ. Engin.)</fld> <def>An embankment of earth with a broad level top, which is sometimes excavated to form a continuation of an elevated canal across a valley.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Terrestre</ent><br/
<hw>Ter*res"tre</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OE., from OF. & F. <ets>terrestre</ets>.]</ety> <def>Terrestrial; earthly.</def> <mark>[Obs.]</mark> <ldquo/His paradise <xex>terrestre</xex>.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrestrial</ent><br/
<hw>Ter*res"tri*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>terrestris</ets>, from <ets>terra</ets> the earth. See <er>Terrace</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to the earth; existing on the earth; earthly; <as>as, <ex>terrestrial</ex> animals</as>.</def> <ldquo/Bodies <xex>terrestrial</xex>.<rdquo/  <rj><au>1 Cor. xv. 40.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Representing, or consisting of, the earth; <as>as, a <ex>terrestrial</ex> globe</as>.</def> <ldquo/The dark <xex>terrestrial</xex> ball.<rdquo/  <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Of or pertaining to the world, or to the present state; sublunary; mundane.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Vain labors of <qex>terrestrial</qex> wit.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A genius bright and base,<br/
Of towering talents, and <qex>terrestrial</qex> aims.</q> <rj><qau>Young.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Consisting of land, in distinction from water; belonging to, or inhabiting, the land or ground, in distinction from trees, water, or the like; <as>as, <ex>terrestrial</ex> serpents</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>terrestrial</qex> parts of the globe.</q> <rj><qau>Woodward.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Adapted for the observation of objects on land and on the earth; <as>as, a <ex>terrestrial</ex> telescope, in distinction from an <ex>astronomical</ex> telescope</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Ter*res"tri*al*ly</wf>, <pos>adv.</pos> -- <wf>Ter*res"tri*al*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrestrial</ent><br/
<hw>Ter*res"tri*al</hw>, <pos>n.</pos> <def>An inhabitant of the earth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrestrify</ent><br/
<hw>Ter*res"tri*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L. <ets>terrestris</ets> terrestrial + <ets>-fy</ets>.]</ety> <def>To convert or reduce into a condition like that of the earth; to make earthy.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrestrious</ent><br/
<hw>Ter*res"tri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Terrestrial</er>.]</ety> <def>Terrestrial.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terret</ent><br/
<hw>Ter"ret</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One of the rings on the top of the saddle of a harness, through which the reins pass.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terre-tenant</ent><br/
<hw>Terre"-ten`ant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>terre</ets> earth, land + <ets>tenant</ets>, p. pr. of <ets>tenir</ets> to hold.]</ety> <fld>(Law)</fld> <def>One who has the actual possession of land; the occupant.</def> <altsp>[Written also <asp>ter-tenant</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1489 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terre-verte</ent><br/
<hw>Terre"-verte`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. <ets>terre</ets> earth + <ets>vert</ets>, <ets>verte</ets>, green.]</ety> <def>An olive-green earth used as a pigment. See <er>Glauconite</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrible</ent><br/
<hw>Ter"ri*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F., fr. L. <ets>terribilis</ets>, fr. <ets>terrere</ets> to frighten. See <er>Terror</er>.]</ety> <sn>1.</sn> <def>Adapted or likely to excite terror, awe, or dread; dreadful; formidable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Prudent in peace, and <qex>terrible</qex> in war.</q> <rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou shalt not be affrighted at them; for the Lord thy God is among you, a mighty God and <qex>terrible</qex>.</q> <rj><qau>Deut. vii. 21.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Excessive; extreme; severe.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>terrible</qex> coldness of the season.</q> <rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Terrific; fearful; frightful; formidable; dreadful; horrible; shocking; awful.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Ter"ri*ble*ness</wf>, <pos>n.</pos> -- <wf>Ter"ri*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terricolae</ent><br/
\'d8<hw>Ter*ric"o*lae</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>terra + colere</ets> to inhabit.]</ety> <fld>(Zool.)</fld> <def>A division of annelids including the common earthworms and allied species.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrienniak</ent><br/
<hw>Ter`ri*en"ni*ak</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The arctic fox.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrier</ent><br/
<hw>Ter"ri*er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[CF. L. <ets>terere</ets> to rub, to rub away, <ets>terebra</ets> a borer.]</ety> <def>An auger or borer.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrier</ent><br/
<hw>Ter"ri*er</hw>, <pos>n.</pos> <sn>1.</sn> <ety>[F. <ets>terrier</ets>, <ets>chien terrier</ets>, from <ets>terre</ets> the earth, L. <ets>terra</ets>; cf. F. <ets>terrier</ets> a burrow, LL. <ets>terrarium</ets> a hillock (hence the sense, a mound thrown up in making a burrow, a burrow). See <er>Terrace</er>, and cf. <er>Terrier</er>, 2.]</ety> <fld>(Zool.)</fld> <def>One of a breed of small dogs, which includes several distinct subbreeds, some of which, such as the Skye terrier and Yorkshire terrier, have long hair and drooping ears, while others, at the English and the black-and-tan terriers, have short, close, smooth hair and upright ears.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Most kinds of terriers are noted for their courage, the acuteness of their sense of smell, their propensity to hunt burrowing animals, and their activity in destroying rats, etc. See <cref>Fox terrier</cref>, under <er>Fox</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[F. <ets>terrier</ets>, <ets>papier terrier</ets>, LL. <ets>terrarius liber</ets>, i.e., a book belonging or pertaining to land or landed estates. See <er>Terrier</er>, 1, and cf. <er>Terrar</er>.]</ety> <fld>(Law)</fld> <sd>(a)</sd> <def>Formerly, a collection of acknowledgments of the vassals or tenants of a lordship, containing the rents and services they owed to the lord, and the like.</def> <sd>(b)</sd> <def>In modern usage, a book or roll in which the lands of private persons or corporations are described by their site, boundaries, number of acres, or the like.</def> <altsp>[Written also <asp>terrar</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrific</ent><br/
<hw>Ter*rif"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>terrificus</ets>; fr. <ets>terrere</ets> to frighten + <ets>facere</ets> to make. See <er>Terror</er>, and <er>Fact</er>.]</ety> <def>Causing terror; adapted to excite great fear or dread; terrible; <as>as, a <ex>terrific</ex> form; a <ex>terrific</ex> sight.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrifical</ent><br/
<hw>Ter*rif"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Terrific.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrifically</ent><br/
<hw>Ter*rif"ic*al*ly</hw>, <pos>adv.</pos> <def>In a terrific manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrify</ent><br/
<hw>Ter"ri*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Terrified</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Terrifying</conjf> <pr>(?)</pr>.]</vmorph> <ety>[L. <ets>terrere</ets> to frighten + <ets>-fy</ets>: cf. F. <ets>terrifier</ets>, L. <ets>terrificare</ets>. See <er>Terrific</er>, and <er>-fy</er>.]</ety> <sn>1.</sn> <def>To make terrible.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>If the law, instead of aggravating and <qex>terrifying</qex> sin, shall give out license, it foils itself.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To alarm or shock with fear; to frighten.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When ye shall hear of wars . . . be not <qex>terrified</qex>.</q> <rj><qau>Luke xxi. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrigenous</ent><br/
<hw>Ter*rig"e*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>terrigena</ets>, <ets>terrigenus</ets>; <ets>terra</ets> the earth + <ets>genere</ets>, <ets>gignere</ets>, to bring forth.]</ety> <def>Earthborn; produced by the earth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrine</ent><br/
<hw>Ter*rine"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See <er>Tureen</er>.]</ety> <sn>1.</sn> <def>A dish or pan, originally of earthenware, such as those in which  various dishes are cooked and served; esp., an earthenware jar containing some table delicacy and sold with its contents.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <fld>(Cookery)</fld> <def>A kind of ragout formerly cooked and served in the same dish; also, a dish consisting of several meats braised together and served in a terrine.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <def>A soup tureen.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Territorial</ent><br/
<hw>Ter`ri*to"ri*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>territorialis</ets>: cf. F. <ets>territorial</ets>.]</ety> <sn>1.</sn> <def>Of or pertaining to territory or land; <as>as, <ex>territorial</ex> limits; <ex>territorial</ex> jurisdiction.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Limited to a certain district; <as>as, right may be personal or <ex>territorial</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Of or pertaining to all or any of the Territories of the United States, or to any district similarly organized elsewhere; <as>as, <ex>Territorial</ex> governments</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>exhibiting <er>territoriality</er>; -- of individual animals or species.</def><br/
[<source>PJC</source>]</p>

<p><ent>Territoriality</ent><br/
<hw>Ter`ri*to`ri*al"i*ty</hw> <pos>n.</pos> <fld>(Zool.)</fld>  <def>a pattern of behavior characterized by the marking and defense of a home territory, exhibited by certain male animals.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Territorialize</ent><br/
<hw>Ter`ri*to"ri*al*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Territorialized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Territorializing</conjf> <pr>(?)</pr>.]</vmorph> <sn>1.</sn> <def>To enlarge by extension of territory.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To reduce to the condition of a territory.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Territorially</ent><br/
<hw>Ter`ri*to"ri*al*ly</hw>, <pos>adv.</pos> <def>In regard to territory; by means of territory.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Territorial waters</ent><br/
<hw>Ter`ri*to"ri*al wa"ters</hw>. <fld>(Internat. Law)</fld> <def>The waters under the territorial jurisdiction of a state; specif., the  belt (often called the <col><b>marine belt</b></col> or <col><b>territorial sea</b></col>) of sea subject to such jurisdiction, and subject only to the right of innocent passage by the vessels of other states.</def></p>

<p><q>Perhaps it may be said without impropriety that a state has theoretically the right to extend its <qex>territorial waters</qex> from time to time at its will with the increased range of guns. Whether it would in practice be judicious to do so . . . is a widely different matter . . . . In any case the custom of regulating a line three miles from land as defining the boundary of marginal <qex>territorial waters</qex> is so far fixed that a state must be supposed to accept it in absence of express notice.</q>  <rj><qau>W. E. Hall.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Territoried</ent><br/
<hw>Ter"ri*to*ried</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Possessed of territory.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Territory</ent><br/
<hw>Ter"ri*to*ry</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Territories</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>territorium</ets>, from <ets>terra</ets> the earth: cf. F. <ets>territoire</ets>. See <er>Terrace</er>.]</ety> <sn>1.</sn> <def>A large extent or tract of land; a region; a country; a district.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He looked, and saw wide <qex>territory</qex> spread<br/
Before him -- towns, and rural works between.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The extent of land belonging to, or under the dominion of, a prince, state, or other form of government; often, a tract of land lying at a distance from the parent country or from the seat of government; <as>as, the <ex>territory</ex> of a State; the <ex>territories</ex> of the East India Company</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>In the United States, a portion of the country not included within the limits of any State, and not yet admitted as a State into the Union, but organized with a separate legislature, under a Territorial governor and other officers appointed by the President and Senate of the United States. In Canada, a similarly organized portion of the country not yet formed into a Province.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terror</ent><br/
<hw>Ter"ror</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>terror</ets>, akin to <ets>terrere</ets> to frighten, for <ets>tersere</ets>; akin to Gr. <?/ to flee away, dread, Skr. <ets>tras</ets> to tremble, to be afraid, Russ. <ets>triasti</ets> to shake: cf. F. <ets>terreur</ets>.  Cf. <er>Deter</er>.]</ety> <sn>1.</sn> <def>Extreme fear; fear that agitates body and mind; violent dread; fright.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Terror</qex> seized the rebel host.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which excites dread; a cause of extreme fear.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Those enormous <qex>terrors</qex> of the Nile.</q> <rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Rulers are not a <qex>terror</qex> to good works.</q> <rj><qau>Rom. xiii. 3.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There is no <qex>terror</qex>, Cassius, in your threats.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Terror</xex> is used in the formation of compounds which are generally self-explaining: as, <xex>terror</xex>-fraught, <xex>terror</xex>-giving, <xex>terror</xex>-smitten, <xex>terror</xex>-stricken, <xex>terror</xex>-struck, and the like.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>King of terrors</b></col>, <cd>death.</cd> <au>Job xviii. 14.</au> -- <col><b>Reign of Terror</b></col>. <fld>(French Hist.)</fld> <cd>See in Dictionary of Noted Names in Fiction.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Alarm; fright; consternation; dread; dismay. See <er>Alarm</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrorism</ent><br/
<hw>Ter"ror*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>terrorisme</ets>.]</ety> <sn>1.</sn> <def>The act of terrorizing, or state of being terrorized; a mode of government by terror or intimidation.</def>  <rj><au>Jefferson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The practise of coercing governments to accede to political demands by committing violence on civilian targets; any similar use of violence to achieve goals.</def><br/
[<source>PJC</source>]</p>

<p><ent>Terrorist</ent><br/
<hw>Ter"ror*ist</hw>, <pos>n.</pos> <ety>[F. <ets>terroriste</ets>.]</ety> <sn>1.</sn> <def>One who governs by terrorism or intimidation; specifically, an agent or partisan of the revolutionary tribunal during the Reign of Terror in France.</def>  <rj><au>Burke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who commits terrorism{2}.</def><br/
[<source>PJC</source>]</p>

<p><ent>Terrorize</ent><br/
<hw>Ter"ror*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[Cf. F. <ets>terroriser</ets>.]</ety> <def>To impress with terror; to coerce by intimidation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Humiliated by the tyranny of foreign despotism, and <qex>terrorized</qex> by ecclesiastical authority.</q> <rj><qau>J. A. Symonds.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terrorless</ent><br/
<hw>Ter"ror*less</hw>, <pos>a.</pos> <def>Free from terror.</def>  <rj><au>Poe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terry</ent><br/
<hw>Ter"ry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kind of heavy colored fabric, either all silk, or silk and worsted, or silk and cotton, often called <xex>terry velvet</xex>, used for upholstery and trimmings.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tersanctus</ent><br/
\'d8<hw>Ter*sanc"tus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>ter</ets> thrice + <ets>sanctus</ets> holy.]</ety> <fld>(Eccl.)</fld> <def>An ancient ascription of praise (containing the word <ldquo/Holy<rdquo/ -- in its Latin form, <ldquo/<xex>Sanctus</xex><rdquo/ -- thrice repeated), used in the Mass of the Roman Catholic Church and before the prayer of consecration in the communion service of the Church of England and the Protestant Episcopal Church.  Cf. <er>Trisagion</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terse</ent><br/
<hw>Terse</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Terser</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Tersest</adjf>.]</amorph> <ety>[L. <ets>tersus</ets>, p. p. of <ets>tergere</ets> to rub or wipe off.]</ety> <sn>1.</sn> <def>Appearing as if rubbed or wiped off; rubbed; smooth; polished.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Many stones, . . . although <qex>terse</qex> and smooth, have not this power attractive.</q> <rj><qau>Sir T. Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Refined; accomplished; -- said of persons.</def> <mark>[R. & Obs.]</mark> <ldquo/Your polite and <xex>terse</xex> gallants.<rdquo/  <rj><au>Massinger.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Elegantly concise; free of superfluous words; polished to smoothness; <as>as, <ex>terse</ex> language; a <ex>terse</ex> style</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Terse</qex>, luminous, and dignified eloquence.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A poet, too, was there, whose verse<br/
Was tender, musical, and <qex>terse</qex>.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Neat; concise; compact.</syn> <usage> <er>Terse</er>, <er>Concise</er>. <xex>Terse</xex> was defined by Johnson <ldquo/cleanly written<rdquo/, <it>i. e.</it>, free from blemishes, neat or smooth. Its present sense is <ldquo/free from excrescences,<rdquo/ and hence, <xex>compact</xex>, with smoothness, grace, or elegance, as in the following lones of Whitehead: -<br/
[<source>1913 Webster</source>]</p>

<p><q><ldquo/In eight <qex>terse</qex> lines has Phaedrus told<br/
(So frugal were the bards of old)<br/
A tale of goats; and closed with grace,<br/
Plan, moral, all, in that short space.<rdquo/</q><br/
[<source>1913 Webster</source>]</p>

<p>  It differs from <xex>concise</xex> in not implying, perhaps, quite as much condensation, but chiefly in the additional idea of <ldquo/grace or elegance.<rdquo/</usage><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Terse"ly</wf>, <pos>adv.</pos> -- <wf>Terse"ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tersulphide</ent><br/
<hw>Ter*sul"phide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pref. <ets>ter-</ets> + <ets>sulphide</ets>.]</ety> <fld>(Chem.)</fld> <def>A trisulphide.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tersulphuret</ent><br/
<hw>Ter*sul"phu*ret</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pref. <ets>ter-</ets> + <ets>sulphuret</ets>.]</ety> <fld>(Chem.)</fld> <def>A trisulphide.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ter-tenant</ent><br/
<hw>Ter"-ten`ant</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Terre-tenant</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tertial</ent><br/
<hw>Ter"tial</hw> <pr>(?)</pr>, <pos>a. & n.</pos> <ety>[From L. <ets>tertius</ets> third, the tertial feathers being feathers of the third row. See <er>Tierce</er>.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Tertiary</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tertian</ent><br/
<hw>Ter"tian</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tertianus</ets>, from <ets>tertius</ets> the third. See <er>Tierce</er>.]</ety> <fld>(Med.)</fld> <def>Occurring every third day; <as>as, a <ex>tertian</ex> fever</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tertian</ent><br/
<hw>Ter"tian</hw>, <pos>n.</pos> <ety>[L. <ets>tertiana</ets> (sc. <ets>febris</ets>): cf. OF. <ets>tertiane</ets>.]</ety> <sn>1.</sn> <fld>(Med.)</fld> <def>A disease, especially an intermittent fever, which returns every third day, reckoning inclusively, or in which the intermission lasts one day.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A liquid measure formerly used for wine, equal to seventy imperial, or eighty-four wine, gallons, being one third of a tun.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tertiary</ent><br/
<hw>Ter"ti*a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tertiarius</ets> containing a third part, fr. <ets>tertius</ets> third: cf. F. <ets>tertiaire</ets>. See <er>Tierce</er>.]</ety> <sn>1.</sn> <def>Being of the third formation, order, or rank; third; <as>as, a <ex>tertiary</ex> use of a word</as>.</def>  <rj><au>Trench.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>Possessing some quality in the third degree; having been subjected to the substitution of three atoms or radicals; <as>as, a <ex>tertiary</ex> alcohol, amine, or salt</as>.  Cf. <er>Primary</er>, and <er>Secondary</er>.</def>
<-- specifically, an organic compound in which the carbon atom attached to the eponymic functional group has three carbon atoms attached to it; <as>as, <ex>tertiary</ex> butyl alcohol, <chform>(CH3)3C.OH</chform></as>. --><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Geol.)</fld> <def>Later than, or subsequent to, the Secondary.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>Growing on the innermost joint of a bird's wing; tertial; -- said of quills.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tertiary age</b></col>. <fld>(Geol.)</fld> <cd>See under <er>Age</er>, 8.</cd> -- <col><b>Tertiary color</b></col>, <cd>a color produced by the mixture of two secondaries.</cd> <ldquo/The so-called <xex>tertiary colors</xex> are <it>citrine</it>, <it>russet</it>, and <it>olive.</it><rdquo/ <au>Fairholt.</au> -- <col><b>Tertiary period</b></col>. <fld>(Geol.)</fld> <sd>(a)</sd> <cd>The first period of the age of mammals, or of the Cenozoic era.</cd> <sd>(b)</sd> <cd>The rock formation of that period; -- called also <altname>Tertiary formation</altname>. See the <xex>Chart</xex> of <er>Geology</er>.</cd> -- <col><b>Tertiary syphilis</b></col> <fld>(Med.)</fld>, <cd>the third and last stage of syphilis, in which it invades the bones and internal organs.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tertiary</ent><br/
<hw>Ter"ti*a*ry</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tertiaries</plw> <pr>(<?/)</pr>.</plu> <sn>1.</sn> <fld>(R. C. Ch.)</fld> <def>A member of the Third Order in any monastic system; <as>as, the Franciscan <ex>tertiaries</ex>; the Dominican <ex>tertiaries</ex>; the Carmelite <ex>tertiaries</ex></as>. See <cref>Third Order</cref>, under <er>Third</er>.</def>  <rj><au>Addis & Arnold.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geol.)</fld> <def>The Tertiary era, period, or formation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>One of the quill feathers which are borne upon the basal joint of the wing of a bird. See <xex>Illust.</xex> of <er>Bird</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tertiate</ent><br/
<hw>Ter"ti*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L. <ets>tertiatus</ets>, p. p. of <ets>tertiare</ets> to do for the third time, fr. <ets>tertius</ets> the third.]</ety> <sn>1.</sn> <def>To do or perform for the third time.</def> <mark>[Obs. & R.]</mark>  <rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Gun.)</fld> <def>To examine, as the thickness of the metal at the muzzle of a gun; or, in general, to examine the thickness of, as ordnance, in order to ascertain its strength.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tertium quid</ent><br/
\'d8<hw>Ter"ti*um quid</hw> <pr>(?)</pr>. <ety>[L.]</ety> <def>A third somewhat; something mediating, or regarded as being, between two diverse or incompatible substances, natures, or positions.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Terutero</ent><br/
\'d8<hw>Ter`u*ter"o</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Probably so named from its city.]</ety> <fld>(Zool.)</fld> <def>The South American lapwing (<spn>Vanellus Cayennensis</spn>). Its wings are furnished with short spurs. Called also <altname>Cayenne lapwing</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terza rima</ent><br/
\'d8<hw>Ter"za ri"ma</hw> <pr>(?)</pr>. <ety>[It., a third or triple rhyme.]</ety> <def>A peculiar and complicated system of versification, borrowed by the early Italian poets from the Troubadours.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Terzetto</ent><br/
\'d8<hw>Ter*zet"to</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It., dim. of <ets>terzo</ets> the third, L. <ets>tertius</ets>. See <er>Tierce</er>.]</ety> <fld>(Mus.)</fld> <def>A composition in three voice parts; a vocal (rarely an instrumental) trio.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tesla transformer</ent><br/
<ent>Tesla coil</ent><br/
<mhw>{ <hw>Tes"la coil</hw>, <hw>Tes"la trans*form"er</hw> }</mhw> <pr>(?)</pr>. <ety>[After N. <etsep>Tesla</etsep>, American electrician.]</ety> <fld>(Elec.)</fld> <def>A transformer without iron, for high frequency alternating or oscillating currents; an oscillation transformer.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tesselar</ent><br/
<hw>Tes"sel*ar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tessella</ets> a small square piece, a little cube, dim. of <ets>tessera</ets> a square piece of stone, wood, etc., a die.]</ety> <def>Formed of tesserae, as a mosaic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tessellata</ent><br/
\'d8<hw>Tes`sel*la"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Tessellate</er>.]</ety> <fld>(Zool.)</fld> <def>A division of Crinoidea including numerous fossil species in which the body is covered with tessellated plates.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tessellate</ent><br/
<hw>Tes"sel*late</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tessellated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tessellating</conjf>.]</vmorph> <ety>[L. <ets>tessellatus</ets> tessellated. See <er>Tessellar</er>.]</ety> <def>To form into squares or checkers; to lay with checkered work.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The floors are sometimes of wood, <qex>tessellated</qex> after the fashion of France.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tessellate</ent><br/
<hw>Tes"sel*late</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tesselatus</ets>.]</ety> <def>Tessellated.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tessellated</ent><br/
<hw>Tes"sel*la`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Formed of little squares, as mosaic work; checkered; <as>as, a <ex>tessellated</ex> pavement</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot. & Zool.)</fld> <def>Marked like a checkerboard; <as>as, a <ex>tessellated</ex> leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tessellation</ent><br/
<hw>Tes`sel*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of tessellating; also, the mosaic work so formed.</def>  <rj><au>J. Forsyth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tessera</ent><br/
\'d8<hw>Tes"se*ra</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tesserae</plw> <pr>(#)</pr>.</plu> <ety>[L., a square piece, a die. See <er>Tessellar</er>.]</ety> <def>A small piece of marble, glass, earthenware, or the like, having a square, or nearly square, face, used by the ancients for mosaic, as for making pavements, for ornamenting walls, and like purposes; also, a similar piece of ivory, bone, wood, etc., used as a ticket of admission to theaters, or as a certificate for successful gladiators, and as a token for various other purposes.</def>  <rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tesseraic</ent><br/
<hw>Tes`se*ra"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Diversified by squares; done in mosaic; tessellated.</def> <mark>[Obs.]</mark>  <rj><au>Sir R. Atkyns (1712).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tesseral</ent><br/
<hw>Tes"se*ral</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Of, pertaining to, or containing, tesserae.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Crystallog.)</fld> <def>Isometric.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tessular</ent><br/
<hw>Tes"su*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Crystallog.)</fld> <def>Tesseral.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Test</ent><br/
<hw>Test</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>test</ets> test, or cupel, potsherd, F. <ets>t<ecir/t</ets>, from L. <ets>testum</ets> an earthen vessel; akin to <ets>testa</ets> a piece of burned clay, an earthen pot, a potsherd, perhaps for <ets>tersta</ets>, and akin to <ets>torrere</ets> to patch, <ets>terra</ets> earth (cf. <er>Thirst</er>, and <er>Terrace</er>), but cf. Zend <ets>tasta</ets> cup.  Cf. <er>Test</er> a shell, <er>Testaceous</er>, <er>Tester</er> a covering, a coin, <er>Testy</er>, <er>T<ecir/te-<agrave/-t<ecir/te</er>.]</ety> <sn>1.</sn> <fld>(Metal.)</fld> <def>A cupel or cupelling hearth in which precious metals are melted for trial and refinement.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our ingots, <qex>tests</qex>, and many mo.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Examination or trial by the cupel; hence, any critical examination or decisive trial; <as>as, to put a man's assertions to a <ex>test</ex></as>.</def> <ldquo/Bring me to the <xex>test</xex>.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Means of trial; <as>as, absence is a <ex>test</ex> of love</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Each <qex>test</qex> every light her muse will bear.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>That with which anything is compared for proof of its genuineness; a touchstone; a standard.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Life, force, and beauty must to all impart,<br/
At once the source, and end, and <qex>test</qex> of art.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Discriminative characteristic; standard of judgment; ground of admission or exclusion.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our <qex>test</qex> excludes your tribe from benefit.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Judgment; distinction; discrimination.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Who would excel, when few can make a <qex>test</qex><br/
Betwixt indifferent writing and the best?</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Chem.)</fld> <def>A reaction employed to recognize or distinguish any particular substance or constituent of a compound, as the production of some characteristic precipitate; also, the reagent employed to produce such reaction; thus, the ordinary <xex>test</xex> for sulphuric acid is the production of a white insoluble precipitate of barium sulphate by means of some soluble barium salt.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>A set of questions to be answered or problems to be solved, used as a means to measure a person's knowledge, aptitude, skill, intelligence, etc.; in school settings, synonymous with <altname>examination</altname> or <altname>exam</altname>; <as>as, an intelligence <ex>test</ex></as>.  Also used attributively; <as>as a <ex>test</ex> score, <ex>test</ex> results</as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Test act</b></col> <fld>(Eng. Law)</fld>, <cd>an act of the English Parliament prescribing a form of oath and declaration against transubstantiation, which all officers, civil and military, were formerly obliged to take within six months after their admission to office. They were obliged also to receive the sacrament according to the usage of the Church of England.</cd> <au>Blackstone.</au> -- <col><b>Test object</b></col> <fld>(Optics)</fld>, <cd>an object which tests the power or quality of a microscope or telescope, by requiring a certain degree of excellence in the instrument to determine its existence or its peculiar texture or markings.</cd> -- <col><b>Test paper</b></col>. <sd>(a)</sd> <fld>(Chem.)</fld> <cd>Paper prepared for use in testing for certain substances by being saturated with a reagent which changes color in some specific way when acted upon by those substances; thus, litmus paper is turned red by acids, and blue by alkalies, turmeric paper is turned brown by alkalies, etc.</cd> <sd>(b)</sd> <fld>(Law)</fld> <cd>An instrument admitted as a standard or comparison of handwriting in those jurisdictions in which comparison of hands is permitted as a mode of proving handwriting.</cd> -- <col><b>Test tube</b></col>. <fld>(Chem.)</fld> <sd>(a)</sd> <cd>A simple tube of thin glass, closed at one end, for heating solutions and for performing ordinary reactions.</cd> <sd>(b)</sd> <cd>A graduated tube.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Criterion; standard; experience; proof; experiment; trial.</syn> <usage> -- <er>Test</er>, <er>Trial</er>. <xex>Trial</xex> is the wider term; <xex>test</xex> is a searching and decisive <xex>trial</xex>. It is derived from the Latin <xex>testa</xex> (earthen pot), which term was early applied to the <xex>fining pot</xex>, or <xex>crucible</xex>, in which metals are melted for trial and refinement. Hence the peculiar force of the word, as indicating a trial or criterion of the most decisive kind.</usage><br/
[<source>1913 Webster</source>]</p>

<p><q>I leave him to your gracious acceptance, whose <qex>trial</qex> shall better publish his commediation.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Thy virtue, prince, has stood the <qex>test</qex> of fortune,<br/
Like purest gold, that tortured in the furnace,<br/
Comes out more bright, and brings forth all its weight.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Test</ent><br/
<hw>Test</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tested</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Testing</conjf>.]</vmorph> <sn>1.</sn> <fld>(Metal.)</fld> <def>To refine, as gold or silver, in a test, or cupel; to subject to cupellation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To put to the proof; to prove the truth, genuineness, or quality of by experiment, or by some principle or standard; to try; <as>as, to <ex>test</ex> the soundness of a principle; to <ex>test</ex> the validity of an argument.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Experience is the surest standard by which to <qex>test</qex> the real tendency of the existing constitution.</q> <rj><qau>Washington.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Chem.)</fld> <def>To examine or try, as by the use of some reagent; <as>as, to <ex>test</ex> a solution by litmus paper</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To administer a test{8} to (someone) for the purpose of ascertaining a person's knowledge or skill; especially, in academic settings, to determine how well a student has learned the subject matter of a course of instruction.</def><br/
[<source>PJC</source>]</p>

<p><-- p. 1490 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Test</ent><br/
<hw>Test</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>testis</ets>.  Cf. <er>Testament</er>, <er>Testify</er>.]</ety> <def>A witness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Prelates and great lords of England, who were for the more surety <qex>tests</qex> of that deed.</q> <rj><qau>Ld. Berners.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Test</ent><br/
<hw>Test</hw>, <pos>v. i.</pos> <ety>[L. <ets>testari</ets>. See <er>Testament</er>.]</ety> <def>To make a testament, or will.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testa</ent><br/
<ent>Test</ent><br/
<mhw>{ <hw>Test</hw> <pr>(?)</pr>, \'d8<hw>Tes"ta</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos>; <plu><it>pl.</it> E. <plw>Tests</plw> <pr>(#)</pr>, L. <plw>Testae</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>testa</ets> a piece of burned clay, a broken piece of earthenware, a shell. See <er>Test</er> a cupel.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>The external hard or firm covering of many invertebrate animals.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>test</xex> of crustaceans and insects is composed largely of chitin; in mollusks it is composed chiefly of calcium carbonate, and is called the <xex>shell</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>The outer integument of a seed; the episperm, or spermoderm.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testable</ent><br/
<hw>Test"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Testament</er>.]</ety> <sn>1.</sn> <def>Capable of being tested or proved.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Capable of being devised, or given by will.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testacea</ent><br/
\'d8<hw>Tes*ta"ce*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>testaceum</ets> a shelled anumal. See <er>Testaceous</er>.]</ety> <fld>(Zool.)</fld> <def>Invertebrate animals covered with shells, especially mollusks; shellfish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testacean</ent><br/
<hw>Tes*ta"cean</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Onr of the Testacea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testaceography</ent><br/
<hw>Tes*ta`ce*og"ra*phy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Testacea</ets> + <ets>-graphy</ets>: cf. F. <ets>testac<eacute/ographie</ets>.]</ety> <def>The science which treats of testaceans, or shellfish; the description of shellfish.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testaceology</ent><br/
<hw>Tes*ta`ce*ol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Testacea</ets> + <ets>-logy</ets>: cf. F. <ets>testac<eacute/ologie</ets>.]</ety> <def>The science of testaceous mollusks; conchology.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testaceous</ent><br/
<hw>Tes*ta"ceous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>testaceus</ets>, fr. <ets>testa</ets> a shell. See <er>Testa</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to shells; consisted of a hard shell, or having a hard shell.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot. & Zool.)</fld> <def>Having a dull red brick color or a brownish yellow color.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Testaceous animals</b></col> <fld>(Zool.)</fld>, <cd>animals having a firm, calcareous shell, as oysters and clams, thus distinguished from <contr>crustaceous animals</contr>, whose shells are more thin and soft, and consist of several joints, or articulations, as lobsters and crabs.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testacy</ent><br/
<hw>Tes"ta*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Testate</er>.]</ety> <fld>(Law)</fld> <def>The state or circumstance of being testate, or of leaving a valid will, or testament, at death.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testament</ent><br/
<hw>Tes"ta*ment</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>testamentum</ets>, fr. <ets>testari</ets> to be a witness, to make one's last will, akin to <ets>testis</ets> a witness.  Cf. <er>Intestate</er>, <er>Testify</er>.]</ety> <sn>1.</sn> <fld>(Law)</fld> <def>A solemn, authentic instrument in writing, by which a person declares his will as to disposal of his estate and effects after his death.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This is otherwise called a <xex>will</xex>, and sometimes a <xex>last will and testament</xex>. A <xex>testament</xex>, to be valid, must be made by a person of sound mind; and it must be executed and published in due form of law. A man, in certain cases, may make a valid will by word of mouth only. See <cref>Nuncupative will</cref>, under <er>Nuncupative</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of the two distinct revelations of God's purposes toward man; a covenant; also, one of the two general divisions of the canonical books of the sacred Scriptures, in which the covenants are respectively revealed; <as>as, the Old <ex>Testament</ex>; the New <ex>Testament</ex>; -- often limited, in colloquial language, to the latter.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>He is the mediator of the new <qex>testament</qex> . . . for the redemption of the transgressions that were under the first <qex>testament</qex>.</q> <rj><qau>Heb. ix. 15.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Holographic testament</b></col>, <cd>a testament written wholly by the testator himself.</cd> <au>Bouvier.</au></cs>
<-- also holographic will.  "Written" means, in handwriting. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testamental</ent><br/
<hw>Tes`ta*men"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>testamentalis</ets>.]</ety> <def>Of or pertaining to a testament; testamentary.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thy <qex>testamental</qex> cup I take,<br/
And thus remember thee.</q> <rj><qau>J. Montgomery.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testamentary</ent><br/
<hw>Tes`ta*men"ta*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>testamentarius</ets>: cf. F. <ets>testamentaire</ets>.]</ety> <sn>1.</sn> <def>Of or pertaining to a will, or testament; <as>as, letters <ex>testamentary</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Bequeathed by will; given by testament.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>How many <qex>testamentary</qex> charities have been defeated by the negligence or fraud of executors!</q> <rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Done, appointed by, or founded on, a testament, or will; <as>as, a <ex>testamentary</ex> guardian of a minor, who may be appointed by the will of a father to act in that capacity until the child becomes of age</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testamentation</ent><br/
<hw>Tes`ta*men*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act or power of giving by testament, or will.</def> <mark>[R.]</mark>  <rj><au>Burke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testamentize</ent><br/
<hw>Tes"ta*men*tize</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To make a will.</def> <mark>[Obs.]</mark>  <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testamur</ent><br/
\'d8<hw>Tes*ta"mur</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., we testify, fr. <ets>testari</ets> to testify.]</ety> <fld>(Eng. Universities)</fld> <def>A certificate of merit or proficiency; -- so called from the Latin words, <xex>Ita testamur</xex>, with which it commences.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testate</ent><br/
<hw>Tes"tate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>testatus</ets>, p. p. of <ets>testari</ets>. See <er>Testament</er>.]</ety> <fld>(Law)</fld> <def>Having made and left a will; <as>as, a person is said to die <ex>testate</ex></as>.</def>  <rj><au>Ayliffe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testate</ent><br/
<hw>Tes"tate</hw>, <pos>n.</pos> <fld>(Law)</fld> <def>One who leaves a valid will at death; a testate person.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testation</ent><br/
<hw>Tes*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>testatio</ets>.]</ety> <def>A witnessing or witness.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testator</ent><br/
<hw>Tes*ta"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.: cf. F. <ets>testateur</ets>.]</ety> <fld>(Law)</fld> <def>A man who makes and leaves a will, or testament, at death.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testatrix</ent><br/
<hw>Tes*ta"trix</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <fld>(Law)</fld> <def>A woman who makes and leaves a will at death; a female testator.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teste</ent><br/
<hw>Tes"te</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So called fr. L. <ets>teste</ets>, abl. of <ets>testis</ets> a witness, because this was formerly the initial word in the clause.]</ety> <fld>(Law)</fld> <sd>(a)</sd> <def>A witness.</def> <sd>(b)</sd> <def>The witnessing or concluding clause, duty attached; -- said of a writ, deed, or the like.</def>  <rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tester</ent><br/
<hw>Tes"ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>testere</ets> a headpiece, helmet, OF. <ets>testiere</ets>, F. <ets>t<ecir/ti<egrave/re</ets> a head covering, fr. OF. <ets>teste</ets> the head, F. <ets>t<ecir/te</ets>, fr. L. <ets>testa</ets> an earthen pot, the skull. See <er>Test</er> a cupel, and cf. <er>Testi<egrave/re</er>.]</ety> <sn>1.</sn> <def>A headpiece; a helmet.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The shields bright, <qex>testers</qex>, and trappures.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A flat canopy, as over a pulpit or tomb.</def>  <rj><au>Oxf. Gross.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A canopy over a bed, supported by the bedposts.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No <qex>testers</qex> to the bed, and the saddles and portmanteaus heaped on me to keep off the cold.</q> <rj><qau>Walpole.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tester</ent><br/
<hw>Tes"ter</hw>, <pos>n.</pos> <ety>[For <ets>testern</ets>, <ets>teston</ets>, fr. F. <ets>teston</ets>, fr. OF. <ets>teste</ets> the head, the head of the king being impressed upon the coin. See <er>Tester</er> a covering, and cf. <er>Testone</er>, <er>Testoon</er>.]</ety> <def>An old French silver coin, originally of the value of about eighteen pence, subsequently reduced to ninepence, and later to sixpence, sterling. Hence, in modern English slang, a sixpence; -- often contracted to <altname>tizzy</altname>. Called also <altname>teston</altname>.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testern</ent><br/
<hw>Tes"tern</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A sixpence; a tester.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testern</ent><br/
<hw>Tes"tern</hw>, <pos>v. t.</pos> <def>To present with a tester.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testes</ent><br/
\'d8<hw>Tes"tes</hw> <pr>(?)</pr>, <pos>n.</pos>, <def><pos>pl.</pos> of <er>Teste</er>, or of <er>Testis</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testicardines</ent><br/
\'d8<hw>Tes`ti*car"di*nes</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Test</er> a shell, and <er>Cardo</er>.]</ety> <fld>(Zool.)</fld> <def>A division of brachiopods including those which have a calcareous shell furnished with a hinge and hinge teeth. Terebratula and Spirifer are examples.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testicle</ent><br/
<hw>Tes"ti*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>testiculus</ets>, dim. of <ets>testis</ets> a testicle, probably the same word as <ets>testis</ets> a witness, as being a witness to manhood.  Cf. <er>Test</er> a witness.]</ety> <fld>(Anat.)</fld> <def>One of the essential male genital glands which secrete the semen.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testicond</ent><br/
<hw>Tes"ti*cond</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>testis</ets> testis + <ets>condere</ets> to hide.]</ety> <fld>(Zool.)</fld> <def>Having the testicles naturally concealed, as in the case of the cetaceans.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testicular</ent><br/
<hw>Tes*tic"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <def>Of or pertaining to the testicle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testiculate</ent><br/
<hw>Tes*tic"u*late</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[NL. <ets>testiculatus</ets>.]</ety> <fld>(Bot.)</fld> <sd>(a)</sd> <def>Shaped like a testicle, ovate and solid.</def> <sd>(b)</sd> <def>Having two tubers resembling testicles in form, as some species of orchis.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testiere</ent><br/
\'d8<hw>Tes`ti*<egrave/re"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>testiere</ets>. See <er>Tester</er> a headpiece.]</ety> <def>A piece of plate armor for the head of a war horse; a tester.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testif</ent><br/
<hw>Tes"tif</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Testy</er>.]</ety> <def>Testy; headstrong; obstinate.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Testif</qex> they were and lusty for to play.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testification</ent><br/
<hw>Tes`ti*fi*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>testificatio</ets>: cf. OF. <ets>testification</ets>. See <er>Testify</er>.]</ety> <def>The act of testifying, or giving testimony or evidence; <as>as, a direct <ex>testification</ex> of our homage to God</as>.</def>  <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testificator</ent><br/
<hw>Tes"ti*fi*ca`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety> <def>A testifier.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testifier</ent><br/
<hw>Tes"ti*fi`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who testifies; one who gives testimony, or bears witness to prove anything; a witness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testify</ent><br/
<hw>Tes"ti*fy</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Testified</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Testifying</conjf> <pr>(?)</pr>.]</vmorph> <ety>[OF. <ets>testifier</ets>, L. <ets>testificari</ets>; <ets>testis</ets> a witness + <ets>-ficare</ets> (in comp.) to make. See <er>-fy</er>, and cf. <er>Attest</er>, <er>Contest</er>, <er>Detest</er>, <er>Protest</er>, <er>Testament</er>.]</ety> <sn>1.</sn> <def>To make a solemn declaration, verbal or written, to establish some fact; to give testimony for the purpose of communicating to others a knowledge of something not known to them.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Jesus . . . needed not that any should <qex>testify</qex> of man, for he knew what was in man.</q> <rj><qau>John ii. 25.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>To make a solemn declaration under oath or affirmation, for the purpose of establishing, or making proof of, some fact to a court; to give testimony in a cause depending before a tribunal.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>One witness shall not <qex>testify</qex> against any person to cause him to die.</q> <rj><qau>Num. xxxv. 30.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To declare a charge; to protest; to give information; to bear witness; -- with <xex>against</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>O Israel, . . . I will <qex>testify</qex> against thee.</q> <rj><qau>Ps. l. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I <qex>testified</qex> against them in the day wherein they sold victuals.</q> <rj><qau>Neh. xiii. 15.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testify</ent><br/
<hw>Tes"ti*fy</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To bear witness to; to support the truth of by testimony; to affirm or declare solemny.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We speak that we do know, and <qex>testify</qex> that we have seen; and ye receive not our witness.</q> <rj><qau>John iii. 11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>To affirm or declare under oath or affirmation before a tribunal, in order to prove some fact.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testify</ent><br/
<hw>Tes"ti*fy</hw>, <pos>adv.</pos> <def>In a testy manner; fretfully; peevishly; with petulance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testimonial</ent><br/
<hw>Tes`ti*mo"ni*al</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. OF. <ets>testimoniale</ets>, LL. <ets>testimonialis</ets>, L. <ets>testimoniales</ets> (sc. <ets>litterae</ets>). See <er>Testimonial</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>A writing or certificate which bears testimony in favor of one's character, good conduct, ability, etc., or of the value of a thing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Something, as money or plate, presented to a preson as a token of respect, or of obligation for services rendered.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testimonial</ent><br/
<hw>Tes`ti*mo"ni*al</hw>, <pos>a.</pos> <ety>[L. <ets>testimonialis</ets>: cf. F. <ets>testimonial</ets>.]</ety> <def>Relating to, or containing, testimony.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testimony</ent><br/
<hw>Tes"ti*mo*ny</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Testimonies</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>testimonium</ets>, from <ets>testis</ets> a witness: cf. OF. <ets>testimoine</ets>, <ets>testemoine</ets>, <ets>testimonie</ets>. See <er>Testify</er>.]</ety> <sn>1.</sn> <def>A solemn declaration or affirmation made for the purpose of establishing or proving some fact.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Such declaration, in judicial proceedings, may be verbal or written, but must be under oath or affirmation.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Affirmation; declaration; <as>as, these doctrines are supported by the uniform <ex>testimony</ex> of the fathers; the belief of past facts must depend on the evidence of human <ex>testimony</ex>, or the <ex>testimony</ex> of historians</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Open attestation; profession.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[Thou] for the <qex>testimony</qex> of truth, hast borne<br/
Universal reproach.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Witness; evidence; proof of some fact.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When ye depart thence, shake off the dust under your feet for a <qex>testimony</qex> against them.</q> <rj><qau>Mark vi. 11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Jewish Antiq.)</fld> <def>The two tables of the law.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou shalt put into the ark the <qex>testimony</qex> which I shall give thee.</q> <rj><qau>Ex. xxv. 16.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Hence, the whole divine revelation; the sacre<?/ Scriptures.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>testimony</qex> of the Lord is sure, making wise the simple.</q> <rj><qau>Ps. xix. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Proof; evidence; attestation; witness; affirmation; confirmation; averment.</syn> <usage> -- <er>Testimony</er>, <er>Proof</er>, <er>Evidence</er>. <xex>Proof</xex> is the most familiar, and is used more frequently (though not exclusively) of facts and things which occur in the ordinary concerns of life. <xex>Evidence</xex> is a word of more dignity, and is more generally applied to that which is moral or intellectual; <as>as, the <ex>evidences</ex> of Christianity, etc.</as> <xex>Testimony</xex> is what is deposed to by a witness on oath or affirmation. When used figuratively or in a wider sense, the word <xex>testimony</xex> has still a reference to some living agent as its author, as when we speak of the <xex>testimony</xex> of conscience, or of doing a thing in <xex>testimony</xex> of our affection, etc. <xex>Testimony</xex> refers rather to the thing declared, <xex>evidence</xex> to its value or effect. <ldquo/To conform our language more to common use, we ought to divide arguments into demonstrations, <xex>proofs</xex>, and probabilities; ba <xex>proofs</xex>, meaning such arguments from experience as leave no room for doubt or opposition.<rdquo/ <au>Hume.</au> <ldquo/The <xex>evidence</xex> of sense is the first and highest kind of <xex>evidence</xex> of which human nature is capable.<rdquo/ <au>Bp. Wilkins.</au> <ldquo/The <xex>proof</xex> of everything must be by the <xex>testimony</xex> of such as the parties produce.<rdquo/ <au>Spenser.</au></usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testimony</ent><br/
<hw>Tes"ti*mo*ny</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To witness; to attest; to prove by testimony.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testiness</ent><br/
<hw>Tes"ti*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being testy; fretfulness; petulance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Testiness</qex> is a disposition or aptness to be angry.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testing</ent><br/
<hw>Test"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act of testing or proving; trial; proof.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Metal.)</fld> <def>The operation of refining gold or silver in a <xex>test</xex>, or cupel; cupellation.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Testing machine</b></col> <fld>(Engin.)</fld>, <cd>a machine used in the determination of the strength of materials, as iron, stone, etc., and their behavior under strains of various kinds, as elongation, bending, crushing, etc.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testis</ent><br/
\'d8<hw>Tes"tis</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Testes</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <fld>(Anat.)</fld> <def>A testicle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Test-market</ent><br/
<hw>Test"-mark`et</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>to market (a product) in a limited area for a period of time to determine the probable demand.</def><br/
[<source>PJC</source>]</p>

<p><ent>Teston</ent><br/
<hw>Tes"ton</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A tester; a sixpence.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testone</ent><br/
<hw>Tes*tone"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Pg. <ets>test<atil/o</ets>, <ets>tost<atil/o</ets>. See <er>Testoon</er>.]</ety> <def>A silver coin of Portugal, worth about sixpence sterling, or about eleven cents.</def>  <rj><au>Homans.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testoon</ent><br/
<hw>Tes*toon"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It. <ets>testone</ets>. See <er>Tester</er> a coin.]</ety> <def>An Italian silver coin. The testoon of Rome is worth 1s. 3d. sterling, or about thirty cents.</def>  <rj><au>Homans.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testosterone</ent><br/
<hw>Tes*tos"ter*one</hw> <pr>(t<ecr/s*t<ocr/s"t<etil/r*<omac/n)</pr>, <pos>n.</pos> <ety>[<ets>test</ets>es + o + <ets>sterone</ets> a steroid ketone.]</ety> <def>a steroid hormone (<chform>C19H28O2</chform>) produced mostly in the testes, which is responsible for producing the secondary sexual characteristics of males.</def><br/
[<source>PJC</source>]</p>

<p><ent>Testudinal</ent><br/
<hw>Tes*tu"di*nal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Testudo</er>.]</ety> <fld>(Zool.)</fld> <def>Of, pertaining to, or resembling, a tortoise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testudinarious</ent><br/
<hw>Tes*tu`di*na"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Of or pertaining to the shell of a tortoise; resembling a tortoise shell; having the color or markings of a tortoise shell.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testudinata</ent><br/
\'d8<hw>Tes*tu`di*na"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[Nl. See <er>Testudo</er>.]</ety> <fld>(Zool.)</fld> <def>An order of reptiles which includes the turtles and tortoises. The body is covered by a shell consisting of an upper or dorsal shell, called the <part>carapace</part>, and a lower or ventral shell, called the <part>plastron</part>, each of which consists of several plates.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testudinated</ent><br/
<ent>Testudinate</ent><br/
<mhw>{ <hw>Tes*tu"di*nate</hw> <pr>(?)</pr>, <hw>Tes*tu"di*na`ted</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>testudinatus</ets>, fr. <ets>testudo</ets>, <ets>-inis</ets>, a tortoise, an arch or vault.]</ety> <def>Resembling a tortoise shell in appearance or structure; roofed; arched; vaulted.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testudineous</ent><br/
<hw>Tes`tu*din"e*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>testudineus</ets>.]</ety> <def>Resembling the shell of a tortoise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testudo</ent><br/
\'d8<hw>Tes*tu"do</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Testudines</plw> <pr>(#)</pr>.</plu> <ety>[L., from <ets>testa</ets> the shell of shellfish, or of testaceous animals.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>A genus of tortoises which formerly included a large number of diverse forms, but is now restricted to certain terrestrial species, such as the European land tortoise (<spn>Testudo Graeca</spn>) and the gopher of the Southern United States.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Rom. Antiq.)</fld> <def>A cover or screen which a body of troops formed with their shields or targets, by holding them over their heads when standing close to each other. This cover resembled the back of a tortoise, and served to shelter the men from darts, stones, and other missiles. A similar defense was sometimes formed of boards, and moved on wheels.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Mus.)</fld> <def>A kind of musical instrument. a species of lyre; -- so called in allusion to the lyre of Mercury, fabled to have been made of the shell of a tortoise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Testy</ent><br/
<hw>Tes"ty</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Testier</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Testiest</adjf>.]</amorph> <ety>[OF. <ets>testu</ets> obstinate, headstrong, F. <ets>t<ecir/tu</ets>, fr. OF. <ets>teste</ets> the head, F. <ets>t<ecir/te</ets>. See <er>Test</er> a cupel.]</ety> <def>Fretful; peevish; petulant; easily irritated.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Must I observe you? must I stand and crouch<br/
Under your <qex>testy</qex> humor?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I was displeased with myself; I was <qex>testy</qex>.</q> <rj><qau>Latimer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetanic</ent><br/
<hw>Te*tan"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. L. <ets>tetanicus</ets> suffering from tetanus, Gr. <?/, F. <ets>t<eacute/tanique</ets>.]</ety> <sn>1.</sn> <fld>(Physiol.)</fld> <def>Of or pertaining to tetanus; having the character of tetanus; <as>as, a <ex>tetanic</ex> state; <ex>tetanic</ex> contraction.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>This condition of muscle, this fusion of a number of simple spasms into an apparently smooth, continuous effort, is known as tetanus, or <qex>tetanic</qex> contraction.</q> <rj><qau>Foster.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Physiol. & Med.)</fld> <def>Producing, or tending to produce, tetanus, or tonic contraction of the muscles; <as>as, a <ex>tetanic</ex> remedy</as>. See <er>Tetanic</er>, <pos>n.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1491 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetanic</ent><br/
<hw>Te*tan"ic</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Physiol. & Med.)</fld> <def>A substance (notably nux vomica, strychnine, and brucine) which, either as a remedy or a poison, acts primarily on the spinal cord, and which, when taken in comparatively large quantity, produces tetanic spasms or convulsions.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetanin</ent><br/
<hw>Tet"a*nin</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Physiol. Chem.)</fld> <def>A poisonous base (ptomaine) formed in meat broth through the agency of a peculiar microbe from the wound of a person who has died of tetanus; -- so called because it produces tetanus as one of its prominent effects.</def>
<-- ?? not in Merck INdex -- tetanospasmin?  The neurotoxin of Clostridium tetani. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetanization</ent><br/
<hw>Tet`a*ni*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Physiol.)</fld> <def>The production or condition of tetanus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetanize</ent><br/
<hw>Tet"a*nize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <fld>(Physiol.)</fld> <def>To throw, as a muscle, into a state of permanent contraction; to cause tetanus in. See <er>Tetanus</er>, <pos>n.</pos>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetanoid</ent><br/
<hw>Tet"a*noid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetanus</ets> + <ets>-oid</ets>.]</ety> <fld>(Med. & Physiol.)</fld> <def>Resembling tetanus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetanomotor</ent><br/
<hw>Tet`a*no*mo"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Physiol.)</fld> <def>An instrument from tetanizing a muscle by irritating its nerve by successive mechanical shocks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetanus</ent><br/
\'d8<hw>Tet"a*nus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr. Gr. <?/, fr. <?/ stretched, <?/ to stretch.]</ety> <sn>1.</sn> <fld>(Med.)</fld> <def>A painful and usually fatal disease, resulting generally from a wound, and having as its principal symptom persistent spasm of the voluntary muscles. When the muscles of the lower jaw are affected, it is called <altname>locked-jaw</altname>, or <altname>lickjaw</altname>, and it takes various names from the various incurvations of the body resulting from the spasm.</def><-- caused by the anaerobic bacterium Clostridium tetani. --><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Physiol.)</fld> <def>That condition of a muscle in which it is in a state of continued vibratory contraction, as when stimulated by a series of induction shocks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetany</ent><br/
<hw>Tet"a*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Med.)</fld> <def>A morbid condition resembling tetanus, but distinguished from it by being less severe and having intermittent spasms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetard</ent><br/
<hw>Te*tard"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A gobioid fish (<spn>Eleotris gyrinus</spn>) of the Southern United States; -- called also <altname>sleeper</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetartohedral</ent><br/
<hw>Te*tar`to*he"dral</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/ fourth + <?/ base.]</ety> <fld>(Crystallog.)</fld> <def>Having one fourth the number of planes which are requisite to complete symmetry.</def> -- <wordforms><wf>Te*tar`to*he"dral*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetartohedrism</ent><br/
<hw>Te*tar`to*he"drism</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Crystallog.)</fld> <def>The property of being tetartohedral.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetaug</ent><br/
<hw>Te*taug"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Tautog</er>.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetchiness</ent><br/
<hw>Tetch"i*ness</hw>, <pos>n.</pos> <def>See <er>Techiness</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetchy</ent><br/
<hw>Tetch"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>See <er>Techy</er>.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tete</ent><br/
\'d8<hw>T<ecir/te</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., the head. See <er>Tester</er> a covering.]</ety> <def>A kind of wig; false hair.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tete-a-tete</ent><br/
\'d8<hw>T<ecir/te`-<agrave/-t<ecir/te"</hw> <pr>(t<amac/t`<adot/*t<amac/t")</pr>, <pos>n.</pos> <ety>[F., head to head. See <er>Tester</er> a covering, <er>Test</er> a cupel.]</ety> <sn>1.</sn> <def>Private conversation; familiar interview or conference of two persons.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A short sofa intended to accomodate two persons.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tete-a-tete</ent><br/
\'d8<hw>T<ecir/te`-<agrave/-t<ecir/te"</hw>, <pos>a.</pos> <def>Private; confidential; familiar.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She avoided <qex>t<ecir/te-<agrave/-t<ecir/te</qex> walks with him.</q> <rj><qau>C. Kingsley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tete-a-tete</ent><br/
\'d8<hw>T<ecir/te`-<agrave/-t<ecir/te"</hw>, <pos>adv.</pos> <def>Face to face; privately or confidentially; familiarly.</def>  <rj><au>Prior.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tete-de-pont</ent><br/
\'d8<hw>T<ecir/te`-de-pont"</hw> <pr>(t<amac/t`d<eit/*p<ocir/N")</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>T<ecir/tes-de-pont</plw> <pr>(#)</pr>.</plu> <ety>[F., head of a bridge.]</ety> <fld>(Mil.)</fld> <def>A work thrown up at the end of a bridge nearest the enemy, for covering the communications across a river; a bridgehead.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetel</ent><br/
<hw>Te*tel"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A large African antelope (<spn>Alcelaphus tora</spn>). It has widely divergent, strongly ringed horns.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tether</ent><br/
<hw>Teth"er</hw> <pr>(t<ecir/<th/"<etil/r)</pr>, <pos>n.</pos> <ety>[Formerly <ets>tedder</ets>, OE. <ets>tedir</ets>; akin to LG. <ets>tider</ets>, <ets>tier</ets>, Icel. <ets>tj<omac/<edh/r</ets>, Sw. <ets>tj<umac/der</ets>, Dan. <ets>t<oum/ir</ets>. <root/64.]</ety> <def>A long rope or chain by which an animal is fastened, as to a stake, so that it can range or feed only within certain limits.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tether</ent><br/
<hw>Teth"er</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tethered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tethering</conjf>.]</vmorph> <def>To confine, as an animal, with a long rope or chain, as for feeding within certain limits.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And by a slender cord was <qex>tethered</qex> to a stone.</q> <rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tether-ball</ent><br/
<hw>Teth"er-ball`</hw>, <pos>n.</pos> <def>A game played with rackets and a ball suspended by a string from an upright pole, the object of each side being to wrap the string around the pole by striking the ball in a direction opposite to the other.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tethydan</ent><br/
<hw>Te*thy"dan</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tethys</er>.]</ety> <fld>(Zool.)</fld> <def>A tunicate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tethyodea</ent><br/
\'d8<hw>Te`thy*o"de*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. <ets>Tethys</ets> + Gr. <grk>e'i^dos</grk> form.]</ety> <fld>(Zool.)</fld> <def>A division of Tunicata including the common attached ascidians, both simple and compound. Called also <altname>Tethioidea</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tethys</ent><br/
<hw>Te"thys</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ an oyster, or <?/ a kind of ascidian.]</ety> <fld>(Zool.)</fld> <def>A genus of a large naked mollusks having a very large, broad, fringed cephalic disk, and branched dorsal gills. Some of the species become a foot long and are brilliantly colored.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetra-</ent><br/
<hw>Tet"ra-</hw> <pr>(?)</pr>. <ety>[Gr. <grk>te`tra-</grk>, from <grk>te`sares</grk>, <grk>te`ttares</grk>, four. See <er>Four</er>.]</ety> <sn>1.</sn> <def>A combining form or prefix signifying <xex>four</xex>, as in <xex>tetra</xex>basic, <xex>tetra</xex>petalous.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>A combining form (also used adjectively) denoting <xex>four proportional</xex> or <xex>combining parts</xex> of the substance or ingredient denoted by the term to which it is prefixed, as in <xex>tetra</xex>-chloride, <xex>tetr</xex>oxide.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrabasic</ent><br/
<hw>Tet`ra*bas"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>basic</ets>.]</ety> <fld>(Chem.)</fld> <def>Capable of neutralizing four molecules of a monacid base; having four hydrogen atoms capable of replacement by bases; quadribasic; -- said of certain acids; thus, normal silicic acid, <chform>Si(OH)4</chform>, is a <xex>tetrabasic</xex> acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraboric</ent><br/
<hw>Tet`ra*bor"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>boric</ets>.]</ety> <fld>(Chem.)</fld> <def>Same as <er>Pyroboric</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrabranchiata</ent><br/
\'d8<hw>Tet`ra*bran`chi*a"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Tetra-</er>, and <er>Branchia</er>.]</ety> <fld>(Zool.)</fld> <def>An order of Cephalopoda having four gills. Among living species it includes only the pearly nautilus. Numerous genera and species are found in the fossil state, such as Ammonites, Baculites, Orthoceras, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrabranchiate</ent><br/
<hw>Tet`ra*bran`chi*ate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra</ets> + <ets>branchiate</ets>.]</ety> <fld>(Zool.)</fld> <def>Of or pertaining to the Tetrabranchiata.</def> -- <def2><pos>n.</pos> <def>One of the Tetrabranchiata.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetracarpel</ent><br/
<hw>Tet`ra*car"pel</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>carpellary</ets>.]</ety> <fld>(Bot.)</fld> <def>Composed of four carpels.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrachord</ent><br/
<hw>Tet"ra*chord</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tetrachordon</ets>, Gr. <?/, from <?/ four-stringed; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ a chord: cf. F. <ets>t<eacute/trachorde</ets>.]</ety> <fld>(Anc. Mus.)</fld> <def>A scale series of four sounds, of which the extremes, or first and last, constituted a fourth. These extremes were immutable; the two middle sounds were changeable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrachotomous</ent><br/
<hw>Tet`ra*chot"o*mous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>te`tracha</grk> in four parts + <grk>te`mnein</grk> to cut.]</ety> <fld>(Bot.)</fld> <def>Having a division by fours; separated into four parts or series, or into series of fours.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetracid</ent><br/
<hw>Tet*rac"id</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra</ets> + <ets>acid</ets>.]</ety> <fld>(Chem.)</fld> <def>Capable of neutralizing four molecules of a monobasic acid; having four hydrogen atoms capable of replacement ba acids or acid atoms; -- said of certain bases; <as>thus, erythrine, <chform>C4H6(OH)4</chform>, is a <ex>tetracid</ex> alcohol</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetracoccous</ent><br/
<hw>Tet`ra*coc"cous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Tetra-</er>, and <er>Coccus</er>.]</ety> <fld>(Bot.)</fld> <def>Having four cocci, or carpels.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetracolon</ent><br/
<hw>Tet`ra*co"lon</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ with four members; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ limb, member.]</ety> <fld>(Pros.)</fld> <def>A stanza or division in lyric poetry, consisting of four verses or lines.</def>  <rj><au>Crabb.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetracoralla</ent><br/
\'d8<hw>Te`tra*co*ral"la</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Tetra-</er>, and <er>Corallum</er>.]</ety> <fld>(Paleon.)</fld> <def>Same as <er>Rugosa</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetractinellid</ent><br/
<hw>Te*trac`ti*nel"lid</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Any species of sponge of the division Tetractinellida. Also used adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetractinellida</ent><br/
\'d8<hw>Te*trac`ti*nel"li*da</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., from Gr. <grk>te`tra-</grk> tetra- + <?/, <?/, ray, spoke.]</ety> <fld>(Zool.)</fld> <def>A division of Spongiae in which the spicules are siliceous and have four branches diverging at right angles. Called also <altname>Tetractinellinae</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrad</ent><br/
<hw>Tet"rad</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tetras</ets>, <ets>-adis</ets>, Gr. <?/, <?/: cf. F. <ets>t<eacute/trade</ets>.]</ety> <sn>1.</sn> <def>The number four; a collection of four things; a quaternion.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>A tetravalent or quadrivalent atom or radical; <as>as, carbon is a <ex>tetrad</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradactyle</ent><br/
<ent>Tetradactyl</ent><br/
<mhw>{ <hw>Tet`ra*dac"tyl</hw>, <hw>Tet`ra*dac"tyle</hw>  }</mhw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>t<eacute/tradactyle</ets>.]</ety> <fld>(Zool.)</fld> <def>Tetradactylous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradactylous</ent><br/
<hw>Tet`ra*dac"tyl*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ finger, toe.]</ety> <fld>(Zool.)</fld> <def>Having, or characterized by, four digits to the foot or hand.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradecane</ent><br/
<hw>Tet`ra*dec"ane</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + Gr. <?/ ten.]</ety> <fld>(Chem.)</fld> <def>A light oily hydrocarbon, <chform>C14H30</chform>, of the marsh-gas series; -- so called from the fourteen carbon atoms in the molecule.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradecapoda</ent><br/
\'d8<hw>Tet`ra*de*cap"o*da</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Tetra-</er>, and <er>Decapoda</er>.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Arthrostraca</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradic</ent><br/
<hw>Tet*rad"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of or pertaining to a tetrad; possessing or having the characteristics of a tetrad; <as>as, a carbon is a <ex>tetradic</ex> element</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradite</ent><br/
<hw>Tet"ra*dite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tetrad</er>.]</ety> <def>A person in some way remarkable with regard to the number four, as one born on the <xex>fourth</xex> day of the month, or one who reverenced <xex>four</xex> persons in the Godhead.</def>  <rj><au>Smart.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradon</ent><br/
<hw>Tet"ra*don</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Tetrodon</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradont</ent><br/
<hw>Tet"ra*dont</hw> <pr>(?)</pr>, <pos>a. & n.</pos> <fld>(Zool.)</fld> <def>See <er>Tetrodont</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradrachma</ent><br/
<ent>Tetradrachm</ent><br/
<mhw>{ <hw>Tet"ra*drachm</hw> <pr>(?)</pr>, \'d8<hw>Tet`ra*drach"ma</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[NL. <ets>tetradrachma</ets>, fr. Gr. <grk>tetra`drachmon</grk>; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <grk>drachmh`</grk> drachm, drachma.]</ety> <def>A silver coin among the ancient Greeks, of the value of four drachms.</def> <note>The Attic <ex>tetradrachm</ex> was equal to 3s. 3d. sterling, or about 76 cents.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradymite</ent><br/
<hw>Tet*rad"y*mite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>tetra`dymos</grk> fourfold. So named from its occurrence in compound twin crystals, or fourlings.]</ety> <fld>(Min.)</fld> <def>A telluride of bismuth. It is of a pale steel-gray color and metallic luster, and usually occurs in foliated masses. Called also <altname>telluric bismuth</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradynamia</ent><br/
\'d8<hw>Tet`ra*dy*na"mi*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ power.]</ety> <fld>(Bot.)</fld> <def>A Linnaean class of plants having six stamens, four of which are longer than the others.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradynamian</ent><br/
<hw>Tet`ra*dy*na"mi*an</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A plant of the order Tetradynamia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetradynamous</ent><br/
<ent>Tetradynamian</ent><br/
<mhw>{ <hw>Tet`ra*dy*na"mi*an</hw> <pr>(?)</pr>, <hw>Tet`ra*dyn"a*mous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <fld>(Bot.)</fld> <def>Belonging to the order Tetradynamia; having six stamens, four of which are uniformly longer than the others.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetragon</ent><br/
<hw>Tet"ra*gon</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tetragonum</ets>, Gr. <grk>tetra`gwnon</grk>; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <grk>gwni`a</grk> corner, angle: cf. F. <ets>t<eacute/tragone</ets>.]</ety> <sn>1.</sn> <fld>(Geom.)</fld> <def>A plane figure having four sides and angles; a quadrangle, as a square, a rhombus, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Astrol.)</fld> <def>An aspect of two planets with regard to the earth when they are distant from each other ninety degrees, or the fourth of a circle.</def>  <rj><au>Hutton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetragonal</ent><br/
<hw>Te*trag"o*nal</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <fld>(Geom.)</fld> <def>Of or pertaining to a tetragon; having four angles or sides; thus, the square, the parallelogram, the rhombus, and the trapezium are <xex>tetragonal</xex> fingers.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Having four prominent longitudinal angles.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Crystallog.)</fld> <def>Designating, or belonging to, a certain system of crystallization; dimetric. See <cref>Tetragonal system</cref>, under <er>Crystallization</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetragrammaton</ent><br/
\'d8<hw>Tet`ra*gram"ma*ton</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ a letter.]</ety> <def>The mystic number four, which was often symbolized to represent the Deity, whose name was expressed by four letters among some ancient nations; <as>as, the Hebrew <ex>JeHoVaH</ex>, Greek <grk>qeo`s</grk>, Latin <ex>deus</ex>, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetragynia</ent><br/
\'d8<hw>Tet`ra*gyn"i*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>te`tra-</grk> (see <er>Tetra-</er>) + <grk>gynh`</grk> a woman, female.]</ety> <fld>(Bot.)</fld> <def>A Linnaean order of plants having four styles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetragynous</ent><br/
<ent>Tetragynian</ent><br/
<mhw>{ <hw>Tet`ra*gyn"i*an</hw> <pr>(?)</pr>, <hw>Te*trag"y*nous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <fld>(Bot.)</fld> <def>Belonging to the order <ord>Tetragynia</ord>; having four styles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrahedral</ent><br/
<hw>Tet`ra*he"dral</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Tetrahedron</er>.]</ety> <sn>1.</sn> <def>Having, or composed of, four sides.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Crystallog.)</fld> <sd>(a)</sd> <def>Having the form of the regular tetrahedron.</def> <sd>(b)</sd> <def>Pertaining or related to a tetrahedron, or to the system of hemihedral forms to which the tetrahedron belongs.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tetrahedral angle</b></col> <fld>(Geom.)</fld>, <cd>a solid angle bounded or inclosed by four plane angles.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrahedrally</ent><br/
<hw>Tet`ra*he"dral*ly</hw>, <pos>adv.</pos> <def>In a tetrahedral manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrahedrite</ent><br/
<hw>Tet`ra*he"drite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So called because the crystals of the species are commonly <ets>tetrahedrons</ets>.]</ety> <fld>(Min.)</fld> <def>A sulphide of antimony and copper, with small quantities of other metals. It is a very common ore of copper, and some varieties yield a considerable presentage of silver. Called also <altname>gray copper ore</altname>, <altname>fahlore</altname>, and <altname>panabase</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrahedron</ent><br/
<hw>Tet`ra*he"dron</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + Gr. <?/ seat, base, fr. <?/ to sit.]</ety> <fld>(Geom.)</fld> <def>A solid figure inclosed or bounded by four triangles.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In crystallography, the regular tetrahedron is regarded as the hemihedral form of the regular octahedron.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Regular tetrahedron</b></col> <fld>(Geom.)</fld>, <cd>a solid bounded by four equal equilateral triangles; one of the five regular solids.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrahexahedral</ent><br/
<hw>Tet`ra*hex`a*he"dral</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Crystallog.)</fld> <def>Pertaining to a tetrahexahedron.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrahexahedron</ent><br/
<hw>Tet`ra*hex`a*he"dron</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + <ets>hexahedron</ets>.]</ety> <fld>(Crystallog.)</fld> <def>A solid in the isometric system, bounded by twenty-four equal triangular faces, four corresponding to each face of the cube.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>tetrahydrocannabinol</ent><br/
<hw>tet`ra*hy`dro*can*nab"i*nol</hw> <pr>(t<ecr/t`r<adot/*h<imac/`dr<osl/*k<acr/n*n<acr/b"<icr/n<add/l)</pr>, <pos>n.</pos> <fld>(Chem. & Med.)</fld> <def>A chemical substance (<chform>C21H20O2</chform>) which is produced by the hemp plant (Cannabis sativa), and is the physiologically active agent of dried preparations of that plant, called variously marijuana, hashish, ganja, hemp, etc.; also called <altname>THC</altname>.  It causes the euphoric effect for which the preparations are smoked or chewed.  It is used in medicine in a purified form as an antiemetic (an antinausea agent), especially in conjunction with chemotherapy of cancer.  It occurs primarily as the <DELTA/<sup>1</sup>-3,4-trans isomer, also called <altname><DELTA/<sup>9</sup>-THC</altname>, with small amounts of the <DELTA/<sup>6</sup>-3,4-trans isomer detectable at about 1%.  It is a controlled substance, classified as a hallucinogen, and its possession or distribution is illegal in almost all states of the United States.</def> <au>MI11</au><br/
[<source>PJC</source>]</p>

<p><ent>Tetrakishexahedron</ent><br/
<hw>Tet`ra*kis*hex`a*he"dron</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ four times + E. <ets>hexahedron</ets>.]</ety> <fld>(Crystallog.)</fld> <def>A tetrahexahedron.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrakosane</ent><br/
<hw>Tet"ra*ko*sane`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + Gr. <?/ twenty.]</ety> <fld>(Chem.)</fld> <def>A hydrocarbon, <chform>C24H50</chform>, resembling paraffin, and like it belonging to the marsh-gas series; -- so called from having <xex>twenty-four</xex> atoms of carbon in the molecule.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetralogy</ent><br/
<hw>Te*tral"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ a speech, discourse: cf. F. <ets>t<eacute/tralogie</ets>.]</ety> <fld>(Gr. Drama)</fld> <def>A group or series of four dramatic pieces, three tragedies and one satyric, or comic, piece (or sometimes four tragedies), represented consequently on the Attic stage at the Dionysiac festival.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A group or series of three tragedies, exhibited together without a fourth piese, was called a <xex>trilogy</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetramera</ent><br/
\'d8<hw>Te*tram"e*ra</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Tetramerous</er>.]</ety> <fld>(Zool.)</fld> <def>A division of Coleoptera having, apparently, only four tarsal joints, one joint being rudimentary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetramerous</ent><br/
<hw>Te*tram"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + Gr. <?/ part.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>Having the parts arranged in sets of four; <as>as, a <ex>tetramerous</ex> flower</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>Having four joints in each of the tarsi; -- said of certain insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrameter</ent><br/
<hw>Te*tram"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tetrametrus</ets>, Gr. <?/; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ a measure: cf. F. <ets>t<eacute/tram<egrave/tre</ets>.]</ety> <fld>(GR. & Latin Pros.)</fld> <def>A verse or line consisting of four measures, that is, in iambic, trochaic, and anapestic verse, of eight feet; in other kinds of verse, of four feet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetramethylene</ent><br/
<hw>Tet`ra*meth"yl*ene</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + <ets>methylene</ets>.]</ety> <fld>(Chem.)</fld> <sd>(a)</sd> <def>A hypothetical hydrocarbon, <chform>C4H8</chform>, analogous to trimethylene, and regarded as the base of well-known series or derivatives.</def> <sd>(b)</sd> <def>Sometimes, an isomeric radical used to designate certain compounds which are really related to butylene.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetramorph</ent><br/
<hw>Tet"ra*morph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + Gr. <grk>morfh`</grk> form, figure: cf. Gr. <?/ fourfold.]</ety> <fld>(Christian Art)</fld> <def>The union of the four attributes of the Evangelists in one figure, which is represented as winged, and standing on winged fiery wheels, the wings being covered with eyes. The representations of it are evidently suggested by the vision of Ezekiel (ch. i.)</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrandria</ent><br/
\'d8<hw>Te*tran"dri*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., from Gr. <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/, <?/, a man, male.]</ety> <fld>(Bot.)</fld> <def>A Linnaean class of plants having four stamens.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrandrous</ent><br/
<ent>Tetrandrian</ent><br/
<mhw>{ <hw>Te*tran"dri*an</hw> <pr>(?)</pr>, <hw>Te*tran"drous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <fld>(Bot.)</fld> <def>Belonging to the class Tetrandria.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1492 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraonid</ent><br/
<hw>Te*tra"o*nid</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tetrao</ets> a heath cock, grouse, Gr. <?/: cf. F. <ets>t<eacute/traonide</ets>.]</ety> <fld>(Zool.)</fld> <def>A bird belonging to the tribe of which the genus <gen>Tetrao</gen> is the type, as the grouse, partridge, quail, and the like. Used also adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrapetalous</ent><br/
<hw>Tet`ra*pet"al*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>petal</ets>.]</ety> <fld>(Bot.)</fld> <def>Containing four distinct petals, or flower leaves; <as>as, a <ex>tetrapetalous</ex> corolla</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrapharmacum</ent><br/
<ent>Tetrapharmacom</ent><br/
<mhw>{ <hw>Tet`ra*phar"ma*com</hw> <pr>(?)</pr>, <hw>Tet`ra*phar"ma*cum</hw> <pr>(?)</pr> }</mhw>, <pos>n.</pos> <ety>[NL. <ets>tetrapharmacon</ets>, L. <ets>tetrapharmacum</ets>, Gr. <?/; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ a drug.]</ety> <fld>(Med.)</fld> <def>A combination of wax, resin, lard, and pitch, composing an ointment.</def>  <rj><au>Brande & C.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraphenol</ent><br/
<hw>Tet`ra*phe"nol</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + <ets>phenol</ets>.]</ety> <fld>(Chem.)</fld> <def>Furfuran.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraphyllous</ent><br/
<hw>Te*traph"yl*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + Gr. <?/ a leaf.]</ety> <fld>(Bot.)</fld> <def>Having four leaves; consisting of four distinct leaves or leaflets.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrapla</ent><br/
\'d8<hw>Tet"ra*pla</hw> <pr>(?)</pr>, <pos>n.</pos>; <note>etymologically <pos>pl.</pos>, but syntactically <pos>sing.</pos></note> <ety>[NL., fr. Gr. <grk>tetraplo`os</grk>, <grk>tetraploy^s</grk>, fourfold.]</ety> <def>A Bible consisting of four different Greek versions arranged in four columns by <persfn>Origen</persfn>; hence, any version in four languages or four columns.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrapneumona</ent><br/
\'d8<hw>Tet`rap*neu"mo*na</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Tetra-</er>, and <er>Pneumo-</er>.]</ety> <fld>(Zool.)</fld> <def>A division of Arachnida including those spiders which have four lungs, or pulmonary sacs. It includes the bird spiders (<gen>Mygale</gen>) and the trapdoor spiders. See <er>Mygale</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrapnuemonian</ent><br/
<hw>Tet`rap*nue*mo"ni*an</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>One of the Tetrapneumona.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrapod</ent><br/
<hw>Tet"ra*pod</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ fourfooted; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/, <?/, foot.]</ety> <fld>(Zool.)</fld> <def>An insect characterized by having but four perfect legs, as certain of the butterflies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrapody</ent><br/
<hw>Te*trap"o*dy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/.]</ety> <def>A set of four feet; a measure or distance of four feet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrapteran</ent><br/
<hw>Te*trap"ter*an</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tetrapterous</er>.]</ety> <fld>(Zool.)</fld> <def>An insect having four wings.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrapterous</ent><br/
<hw>Te*trap"ter*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ wing.]</ety> <fld>(Zool.)</fld> <def>Having four wings.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraptote</ent><br/
<hw>Tet"rap*tote</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tetraptotum</ets>, Gr. <?/.]</ety> <fld>(Gram.)</fld> <def>A noun that has four cases only.</def>  <rj><au>Andrews.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrarch</ent><br/
<hw>Te"trarch</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tetrarches</ets>, Gr. <?/, <?/; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ a ruler, <?/ to lead; rule: cf. F. <ets>t<eacute/trarque</ets>. See <er>Arch</er>, <pos>a.</pos>]</ety> <fld>(Rom. Antiq.)</fld> <def>A Roman governor of the fourth part of a province; hence, any subordinate or dependent prince; also, a petty king or sovereign.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrarch</ent><br/
<hw>Te"trarch</hw>, <pos>a.</pos> <def>Four.</def> <mark>[Obs.]</mark>  <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrarchate</ent><br/
<hw>Te*trarch"ate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>t<eacute/trarchat</ets>.]</ety> <fld>(Rom. Antiq.)</fld> <def>A tetrarchy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrarchical</ent><br/
<hw>Te*trarch"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/.]</ety> <def>Of or pertaining to a tetrarch or tetrarchy.</def>  <rj><au>Bolingbroke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrarchy</ent><br/
<hw>Tet"rarch*y</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Tetrarchies</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>tetrarchia</ets>, Gr. <?/: cf. F. <ets>t<eacute/trarchie</ets>.]</ety> <fld>(Rom. Antiq.)</fld> <def>The district under a Roman tetrarch; the office or jurisdiction of a tetrarch; a tetrarchate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraschistic</ent><br/
<hw>Tet`ra*schis"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/ divided into four parts; <grk>te`tra-</grk> tetra- + <?/ to split.]</ety> <fld>(Biol.)</fld> <def>Characterized by division into four parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrasepalous</ent><br/
<hw>Tet`ra*sep"al*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>sepal</ets>.]</ety> <fld>(Bot.)</fld> <def>Having four sepals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraspaston</ent><br/
<hw>Tet`ra*spas"ton</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ to draw, pull.]</ety> <fld>(Mach.)</fld> <def>A machine in which four pulleys act together.</def>  <rj><au>Brande & C.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraspermous</ent><br/
<hw>Tet`ra*sper"mous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + Gr. <?/ a seed.]</ety> <fld>(Bot.)</fld> <def>Having four seeds.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tetraspermous plant</b></col>, <cd>a plant which produces four seeds in each flower.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraspore</ent><br/
<hw>Tet"ra*spore</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + <ets>spore</ets>.]</ety> <fld>(Bot.)</fld> <def>A nonsexual spore, one of a group of four regularly occurring in red seaweeds.</def> -- <wordforms><wf>Tet`ra*spor"ic</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrastich</ent><br/
<hw>Te*tras"tich</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tetrastichon</ets>, Gr. <?/; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ a row, verse.]</ety> <def>A stanza, epigram, or poem, consisting of four verses or lines.</def>  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrastyle</ent><br/
<hw>Tet"ra*style</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>tetrastylon</ets>, Gr. <?/ with four pillars in front; <grk>te`tra-</grk> (see <er>Tetra-</er>) + <?/ a column.]</ety> <fld>(Arch.)</fld> <def>Having four columns in front; -- said of a temple, portico, or colonnade.</def> -- <def2><pos>n.</pos> <def>A tetrastyle building.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrasyllabical</ent><br/
<ent>Tetrasyllabic</ent><br/
<mhw>{ <hw>Tet`ra*syl*lab"ic</hw> <pr>(?)</pr>, <hw>Tet`ra*syl*lab"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>t<eacute/trasyllabique</ets>.]</ety> <def>Consisting of, or having, four syllables; quadrisyllabic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrasyllable</ent><br/
<hw>Tet"ra*syl`la*ble</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + <ets>syllable</ets>: cf. Gr. <?/ of four syllables.]</ety> <def>A word consisting of four syllables; a quadrisyllable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrathecal</ent><br/
<hw>Tet`ra*the"cal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>thecal</ets>.]</ety> <fld>(Bot.)</fld> <def>Having four loculaments, or thecae.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrathionate</ent><br/
<hw>Tet`ra*thi"on*ate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of tetrathionic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrathionic</ent><br/
<hw>Tet`ra*thi*on"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>thionic</ets>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, a thionic derivative, <chform>H2S4O6</chform>, of sulphuric acid, obtained as a colorless, odorless liquid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetratomic</ent><br/
<hw>Tet`ra*tom"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>atomic</ets>.]</ety> <fld>(Chem.)</fld> <sd>(a)</sd> <def>Consisting of four atoms; having four atoms in the molecule, as phosphorus and arsenic.</def> <sd>(b)</sd> <def>Having a valence of four; quadrivalent; tetravalent; sometimes, in a specific sense, having four hydroxyl groups, whether acid or basic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetravalence</ent><br/
<hw>Te*trav"a*lence</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>The quality or state of being tetravalent; quadrivalence.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetravalent</ent><br/
<hw>Te*trav"a*lent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + L. <ets>valens</ets>, <ets>-entis</ets>, p. pr.]</ety> <fld>(Chem.)</fld> <def>Having a valence of four; tetratomic; quadrivalent.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetraxile</ent><br/
<hw>Te*trax"ile</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>axile</ets>.]</ety> <fld>(Zool.)</fld> <def>Having four branches diverging at right angles; -- said of certain spicules of sponges.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>-in</ent><br/
<ent>Tetrazine</ent><br/
<mhw>{ <hw>Tet*raz"ine</hw> <pr>(?)</pr>, <pos>n.</pos> Also <hw>-in</hw>  }</mhw>. <ety>[<ets>Tetrazo-</ets> + <ets>-ine</ets>.]</ety> <fld>(Chem.)</fld> <def>A hypothetical compound, <chform>C2H2N4</chform> which  may be regarded as benzene with four <chform>CH</chform> groups replaced by nitrogen atoms; also, any of various derivatives of the same. There are three isomeric varieties.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tetrazo-</ent><br/
<hw>Tet*raz"o-</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Tetra-</ets> + <ets>azo-</ets>.]</ety> <fld>(Chem.)</fld> <def>A combining form (also used adjectively), designating any one of a series of double derivatives of the azo and diazo compounds <xex>containing four atoms of nitrogen</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrazole</ent><br/
<hw>Tet*raz"ole</hw> <pr>(?)</pr>, <pos>n.</pos>  <ety>[<ets>Tetrazo-</ets> + <ets>-ole</ets>.]</ety> <fld>(Org. Chem.)</fld> <def>A crystalline acid substance, <chform>CH2N4</chform>, which may be regarded as pyrrol in which nitrogen atoms replace three <chform>CH</chform> groups; also, any of various derivatives of the same.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tetrazone</ent><br/
<hw>Tet"ra*zone</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>Any one of a certain series of basic compounds containing a chain of four nitrogen atoms; <as>for example, ethyl <ex>tetrazone</ex>, <chform>(C2H5)2N.N2.N(C2H5)2</chform>, a colorless liquid having an odor of leeks</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrical</ent><br/
<ent>Tetric</ent><br/
<mhw>{ <hw>Tet"ric</hw> <pr>(?)</pr>, <hw>Tet"ri*cal</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>tetricus</ets>, taetricus, from <ets>teter</ets>, <ets>taeter</ets>, offensive, foul.]</ety> <def>Forward; perverse; harsh; sour; rugged.</def> <mark>[Obs.]</mark> -- <wordforms><wf>Tet"ric*al*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetricity</ent><br/
<hw>Te*tric"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>tetricitas</ets>, <ets>taetricitas</ets>.]</ety> <def>Crabbedness; perverseness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetricous</ent><br/
<hw>Tet"ric*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Tetric.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrinic</ent><br/
<hw>Te*trin"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Tetra-</er>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, a complex ketonic acid, <chform>C5H6O3</chform>, obtained as a white crystalline substance; -- so called because once supposed to contain a peculiar radical of <xex>four</xex> carbon atoms. Called also <altname>acetyl-acrylic acid</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrodon</ent><br/
<hw>Tet"ro*don</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + Gr. <?/, <?/, tooth.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of plectognath fishes belonging to <gen>Tetrodon</gen> and allied genera. Each jaw is furnished with two large, thick, beaklike, bony teeth.</def> <altsp>[Written also <asp>tetradon</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The skin is usually spinous, and the belly is capable of being greatly distended by air or water. It includes the swellfish, puffer <sd>(a)</sd>, and similar species.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrodont</ent><br/
<hw>Tet"ro*dont</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Of or pertaining to the tetrodons.</def> -- <def2><pos>n.</pos> <def>A tetrodon.</def></def2> <altsp>[Written also <asp>tetradont</asp>, and <asp>tetraodont</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrol</ent><br/
<hw>Tet"rol</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetra-</ets> + benz<ets>ol</ets>.]</ety> <fld>(Chem.)</fld> <def>A hypothetical hydrocarbon, <chform>C4H4</chform>, analogous to benzene; -- so called from the <xex>four</xex> carbon atoms in the molecule.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Tetrol phenol</b></col>, <cd>furfuran.</cd> <mark>[Obs.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrolic</ent><br/
<hw>Tet*rol"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, an acid, <chform>C3H3.CO2H</chform>, of the acetylene series, homologous with propiolic acid, obtained as a white crystalline substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrose</ent><br/
<hw>Tet"rose</hw> <pr>(?)</pr>, <pos>n.</pos>  <ety>[<ets>Tetra-</ets> + <ets>-ose</ets>.]</ety> <fld>(Chem.)</fld> <def>A monosaccharide derived from a certain alcohol.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tetroxide</ent><br/
<hw>Tet*rox"ide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetr</ets>a- + <ets>oxide</ets>.]</ety> <fld>(Chem.)</fld> <def>An oxide having four atoms of oxygen in the molecule; a quadroxide; <as>as, osmium <ex>tetroxide</ex>, <chform>OsO4</chform></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetryl</ent><br/
<hw>Tet"ryl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetr</ets>a- + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>Butyl; -- so called from the <xex>four</xex> carbon atoms in the molecule.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetrylene</ent><br/
<hw>Tet"ryl*ene</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Tetr</ets>a- + eth<ets>ylene</ets>.]</ety> <fld>(Chem.)</fld> <def>Butylene; -- so called from the <xex>four</xex> carbon atoms in the molecule.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetter</ent><br/
<hw>Tet"ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>teter</ets>, AS. <ets>teter</ets>, <ets>tetr</ets>; akin to G. <ets>zitter</ets>, <ets>zitter</ets>mal, OHG. <ets>zittar</ets>och, Skr. <ets>dadru</ets>, <ets>dadruka</ets>, a sort of skin disease. <root/63, 240.]</ety> <fld>(Med.)</fld> <def>A vesicular disease of the skin; herpes. See <er>Herpes</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Honeycomb tetter</b></col> <fld>(Med.)</fld>, <cd>favus.</cd> -- <col><b>Moist tetter</b></col> <fld>(Med.)</fld>, <cd>eczema.</cd> -- <col><b>Scaly tetter</b></col> <fld>(Med.)</fld>, <cd>psoriasis.</cd> -- <col><b>Tetter berry</b></col> <fld>(Bot.)</fld>, <cd>the white bryony.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetter</ent><br/
<hw>Tet"ter</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tettered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tettering</conjf>.]</vmorph> <def>To affect with tetter.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetterous</ent><br/
<hw>Tet"ter*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having the character of, or pertaining to, tetter.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetter-totter</ent><br/
<hw>Tet"ter-tot`ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Teeter</er>.]</ety> <def>A certain game of children; seesaw; -- called also <altname>titter-totter</altname>, and <altname>titter-cum-totter</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetterwort</ent><br/
<hw>Tet"ter*wort`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A plant used as a remedy for tetter, -- in England the calendine, in America the bloodroot.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tettigonian</ent><br/
<hw>Tet`ti*go"ni*an</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/, dim. of <?/ a kind of grasshopper.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of Hemiptera belonging to <gen>Tettigonia</gen> and allied genera; a leaf hopper.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tettish</ent><br/
<hw>Tet"tish</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. <er>Testy</er>.]</ety> <def>Captious; testy.</def> <altsp>[Written also <asp>teatish</asp>.]</altsp> <mark>[Obs.]</mark>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tettix</ent><br/
\'d8<hw>Tet"tix</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ a kind of grasshopper.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>The cicada.</def> <mark>[Obs. or R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A genus of small grasshoppers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tetty</ent><br/
<hw>Tet"ty</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Testy; irritable.</def> <mark>[Obs.]</mark>  <rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teufit</ent><br/
<hw>Teu"fit</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The lapwing; -- called also <altname>teuchit</altname>.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teuk</ent><br/
<hw>Teuk</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The redshank.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teuton</ent><br/
<hw>Teu"ton</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E. <plw>Teutons</plw> <pr>(#)</pr>, L. <plw>Teutones</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>Teutones</ets>, <ets>Teutoni</ets>, the name of a Germanic people, probably akin to E. <ets>Dutch</ets>.  Cf. <er>Dutch</er>.]</ety> <sn>1.</sn> <def>One of an ancient German tribe; later, a name applied to any member of the Germanic race in Europe; now used to designate a German, Dutchman, Scandinavian, etc., in distinction from a Celt or one of a Latin race.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A member of the Teutonic branch of the Indo-European, or Aryan, family.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teutonic</ent><br/
<hw>Teu*ton"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>Teutonicus</ets>, from <ets>Teutoni</ets>, or <ets>Teutones</ets>. See <er>Teuton</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to the Teutons, esp. the ancient Teutons; Germanic.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to any of the Teutonic languages, or the peoples who speak these languages.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Teutonic languages</b></col>, <cd>a group of languages forming a division of the Indo-European, or Aryan, family, and embracing the High German, Low German, Gothic, and Scandinavian dialects and languages.</cd> -- <col><b>Teutonic order</b></col>, <cd>a military religious order of knights, established toward the close of the twelfth century, in imitation of the Templars and Hospitalers, and composed chiefly of Teutons, or Germans. The order rapidly increased in numbers and strength till it became master of all Prussia, Livonia, and Pomerania. In its decay it was abolished by Napoleon; but it has been revived as an honorary order.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teutonic</ent><br/
<hw>Teu*ton"ic</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The language of the ancient Germans; the Teutonic languages, collectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teutonicism</ent><br/
<hw>Teu*ton"i*cism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A mode of speech peculiar to the Teutons; a Teutonic idiom, phrase, or expression; a Teutonic mode or custom; a Germanism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tew</ent><br/
<hw>Tew</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Tewed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Tewing</conjf>.]</vmorph> <ety>[OE. <ets>tewen</ets>, <ets>tawen</ets>. <root/64. See <er>Taw</er>, <pos>v.</pos>]</ety> <sn>1.</sn> <def>To prepare by beating or working, as leather or hemp; to taw.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, to beat; to scourge; also, to pull about; to maul; to tease; to vex.</def> <mark>[Obs. or Prov. Eng. & Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tew</ent><br/
<hw>Tew</hw>, <pos>v. i.</pos> <def>To work hard; to strive; to fuse.</def> <mark>[Local]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tew</ent><br/
<hw>Tew</hw>, <pos>v. t.</pos> <ety>[Cf. <er>Taw</er> to tow, <er>Tow</er>, <pos>v. t.</pos>]</ety> <def>To tow along, as a vessel.</def> <mark>[Obs.]</mark>  <rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tew</ent><br/
<hw>Tew</hw>, <pos>n.</pos> <def>A rope or chain for towing a boat; also, a cord; a string.</def> <mark>[Obs. or Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tewan</ent><br/
<hw>Te"wan</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Ethnol.)</fld> <def>A tribe of American Indians including many of the Pueblos of New Mexico and adjacent regions.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tewed</ent><br/
<hw>Tewed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Fatigued; worn with labor or hardship.</def> <mark>[Obs. or Local]</mark>  <rj><au>Mir. for Mag.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tewel</ent><br/
<hw>Tew"el</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>tuel</ets>, OF. <ets>tuiel</ets>, <ets>tuel</ets>, F. <ets>tuyau</ets>; of Teutonic origin; cf. Dan. <ets>tud</ets>, D. <ets>tuit</ets>, Prov. G. <ets>zaute</ets>.  Cf. <er>Tuy<egrave/re</er>.]</ety> <sn>1.</sn> <def>A pipe, funnel, or chimney, as for smoke.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The tuy<egrave/re of a furnace.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tewhit</ent><br/
<hw>Te"whit</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The lapwing; -- called also <altname>teewheep</altname>.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tewtaw</ent><br/
<hw>Tew"taw</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[See <er>Tew</er>, <pos>v. t.</pos>]</ety> <def>To beat; to break, as flax or hemp.</def> <mark>[Obs.]</mark>  <rj><au>Mortimer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Texas</ent><br/
<hw>Tex"as</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A structure on the hurricane deck of a steamer, containing the pilot house, officers' cabins, etc.</def> <mark>[Western U. S.]</mark>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Texas Leaguer</ent><br/
<hw>Tex"as Leagu"er</hw> <pr>(?)</pr>. <ety>[From the Texas (baseball) League.]</ety> <fld>(Baseball)</fld> <def>A short fly that falls too far out to be handled by an infielder and too close in to be caught by an outfielder; -- called also <altname>Texas league single</altname>.</def> <mark>[Cant]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Text</ent><br/
<hw>Text</hw> <pr>(t<ecr/kst)</pr>, <pos>n.</pos> <ety>[F. <ets>texte</ets>, L. <ets>textus</ets>, texture, structure, context, fr. <ets>texere</ets>, <ets>textum</ets>, to weave, construct, compose; cf. Gr. <grk>te`ktwn</grk> carpenter, Skr. <ets>taksh</ets> to cut, carve, make.  Cf. <er>Context</er>, <er>Mantle</er>, <pos>n.</pos>, <er>Pretext</er>, <er>Tissue</er>, <er>Toil</er> a snare.]</ety> <sn>1.</sn> <def>A discourse or composition on which a note or commentary is written; the original words of an author, in distinction from a paraphrase, annotation, or commentary.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(O. Eng. Law)</fld> <def>The four Gospels, by way of distinction or eminence.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A verse or passage of Scripture, especially one chosen as the subject of a sermon, or in proof of a doctrine.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>How oft, when Paul has served us with a <qex>text</qex>,<br/
Has Epictetus, Plato, Tully, preached!</q> <rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Hence, anything chosen as the subject of an argument, literary composition, or the like; topic; theme.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A style of writing in large characters; text-hand also, a kind of type used in printing; <as>as, German <ex>text</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>That part of a document (printed or electronic) comprising the words, especially the main body of expository words, in contrast to the illustrations, pictures, charts, tables, or other formatted material which contain graphic elements as a major component.</def><br/
[<source>PJC</source>]</p>

<p><sn>7.</sn>  <def>Any communication composed of words.</def><br/
[<source>PJC</source>]</p>

<p><sn>8.</sn>  <def>a textbook.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Text blindness</b></col>. <fld>(Physiol.)</fld> <cd>See <cref>Word blindness</cref>, under <er>Word</er>.</cd> -- <col><b>Text letter</b></col>, <cd>a large or capital letter.</cd> <mark>[Obs.]</mark> -- <col><b>Text pen</b></col>, <cd>a kind of metallic pen used in engrossing, or in writing text-hand.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Text</ent><br/
<hw>Text</hw>, <pos>v. t.</pos> <def>To write in large characters, as in text hand.</def> <mark>[Obs.]</mark>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Text-book</ent><br/
<hw>Text"-book`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A book with wide spaces between the lines, to give room for notes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A volume, as of some classical author, on which a teacher lectures or comments; hence, any manual of instruction; a schoolbook.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Text-hand</ent><br/
<ent>Text hand</ent><br/
<mhw><hw>Text hand</hw>, <hw>Text"-hand`</hw></mhw> <pr>(?)</pr>, <pos>n.</pos> <def>A large hand in writing; -- so called because it was the practice to write the text of a book in a large hand and the notes in a smaller hand.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textile</ent><br/
<hw>Tex"tile</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>textilis</ets>, fr. <ets>texere</ets> to weave: cf. F. <ets>textile</ets>. See <er>Text</er>.]</ety> <def>Pertaining to weaving or to woven fabrics; <as>as, <ex>textile</ex> arts</as>; woven, capable of being woven; formed by weaving; <as>as, <ex>textile</ex> fabrics</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Textile cone</b></col> <fld>(Zool.)</fld>, <cd>a beautiful cone shell (<spn>Conus textilis</spn>) in which the colors are arranged so that they resemble certain kinds of cloth.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textile</ent><br/
<hw>Tex"tile</hw>, <pos>n.</pos> <def>That which is, or may be, woven; a fabric made by weaving.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textman</ent><br/
<hw>Text"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Textmen</plw> <pr>(<?/)</pr>.</plu> <def>One ready in quoting texts.</def> <mark>[R.]</mark>  <rj><au>Bp. Sanderston.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textorial</ent><br/
<hw>Tex*to"ri*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>textorius</ets>, fr. <ets>textor</ets> a weaver, fr. <ets>texere</ets>, <ets>textum</ets>, to weave.]</ety> <def>Of or pertaining to weaving.</def>  <rj><au>T. Warton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textrine</ent><br/
<hw>Tex"trine</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>textrinus</ets>, for <ets>textorinus</ets>, fr. <ets>textor</ets> a weaver.]</ety> <def>Of or pertaining to weaving, textorial; <as>as, the <ex>textrine</ex> art</as>.</def>  <rj><au>Denham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textual</ent><br/
<hw>Tex"tu*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OE. <ets>textuel</ets>, F. <ets>textuel</ets>.]</ety> <sn>1.</sn> <def>Of, pertaining to, or contained in, the text; <as>as, <ex>textual</ex> criticism; a <ex>textual</ex> reading</as>.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Serving for, or depending on, texts.</def>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Familiar with texts or authorities so as to cite them accurately.</def> <ldquo/I am not <xex>textuel</xex>.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textualist</ent><br/
<hw>Tex"tu*al*ist</hw>, <pos>n.</pos> <def>A textman; a textuary.</def>  <rj><au>Lightfoot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textually</ent><br/
<hw>Tex"tu*al*ly</hw>, <pos>adv.</pos> <def>In a textual manner; in the text or body of a work; in accordance with the text.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textuarist</ent><br/
<hw>Tex"tu*a*rist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A textuary.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textuary</ent><br/
<hw>Tex"tu*a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>textuaire</ets>.]</ety> <sn>1.</sn> <def>Contained in the text; textual.</def>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Serving as a text; authoritative.</def>  <rj><au>Glanvill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textuary</ent><br/
<hw>Tex"tu*a*ry</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>textuaire</ets>.]</ety> <sn>1.</sn> <def>One who is well versed in the Scriptures; a textman.</def>  <rj><au>Bp. Bull.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who adheres strictly or rigidly to the text.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textuel</ent><br/
<hw>Tex"tu*el</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Textual.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textuist</ent><br/
<hw>Tex"tu*ist</hw>, <pos>n.</pos> <def>A textualist; a textman.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The crabbed <qex>textualists</qex> of his time.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textural</ent><br/
<hw>Tex"tur*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to texture.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Texture</ent><br/
<hw>Tex"ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>textura</ets>, fr. <ets>texere</ets>, <ets>textum</ets>, to weave: cf. F. <ets>texture</ets>. See <er>Text</er>.]</ety> <sn>1.</sn> <def>The act or art of weaving.</def> <mark>[R.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which woven; a woven fabric; a web.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Others, apart far in the grassy dale,<br/
Or roughening waste, their humble <qex>texture</qex> weave.</q> <rj><qau>Thomson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The disposition or connection of threads, filaments, or other slender bodies, interwoven; <as>as, the <ex>texture</ex> of cloth or of a spider's web</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The disposition of the several parts of any body in connection with each other, or the manner in which the constituent parts are united; structure; <as>as, the <ex>texture</ex> of earthy substances or minerals; the <ex>texture</ex> of a plant or a bone; the <ex>texture</ex> of paper; a loose or compact <ex>texture</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Biol.)</fld> <def>A tissue. See <er>Tissue</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1493 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Texture</ent><br/
<hw>Tex"ture</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Textured</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Texturing</conjf>.]</vmorph> <def>To form a texture of or with; to interweave.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Textury</ent><br/
<hw>Tex"tur*y</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The art or process of weaving; texture.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Teyne</ent><br/
<hw>Teyne</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Tain</er>.]</ety> <def>A thin plate of metal.</def> <mark>[Obs.]</mark> <ldquo/A <xex>teyne</xex> of silver.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Th</ent><br/
<hw>Th</hw>. <def>In Old English, the article <xex>the</xex>, when the following word began with a vowel, was often written with elision as if a part of the word. Thus in Chaucer, the forms <xex>thabsence</xex>, <xex>tharray</xex>, <xex>thegle</xex>, <xex>thend</xex>, <xex>thingot</xex>, etc., are found for <xex>the absence</xex>, <xex>the array</xex>, <xex>the eagle</xex>, <xex>the end</xex>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thacker</ent><br/
<ent>Thack</ent><br/
<mhw>{ <hw>Thack</hw> <pr>(?)</pr>, <hw>Thack"er</hw> <pr>(?)</pr> }</mhw>. <def>See <er>Thatch</er>, <er>Thatcher</er>.</def> <mark>[Obs. or Prov. Eng. & Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thai</ent><br/
<hw>Thai</hw> <pr>(t<imac/)</pr>, <pos>n.</pos> <def>The language of Thailand (Siam); it is a member of the Tai group of languages.</def><br/
[<source>PJC</source>]</p>

<p><ent>Thai</ent><br/
<hw>Thai</hw> <pr>(t<imac/)</pr>, <pos>a.</pos> <def>Of or pertaining to the Thai language, a member of the Tai group of languages.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to Thailand or its people.</def><br/
[<source>PJC</source>]</p>

<p><ent>Thak</ent><br/
<hw>Thak</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To thwack.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalamencephalon</ent><br/
\'d8<hw>Thal`a*men*ceph"a*lon</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Thalamus</er>, and <er>Encephalon</er>.]</ety> <fld>(Anat.)</fld> <def>The segment of the brain next in front of the midbrain, including the thalami, pineal gland, and pituitary body; the diencephalon; the interbrain.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalamic</ent><br/
<hw>Tha*lam"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <def>Of or pertaining to a thalamus or to thalami.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalamiflorous</ent><br/
<ent>Thalamifloral</ent><br/
<mhw>{ <hw>Thal`a*mi*flo"ral</hw> <pr>(?)</pr>, <hw>Thal`a*mi*flo"rous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[See <er>Thalamus</er>, and <er>Floral</er>.]</ety> <fld>(Bot.)</fld> <def>Bearing the stamens directly on the receptacle; -- said of a subclass of polypetalous dicotyledonous plants in the system of De Candolle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalamocoele</ent><br/
<hw>Thal"a*mo*coele`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Thalam</ets>ic + Gr. <grk>koi^los</grk> hollow.]</ety> <fld>(Anat.)</fld> <def>The cavity or ventricle of the thalamencephalon; the third ventricle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalamophora</ent><br/
\'d8<hw>Thal`a*moph"o*ra</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>qa`lamos</grk> chamber + <grk>fe`rein</grk> to bear.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Foraminifera</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalamus</ent><br/
\'d8<hw>Thal"a*mus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Thalami</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>thalamus</ets> chamber, Gr. <grk>qa`lamos</grk>.]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>A mass of nervous matter on either side of the third ventricle of the brain; -- called also <altname>optic thalamus</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <sd>(a)</sd> <def>Same as <er>Thallus</er>.</def> <sd>(b)</sd> <def>The receptacle of a flower; a torus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalassian</ent><br/
<hw>Tha*las"si*an</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From Gr. <grk>qa`lassa</grk> the sea.]</ety> <fld>(Zool.)</fld> <def>Any sea tortoise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalassic</ent><br/
<hw>Tha*las"sic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>qa`lassa</grk> the sea.]</ety> <fld>(Geol.)</fld> <def>Of or pertaining to the sea; -- sometimes applied to rocks formed from sediments deposited upon the sea bottom.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalassinian</ent><br/
<hw>Thal`as*sin"i*an</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Any species of <fam>Thalassinidae</fam>, a family of burrowing macrurous Crustacea, having a long and soft abdomen.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalassography</ent><br/
<hw>Thal`as*sog"ra*phy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>qa`lassa</grk> sea + <ets>-graphy</ets>.]</ety> <def>The study or science of the life of marine organisms.</def>  <rj><au>Agassiz.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>thaler</ent><br/
\'d8<hw>tha"ler</hw> <pr>(t<aum/"l<etil/r)</pr>, <pos>n.</pos> <ety>[G. See <er>Dollar</er>.]</ety> <def>A former German silver coin worth about three shillings sterling, or about 73 cents, around 1900.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Thalia</ent><br/
<hw>Tha*li"a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr. Gr. <grk>Qa`leia</grk>, originally, blooming, luxuriant, akin to <grk>qa`llein</grk> to be luxuriant.]</ety> <fld>(Class. Myth.)</fld> <sd>(a)</sd> <def>That one of the nine Muses who presided over comedy.</def> <sd>(b)</sd> <def>One of the three Graces.</def> <sd>(c)</sd> <def>One of the Nereids.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thaliacea</ent><br/
\'d8<hw>Tha`li*a"ce*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Thalia</er>.]</ety> <fld>(Zool.)</fld> <def>A division of Tunicata comprising the free-swimming species, such as Salpa and Doliolum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalian</ent><br/
<hw>Tha*li"an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to Thalia; hence, of or pertaining to comedy; comic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thallate</ent><br/
<hw>Thal"late</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of a hypothetical thallic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thallene</ent><br/
<hw>Thal"lene</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A hydrocarbon obtained from coal-tar residues, and remarkable for its intense yellowish green fluorescence.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thallic</ent><br/
<hw>Thal"lic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of or pertaining to thallium; derived from, or containing, thallium; specifically, designating those compounds in which the element has a higher valence as contrasted with the <contr>thallous</contr> compounds; <as>as, <ex>thallic</ex> oxide</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalline</ent><br/
<hw>Thal"line</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Bot.)</fld> <def>Consisting of a thallus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalline</ent><br/
<hw>Thal"line</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ a young shoot or branch.]</ety> <fld>(Chem.)</fld> <def>An artificial alkaloid of the quinoline series, obtained as a white crystalline substance, <chform>C10H13NO</chform>, whose salts are valuable as antipyretics; -- so called from the <xex>green</xex> color produced in its solution by certain oxidizing agents.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thallious</ent><br/
<hw>Thal"li*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>See <er>Thallous</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thallium</ent><br/
<hw>Thal"li*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ young or green shoot or branch, twig. So called from a characteristic bright <ets>green</ets> line in its spectrum.]</ety> <fld>(Chem.)</fld> <def>A rare metallic element of the aluminium group found in some minerals, as certain pyrites, and also in the lead-chamber deposit in the manufacture of sulphuric acid. It is isolated as a heavy, soft, bluish white metal, easily oxidized in moist air, but preserved by keeping under water. Symbol Tl. Atomic weight 203.7.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thallogen</ent><br/
<hw>Thal"lo*gen</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ young shoot or branch, frond + <ets>-gen</ets>.]</ety> <fld>(Bot.)</fld> <def>One of a large class or division of the vegetable kingdom, which includes those flowerless plants, such as fungi, algae, and lichens, that consist of a thallus only, composed of cellular tissue, or of a congeries of cells, or even of separate cells, and never show a distinction into root, stem, and leaf.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalloid</ent><br/
<hw>Thal"loid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Thallus</ets> + <ets>-oid</ets>.]</ety> <fld>(Bot.)</fld> <def>Resembling, or consisting of, thallus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thallophyta</ent><br/
\'d8<hw>Thal*loph"y*ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Thallophyte</er>.]</ety> <fld>(Bot.)</fld> <def>A phylum of plants of very diverse habit and structure, including the algae, fungi, and lichens. The simpler forms, as many blue-green algae, yeasts, etc., are unicellular and reproduce vegetatively or  by means of asexual spores; in the higher forms the plant body is a <xex>thallus</xex>, which may be filamentous or may consist of plates of cells; it is commonly undifferentiated into stem, leaves, and roots, and shows no distinct tissue systems; the fronds of many algae, however, are modified to serve many of the functions of the above-named organs. Both asexual and sexual reproduction, often of a complex type, occur in these forms. The Thallophyta exist almost exclusively as gametophytes, the sporophyte being absent or rudimentary. By those who do not separate the Myxophyta from the Tallophyta as a distinct phylum the latter is treated as the lowermost group in the vegetable kingdom.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Thallophyte</ent><br/
<hw>Thal"lo*phyte</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ young shoot + <ets>-phyte</ets>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>A plant belonging to the Thallophyta.</def> -- <wordforms><wf>Thal`lo*phyt"ic</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Same as <er>Thallogen</er>.</def><br/
[<source>1913 Webster</source>]<-- ##is this identical to thallophyte??
 --></p>

<p><ent>Thallous</ent><br/
<hw>Thal"lous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of or pertaining to thallium; derived from, or containing, thallium; specifically, designating those compounds in which the element has a lower valence as contrasted with the <contr>thallic</contr> compounds.</def> <altsp>[Written also <asp>thallious</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thallus</ent><br/
\'d8<hw>Thal"lus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Thalli</plw> <pr>(#)</pr>.</plu> <ety>[NL., fr. Gr. <?/ young shoot or branch, frond.]</ety> <fld>(Bot.)</fld> <def>A solid mass of cellular tissue, consisting of one or more layers, usually in the form of a flat stratum or expansion, but sometimes erect or pendulous, and elongated and branching, and forming the substance of the thallogens.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thalweg</ent><br/
\'d8<hw>Thal"weg`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G., fr. <ets>thal</ets> valley + <ets>weg</ets> way. See <er>Dale</er>; <er>Way</er>.]</ety> <fld>(Physiography)</fld> <sd>(a)</sd> <def>A line following the lowest part of a valley, whether under water or not.</def> <sd>(b)</sd> <def>The line of continuous maximum descent from any point on a land surface, or that cutting all contours and angles.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Tammuz</ent><br/
<ent>Thammuz</ent><br/
<mhw>{ <hw>Tham"muz</hw> <pr>(?)</pr>, <hw>Tam"muz</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[Heb. <ets>thamm<umac/z</ets>.]</ety> <sn>1.</sn> <def>A deity among the ancient Syrians, in honor of whom the Hebrew idolatresses held an annual lamentation. This deity has been conjectured to be the same with the Phoenician Adon, or Adonis.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The fourth month of the Jewish ecclesiastical year, -- supposed to correspond nearly with our month of July.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thamnophile</ent><br/
<hw>Tham"no*phile</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>qa`mnos</grk> a bush + <grk>fi`los</grk> loving.]</ety> <fld>(Zool.)</fld> <def>A bush shrike.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thamyn</ent><br/
\'d8<hw>Tha"myn</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>An Asiatic deer (<spn>Rucervus Eldi</spn>) resembling the swamp deer; -- called also <altname>Eld's deer</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Than</ent><br/
<hw>Than</hw> <pr>(<th/<acr/n)</pr>, <pos>conj.</pos> <ety>[OE. <ets>than</ets>, <ets>thon</ets>, <ets>then</ets>, <ets>thanne</ets>, <ets>thonne</ets>, <ets>thenne</ets>, than, then, AS. <ets><edh/anne</ets>, <ets><edh/onne</ets>, <ets><edh/aenne</ets>; akin to D. <ets>dan</ets>, OHG. <ets>danne</ets>, G. <ets>dann</ets> then, <ets>denn</ets> than, for, Goth. <ets><thorn/an</ets> then, and to E. <ets>the</ets>, <ets>there</ets>, <ets>that</ets>. See <er>That</er>, and cf. <er>Then</er>.]</ety> <def>A particle expressing comparison, used after certain adjectives and adverbs which express comparison or diversity, as <xex>more</xex>, <xex>better</xex>, <xex>other</xex>, <xex>otherwise</xex>, and the like. It is usually followed by the object compared in the nominative case. Sometimes, however, the object compared is placed in the objective case, and <xex>than</xex> is then considered by some grammarians as a preposition. Sometimes the object is expressed in a sentence, usually introduced by <xex>that</xex>; <as>as, I would rather suffer <ex>than</ex> that you should want</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Behold, a greater <qex>than</qex> Solomon is here.</q> <rj><qau>Matt. xii. 42.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Which when Beelzebub perceived, <qex>than</qex> whom,<br/
Satan except, none higher sat.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It's wiser being good <qex>than</qex> bad;<br/
It's safer being meek <qex>than</qex> fierce;<br/
It's fitter being sane <qex>than</qex> mad.</q> <rj><qau>R. Browning.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Than</ent><br/
<hw>Than</hw>, <pos>adv.</pos> <def>Then. See <er>Then</er>.</def> <mark>[Obs.]</mark>  <rj><au>Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Thanne</qex> longen folk to gon on pilgrimages.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thana</ent><br/
\'d8<hw>Tha"na</hw> <pr>(t<aum/"n<aum/)</pr>, <pos>n.</pos> <altname>[Written also <asp>tana</asp>, <asp>tanna</asp>.]</altname> <ety>[Hind. <ets>th<amac/n<amac/</ets>.]</ety> <def>A police station.</def> <mark>[India]</mark>  <rj><au>Kipling.</au></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Thanage</ent><br/
<hw>Than"age</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The district in which a thane anciently had jurisdiction; thanedom.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thanatoid</ent><br/
<hw>Than"a*toid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>qa`natos</grk> death + <ets>-oid</ets>.]</ety> <def>Deathlike; resembling death.</def>  <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thanatology</ent><br/
<hw>Than`a*tol"o*gy</hw> <pr>(th<acr/n`<adot/*t<ocr/l"<osl/*j<ycr/)</pr>, <pos>n.</pos> <ety>[Gr. <grk>qa`natos</grk> + <ets>-logy</ets>.]</ety> <def>A description, or the doctrine, of death.</def>  <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>thanatopsis</ent><br/
<hw>than`a*top"sis</hw> <pr>(th<acr/n`<adot/*t<ocr/p"s<icr/s)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>qa`natos</grk> death + <grk>'o`psis</grk> view.]</ety>  <def>A view of death; a meditation on the subject of death.</def>  <rj><au>Bryant.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thanatopsis</ent><br/
<hw>Than`a*top"sis</hw> <pr>(th<acr/n`<adot/*t<ocr/p"s<icr/s)</pr>, <pos>prop. n.</pos> <ety>[NL., fr. Gr. <grk>qa`natos</grk> death + <grk>'o`psis</grk> view.]</ety>  <def>The title of a poem by <person>William Cullen Bryant</person> (1794-1878), meditating on the subject of death.  One of Bryant's best-remembered poems, it was written in 1811 and was discovered and rushed to publication in 1817 (in the <it>North American Review</it>) by <persfn>Bryant's</persfn> father, originally without the poet's knowledge.  A revised version was published in 1821.  In this elegy <persfn>Bryant</persfn> reflects that death comes to all men, common and great, and that all eventually shall rest together in the "mighty sepulchre" of the earth.</def><br/
[<source>PJC</source>]</p>

<p><note>The text of the poem is as follows:<br/
<br/
To him who in the love of nature holds<br/
Communion with her visible forms, she speaks<br/
A various language; for his gayer hours<br/
She has a voice of gladness, and a smile<br/
And eloquence of beauty; and she glides<br/
Into his darker musings, with a mild<br/
And healing sympathy that steals away<br/
Their sharpness ere he is aware.  When thoughts<br/
Of the last bitter hour come like a blight<br/
Over thy spirit, and sad images<br/
Of the stern agony, and shroud, and pall,<br/
And breathless darkness, and the narrow house,<br/
Make thee to shudder, and grow sick at heart; --<br/
Go forth, under the open sky, and list<br/
To Nature's teachings, while from all around --<br/
Earth and her waters, and the depths of air --<br/
Comes a still voice.  Yet a few days, and thee<br/
The all-beholding sun shall see no more<br/
In all his course; nor yet in the cold ground,<br/
Where thy pale form was laid, with many tears,<br/
Nor in the embrace of ocean, shall exist<br/
Thy image.  Earth, that nourished thee, shall claim<br/
Thy growth, to be resolved to earth again,<br/
And, lost each human trace, surrendering up<br/
Thine individual being, shalt thou go <br/
To mix forever with the elements,<br/
To be a brother to the insensible rock<br/
And to the sluggish clod, which the rude swain<br/
Turns with his share, and treads upon.  The oak<br/
Shall send his roots abroad, and pierce thy mold.<br/
Yet not to thine eternal resting-place<br/
Shalt thou retire alone, nor couldst thou wish<br/
Couch more magnificent.  Thou shalt lie down<br/
With patriarchs of the infant world -- with kings,<br/
The powerful of the earth -- the wise, the good,<br/
Fair forms, and hoary seers of ages past,<br/
All in one mighty sepulchre.  -- The hills<br/
Rock-ribbed and ancient as the sun, -- the vales<br/
Stretching in pensive quietness between;<br/
The venerable woods -- rivers that move<br/
In majesty, and the complaining brooks<br/
That make the meadows green; and, poured round all,<br/
Old Ocean's gray and melancholy waste,--<br/
Are but the solemn decorations all<br/
Of the great tomb of man.  The golden sun,<br/
The planets, all the infinite host of heaven,<br/
Are shining on the sad abodes of death<br/
Through the still lapse of ages.  All that tread<br/
The globe are but a handful to the tribes<br/
That slumber in its bosom. -- Take the wings<br/
Of morning, pierce the Barcan wilderness,<br/
Or lose thyself in the continuous woods<br/
Where rolls the Oregon, and hears no sound,<br/
Save his own dashings -- yet the dead are there:<br/
And millions in those solitudes, since first<br/
The flight of years began, have laid them down<br/
In their last sleep -- the dead reign there alone.<br/
So shalt thou rest -- and what if thou withdraw<br/
In silence from the living, and no friend<br/
Take note of thy departure?  All that breathe<br/
Will share thy destiny.  The gay will laugh<br/
When thou art gone, the solemn brood of care<br/
Plod on, and each one as before will chase<br/
His favorite phantom; yet all these shall leave<br/
Their mirth and their employments, and shall come<br/
And make their bed with thee.  As the long train<br/
Of ages glides away, the sons of men--<br/
The youth in life's fresh spring, and he who goes<br/
In the full strength of years, matron and maid,<br/
The speechless babe, and the gray-headed man--<br/
Shall one by one be gathered to thy side,<br/
By those, who in their turn, shall follow them.<br/
So live, that when thy summons comes to join<br/
The innumerable caravan, which moves<br/
To that mysterious realm, where each shall take<br/
His chamber in the silent halls of death,<br/
Thou go not, like the quarry-slave at night,<br/
Scourged to his dungeon, but, sustained and soothed<br/
By an unfaltering trust, approach thy grave<br/
Like one who wraps the drapery of his couch<br/
About him, and lies down to pleasant dreams.<br/
</note><br/
[<source>PJC</source>]</p>

<p><ent>Thane</ent><br/
<hw>Thane</hw> <pr>(th<amac/n)</pr>, <pos>n.</pos> <ety>[OE. <ets>thein</ets>, <ets><thorn/ein</ets>, AS. <ets><thorn/egen</ets>, <ets><thorn/egn</ets>; akin to OHG. <ets>degan</ets> a follower, warrior, boy, MHG. <ets>degen</ets> a hero, G. <ets>degen</ets> hero, soldier, Icel. <ets><thorn/egn</ets> a thane, a freeman; probably akin to Gr. <grk>te`knon</grk> a child, <grk>ti`ktein</grk> to bear, beget, or perhaps to Goth. <ets><thorn/ius</ets> servant, AS. <ets><thorn/e<oacute/w</ets>, G. <ets>dienen</ets> to serve.]</ety> <def>A dignitary under the Anglo-Saxons and Danes in England.  Of these there were two orders, the king's thanes, who attended the kings in their courts and held lands immediately of them, and the ordinary thanes, who were lords of manors and who had particular jurisdiction within their limits.  After the Conquest, this title was disused, and <altname>baron</altname> took its place.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Among the ancient Scots, <ex>thane</ex> was a title of honor, which seems gradually to have declined in its significance.</note>  <rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>thanedom</ent><br/
<hw>thane"dom</hw> <pr>(th<amac/n"d<ucr/m)</pr>, <pos>n.</pos> <def>The property or jurisdiction of a thane; thanage.</def>  <rj><au>Sir W. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>thanehood</ent><br/
<hw>thane"hood</hw> <pr>(th<amac/n"h<oocr/d)</pr>, <pos>n.</pos> <def>The character or dignity of a thane; also, thanes, collectively.</def>  <rj><au>J. R. Green.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>thaneship</ent><br/
<hw>thane"ship</hw>, <pos>n.</pos> <def>The state or dignity of a thane; thanehood; also, the seignioralty of a thane.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>thank</ent><br/
<hw>thank</hw> <pr>(th<acr/<nsm/k)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>thanks</plw> <pr>(th<acr/<nsm/ks)</pr>.</plu> <ety>[AS. <ets><thorn/anc</ets>, <ets><thorn/onc</ets>, thanks, favor, thought; akin to OS. <ets>thank</ets> favor, pleasure, thanks, D. & G. <ets>dank</ets> thanks, Icel. <ets><thorn/<oum/kk</ets>, Dan. <ets>tak</ets>, Sw. <ets>tack</ets>, Goth. <ets><thorn/agks</ets> thanks; -- originally, a thought, a thinking. See <er>Think</er>.]</ety> <def>A expression of gratitude; an acknowledgment expressive of a sense of favor or kindness received; obligation, claim, or desert, or gratitude; -- now generally used in the plural.</def> <ldquo/This ceremonial <xex>thanks</xex>.<rdquo/  <rj><au>Massinger.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>If ye do good to them which do good to you, what <qex>thank</qex> have ye? for sinners also do even the same.</q> <rj><qau>Luke vi. 33.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>What great <qex>thank</qex>, then, if any man, reputed wise and constant, will neither do, nor permit others under his charge to do, that which he approves not, especially in matter of sin?</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Thanks</qex>, <qex>thanks</qex> to thee, most worthy friend,<br/
For the lesson thou hast taught.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>His thanks</b></col>, <col><b>Her thanks</b></col>, etc.</mcol>, <cd>of his or her own accord; with his or her good will; voluntary.</cd> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Full sooth is said that love ne lordship,<br/
Will not, <qex>his thanks</qex>, have no fellowship.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <col><b>In thank</b></col>, <cd>with thanks or thankfulness.</cd> <mark>[Obs.]</mark> -- <col><b>Thank offering</b></col>, <cd>an offering made as an expression of thanks.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thank</ent><br/
<hw>Thank</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Thanked</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Thanking</conjf>.]</vmorph> <ety>[AS. <ets><thorn/ancian</ets>. See <er>Thank</er>, <pos>n.</pos>]</ety> <def>To express gratitude to (anyone) for a favor; to make acknowledgments to (anyone) for kindness bestowed; -- used also ironically for <xex>blame</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><ldquo/Graunt mercy, lord, that <qex>thank</qex> I you,<rdquo/ quod she.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I <qex>thank</qex> thee for thine honest care.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Weigh the danger with the doubtful bliss,<br/
And <qex>thank</qex> yourself if aught should fall amiss.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thankful</ent><br/
<hw>Thank"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[AS. <ets><thorn/ancfull</ets>.]</ety> <sn>1.</sn> <def>Obtaining or deserving thanks; thankworthy.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Ladies, look here; this is the <qex>thankful</qex> glass<br/
That mends the looker's eyes; this is the well<br/
That washes what it shows.</q> <rj><qau>Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Impressed with a sense of kindness received, and ready to acknowledge it; grateful.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Be <qex>thankful</qex> unto him, and bless his name.</q> <rj><qau>Ps. c. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Thank"ful*ly</wf>, <pos>adv.</pos> -- <wf>Thank"ful*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thankless</ent><br/
<hw>Thank"less</hw>, <pos>a.</pos> <sn>1.</sn> <def>Not acknowledging favors; not expressing thankfulness; unthankful; ungrateful.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That she may feel<br/
How sharper than a serpent's tooth it is<br/
To have a <qex>thankless</qex> child!</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not obtaining or deserving thanks; unacceptable; <as>as, a <ex>thankless</ex> task</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To shepherd <qex>thankless</qex>, but by thieves that love the night allowed.</q> <rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Thank"less*ly</wf> <pr>(#)</pr>, <pos>adv.</pos> -- <wf>Thank"less*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thankly</ent><br/
<hw>Thank"ly</hw>, <pos>adv.</pos> <def>Thankfully.</def> <mark>[Obs.]</mark>  <rj><au>Sylvester (Du Bartas).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thanksgive</ent><br/
<hw>Thanks"give</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To give or dedicate in token of thanks.</def> <mark>[Obs. or R.]</mark>  <rj><au>Mede.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thanksgiver</ent><br/
<hw>Thanks"giv`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who gives thanks, or acknowledges a kindness.</def>  <rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thanksgiving</ent><br/
<hw>Thanks"giv`ing</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act of rending thanks, or expressing gratitude for favors or mercies.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Every creature of God is good, and nothing to be refused, if it be received with <qex>thanksgiving</qex>.</q> <rj><qau>1 Tim. iv. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In the <qex>thanksgiving</qex> before meat.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And taught by thee the Church prolongs<br/
Her hymns of high <qex>thanksgiving</qex> still.</q> <rj><qau>Keble.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A public acknowledgment or celebration of divine goodness; also, a day set apart for religious services, specially to acknowledge the goodness of God, either in any remarkable deliverance from calamities or danger, or in the ordinary dispensation of his bounties.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the United States it is now customary for the President by proclamation to appoint annually a day (usually the last Thursday in November) of thanksgiving and praise to God for the mercies of the past year. This is an extension of the custom long prevailing in several States in which an annual Thanksgiving day has been appointed by proclamation of the governor.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thankworthiness</ent><br/
<hw>Thank"wor`thi*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being thankworthy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thankworthy</ent><br/
<hw>Thank"wor`thy</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Deserving thanks; worthy of gratitude; mreitorious.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For this <qex>thankworthy</qex>, if a man, for conscience toward God, endure grief, suffering wrongfully.</q> <rj><qau>1 Pet. ii. 19.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thar</ent><br/
<hw>Thar</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A goatlike animal (<spn>Capra Jemlaica</spn>) native of the Himalayas. It has small, flattened horns, curved directly backward. The hair of the neck, shoulders, and chest of the male is very long, reaching to the knees. Called also <altname>serow</altname>, and <altname>imo</altname>.</def> <altsp>[Written also <asp>thaar</asp>, and <asp>tahr</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thar</ent><br/
<hw>Thar</hw>, <pos>v. impersonal, pres.</pos> <ety>[OE. <ets>thar</ets>, <ets><thorn/arf</ets>, AS. <ets><thorn/earf</ets>, infin. <ets><thorn/urfan</ets> to need; akin to OHG. <ets>durfan</ets>, G. <ets>d<uum/rfen</ets> to be allowed, Icel. <ets><thorn/urfa</ets> to need, Goth. <ets><thorn/a<uacute/rban</ets>.]</ety> <def>It needs; need.</def> <mark>[Obs.]</mark>  <rj><au>Piers Plowman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>What <qex>thar</qex> thee reck or care?</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tharms</ent><br/
<hw>Tharms</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[AS. <ets><thorn/earm</ets> a gut; akin to D. & G. <ets>darm</ets>, Icel. <ets><thorn/armr</ets>, Sw. & Dan. <ets>tarm</ets>. <root/53.]</ety> <def>Twisted guts.</def> <mark>[Obs. or Prov. Eng.]</mark>  <rj><au>Ascham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Tharos</ent><br/
<hw>Tha"ros</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A small American butterfly (<spn>Phycoides tharos</spn>) having the upper surface of the wings variegated with orange and black, the outer margins black with small white crescents; -- called also <altname>pearl crescent</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>That</ent><br/
<hw>That</hw> <pr>(?)</pr>, <pos>pron., a., conj., & adv.</pos> <ety>[AS. <ets><edh/aet</ets>, neuter nom. & acc. sing. of the article (originally a demonstrative pronoun). The nom. masc. <ets>s<emac/</ets>, and the nom. fem. <ets>se<oacute/</ets> are from a different root. AS. <ets><edh/aet</ets> is akin to D. <ets>dat</ets>, G. <ets>das</ets>, OHG. <ets>daz</ets>, Sw. & Dan. <ets>det</ets>, Icel. <ets><thorn/at</ets> (masc. <ets>s<amac/</ets>, fem. <ets>s<omac/</ets>), Goth. <ets><thorn/ata</ets> (masc. <ets>sa</ets>, fem. <ets>s<omac/</ets>), Gr. <?/ (masc. <?/, fem. <?/), Skr. <ets>tat</ets> (for <ets>tad</ets>, masc. <ets>sas</ets>, fem. <ets>s<amac/</ets>); cf. L. is<ets>tud</ets> that. <root/184.  Cf. <er>The</er>, <er>Their</er>, <er>They</er>, <er>Them</er>, <er>This</er>, <er>Than</er>, <er>Since</er>.]</ety> <sn>1.</sn> <def>As a demonstrative pronoun (<pluf>pl.</pluf> <er>Those</er>), <xex>that</xex> usually points out, or refers to, a person or thing previously mentioned, or supposed to be understood. <xex>That</xex>, as a demonstrative, may precede the noun to which it refers; <as>as, <ex>that</ex> which he has said is true; <ex>those</ex> in the basket are good apples.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The early fame of Gratian was equal to <qex>that</qex> of the most celebrated princes.</q> <rj><qau>Gibbon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>That</xex> may refer to an entire sentence or paragraph, and not merely to a word. It usually follows, but sometimes precedes, the sentence referred to.</note><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>That</qex> be far from thee, to do after this manner, to slay the righteous with the wicked.</q> <rj><qau>Gen. xviii. 25.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And when Moses heard <qex>that</qex>, he was content.</q> <rj><qau>Lev. x. 20.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I will know your business, Harry, <qex>that</qex> I will.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>That</xex> is often used in opposition to <xex>this</xex>, or by way of distinction, and in such cases <xex>this</xex>, like the Latin <xex>hic</xex> and French <xex>ceci</xex>, generally refers to that which is nearer, and <xex>that</xex>, like Latin <xex>ille</xex> and French <xex>cela</xex>, to that which is more remote. When they refer to foreign words or phrases, <xex>this</xex> generally refers to the latter, and <xex>that</xex> to the former.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Two principles in human nature reign;<br/
Self-love, to urge, and Reason, to restrain;<br/
Nor <qex>this</qex> a good, nor <qex>that</qex> a bad we call.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>If the Lord will, we shall live, and do <qex>this</qex> or <qex>that</qex>.</q> <rj><qau>James iv. 16.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>As an adjective, <xex>that</xex> has the same demonstrative force as the pronoun, but is followed by a noun.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It shall be more tolerable for Sodom and Gomorrah in the day of judgment, than for <qex>that</qex> city.</q> <rj><qau>Matt. x. 15.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The woman was made whole from <qex>that</qex> hour.</q> <rj><qau>Matt. ix. 22.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>That</xex> was formerly sometimes used with the force of the article <xex>the</xex>, especially in the phrases <xex>that one</xex>, <xex>that other</xex>, which were subsequently corrupted into <xex>th'tone</xex>, <xex>th'tother</xex> (now written <xex>t'other</xex>).</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Upon a day out riden knightes two . . . <br/
<qex>That one</qex> of them came home, <qex>that other</qex> not.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>As a relative pronoun, <xex>that</xex> is equivalent to <xex>who</xex> or <xex>which</xex>, serving to point out, and make definite, a person or thing spoken of, or alluded to, before, and may be either singular or plural.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>that</qex> reproveth a scorner getteth to himself shame.</q> <rj><qau>Prov. ix. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A judgment <qex>that</qex> is equal and impartial must incline to the greater probabilities.</q> <rj><qau>Bp. Wilkins.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1494 --><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ If the relative clause simply conveys an additional idea, and is not properly explanatory or restrictive, <xex>who</xex> or <xex>which</xex> (rarely <xex>that</xex>) is employed; as, the king <xex>that</xex> (or <xex>who</xex>) rules well is generally popular; Victoria, <xex>who</xex> (not <xex>that</xex>) rules well, enjoys the confidence of her subjects. Ambiguity may in some cases be avoided in the use of <xex>that</xex> (which is restrictive) instead of <xex>who</xex> or <xex>which</xex>, likely to be understood in a coordinating sense. <au>Bain.</au><br/
[<source>1913 Webster</source>]</p>

<p><xex>That</xex> was formerly used for <xex>that which</xex>, as <xex>what</xex> is now; but such use is now archaic.<br/
[<source>1913 Webster</source>]</p>

<p><q>We speak <qex>that</qex> we do know, and testify <qex>that</qex> we have seen.</q> <rj><qau>John iii. 11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>That</qex> I have done it is thyself to wite [blame].</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><xex>That</xex>, as a relative pronoun, cannot be governed by a preposition preceding it, but may be governed by one at the end of the sentence which it commences.<br/
[<source>1913 Webster</source>]</p>

<p><q>The ship <qex>that</qex> somebody was sailing in.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>In Old English, <xex>that</xex> was often used with the demonstratives <xex>he</xex>, <xex>his</xex>, <xex>him</xex>, etc., and the two together had the force of a relative pronoun; thus, <xex>that he</xex> = who; <xex>that his</xex> = whose; <xex>that him</xex> = whom.<br/
[<source>1913 Webster</source>]</p>

<p><q>I saw to-day a corpse yborn to church<br/
<qex>That</qex> now on Monday last I saw <qex>him</qex> wirche [work].</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>Formerly, <xex>that</xex> was used, where we now commonly use <xex>which</xex>, as a relative pronoun with the demonstrative pronoun <xex>that</xex> as its antecedent.<br/
[<source>1913 Webster</source>]</p>

<p><q>That <qex>that</qex> dieth, let it die; and that <qex>that</qex> is to cut off, let it be cut off.</q> <rj><qau>Zech. xi. 9.</qau></rj>
</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>As a conjunction, <xex>that</xex> retains much of its force as a demonstrative pronoun.</def> It is used, specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>To introduce a clause employed as the object of the preceding verb, or as the subject or predicate nominative of a verb.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She tells them 't is a causeless fantasy,<br/
And childish error, <qex>that</qex> they are afraid.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I have shewed before, <qex>that</qex> a mere possibility to the contrary, can by no means hinder a thing from being highly credible.</q> <rj><qau>Bp. Wilkins.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>To introduce, a reason or cause; -- equivalent to <xex>for that</xex>, <xex>in that</xex>, <xex>for the reason that</xex>, <xex>because</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He does hear me;<br/
And <qex>that</qex> he does, I weep.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>To introduce a purpose; -- usually followed by <xex>may</xex>, or <xex>might</xex>, and frequently preceded by <xex>so</xex>, <xex>in order</xex>, <xex>to the end</xex>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>These things I say, <qex>that</qex> ye might be saved.</q> <rj><qau>John v. 34.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To the end <qex>that</qex> he may prolong his days.</q> <rj><qau>Deut. xvii. 20.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>To introduce a consequence, result, or effect; -- usually preceded by <xex>so</xex> or <xex>such</xex>, sometimes by <xex>that</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The birds their notes renew, and bleating herds<br/
Attest their joy, <qex>that</qex> hill and valley rings.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He gazed so long<br/
<qex>That</qex> both his eyes were dazzled.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(e)</sd> To introduce a clause denoting time; -- equivalent to <xex>in which time</xex>, <xex>at which time</xex>, <xex>when</xex>.<br/
[<source>1913 Webster</source>]</p>

<p><q>So wept Duessa until eventide,<br/
<qex>That</qex> shining lamps in Jove's high course were lit.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Is not this the day<br/
<qex>That</qex> Hermia should give answer of her choice?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(f)</sd> <def>In an elliptical sentence to introduce a dependent sentence expressing a wish, or a cause of surprise, indignation, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ha, cousin Silence, <qex>that</qex> thou hadst seen that that this knight and I have seen!</q> <rj><qau>Shak.</qau></rj>
<-- = if only . . . = if --><br/
[<source>1913 Webster</source>]</p>

<p><q>O God, <qex>that</qex> right should thus overcome might!</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>That</xex> was formerly added to other conjunctions or to adverbs to make them emphatic.<br/
[<source>1913 Webster</source>]</p>

<p><q>To try if <qex>that</qex> our own be ours or no.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><xex>That</xex> is sometimes used to connect a clause with a preceding conjunction on which it depends.<br/
[<source>1913 Webster</source>]</p>

<p><q>When he had carried Rome and <qex>that</qex> we looked<br/
For no less spoil than glory.</q> <rj><qau>Shak.</qau></rj>
</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>As adverb: To such a degree; so; <as>as, he was <ex>that</ex> frightened he could say nothing</as>.</def> <mark>[Archaic or in illiteral use.]</mark><-- = so --><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>All that</b></col>, <cd>everything of that kind; all that sort.</cd><br/
[<source>1913 Webster</source>]</p>

<p><q>With singing, laughing, ogling, and <qex>all that</qex>.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The rank is but the guinea's stamp,<br/
The man's the gowd [gold] for <qex>a'that</qex>.</q> <rj><qau>Burns.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <col><b>For that</b></col>. <cd>See under <er>For</er>, <pos>prep.</pos></cd> -- <col><b>In that</b></col>. <cd>See under <er>In</er>, <pos>prep.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thatch</ent><br/
<hw>Thatch</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>thak</ets>, AS. <ets><thorn/<ae/c</ets> a roof; akin to <ets><thorn/eccean</ets> to cover, D. <ets>dak</ets> a roof, <ets>dekken</ets> to cover, G. <ets>dach</ets> a roof, <ets>decken</ets> 8cover, Icel. <ets><thorn/ak</ets> a roof, Sw. <ets>tak</ets>, Dan. <ets>tag</ets>, Lith. <ets>st<omac/gas</ets>, Ir. <ets>teagh</ets> a house, Gael. <ets>teach</ets>, <ets>tigh</ets>, W. <ets>ty</ets>, L. <ets>tegere</ets> to cover, <ets>toga</ets> a toga, Gr. <?/, <?/, a roof, <?/ to cover, Skr. <ets>sthag</ets>.  Cf. <er>Deck</er>, <er>Integument</er>, <er>Tile</er>, <er>Toga</er>.]</ety> <sn>1.</sn> <def>Straw, rushes, or the like, used for making or covering the roofs of buildings, or of stacks of hay or grain.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>A name in the West Indies for several kinds of palm, the leaves of which are used for thatching.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Thatch sparrow</b></col>, <cd>the house sparrow.</cd> <mark>[Prov. Eng.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thatch</ent><br/
<hw>Thatch</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Thatched</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Thatching</conjf>.]</vmorph> <ety>[From <er>Thatch</er>, <pos>n.</pos>: cf. OE. <ets>thecchen</ets>, AS. <ets><?/eccean</ets> to cover.]</ety> <def>To cover with, or with a roof of, straw, reeds, or some similar substance; <as>as, to <ex>thatch</ex> a roof, a stable, or a stack of grain</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thatcher</ent><br/
<hw>Thatch"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who thatches.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thatching</ent><br/
<hw>Thatch"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act or art of covering buildings with thatch; so as to keep out rain, snow, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The materials used for this purpose; thatch.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thaught</ent><br/
<hw>Thaught</hw> <pr>(th<add/t)</pr>, <pos>n.</pos> <fld>(Naut.)</fld> <def>See <er>Thwart</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thaumatolatry</ent><br/
<hw>Thau`ma*tol"a*try</hw> <pr>(th<add/`m<adot/*t<ocr/l"<adot/*tr<ycr/)</pr>, <pos>n.</pos> <ety>[Gr. <grk>qay^ma</grk>, <grk>qay`matos</grk>, a wonder + <grk>latrei`a</grk> worship.]</ety> <def>Worship or undue admiration of wonderful or miraculous things.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>thaumatolatry</qex> by which our theology has been debased for more than a century.</q> <rj><qau>Hare.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thaumatrope</ent><br/
<hw>Thau"ma*trope</hw> <pr>(th<add/"m<adot/*tr<omac/p)</pr>, <pos>n.</pos> <ety>[Gr. <grk>qay^ma</grk> a wonder + <grk>tre`pein</grk> to turn.]</ety> <fld>(Opt.)</fld> <def>An optical instrument or toy for showing the persistence of an impression upon the eyes after the luminous object is withdrawn.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It consists of a card having on its opposite faces figures of two different objects, or halves of the same object, as a bird and a cage, which, when the card is whirled rapidly round a diameter by the strings that hold it, appear to the eye combined in a single picture, as of a bird in its cage.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>thaumaturge</ent><br/
<hw>thau"ma*turge</hw> <pr>(th<add/"m<adot/*t<ucir/rj)</pr>, <pos>n.</pos> <ety>[See <er>thaumaturgus</er>.]</ety> <def>A magician; a wonder worker.</def>  <rj><au>Lowell.</au></rj><br/
<syn><b>Syn. --</b> thaumaturgist.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>thaumaturgical</ent><br/
<ent>thaumaturgic</ent><br/
<mhw>{ <hw>thau`ma*tur"gic</hw> <pr>(th<add/`m<adot/*t<ucir/r"j<icr/k)</pr>, <hw>thau`ma*tur"gic*al</hw> <pr>(th<add/`m<adot/*t<ucir/r"j<icr/*k<ait/l)</pr>, }</mhw> <pos>a.</pos> <def>Of or pertaining to thaumaturgy; magical; wonderful.</def>  <rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>thaumaturgics</ent><br/
<hw>thau`ma*tur"gics</hw> <pr>(th<add/`m<adot/*t<ucir/r"j<icr/ks)</pr>, <pos>n.</pos> <def>Feats of legerdemain, or magical performances.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>thaumaturgist</ent><br/
<hw>thau`ma*tur"gist</hw> <pr>(th<add/`m<adot/*t<ucir/r"j<icr/st)</pr>, <pos>n.</pos> <def>One who deals in wonders, or believes in them; a wonder worker; a thaumaturge.</def>  <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>thaumaturgus</ent><br/
\'d8<hw>thau`ma*tur"gus</hw> <pr>(th<add/`m<adot/*t<ucir/r"g<ucr/s)</pr>, <pos>n.</pos> <ety>[NL., from Gr. <grk>qaymatourgo`s</grk> wonder-working; <grk>qay^ma</grk> a wonder + <grk>'e`rgon</grk> work.]</ety> <def>A miracle worker; -- a title given by the Roman Catholics to some saints.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>thaumaturgy</ent><br/
<hw>thau"ma*tur`gy</hw> <pr>(th<add/`m<adot/*t<ucir/r"j<ycr/)</pr>, <pos>n.</pos> <ety>[Gr. <grk>qaymatourgi`a</grk>.]</ety> <def>The act or art of performing something wonderful; magic; legerdemain.</def>  <rj><au>T. Warton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>thave</ent><br/
<hw>thave</hw> <pr>(th<amac/v)</pr>, <pos>n.</pos> <def>Same as <er>theave</er>.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>thaw</ent><br/
<hw>thaw</hw> <pr>(th<add/)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Thawed</conjf> <pr>(th<add/d)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Thawing</conjf>.]</vmorph> <ety>[AS. <ets><thorn/<amac/wian</ets>, <ets><thorn/<amac/wan</ets>; akin to D. <ets>dovijen</ets>, G. <ets>tauen</ets>, <ets>thauen</ets> (cf. also ver<ets>dauen</ets> to digest, OHG. <ets>douwen</ets>, fir<ets>douwen</ets>), Icel. <ets><thorn/eyja</ets>, Sw. <ets>t<oum/a</ets>, Dan. <ets>t<oum/e</ets>, and perhaps to Gr. <grk>th`kein</grk> to melt. <root/56.]</ety> <sn>1.</sn> <def>To melt, dissolve, or become fluid; to soften; -- said of that which is frozen; <as>as, the ice <ex>thaws</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To become so warm as to melt ice and snow; -- said in reference to the weather, and used impersonally.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <specif>Fig.:</specif> <def>To grow gentle or genial.  Compare <er>cold</er>{4}, <pos>a.</pos> and <er>hard</er>{6}, <pos>a.</pos></def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>thaw</ent><br/
<hw>thaw</hw>, <pos>v. t.</pos> <def>To cause (frozen things, as earth, snow, ice) to melt, soften, or dissolve.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>thaw</ent><br/
<hw>thaw</hw>, <pos>n.</pos> <def>The melting of ice, snow, or other congealed matter; the resolution of ice, or the like, into the state of a fluid; liquefaction by heat of anything congealed by frost; also, a warmth of weather sufficient to melt that which is congealed.</def>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>thawy</ent><br/
<hw>thaw"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Liquefying by heat after having been frozen; thawing; melting.</def> <mark>[archaic]</mark><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>The</ent><br/
<hw>The</hw> <pr>(<th/<emac/)</pr>, <pos>v. i.</pos> <def>See <er>Thee</er>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au>  <au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>The</ent><br/
<hw>The</hw> <pr>(<th/<emac/, <it>when emphatic or alone</it>; <th/<esl/, <it>obscure before a vowel</it>; <th/<eit/, <it>obscure before a consonant</it>; 37)</pr>, <pos>definite article.</pos> <ety>[AS. <ets><edh/<emac/</ets>, a later form for earlier nom. sing. masc. <ets>s<emac/</ets>, formed under the influence of the oblique cases.  See <er>That</er>, pron.]</ety> <def>A word placed before nouns to limit or individualize their meaning.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ex>The</ex> was originally a demonstrative pronoun, being a weakened form of <ex>that</ex>.  When placed before adjectives and participles, it converts them into abstract nouns; as, <ex>the</ex> sublime and <ex>the</ex> beautiful. <au>Burke.</au>  <ex>The</ex> is used regularly before many proper names, as of rivers, oceans, ships, etc.; as, <ex>the</ex> Nile, <ex>the</ex> Atlantic, <ex>the</ex> Great Eastern, <ex>the</ex> West Indies, <ex>The</ex> Hague.  <ex>The</ex> with an epithet or ordinal number often follows a proper name; as, Alexander <ex>the</ex> Great; Napoleon <ex>the</ex> Third.  <ex>The</ex> may be employed to individualize a particular kind or species; as, <ex>the</ex> grasshopper shall be a burden. <au>Eccl. xii. 5.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><ent>The</ent><br/
<hw>The</hw>, <pos>adv.</pos> <ety>[AS. <ets><edh/<emac/</ets>, <ets><edh/<ymac/</ets>, instrumental case of <ets>s<emac/</ets>, <ets>se<oacute/</ets>, <ets><edh/<ae/t</ets>, the definite article.  See 2d <er>The</er>.]</ety> <def>By that; by how much; by so much; on that account; -- used before comparatives; <as>as, <ex>the</ex> longer we continue in sin, <ex>the</ex> more difficult it is to reform</as>.</def> <ldquo/Yet not <xex>the</xex> more cease I.<rdquo/  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>So much <qex>the</qex> rather thou, Celestial Light,<br/
Shine inward, and the mind through all her powers<br/
Irradiate.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thea</ent><br/
\'d8<hw>The"a</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[NL. See <er>Tea</er>.]</ety> <fld>(Bot.)</fld> <def>A genus of plants found in China and Japan; the tea plant.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It is now commonly referred to the genus <gen>Camellia</gen>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>theandric</ent><br/
<hw>the*an"dric</hw> <pr>(th<esl/*<acr/n"dr<icr/k)</pr>, <pos>a.</pos> <ety>[Gr. <grk>qeandriko`s</grk>; <grk>qeo`s</grk> god + <grk>anh`r</grk>, <grk>andro`s</grk>, a man.]</ety> <def>Relating to, or existing by, the union of divine and human operation in Christ, or the joint agency of the divine and human nature.</def>  <rj><au>Murdock.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theanthropical</ent><br/
<ent>theanthropic</ent><br/
<mhw>{ <hw>the`an*throp"ic</hw> <pr>(th<emac/`<acr/n*thr<ocr/p"<icr/k)</pr>, <hw>The`an*throp"ic*al</hw> <pr>(th<emac/`<acr/n*thr<ocr/p"<icr/*k<ait/l)</pr>, }</mhw> <pos>a.</pos> <def>Partaking of, or combining, both divinity and humanity.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The gorgeous and imposing figures of his [Homer's] <qex>theanthropic</qex> sytem.</q> <rj><qau>Gladstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theanthropism</ent><br/
<hw>The*an"thro*pism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ god + <?/ man.]</ety> <sn>1.</sn> <def>A state of being God and man.</def> <mark>[R.]</mark>  <rj><au>Coleridge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The ascription of human atributes to the Deity, or to a polytheistic deity; anthropomorphism.</def>  <rj><au>Gladstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theanthropist</ent><br/
<hw>The*an"thro*pist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who advocates, or believes in, theanthropism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theanthropy</ent><br/
<hw>The*an"thro*py</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Theanthropism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thearchic</ent><br/
<hw>The*ar"chic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/. See <er>Thearchy</er>.]</ety> <def>Divinely sovereign or supreme.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He [Jesus] is the <qex>thearchic</qex> Intelligence.</q> <rj><qau>Milman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thearchy</ent><br/
<hw>The"ar*chy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ god + <ets>-archy</ets>: cf. Gr. <?/ the supreme deity.]</ety> <def>Government by God; divine sovereignty; theocracy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theatre</ent><br/
<ent>Theater</ent><br/
<mhw>{ <hw>The"a*ter</hw>, <hw>The"a*tre</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>th<eacute/<acir/tre</ets>, L. <ets>theatrum</ets>, Gr. <?/, fr. <?/  to see, view; cf. Skr. <ets>dhy<amac/</ets> to meditate, think.  Cf. <er>Theory</er>.]</ety> <sn>1.</sn> <def>An edifice in which dramatic performances or spectacles are exhibited for the amusement of spectators; anciently uncovered, except the stage, but in modern times roofed.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any room adapted to the exhibition of any performances before an assembly, as public lectures, scholastic exercises, anatomical demonstrations, surgical operations, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which resembles a theater in form, use, or the like; a place rising by steps or gradations, like the seats of a theater.</def>  <rj><au>Burns.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Shade above shade, a woody <qex>theater</qex><br/
Of stateliest view.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A sphere or scheme of operation.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>For if a man can be partaker of God's <qex>theater</qex>, he shall likewise be partaker of God's rest.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A place or region where great events are enacted; <as>as, the <ex>theater</ex> of war</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theatine</ent><br/
<ent>Theatin</ent><br/
<mhw>{ <hw>The"a*tin</hw>, <hw>The"a*tine</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>th<eacute/atin</ets>, It. <ets>theatino</ets>.]</ety> <fld>(R. C. Ch.)</fld> <sn>1.</sn> <def>One of an order of Italian monks, established in 1524, expressly to oppose Reformation, and to raise the tone of piety among Roman Catholics. They hold no property, nor do they beg, but depend on what Providence sends. Their chief employment is preaching and giving religious instruction.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Their name is derived from <xex>Theate</xex>, or <xex>Chieti</xex>, a city of Naples, the archbishop of which was a principal founder of the order; but they bore various names; as, <xex>Regular Clerks of the Community</xex>, <xex>Pauline Monks</xex>, <xex>Apostolic Clerks</xex>, and <xex>Regular Clerks of the Divine Providence</xex>. The order never flourished much out of Italy.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(R. C. Ch.)</fld> <def>One of an order of nuns founded by <person>Ursula Benincasa</person>, who died in 1618.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theatral</ent><br/
<hw>The"a*tral</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>theatralis</ets>: cf. F. <ets>th<eacute/atral</ets>.]</ety> <def>Of or pertaining to a theater; theatrical.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theatric</ent><br/
<hw>The*at"ric</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Theatrical.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Woods over woods in gay, <qex>theatric</qex> pride.</q> <rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theatrical</ent><br/
<hw>The*at"ric*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>theatricus</ets>, Gr. <?/.]</ety> <def>Of or pertaining to a theater, or to the scenic representations; resembling the manner of dramatic performers; histrionic; hence, artificial; <as>as, <ex>theatrical</ex> performances; <ex>theatrical</ex> gestures</as>.</def> -- <wordforms><wf>The*at`ri*cal"i*ty</wf> <pr>(#)</pr>, <pos>n.</pos> -- <wf>The*at"ric*al*ly</wf> <pr>(#)</pr>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>No meretricious aid whatever has been called in -- no trick, no illusion of the eye, nothing <qex>theatrical</qex>.</q> <rj><qau>R. Jefferies.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theatricals</ent><br/
<hw>The*at"ric*als</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>Dramatic performances; especially, those produced by amateurs.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Such fashionable cant terms as <lsquo/<qex>theatricals</qex>,' and <lsquo/musicals,' invented by the flippant Topham, still survive among his confraternity of frivolity.</q> <rj><qau>I. Disraeli.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theave</ent><br/
<hw>Theave</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. W. <ets>dafad</ets> a sheep, ewe.]</ety> <def>A ewe lamb of the first year; also, a sheep three years old.</def> <altsp>[Written also <asp>thave</asp>.]</altsp> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thebaic</ent><br/
<hw>The*ba"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>thebaicus</ets>, Gr. <?/.]</ety> <def>Of or pertaining to Thebes in Egypt; specifically, designating a version of the Bible preserved by the Copts, and esteemed of great value by biblical scholars. This version is also called the <xex>Sahidic version</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thebaid</ent><br/
<hw>The"ba*id</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>Thebais</ets>, <ets>-idis</ets>.]</ety> <def>A Latin epic poem by Statius about Thebes in Boeotia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thebaine</ent><br/
<hw>The*ba"ine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So called from a kind of Egyptian opium produced at <ets>Thebes</ets>.]</ety> <fld>(Chem.)</fld> <def>A poisonous alkaloid, <chform>C19H21NO3</chform>, found in opium in small quantities, having a sharp, astringent taste, and a tetanic action resembling that of strychnine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theban</ent><br/
<hw>The"ban</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>Thebanus</ets>.]</ety> <def>Of or pertaining to Thebes.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Theban year</b></col> <fld>(Anc. Chron.)</fld>, <cd>the Egyptian year of 365 days and 6 hours.</cd> <au>J. Bryant.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theban</ent><br/
<hw>The"ban</hw>, <pos>n.</pos> <def>A native or inhabitant of Thebes; also, a wise man.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I'll talk a word with this same learned <qex>Theban</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theca</ent><br/
\'d8<hw>The"ca</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Thecae</plw> <pr>(#)</pr>.</plu> <ety>[L., fr. Gr. <?/ a case to put anything in. See <er>Tick</er> a cover.]</ety> <sn>1.</sn> <def>A sheath; a case; <as>as, the <ex>theca</ex>, or cell, of an anther; the <ex>theca</ex>, or spore case, of a fungus; the <ex>theca</ex> of the spinal cord.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <sd>(a)</sd> <def>The chitinous cup which protects the hydranths of certain hydroids.</def> <sd>(b)</sd> <def>The more or less cuplike calicle of a coral.</def> <sd>(c)</sd> <def>The wall forming a calicle of a coral.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecal</ent><br/
<hw>The"cal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to a theca; <as>as, a <ex>thecal</ex> abscess</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecaphore</ent><br/
<hw>The"ca*phore</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Theca</ets> + Gr. <grk>fe`rein</grk> to bear: cf. F. <ets>th<eacute/caphore</ets>.]</ety> <fld>(Bot.)</fld> <sd>(a)</sd> <def>A surface or organ bearing a theca, or covered with thecae.</def> <sd>(b)</sd> <def>See <er>Basigynium</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecasporous</ent><br/
<hw>The*cas"po*rous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Bot.)</fld> <def>Having the spores in thecae, or cases.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecata</ent><br/
\'d8<hw>The*ca"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., from Gr. <?/ a case.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Thecophora</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecla</ent><br/
<hw>Thec"la</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Any one of many species of small delicately colored butterflies belonging to <gen>Thecla</gen> and allied genera; -- called also <altname>hairstreak</altname>, and <altname>elfin</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecodactyl</ent><br/
<hw>The`co*dac"tyl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<?/ case + <?/ finger.]</ety> <fld>(Zool.)</fld> <def>Any one of a group of lizards of the Gecko tribe, having the toes broad, and furnished with a groove in which the claws can be concealed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecodont</ent><br/
<hw>The"co*dont</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/ a case + <?/, <?/, a tooth.]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>Having the teeth inserted in sockets in the alveoli of the jaws.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Paleon.)</fld> <def>Of or pertaining to the thecodonts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecodont</ent><br/
<hw>The"co*dont</hw>, <pos>n.</pos> <fld>(Paleon.)</fld> <def>One of the Thecodontia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecodontia</ent><br/
\'d8<hw>The`co*don"ti*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.]</ety> <fld>(Paleon.)</fld> <def>A group of fossil saurians having biconcave vertebrae and the teeth implanted in sockets.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecophora</ent><br/
\'d8<hw>The*coph"o*ra</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., from Gr. <?/ a case + <grk>fe`rein</grk> to bear.]</ety> <fld>(Zool.)</fld> <def>A division of hydroids comprising those which have the hydranths in thecae and the gonophores in capsules. The campanularians and sertularians are examples. Called also <altname>Thecata</altname>. See <xex>Illust.</xex> under <er>Hydroidea</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thecosomata</ent><br/
\'d8<hw>The`co*so"ma*ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Theca</er>, and <er>Soma</er>.]</ety> <fld>(Zool.)</fld> <def>An order of Pteropoda comprising those species which have a shell. See <er>Pteropoda</er>.</def> -- <wordforms><wf>The`co*so"ma*tous</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thedom</ent><br/
<hw>The"dom</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Thee</ets> to prosper + <ets>-dom</ets>.]</ety> <def>Success; fortune; luck; chance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Evil <qex>thedom</qex> on his monk's snout.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thee</ent><br/
<hw>Thee</hw> <pr>(th<emac/)</pr>, <pos>v. i.</pos> <ety>[AS. <ets><thorn/e<oacute/n</ets>; akin to OS. <ets>th<imac/han</ets>, D. ge<ets>dijen</ets>, G. ge<ets>deihen</ets>, OHG. gi<ets>dihan</ets>, Goth. <ets><thorn/eihan</ets>, Lith. <ets>tekti</ets> to fall to the lot of.  Cf. <er>Tight</er>, <pos>a.</pos>]</ety> <def>To thrive; to prosper.</def> <mark>[Obs.]</mark> <ldquo/He shall never <xex>thee</xex>.<rdquo/ <au>Chaucer.</au><br/
[<source>1913 Webster</source>]</p>

<p><q>Well mote <qex>thee</qex>, as well can wish your thought.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thee</ent><br/
<hw>Thee</hw> <pr>(<th/<emac/)</pr>, <pos>pron.</pos> <ety>[AS. <ets><edh/<emac/</ets>, acc. & dat. of <ets><edh/<umac/</ets> thou. See <er>Thou</er>.]</ety> <def>The objective case of <xex>thou</xex>. See <er>Thou</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Thee is poetically used for <xex>thyself</xex>, as <xex>him</xex> for <xex>himself</xex>, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>This sword hath ended him; so shall it thee,<br/
Unless thou yield <qex>thee</qex> as my prisoner.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1495 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theft</ent><br/
<hw>Theft</hw> <pr>(th<ecr/ft)</pr>, <pos>n.</pos> <ety>[OE. <ets>thefte</ets>, AS. <ets><thorn/i<eacute/f<edh/e</ets>, <ets><thorn/<ymac/f<edh/e</ets>, <ets><thorn/e<oacute/f<edh/e</ets>. See <er>Thief</er>.]</ety> <sn>1.</sn> <fld>(Law)</fld> <def>The act of stealing; specifically, the felonious taking and removing of personal property, with an intent to deprive the rightful owner of the same; larceny.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ To constitute theft there must be a taking without the owner's consent, and it must be unlawful or felonious; every part of the property stolen must be removed, however slightly, from its former position; and it must be, at least momentarily, in the complete possession of the thief. See <er>Larceny</er>, and the Note under <er>Robbery</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The thing stolen.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>If the <qex>theft</qex> be certainly found in his hand alive, . . . he shall restore double.</q> <rj><qau>Ex. xxii. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theftbote</ent><br/
<hw>Theft"bote`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Theft</ets> + <ets>bote</ets> compensation.]</ety> <fld>(Law)</fld> <def>The receiving of a man's goods again from a thief, or a compensation for them, by way of composition, with the intent that the thief shall escape punishment.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thegn</ent><br/
<hw>Thegn</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Thane. See <er>Thane</er>.</def>  <rj><au>E. A. Freeman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thegnhood</ent><br/
<hw>Thegn"hood</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Thanehood.</def>  <rj><au>E. A. Freeman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theiform</ent><br/
<hw>The"i*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[NL. <ets>thea</ets> tea, the tea plant + <ets>-form</ets>: cf. F. <ets>th<eacute/iforme</ets>.]</ety> <def>Having the form of tea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theine</ent><br/
<hw>The"ine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>th<eacute/ine</ets>, fr. NL. <ets>thea</ets>. See <er>Theiform</er>.]</ety> <fld>(Chem.)</fld> <def>See <er>Caffeine</er>. Called also <altname>theina</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Their</ent><br/
<hw>Their</hw> <pr>(?)</pr>, <pos>pron. & a.</pos> <ety>[OE. <ets>thair</ets>, fr. Icel. <ets><thorn/eirra</ets>, <ets><thorn/eira</ets>, of them, but properly gen. pl. of the definite article; akin to AS. <ets><edh/<amac/ra</ets>, <ets><edh/<aemac/ra</ets>, gen. pl. of the definite article, or fr. AS. <ets><edh/<aemac/ra</ets>, influenced by the Scandinavian use. See <er>That</er>.]</ety> <def>The possessive case of the personal pronoun <xex>they</xex>; <as>as, <ex>their</ex> houses; <ex>their</ex> country</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The possessive takes the form <xex>theirs</xex> (<?/) when the noun to which it refers is not expressed, but implied or understood; as, our land is richest, but <xex>theirs</xex> is best cultivated.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Nothing but the name of zeal appears<br/
'Twixt our best actions and the worst of <qex>theirs</qex>.</q> <rj><qau>Denham.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theism</ent><br/
<hw>The"ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From Gr. <?/ God; probably akin to <?/ to pray for, <?/ spoken by God, decreed: cf. F. <ets>th<eacute/isme</ets>.  Cf. <er>Enthusiasm</er>, <er>Pantheon</er>, <er>Theology</er>.]</ety> <def>The belief or acknowledgment of the existence of a God, as opposed to <contr>atheism</contr>, <contr>pantheism</contr>, or <contr>polytheism</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theism</ent><br/
<hw>The"ism</hw> <pr>(th<emac/"<icr/z'm)</pr>, <pos>n.</pos> <ety>[NL. & E. <ets>thea</ets> tea + <ets>-ism</ets>.]</ety> <fld>(Med.)</fld> <def>The morbid condition resulting from the excessive use of tea.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Theist</ent><br/
<hw>The"ist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>th<eacute/iste</ets>. See <er>Theism</er>.]</ety> <def>One who believes in the existence of a God; especially, one who believes in a personal God; -- opposed to <contr>atheist</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theistical</ent><br/
<ent>Theistic</ent><br/
<mhw>{ <hw>The*is"tic</hw> <pr>(?)</pr>, <hw>The*is"tic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <def>Of or pertaining to theism, or a theist; according to the doctrine of theists.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thelphusian</ent><br/
<hw>Thel*phu"si*an</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ nipple + <?/ to blow, to puff.]</ety> <fld>(Zool.)</fld> <def>One of a tribe of fresh-water crabs which live in or on the banks of rivers in tropical countries.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thelytokous</ent><br/
<hw>The*lyt"o*kous</hw> <pr>(th<esl/*l<icr/t"<osl/*k<ucr/s)</pr>, <pos>a.</pos> <ety>[Gr. <grk>qh^lys</grk> female + <grk>to`kos</grk> a bringing forth.]</ety> <fld>(Zool.)</fld> <def>Producing females only; -- said of certain female insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Them</ent><br/
<hw>Them</hw> <pr>(<th/<ecr/m)</pr>, <pos>pron.</pos> <ety>[AS. <ets><edh/<aemac/m</ets>, dat. pl. of the article, but influenced by the Scand. use of the corresponding form <ets><thorn/eim</ets> as a personal pronoun. See <er>They</er>.]</ety> <def>The objective case of they. See <er>They</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Go ye rather to <qex>them</qex> that sell, and buy for yourselves.</q> <rj><qau>Matt. xxv. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Then shall the King say unto <qex>them</qex> on his right hand, Come, ye blessed of my Father.</q> <rj><qau>Matt. xxv. 34.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Them</xex> is poetically used for <xex>themselves</xex>, as <xex>him</xex> for <xex>himself</xex>, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Little stars may hide <qex>them</qex> when they list.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thematic</ent><br/
<hw>The*mat"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/: cf. F. <ets>th<eacute/matique</ets>.]</ety> <sn>1.</sn> <fld>(Gram.)</fld> <def>Of or pertaining to the theme of a word. See <er>Theme</er>, <pos>n.</pos>, 4.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>Of or pertaining to a theme, or subject.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Thematic catalogue</b></col> <fld>(Mus.)</fld>, <cd>a catalogue of musical works which, besides the title and other particulars, gives in notes the theme, or first few measures, of the whole work or of its several movements.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theme</ent><br/
<hw>Theme</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>teme</ets>, OF. <ets>teme</ets>, F. <ets>th<egrave/me</ets>, L. <ets>thema</ets>, Gr. <?/, fr. <?/ to set, place. See <er>Do</er>, and cf. <er>Thesis</er>.]</ety> <sn>1.</sn> <def>A subject or topic on which a person writes or speaks; a proposition for discussion or argument; a text.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>My <qex>theme</qex> is alway one and ever was.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And when a soldier was the <qex>theme</qex>, my name<br/
Was not far off.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Discourse on a certain subject.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Then ran repentance and rehearsed his <qex>theme</qex>.</q> <rj><qau>Piers Plowman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It was the subject of my <qex>theme</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A composition or essay required of a pupil.</def>  <rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Gram.)</fld> <def>A noun or verb, not modified by inflections; also, that part of a noun or verb which remains unchanged (except by euphonic variations) in declension or conjugation; stem.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>That by means of which a thing is done; means; instrument.</def> <mark>[Obs.]</mark>  <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Mus.)</fld> <def>The leading subject of a composition or a movement.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Themis</ent><br/
<hw>The"mis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr. Gr. <?/, fr. <?/ that which is laid down or established by usage, law, prob. fr. <?/ to set, place.]</ety> <fld>(Gr. Myth.)</fld> <def>The goddess of law and order; the patroness of existing rights.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Themselves</ent><br/
<hw>Them*selves"</hw> <pr>(?)</pr>, <pos>pron.</pos> <def>The plural of <xex>himself</xex>, <xex>herself</xex>, and <xex>itself</xex>. See <er>Himself</er>, <er>Herself</er>, <er>Itself</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Then</ent><br/
<hw>Then</hw> <pr>(<th/<ecr/n)</pr>, <pos>adv.</pos> <ety>[Originally the same word as <ets>than</ets>. See <er>Than</er>.]</ety> <sn>1.</sn> <def>At that time (referring to a time specified, either past or future).</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And the Canaanite was <qex>then</qex> in the land.</q> <rj><qau>Gen. xii. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Now I know in part; but <qex>then</qex> shall I know even as also I am known.</q> <rj><qau>1 Cor. xiii. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Soon afterward, or immediately; next; afterward.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>First be reconciled to thy brother, and <qex>then</qex> come and offer thy gift.</q> <rj><qau>Matt. v. 24.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>At another time; later; again.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>One while the master is not aware of what is done, and <qex>then</qex> in other cases it may fall out to be own act.</q> <rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>By then</b></col>. <sd>(a)</sd> <cd>By that time.</cd> <sd>(b)</sd> <cd>By the time that.</cd> <mark>[Obs.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>But that opinion, I trust, <qex>by then</qex> this following argument hath been well read, will be left for one of the mysteries of an indulgent Antichrist.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Now and then</b></col>. <cd>See under <er>Now</er>, <pos>adv.</pos></cd> -- <col><b>Till then</b></col>, <cd>until that time; until the time mentioned.</cd> <au>Milton.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Then</xex> is often used elliptically, like an adjective, for <xex>then existing</xex>; as, the <xex>then</xex> administration.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Then</ent><br/
<hw>Then</hw> <pr>(?)</pr>, <pos>conj.</pos> <sn>1.</sn> <def>Than.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In that case; in consequence; as a consequence; therefore; for this reason.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If all this be so, <qex>then</qex> man has a natural freedom.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Now, <qex>then</qex>, be all thy weighty cares away.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Therefore.</syn> <usage> <er>Then</er>, <er>Therefore</er>. Both these words are used in reasoning; but <xex>therefore</xex> takes the lead, while <xex>then</xex> is rather subordinate or incidental. <xex>Therefore</xex> states reasons and draws inferences in form; <xex>then</xex>, to a great extent, takes the point as proved, and passes on to the general conclusion. <ldquo/<xex>Therefore</xex> being justified by faith, we have peace with God.<rdquo/ <au>Rom. v. 1.</au> <ldquo/So <xex>then</xex> faith cometh by hearing, and hearing by the word of God.<rdquo/ <au>Rom. x. 17.</au></usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thenadays</ent><br/
<hw>Then"a*days</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>At that time; then; in those days; -- correlative to <xex>nowadays</xex>.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thenar</ent><br/
<ent>Thenal</ent><br/
<mhw>{ <hw>The"nal</hw> <pr>(?)</pr>, <hw>The"nar</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[NL., fr. Gr. <?/.]</ety> <fld>(Anat.)</fld> <def>Of or pertaining to the thenar; corresponding to thenar; palmar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thenar</ent><br/
<hw>The"nar</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Anat.)</fld> <sd>(a)</sd> <def>The palm of the hand.</def> <sd>(b)</sd> <def>The prominence of the palm above the base of the thumb; the thenar eminence; the ball of the thumb. Sometimes applied to the corresponding part of the foot.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thenardite</ent><br/
<hw>The*nard"ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Named after the French chemist, L. J. <etsep>Th<eacute/nard</etsep>.]</ety> <fld>(Min.)</fld> <def>Anhydrous sodium sulphate, a mineral of a white or brown color and vitreous luster.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thence</ent><br/
<hw>Thence</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[OE. <ets>thenne</ets>, <ets>thanne</ets>, and (with the adverbal <ets>-s</ets>; see <er>-wards</er>) <ets>thennes</ets>, <ets>thannes</ets> (hence <ets>thens</ets>, now written <ets>thence</ets>), AS. <ets><edh/anon</ets>, <ets><edh/anan</ets>, <ets><edh/onan</ets>; akin to OHG. <ets>dannana</ets>, <ets>dann<amac/n</ets>, <ets>dan<amac/n</ets>, and G. von <ets>dannen</ets>, E. <ets>that</ets>, <ets>there</ets>. See <er>That</er>.]</ety> <sn>1.</sn> <def>From that place.</def> <ldquo/Bid him <xex>thence</xex> go.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When ye depart <qex>thence</qex>, shake off the dust under your feet for a testimony against them.</q> <rj><qau>Mark vi. 11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It is not unusual, though pleonastic, to use <xex>from</xex> before <xex>thence</xex>.  Cf. <er>Hence</er>, <er>Whence</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Then I will send, and fetch thee <qex>from thence</qex>.</q> <rj><qau>Gen. xxvii. 45.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>From that time; thenceforth; thereafter.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There shall be no more <qex>thence</qex> an infant of days.</q> <rj><qau>Isa. lxv. 20.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>For that reason; therefore.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Not to sit idle with so great a gift<br/
Useless, and <qex>thence</qex> ridiculous, about him.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Not there; elsewhere; absent.</def> <mark>[Poetic]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thenceforth</ent><br/
<hw>Thence`forth"</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>From that time; thereafter.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If the salt have lost his savor, wherewith shall it be salted? it is <qex>thenceforth</qex> good for nothing.</q> <rj><qau>Matt. v. 13.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note>    This word is sometimes preceded by <xex>from</xex>, -- a redundancy sanctioned by custom.  <rj><au>Chaucer.</au> <au>John. xix. 12.</au></rj>
</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thenceforward</ent><br/
<hw>Thence`for"ward</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>From that time onward; thenceforth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Thencefrom</ent><br/
<hw>Thence`from"</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>From that place.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theobroma</ent><br/
<hw>The`o*bro"ma</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ a god + <?/ food, fr. <?/ to eat: cf. F. <ets>th<eacute/obrome</ets>.]</ety> <fld>(Bot.)</fld> <def>A genus of small trees. See <er>Cacao</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theobromic</ent><br/
<hw>The`o*bro"mic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of, pertaining to, or designating, an acid extracted from cacao butter (from the <xex>Theobroma Cacao</xex>), peanut oil (from <xex>Arachis hypogaea</xex>), etc., as a white waxy crystalline substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theobromine</ent><br/
<hw>The`o*bro"mine</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>An alkaloidal ureide, <chform>C7H8N4O2</chform>, homologous with and resembling caffeine, produced artificially, and also extracted from cacao and chocolate (from <spn>Theobroma Cacao</spn>) as a bitter white crystalline substance; -- called also <altname>dimethyl xanthine</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theochristic</ent><br/
<hw>The`o*chris"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/; <?/ God + <?/ anointed, fr. <?/ to anoint.]</ety> <def>Anointed by God.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theocracy</ent><br/
<hw>The*oc"ra*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/; <?/ God + <?/ to be strong, to rule, fr. <?/ strength: cf. F. <ets>th<eacute/ocratie</ets>. See <er>Theism</er>, and cf. <er>Democracy</er>.]</ety> <sn>1.</sn> <def>Government of a state by the immediate direction or administration of God; hence, the exercise of political authority by priests as representing the Deity.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The state thus governed, as the Hebrew commonwealth before it became a kingdom.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theocrasy</ent><br/
<hw>The*oc"ra*sy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ union of the soul with God; <?/ God + <?/ a mixing, akin to <?/ to mix.]</ety> <sn>1.</sn> <def>A mixture of the worship of different gods, as of Jehovah and idols.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This syncretistic <qex>theocracy</qex> by no means excludes in him [Solomon] the proper service of idols.</q> <rj><qau>J. Murphy.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Philos.)</fld> <def>An intimate union of the soul with God in contemplation, -- an ideal of the Neoplatonists and of some Oriental mystics.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theocrat</ent><br/
<hw>The"o*crat</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who lives under a theocratic form of government; one who in civil affairs conforms to divine law.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theocratical</ent><br/
<ent>Theocratic</ent><br/
<mhw>{ <hw>The`o*crat"ic</hw> <pr>(?)</pr>, <hw>The`o*crat"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>th<eacute/ocratique</ets>.]</ety> <def>Of or pertaining to a theocracy; administred by the immediate direction of God; <as>as, the <ex>theocratical</ex> state of the Israelites</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theodicy</ent><br/
<hw>The*od"i*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. <ets>theodicaea</ets>, fr. Gr. <?/ God + <?/ right, justice: cf. F. <ets>th<eacute/odic<eacute/e</ets>.]</ety> <sn>1.</sn> <def>A vindication of the justice of God in ordaining or permitting natural and moral evil.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That department of philosophy which treats of the being, perfections, and government of God, and the immortality of the soul.</def>  <rj><au>Krauth-Fleming.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theodolite</ent><br/
<hw>The*od"o*lite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Probably a corruption of <ets>the alidade</ets>. See <er>Alidade</er>.]</ety> <def>An instrument used, especially in trigonometrical surveying, for the accurate measurement of horizontal angles, and also usually of vertical angles. It is variously constructed.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The theodolite consists principally of a telescope, with cross wires in the focus of its object glass, clamped in Y's attached to a frame that is mounted so as to turn both on vertical and horizontal axes, the former carrying a vernier plate on a horizontal graduated plate or circle for azimuthal angles, and the latter a vertical graduated arc or semicircle for altitudes. The whole is furnished with levels and adjusting screws and mounted on a tripod.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theodolitic</ent><br/
<hw>The*od`o*lit"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to a theodolite; made by means of a theodolite; <as>as, <ex>theodolitic</ex> observations</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theogonic</ent><br/
<hw>The`o*gon"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or relating to theogony.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theogonism</ent><br/
<hw>The*og"o*nism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Theogony.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theogonist</ent><br/
<hw>The*og"o*nist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A writer on theogony.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theogony</ent><br/
<hw>The*og"o*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>theogonia</ets>, Gr. <?/; <?/ a god + the root of <?/ to be born. See <er>Theism</er>, and <er>Genus</er>.]</ety> <def>The generation or genealogy of the gods; that branch of heathen theology which deals with the origin and descent of the deities; also, a poem treating of such genealogies; <as>as, the <ex>Theogony</ex> of Hesiod</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theologaster</ent><br/
<hw>The*ol"o*gas`ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Formed like <ets>poetaster</ets>: cf. F. <ets>th<eacute/ologastre</ets>.]</ety> <def>A pretender or quack in theology.</def> <mark>[R.]</mark>  <rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theologer</ent><br/
<hw>The*ol"o*ger</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A theologian.</def>  <rj><au>Cudworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theologian</ent><br/
<hw>The`o*lo"gi*an</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>th<eacute/ologien</ets>, L. <ets>theologus</ets>, Gr. <?/. See <er>Theology</er>.]</ety> <def>A person well versed in theology; a professor of theology or divinity; a divine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theologic</ent><br/
<hw>The`o*log"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Theological.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Theological</ent><br/
<hw>The`o*log"ic*al</hw> <pr>(?)