/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.UriTextResource;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDirectoryListingParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheDirectoryListingParser.class);

    public List<String> parse(URI baseURI, InputStream content, String contentType) throws Exception {
        baseURI = this.addTrailingSlashes(baseURI);
        if (contentType == null || !contentType.startsWith("text/html")) {
            throw new ResourceException(baseURI, String.format("Unsupported ContentType %s for directory listing '%s'", contentType, baseURI));
        }
        Charset contentEncoding = UriTextResource.extractCharacterEncoding((String)contentType, (Charset)Charsets.UTF_8);
        Document document = Jsoup.parse((InputStream)content, (String)contentEncoding.name(), (String)baseURI.toString());
        Elements elements = document.select("a[href]");
        List<String> hrefs = elements.stream().map(it -> it.attr("href")).collect(Collectors.toList());
        List<URI> uris = this.resolveURIs(baseURI, hrefs);
        return this.filterNonDirectChilds(baseURI, uris);
    }

    private URI addTrailingSlashes(URI uri) throws IOException, URISyntaxException {
        if (uri.getPath() == null) {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "/", uri.getQuery(), uri.getFragment());
        } else if (!uri.getPath().endsWith("/") && !uri.getPath().endsWith(".html")) {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath() + "/", uri.getQuery(), uri.getFragment());
        }
        return uri;
    }

    private List<String> filterNonDirectChilds(URI baseURI, List<URI> inputURIs) throws MalformedURLException {
        int baseURIPort = baseURI.getPort();
        String baseURIHost = baseURI.getHost();
        String baseURIScheme = baseURI.getScheme();
        ArrayList<String> uris = new ArrayList<String>();
        String prefixPath = baseURI.getPath();
        for (URI parsedURI : inputURIs) {
            String childPathPart;
            if (parsedURI.getHost() != null && !parsedURI.getHost().equals(baseURIHost) || parsedURI.getScheme() != null && !parsedURI.getScheme().equals(baseURIScheme) || parsedURI.getPort() != baseURIPort || parsedURI.getPath() != null && !parsedURI.getPath().startsWith(prefixPath) || (childPathPart = parsedURI.getPath().substring(prefixPath.length(), parsedURI.getPath().length())).startsWith("../") || childPathPart.equals("") || childPathPart.split("/").length > 1) continue;
            String path = parsedURI.getPath();
            int pos = path.lastIndexOf(47);
            if (pos < 0) {
                uris.add(path);
                continue;
            }
            if (pos == path.length() - 1) {
                int start = path.lastIndexOf(47, pos - 1);
                if (start < 0) {
                    uris.add(path.substring(0, pos));
                    continue;
                }
                uris.add(path.substring(start + 1, pos));
                continue;
            }
            uris.add(path.substring(pos + 1));
        }
        return uris;
    }

    private List<URI> resolveURIs(URI baseURI, List<String> hrefs) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String href : hrefs) {
            try {
                uris.add(baseURI.resolve(href));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.debug("Cannot resolve anchor: {}", (Object)href);
            }
        }
        return uris;
    }
}

