/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class NetscapeDomainHandler
extends BasicDomainHandler {
    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (TextUtils.isBlank(value2)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        cookie.setDomain(value2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        String domain2;
        String host = origin.getHost();
        if (!host.equals(domain2 = cookie.getDomain()) && !BasicDomainHandler.domainMatch(domain2, host)) {
            throw new CookieRestrictionViolationException("Illegal domain attribute \"" + domain2 + "\". Domain of origin: \"" + host + "\"");
        }
        if (host.contains(".")) {
            int domainParts = new StringTokenizer(domain2, ".").countTokens();
            if (NetscapeDomainHandler.isSpecialDomain(domain2)) {
                if (domainParts < 2) {
                    throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates the Netscape cookie specification for " + "special domains");
                }
            } else if (domainParts < 3) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates the Netscape cookie specification");
            }
        }
    }

    private static boolean isSpecialDomain(String domain2) {
        String ucDomain = domain2.toUpperCase(Locale.ROOT);
        return ucDomain.endsWith(".COM") || ucDomain.endsWith(".EDU") || ucDomain.endsWith(".NET") || ucDomain.endsWith(".GOV") || ucDomain.endsWith(".MIL") || ucDomain.endsWith(".ORG") || ucDomain.endsWith(".INT");
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain2 = cookie.getDomain();
        if (domain2 == null) {
            return false;
        }
        return host.endsWith(domain2);
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

