/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jackson.internal;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Singleton;
import java.util.List;
import org.glassfish.jersey.jackson.internal.JacksonMapperConfigurator;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.Annotations;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JsonMapperConfigurator;

@Singleton
public class DefaultJacksonJaxbJsonProvider
extends JacksonJaxbJsonProvider {
    private static final String[] EXCLUDE_MODULE_NAMES = new String[]{"JaxbAnnotationModule", "JakartaXmlBindAnnotationModule"};

    public DefaultJacksonJaxbJsonProvider() {
        super(new JacksonMapperConfigurator(null, DEFAULT_ANNOTATIONS));
        this.findAndRegisterModules();
    }

    public DefaultJacksonJaxbJsonProvider(Annotations ... annotationsToUse) {
        super(new JacksonMapperConfigurator(null, annotationsToUse));
        this.findAndRegisterModules();
    }

    private void findAndRegisterModules() {
        ObjectMapper defaultMapper = ((JsonMapperConfigurator)this._mapperConfig).getDefaultMapper();
        ObjectMapper mapper = ((JsonMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        List<Module> modules = ObjectMapper.findModules();
        for (String exludeModuleName : EXCLUDE_MODULE_NAMES) {
            modules.removeIf(mod -> mod.getModuleName().contains(exludeModuleName));
        }
        defaultMapper.registerModules(modules);
        if (mapper != null) {
            mapper.registerModules(modules);
        }
    }
}

