/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.auth;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.jicofo.auth.AbstractAuthAuthority;
import org.jitsi.jicofo.auth.AuthenticationAuthority;
import org.jitsi.jicofo.auth.AuthenticationSession;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class ShibbolethAuthAuthority
extends AbstractAuthAuthority
implements AuthenticationAuthority {
    public static final String DEFAULT_URL_CONST = "shibboleth:default";
    private String loginUrlPattern = "login/?machineUID=%1$s&room=%3$s&close=%4$s";
    private String logoutUrlPattern = "../Shibboleth.sso/Logout";

    public ShibbolethAuthAuthority(boolean enableAutoLogin2, Duration authenticationLifetime2, String loginUrlPattern, String logoutUrlPattern) {
        super(enableAutoLogin2, authenticationLifetime2);
        if (StringUtils.isNotBlank(loginUrlPattern) && !DEFAULT_URL_CONST.equals(loginUrlPattern)) {
            this.loginUrlPattern = loginUrlPattern;
        }
        if (!DEFAULT_URL_CONST.equals(logoutUrlPattern)) {
            this.logoutUrlPattern = logoutUrlPattern;
        }
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public String createLoginUrl(String machineUID, EntityFullJid userJid, EntityBareJid roomName, boolean popup) {
        return String.format(this.loginUrlPattern, machineUID, userJid, roomName, popup);
    }

    @Override
    public String createLogoutUrl(String sessionId) {
        if (this.logoutUrlPattern == null) {
            return null;
        }
        return String.format(this.logoutUrlPattern, sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticateUser(String machineUID, String authIdentity, EntityBareJid roomName) {
        Object object = this.syncRoot;
        synchronized (object) {
            AuthenticationSession session = this.findSessionForIdentity(machineUID, authIdentity);
            if (session == null) {
                session = this.createNewSession(machineUID, authIdentity, roomName);
            }
            return session.getSessionId();
        }
    }

    @Override
    protected IQ processAuthLocked(ConferenceIq query, ConferenceIq response) {
        Jid peerJid = query.getFrom();
        String sessionId = query.getSessionId();
        AuthenticationSession session = this.getSession(sessionId);
        IQ error = this.verifySession(query);
        if (error != null) {
            return error;
        }
        if (session != null) {
            this.authenticateJidWithSession(session, peerJid, response);
        }
        return null;
    }
}

