/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.compression.XmppCompressionFactory;

public class XmppCompressionManager {
    private static final List<XmppCompressionFactory> xmppCompressionFactories = new ArrayList<XmppCompressionFactory>(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmppCompressionFactory registerXmppCompressionFactory(XmppCompressionFactory xmppCompressionFactory) {
        String method = xmppCompressionFactory.getCompressionMethod();
        XmppCompressionFactory previousFactory = null;
        List<XmppCompressionFactory> list = xmppCompressionFactories;
        synchronized (list) {
            Iterator<XmppCompressionFactory> it = xmppCompressionFactories.iterator();
            while (it.hasNext()) {
                XmppCompressionFactory factory = it.next();
                if (!factory.getCompressionMethod().equals(method)) continue;
                it.remove();
                previousFactory = factory;
                break;
            }
            xmppCompressionFactories.add(xmppCompressionFactory);
            Collections.sort(xmppCompressionFactories);
        }
        return previousFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmppCompressionFactory getBestFactory(Compress.Feature compressFeature) {
        List<String> announcedMethods = compressFeature.getMethods();
        List<XmppCompressionFactory> list = xmppCompressionFactories;
        synchronized (list) {
            for (XmppCompressionFactory factory : xmppCompressionFactories) {
                if (!announcedMethods.contains(factory.getCompressionMethod())) continue;
                return factory;
            }
        }
        return null;
    }
}

