/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingle;

import java.io.IOException;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.condesc.CallIdExtension;
import org.jitsi.xmpp.extensions.jingle.CoinPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.CryptoPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.EncryptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ExtmapAllowMixedPacketExtension;
import org.jitsi.xmpp.extensions.jingle.GroupPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.InputEvtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.JingleRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.MuteSessionInfoPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RawUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ReasonPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ReasonProvider;
import org.jitsi.xmpp.extensions.jingle.RemoteCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SctpMapExtensionProvider;
import org.jitsi.xmpp.extensions.jingle.SessionInfoPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SessionInfoType;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceRidGroupPacketExtension;
import org.jitsi.xmpp.extensions.jingle.TransferPacketExtension;
import org.jitsi.xmpp.extensions.jingle.TransferredPacketExtension;
import org.jitsi.xmpp.extensions.jingle.UdpCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.ZrtpHashPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.SSRCInfoPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class JingleIQProvider
extends IqProvider<JingleIQ> {
    public JingleIQProvider() {
        ProviderManager.addExtensionProvider("description", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<RtpDescriptionPacketExtension>(RtpDescriptionPacketExtension.class));
        ProviderManager.addExtensionProvider("payload-type", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<PayloadTypePacketExtension>(PayloadTypePacketExtension.class));
        ProviderManager.addExtensionProvider("parameter", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class));
        ProviderManager.addExtensionProvider("rtp-hdrext", "urn:xmpp:jingle:apps:rtp:rtp-hdrext:0", new DefaultPacketExtensionProvider<RTPHdrExtPacketExtension>(RTPHdrExtPacketExtension.class));
        ProviderManager.addExtensionProvider("extmap-allow-mixed", "urn:xmpp:jingle:apps:rtp:rtp-hdrext:0", new DefaultPacketExtensionProvider<ExtmapAllowMixedPacketExtension>(ExtmapAllowMixedPacketExtension.class));
        ProviderManager.addExtensionProvider("sctpmap", "urn:xmpp:jingle:transports:dtls-sctp:1", new SctpMapExtensionProvider());
        ProviderManager.addExtensionProvider("encryption", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<EncryptionPacketExtension>(EncryptionPacketExtension.class));
        ProviderManager.addExtensionProvider("zrtp-hash", "urn:xmpp:jingle:apps:rtp:zrtp:1", new DefaultPacketExtensionProvider<ZrtpHashPacketExtension>(ZrtpHashPacketExtension.class));
        ProviderManager.addExtensionProvider("crypto", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<CryptoPacketExtension>(CryptoPacketExtension.class));
        ProviderManager.addExtensionProvider("group", "urn:xmpp:jingle:apps:grouping:0", new DefaultPacketExtensionProvider<GroupPacketExtension>(GroupPacketExtension.class));
        ProviderManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<IceUdpTransportPacketExtension>(IceUdpTransportPacketExtension.class));
        ProviderManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:raw-udp:1", new DefaultPacketExtensionProvider<RawUdpTransportPacketExtension>(RawUdpTransportPacketExtension.class));
        ProviderManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<IceCandidatePacketExtension>(IceCandidatePacketExtension.class));
        ProviderManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:raw-udp:1", new DefaultPacketExtensionProvider<UdpCandidatePacketExtension>(UdpCandidatePacketExtension.class));
        ProviderManager.addExtensionProvider("remote-candidate", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<RemoteCandidatePacketExtension>(RemoteCandidatePacketExtension.class));
        ProviderManager.addExtensionProvider("inputevt", "http://jitsi.org/protocol/inputevt", new DefaultPacketExtensionProvider<InputEvtPacketExtension>(InputEvtPacketExtension.class));
        ProviderManager.addExtensionProvider("conference-info", "urn:xmpp:coin:1", new DefaultPacketExtensionProvider<CoinPacketExtension>(CoinPacketExtension.class));
        ProviderManager.addExtensionProvider("fingerprint", "urn:xmpp:jingle:apps:dtls:0", new DefaultPacketExtensionProvider<DtlsFingerprintPacketExtension>(DtlsFingerprintPacketExtension.class));
        ProviderManager.addExtensionProvider("transfer", "urn:xmpp:jingle:transfer:0", new DefaultPacketExtensionProvider<TransferPacketExtension>(TransferPacketExtension.class));
        ProviderManager.addExtensionProvider("transferred", "urn:xmpp:jingle:transfer:0", new DefaultPacketExtensionProvider<TransferredPacketExtension>(TransferredPacketExtension.class));
        ProviderManager.addExtensionProvider("callid", "http://jitsi.org/protocol/condesc", new DefaultPacketExtensionProvider<CallIdExtension>(CallIdExtension.class));
        ProviderManager.addExtensionProvider("rtcp-fb", "urn:xmpp:jingle:apps:rtp:rtcp-fb:0", new DefaultPacketExtensionProvider<RtcpFbPacketExtension>(RtcpFbPacketExtension.class));
        ProviderManager.addExtensionProvider("rtcp-mux", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<IceRtcpmuxPacketExtension>(IceRtcpmuxPacketExtension.class));
        ProviderManager.addExtensionProvider("rtcp-mux", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<JingleRtcpmuxPacketExtension>(JingleRtcpmuxPacketExtension.class));
        ProviderManager.addExtensionProvider("web-socket", "http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<WebSocketPacketExtension>(WebSocketPacketExtension.class));
        ProviderManager.addExtensionProvider("ssrc-info", "http://jitsi.org/jitmeet", new DefaultPacketExtensionProvider<SSRCInfoPacketExtension>(SSRCInfoPacketExtension.class));
        ProviderManager.addExtensionProvider("source", "urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourcePacketExtension>(SourcePacketExtension.class));
        ProviderManager.addExtensionProvider("ssrc-group", "urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourceGroupPacketExtension>(SourceGroupPacketExtension.class));
        ProviderManager.addExtensionProvider("rid-group", "urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourceRidGroupPacketExtension>(SourceRidGroupPacketExtension.class));
        ProviderManager.addExtensionProvider("parameter", "urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class));
    }

    @Override
    public JingleIQ parse(XmlPullParser parser2, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        JingleAction action = JingleAction.parseString(parser2.getAttributeValue("", "action"));
        String initiator = parser2.getAttributeValue("", "initiator");
        String responder = parser2.getAttributeValue("", "responder");
        String sid = parser2.getAttributeValue("", "sid");
        JingleIQ jingleIQ = new JingleIQ(action, sid);
        if (initiator != null) {
            Jid initiatorJid = JidCreate.from(initiator);
            jingleIQ.setInitiator(initiatorJid);
        }
        if (responder != null) {
            Jid responderJid = JidCreate.from(responder);
            jingleIQ.setResponder(responderJid);
        }
        boolean done = false;
        DefaultPacketExtensionProvider<ContentPacketExtension> contentProvider = new DefaultPacketExtensionProvider<ContentPacketExtension>(ContentPacketExtension.class);
        ReasonProvider reasonProvider = new ReasonProvider();
        DefaultPacketExtensionProvider<TransferPacketExtension> transferProvider = new DefaultPacketExtensionProvider<TransferPacketExtension>(TransferPacketExtension.class);
        DefaultPacketExtensionProvider<CoinPacketExtension> coinProvider = new DefaultPacketExtensionProvider<CoinPacketExtension>(CoinPacketExtension.class);
        DefaultPacketExtensionProvider<CallIdExtension> callidProvider = new DefaultPacketExtensionProvider<CallIdExtension>(CallIdExtension.class);
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            String elementName = parser2.getName();
            String namespace = parser2.getNamespace();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (elementName.equals("content")) {
                    ContentPacketExtension content = (ContentPacketExtension)contentProvider.parse(parser2);
                    jingleIQ.addContent(content);
                } else if (elementName.equals("reason")) {
                    ReasonPacketExtension reason2 = (ReasonPacketExtension)reasonProvider.parse(parser2);
                    jingleIQ.setReason(reason2);
                } else if (elementName.equals("transfer") && namespace.equals("urn:xmpp:jingle:transfer:0")) {
                    jingleIQ.addExtension((ExtensionElement)transferProvider.parse(parser2));
                } else if (elementName.equals("conference-info")) {
                    jingleIQ.addExtension((ExtensionElement)coinProvider.parse(parser2));
                } else if (elementName.equals("callid")) {
                    jingleIQ.addExtension((ExtensionElement)callidProvider.parse(parser2));
                } else if (elementName.equals("group")) {
                    jingleIQ.addExtension(GroupPacketExtension.parseExtension(parser2, xmlEnvironment));
                } else if (namespace.equals("urn:xmpp:jingle:apps:rtp:info:1")) {
                    SessionInfoType type2 = SessionInfoType.valueOf(elementName);
                    if (type2 == SessionInfoType.mute || type2 == SessionInfoType.unmute) {
                        String name = parser2.getAttributeValue("", "name");
                        jingleIQ.setSessionInfo(new MuteSessionInfoPacketExtension(type2 == SessionInfoType.mute, name));
                    } else {
                        jingleIQ.setSessionInfo(new SessionInfoPacketExtension(type2));
                    }
                } else {
                    PacketParserUtils.addExtensionElement(jingleIQ, parser2, xmlEnvironment);
                }
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals("jingle")) continue;
            done = true;
        }
        return jingleIQ;
    }
}

