/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xeustechnologies.jcl.Configuration;
import org.xeustechnologies.jcl.ProxyClassLoader;
import org.xeustechnologies.jcl.exception.JclException;
import org.xeustechnologies.jcl.exception.ResourceNotFoundException;
import org.xeustechnologies.jcl.utils.Utils;

public abstract class AbstractClassLoader
extends ClassLoader {
    protected final List<ProxyClassLoader> loaders = Collections.synchronizedList(new ArrayList());
    private final ProxyClassLoader systemLoader = new SystemLoader();
    private final ProxyClassLoader parentLoader = new ParentLoader();
    private final ProxyClassLoader currentLoader = new CurrentLoader();
    private final ProxyClassLoader threadLoader = new ThreadContextLoader();
    private final ProxyClassLoader osgiBootLoader = new OsgiBootLoader();

    public AbstractClassLoader(ClassLoader parent) {
        super(parent);
        this.addDefaultLoader();
    }

    public AbstractClassLoader() {
        this.addDefaultLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDefaultLoader() {
        List<ProxyClassLoader> list = this.loaders;
        synchronized (list) {
            this.loaders.add(this.systemLoader);
            this.loaders.add(this.parentLoader);
            this.loaders.add(this.currentLoader);
            this.loaders.add(this.threadLoader);
            Collections.sort(this.loaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoader(ProxyClassLoader loader) {
        List<ProxyClassLoader> list = this.loaders;
        synchronized (list) {
            this.loaders.add(loader);
            Collections.sort(this.loaders);
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        if (className == null || className.trim().equals("")) {
            return null;
        }
        Class clazz = null;
        if (this.osgiBootLoader.isEnabled()) {
            clazz = this.osgiBootLoader.loadClass(className, resolveIt);
        }
        if (clazz == null) {
            List<ProxyClassLoader> list = this.loaders;
            synchronized (list) {
                for (ProxyClassLoader l : this.loaders) {
                    if (l.isEnabled() && (clazz = l.loadClass(className, resolveIt)) != null) break;
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        URL url = null;
        if (this.osgiBootLoader.isEnabled()) {
            url = this.osgiBootLoader.findResource(name);
        }
        if (url == null) {
            List<ProxyClassLoader> list = this.loaders;
            synchronized (list) {
                for (ProxyClassLoader l : this.loaders) {
                    if (l.isEnabled() && (url = l.findResource(name)) != null) break;
                }
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (name == null || name.trim().equals("")) {
            return Collections.emptyEnumeration();
        }
        Vector<URL> urlVector = new Vector<URL>();
        URL url = null;
        if (this.osgiBootLoader.isEnabled() && (url = this.osgiBootLoader.findResource(name)) != null) {
            urlVector.add(url);
        }
        if (url == null) {
            List<ProxyClassLoader> list = this.loaders;
            synchronized (list) {
                for (ProxyClassLoader l : this.loaders) {
                    if (!l.isEnabled() || (url = l.findResource(name)) == null) continue;
                    urlVector.add(url);
                }
            }
        }
        return urlVector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String name) {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        InputStream is = null;
        if (this.osgiBootLoader.isEnabled()) {
            is = this.osgiBootLoader.loadResource(name);
        }
        if (is == null) {
            List<ProxyClassLoader> list = this.loaders;
            synchronized (list) {
                for (ProxyClassLoader l : this.loaders) {
                    if (l.isEnabled() && (is = l.loadResource(name)) != null) break;
                }
            }
        }
        return is;
    }

    public ProxyClassLoader getSystemLoader() {
        return this.systemLoader;
    }

    public ProxyClassLoader getParentLoader() {
        return this.parentLoader;
    }

    public ProxyClassLoader getCurrentLoader() {
        return this.currentLoader;
    }

    public ProxyClassLoader getThreadLoader() {
        return this.threadLoader;
    }

    public ProxyClassLoader getOsgiBootLoader() {
        return this.osgiBootLoader;
    }

    public final class OsgiBootLoader
    extends ProxyClassLoader {
        private final Logger logger = LoggerFactory.getLogger(OsgiBootLoader.class);
        private boolean strictLoading;
        private String[] bootDelagation;
        private static final String JAVA_PACKAGE = "java.";

        public OsgiBootLoader() {
            this.enabled = Configuration.isOsgiBootDelegationEnabled();
            this.strictLoading = Configuration.isOsgiBootDelegationStrict();
            this.bootDelagation = Configuration.getOsgiBootDelegation();
            this.order = 0;
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class clazz = null;
            if (this.enabled && this.isPartOfOsgiBootDelegation(className)) {
                clazz = AbstractClassLoader.this.getParentLoader().loadClass(className, resolveIt);
                if (clazz == null && this.strictLoading) {
                    throw new JclException(new ClassNotFoundException("JCL OSGi Boot Delegation: Class " + className + " not found."));
                }
                this.logger.debug("Class " + className + " loaded via OSGi boot delegation.");
            }
            return clazz;
        }

        @Override
        public InputStream loadResource(String name) {
            InputStream is = null;
            if (this.enabled && this.isPartOfOsgiBootDelegation(name)) {
                is = AbstractClassLoader.this.getParentLoader().loadResource(name);
                if (is == null && this.strictLoading) {
                    throw new ResourceNotFoundException("JCL OSGi Boot Delegation: Resource " + name + " not found.");
                }
                this.logger.debug("Resource " + name + " loaded via OSGi boot delegation.");
            }
            return is;
        }

        @Override
        public URL findResource(String name) {
            URL url = null;
            if (this.enabled && this.isPartOfOsgiBootDelegation(name)) {
                url = AbstractClassLoader.this.getParentLoader().findResource(name);
                if (url == null && this.strictLoading) {
                    throw new ResourceNotFoundException("JCL OSGi Boot Delegation: Resource " + name + " not found.");
                }
                this.logger.debug("Resource " + name + " loaded via OSGi boot delegation.");
            }
            return url;
        }

        private boolean isPartOfOsgiBootDelegation(String resourceName) {
            if (resourceName.startsWith(JAVA_PACKAGE)) {
                return true;
            }
            String[] bootPkgs = this.bootDelagation;
            if (bootPkgs != null) {
                for (String bc : bootPkgs) {
                    Pattern pat = Pattern.compile(Utils.wildcardToRegex(bc), 2);
                    Matcher matcher = pat.matcher(resourceName);
                    if (!matcher.find()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isStrictLoading() {
            return this.strictLoading;
        }

        public void setStrictLoading(boolean strictLoading) {
            this.strictLoading = strictLoading;
        }

        public String[] getBootDelagation() {
            return this.bootDelagation;
        }

        public void setBootDelagation(String[] bootDelagation) {
            this.bootDelagation = bootDelagation;
        }
    }

    class ThreadContextLoader
    extends ProxyClassLoader {
        private final Logger logger = LoggerFactory.getLogger(ThreadContextLoader.class);

        public ThreadContextLoader() {
            this.order = 40;
            this.enabled = Configuration.isThreadContextLoaderEnabled();
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class<?> result2;
            try {
                result2 = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            this.logger.debug("Returning class " + className + " loaded with thread context classloader");
            return result2;
        }

        @Override
        public InputStream loadResource(String name) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
            if (is != null) {
                this.logger.debug("Returning resource " + name + " loaded with thread context classloader");
                return is;
            }
            return null;
        }

        @Override
        public URL findResource(String name) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            if (url != null) {
                this.logger.debug("Returning resource " + name + " loaded with thread context classloader");
                return url;
            }
            return null;
        }
    }

    class CurrentLoader
    extends ProxyClassLoader {
        private final Logger logger = LoggerFactory.getLogger(CurrentLoader.class);

        public CurrentLoader() {
            this.order = 20;
            this.enabled = Configuration.isCurrentLoaderEnabled();
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class<?> result2;
            try {
                result2 = this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            this.logger.debug("Returning class " + className + " loaded with current classloader");
            return result2;
        }

        @Override
        public InputStream loadResource(String name) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
            if (is != null) {
                this.logger.debug("Returning resource " + name + " loaded with current classloader");
                return is;
            }
            return null;
        }

        @Override
        public URL findResource(String name) {
            URL url = this.getClass().getClassLoader().getResource(name);
            if (url != null) {
                this.logger.debug("Returning resource " + name + " loaded with current classloader");
                return url;
            }
            return null;
        }
    }

    class ParentLoader
    extends ProxyClassLoader {
        private final Logger logger = LoggerFactory.getLogger(ParentLoader.class);

        public ParentLoader() {
            this.order = 30;
            this.enabled = Configuration.isParentLoaderEnabled();
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class<?> result2;
            try {
                result2 = AbstractClassLoader.this.getParent().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            this.logger.debug("Returning class " + className + " loaded with parent classloader");
            return result2;
        }

        @Override
        public InputStream loadResource(String name) {
            InputStream is = AbstractClassLoader.this.getParent().getResourceAsStream(name);
            if (is != null) {
                this.logger.debug("Returning resource " + name + " loaded with parent classloader");
                return is;
            }
            return null;
        }

        @Override
        public URL findResource(String name) {
            URL url = AbstractClassLoader.this.getParent().getResource(name);
            if (url != null) {
                this.logger.debug("Returning resource " + name + " loaded with parent classloader");
                return url;
            }
            return null;
        }
    }

    class SystemLoader
    extends ProxyClassLoader {
        private final Logger logger = LoggerFactory.getLogger(SystemLoader.class);

        public SystemLoader() {
            this.order = 50;
            this.enabled = Configuration.isSystemLoaderEnabled();
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class result2;
            try {
                result2 = AbstractClassLoader.this.findSystemClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            this.logger.debug("Returning system class " + className);
            return result2;
        }

        @Override
        public InputStream loadResource(String name) {
            InputStream is = ClassLoader.getSystemResourceAsStream(name);
            if (is != null) {
                this.logger.debug("Returning system resource " + name);
                return is;
            }
            return null;
        }

        @Override
        public URL findResource(String name) {
            URL url = ClassLoader.getSystemResource(name);
            if (url != null) {
                this.logger.debug("Returning system resource " + name);
                return url;
            }
            return null;
        }
    }
}

