/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.instantiation.internal;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.util.beans.BeanInfoHelper;
import org.hibernate.query.sqm.sql.internal.InstantiationException;
import org.hibernate.query.sqm.tree.expression.Compatibility;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentReader;
import org.hibernate.sql.results.graph.instantiation.internal.BeanInjection;
import org.hibernate.sql.results.graph.instantiation.internal.BeanInjectorField;
import org.hibernate.sql.results.graph.instantiation.internal.BeanInjectorSetter;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class DynamicInstantiationAssemblerInjectionImpl<T>
implements DomainResultAssembler<T> {
    private final JavaType<T> target;
    private final List<BeanInjection> beanInjections = new ArrayList<BeanInjection>();

    public DynamicInstantiationAssemblerInjectionImpl(JavaType<T> target, List<ArgumentReader<?>> argumentReaders) {
        this.target = target;
        Class<T> targetJavaType = target.getJavaTypeClass();
        BeanInfoHelper.visitBeanInfo(targetJavaType, beanInfo -> {
            for (ArgumentReader argumentReader : argumentReaders) {
                boolean found = false;
                for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                    boolean assignmentCompatible;
                    if (!argumentReader.getAlias().equals(propertyDescriptor.getName()) || propertyDescriptor.getWriteMethod() == null || !(assignmentCompatible = Compatibility.areAssignmentCompatible(propertyDescriptor.getWriteMethod().getParameterTypes()[0], argumentReader.getAssembledJavaType().getClass()))) continue;
                    propertyDescriptor.getWriteMethod().setAccessible(true);
                    this.beanInjections.add(new BeanInjection(new BeanInjectorSetter(propertyDescriptor.getWriteMethod()), argumentReader));
                    found = true;
                    break;
                }
                if (found) continue;
                Field field = this.findField(targetJavaType, argumentReader.getAlias(), argumentReader.getAssembledJavaType().getJavaTypeClass());
                if (field != null) {
                    this.beanInjections.add(new BeanInjection(new BeanInjectorField(field), argumentReader));
                    continue;
                }
                throw new InstantiationException("Unable to determine dynamic instantiation injection strategy for " + targetJavaType.getName() + "#" + argumentReader.getAlias());
            }
        });
        if (argumentReaders.size() != this.beanInjections.size()) {
            throw new IllegalStateException("The number of readers did not match the number of injections");
        }
    }

    private Field findField(Class<?> declaringClass, String name, Class<?> javaType) {
        try {
            Field field = declaringClass.getDeclaredField(name);
            if (Compatibility.areAssignmentCompatible(field.getType(), javaType)) {
                field.setAccessible(true);
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public JavaType<T> getAssembledJavaType() {
        return this.target;
    }

    @Override
    public T assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        try {
            T result = this.target.getJavaTypeClass().newInstance();
            for (BeanInjection beanInjection : this.beanInjections) {
                beanInjection.getBeanInjector().inject(result, beanInjection.getValueAssembler().assemble(rowProcessingState, options));
            }
            return result;
        }
        catch (IllegalAccessException | java.lang.InstantiationException | InstantiationException e) {
            throw new InstantiationException("Could not call default constructor [" + this.target.getJavaType().getTypeName() + "]", (Throwable)e);
        }
    }
}

