/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.validate.AbstractStringValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.ValidatorConfig;

public class LocalDateValidator
extends AbstractStringValidator
implements ConfiguredProvider {
    public static final LocalDateValidator INSTANCE = new LocalDateValidator();
    public static final String ID = "local-date";
    public static final String MESSAGE_INVALID_DATE = "error-invalid-date";

    public String getId() {
        return ID;
    }

    @Override
    protected void doValidate(String value, String inputHint, ValidationContext context, ValidatorConfig config) {
        UserModel user = (UserModel)context.getAttributes().get(UserModel.class.getName());
        KeycloakSession session = context.getSession();
        KeycloakContext keycloakContext = session.getContext();
        Locale locale = keycloakContext.resolveLocale(user);
        DateFormat formatter = DateFormat.getDateInstance(3, locale);
        formatter.setLenient(false);
        try {
            formatter.parse(value);
        }
        catch (ParseException e) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_DATE));
        }
    }

    @Override
    public ValidationResult validateConfig(KeycloakSession session, ValidatorConfig config) {
        return ValidationResult.OK;
    }

    public String getHelpText() {
        return "Validates date formats based on the realm or user locale.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    @Override
    protected boolean isIgnoreEmptyValuesConfigured(ValidatorConfig config) {
        return true;
    }
}

