/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.security.AuthenticationException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.vertx.core.Handler;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class QuarkusErrorHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger(QuarkusErrorHandler.class);
    private static final String BASE_ID = UUID.randomUUID().toString() + "-";
    private static final AtomicLong ERROR_COUNT = new AtomicLong();
    private final boolean showStack;
    private final Optional<HttpConfiguration.PayloadHint> contentTypeDefault;

    public QuarkusErrorHandler(boolean showStack, Optional<HttpConfiguration.PayloadHint> contentTypeDefault) {
        this.showStack = showStack;
        this.contentTypeDefault = contentTypeDefault;
    }

    public void handle(final RoutingContext event) {
        String details;
        try {
            if (event.failure() == null) {
                event.response().setStatusCode(event.statusCode());
                event.response().end();
                return;
            }
            if (event.failure() instanceof UnauthorizedException) {
                HttpAuthenticator authenticator = (HttpAuthenticator)event.get(HttpAuthenticator.class.getName());
                if (authenticator != null) {
                    authenticator.sendChallenge(event).subscribe().with((Consumer)new Consumer<Boolean>(){

                        @Override
                        public void accept(Boolean aBoolean) {
                            event.response().end();
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable throwable) {
                            event.fail(throwable);
                        }
                    });
                } else {
                    event.response().setStatusCode(HttpResponseStatus.UNAUTHORIZED.code()).end();
                }
                return;
            }
            if (event.failure() instanceof ForbiddenException) {
                event.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).end();
                return;
            }
            if (event.failure() instanceof AuthenticationException) {
                if (event.response().getStatusCode() == HttpResponseStatus.OK.code()) {
                    event.response().setStatusCode(HttpResponseStatus.UNAUTHORIZED.code());
                }
                event.response().end();
                return;
            }
        }
        catch (IllegalStateException e) {
            if (!event.response().ended()) {
                event.response().end();
            }
            return;
        }
        if (!event.response().headWritten()) {
            event.response().setStatusCode(event.statusCode() > 0 ? event.statusCode() : 500);
        }
        String uuid = BASE_ID + ERROR_COUNT.incrementAndGet();
        String stack = "";
        Throwable exception = event.failure();
        String responseContentType = null;
        try {
            responseContentType = ContentTypes.pickFirstSupportedAndAcceptedContentType(event);
        }
        catch (RuntimeException e) {
            exception.addSuppressed(e);
        }
        if (this.showStack && exception != null) {
            details = QuarkusErrorHandler.generateHeaderMessage(exception, uuid);
            stack = QuarkusErrorHandler.generateStackTrace(exception);
        } else {
            details = QuarkusErrorHandler.generateHeaderMessage(uuid);
        }
        if (event.failure() instanceof IOException) {
            log.debugf(exception, "IOError processing HTTP request to %s failed, the client likely terminated the connection. Error id: %s", (Object)event.request().uri(), (Object)uuid);
        } else {
            log.errorf(exception, "HTTP Request to %s failed, error id: %s", (Object)event.request().uri(), (Object)uuid);
        }
        if (event.response().ended()) {
            return;
        }
        if (event.response().headWritten()) {
            event.response().end();
            return;
        }
        if (responseContentType == null) {
            responseContentType = "";
        }
        block10 : switch (responseContentType) {
            case "text/html": 
            case "application/xhtml+xml": 
            case "application/xml": 
            case "text/xml": {
                this.htmlResponse(event, details, exception);
                break;
            }
            case "application/json": 
            case "text/json": {
                this.jsonResponse(event, responseContentType, details, stack);
                break;
            }
            default: {
                switch (this.contentTypeDefault.orElse(HttpConfiguration.PayloadHint.JSON)) {
                    case HTML: {
                        this.htmlResponse(event, details, exception);
                        break block10;
                    }
                }
                this.jsonResponse(event, "application/json", details, stack);
            }
        }
    }

    private void jsonResponse(RoutingContext event, String contentType, String details, String stack) {
        event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)(contentType + "; charset=utf-8"));
        String escapedDetails = QuarkusErrorHandler.escapeJsonString(details);
        String escapedStack = QuarkusErrorHandler.escapeJsonString(stack);
        StringBuilder jsonPayload = new StringBuilder("{\"details\":\"").append(escapedDetails).append("\",\"stack\":\"").append(escapedStack).append("\"}");
        this.writeResponse(event, jsonPayload.toString());
    }

    private void htmlResponse(RoutingContext event, String details, Throwable exception) {
        event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8");
        TemplateHtmlBuilder htmlBuilder = new TemplateHtmlBuilder("Internal Server Error", details, details);
        if (this.showStack && exception != null) {
            htmlBuilder.stack(exception);
        }
        this.writeResponse(event, htmlBuilder.toString());
    }

    private void writeResponse(RoutingContext event, String output) {
        if (!event.response().ended()) {
            event.response().end(output);
        }
    }

    private static String generateStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().trim();
    }

    private static String generateHeaderMessage(Throwable exception, String uuid) {
        return String.format("Error id %s, %s: %s", uuid, exception.getClass().getName(), QuarkusErrorHandler.extractFirstLine(exception.getMessage()));
    }

    private static String generateHeaderMessage(String uuid) {
        return String.format("Error id %s", uuid);
    }

    private static String extractFirstLine(String message) {
        if (null == message) {
            return "";
        }
        String[] lines = message.split("\\r?\\n");
        return lines[0].trim();
    }

    static String escapeJsonString(String text) {
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static final class ContentTypes {
        private static final String APPLICATION_JSON = "application/json";
        private static final String TEXT_JSON = "text/json";
        private static final String TEXT_HTML = "text/html";
        private static final String APPLICATION_XHTML = "application/xhtml+xml";
        private static final String APPLICATION_XML = "application/xml";
        private static final String TEXT_XML = "text/xml";
        private static final Collection<MIMEHeader> SUPPORTED = Arrays.asList(new ParsableMIMEValue("application/json").forceParse(), new ParsableMIMEValue("text/json").forceParse(), new ParsableMIMEValue("text/html").forceParse(), new ParsableMIMEValue("application/xhtml+xml").forceParse(), new ParsableMIMEValue("application/xml").forceParse(), new ParsableMIMEValue("text/xml").forceParse());

        private ContentTypes() {
        }

        static String pickFirstSupportedAndAcceptedContentType(RoutingContext context) {
            List acceptableTypes = context.parsedHeaders().accept();
            MIMEHeader result = context.parsedHeaders().findBestUserAcceptedIn(acceptableTypes, SUPPORTED);
            return result == null ? null : result.value();
        }
    }
}

