/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.locationtech.jts.operation.union.InputExtracter;
import org.locationtech.jts.operation.union.PointGeometryUnion;

public class UnaryUnionOp {
    private GeometryFactory geomFact = null;
    private InputExtracter extracter;

    public static Geometry union(Collection geoms) {
        UnaryUnionOp op = new UnaryUnionOp(geoms);
        return op.union();
    }

    public static Geometry union(Collection geoms, GeometryFactory geomFact) {
        UnaryUnionOp op = new UnaryUnionOp(geoms, geomFact);
        return op.union();
    }

    public static Geometry union(Geometry geom) {
        UnaryUnionOp op = new UnaryUnionOp(geom);
        return op.union();
    }

    public UnaryUnionOp(Collection geoms, GeometryFactory geomFact) {
        this.geomFact = geomFact;
        this.extract(geoms);
    }

    public UnaryUnionOp(Collection geoms) {
        this.extract(geoms);
    }

    public UnaryUnionOp(Geometry geom) {
        this.extract(geom);
    }

    private void extract(Collection geoms) {
        this.extracter = InputExtracter.extract(geoms);
    }

    private void extract(Geometry geom) {
        this.extracter = InputExtracter.extract(geom);
    }

    public Geometry union() {
        if (this.geomFact == null) {
            this.geomFact = this.extracter.getFactory();
        }
        if (this.geomFact == null) {
            return null;
        }
        if (this.extracter.isEmpty()) {
            return this.geomFact.createEmpty(this.extracter.getDimension());
        }
        List points = this.extracter.getExtract(0);
        List lines = this.extracter.getExtract(1);
        List polygons = this.extracter.getExtract(2);
        Geometry unionPoints = null;
        if (points.size() > 0) {
            Geometry ptGeom = this.geomFact.buildGeometry(points);
            unionPoints = this.unionNoOpt(ptGeom);
        }
        Geometry unionLines = null;
        if (lines.size() > 0) {
            Geometry lineGeom = this.geomFact.buildGeometry(lines);
            unionLines = this.unionNoOpt(lineGeom);
        }
        Geometry unionPolygons = null;
        if (polygons.size() > 0) {
            unionPolygons = CascadedPolygonUnion.union(polygons);
        }
        Geometry unionLA = this.unionWithNull(unionLines, unionPolygons);
        Geometry union = null;
        union = unionPoints == null ? unionLA : (unionLA == null ? unionPoints : PointGeometryUnion.union((Puntal)((Object)unionPoints), unionLA));
        if (union == null) {
            return this.geomFact.createGeometryCollection();
        }
        return union;
    }

    private Geometry unionWithNull(Geometry g0, Geometry g1) {
        if (g0 == null && g1 == null) {
            return null;
        }
        if (g1 == null) {
            return g0;
        }
        if (g0 == null) {
            return g1;
        }
        return g0.union(g1);
    }

    private Geometry unionNoOpt(Geometry g0) {
        Point empty = this.geomFact.createPoint();
        return SnapIfNeededOverlayOp.overlayOp(g0, empty, 2);
    }
}

