/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.init;

import io.quarkus.runtime.PreventFurtherStepsException;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.annotations.Recorder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.ConfigProvider;

@Recorder
public class InitializationTaskRecorder {
    private static final String QUARKUS_INIT_AND_EXIT = "quarkus.init-and-exit";

    public void exitIfNeeded() {
        boolean initAndExitConfigured = StreamSupport.stream(ConfigProvider.getConfig().getPropertyNames().spliterator(), false).anyMatch(n -> QUARKUS_INIT_AND_EXIT.equals(n));
        if (initAndExitConfigured && ((Boolean)ConfigProvider.getConfig().getValue(QUARKUS_INIT_AND_EXIT, Boolean.TYPE)).booleanValue()) {
            InitializationTaskRecorder.preventFurtherRecorderSteps(5, "Error attempting to gracefully shutdown after initialization", () -> new PreventFurtherStepsException("Gracefully exiting after initialization.", 0));
        }
    }

    public static void preventFurtherRecorderSteps(int waitSeconds, String waitErrorMessage, Supplier<PreventFurtherStepsException> supplier) {
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Quarkus.blockingExit();
                latch.countDown();
            }
        }).start();
        try {
            latch.await(waitSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.err.println(waitErrorMessage);
        }
        throw supplier.get();
    }
}

