/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.clientscope.MapClientScopeAdapter;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.InvalidationHandler;

public class MapClientScopeProvider
implements ClientScopeProvider {
    private static final Logger LOG = Logger.getLogger(MapClientScopeProvider.class);
    private final KeycloakSession session;
    private final MapStorage<MapClientScopeEntity, ClientScopeModel> store;
    private final boolean storeHasRealmId;

    public MapClientScopeProvider(KeycloakSession session, MapStorage<MapClientScopeEntity, ClientScopeModel> clientScopeStore) {
        this.session = session;
        this.store = clientScopeStore;
        this.storeHasRealmId = this.store instanceof HasRealmId;
    }

    private Function<MapClientScopeEntity, ClientScopeModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapClientScopeAdapter(this.session, realm, (MapClientScopeEntity)origEntity);
    }

    private MapStorage<MapClientScopeEntity, ClientScopeModel> storeWithRealm(RealmModel realm) {
        if (this.storeHasRealmId) {
            ((HasRealmId)((Object)this.store)).setRealmId(realm == null ? null : realm.getId());
        }
        return this.store;
    }

    private Predicate<MapClientScopeEntity> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return c -> false;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public Stream<ClientScopeModel> getClientScopesStream(RealmModel realm) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(ClientScopeModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb).orderBy(ClientScopeModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }

    public ClientScopeModel addClientScope(RealmModel realm, String id, String name) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(ClientScopeModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(ClientScopeModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        if (this.storeWithRealm(realm).exists(QueryParameters.withCriteria(mcb))) {
            throw new ModelDuplicateException("Client scope with name '" + name + "' in realm " + realm.getName());
        }
        if (id != null && this.storeWithRealm(realm).exists(id)) {
            throw new ModelDuplicateException("Client scope exists: " + id);
        }
        LOG.tracef("addClientScope(%s, %s, %s)%s", new Object[]{realm, id, name, StackUtil.getShortStackTrace()});
        MapClientScopeEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapClientScopeEntity.class);
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setName(KeycloakModelUtils.convertClientScopeName((String)name));
        entity = this.storeWithRealm(realm).create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public boolean removeClientScope(RealmModel realm, String id) {
        if (id == null) {
            return false;
        }
        ClientScopeModel clientScope = this.getClientScopeById(realm, id);
        if (clientScope == null) {
            return false;
        }
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.CLIENT_SCOPE_BEFORE_REMOVE, new Object[]{realm, clientScope});
        this.storeWithRealm(realm).delete(id);
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.CLIENT_SCOPE_AFTER_REMOVE, new Object[]{clientScope});
        return true;
    }

    public void removeClientScopes(RealmModel realm) {
        LOG.tracef("removeClients(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.getClientScopesStream(realm).map(ClientScopeModel::getId).collect(Collectors.toSet()).forEach(id -> this.removeClientScope(realm, (String)id));
    }

    public ClientScopeModel getClientScopeById(RealmModel realm, String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getClientScopeById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapClientScopeEntity entity = this.storeWithRealm(realm).read(id);
        return entity == null || !this.entityRealmFilter(realm).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(ClientScopeModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.storeWithRealm(realm).delete(QueryParameters.withCriteria(mcb));
    }

    public void close() {
    }
}

