/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.OCSPBasicResponse;
import org.jruby.ext.openssl.OCSPCertificateId;
import org.jruby.ext.openssl.OCSPRequest;
import org.jruby.ext.openssl.OCSPResponse;
import org.jruby.ext.openssl.OCSPSingleResponse;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.builtin.IRubyObject;

public class OCSP {
    private static final String _RESPONSE_STATUS_SUCCESSFUL_STR = "RESPONSE_STATUS_SUCCESSFUL";
    private static final int _RESPONSE_STATUS_SUCCESSFUL = 0;
    private static final String _RESPONSE_STATUS_MALFORMEDREQUEST_STR = "RESPONSE_STATUS_MALFORMEDREQUEST";
    private static final int _RESPONSE_STATUS_MALFORMEDREQUEST = 1;
    private static final String _RESPONSE_STATUS_INTERNALERROR_STR = "RESPONSE_STATUS_INTERNALERROR";
    private static final int _RESPONSE_STATUS_INTERNALERROR = 2;
    private static final String _RESPONSE_STATUS_TRYLATER_STR = "RESPONSE_STATUS_TRYLATER";
    private static final int _RESPONSE_STATUS_TRYLATER = 3;
    private static final String _RESPONSE_STATUS_SIGREQUIRED_STR = "RESPONSE_STATUS_SIGREQUIRED";
    private static final int _RESPONSE_STATUS_SIGREQUIRED = 5;
    private static final String _RESPONSE_STATUS_UNAUTHORIZED_STR = "RESPONSE_STATUS_UNAUTHORIZED";
    private static final int _RESPONSE_STATUS_UNAUTHORIZED = 6;
    private static final Map<Integer, String> responseMap;
    private static final int _REVOKED_STATUS_NOSTATUS = -1;
    private static final int _REVOKED_STATUS_UNSPECIFIED = 0;
    private static final int _REVOKED_STATUS_KEYCOMPROMISE = 1;
    private static final int _REVOKED_STATUS_CACOMPROMISE = 2;
    private static final int _REVOKED_STATUS_AFFILIATIONCHANGED = 3;
    private static final int _REVOKED_STATUS_SUPERSEDED = 4;
    private static final int _REVOKED_STATUS_CESSATIONOFOPERATION = 5;
    private static final int _REVOKED_STATUS_CERTIFICATEHOLD = 6;
    private static final int _REVOKED_STATUS_REMOVEFROMCRL = 8;
    private static final int _NOCERTS = 1;
    private static final int _NOINTERN = 2;
    private static final int _NOSIGS = 4;
    private static final int _NOCHAIN = 8;
    private static final int _NOVERIFY = 16;
    private static final int _NOEXPLICIT = 32;
    private static final int _NOCASIGN = 64;
    private static final int _NODELEGATED = 128;
    private static final int _NOCHECKS = 256;
    private static final int _TRUSTOTHER = 512;
    private static final int _RESPID_KEY = 1024;
    private static final int _NOTIME = 2048;
    private static final int _V_CERTSTATUS_GOOD = 0;
    private static final int _V_CERTSTATUS_REVOKED = 1;
    private static final int _V_CERTSTATUS_UNKNOWN = 2;
    private static final int _V_RESPID_NAME = 0;
    private static final int _V_RESPID_KEY = 1;

    static void createOCSP(Ruby runtime, RubyModule OpenSSL2, RubyClass OpenSSLError) {
        RubyModule OCSP2 = OpenSSL2.defineModuleUnder("OCSP");
        OCSP2.defineClassUnder("OCSPError", OpenSSLError, OpenSSLError.getAllocator());
        OCSPBasicResponse.createBasicResponse(runtime, OCSP2);
        OCSPCertificateId.createCertificateId(runtime, OCSP2);
        OCSPRequest.createRequest(runtime, OCSP2);
        OCSPResponse.createResponse(runtime, OCSP2);
        OCSPSingleResponse.createSingleResponse(runtime, OCSP2);
        OCSP2.setConstant(_RESPONSE_STATUS_SUCCESSFUL_STR, (IRubyObject)runtime.newFixnum(0));
        OCSP2.setConstant(_RESPONSE_STATUS_MALFORMEDREQUEST_STR, (IRubyObject)runtime.newFixnum(1));
        OCSP2.setConstant(_RESPONSE_STATUS_INTERNALERROR_STR, (IRubyObject)runtime.newFixnum(2));
        OCSP2.setConstant(_RESPONSE_STATUS_TRYLATER_STR, (IRubyObject)runtime.newFixnum(3));
        OCSP2.setConstant(_RESPONSE_STATUS_SIGREQUIRED_STR, (IRubyObject)runtime.newFixnum(5));
        OCSP2.setConstant(_RESPONSE_STATUS_UNAUTHORIZED_STR, (IRubyObject)runtime.newFixnum(6));
        OCSP2.setConstant("REVOKED_STATUS_NOSTATUS", (IRubyObject)runtime.newFixnum(-1));
        OCSP2.setConstant("REVOKED_STATUS_UNSPECIFIED", (IRubyObject)runtime.newFixnum(0));
        OCSP2.setConstant("REVOKED_STATUS_KEYCOMPROMISE", (IRubyObject)runtime.newFixnum(1));
        OCSP2.setConstant("REVOKED_STATUS_CACOMPROMISE", (IRubyObject)runtime.newFixnum(2));
        OCSP2.setConstant("REVOKED_STATUS_AFFILIATIONCHANGED", (IRubyObject)runtime.newFixnum(3));
        OCSP2.setConstant("REVOKED_STATUS_SUPERSEDED", (IRubyObject)runtime.newFixnum(4));
        OCSP2.setConstant("REVOKED_STATUS_CESSATIONOFOPERATION", (IRubyObject)runtime.newFixnum(5));
        OCSP2.setConstant("REVOKED_STATUS_CERTIFICATEHOLD", (IRubyObject)runtime.newFixnum(6));
        OCSP2.setConstant("REVOKED_STATUS_REMOVEFROMCRL", (IRubyObject)runtime.newFixnum(8));
        OCSP2.setConstant("NOCERTS", (IRubyObject)runtime.newFixnum(1));
        OCSP2.setConstant("NOINTERN", (IRubyObject)runtime.newFixnum(2));
        OCSP2.setConstant("NOSIGS", (IRubyObject)runtime.newFixnum(4));
        OCSP2.setConstant("NOCHAIN", (IRubyObject)runtime.newFixnum(8));
        OCSP2.setConstant("NOVERIFY", (IRubyObject)runtime.newFixnum(16));
        OCSP2.setConstant("NOEXPLICIT", (IRubyObject)runtime.newFixnum(32));
        OCSP2.setConstant("NOCASIGN", (IRubyObject)runtime.newFixnum(64));
        OCSP2.setConstant("NODELEGATED", (IRubyObject)runtime.newFixnum(128));
        OCSP2.setConstant("NOCHECKS", (IRubyObject)runtime.newFixnum(256));
        OCSP2.setConstant("TRUSTOTHER", (IRubyObject)runtime.newFixnum(512));
        OCSP2.setConstant("RESPID_KEY", (IRubyObject)runtime.newFixnum(1024));
        OCSP2.setConstant("NOTIME", (IRubyObject)runtime.newFixnum(2048));
        OCSP2.setConstant("V_CERTSTATUS_GOOD", (IRubyObject)runtime.newFixnum(0));
        OCSP2.setConstant("V_CERTSTATUS_REVOKED", (IRubyObject)runtime.newFixnum(1));
        OCSP2.setConstant("V_CERTSTATUS_UNKNOWN", (IRubyObject)runtime.newFixnum(2));
        OCSP2.setConstant("V_RESPID_NAME", (IRubyObject)runtime.newFixnum(0));
        OCSP2.setConstant("V_RESPID_KEY", (IRubyObject)runtime.newFixnum(1));
    }

    public static String getResponseStringForValue(IRubyObject fixnum) {
        RubyFixnum rubyFixnum = (RubyFixnum)fixnum;
        return responseMap.get((int)rubyFixnum.getLongValue());
    }

    static RaiseException newOCSPError(Ruby runtime, Exception ex) {
        return Utils.newError(runtime, OCSP._OCSP(runtime).getClass("OCSPError"), ex);
    }

    static RubyModule _OCSP(Ruby runtime) {
        return (RubyModule)runtime.getModule("OpenSSL").getConstant("OCSP");
    }

    static byte[] generateNonce(Ruby runtime) {
        return OCSP.generateNonce(runtime, new byte[16]);
    }

    static byte[] generateNonce(Ruby runtime, byte[] bytes) {
        OpenSSL.getSecureRandom(runtime).nextBytes(bytes);
        return bytes;
    }

    static JcaContentSignerBuilder newJcaContentSignerBuilder(String alg) {
        JcaContentSignerBuilder builder = new JcaContentSignerBuilder(alg);
        if (SecurityHelper.isProviderAvailable("BC")) {
            builder.setProvider("BC");
        } else {
            builder.setProvider(SecurityHelper.getSecurityProvider());
        }
        return builder;
    }

    static JcaContentVerifierProviderBuilder newJcaContentVerifierProviderBuilder() {
        JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder();
        if (SecurityHelper.isProviderAvailable("BC")) {
            builder.setProvider("BC");
        } else {
            builder.setProvider(SecurityHelper.getSecurityProvider());
        }
        return builder;
    }

    static JcaDigestCalculatorProviderBuilder newJcaDigestCalculatorProviderBuilder() {
        JcaDigestCalculatorProviderBuilder builder = new JcaDigestCalculatorProviderBuilder();
        if (SecurityHelper.isProviderAvailable("BC")) {
            builder.setProvider("BC");
        } else {
            builder.setProvider(SecurityHelper.getSecurityProvider());
        }
        return builder;
    }

    static {
        HashMap<Integer, String> resMap = new HashMap<Integer, String>(8, 1.0f);
        resMap.put(0, _RESPONSE_STATUS_SUCCESSFUL_STR);
        resMap.put(1, _RESPONSE_STATUS_MALFORMEDREQUEST_STR);
        resMap.put(2, _RESPONSE_STATUS_INTERNALERROR_STR);
        resMap.put(3, _RESPONSE_STATUS_TRYLATER_STR);
        resMap.put(5, _RESPONSE_STATUS_SIGREQUIRED_STR);
        resMap.put(6, _RESPONSE_STATUS_UNAUTHORIZED_STR);
        responseMap = resMap;
    }
}

