/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.FileLockFactory;
import org.logstash.LockException;
import org.logstash.ackedqueue.Batch;
import org.logstash.ackedqueue.Checkpoint;
import org.logstash.ackedqueue.Page;
import org.logstash.ackedqueue.PageFactory;
import org.logstash.ackedqueue.QueueRuntimeException;
import org.logstash.ackedqueue.QueueUpgrade;
import org.logstash.ackedqueue.Queueable;
import org.logstash.ackedqueue.SequencedList;
import org.logstash.ackedqueue.Settings;
import org.logstash.ackedqueue.io.CheckpointIO;
import org.logstash.ackedqueue.io.FileCheckpointIO;
import org.logstash.ackedqueue.io.MmapPageIOV2;
import org.logstash.ackedqueue.io.PageIO;
import org.logstash.common.FsUtil;

public final class Queue
implements Closeable {
    private long seqNum;
    protected Page headPage;
    protected final List<Page> tailPages;
    protected final List<Page> unreadTailPages;
    protected volatile long unreadCount;
    private final CheckpointIO checkpointIO;
    private final int pageCapacity;
    private final long maxBytes;
    private final Path dirPath;
    private final int maxUnread;
    private final int checkpointMaxAcks;
    private final int checkpointMaxWrites;
    private final AtomicBoolean closed;
    private final Class<? extends Queueable> elementClass;
    private final Method deserializeMethod;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final Condition notEmpty = this.lock.newCondition();
    private FileLock dirLock;
    private static final String LOCK_NAME = ".lock";
    private static final Logger logger = LogManager.getLogger(Queue.class);

    public Queue(Settings settings) {
        try {
            Path queueDir = Paths.get(settings.getDirPath(), new String[0]);
            if (!Files.exists(queueDir, new LinkOption[0])) {
                Files.createDirectories(queueDir, new FileAttribute[0]);
            }
            this.dirPath = queueDir.toRealPath(new LinkOption[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        this.pageCapacity = settings.getCapacity();
        this.maxBytes = settings.getQueueMaxBytes();
        this.checkpointIO = new FileCheckpointIO(this.dirPath, settings.getCheckpointRetry());
        this.elementClass = settings.getElementClass();
        this.tailPages = new ArrayList<Page>();
        this.unreadTailPages = new ArrayList<Page>();
        this.closed = new AtomicBoolean(true);
        this.maxUnread = settings.getMaxUnread();
        this.checkpointMaxAcks = settings.getCheckpointMaxAcks();
        this.checkpointMaxWrites = settings.getCheckpointMaxWrites();
        this.unreadCount = 0L;
        try {
            Class[] cArg = new Class[]{byte[].class};
            this.deserializeMethod = this.elementClass.getDeclaredMethod("deserialize", cArg);
        }
        catch (NoSuchMethodException e) {
            throw new QueueRuntimeException("cannot find deserialize method on class " + this.elementClass.getName(), e);
        }
    }

    public String getDirPath() {
        return this.dirPath.toString();
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public long getMaxUnread() {
        return this.maxUnread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPersistedByteSize() {
        this.lock.lock();
        try {
            long size = this.headPage == null ? 0L : (long)this.headPage.getPageIO().getHead() + this.tailPages.stream().mapToLong(p -> p.getPageIO().getHead()).sum();
            long l = size;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPageCapacity() {
        return this.pageCapacity;
    }

    public long getUnreadCount() {
        return this.unreadCount;
    }

    public void open() throws IOException {
        if (!this.closed.get()) {
            throw new IOException("queue already opened");
        }
        this.lock.lock();
        try {
            try {
                this.dirLock = FileLockFactory.obtainLock(this.dirPath, LOCK_NAME);
            }
            catch (LockException e) {
                throw new LockException("The queue failed to obtain exclusive access, cause: " + e.getMessage());
            }
            try {
                this.openPages();
                this.closed.set(false);
            }
            catch (IOException e) {
                this.releaseLockAndSwallow();
                throw e;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void openPages() throws IOException {
        Checkpoint headCheckpoint;
        QueueUpgrade.upgradeQueueDirectoryToV2(this.dirPath);
        try {
            headCheckpoint = this.checkpointIO.read(this.checkpointIO.headFileName());
        }
        catch (NoSuchFileException e) {
            logger.debug("No head checkpoint found at: {}, creating new head page", (Object)this.checkpointIO.headFileName());
            this.ensureDiskAvailable(this.maxBytes, 0L);
            this.seqNum = 0L;
            int headPageNum = 0;
            this.newCheckpointedHeadpage(headPageNum);
            this.closed.set(false);
            return;
        }
        long pqSizeBytes = 0L;
        for (int pageNum = headCheckpoint.getFirstUnackedPageNum(); pageNum < headCheckpoint.getPageNum(); ++pageNum) {
            String cpFileName = this.checkpointIO.tailFileName(pageNum);
            if (!this.dirPath.resolve(cpFileName).toFile().exists()) continue;
            Checkpoint cp = this.checkpointIO.read(cpFileName);
            logger.debug("opening tail page: {}, in: {}, with checkpoint: {}", (Object)pageNum, (Object)this.dirPath, (Object)cp);
            MmapPageIOV2 pageIO = new MmapPageIOV2(pageNum, this.pageCapacity, this.dirPath);
            if (cp.isFullyAcked()) {
                this.purgeTailPage(cp, pageIO);
            } else {
                pageIO.open(cp.getMinSeqNum(), cp.getElementCount());
                this.addTailPage(PageFactory.newTailPage(cp, this, pageIO));
                pqSizeBytes += (long)pageIO.getCapacity();
            }
            if (cp.maxSeqNum() <= this.seqNum) continue;
            this.seqNum = cp.maxSeqNum();
        }
        if (this.cleanedUpFullyAckedCorruptedPage(headCheckpoint, pqSizeBytes)) {
            return;
        }
        logger.debug("opening head page: {}, in: {}, with checkpoint: {}", (Object)headCheckpoint.getPageNum(), (Object)this.dirPath, (Object)headCheckpoint);
        MmapPageIOV2 pageIO = new MmapPageIOV2(headCheckpoint.getPageNum(), this.pageCapacity, this.dirPath);
        pageIO.recover();
        this.ensureDiskAvailable(this.maxBytes, pqSizeBytes += (long)pageIO.getHead());
        if (pageIO.getMinSeqNum() != headCheckpoint.getMinSeqNum() || pageIO.getElementCount() != headCheckpoint.getElementCount()) {
            logger.warn("recovered head data page {} is different than checkpoint, using recovered page information", (Object)headCheckpoint.getPageNum());
            logger.debug("head checkpoint minSeqNum={} or elementCount={} is different than head pageIO minSeqNum={} or elementCount={}", (Object)headCheckpoint.getMinSeqNum(), (Object)headCheckpoint.getElementCount(), (Object)pageIO.getMinSeqNum(), (Object)pageIO.getElementCount());
            long firstUnackedSeqNum = headCheckpoint.getFirstUnackedSeqNum();
            if (firstUnackedSeqNum < pageIO.getMinSeqNum()) {
                logger.debug("head checkpoint firstUnackedSeqNum={} is < head pageIO minSeqNum={}, using pageIO minSeqNum", (Object)firstUnackedSeqNum, (Object)pageIO.getMinSeqNum());
                firstUnackedSeqNum = pageIO.getMinSeqNum();
            }
            headCheckpoint = new Checkpoint(headCheckpoint.getPageNum(), headCheckpoint.getFirstUnackedPageNum(), firstUnackedSeqNum, pageIO.getMinSeqNum(), pageIO.getElementCount());
        }
        this.headPage = PageFactory.newHeadPage(headCheckpoint, this, (PageIO)pageIO);
        if (this.headPage.getMinSeqNum() <= 0L && this.headPage.getElementCount() <= 0) {
            this.headPage.checkpoint();
        } else {
            this.headPage.behead();
            if (headCheckpoint.isFullyAcked()) {
                this.purgeTailPage(headCheckpoint, pageIO);
            } else {
                this.addTailPage(this.headPage);
            }
            if (headCheckpoint.maxSeqNum() > this.seqNum) {
                this.seqNum = headCheckpoint.maxSeqNum();
            }
            int headPageNum = headCheckpoint.getPageNum() + 1;
            this.newCheckpointedHeadpage(headPageNum);
        }
        if (this.tailPages.size() > 0) {
            this.tailPages.get(0).getPageIO().activate();
        }
    }

    private boolean cleanedUpFullyAckedCorruptedPage(Checkpoint headCheckpoint, long pqSizeBytes) throws IOException {
        MmapPageIOV2 pageIO;
        if (headCheckpoint.isFullyAcked() && (pageIO = new MmapPageIOV2(headCheckpoint.getPageNum(), this.pageCapacity, this.dirPath)).isCorruptedPage()) {
            logger.debug("Queue is fully acked. Found zero byte page.{}. Recreate checkpoint.head and delete corrupted page", (Object)headCheckpoint.getPageNum());
            this.checkpointIO.purge(this.checkpointIO.headFileName());
            pageIO.purge();
            if (headCheckpoint.maxSeqNum() > this.seqNum) {
                this.seqNum = headCheckpoint.maxSeqNum();
            }
            this.newCheckpointedHeadpage(headCheckpoint.getPageNum() + 1);
            this.ensureDiskAvailable(this.maxBytes, pqSizeBytes += (long)pageIO.getHead());
            return true;
        }
        return false;
    }

    private void purgeTailPage(Checkpoint checkpoint, PageIO pageIO) throws IOException {
        try {
            pageIO.purge();
        }
        catch (NoSuchFileException e) {
            logger.debug("tail page does not exist: {}", (Object)pageIO);
        }
        if (this.tailPages.size() == 0) {
            this.checkpointIO.purge(this.checkpointIO.tailFileName(checkpoint.getPageNum()));
        }
    }

    private void addTailPage(Page page) throws IOException {
        this.tailPages.add(page);
        this.unreadTailPages.add(page);
        this.unreadCount += page.unreadCount();
        page.getPageIO().deactivate();
    }

    private void newCheckpointedHeadpage(int pageNum) throws IOException {
        MmapPageIOV2 headPageIO = new MmapPageIOV2(pageNum, this.pageCapacity, this.dirPath);
        headPageIO.create();
        logger.debug("created new head page: {}", (Object)headPageIO);
        this.headPage = PageFactory.newHeadPage(pageNum, this, (PageIO)headPageIO);
        this.headPage.forceCheckpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(Queueable element) throws IOException {
        byte[] data = element.serialize();
        this.lock.lock();
        try {
            if (!this.headPage.hasCapacity(data.length)) {
                throw new IOException("data to be written is bigger than page capacity");
            }
            if (!this.headPage.hasSpace(data.length)) {
                int newHeadPageNum = this.headPage.pageNum + 1;
                if (this.headPage.isFullyAcked()) {
                    this.headPage.purge();
                } else {
                    this.behead();
                }
                this.newCheckpointedHeadpage(newHeadPageNum);
            }
            long seqNum = ++this.seqNum;
            this.headPage.write(data, seqNum, this.checkpointMaxWrites);
            ++this.unreadCount;
            this.notEmpty.signal();
            while (this.isFull() && !this.isClosed()) {
                try {
                    this.notFull.await();
                }
                catch (InterruptedException e) {
                    logger.debug("interrupted waiting for queue to not be full", (Throwable)e);
                    Thread.currentThread().interrupt();
                    long l = seqNum;
                    this.lock.unlock();
                    return l;
                }
            }
            long l = seqNum;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void behead() throws IOException {
        this.headPage.behead();
        this.tailPages.add(this.headPage);
        if (!this.headPage.isFullyRead()) {
            if (!this.unreadTailPages.isEmpty()) {
                this.headPage.deactivate();
            }
            this.unreadTailPages.add(this.headPage);
        } else {
            this.headPage.deactivate();
        }
    }

    public boolean isFull() {
        this.lock.lock();
        try {
            boolean bl = this.isMaxBytesReached() || this.isMaxUnreadReached();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isMaxBytesReached() {
        if (this.maxBytes <= 0L) {
            return false;
        }
        long persistedByteSize = this.getPersistedByteSize();
        return persistedByteSize > this.maxBytes || persistedByteSize == this.maxBytes && !this.headPage.hasSpace(1);
    }

    private boolean isMaxUnreadReached() {
        return this.maxUnread > 0 && this.unreadCount >= (long)this.maxUnread;
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.tailPages.isEmpty() && this.headPage.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isFullyAcked() {
        this.lock.lock();
        try {
            boolean bl = this.tailPages.isEmpty() ? this.headPage.isFullyAcked() : false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void ensurePersistedUpto(long seqNum) throws IOException {
        this.lock.lock();
        try {
            this.headPage.ensurePersistedUpto(seqNum);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Batch nonBlockReadBatch(int limit) throws IOException {
        this.lock.lock();
        try {
            Page p = this.nextReadPage();
            Batch batch = this.isHeadPage(p) && p.isFullyRead() ? null : this.readPageBatch(p, limit, 0L);
            return batch;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Batch readBatch(int limit, long timeout) throws IOException {
        this.lock.lock();
        try {
            Batch batch = this.readPageBatch(this.nextReadPage(), limit, timeout);
            return batch;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Batch readPageBatch(Page p, int limit, long timeout) throws IOException {
        int left = limit;
        ArrayList<byte[]> elements = new ArrayList<byte[]>(limit);
        long firstSeqNum = -1L;
        while (left > 0) {
            if (this.isHeadPage(p) && p.isFullyRead()) {
                boolean elapsed;
                try {
                    elapsed = !this.notEmpty.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (elapsed && p.isFullyRead() || this.isClosed()) break;
            }
            if (!p.isFullyRead()) {
                boolean wasFull = this.isMaxUnreadReached();
                SequencedList<byte[]> serialized = p.read(left);
                int n = serialized.getElements().size();
                assert (n > 0) : "page read returned 0 elements";
                elements.addAll(serialized.getElements());
                if (firstSeqNum == -1L) {
                    firstSeqNum = serialized.getSeqNums().get(0);
                }
                this.unreadCount -= (long)n;
                left -= n;
                if (wasFull) {
                    this.notFull.signalAll();
                }
            }
            if (!this.isTailPage(p) || !p.isFullyRead()) continue;
        }
        if (this.isTailPage(p) && p.isFullyRead()) {
            this.removeUnreadPage(p);
        }
        return new Batch(elements, firstSeqNum, this);
    }

    private int binaryFindPageForSeqnum(long seqNum) {
        int lo = 0;
        int hi = this.tailPages.size() - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            Page p = this.tailPages.get(mid);
            long pMinSeq = p.getMinSeqNum();
            if (seqNum < pMinSeq) {
                hi = mid - 1;
                continue;
            }
            if (seqNum >= pMinSeq + (long)p.getElementCount()) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        throw new IllegalArgumentException(String.format("Sequence number %d not found in any page", seqNum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(long firstAckSeqNum, int ackCount) throws IOException {
        this.lock.lock();
        try {
            if (Queue.containsSeq(this.headPage, firstAckSeqNum)) {
                this.headPage.ack(firstAckSeqNum, ackCount, this.checkpointMaxAcks);
            } else {
                int resultIndex = this.binaryFindPageForSeqnum(firstAckSeqNum);
                if (this.tailPages.get(resultIndex).ack(firstAckSeqNum, ackCount, this.checkpointMaxAcks)) {
                    this.tailPages.remove(resultIndex);
                    this.notFull.signalAll();
                }
                this.headPage.checkpoint();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public CheckpointIO getCheckpointIO() {
        return this.checkpointIO;
    }

    public Queueable deserialize(byte[] bytes) {
        try {
            return (Queueable)this.deserializeMethod.invoke(this.elementClass, new Object[]{bytes});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new QueueRuntimeException("deserialize invocation error", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            this.lock.lock();
            try {
                this.ensurePersistedUpto(this.seqNum);
                for (Page p : this.tailPages) {
                    p.close();
                }
                this.headPage.close();
                this.tailPages.clear();
                this.unreadTailPages.clear();
                this.headPage = null;
                this.notEmpty.signalAll();
                this.notFull.signalAll();
            }
            finally {
                this.releaseLockAndSwallow();
                this.lock.unlock();
            }
        }
    }

    private void releaseLockAndSwallow() {
        try {
            FileLockFactory.releaseLock(this.dirLock);
        }
        catch (IOException e) {
            logger.error("Queue close releaseLock failed, error={}", (Object)e.getMessage());
        }
    }

    public Page nextReadPage() {
        this.lock.lock();
        try {
            Page page = this.unreadTailPages.isEmpty() ? this.headPage : this.unreadTailPages.get(0);
            return page;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeUnreadPage(Page p) {
        if (!this.unreadTailPages.isEmpty()) {
            Page firstUnread = this.unreadTailPages.get(0);
            assert (p.pageNum <= firstUnread.pageNum) : String.format("fully read pageNum=%d is greater than first unread pageNum=%d", p.pageNum, firstUnread.pageNum);
            if (firstUnread == p) {
                this.unreadTailPages.remove(0);
            }
        }
    }

    public int firstUnackedPageNum() {
        this.lock.lock();
        try {
            if (this.tailPages.isEmpty()) {
                int n = this.headPage.getPageNum();
                return n;
            }
            int n = this.tailPages.get(0).getPageNum();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getAckedCount() {
        this.lock.lock();
        try {
            long l = (long)this.headPage.ackedSeqNums.cardinality() + this.tailPages.stream().mapToLong(page -> page.ackedSeqNums.cardinality()).sum();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnackedCount() {
        this.lock.lock();
        try {
            long headPageCount = this.headPage.getElementCount() - this.headPage.ackedSeqNums.cardinality();
            long tailPagesCount = this.tailPages.stream().mapToLong(page -> page.getElementCount() - page.ackedSeqNums.cardinality()).sum();
            long l = headPageCount + tailPagesCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isClosed() {
        return this.closed.get();
    }

    private boolean isHeadPage(Page p) {
        return p == this.headPage;
    }

    private boolean isTailPage(Page p) {
        return !this.isHeadPage(p);
    }

    private void ensureDiskAvailable(long maxPqSize, long currentPqSize) throws IOException {
        if (!FsUtil.hasFreeSpace(this.dirPath, maxPqSize - currentPqSize)) {
            throw new IOException(String.format("Unable to allocate %d more bytes for persisted queue on top of its current usage of %d bytes", maxPqSize - currentPqSize, currentPqSize));
        }
    }

    private static boolean containsSeq(Page page, long seqNum) {
        long pMinSeq = page.getMinSeqNum();
        long pMaxSeq = pMinSeq + (long)page.getElementCount();
        return seqNum >= pMinSeq && seqNum < pMaxSeq;
    }
}

