/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugUtilsObjectTagInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECTHANDLE;
    public static final int TAGNAME;
    public static final int TAGSIZE;
    public static final int PTAG;

    public VkDebugUtilsObjectTagInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDebugUtilsObjectTagInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugUtilsObjectTagInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugUtilsObjectTagInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkObjectType")
    public int objectType() {
        return VkDebugUtilsObjectTagInfoEXT.nobjectType(this.address());
    }

    @NativeType(value="uint64_t")
    public long objectHandle() {
        return VkDebugUtilsObjectTagInfoEXT.nobjectHandle(this.address());
    }

    @NativeType(value="uint64_t")
    public long tagName() {
        return VkDebugUtilsObjectTagInfoEXT.ntagName(this.address());
    }

    @NativeType(value="size_t")
    public long tagSize() {
        return VkDebugUtilsObjectTagInfoEXT.ntagSize(this.address());
    }

    @NativeType(value="void const *")
    public ByteBuffer pTag() {
        return VkDebugUtilsObjectTagInfoEXT.npTag(this.address());
    }

    public VkDebugUtilsObjectTagInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugUtilsObjectTagInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectTagInfoEXT sType$Default() {
        return this.sType(1000128001);
    }

    public VkDebugUtilsObjectTagInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugUtilsObjectTagInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectTagInfoEXT objectType(@NativeType(value="VkObjectType") int value) {
        VkDebugUtilsObjectTagInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectTagInfoEXT objectHandle(@NativeType(value="uint64_t") long value) {
        VkDebugUtilsObjectTagInfoEXT.nobjectHandle(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectTagInfoEXT tagName(@NativeType(value="uint64_t") long value) {
        VkDebugUtilsObjectTagInfoEXT.ntagName(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectTagInfoEXT pTag(@NativeType(value="void const *") ByteBuffer value) {
        VkDebugUtilsObjectTagInfoEXT.npTag(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectTagInfoEXT set(int sType, long pNext, int objectType, long objectHandle, long tagName, ByteBuffer pTag) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectType(objectType);
        this.objectHandle(objectHandle);
        this.tagName(tagName);
        this.pTag(pTag);
        return this;
    }

    public VkDebugUtilsObjectTagInfoEXT set(VkDebugUtilsObjectTagInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDebugUtilsObjectTagInfoEXT malloc() {
        return (VkDebugUtilsObjectTagInfoEXT)VkDebugUtilsObjectTagInfoEXT.wrap(VkDebugUtilsObjectTagInfoEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDebugUtilsObjectTagInfoEXT calloc() {
        return (VkDebugUtilsObjectTagInfoEXT)VkDebugUtilsObjectTagInfoEXT.wrap(VkDebugUtilsObjectTagInfoEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDebugUtilsObjectTagInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDebugUtilsObjectTagInfoEXT)VkDebugUtilsObjectTagInfoEXT.wrap(VkDebugUtilsObjectTagInfoEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDebugUtilsObjectTagInfoEXT create(long address) {
        return (VkDebugUtilsObjectTagInfoEXT)VkDebugUtilsObjectTagInfoEXT.wrap(VkDebugUtilsObjectTagInfoEXT.class, (long)address);
    }

    @Nullable
    public static VkDebugUtilsObjectTagInfoEXT createSafe(long address) {
        return address == 0L ? null : (VkDebugUtilsObjectTagInfoEXT)VkDebugUtilsObjectTagInfoEXT.wrap(VkDebugUtilsObjectTagInfoEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDebugUtilsObjectTagInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDebugUtilsObjectTagInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDebugUtilsObjectTagInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDebugUtilsObjectTagInfoEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDebugUtilsObjectTagInfoEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDebugUtilsObjectTagInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDebugUtilsObjectTagInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkDebugUtilsObjectTagInfoEXT mallocStack() {
        return VkDebugUtilsObjectTagInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugUtilsObjectTagInfoEXT callocStack() {
        return VkDebugUtilsObjectTagInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugUtilsObjectTagInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugUtilsObjectTagInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkDebugUtilsObjectTagInfoEXT callocStack(MemoryStack stack) {
        return VkDebugUtilsObjectTagInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDebugUtilsObjectTagInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDebugUtilsObjectTagInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsObjectTagInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsObjectTagInfoEXT.calloc(capacity, stack);
    }

    public static VkDebugUtilsObjectTagInfoEXT malloc(MemoryStack stack) {
        return (VkDebugUtilsObjectTagInfoEXT)VkDebugUtilsObjectTagInfoEXT.wrap(VkDebugUtilsObjectTagInfoEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugUtilsObjectTagInfoEXT calloc(MemoryStack stack) {
        return (VkDebugUtilsObjectTagInfoEXT)VkDebugUtilsObjectTagInfoEXT.wrap(VkDebugUtilsObjectTagInfoEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugUtilsObjectTagInfoEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugUtilsObjectTagInfoEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nobjectType(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTTYPE);
    }

    public static long nobjectHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)OBJECTHANDLE);
    }

    public static long ntagName(long struct) {
        return UNSAFE.getLong(null, struct + (long)TAGNAME);
    }

    public static long ntagSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TAGSIZE));
    }

    public static ByteBuffer npTag(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PTAG)), (int)((int)VkDebugUtilsObjectTagInfoEXT.ntagSize(struct)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nobjectType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTTYPE, value);
    }

    public static void nobjectHandle(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OBJECTHANDLE, value);
    }

    public static void ntagName(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TAGNAME, value);
    }

    public static void ntagSize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TAGSIZE), (long)value);
    }

    public static void npTag(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTAG), (long)MemoryUtil.memAddress((ByteBuffer)value));
        VkDebugUtilsObjectTagInfoEXT.ntagSize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PTAG)));
    }

    static {
        Struct.Layout layout = VkDebugUtilsObjectTagInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkDebugUtilsObjectTagInfoEXT.__member((int)4), VkDebugUtilsObjectTagInfoEXT.__member((int)POINTER_SIZE), VkDebugUtilsObjectTagInfoEXT.__member((int)4), VkDebugUtilsObjectTagInfoEXT.__member((int)8), VkDebugUtilsObjectTagInfoEXT.__member((int)8), VkDebugUtilsObjectTagInfoEXT.__member((int)POINTER_SIZE), VkDebugUtilsObjectTagInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECTHANDLE = layout.offsetof(3);
        TAGNAME = layout.offsetof(4);
        TAGSIZE = layout.offsetof(5);
        PTAG = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkDebugUtilsObjectTagInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDebugUtilsObjectTagInfoEXT ELEMENT_FACTORY = VkDebugUtilsObjectTagInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDebugUtilsObjectTagInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugUtilsObjectTagInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugUtilsObjectTagInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkObjectType")
        public int objectType() {
            return VkDebugUtilsObjectTagInfoEXT.nobjectType(this.address());
        }

        @NativeType(value="uint64_t")
        public long objectHandle() {
            return VkDebugUtilsObjectTagInfoEXT.nobjectHandle(this.address());
        }

        @NativeType(value="uint64_t")
        public long tagName() {
            return VkDebugUtilsObjectTagInfoEXT.ntagName(this.address());
        }

        @NativeType(value="size_t")
        public long tagSize() {
            return VkDebugUtilsObjectTagInfoEXT.ntagSize(this.address());
        }

        @NativeType(value="void const *")
        public ByteBuffer pTag() {
            return VkDebugUtilsObjectTagInfoEXT.npTag(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugUtilsObjectTagInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000128001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugUtilsObjectTagInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer objectType(@NativeType(value="VkObjectType") int value) {
            VkDebugUtilsObjectTagInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer objectHandle(@NativeType(value="uint64_t") long value) {
            VkDebugUtilsObjectTagInfoEXT.nobjectHandle(this.address(), value);
            return this;
        }

        public Buffer tagName(@NativeType(value="uint64_t") long value) {
            VkDebugUtilsObjectTagInfoEXT.ntagName(this.address(), value);
            return this;
        }

        public Buffer pTag(@NativeType(value="void const *") ByteBuffer value) {
            VkDebugUtilsObjectTagInfoEXT.npTag(this.address(), value);
            return this;
        }
    }
}

