/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.HashMap;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.AbstractMavenPluginParametersValidator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

@Singleton
@Named
class DeprecatedCoreExpressionValidator
extends AbstractMavenPluginParametersValidator {
    private static final HashMap<String, String> DEPRECATED_CORE_PARAMETERS;
    private static final String ARTIFACT_REPOSITORY_REASON = "Avoid use of ArtifactRepository type. If you need access to local repository, switch to '${repositorySystemSession}' expression and get LRM from it instead.";

    DeprecatedCoreExpressionValidator() {
    }

    @Override
    protected String getParameterLogReason(Parameter parameter) {
        return "is deprecated core expression; " + DEPRECATED_CORE_PARAMETERS.get(parameter.getDefaultValue());
    }

    @Override
    protected void doValidate(MojoDescriptor mojoDescriptor, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        if (mojoDescriptor.getParameters() == null) {
            return;
        }
        mojoDescriptor.getParameters().stream().filter(this::isDeprecated).forEach(this::logParameter);
    }

    private boolean isDeprecated(Parameter parameter) {
        return Objects.equals(ArtifactRepository.class.getName(), parameter.getType()) && DEPRECATED_CORE_PARAMETERS.containsKey(parameter.getDefaultValue());
    }

    static {
        HashMap<String, String> deprecatedCoreParameters = new HashMap<String, String>();
        deprecatedCoreParameters.put("${localRepository}", ARTIFACT_REPOSITORY_REASON);
        deprecatedCoreParameters.put("${session.localRepository}", ARTIFACT_REPOSITORY_REASON);
        DEPRECATED_CORE_PARAMETERS = deprecatedCoreParameters;
    }
}

