/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.form.FormProperty;

class CustomCodeData {
    private CodeCategory defaultCategory = CodeCategory.CREATE_AND_INIT;
    private List<EditableBlock> initEditableBlocks = new ArrayList<EditableBlock>();
    private List<GuardedBlock> initGuardedBlocks = new ArrayList<GuardedBlock>();
    private VariableDeclaration declaration;
    private List<EditableBlock> declarationEditableBlocks = new ArrayList<EditableBlock>();
    private List<GuardedBlock> declarationGuardedBlocks = new ArrayList<GuardedBlock>();
    private int highestPreference;

    CustomCodeData() {
    }

    int getEditableBlockCount(CodeCategory category) {
        return this.getEditableList(category).size();
    }

    EditableBlock getEditableBlock(CodeCategory category, int index) {
        return this.getEditableList(category).get(index);
    }

    int getGuardedBlockCount(CodeCategory category) {
        return this.getGuardedList(category).size();
    }

    GuardedBlock getGuardedBlock(CodeCategory category, int index) {
        return this.getGuardedList(category).get(index);
    }

    VariableDeclaration getDeclarationData() {
        return this.declaration;
    }

    void addEditableBlock(String code, FormProperty targetProperty, int preferenceIndex, String displayName, String hint) {
        this.addEditableBlock(null, code, targetProperty, preferenceIndex, displayName, hint, false, false);
    }

    void addEditableBlock(String code, FormProperty targetProperty, int preferenceIndex, String displayName, String hint, boolean pre, boolean post) {
        this.addEditableBlock(null, code, targetProperty, preferenceIndex, displayName, hint, pre, post);
    }

    void addEditableBlock(CodeCategory category, String code, FormProperty targetProperty, int preferenceIndex, String displayName, String hint, boolean pre, boolean post) {
        List<EditableBlock> editList;
        if (category == null) {
            category = this.defaultCategory;
        }
        if ((editList = this.getEditableList(category)).size() <= this.getGuardedList(category).size()) {
            this.highestPreference = 0;
            editList.add(new EditableBlock());
        }
        EditableBlock eBlock = editList.get(editList.size() - 1);
        eBlock.addEntry(new CodeEntry(code, targetProperty, displayName, hint, pre, post), preferenceIndex > this.highestPreference);
        if (preferenceIndex > this.highestPreference) {
            this.highestPreference = preferenceIndex;
        }
    }

    void addGuardedBlock(String code) {
        this.addGuardedBlock(null, code, null, null, false, null, null, null);
    }

    void addGuardedBlock(String defaultCode, String customCode, String customCodeMark, boolean customized, FormProperty targetProperty, String displayName, String hint) {
        this.addGuardedBlock(null, defaultCode, customCode, customCodeMark, customized, targetProperty, displayName, hint);
    }

    void addGuardedBlock(CodeCategory category, String defaultCode, String customCode, String customCodeMark, boolean customized, FormProperty targetProperty, String displayName, String hint) {
        if (category == null) {
            category = this.defaultCategory;
        }
        assert (this.getGuardedList(category).size() + 1 == this.getEditableList(category).size());
        CodeEntry customEntry = null;
        int guardHeading = 0;
        int guardEnding = 0;
        if (customCode != null) {
            int codeLen = customCode.length();
            int first = customCode.indexOf(customCodeMark);
            int last = customCode.lastIndexOf(customCodeMark);
            if (first > 0 && last < codeLen - 1) {
                int markLen = customCodeMark.length();
                String customizablePart = customCode.substring(first + markLen, last);
                customCode = customCode.substring(0, first) + customizablePart + customCode.substring(last + markLen);
                guardHeading = first;
                guardEnding = codeLen - markLen - last;
                customEntry = new CodeEntry(customized ? customizablePart : null, targetProperty, displayName, hint, false, false);
            } else {
                customCode = null;
            }
        }
        GuardedBlock gBlock = new GuardedBlock(defaultCode, customCode, guardHeading, guardEnding, customized, customEntry);
        this.getGuardedList(category).add(gBlock);
    }

    void setDefaultCategory(CodeCategory category) {
        this.defaultCategory = category;
    }

    void setDeclarationData(boolean local, int modifiers) {
        this.declaration = new VariableDeclaration(local, modifiers);
    }

    private List<EditableBlock> getEditableList(CodeCategory category) {
        switch (category) {
            case CREATE_AND_INIT: {
                return this.initEditableBlocks;
            }
            case DECLARATION: {
                return this.declarationEditableBlocks;
            }
        }
        return null;
    }

    private List<GuardedBlock> getGuardedList(CodeCategory category) {
        switch (category) {
            case CREATE_AND_INIT: {
                return this.initGuardedBlocks;
            }
            case DECLARATION: {
                return this.declarationGuardedBlocks;
            }
        }
        return null;
    }

    void check() {
        this.checkEditableGuardedPairs(this.initEditableBlocks, this.initGuardedBlocks);
        this.checkEditableGuardedPairs(this.declarationEditableBlocks, this.declarationGuardedBlocks);
    }

    private void checkEditableGuardedPairs(List<EditableBlock> eList, List<GuardedBlock> gList) {
        assert (eList.isEmpty() && gList.isEmpty() || eList.size() == gList.size() + 1);
    }

    static class VariableDeclaration {
        boolean local;
        int modifiers;

        private VariableDeclaration(boolean local, int modifiers) {
            this.local = local;
            this.modifiers = modifiers;
        }
    }

    static class GuardedBlock {
        private String defaultCode;
        private String customCode;
        private int headerLength;
        private int footerLength;
        private boolean customCodeSet;
        private CodeEntry customEntry;

        private GuardedBlock(String defaultCode, String customCode, int header, int footer, boolean customSet, CodeEntry customEntry) {
            this.defaultCode = defaultCode;
            this.customCode = customCode;
            this.headerLength = header;
            this.footerLength = footer;
            this.customCodeSet = customSet;
            this.customEntry = customEntry;
        }

        String getDefaultCode() {
            return this.defaultCode;
        }

        String getCustomCode() {
            return this.customCode;
        }

        void setCustomizedCode(String code) {
            this.customEntry.setCode(code);
            if (code != null) {
                this.customCode = this.customCode.substring(0, this.headerLength) + code + this.customCode.substring(this.customCode.length() - this.footerLength);
                this.customCodeSet = true;
            } else {
                this.customCodeSet = false;
            }
        }

        boolean isCustomizable() {
            return this.customCode != null;
        }

        boolean isCustomized() {
            return this.customCodeSet;
        }

        CodeEntry getCustomEntry() {
            return this.customEntry;
        }

        int getHeaderLength() {
            return this.headerLength;
        }

        int getFooterLength() {
            return this.footerLength;
        }
    }

    static class EditableBlock {
        private List<CodeEntry> entries = new ArrayList<CodeEntry>();
        private int prefEntryIndex;

        EditableBlock() {
        }

        private void addEntry(CodeEntry e, boolean preferred) {
            this.entries.add(e);
            if (preferred) {
                this.prefEntryIndex = this.entries.size() - 1;
            }
        }

        int getPreferredEntryIndex() {
            return this.prefEntryIndex;
        }

        CodeEntry[] getEntries() {
            return this.entries.toArray(new CodeEntry[this.entries.size()]);
        }
    }

    static class CodeEntry {
        private String code;
        private FormProperty targetProperty;
        private String displayName;
        private String hint;
        private boolean pre;
        private boolean post;

        private CodeEntry(String code, FormProperty prop, String displayName, String hint, boolean pre, boolean post) {
            assert (!pre && !post || pre != post);
            this.code = code;
            this.targetProperty = prop;
            this.displayName = displayName;
            this.hint = hint;
            this.pre = pre;
            this.post = post;
        }

        String getCode() {
            return this.code;
        }

        void setCode(String code) {
            this.code = code;
        }

        String getName() {
            return this.targetProperty.getName();
        }

        String getDisplayName() {
            return this.displayName;
        }

        String getToolTipText() {
            return this.hint;
        }

        FormProperty getTargetProperty() {
            return this.targetProperty;
        }

        boolean isPropertyPreInit() {
            return this.pre;
        }

        boolean isPropertyPostInit() {
            return this.post;
        }

        public String toString() {
            return this.displayName;
        }
    }

    static enum CodeCategory {
        CREATE_AND_INIT,
        DECLARATION;

    }
}

