/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.db;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataListener;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataProvider;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeItemData;
import org.openide.nodes.Node;

public class DBDecorationProvider
implements TreeDataProvider.Factory {
    private static final String CONNECTED = "is:connected";
    private static final String DISCONNECTED = "is:disconnected";
    private static final Logger LOG = Logger.getLogger(DBDecorationProvider.class.getName());

    @Override
    public TreeDataProvider createProvider(String treeId) {
        LOG.log(Level.FINE, "Creating default DBDecorationProvider for {0}", treeId);
        return new DBDataProvider();
    }

    private static class DBDataProvider
    implements TreeDataProvider {
        private DBDataProvider() {
        }

        @Override
        public TreeItemData createDecorations(Node n, boolean expanded) {
            DatabaseConnection conn = (DatabaseConnection)n.getLookup().lookup(DatabaseConnection.class);
            if (conn != null) {
                String status = conn.getJDBCConnection() != null ? DBDecorationProvider.CONNECTED : DBDecorationProvider.DISCONNECTED;
                TreeItemData data = new TreeItemData();
                data.setContextValues(status);
                return data;
            }
            return null;
        }

        @Override
        public void addTreeItemDataListener(TreeDataListener l) {
        }

        @Override
        public void removeTreeItemDataListener(TreeDataListener l) {
        }

        @Override
        public void nodeReleased(Node n) {
        }
    }
}

