/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.attach;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.debugging.attach.AttachConfigurations;
import org.netbeans.modules.java.lsp.server.debugging.attach.ConfigurationAttribute;
import org.netbeans.modules.java.lsp.server.debugging.attach.ConfigurationAttributes;
import org.netbeans.modules.java.lsp.server.protocol.LaunchConfigurationCompletion;
import org.openide.util.Exceptions;

public class AttachConfigurationCompletion
implements LaunchConfigurationCompletion {
    @Override
    public CompletableFuture<List<CompletionItem>> configurations(Supplier<CompletableFuture<Project>> projectSupplier) {
        return CompletableFuture.supplyAsync(() -> AttachConfigurationCompletion.createCompletion(AttachConfigurations.get()), (Executor)AttachConfigurations.RP);
    }

    @Override
    public CompletableFuture<List<CompletionItem>> attributes(Supplier<CompletableFuture<Project>> projectSupplier, Map<String, Object> currentAttributes) {
        return CompletableFuture.supplyAsync(() -> AttachConfigurationCompletion.createAttributesCompletion(AttachConfigurations.get(), currentAttributes), (Executor)AttachConfigurations.RP);
    }

    @Override
    public CompletableFuture<List<CompletionItem>> attributeValues(Supplier<CompletableFuture<Project>> projectSupplier, Map<String, Object> currentAttributes, String attribute) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private static List<CompletionItem> createCompletion(AttachConfigurations attachConfigurations) {
        return attachConfigurations.getConfigurations().stream().map(configAttrs -> AttachConfigurationCompletion.createCompletion(configAttrs)).collect(Collectors.toList());
    }

    private static CompletionItem createCompletion(ConfigurationAttributes configAttrs) {
        CompletionItem ci = new CompletionItem("Java+: " + configAttrs.getName());
        ci.setKind(CompletionItemKind.Module);
        StringWriter sw = new StringWriter();
        try (JsonWriter w = new JsonWriter((Writer)sw);){
            w.setIndent("\t");
            w.beginObject();
            w.name("name").jsonValue("\"${1:" + Utils.escapeCompletionSnippetSpecialChars(Utils.encode2JSON(configAttrs.getName())) + "}\"");
            w.name("type").value("java+");
            w.name("request").value("attach");
            int locationIndex = 2;
            for (Map.Entry<String, ConfigurationAttribute> entry : configAttrs.getAttributes().entrySet()) {
                ConfigurationAttribute ca = entry.getValue();
                if (!ca.isMustSpecify()) continue;
                String value = ca.getDefaultValue();
                value = value.startsWith("${command:") ? Utils.escapeCompletionSnippetSpecialChars(Utils.encode2JSON(value)) : "${" + locationIndex++ + (value.isEmpty() ? "}" : ":" + Utils.escapeCompletionSnippetSpecialChars(Utils.encode2JSON(value)) + "}");
                w.name(entry.getKey()).jsonValue("\"" + value + "\"");
            }
            w.endObject();
            w.flush();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ci.setInsertText(sw.toString());
        ci.setInsertTextFormat(InsertTextFormat.Snippet);
        ci.setDocumentation(configAttrs.getDescription());
        return ci;
    }

    private static List<CompletionItem> createAttributesCompletion(AttachConfigurations attachConfigurations, Map<String, Object> currentAttributes) {
        ArrayList<CompletionItem> completionItems = null;
        ConfigurationAttributes currentConfiguration = attachConfigurations.findConfiguration(currentAttributes);
        if (currentConfiguration != null) {
            Map<String, ConfigurationAttribute> attributes = currentConfiguration.getAttributes();
            for (Map.Entry<String, ConfigurationAttribute> entry : attributes.entrySet()) {
                String attrName = entry.getKey();
                if (currentAttributes.containsKey(attrName)) continue;
                StringWriter sw = new StringWriter();
                try (JsonWriter w = new JsonWriter((Writer)sw);){
                    w.beginObject();
                    w.name(attrName).value(entry.getValue().getDefaultValue());
                    w.endObject();
                    w.flush();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                CompletionItem ci = new CompletionItem(attrName);
                String text = sw.toString();
                text = text.substring(1, text.length() - 1);
                ci.setInsertText(text);
                ci.setDocumentation(entry.getValue().getDescription());
                if (completionItems == null) {
                    completionItems = new ArrayList<CompletionItem>(3);
                }
                completionItems.add(ci);
            }
        }
        if (completionItems != null) {
            return completionItems;
        }
        return Collections.emptyList();
    }
}

