/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.executable;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.util.FileUtils;

public final class PhpExecutableValidator {
    private PhpExecutableValidator() {
    }

    public static boolean isValidCommand(@NullAllowed String command) {
        return PhpExecutableValidator.validateCommand(command, (String)null) == null;
    }

    public static String validateCommand(@NullAllowed String command, @NullAllowed String executableName) {
        String executable = null;
        if (command != null) {
            executable = (String)PhpExecutable.parseCommand(command).first();
        }
        if (executableName == null) {
            return FileUtils.validateFile((String)executable, (boolean)false);
        }
        return FileUtils.validateFile((String)executableName, (String)executable, (boolean)false);
    }

    public static String validateCommand(@NonNull String command, @NonNull ValidationHandler validationHandler) {
        return validationHandler.validate((String)PhpExecutable.parseCommand(command).first());
    }

    public static interface ValidationHandler {
        public String validate(String var1);
    }
}

